/* sudoku-view.c generated by valac 0.28.0.14-080be, the Vala compiler
 * generated from sudoku-view.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * Copyright © 2014 Parin Porecha
 * Copyright © 2014 Michael Catanzaro
 *
 * This file is part of GNOME Sudoku.
 *
 * GNOME Sudoku is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * GNOME Sudoku is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME Sudoku. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <pango/pango.h>
#include <float.h>
#include <math.h>
#include "libsudoku.h"
#include <gdk/gdk.h>
#include <stdlib.h>
#include <string.h>
#include <cairo.h>
#include <gee.h>
#include <pango/pangocairo.h>
#include <glib/gi18n-lib.h>


#define TYPE_SUDOKU_CELL_VIEW (sudoku_cell_view_get_type ())
#define SUDOKU_CELL_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_CELL_VIEW, SudokuCellView))
#define SUDOKU_CELL_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_CELL_VIEW, SudokuCellViewClass))
#define IS_SUDOKU_CELL_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_CELL_VIEW))
#define IS_SUDOKU_CELL_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_CELL_VIEW))
#define SUDOKU_CELL_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_CELL_VIEW, SudokuCellViewClass))

typedef struct _SudokuCellView SudokuCellView;
typedef struct _SudokuCellViewClass SudokuCellViewClass;
typedef struct _SudokuCellViewPrivate SudokuCellViewPrivate;

#define TYPE_NUMBER_PICKER (number_picker_get_type ())
#define NUMBER_PICKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NUMBER_PICKER, NumberPicker))
#define NUMBER_PICKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NUMBER_PICKER, NumberPickerClass))
#define IS_NUMBER_PICKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NUMBER_PICKER))
#define IS_NUMBER_PICKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NUMBER_PICKER))
#define NUMBER_PICKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NUMBER_PICKER, NumberPickerClass))

typedef struct _NumberPicker NumberPicker;
typedef struct _NumberPickerClass NumberPickerClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_SUDOKU_VIEW (sudoku_view_get_type ())
#define SUDOKU_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_VIEW, SudokuView))
#define SUDOKU_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_VIEW, SudokuViewClass))
#define IS_SUDOKU_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_VIEW))
#define IS_SUDOKU_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_VIEW))
#define SUDOKU_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_VIEW, SudokuViewClass))

typedef struct _SudokuView SudokuView;
typedef struct _SudokuViewClass SudokuViewClass;
typedef struct _SudokuViewPrivate SudokuViewPrivate;
typedef struct _Block5Data Block5Data;
typedef struct _Block6Data Block6Data;

struct _SudokuCellView {
	GtkDrawingArea parent_instance;
	SudokuCellViewPrivate * priv;
};

struct _SudokuCellViewClass {
	GtkDrawingAreaClass parent_class;
};

struct _SudokuCellViewPrivate {
	PangoLayout* layout;
	gdouble size_ratio;
	GtkPopover* popover;
	GtkPopover* earmark_popover;
	SudokuGame* game;
	gint row;
	gint col;
	gboolean _show_possibilities;
	gboolean _show_warnings;
	gboolean _selected;
	GdkRGBA _background_color;
	NumberPicker* number_picker;
	NumberPicker* earmark_picker;
};

struct _SudokuView {
	GtkAspectFrame parent_instance;
	SudokuViewPrivate * priv;
	SudokuGame* game;
};

struct _SudokuViewClass {
	GtkAspectFrameClass parent_class;
};

struct _SudokuViewPrivate {
	SudokuCellView** cells;
	gint cells_length1;
	gint cells_length2;
	gboolean previous_board_broken_state;
	GtkOverlay* overlay;
	GtkDrawingArea* drawing;
	GtkGrid* grid;
	gint selected_row;
	gint selected_col;
	gboolean _show_warnings;
	gboolean _show_possibilities;
	gboolean _highlighter;
};

struct _Block5Data {
	int _ref_count_;
	SudokuView* self;
	SudokuGame* game;
};

struct _Block6Data {
	int _ref_count_;
	Block5Data * _data5_;
	gint cell_row;
	gint cell_col;
};


static gpointer sudoku_cell_view_parent_class = NULL;
static gpointer sudoku_view_parent_class = NULL;

GType sudoku_cell_view_get_type (void) G_GNUC_CONST;
GType number_picker_get_type (void) G_GNUC_CONST;
#define SUDOKU_CELL_VIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SUDOKU_CELL_VIEW, SudokuCellViewPrivate))
enum  {
	SUDOKU_CELL_VIEW_DUMMY_PROPERTY,
	SUDOKU_CELL_VIEW_VALUE,
	SUDOKU_CELL_VIEW_IS_FIXED,
	SUDOKU_CELL_VIEW_SHOW_POSSIBILITIES,
	SUDOKU_CELL_VIEW_SHOW_WARNINGS,
	SUDOKU_CELL_VIEW_SELECTED,
	SUDOKU_CELL_VIEW_BACKGROUND_COLOR
};
SudokuCellView* sudoku_cell_view_new (gint row, gint col, SudokuGame** game);
SudokuCellView* sudoku_cell_view_construct (GType object_type, gint row, gint col, SudokuGame** game);
void sudoku_cell_view_set_value (SudokuCellView* self, gint value);
gboolean sudoku_cell_view_get_is_fixed (SudokuCellView* self);
static gboolean sudoku_cell_view_focus_out_cb (SudokuCellView* self, GtkWidget* widget, GdkEventFocus* event);
static gboolean _sudoku_cell_view_focus_out_cb_gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self);
void sudoku_cell_view_cell_changed_cb (SudokuCellView* self, gint row, gint col, gint old_val, gint new_val);
static void _sudoku_cell_view_cell_changed_cb_sudoku_game_cell_changed (SudokuGame* _sender, gint row, gint col, gint old_val, gint new_val, gpointer self);
static gboolean sudoku_cell_view_real_button_press_event (GtkWidget* base, GdkEventButton* event);
static void sudoku_cell_view_hide_both_popovers (SudokuCellView* self);
static void sudoku_cell_view_show_earmark_picker (SudokuCellView* self);
static void sudoku_cell_view_show_number_picker (SudokuCellView* self);
static void sudoku_cell_view_create_earmark_picker (SudokuCellView* self);
NumberPicker* number_picker_new (SudokuBoard** board, gboolean earmark);
NumberPicker* number_picker_construct (GType object_type, SudokuBoard** board, gboolean earmark);
static void __lambda7_ (SudokuCellView* self, gint number, gboolean state);
gint sudoku_cell_view_get_value (SudokuCellView* self);
static void ___lambda7__number_picker_earmark_state_changed (NumberPicker* _sender, gint number, gboolean active, gpointer self);
void number_picker_set_earmarks (NumberPicker* self, gint row, gint col);
static void __lambda10_ (SudokuCellView* self, NumberPicker* o, gint number);
static void ___lambda10__number_picker_number_picked (NumberPicker* _sender, gint number, gpointer self);
void number_picker_set_clear_button_visibility (NumberPicker* self, gboolean visible);
static void __lambda11_ (SudokuCellView* self);
static void sudoku_cell_view_destroy_popover (SudokuCellView* self, GtkPopover** popover);
static void ___lambda11__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static gboolean __lambda12_ (SudokuCellView* self);
static gboolean ___lambda12__gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self);
static void __lambda8_ (SudokuCellView* self);
static void ___lambda8__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static gboolean __lambda9_ (SudokuCellView* self);
static gboolean ___lambda9__gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self);
static gint sudoku_cell_view_key_map_keypad (SudokuCellView* self, const gchar* key_name);
static gboolean sudoku_cell_view_real_key_press_event (GtkWidget* base, GdkEventKey* event);
gboolean number_picker_set_earmark (NumberPicker* self, gint row, gint col, gint index, gboolean state);
static gboolean sudoku_cell_view_real_draw (GtkWidget* base, cairo_t* c);
void sudoku_cell_view_set_background_color (SudokuCellView* self, GdkRGBA* value);
void sudoku_cell_view_clear (SudokuCellView* self);
gboolean sudoku_cell_view_get_show_possibilities (SudokuCellView* self);
void sudoku_cell_view_set_show_possibilities (SudokuCellView* self, gboolean value);
gboolean sudoku_cell_view_get_show_warnings (SudokuCellView* self);
void sudoku_cell_view_set_show_warnings (SudokuCellView* self, gboolean value);
gboolean sudoku_cell_view_get_selected (SudokuCellView* self);
void sudoku_cell_view_set_selected (SudokuCellView* self, gboolean value);
void sudoku_cell_view_get_background_color (SudokuCellView* self, GdkRGBA* result);
static void sudoku_cell_view_finalize (GObject* obj);
static void _vala_sudoku_cell_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_sudoku_cell_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType sudoku_view_get_type (void) G_GNUC_CONST;
#define SUDOKU_VIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SUDOKU_VIEW, SudokuViewPrivate))
enum  {
	SUDOKU_VIEW_DUMMY_PROPERTY,
	SUDOKU_VIEW_SHOW_WARNINGS,
	SUDOKU_VIEW_SHOW_POSSIBILITIES,
	SUDOKU_VIEW_HIGHLIGHTER
};
static void sudoku_view_set_selected (SudokuView* self, gint cell_row, gint cell_col);
SudokuView* sudoku_view_new (SudokuGame* game);
SudokuView* sudoku_view_construct (GType object_type, SudokuGame* game);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static gboolean sudoku_view_draw_board (SudokuView* self, cairo_t* c);
static gboolean _sudoku_view_draw_board_gtk_widget_draw (GtkWidget* _sender, cairo_t* cr, gpointer self);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static gboolean ________lambda13_ (Block6Data* _data6_);
static gboolean _________lambda13__gtk_widget_focus_in_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self);
static void ________lambda14_ (Block6Data* _data6_, GObject* s, GParamSpec* p);
static void _________lambda14__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
void sudoku_view_clear (SudokuView* self);
gboolean sudoku_view_get_show_warnings (SudokuView* self);
void sudoku_view_set_show_warnings (SudokuView* self, gboolean value);
gboolean sudoku_view_get_show_possibilities (SudokuView* self);
void sudoku_view_set_show_possibilities (SudokuView* self, gboolean value);
gboolean sudoku_view_get_highlighter (SudokuView* self);
void sudoku_view_set_highlighter (SudokuView* self, gboolean value);
static void sudoku_view_finalize (GObject* obj);
static void _vala_sudoku_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_sudoku_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

const GdkRGBA selected_bg_color = {0.7, 0.8, 0.9};
const GdkRGBA fixed_cell_color = {0.8, 0.8, 0.8, (gdouble) 0};
const GdkRGBA free_cell_color = {1.0, 1.0, 1.0, 1.0};
const GdkRGBA highlight_color = {0.93, 0.93, 0.93, (gdouble) 0};

static gpointer _g_object_ref0 (gpointer self) {
#line 108 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	return self ? g_object_ref (self) : NULL;
#line 246 "sudoku-view.c"
}


static gboolean _sudoku_cell_view_focus_out_cb_gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self) {
	gboolean result;
	result = sudoku_cell_view_focus_out_cb ((SudokuCellView*) self, _sender, event);
#line 123 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	return result;
#line 255 "sudoku-view.c"
}


static void _sudoku_cell_view_cell_changed_cb_sudoku_game_cell_changed (SudokuGame* _sender, gint row, gint col, gint old_val, gint new_val, gpointer self) {
#line 124 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	sudoku_cell_view_cell_changed_cb ((SudokuCellView*) self, row, col, old_val, new_val);
#line 262 "sudoku-view.c"
}


SudokuCellView* sudoku_cell_view_construct (GType object_type, gint row, gint col, SudokuGame** game) {
	SudokuCellView * self = NULL;
	SudokuGame* _tmp0_ = NULL;
	SudokuGame* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	GtkStyle* _tmp4_ = NULL;
	GtkStyle* _tmp5_ = NULL;
	PangoFontDescription* _tmp6_ = NULL;
	SudokuGame* _tmp7_ = NULL;
	SudokuBoard* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	gboolean _tmp14_ = FALSE;
	SudokuGame* _tmp17_ = NULL;
#line 106 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_val_if_fail (*game != NULL, NULL);
#line 106 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self = (SudokuCellView*) g_object_new (object_type, NULL);
#line 108 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = *game;
#line 108 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 108 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_g_object_unref0 (self->priv->game);
#line 108 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->game = _tmp1_;
#line 109 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp2_ = row;
#line 109 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->row = _tmp2_;
#line 110 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp3_ = col;
#line 110 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->col = _tmp3_;
#line 112 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp4_ = gtk_widget_get_style ((GtkWidget*) self);
#line 112 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp5_ = _tmp4_;
#line 112 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp6_ = _tmp5_->font_desc;
#line 112 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	pango_font_description_set_size (_tmp6_, PANGO_SCALE * 13);
#line 113 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp7_ = *game;
#line 113 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp8_ = _tmp7_->board;
#line 113 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp9_ = row;
#line 113 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp10_ = col;
#line 113 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp11_ = sudoku_board_get (_tmp8_, _tmp9_, _tmp10_);
#line 113 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	sudoku_cell_view_set_value (self, _tmp11_);
#line 117 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_object_set ((GtkWidget*) self, "can-focus", TRUE, NULL);
#line 118 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_widget_set_events ((GtkWidget*) self, (GDK_EXPOSURE_MASK | GDK_BUTTON_PRESS_MASK) | GDK_KEY_PRESS_MASK);
#line 120 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp13_ = sudoku_cell_view_get_is_fixed (self);
#line 120 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp14_ = _tmp13_;
#line 120 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp14_) {
#line 334 "sudoku-view.c"
		SudokuGame* _tmp15_ = NULL;
		GameMode _tmp16_ = 0;
#line 120 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp15_ = *game;
#line 120 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp16_ = _tmp15_->mode;
#line 120 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp12_ = _tmp16_ == GAME_MODE_PLAY;
#line 343 "sudoku-view.c"
	} else {
#line 120 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp12_ = FALSE;
#line 347 "sudoku-view.c"
	}
#line 120 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp12_) {
#line 121 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		return self;
#line 353 "sudoku-view.c"
	}
#line 123 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_signal_connect_object ((GtkWidget*) self, "focus-out-event", (GCallback) _sudoku_cell_view_focus_out_cb_gtk_widget_focus_out_event, self, 0);
#line 124 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp17_ = *game;
#line 124 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_signal_connect_object (_tmp17_, "cell-changed", (GCallback) _sudoku_cell_view_cell_changed_cb_sudoku_game_cell_changed, self, 0);
#line 106 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	return self;
#line 363 "sudoku-view.c"
}


SudokuCellView* sudoku_cell_view_new (gint row, gint col, SudokuGame** game) {
#line 106 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	return sudoku_cell_view_construct (TYPE_SUDOKU_CELL_VIEW, row, col, game);
#line 370 "sudoku-view.c"
}


static gboolean sudoku_cell_view_real_button_press_event (GtkWidget* base, GdkEventButton* event) {
	SudokuCellView * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GdkEventButton* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	SudokuGame* _tmp8_ = NULL;
	GameMode _tmp9_ = 0;
	gboolean _tmp16_ = FALSE;
	GtkPopover* _tmp17_ = NULL;
	GdkEventButton* _tmp19_ = NULL;
	guint _tmp20_ = 0U;
#line 127 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self = (SudokuCellView*) base;
#line 127 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 129 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp1_ = event;
#line 129 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp2_ = _tmp1_->button;
#line 129 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp2_ != ((guint) 1)) {
#line 399 "sudoku-view.c"
		GdkEventButton* _tmp3_ = NULL;
		guint _tmp4_ = 0U;
#line 129 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp3_ = event;
#line 129 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp4_ = _tmp3_->button;
#line 129 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp0_ = _tmp4_ != ((guint) 3);
#line 408 "sudoku-view.c"
	} else {
#line 129 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp0_ = FALSE;
#line 412 "sudoku-view.c"
	}
#line 129 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp0_) {
#line 130 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		result = FALSE;
#line 130 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		return result;
#line 420 "sudoku-view.c"
	}
#line 132 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_object_get ((GtkWidget*) self, "is-focus", &_tmp5_, NULL);
#line 132 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp6_ = _tmp5_;
#line 132 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (!_tmp6_) {
#line 133 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		gtk_widget_grab_focus ((GtkWidget*) self);
#line 430 "sudoku-view.c"
	}
#line 134 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp8_ = self->priv->game;
#line 134 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp9_ = _tmp8_->mode;
#line 134 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp9_ == GAME_MODE_PLAY) {
#line 438 "sudoku-view.c"
		gboolean _tmp10_ = FALSE;
		gboolean _tmp11_ = FALSE;
		gboolean _tmp12_ = FALSE;
#line 134 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp11_ = sudoku_cell_view_get_is_fixed (self);
#line 134 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp12_ = _tmp11_;
#line 134 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		if (_tmp12_) {
#line 134 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp10_ = TRUE;
#line 450 "sudoku-view.c"
		} else {
			SudokuGame* _tmp13_ = NULL;
			gboolean _tmp14_ = FALSE;
			gboolean _tmp15_ = FALSE;
#line 134 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp13_ = self->priv->game;
#line 134 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp14_ = sudoku_game_get_paused (_tmp13_);
#line 134 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp15_ = _tmp14_;
#line 134 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp10_ = _tmp15_;
#line 463 "sudoku-view.c"
		}
#line 134 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp7_ = _tmp10_;
#line 467 "sudoku-view.c"
	} else {
#line 134 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp7_ = FALSE;
#line 471 "sudoku-view.c"
	}
#line 134 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp7_) {
#line 135 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		result = FALSE;
#line 135 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		return result;
#line 479 "sudoku-view.c"
	}
#line 137 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp17_ = self->priv->popover;
#line 137 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp17_ != NULL) {
#line 137 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp16_ = TRUE;
#line 487 "sudoku-view.c"
	} else {
		GtkPopover* _tmp18_ = NULL;
#line 137 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp18_ = self->priv->earmark_popover;
#line 137 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp16_ = _tmp18_ != NULL;
#line 494 "sudoku-view.c"
	}
#line 137 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp16_) {
#line 139 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		sudoku_cell_view_hide_both_popovers (self);
#line 140 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		result = FALSE;
#line 140 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		return result;
#line 504 "sudoku-view.c"
	}
#line 143 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp19_ = event;
#line 143 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp20_ = _tmp19_->button;
#line 143 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp20_ == ((guint) 1)) {
#line 512 "sudoku-view.c"
		gboolean _tmp21_ = FALSE;
		gboolean _tmp22_ = FALSE;
		gboolean _tmp23_ = FALSE;
#line 145 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp23_ = self->priv->_show_possibilities;
#line 145 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		if (!_tmp23_) {
#line 520 "sudoku-view.c"
			GdkEventButton* _tmp24_ = NULL;
			GdkModifierType _tmp25_ = 0;
#line 145 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp24_ = event;
#line 145 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp25_ = _tmp24_->state;
#line 145 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp22_ = (_tmp25_ & GDK_CONTROL_MASK) > 0;
#line 529 "sudoku-view.c"
		} else {
#line 145 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp22_ = FALSE;
#line 533 "sudoku-view.c"
		}
#line 145 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		if (_tmp22_) {
#line 537 "sudoku-view.c"
			SudokuGame* _tmp26_ = NULL;
			GameMode _tmp27_ = 0;
#line 145 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp26_ = self->priv->game;
#line 145 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp27_ = _tmp26_->mode;
#line 145 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp21_ = _tmp27_ == GAME_MODE_PLAY;
#line 546 "sudoku-view.c"
		} else {
#line 145 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp21_ = FALSE;
#line 550 "sudoku-view.c"
		}
#line 145 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		if (_tmp21_) {
#line 146 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			sudoku_cell_view_show_earmark_picker (self);
#line 556 "sudoku-view.c"
		} else {
#line 148 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			sudoku_cell_view_show_number_picker (self);
#line 560 "sudoku-view.c"
		}
	} else {
		gboolean _tmp28_ = FALSE;
		gboolean _tmp29_ = FALSE;
		gboolean _tmp30_ = FALSE;
#line 150 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp30_ = self->priv->_show_possibilities;
#line 150 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		if (!_tmp30_) {
#line 570 "sudoku-view.c"
			GdkEventButton* _tmp31_ = NULL;
			guint _tmp32_ = 0U;
#line 150 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp31_ = event;
#line 150 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp32_ = _tmp31_->button;
#line 150 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp29_ = _tmp32_ == ((guint) 3);
#line 579 "sudoku-view.c"
		} else {
#line 150 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp29_ = FALSE;
#line 583 "sudoku-view.c"
		}
#line 150 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		if (_tmp29_) {
#line 587 "sudoku-view.c"
			SudokuGame* _tmp33_ = NULL;
			GameMode _tmp34_ = 0;
#line 150 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp33_ = self->priv->game;
#line 150 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp34_ = _tmp33_->mode;
#line 150 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp28_ = _tmp34_ == GAME_MODE_PLAY;
#line 596 "sudoku-view.c"
		} else {
#line 150 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp28_ = FALSE;
#line 600 "sudoku-view.c"
		}
#line 150 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		if (_tmp28_) {
#line 151 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			sudoku_cell_view_show_earmark_picker (self);
#line 606 "sudoku-view.c"
		}
	}
#line 153 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	result = FALSE;
#line 153 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	return result;
#line 613 "sudoku-view.c"
}


static void __lambda7_ (SudokuCellView* self, gint number, gboolean state) {
	gboolean _tmp0_ = FALSE;
	SudokuGame* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	gint _tmp16_ = 0;
	gint _tmp17_ = 0;
#line 160 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = state;
#line 160 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp0_) {
#line 630 "sudoku-view.c"
		SudokuGame* _tmp1_ = NULL;
		SudokuBoard* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
#line 161 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp1_ = self->priv->game;
#line 161 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp2_ = _tmp1_->board;
#line 161 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp3_ = self->priv->row;
#line 161 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp4_ = self->priv->col;
#line 161 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp5_ = number;
#line 161 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		sudoku_board_enable_earmark (_tmp2_, _tmp3_, _tmp4_, _tmp5_);
#line 648 "sudoku-view.c"
	} else {
		SudokuGame* _tmp6_ = NULL;
		SudokuBoard* _tmp7_ = NULL;
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
#line 163 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp6_ = self->priv->game;
#line 163 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp7_ = _tmp6_->board;
#line 163 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp8_ = self->priv->row;
#line 163 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp9_ = self->priv->col;
#line 163 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp10_ = number;
#line 163 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		sudoku_board_disable_earmark (_tmp7_, _tmp8_, _tmp9_, _tmp10_);
#line 667 "sudoku-view.c"
	}
#line 164 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp11_ = self->priv->game;
#line 164 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp12_ = self->priv->row;
#line 164 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp13_ = self->priv->col;
#line 164 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp14_ = sudoku_cell_view_get_value (self);
#line 164 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp15_ = _tmp14_;
#line 164 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp16_ = sudoku_cell_view_get_value (self);
#line 164 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp17_ = _tmp16_;
#line 164 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_signal_emit_by_name (_tmp11_, "cell-changed", _tmp12_, _tmp13_, _tmp15_, _tmp17_);
#line 165 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_widget_queue_draw ((GtkWidget*) self);
#line 687 "sudoku-view.c"
}


static void ___lambda7__number_picker_earmark_state_changed (NumberPicker* _sender, gint number, gboolean active, gpointer self) {
#line 159 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	__lambda7_ ((SudokuCellView*) self, number, active);
#line 694 "sudoku-view.c"
}


static void sudoku_cell_view_create_earmark_picker (SudokuCellView* self) {
	SudokuGame* _tmp0_ = NULL;
	NumberPicker* _tmp1_ = NULL;
	NumberPicker* _tmp2_ = NULL;
	NumberPicker* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
#line 156 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_if_fail (self != NULL);
#line 158 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = self->priv->game;
#line 158 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp1_ = number_picker_new (&_tmp0_->board, TRUE);
#line 158 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_object_ref_sink (_tmp1_);
#line 158 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_g_object_unref0 (self->priv->earmark_picker);
#line 158 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->earmark_picker = _tmp1_;
#line 159 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp2_ = self->priv->earmark_picker;
#line 159 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_signal_connect_object (_tmp2_, "earmark-state-changed", (GCallback) ___lambda7__number_picker_earmark_state_changed, self, 0);
#line 167 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp3_ = self->priv->earmark_picker;
#line 167 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp4_ = self->priv->row;
#line 167 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp5_ = self->priv->col;
#line 167 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	number_picker_set_earmarks (_tmp3_, _tmp4_, _tmp5_);
#line 729 "sudoku-view.c"
}


static void __lambda10_ (SudokuCellView* self, NumberPicker* o, gint number) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	SudokuGame* _tmp2_ = NULL;
	SudokuBoard* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	GtkPopover* _tmp6_ = NULL;
#line 176 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_if_fail (o != NULL);
#line 177 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = number;
#line 177 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	sudoku_cell_view_set_value (self, _tmp0_);
#line 178 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp1_ = number;
#line 178 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp1_ == 0) {
#line 179 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		g_object_notify ((GObject*) self, "value");
#line 753 "sudoku-view.c"
	}
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp2_ = self->priv->game;
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp3_ = _tmp2_->board;
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp4_ = self->priv->row;
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp5_ = self->priv->col;
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	sudoku_board_disable_all_earmarks (_tmp3_, _tmp4_, _tmp5_);
#line 182 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp6_ = self->priv->popover;
#line 182 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_widget_hide ((GtkWidget*) _tmp6_);
#line 769 "sudoku-view.c"
}


static void ___lambda10__number_picker_number_picked (NumberPicker* _sender, gint number, gpointer self) {
#line 176 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	__lambda10_ ((SudokuCellView*) self, _sender, number);
#line 776 "sudoku-view.c"
}


static void __lambda11_ (SudokuCellView* self) {
	GtkPopover* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
#line 191 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = self->priv->popover;
#line 191 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp1_ = gtk_widget_get_visible ((GtkWidget*) _tmp0_);
#line 191 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp2_ = _tmp1_;
#line 191 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (!_tmp2_) {
#line 192 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		sudoku_cell_view_destroy_popover (self, &self->priv->popover);
#line 794 "sudoku-view.c"
	}
}


static void ___lambda11__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 190 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	__lambda11_ ((SudokuCellView*) self);
#line 802 "sudoku-view.c"
}


static gboolean __lambda12_ (SudokuCellView* self) {
	gboolean result = FALSE;
	GtkPopover* _tmp0_ = NULL;
#line 195 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = self->priv->popover;
#line 195 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_widget_hide ((GtkWidget*) _tmp0_);
#line 196 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	result = TRUE;
#line 196 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	return result;
#line 817 "sudoku-view.c"
}


static gboolean ___lambda12__gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self) {
	gboolean result;
	result = __lambda12_ ((SudokuCellView*) self);
#line 194 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	return result;
#line 826 "sudoku-view.c"
}


static void sudoku_cell_view_show_number_picker (SudokuCellView* self) {
	GtkPopover* _tmp0_ = NULL;
	SudokuGame* _tmp2_ = NULL;
	NumberPicker* _tmp3_ = NULL;
	NumberPicker* _tmp4_ = NULL;
	NumberPicker* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	GtkPopover* _tmp8_ = NULL;
	GtkPopover* _tmp9_ = NULL;
	NumberPicker* _tmp10_ = NULL;
	GtkPopover* _tmp11_ = NULL;
	GtkPopover* _tmp12_ = NULL;
	GtkPopover* _tmp13_ = NULL;
	GtkPopover* _tmp14_ = NULL;
	GtkPopover* _tmp15_ = NULL;
#line 170 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_if_fail (self != NULL);
#line 172 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = self->priv->earmark_popover;
#line 172 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp0_ != NULL) {
#line 852 "sudoku-view.c"
		GtkPopover* _tmp1_ = NULL;
#line 173 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp1_ = self->priv->earmark_popover;
#line 173 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		gtk_widget_hide ((GtkWidget*) _tmp1_);
#line 858 "sudoku-view.c"
	}
#line 175 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp2_ = self->priv->game;
#line 175 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp3_ = number_picker_new (&_tmp2_->board, FALSE);
#line 175 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_object_ref_sink (_tmp3_);
#line 175 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_g_object_unref0 (self->priv->number_picker);
#line 175 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->number_picker = _tmp3_;
#line 176 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp4_ = self->priv->number_picker;
#line 176 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_signal_connect_object (_tmp4_, "number-picked", (GCallback) ___lambda10__number_picker_number_picked, self, 0);
#line 184 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp5_ = self->priv->number_picker;
#line 184 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp6_ = sudoku_cell_view_get_value (self);
#line 184 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp7_ = _tmp6_;
#line 184 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	number_picker_set_clear_button_visibility (_tmp5_, _tmp7_ != 0);
#line 186 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp8_ = (GtkPopover*) gtk_popover_new ((GtkWidget*) self);
#line 186 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_object_ref_sink (_tmp8_);
#line 186 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_g_object_unref0 (self->priv->popover);
#line 186 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->popover = _tmp8_;
#line 187 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp9_ = self->priv->popover;
#line 187 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp10_ = self->priv->number_picker;
#line 187 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_container_add ((GtkContainer*) _tmp9_, (GtkWidget*) _tmp10_);
#line 188 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp11_ = self->priv->popover;
#line 188 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_popover_set_modal (_tmp11_, FALSE);
#line 189 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp12_ = self->priv->popover;
#line 189 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_popover_set_position (_tmp12_, GTK_POS_BOTTOM);
#line 190 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp13_ = self->priv->popover;
#line 190 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_signal_connect_object ((GObject*) _tmp13_, "notify::visible", (GCallback) ___lambda11__g_object_notify, self, 0);
#line 194 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp14_ = self->priv->popover;
#line 194 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_signal_connect_object ((GtkWidget*) _tmp14_, "focus-out-event", (GCallback) ___lambda12__gtk_widget_focus_out_event, self, 0);
#line 199 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp15_ = self->priv->popover;
#line 199 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_widget_show ((GtkWidget*) _tmp15_);
#line 916 "sudoku-view.c"
}


static void __lambda8_ (SudokuCellView* self) {
	GtkPopover* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
#line 214 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = self->priv->earmark_popover;
#line 214 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp1_ = gtk_widget_get_visible ((GtkWidget*) _tmp0_);
#line 214 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp2_ = _tmp1_;
#line 214 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (!_tmp2_) {
#line 215 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		sudoku_cell_view_destroy_popover (self, &self->priv->earmark_popover);
#line 934 "sudoku-view.c"
	}
}


static void ___lambda8__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 213 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	__lambda8_ ((SudokuCellView*) self);
#line 942 "sudoku-view.c"
}


static gboolean __lambda9_ (SudokuCellView* self) {
	gboolean result = FALSE;
	GtkPopover* _tmp0_ = NULL;
#line 218 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = self->priv->earmark_popover;
#line 218 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_widget_hide ((GtkWidget*) _tmp0_);
#line 219 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	result = TRUE;
#line 219 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	return result;
#line 957 "sudoku-view.c"
}


static gboolean ___lambda9__gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self) {
	gboolean result;
	result = __lambda9_ ((SudokuCellView*) self);
#line 217 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	return result;
#line 966 "sudoku-view.c"
}


static void sudoku_cell_view_show_earmark_picker (SudokuCellView* self) {
	GtkPopover* _tmp0_ = NULL;
	GtkPopover* _tmp2_ = NULL;
	GtkPopover* _tmp3_ = NULL;
	NumberPicker* _tmp4_ = NULL;
	GtkPopover* _tmp5_ = NULL;
	GtkPopover* _tmp6_ = NULL;
	GtkPopover* _tmp7_ = NULL;
	GtkPopover* _tmp8_ = NULL;
	GtkPopover* _tmp9_ = NULL;
#line 202 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_if_fail (self != NULL);
#line 204 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = self->priv->popover;
#line 204 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp0_ != NULL) {
#line 986 "sudoku-view.c"
		GtkPopover* _tmp1_ = NULL;
#line 205 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp1_ = self->priv->popover;
#line 205 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		gtk_widget_hide ((GtkWidget*) _tmp1_);
#line 992 "sudoku-view.c"
	}
#line 207 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	sudoku_cell_view_create_earmark_picker (self);
#line 209 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp2_ = (GtkPopover*) gtk_popover_new ((GtkWidget*) self);
#line 209 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_object_ref_sink (_tmp2_);
#line 209 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_g_object_unref0 (self->priv->earmark_popover);
#line 209 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->earmark_popover = _tmp2_;
#line 210 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp3_ = self->priv->earmark_popover;
#line 210 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp4_ = self->priv->earmark_picker;
#line 210 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_container_add ((GtkContainer*) _tmp3_, (GtkWidget*) _tmp4_);
#line 211 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp5_ = self->priv->earmark_popover;
#line 211 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_popover_set_modal (_tmp5_, FALSE);
#line 212 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp6_ = self->priv->earmark_popover;
#line 212 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_popover_set_position (_tmp6_, GTK_POS_BOTTOM);
#line 213 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp7_ = self->priv->earmark_popover;
#line 213 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_signal_connect_object ((GObject*) _tmp7_, "notify::visible", (GCallback) ___lambda8__g_object_notify, self, 0);
#line 217 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp8_ = self->priv->earmark_popover;
#line 217 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_signal_connect_object ((GtkWidget*) _tmp8_, "focus-out-event", (GCallback) ___lambda9__gtk_widget_focus_out_event, self, 0);
#line 222 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp9_ = self->priv->earmark_popover;
#line 222 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_widget_show ((GtkWidget*) _tmp9_);
#line 1030 "sudoku-view.c"
}


static void sudoku_cell_view_destroy_popover (SudokuCellView* self, GtkPopover** popover) {
	GtkPopover* _tmp0_ = NULL;
#line 225 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_if_fail (self != NULL);
#line 225 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_if_fail (*popover != NULL);
#line 227 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = *popover;
#line 227 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp0_ != NULL) {
#line 1044 "sudoku-view.c"
		GtkPopover* _tmp1_ = NULL;
#line 229 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp1_ = *popover;
#line 229 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		gtk_widget_destroy ((GtkWidget*) _tmp1_);
#line 230 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_g_object_unref0 (*popover);
#line 230 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		*popover = NULL;
#line 1054 "sudoku-view.c"
	}
}


static void sudoku_cell_view_hide_both_popovers (SudokuCellView* self) {
	GtkPopover* _tmp0_ = NULL;
	GtkPopover* _tmp2_ = NULL;
#line 234 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_if_fail (self != NULL);
#line 236 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = self->priv->popover;
#line 236 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp0_ != NULL) {
#line 1068 "sudoku-view.c"
		GtkPopover* _tmp1_ = NULL;
#line 237 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp1_ = self->priv->popover;
#line 237 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		gtk_widget_hide ((GtkWidget*) _tmp1_);
#line 1074 "sudoku-view.c"
	}
#line 238 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp2_ = self->priv->earmark_popover;
#line 238 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp2_ != NULL) {
#line 1080 "sudoku-view.c"
		GtkPopover* _tmp3_ = NULL;
#line 239 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp3_ = self->priv->earmark_popover;
#line 239 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		gtk_widget_hide ((GtkWidget*) _tmp3_);
#line 1086 "sudoku-view.c"
	}
}


static gboolean sudoku_cell_view_focus_out_cb (SudokuCellView* self, GtkWidget* widget, GdkEventFocus* event) {
	gboolean result = FALSE;
#line 242 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 242 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_val_if_fail (widget != NULL, FALSE);
#line 242 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 244 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	sudoku_cell_view_hide_both_popovers (self);
#line 245 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	result = FALSE;
#line 245 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	return result;
#line 1105 "sudoku-view.c"
}


static gint sudoku_cell_view_key_map_keypad (SudokuCellView* self, const gchar* key_name) {
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
#line 249 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 249 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_val_if_fail (key_name != NULL, 0);
#line 252 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp1_ = key_name;
#line 252 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (g_strcmp0 (_tmp1_, "KP_0") == 0) {
#line 252 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp0_ = TRUE;
#line 1132 "sudoku-view.c"
	} else {
		const gchar* _tmp2_ = NULL;
#line 252 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp2_ = key_name;
#line 252 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp0_ = g_strcmp0 (_tmp2_, "0") == 0;
#line 1139 "sudoku-view.c"
	}
#line 252 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp0_) {
#line 253 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		result = 0;
#line 253 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		return result;
#line 1147 "sudoku-view.c"
	}
#line 254 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp3_ = key_name;
#line 254 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (g_strcmp0 (_tmp3_, "KP_1") == 0) {
#line 255 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		result = 1;
#line 255 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		return result;
#line 1157 "sudoku-view.c"
	}
#line 256 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp4_ = key_name;
#line 256 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (g_strcmp0 (_tmp4_, "KP_2") == 0) {
#line 257 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		result = 2;
#line 257 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		return result;
#line 1167 "sudoku-view.c"
	}
#line 258 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp5_ = key_name;
#line 258 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (g_strcmp0 (_tmp5_, "KP_3") == 0) {
#line 259 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		result = 3;
#line 259 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		return result;
#line 1177 "sudoku-view.c"
	}
#line 260 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp6_ = key_name;
#line 260 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (g_strcmp0 (_tmp6_, "KP_4") == 0) {
#line 261 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		result = 4;
#line 261 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		return result;
#line 1187 "sudoku-view.c"
	}
#line 262 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp7_ = key_name;
#line 262 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (g_strcmp0 (_tmp7_, "KP_5") == 0) {
#line 263 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		result = 5;
#line 263 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		return result;
#line 1197 "sudoku-view.c"
	}
#line 264 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp8_ = key_name;
#line 264 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (g_strcmp0 (_tmp8_, "KP_6") == 0) {
#line 265 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		result = 6;
#line 265 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		return result;
#line 1207 "sudoku-view.c"
	}
#line 266 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp9_ = key_name;
#line 266 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (g_strcmp0 (_tmp9_, "KP_7") == 0) {
#line 267 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		result = 7;
#line 267 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		return result;
#line 1217 "sudoku-view.c"
	}
#line 268 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp10_ = key_name;
#line 268 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (g_strcmp0 (_tmp10_, "KP_8") == 0) {
#line 269 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		result = 8;
#line 269 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		return result;
#line 1227 "sudoku-view.c"
	}
#line 270 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp11_ = key_name;
#line 270 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (g_strcmp0 (_tmp11_, "KP_9") == 0) {
#line 271 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		result = 9;
#line 271 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		return result;
#line 1237 "sudoku-view.c"
	}
#line 272 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	result = -1;
#line 272 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	return result;
#line 1243 "sudoku-view.c"
}


static gboolean sudoku_cell_view_real_key_press_event (GtkWidget* base, GdkEventKey* event) {
	SudokuCellView * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	SudokuGame* _tmp1_ = NULL;
	GameMode _tmp2_ = 0;
	gchar* k_name = NULL;
	GdkEventKey* _tmp9_ = NULL;
	guint _tmp10_ = 0U;
	const gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gint k_no = 0;
	const gchar* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	gboolean _tmp18_ = FALSE;
	gint _tmp19_ = 0;
	gboolean _tmp55_ = FALSE;
	gboolean _tmp56_ = FALSE;
	gint _tmp57_ = 0;
	gboolean _tmp60_ = FALSE;
	gboolean _tmp61_ = FALSE;
	const gchar* _tmp62_ = NULL;
	const gchar* _tmp67_ = NULL;
#line 275 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self = (SudokuCellView*) base;
#line 275 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 277 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp1_ = self->priv->game;
#line 277 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp2_ = _tmp1_->mode;
#line 277 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp2_ == GAME_MODE_PLAY) {
#line 1281 "sudoku-view.c"
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_ = FALSE;
#line 277 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp4_ = sudoku_cell_view_get_is_fixed (self);
#line 277 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp5_ = _tmp4_;
#line 277 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		if (_tmp5_) {
#line 277 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp3_ = TRUE;
#line 1293 "sudoku-view.c"
		} else {
			SudokuGame* _tmp6_ = NULL;
			gboolean _tmp7_ = FALSE;
			gboolean _tmp8_ = FALSE;
#line 277 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp6_ = self->priv->game;
#line 277 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp7_ = sudoku_game_get_paused (_tmp6_);
#line 277 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp8_ = _tmp7_;
#line 277 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp3_ = _tmp8_;
#line 1306 "sudoku-view.c"
		}
#line 277 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp0_ = _tmp3_;
#line 1310 "sudoku-view.c"
	} else {
#line 277 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp0_ = FALSE;
#line 1314 "sudoku-view.c"
	}
#line 277 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp0_) {
#line 278 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		result = FALSE;
#line 278 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		return result;
#line 1322 "sudoku-view.c"
	}
#line 279 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp9_ = event;
#line 279 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp10_ = _tmp9_->keyval;
#line 279 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp11_ = gdk_keyval_name (_tmp10_);
#line 279 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp12_ = g_strdup (_tmp11_);
#line 279 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	k_name = _tmp12_;
#line 280 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp13_ = k_name;
#line 280 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp14_ = atoi (_tmp13_);
#line 280 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	k_no = _tmp14_;
#line 282 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp15_ = k_no;
#line 282 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp15_ == 0) {
#line 1344 "sudoku-view.c"
		const gchar* _tmp16_ = NULL;
		gint _tmp17_ = 0;
#line 283 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp16_ = k_name;
#line 283 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp17_ = sudoku_cell_view_key_map_keypad (self, _tmp16_);
#line 283 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		k_no = _tmp17_;
#line 1353 "sudoku-view.c"
	}
#line 284 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp19_ = k_no;
#line 284 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp19_ >= 1) {
#line 1359 "sudoku-view.c"
		gint _tmp20_ = 0;
#line 284 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp20_ = k_no;
#line 284 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp18_ = _tmp20_ <= 9;
#line 1365 "sudoku-view.c"
	} else {
#line 284 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp18_ = FALSE;
#line 1369 "sudoku-view.c"
	}
#line 284 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp18_) {
#line 1373 "sudoku-view.c"
		gboolean _tmp21_ = FALSE;
		GdkEventKey* _tmp22_ = NULL;
		GdkModifierType _tmp23_ = 0;
#line 286 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp22_ = event;
#line 286 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp23_ = _tmp22_->state;
#line 286 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		if ((_tmp23_ & GDK_CONTROL_MASK) > 0) {
#line 1383 "sudoku-view.c"
			SudokuGame* _tmp24_ = NULL;
			GameMode _tmp25_ = 0;
#line 286 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp24_ = self->priv->game;
#line 286 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp25_ = _tmp24_->mode;
#line 286 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp21_ = _tmp25_ == GAME_MODE_PLAY;
#line 1392 "sudoku-view.c"
		} else {
#line 286 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp21_ = FALSE;
#line 1396 "sudoku-view.c"
		}
#line 286 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		if (_tmp21_) {
#line 1400 "sudoku-view.c"
			gboolean new_state = FALSE;
			SudokuGame* _tmp26_ = NULL;
			SudokuBoard* _tmp27_ = NULL;
			gint _tmp28_ = 0;
			gint _tmp29_ = 0;
			gint _tmp30_ = 0;
			gboolean _tmp31_ = FALSE;
			NumberPicker* _tmp32_ = NULL;
			NumberPicker* _tmp33_ = NULL;
			gint _tmp34_ = 0;
			gint _tmp35_ = 0;
			gint _tmp36_ = 0;
			gboolean _tmp37_ = FALSE;
			gboolean _tmp38_ = FALSE;
#line 288 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp26_ = self->priv->game;
#line 288 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp27_ = _tmp26_->board;
#line 288 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp28_ = self->priv->row;
#line 288 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp29_ = self->priv->col;
#line 288 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp30_ = k_no;
#line 288 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp31_ = sudoku_board_is_earmark_enabled (_tmp27_, _tmp28_, _tmp29_, _tmp30_);
#line 288 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			new_state = !_tmp31_;
#line 289 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp32_ = self->priv->earmark_picker;
#line 289 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			if (_tmp32_ == NULL) {
#line 290 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				sudoku_cell_view_create_earmark_picker (self);
#line 1435 "sudoku-view.c"
			}
#line 291 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp33_ = self->priv->earmark_picker;
#line 291 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp34_ = self->priv->row;
#line 291 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp35_ = self->priv->col;
#line 291 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp36_ = k_no;
#line 291 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp37_ = new_state;
#line 291 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp38_ = number_picker_set_earmark (_tmp33_, _tmp34_, _tmp35_, _tmp36_ - 1, _tmp37_);
#line 291 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			if (_tmp38_) {
#line 1451 "sudoku-view.c"
				gboolean _tmp39_ = FALSE;
#line 293 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp39_ = new_state;
#line 293 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				if (_tmp39_) {
#line 1457 "sudoku-view.c"
					SudokuGame* _tmp40_ = NULL;
					SudokuBoard* _tmp41_ = NULL;
					gint _tmp42_ = 0;
					gint _tmp43_ = 0;
					gint _tmp44_ = 0;
#line 294 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp40_ = self->priv->game;
#line 294 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp41_ = _tmp40_->board;
#line 294 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp42_ = self->priv->row;
#line 294 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp43_ = self->priv->col;
#line 294 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp44_ = k_no;
#line 294 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					sudoku_board_enable_earmark (_tmp41_, _tmp42_, _tmp43_, _tmp44_);
#line 1475 "sudoku-view.c"
				} else {
					SudokuGame* _tmp45_ = NULL;
					SudokuBoard* _tmp46_ = NULL;
					gint _tmp47_ = 0;
					gint _tmp48_ = 0;
					gint _tmp49_ = 0;
#line 296 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp45_ = self->priv->game;
#line 296 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp46_ = _tmp45_->board;
#line 296 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp47_ = self->priv->row;
#line 296 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp48_ = self->priv->col;
#line 296 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp49_ = k_no;
#line 296 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					sudoku_board_disable_earmark (_tmp46_, _tmp47_, _tmp48_, _tmp49_);
#line 1494 "sudoku-view.c"
				}
#line 297 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				gtk_widget_queue_draw ((GtkWidget*) self);
#line 1498 "sudoku-view.c"
			}
		} else {
			gint _tmp50_ = 0;
			SudokuGame* _tmp51_ = NULL;
			SudokuBoard* _tmp52_ = NULL;
			gint _tmp53_ = 0;
			gint _tmp54_ = 0;
#line 302 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp50_ = k_no;
#line 302 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			sudoku_cell_view_set_value (self, _tmp50_);
#line 303 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp51_ = self->priv->game;
#line 303 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp52_ = _tmp51_->board;
#line 303 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp53_ = self->priv->row;
#line 303 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp54_ = self->priv->col;
#line 303 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			sudoku_board_disable_all_earmarks (_tmp52_, _tmp53_, _tmp54_);
#line 1520 "sudoku-view.c"
		}
#line 305 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		result = TRUE;
#line 305 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_g_free0 (k_name);
#line 305 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		return result;
#line 1528 "sudoku-view.c"
	}
#line 307 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp57_ = k_no;
#line 307 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp57_ == 0) {
#line 307 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp56_ = TRUE;
#line 1536 "sudoku-view.c"
	} else {
		const gchar* _tmp58_ = NULL;
#line 307 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp58_ = k_name;
#line 307 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp56_ = g_strcmp0 (_tmp58_, "BackSpace") == 0;
#line 1543 "sudoku-view.c"
	}
#line 307 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp56_) {
#line 307 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp55_ = TRUE;
#line 1549 "sudoku-view.c"
	} else {
		const gchar* _tmp59_ = NULL;
#line 307 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp59_ = k_name;
#line 307 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp55_ = g_strcmp0 (_tmp59_, "Delete") == 0;
#line 1556 "sudoku-view.c"
	}
#line 307 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp55_) {
#line 309 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		sudoku_cell_view_set_value (self, 0);
#line 310 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		g_object_notify ((GObject*) self, "value");
#line 311 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		result = TRUE;
#line 311 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_g_free0 (k_name);
#line 311 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		return result;
#line 1570 "sudoku-view.c"
	}
#line 314 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp62_ = k_name;
#line 314 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (g_strcmp0 (_tmp62_, "space") == 0) {
#line 314 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp61_ = TRUE;
#line 1578 "sudoku-view.c"
	} else {
		const gchar* _tmp63_ = NULL;
#line 314 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp63_ = k_name;
#line 314 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp61_ = g_strcmp0 (_tmp63_, "Return") == 0;
#line 1585 "sudoku-view.c"
	}
#line 314 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp61_) {
#line 314 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp60_ = TRUE;
#line 1591 "sudoku-view.c"
	} else {
		const gchar* _tmp64_ = NULL;
#line 314 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp64_ = k_name;
#line 314 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp60_ = g_strcmp0 (_tmp64_, "KP_Enter") == 0;
#line 1598 "sudoku-view.c"
	}
#line 314 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp60_) {
#line 1602 "sudoku-view.c"
		GtkPopover* _tmp65_ = NULL;
#line 316 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp65_ = self->priv->popover;
#line 316 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		if (_tmp65_ != NULL) {
#line 1608 "sudoku-view.c"
			GtkPopover* _tmp66_ = NULL;
#line 318 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp66_ = self->priv->popover;
#line 318 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			gtk_widget_hide ((GtkWidget*) _tmp66_);
#line 319 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			result = FALSE;
#line 319 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_g_free0 (k_name);
#line 319 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			return result;
#line 1620 "sudoku-view.c"
		}
#line 321 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		sudoku_cell_view_show_number_picker (self);
#line 322 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		result = TRUE;
#line 322 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_g_free0 (k_name);
#line 322 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		return result;
#line 1630 "sudoku-view.c"
	}
#line 325 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp67_ = k_name;
#line 325 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (g_strcmp0 (_tmp67_, "Escape") == 0) {
#line 327 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		sudoku_cell_view_hide_both_popovers (self);
#line 328 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		result = TRUE;
#line 328 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_g_free0 (k_name);
#line 328 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		return result;
#line 1644 "sudoku-view.c"
	}
#line 331 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	result = FALSE;
#line 331 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_g_free0 (k_name);
#line 331 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	return result;
#line 1652 "sudoku-view.c"
}


static gboolean sudoku_cell_view_real_draw (GtkWidget* base, cairo_t* c) {
	SudokuCellView * self;
	gboolean result = FALSE;
	gint glyph_width = 0;
	gint glyph_height = 0;
	PangoLayout* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	SudokuGame* _tmp16_ = NULL;
	gboolean _tmp17_ = FALSE;
	gboolean _tmp18_ = FALSE;
	gint _tmp19_ = 0;
	gint _tmp20_ = 0;
	gboolean _tmp42_ = FALSE;
	gboolean _tmp43_ = FALSE;
	gboolean _tmp44_ = FALSE;
	gboolean _tmp47_ = FALSE;
	gboolean _tmp113_ = FALSE;
	gboolean _tmp114_ = FALSE;
#line 334 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self = (SudokuCellView*) base;
#line 334 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_val_if_fail (c != NULL, FALSE);
#line 337 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = self->priv->layout;
#line 337 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	pango_layout_get_pixel_size (_tmp0_, &_tmp1_, &_tmp2_);
#line 337 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	glyph_width = _tmp1_;
#line 337 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	glyph_height = _tmp2_;
#line 338 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp4_ = self->priv->_show_warnings;
#line 338 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp4_) {
#line 1693 "sudoku-view.c"
		SudokuGame* _tmp5_ = NULL;
		SudokuBoard* _tmp6_ = NULL;
		GeeSet* _tmp7_ = NULL;
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
		Coord _tmp10_ = {0};
		gboolean _tmp11_ = FALSE;
#line 338 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp5_ = self->priv->game;
#line 338 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp6_ = _tmp5_->board;
#line 338 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp7_ = _tmp6_->broken_coords;
#line 338 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp8_ = self->priv->row;
#line 338 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp9_ = self->priv->col;
#line 338 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		coord_init (&_tmp10_, _tmp8_, _tmp9_);
#line 338 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp11_ = gee_collection_contains ((GeeCollection*) _tmp7_, &_tmp10_);
#line 338 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp3_ = _tmp11_;
#line 1717 "sudoku-view.c"
	} else {
#line 338 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp3_ = FALSE;
#line 1721 "sudoku-view.c"
	}
#line 338 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp3_) {
#line 1725 "sudoku-view.c"
		cairo_t* _tmp12_ = NULL;
#line 339 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp12_ = c;
#line 339 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		cairo_set_source_rgb (_tmp12_, 1.0, 0.0, 0.0);
#line 1731 "sudoku-view.c"
	} else {
		gboolean _tmp13_ = FALSE;
#line 340 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp13_ = self->priv->_selected;
#line 340 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		if (_tmp13_) {
#line 1738 "sudoku-view.c"
			cairo_t* _tmp14_ = NULL;
#line 341 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp14_ = c;
#line 341 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			cairo_set_source_rgb (_tmp14_, 0.2, 0.2, 0.2);
#line 1744 "sudoku-view.c"
		} else {
			cairo_t* _tmp15_ = NULL;
#line 343 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp15_ = c;
#line 343 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			cairo_set_source_rgb (_tmp15_, 0.0, 0.0, 0.0);
#line 1751 "sudoku-view.c"
		}
	}
#line 345 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp16_ = self->priv->game;
#line 345 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp17_ = sudoku_game_get_paused (_tmp16_);
#line 345 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp18_ = _tmp17_;
#line 345 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp18_) {
#line 346 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		result = FALSE;
#line 346 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		return result;
#line 1766 "sudoku-view.c"
	}
#line 348 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp19_ = sudoku_cell_view_get_value (self);
#line 348 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp20_ = _tmp19_;
#line 348 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp20_ != 0) {
#line 1774 "sudoku-view.c"
		gint width = 0;
		gint height = 0;
		PangoLayout* _tmp21_ = NULL;
		gint _tmp22_ = 0;
		gint _tmp23_ = 0;
		gint _tmp24_ = 0;
		gdouble scale = 0.0;
		gint _tmp25_ = 0;
		gdouble _tmp26_ = 0.0;
		gint _tmp27_ = 0;
		cairo_t* _tmp28_ = NULL;
		gint _tmp29_ = 0;
		gint _tmp30_ = 0;
		gdouble _tmp31_ = 0.0;
		gint _tmp32_ = 0;
		gint _tmp33_ = 0;
		gdouble _tmp34_ = 0.0;
		cairo_t* _tmp35_ = NULL;
		cairo_t* _tmp36_ = NULL;
		gdouble _tmp37_ = 0.0;
		gdouble _tmp38_ = 0.0;
		cairo_t* _tmp39_ = NULL;
		PangoLayout* _tmp40_ = NULL;
		cairo_t* _tmp41_ = NULL;
#line 351 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp21_ = self->priv->layout;
#line 351 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		pango_layout_get_size (_tmp21_, &_tmp22_, &_tmp23_);
#line 351 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		width = _tmp22_;
#line 351 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		height = _tmp23_;
#line 352 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp24_ = height;
#line 352 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		height = _tmp24_ / PANGO_SCALE;
#line 354 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp25_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
#line 354 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp26_ = self->priv->size_ratio;
#line 354 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp27_ = height;
#line 354 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		scale = (((gdouble) _tmp25_) / _tmp26_) / _tmp27_;
#line 355 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp28_ = c;
#line 355 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp29_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
#line 355 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp30_ = glyph_width;
#line 355 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp31_ = scale;
#line 355 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp32_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
#line 355 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp33_ = glyph_height;
#line 355 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp34_ = scale;
#line 355 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		cairo_move_to (_tmp28_, (_tmp29_ - (_tmp30_ * _tmp31_)) / 2, (_tmp32_ - (_tmp33_ * _tmp34_)) / 2);
#line 356 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp35_ = c;
#line 356 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		cairo_save (_tmp35_);
#line 357 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp36_ = c;
#line 357 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp37_ = scale;
#line 357 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp38_ = scale;
#line 357 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		cairo_scale (_tmp36_, _tmp37_, _tmp38_);
#line 358 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp39_ = c;
#line 358 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp40_ = self->priv->layout;
#line 358 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		pango_cairo_show_layout (_tmp39_, _tmp40_);
#line 359 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp41_ = c;
#line 359 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		cairo_restore (_tmp41_);
#line 1857 "sudoku-view.c"
	}
#line 362 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp43_ = sudoku_cell_view_get_is_fixed (self);
#line 362 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp44_ = _tmp43_;
#line 362 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp44_) {
#line 1865 "sudoku-view.c"
		SudokuGame* _tmp45_ = NULL;
		GameMode _tmp46_ = 0;
#line 362 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp45_ = self->priv->game;
#line 362 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp46_ = _tmp45_->mode;
#line 362 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp42_ = _tmp46_ == GAME_MODE_PLAY;
#line 1874 "sudoku-view.c"
	} else {
#line 362 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp42_ = FALSE;
#line 1878 "sudoku-view.c"
	}
#line 362 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp42_) {
#line 363 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		result = FALSE;
#line 363 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		return result;
#line 1886 "sudoku-view.c"
	}
#line 365 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp47_ = self->priv->_show_possibilities;
#line 365 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (!_tmp47_) {
#line 1892 "sudoku-view.c"
		gdouble earmark_size = 0.0;
		gint _tmp48_ = 0;
		gdouble _tmp49_ = 0.0;
		cairo_t* _tmp50_ = NULL;
		gdouble _tmp51_ = 0.0;
		cairo_t* _tmp52_ = NULL;
		gdouble _tmp53_ = 0.0;
		cairo_t* _tmp54_ = NULL;
		cairo_t* _tmp55_ = NULL;
		SudokuGame* _tmp56_ = NULL;
		SudokuBoard* _tmp57_ = NULL;
		gint _tmp58_ = 0;
		gint _tmp59_ = 0;
		gchar* _tmp60_ = NULL;
		gchar* _tmp61_ = NULL;
#line 368 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp48_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
#line 368 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp49_ = self->priv->size_ratio;
#line 368 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		earmark_size = _tmp48_ / (_tmp49_ * 2);
#line 369 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp50_ = c;
#line 369 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp51_ = earmark_size;
#line 369 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		cairo_set_font_size (_tmp50_, _tmp51_);
#line 371 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp52_ = c;
#line 371 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp53_ = earmark_size;
#line 371 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		cairo_move_to (_tmp52_, (gdouble) 0, _tmp53_);
#line 373 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp54_ = c;
#line 373 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		cairo_set_source_rgb (_tmp54_, 0.0, 0.0, 0.0);
#line 374 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp55_ = c;
#line 374 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp56_ = self->priv->game;
#line 374 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp57_ = _tmp56_->board;
#line 374 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp58_ = self->priv->row;
#line 374 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp59_ = self->priv->col;
#line 374 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp60_ = sudoku_board_get_earmarks_string (_tmp57_, _tmp58_, _tmp59_);
#line 374 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp61_ = _tmp60_;
#line 374 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		cairo_show_text (_tmp55_, _tmp61_);
#line 374 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_g_free0 (_tmp61_);
#line 1948 "sudoku-view.c"
	} else {
		gint _tmp62_ = 0;
		gint _tmp63_ = 0;
#line 376 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp62_ = sudoku_cell_view_get_value (self);
#line 376 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp63_ = _tmp62_;
#line 376 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		if (_tmp63_ == 0) {
#line 1958 "sudoku-view.c"
			gdouble possibility_size = 0.0;
			gint _tmp64_ = 0;
			gdouble _tmp65_ = 0.0;
			cairo_t* _tmp66_ = NULL;
			gdouble _tmp67_ = 0.0;
			cairo_t* _tmp68_ = NULL;
			gboolean* possibilities = NULL;
			SudokuGame* _tmp69_ = NULL;
			SudokuBoard* _tmp70_ = NULL;
			gint _tmp71_ = 0;
			gint _tmp72_ = 0;
			gint _tmp73_ = 0;
			gboolean* _tmp74_ = NULL;
			gint possibilities_length1 = 0;
			gint _possibilities_size_ = 0;
			gint height = 0;
			gint _tmp75_ = 0;
			SudokuGame* _tmp76_ = NULL;
			SudokuBoard* _tmp77_ = NULL;
			gint _tmp78_ = 0;
			gint _tmp79_ = 0;
			gint width = 0;
			gint _tmp80_ = 0;
			SudokuGame* _tmp81_ = NULL;
			SudokuBoard* _tmp82_ = NULL;
			gint _tmp83_ = 0;
			gint _tmp84_ = 0;
			gint num = 0;
#line 378 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp64_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
#line 378 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp65_ = self->priv->size_ratio;
#line 378 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			possibility_size = _tmp64_ / (_tmp65_ * 2);
#line 379 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp66_ = c;
#line 379 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp67_ = possibility_size;
#line 379 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			cairo_set_font_size (_tmp66_, _tmp67_);
#line 380 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp68_ = c;
#line 380 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			cairo_set_source_rgb (_tmp68_, 0.0, 0.0, 0.0);
#line 382 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp69_ = self->priv->game;
#line 382 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp70_ = _tmp69_->board;
#line 382 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp71_ = self->priv->row;
#line 382 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp72_ = self->priv->col;
#line 382 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp74_ = sudoku_board_get_possibilities_as_bool_array (_tmp70_, _tmp71_, _tmp72_, &_tmp73_);
#line 382 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			possibilities = _tmp74_;
#line 382 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			possibilities_length1 = _tmp73_;
#line 382 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_possibilities_size_ = possibilities_length1;
#line 384 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp75_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
#line 384 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp76_ = self->priv->game;
#line 384 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp77_ = _tmp76_->board;
#line 384 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp78_ = sudoku_board_get_block_cols (_tmp77_);
#line 384 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp79_ = _tmp78_;
#line 384 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			height = _tmp75_ / _tmp79_;
#line 385 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp80_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
#line 385 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp81_ = self->priv->game;
#line 385 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp82_ = _tmp81_->board;
#line 385 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp83_ = sudoku_board_get_block_rows (_tmp82_);
#line 385 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp84_ = _tmp83_;
#line 385 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			width = _tmp80_ / _tmp84_;
#line 387 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			num = 0;
#line 2045 "sudoku-view.c"
			{
				gint row_tmp = 0;
#line 388 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				row_tmp = 0;
#line 2050 "sudoku-view.c"
				{
					gboolean _tmp85_ = FALSE;
#line 388 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp85_ = TRUE;
#line 388 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					while (TRUE) {
#line 2057 "sudoku-view.c"
						gint _tmp87_ = 0;
						SudokuGame* _tmp88_ = NULL;
						SudokuBoard* _tmp89_ = NULL;
						gint _tmp90_ = 0;
						gint _tmp91_ = 0;
#line 388 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						if (!_tmp85_) {
#line 2065 "sudoku-view.c"
							gint _tmp86_ = 0;
#line 388 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp86_ = row_tmp;
#line 388 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							row_tmp = _tmp86_ + 1;
#line 2071 "sudoku-view.c"
						}
#line 388 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						_tmp85_ = FALSE;
#line 388 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						_tmp87_ = row_tmp;
#line 388 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						_tmp88_ = self->priv->game;
#line 388 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						_tmp89_ = _tmp88_->board;
#line 388 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						_tmp90_ = sudoku_board_get_block_rows (_tmp89_);
#line 388 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						_tmp91_ = _tmp90_;
#line 388 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						if (!(_tmp87_ < _tmp91_)) {
#line 388 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							break;
#line 2089 "sudoku-view.c"
						}
						{
							gint col_tmp = 0;
#line 390 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							col_tmp = 0;
#line 2095 "sudoku-view.c"
							{
								gboolean _tmp92_ = FALSE;
#line 390 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
								_tmp92_ = TRUE;
#line 390 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
								while (TRUE) {
#line 2102 "sudoku-view.c"
									gint _tmp94_ = 0;
									SudokuGame* _tmp95_ = NULL;
									SudokuBoard* _tmp96_ = NULL;
									gint _tmp97_ = 0;
									gint _tmp98_ = 0;
									gint _tmp99_ = 0;
									gboolean* _tmp100_ = NULL;
									gint _tmp100__length1 = 0;
									gint _tmp101_ = 0;
									gboolean _tmp102_ = FALSE;
#line 390 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
									if (!_tmp92_) {
#line 2115 "sudoku-view.c"
										gint _tmp93_ = 0;
#line 390 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
										_tmp93_ = col_tmp;
#line 390 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
										col_tmp = _tmp93_ + 1;
#line 2121 "sudoku-view.c"
									}
#line 390 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
									_tmp92_ = FALSE;
#line 390 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
									_tmp94_ = col_tmp;
#line 390 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
									_tmp95_ = self->priv->game;
#line 390 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
									_tmp96_ = _tmp95_->board;
#line 390 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
									_tmp97_ = sudoku_board_get_block_cols (_tmp96_);
#line 390 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
									_tmp98_ = _tmp97_;
#line 390 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
									if (!(_tmp94_ < _tmp98_)) {
#line 390 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
										break;
#line 2139 "sudoku-view.c"
									}
#line 392 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
									_tmp99_ = num;
#line 392 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
									num = _tmp99_ + 1;
#line 394 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
									_tmp100_ = possibilities;
#line 394 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
									_tmp100__length1 = possibilities_length1;
#line 394 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
									_tmp101_ = num;
#line 394 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
									_tmp102_ = _tmp100_[_tmp101_ - 1];
#line 394 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
									if (_tmp102_) {
#line 2155 "sudoku-view.c"
										cairo_t* _tmp103_ = NULL;
										gint _tmp104_ = 0;
										gint _tmp105_ = 0;
										gint _tmp106_ = 0;
										gint _tmp107_ = 0;
										gdouble _tmp108_ = 0.0;
										cairo_t* _tmp109_ = NULL;
										gint _tmp110_ = 0;
										gchar* _tmp111_ = NULL;
										gchar* _tmp112_ = NULL;
#line 396 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
										_tmp103_ = c;
#line 396 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
										_tmp104_ = col_tmp;
#line 396 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
										_tmp105_ = width;
#line 396 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
										_tmp106_ = row_tmp;
#line 396 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
										_tmp107_ = height;
#line 396 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
										_tmp108_ = possibility_size;
#line 396 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
										cairo_move_to (_tmp103_, (gdouble) (_tmp104_ * _tmp105_), (_tmp106_ * _tmp107_) + _tmp108_);
#line 397 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
										_tmp109_ = c;
#line 397 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
										_tmp110_ = num;
#line 397 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
										_tmp111_ = g_strdup_printf ("%d", _tmp110_);
#line 397 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
										_tmp112_ = _tmp111_;
#line 397 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
										cairo_show_text (_tmp109_, _tmp112_);
#line 397 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
										_g_free0 (_tmp112_);
#line 2192 "sudoku-view.c"
									}
								}
							}
						}
					}
				}
			}
#line 376 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			possibilities = (g_free (possibilities), NULL);
#line 2202 "sudoku-view.c"
		}
	}
#line 403 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp114_ = self->priv->_show_warnings;
#line 403 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp114_) {
#line 2209 "sudoku-view.c"
		gboolean _tmp115_ = FALSE;
		gint _tmp116_ = 0;
		gint _tmp117_ = 0;
#line 403 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp116_ = sudoku_cell_view_get_value (self);
#line 403 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp117_ = _tmp116_;
#line 403 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		if (_tmp117_ == 0) {
#line 2219 "sudoku-view.c"
			SudokuGame* _tmp118_ = NULL;
			SudokuBoard* _tmp119_ = NULL;
			gint _tmp120_ = 0;
			gint _tmp121_ = 0;
			gint _tmp122_ = 0;
#line 403 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp118_ = self->priv->game;
#line 403 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp119_ = _tmp118_->board;
#line 403 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp120_ = self->priv->row;
#line 403 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp121_ = self->priv->col;
#line 403 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp122_ = sudoku_board_count_possibilities (_tmp119_, _tmp120_, _tmp121_);
#line 403 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp115_ = _tmp122_ == 0;
#line 2237 "sudoku-view.c"
		} else {
#line 403 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp115_ = FALSE;
#line 2241 "sudoku-view.c"
		}
#line 403 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp113_ = _tmp115_;
#line 2245 "sudoku-view.c"
	} else {
#line 403 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp113_ = FALSE;
#line 2249 "sudoku-view.c"
	}
#line 403 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp113_) {
#line 2253 "sudoku-view.c"
		gchar* warning = NULL;
		gchar* _tmp123_ = NULL;
		cairo_text_extents_t extents = {0};
		cairo_t* _tmp124_ = NULL;
		gint _tmp125_ = 0;
		cairo_t* _tmp126_ = NULL;
		const gchar* _tmp127_ = NULL;
		cairo_text_extents_t _tmp128_ = {0};
		cairo_t* _tmp129_ = NULL;
		gint _tmp130_ = 0;
		cairo_text_extents_t _tmp131_ = {0};
		gdouble _tmp132_ = 0.0;
		gint _tmp133_ = 0;
		cairo_text_extents_t _tmp134_ = {0};
		gdouble _tmp135_ = 0.0;
		cairo_t* _tmp136_ = NULL;
		cairo_t* _tmp137_ = NULL;
		const gchar* _tmp138_ = NULL;
#line 405 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp123_ = g_strdup ("X");
#line 405 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		warning = _tmp123_;
#line 407 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp124_ = c;
#line 407 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp125_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
#line 407 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		cairo_set_font_size (_tmp124_, (gdouble) (_tmp125_ / 2));
#line 408 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp126_ = c;
#line 408 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp127_ = warning;
#line 408 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		cairo_text_extents (_tmp126_, _tmp127_, &_tmp128_);
#line 408 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		extents = _tmp128_;
#line 409 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp129_ = c;
#line 409 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp130_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
#line 409 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp131_ = extents;
#line 409 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp132_ = _tmp131_.width;
#line 409 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp133_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
#line 409 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp134_ = extents;
#line 409 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp135_ = _tmp134_.height;
#line 409 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		cairo_move_to (_tmp129_, ((_tmp130_ - _tmp132_) / 2) - 1, ((_tmp133_ + _tmp135_) / 2) + 1);
#line 410 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp136_ = c;
#line 410 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		cairo_set_source_rgb (_tmp136_, 1.0, 0.0, 0.0);
#line 411 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp137_ = c;
#line 411 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp138_ = warning;
#line 411 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		cairo_show_text (_tmp137_, _tmp138_);
#line 403 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_g_free0 (warning);
#line 2318 "sudoku-view.c"
	}
#line 414 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	result = FALSE;
#line 414 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	return result;
#line 2324 "sudoku-view.c"
}


void sudoku_cell_view_cell_changed_cb (SudokuCellView* self, gint row, gint col, gint old_val, gint new_val) {
	gboolean _tmp0_ = FALSE;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
#line 417 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_if_fail (self != NULL);
#line 419 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp1_ = row;
#line 419 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp2_ = self->priv->row;
#line 419 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp1_ == _tmp2_) {
#line 2340 "sudoku-view.c"
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
#line 419 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp3_ = col;
#line 419 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp4_ = self->priv->col;
#line 419 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp0_ = _tmp3_ == _tmp4_;
#line 2349 "sudoku-view.c"
	} else {
#line 419 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp0_ = FALSE;
#line 2353 "sudoku-view.c"
	}
#line 419 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp0_) {
#line 2357 "sudoku-view.c"
		gint _tmp5_ = 0;
		SudokuGame* _tmp6_ = NULL;
		GameMode _tmp7_ = 0;
#line 421 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp5_ = new_val;
#line 421 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		sudoku_cell_view_set_value (self, _tmp5_);
#line 423 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp6_ = self->priv->game;
#line 423 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp7_ = _tmp6_->mode;
#line 423 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		if (_tmp7_ == GAME_MODE_CREATE) {
#line 2371 "sudoku-view.c"
			gboolean _tmp8_ = FALSE;
#line 425 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp8_ = self->priv->_selected;
#line 425 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			if (_tmp8_) {
#line 426 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				sudoku_cell_view_set_background_color (self, &selected_bg_color);
#line 2379 "sudoku-view.c"
			} else {
				GdkRGBA _tmp9_ = {0};
				gboolean _tmp10_ = FALSE;
				gboolean _tmp11_ = FALSE;
#line 428 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp10_ = sudoku_cell_view_get_is_fixed (self);
#line 428 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp11_ = _tmp10_;
#line 428 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				if (_tmp11_) {
#line 428 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp9_ = fixed_cell_color;
#line 2392 "sudoku-view.c"
				} else {
#line 428 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp9_ = free_cell_color;
#line 2396 "sudoku-view.c"
				}
#line 428 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				sudoku_cell_view_set_background_color (self, &_tmp9_);
#line 2400 "sudoku-view.c"
			}
		}
#line 431 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		g_object_notify ((GObject*) self, "value");
#line 2405 "sudoku-view.c"
	}
}


void sudoku_cell_view_clear (SudokuCellView* self) {
	SudokuGame* _tmp0_ = NULL;
	SudokuBoard* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
#line 435 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_if_fail (self != NULL);
#line 437 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = self->priv->game;
#line 437 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp1_ = _tmp0_->board;
#line 437 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp2_ = self->priv->row;
#line 437 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp3_ = self->priv->col;
#line 437 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	sudoku_board_disable_all_earmarks (_tmp1_, _tmp2_, _tmp3_);
#line 2427 "sudoku-view.c"
}


gint sudoku_cell_view_get_value (SudokuCellView* self) {
	gint result;
	SudokuGame* _tmp0_ = NULL;
	SudokuBoard* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
#line 41 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 41 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = self->priv->game;
#line 41 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp1_ = _tmp0_->board;
#line 41 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp2_ = self->priv->row;
#line 41 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp3_ = self->priv->col;
#line 41 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp4_ = sudoku_board_get (_tmp1_, _tmp2_, _tmp3_);
#line 41 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	result = _tmp4_;
#line 41 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	return result;
#line 2454 "sudoku-view.c"
}


void sudoku_cell_view_set_value (SudokuCellView* self, gint value) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gint _tmp16_ = 0;
	gint _tmp34_ = 0;
	SudokuGame* _tmp35_ = NULL;
	SudokuBoard* _tmp36_ = NULL;
	gint _tmp37_ = 0;
	gint _tmp38_ = 0;
	gint _tmp39_ = 0;
	SudokuGame* _tmp48_ = NULL;
	gint _tmp49_ = 0;
	gint _tmp50_ = 0;
	gint _tmp51_ = 0;
#line 42 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_if_fail (self != NULL);
#line 44 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = sudoku_cell_view_get_is_fixed (self);
#line 44 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp1_ = _tmp0_;
#line 44 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp1_) {
#line 2480 "sudoku-view.c"
		gchar* text = NULL;
		SudokuGame* _tmp2_ = NULL;
		SudokuBoard* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
		gchar* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		PangoLayout* _tmp9_ = NULL;
		PangoLayout* _tmp10_ = NULL;
		GtkStyle* _tmp11_ = NULL;
		GtkStyle* _tmp12_ = NULL;
		PangoFontDescription* _tmp13_ = NULL;
		SudokuGame* _tmp14_ = NULL;
		GameMode _tmp15_ = 0;
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp2_ = self->priv->game;
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp3_ = _tmp2_->board;
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp4_ = self->priv->row;
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp5_ = self->priv->col;
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp6_ = sudoku_board_get (_tmp3_, _tmp4_, _tmp5_);
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp7_ = g_strdup_printf ("%d", _tmp6_);
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		text = _tmp7_;
#line 47 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp8_ = text;
#line 47 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp9_ = gtk_widget_create_pango_layout ((GtkWidget*) self, _tmp8_);
#line 47 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_g_object_unref0 (self->priv->layout);
#line 47 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		self->priv->layout = _tmp9_;
#line 48 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp10_ = self->priv->layout;
#line 48 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp11_ = gtk_widget_get_style ((GtkWidget*) self);
#line 48 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp12_ = _tmp11_;
#line 48 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp13_ = _tmp12_->font_desc;
#line 48 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		pango_layout_set_font_description (_tmp10_, _tmp13_);
#line 49 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp14_ = self->priv->game;
#line 49 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp15_ = _tmp14_->mode;
#line 49 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		if (_tmp15_ == GAME_MODE_PLAY) {
#line 50 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_g_free0 (text);
#line 50 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			return;
#line 2538 "sudoku-view.c"
		}
#line 44 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_g_free0 (text);
#line 2542 "sudoku-view.c"
	}
#line 52 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp16_ = value;
#line 52 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp16_ == 0) {
#line 2548 "sudoku-view.c"
		gchar* text = NULL;
		gchar* _tmp17_ = NULL;
		const gchar* _tmp18_ = NULL;
		PangoLayout* _tmp19_ = NULL;
		PangoLayout* _tmp20_ = NULL;
		GtkStyle* _tmp21_ = NULL;
		GtkStyle* _tmp22_ = NULL;
		PangoFontDescription* _tmp23_ = NULL;
		SudokuGame* _tmp24_ = NULL;
		SudokuBoard* _tmp25_ = NULL;
		gint _tmp26_ = 0;
		gint _tmp27_ = 0;
		gint _tmp28_ = 0;
		SudokuGame* _tmp32_ = NULL;
		GameMode _tmp33_ = 0;
#line 54 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp17_ = g_strdup ("");
#line 54 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		text = _tmp17_;
#line 55 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp18_ = text;
#line 55 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp19_ = gtk_widget_create_pango_layout ((GtkWidget*) self, _tmp18_);
#line 55 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_g_object_unref0 (self->priv->layout);
#line 55 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		self->priv->layout = _tmp19_;
#line 56 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp20_ = self->priv->layout;
#line 56 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp21_ = gtk_widget_get_style ((GtkWidget*) self);
#line 56 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp22_ = _tmp21_;
#line 56 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp23_ = _tmp22_->font_desc;
#line 56 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		pango_layout_set_font_description (_tmp20_, _tmp23_);
#line 57 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp24_ = self->priv->game;
#line 57 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp25_ = _tmp24_->board;
#line 57 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp26_ = self->priv->row;
#line 57 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp27_ = self->priv->col;
#line 57 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp28_ = sudoku_board_get (_tmp25_, _tmp26_, _tmp27_);
#line 57 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		if (_tmp28_ != 0) {
#line 2598 "sudoku-view.c"
			SudokuGame* _tmp29_ = NULL;
			gint _tmp30_ = 0;
			gint _tmp31_ = 0;
#line 58 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp29_ = self->priv->game;
#line 58 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp30_ = self->priv->row;
#line 58 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp31_ = self->priv->col;
#line 58 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			sudoku_game_remove (_tmp29_, _tmp30_, _tmp31_);
#line 2610 "sudoku-view.c"
		}
#line 59 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp32_ = self->priv->game;
#line 59 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp33_ = _tmp32_->mode;
#line 59 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		if (_tmp33_ == GAME_MODE_PLAY) {
#line 60 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_g_free0 (text);
#line 60 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			return;
#line 2622 "sudoku-view.c"
		}
#line 52 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_g_free0 (text);
#line 2626 "sudoku-view.c"
	}
#line 62 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp34_ = value;
#line 62 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp35_ = self->priv->game;
#line 62 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp36_ = _tmp35_->board;
#line 62 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp37_ = self->priv->row;
#line 62 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp38_ = self->priv->col;
#line 62 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp39_ = sudoku_board_get (_tmp36_, _tmp37_, _tmp38_);
#line 62 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp34_ == _tmp39_) {
#line 2642 "sudoku-view.c"
		gchar* text = NULL;
		gint _tmp40_ = 0;
		gchar* _tmp41_ = NULL;
		const gchar* _tmp42_ = NULL;
		PangoLayout* _tmp43_ = NULL;
		PangoLayout* _tmp44_ = NULL;
		GtkStyle* _tmp45_ = NULL;
		GtkStyle* _tmp46_ = NULL;
		PangoFontDescription* _tmp47_ = NULL;
#line 64 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp40_ = value;
#line 64 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp41_ = g_strdup_printf ("%d", _tmp40_);
#line 64 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		text = _tmp41_;
#line 65 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp42_ = text;
#line 65 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp43_ = gtk_widget_create_pango_layout ((GtkWidget*) self, _tmp42_);
#line 65 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_g_object_unref0 (self->priv->layout);
#line 65 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		self->priv->layout = _tmp43_;
#line 66 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp44_ = self->priv->layout;
#line 66 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp45_ = gtk_widget_get_style ((GtkWidget*) self);
#line 66 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp46_ = _tmp45_;
#line 66 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp47_ = _tmp46_->font_desc;
#line 66 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		pango_layout_set_font_description (_tmp44_, _tmp47_);
#line 67 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_g_free0 (text);
#line 67 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		return;
#line 2680 "sudoku-view.c"
	}
#line 69 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp48_ = self->priv->game;
#line 69 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp49_ = self->priv->row;
#line 69 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp50_ = self->priv->col;
#line 69 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp51_ = value;
#line 69 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	sudoku_game_insert (_tmp48_, _tmp49_, _tmp50_, _tmp51_);
#line 42 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_object_notify ((GObject *) self, "value");
#line 2694 "sudoku-view.c"
}


gboolean sudoku_cell_view_get_is_fixed (SudokuCellView* self) {
	gboolean result;
	SudokuGame* _tmp0_ = NULL;
	SudokuBoard* _tmp1_ = NULL;
	gboolean* _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	gint _tmp2__length2 = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gboolean _tmp5_ = FALSE;
#line 75 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 75 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = self->priv->game;
#line 75 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp1_ = _tmp0_->board;
#line 75 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp2_ = _tmp1_->is_fixed;
#line 75 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp2__length1 = _tmp1_->is_fixed_length1;
#line 75 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp2__length2 = _tmp1_->is_fixed_length2;
#line 75 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp3_ = self->priv->row;
#line 75 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp4_ = self->priv->col;
#line 75 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp5_ = _tmp2_[(_tmp3_ * _tmp2__length2) + _tmp4_];
#line 75 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	result = _tmp5_;
#line 75 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	return result;
#line 2730 "sudoku-view.c"
}


gboolean sudoku_cell_view_get_show_possibilities (SudokuCellView* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 81 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 81 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = self->priv->_show_possibilities;
#line 81 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	result = _tmp0_;
#line 81 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	return result;
#line 2745 "sudoku-view.c"
}


void sudoku_cell_view_set_show_possibilities (SudokuCellView* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 82 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_if_fail (self != NULL);
#line 84 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = value;
#line 84 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->_show_possibilities = _tmp0_;
#line 85 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_widget_queue_draw ((GtkWidget*) self);
#line 82 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_object_notify ((GObject *) self, "show-possibilities");
#line 2761 "sudoku-view.c"
}


gboolean sudoku_cell_view_get_show_warnings (SudokuCellView* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 92 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 92 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = self->priv->_show_warnings;
#line 92 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	result = _tmp0_;
#line 92 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	return result;
#line 2776 "sudoku-view.c"
}


void sudoku_cell_view_set_show_warnings (SudokuCellView* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 93 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_if_fail (self != NULL);
#line 95 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = value;
#line 95 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->_show_warnings = _tmp0_;
#line 96 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_widget_queue_draw ((GtkWidget*) self);
#line 93 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_object_notify ((GObject *) self, "show-warnings");
#line 2792 "sudoku-view.c"
}


gboolean sudoku_cell_view_get_selected (SudokuCellView* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 100 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 100 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = self->priv->_selected;
#line 100 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	result = _tmp0_;
#line 100 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	return result;
#line 2807 "sudoku-view.c"
}


void sudoku_cell_view_set_selected (SudokuCellView* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 100 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_if_fail (self != NULL);
#line 100 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = value;
#line 100 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->_selected = _tmp0_;
#line 100 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_object_notify ((GObject *) self, "selected");
#line 2821 "sudoku-view.c"
}


void sudoku_cell_view_get_background_color (SudokuCellView* self, GdkRGBA* result) {
	GdkRGBA _tmp0_ = {0};
#line 101 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_if_fail (self != NULL);
#line 101 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = self->priv->_background_color;
#line 101 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	*result = _tmp0_;
#line 101 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	return;
#line 2835 "sudoku-view.c"
}


void sudoku_cell_view_set_background_color (SudokuCellView* self, GdkRGBA* value) {
	GdkRGBA _tmp0_ = {0};
#line 101 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_if_fail (self != NULL);
#line 101 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = *value;
#line 101 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->_background_color = _tmp0_;
#line 101 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_object_notify ((GObject *) self, "background-color");
#line 2849 "sudoku-view.c"
}


static void sudoku_cell_view_class_init (SudokuCellViewClass * klass) {
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	sudoku_cell_view_parent_class = g_type_class_peek_parent (klass);
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_type_class_add_private (klass, sizeof (SudokuCellViewPrivate));
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	((GtkWidgetClass *) klass)->button_press_event = sudoku_cell_view_real_button_press_event;
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	((GtkWidgetClass *) klass)->key_press_event = sudoku_cell_view_real_key_press_event;
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	((GtkWidgetClass *) klass)->draw = sudoku_cell_view_real_draw;
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_sudoku_cell_view_get_property;
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_sudoku_cell_view_set_property;
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	G_OBJECT_CLASS (klass)->finalize = sudoku_cell_view_finalize;
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_CELL_VIEW_VALUE, g_param_spec_int ("value", "value", "value", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_CELL_VIEW_IS_FIXED, g_param_spec_boolean ("is-fixed", "is-fixed", "is-fixed", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_CELL_VIEW_SHOW_POSSIBILITIES, g_param_spec_boolean ("show-possibilities", "show-possibilities", "show-possibilities", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_CELL_VIEW_SHOW_WARNINGS, g_param_spec_boolean ("show-warnings", "show-warnings", "show-warnings", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_CELL_VIEW_SELECTED, g_param_spec_boolean ("selected", "selected", "selected", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_CELL_VIEW_BACKGROUND_COLOR, g_param_spec_boxed ("background-color", "background-color", "background-color", gdk_rgba_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 2882 "sudoku-view.c"
}


static void sudoku_cell_view_instance_init (SudokuCellView * self) {
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv = SUDOKU_CELL_VIEW_GET_PRIVATE (self);
#line 29 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->size_ratio = (gdouble) 2;
#line 89 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->_show_warnings = TRUE;
#line 2893 "sudoku-view.c"
}


static void sudoku_cell_view_finalize (GObject* obj) {
	SudokuCellView * self;
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SUDOKU_CELL_VIEW, SudokuCellView);
#line 27 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_g_object_unref0 (self->priv->layout);
#line 31 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_g_object_unref0 (self->priv->popover);
#line 32 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_g_object_unref0 (self->priv->earmark_popover);
#line 34 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_g_object_unref0 (self->priv->game);
#line 103 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_g_object_unref0 (self->priv->number_picker);
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_g_object_unref0 (self->priv->earmark_picker);
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	G_OBJECT_CLASS (sudoku_cell_view_parent_class)->finalize (obj);
#line 2915 "sudoku-view.c"
}


GType sudoku_cell_view_get_type (void) {
	static volatile gsize sudoku_cell_view_type_id__volatile = 0;
	if (g_once_init_enter (&sudoku_cell_view_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SudokuCellViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sudoku_cell_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SudokuCellView), 0, (GInstanceInitFunc) sudoku_cell_view_instance_init, NULL };
		GType sudoku_cell_view_type_id;
		sudoku_cell_view_type_id = g_type_register_static (gtk_drawing_area_get_type (), "SudokuCellView", &g_define_type_info, 0);
		g_once_init_leave (&sudoku_cell_view_type_id__volatile, sudoku_cell_view_type_id);
	}
	return sudoku_cell_view_type_id__volatile;
}


static void _vala_sudoku_cell_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SudokuCellView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SUDOKU_CELL_VIEW, SudokuCellView);
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	switch (property_id) {
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		case SUDOKU_CELL_VIEW_VALUE:
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		g_value_set_int (value, sudoku_cell_view_get_value (self));
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		break;
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		case SUDOKU_CELL_VIEW_IS_FIXED:
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		g_value_set_boolean (value, sudoku_cell_view_get_is_fixed (self));
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		break;
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		case SUDOKU_CELL_VIEW_SHOW_POSSIBILITIES:
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		g_value_set_boolean (value, sudoku_cell_view_get_show_possibilities (self));
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		break;
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		case SUDOKU_CELL_VIEW_SHOW_WARNINGS:
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		g_value_set_boolean (value, sudoku_cell_view_get_show_warnings (self));
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		break;
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		case SUDOKU_CELL_VIEW_SELECTED:
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		g_value_set_boolean (value, sudoku_cell_view_get_selected (self));
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		break;
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		case SUDOKU_CELL_VIEW_BACKGROUND_COLOR:
#line 2968 "sudoku-view.c"
		{
			GdkRGBA boxed;
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			sudoku_cell_view_get_background_color (self, &boxed);
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			g_value_set_boxed (value, &boxed);
#line 2975 "sudoku-view.c"
		}
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		break;
#line 2979 "sudoku-view.c"
		default:
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		break;
#line 2985 "sudoku-view.c"
	}
}


static void _vala_sudoku_cell_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SudokuCellView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SUDOKU_CELL_VIEW, SudokuCellView);
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	switch (property_id) {
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		case SUDOKU_CELL_VIEW_VALUE:
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		sudoku_cell_view_set_value (self, g_value_get_int (value));
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		break;
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		case SUDOKU_CELL_VIEW_SHOW_POSSIBILITIES:
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		sudoku_cell_view_set_show_possibilities (self, g_value_get_boolean (value));
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		break;
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		case SUDOKU_CELL_VIEW_SHOW_WARNINGS:
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		sudoku_cell_view_set_show_warnings (self, g_value_get_boolean (value));
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		break;
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		case SUDOKU_CELL_VIEW_SELECTED:
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		sudoku_cell_view_set_selected (self, g_value_get_boolean (value));
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		break;
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		case SUDOKU_CELL_VIEW_BACKGROUND_COLOR:
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		sudoku_cell_view_set_background_color (self, g_value_get_boxed (value));
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		break;
#line 3025 "sudoku-view.c"
		default:
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		break;
#line 3031 "sudoku-view.c"
	}
}


static void sudoku_view_set_selected (SudokuView* self, gint cell_row, gint cell_col) {
	SudokuCellView** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint _tmp0__length2 = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	SudokuCellView* _tmp3_ = NULL;
	SudokuCellView** _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	gint _tmp4__length2 = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	SudokuCellView* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	SudokuCellView** _tmp10_ = NULL;
	gint _tmp10__length1 = 0;
	gint _tmp10__length2 = 0;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	SudokuCellView* _tmp13_ = NULL;
#line 459 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_if_fail (self != NULL);
#line 461 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = self->priv->cells;
#line 461 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0__length1 = self->priv->cells_length1;
#line 461 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0__length2 = self->priv->cells_length2;
#line 461 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp1_ = self->priv->selected_row;
#line 461 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp2_ = self->priv->selected_col;
#line 461 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp3_ = _tmp0_[(_tmp1_ * _tmp0__length2) + _tmp2_];
#line 461 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	sudoku_cell_view_set_selected (_tmp3_, FALSE);
#line 462 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp4_ = self->priv->cells;
#line 462 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp4__length1 = self->priv->cells_length1;
#line 462 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp4__length2 = self->priv->cells_length2;
#line 462 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp5_ = self->priv->selected_row;
#line 462 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp6_ = self->priv->selected_col;
#line 462 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp7_ = _tmp4_[(_tmp5_ * _tmp4__length2) + _tmp6_];
#line 462 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_widget_queue_draw ((GtkWidget*) _tmp7_);
#line 463 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp8_ = cell_row;
#line 463 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->selected_row = _tmp8_;
#line 464 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp9_ = cell_col;
#line 464 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->selected_col = _tmp9_;
#line 465 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp10_ = self->priv->cells;
#line 465 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp10__length1 = self->priv->cells_length1;
#line 465 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp10__length2 = self->priv->cells_length2;
#line 465 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp11_ = self->priv->selected_row;
#line 465 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp12_ = self->priv->selected_col;
#line 465 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp13_ = _tmp10_[(_tmp11_ * _tmp10__length2) + _tmp12_];
#line 465 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	sudoku_cell_view_set_selected (_tmp13_, TRUE);
#line 3109 "sudoku-view.c"
}


static Block5Data* block5_data_ref (Block5Data* _data5_) {
#line 468 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_atomic_int_inc (&_data5_->_ref_count_);
#line 468 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	return _data5_;
#line 3118 "sudoku-view.c"
}


static void block5_data_unref (void * _userdata_) {
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
#line 468 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
#line 3127 "sudoku-view.c"
		SudokuView* self;
#line 468 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		self = _data5_->self;
#line 468 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_g_object_unref0 (_data5_->game);
#line 468 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_g_object_unref0 (self);
#line 468 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		g_slice_free (Block5Data, _data5_);
#line 3137 "sudoku-view.c"
	}
}


static gboolean _sudoku_view_draw_board_gtk_widget_draw (GtkWidget* _sender, cairo_t* cr, gpointer self) {
	gboolean result;
	result = sudoku_view_draw_board ((SudokuView*) self, cr);
#line 478 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	return result;
#line 3147 "sudoku-view.c"
}


static Block6Data* block6_data_ref (Block6Data* _data6_) {
#line 494 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_atomic_int_inc (&_data6_->_ref_count_);
#line 494 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	return _data6_;
#line 3156 "sudoku-view.c"
}


static void block6_data_unref (void * _userdata_) {
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
#line 494 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
#line 3165 "sudoku-view.c"
		SudokuView* self;
#line 494 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		self = _data6_->_data5_->self;
#line 494 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		block5_data_unref (_data6_->_data5_);
#line 494 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_data6_->_data5_ = NULL;
#line 494 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		g_slice_free (Block6Data, _data6_);
#line 3175 "sudoku-view.c"
	}
}


static gboolean ________lambda13_ (Block6Data* _data6_) {
	Block5Data* _data5_;
	SudokuView* self;
	gboolean result = FALSE;
	SudokuGame* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	SudokuCellView** _tmp113_ = NULL;
	gint _tmp113__length1 = 0;
	gint _tmp113__length2 = 0;
	gint _tmp114_ = 0;
	gint _tmp115_ = 0;
	SudokuCellView* _tmp116_ = NULL;
#line 502 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_data5_ = _data6_->_data5_;
#line 502 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self = _data5_->self;
#line 503 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = _data5_->game;
#line 503 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp1_ = sudoku_game_get_paused (_tmp0_);
#line 503 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp2_ = _tmp1_;
#line 503 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp2_) {
#line 504 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		result = FALSE;
#line 504 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		return result;
#line 3211 "sudoku-view.c"
	}
#line 506 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp3_ = _data6_->cell_row;
#line 506 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp4_ = _data6_->cell_col;
#line 506 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	sudoku_view_set_selected (self, _tmp3_, _tmp4_);
#line 3219 "sudoku-view.c"
	{
		gint col_tmp = 0;
#line 508 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		col_tmp = 0;
#line 3224 "sudoku-view.c"
		{
			gboolean _tmp5_ = FALSE;
#line 508 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp5_ = TRUE;
#line 508 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			while (TRUE) {
#line 3231 "sudoku-view.c"
				gint _tmp7_ = 0;
				SudokuGame* _tmp8_ = NULL;
				SudokuBoard* _tmp9_ = NULL;
				gint _tmp10_ = 0;
				gint _tmp11_ = 0;
				GdkRGBA _tmp12_ = {0};
				gboolean _tmp13_ = FALSE;
				gint _tmp14_ = 0;
				gint _tmp15_ = 0;
				GdkRGBA color = {0};
#line 508 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				if (!_tmp5_) {
#line 3244 "sudoku-view.c"
					gint _tmp6_ = 0;
#line 508 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp6_ = col_tmp;
#line 508 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					col_tmp = _tmp6_ + 1;
#line 3250 "sudoku-view.c"
				}
#line 508 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp5_ = FALSE;
#line 508 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp7_ = col_tmp;
#line 508 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp8_ = _data5_->game;
#line 508 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp9_ = _tmp8_->board;
#line 508 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp10_ = sudoku_board_get_cols (_tmp9_);
#line 508 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp11_ = _tmp10_;
#line 508 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				if (!(_tmp7_ < _tmp11_)) {
#line 508 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					break;
#line 3268 "sudoku-view.c"
				}
#line 510 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp14_ = col_tmp;
#line 510 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp15_ = _data6_->cell_col;
#line 510 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				if (_tmp14_ == _tmp15_) {
#line 3276 "sudoku-view.c"
					gboolean _tmp16_ = FALSE;
#line 510 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp16_ = self->priv->_highlighter;
#line 510 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp13_ = _tmp16_;
#line 3282 "sudoku-view.c"
				} else {
#line 510 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp13_ = FALSE;
#line 3286 "sudoku-view.c"
				}
#line 510 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				if (_tmp13_) {
#line 510 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp12_ = highlight_color;
#line 3292 "sudoku-view.c"
				} else {
#line 510 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp12_ = free_cell_color;
#line 3296 "sudoku-view.c"
				}
#line 510 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				color = _tmp12_;
#line 3300 "sudoku-view.c"
				{
					gint row_tmp = 0;
#line 511 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					row_tmp = 0;
#line 3305 "sudoku-view.c"
					{
						gboolean _tmp17_ = FALSE;
#line 511 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						_tmp17_ = TRUE;
#line 511 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						while (TRUE) {
#line 3312 "sudoku-view.c"
							gint _tmp19_ = 0;
							SudokuGame* _tmp20_ = NULL;
							SudokuBoard* _tmp21_ = NULL;
							gint _tmp22_ = 0;
							gint _tmp23_ = 0;
							GdkRGBA _tmp24_ = {0};
							SudokuCellView** _tmp25_ = NULL;
							gint _tmp25__length1 = 0;
							gint _tmp25__length2 = 0;
							gint _tmp26_ = 0;
							gint _tmp27_ = 0;
							SudokuCellView* _tmp28_ = NULL;
							gboolean _tmp29_ = FALSE;
							gboolean _tmp30_ = FALSE;
							SudokuCellView** _tmp32_ = NULL;
							gint _tmp32__length1 = 0;
							gint _tmp32__length2 = 0;
							gint _tmp33_ = 0;
							gint _tmp34_ = 0;
							SudokuCellView* _tmp35_ = NULL;
#line 511 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							if (!_tmp17_) {
#line 3335 "sudoku-view.c"
								gint _tmp18_ = 0;
#line 511 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
								_tmp18_ = row_tmp;
#line 511 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
								row_tmp = _tmp18_ + 1;
#line 3341 "sudoku-view.c"
							}
#line 511 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp17_ = FALSE;
#line 511 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp19_ = row_tmp;
#line 511 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp20_ = _data5_->game;
#line 511 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp21_ = _tmp20_->board;
#line 511 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp22_ = sudoku_board_get_rows (_tmp21_);
#line 511 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp23_ = _tmp22_;
#line 511 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							if (!(_tmp19_ < _tmp23_)) {
#line 511 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
								break;
#line 3359 "sudoku-view.c"
							}
#line 512 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp25_ = self->priv->cells;
#line 512 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp25__length1 = self->priv->cells_length1;
#line 512 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp25__length2 = self->priv->cells_length2;
#line 512 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp26_ = row_tmp;
#line 512 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp27_ = col_tmp;
#line 512 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp28_ = _tmp25_[(_tmp26_ * _tmp25__length2) + _tmp27_];
#line 512 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp29_ = sudoku_cell_view_get_is_fixed (_tmp28_);
#line 512 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp30_ = _tmp29_;
#line 512 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							if (_tmp30_) {
#line 512 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
								_tmp24_ = fixed_cell_color;
#line 3381 "sudoku-view.c"
							} else {
								GdkRGBA _tmp31_ = {0};
#line 512 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
								_tmp31_ = color;
#line 512 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
								_tmp24_ = _tmp31_;
#line 3388 "sudoku-view.c"
							}
#line 512 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp32_ = self->priv->cells;
#line 512 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp32__length1 = self->priv->cells_length1;
#line 512 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp32__length2 = self->priv->cells_length2;
#line 512 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp33_ = row_tmp;
#line 512 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp34_ = col_tmp;
#line 512 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp35_ = _tmp32_[(_tmp33_ * _tmp32__length2) + _tmp34_];
#line 512 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							sudoku_cell_view_set_background_color (_tmp35_, &_tmp24_);
#line 3404 "sudoku-view.c"
						}
					}
				}
			}
		}
	}
	{
		gint col_tmp = 0;
#line 514 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		col_tmp = 0;
#line 3415 "sudoku-view.c"
		{
			gboolean _tmp36_ = FALSE;
#line 514 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp36_ = TRUE;
#line 514 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			while (TRUE) {
#line 3422 "sudoku-view.c"
				gint _tmp38_ = 0;
				SudokuGame* _tmp39_ = NULL;
				SudokuBoard* _tmp40_ = NULL;
				gint _tmp41_ = 0;
				gint _tmp42_ = 0;
				SudokuCellView** _tmp43_ = NULL;
				gint _tmp43__length1 = 0;
				gint _tmp43__length2 = 0;
				gint _tmp44_ = 0;
				gint _tmp45_ = 0;
				SudokuCellView* _tmp46_ = NULL;
				gboolean _tmp47_ = FALSE;
				gboolean _tmp48_ = FALSE;
#line 514 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				if (!_tmp36_) {
#line 3438 "sudoku-view.c"
					gint _tmp37_ = 0;
#line 514 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp37_ = col_tmp;
#line 514 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					col_tmp = _tmp37_ + 1;
#line 3444 "sudoku-view.c"
				}
#line 514 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp36_ = FALSE;
#line 514 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp38_ = col_tmp;
#line 514 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp39_ = _data5_->game;
#line 514 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp40_ = _tmp39_->board;
#line 514 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp41_ = sudoku_board_get_cols (_tmp40_);
#line 514 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp42_ = _tmp41_;
#line 514 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				if (!(_tmp38_ < _tmp42_)) {
#line 514 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					break;
#line 3462 "sudoku-view.c"
				}
#line 516 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp43_ = self->priv->cells;
#line 516 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp43__length1 = self->priv->cells_length1;
#line 516 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp43__length2 = self->priv->cells_length2;
#line 516 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp44_ = _data6_->cell_row;
#line 516 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp45_ = col_tmp;
#line 516 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp46_ = _tmp43_[(_tmp44_ * _tmp43__length2) + _tmp45_];
#line 516 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp47_ = sudoku_cell_view_get_is_fixed (_tmp46_);
#line 516 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp48_ = _tmp47_;
#line 516 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				if (_tmp48_) {
#line 3482 "sudoku-view.c"
					SudokuCellView** _tmp49_ = NULL;
					gint _tmp49__length1 = 0;
					gint _tmp49__length2 = 0;
					gint _tmp50_ = 0;
					gint _tmp51_ = 0;
					SudokuCellView* _tmp52_ = NULL;
#line 517 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp49_ = self->priv->cells;
#line 517 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp49__length1 = self->priv->cells_length1;
#line 517 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp49__length2 = self->priv->cells_length2;
#line 517 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp50_ = _data6_->cell_row;
#line 517 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp51_ = col_tmp;
#line 517 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp52_ = _tmp49_[(_tmp50_ * _tmp49__length2) + _tmp51_];
#line 517 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					sudoku_cell_view_set_background_color (_tmp52_, &fixed_cell_color);
#line 3503 "sudoku-view.c"
				} else {
					gboolean _tmp53_ = FALSE;
#line 518 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp53_ = self->priv->_highlighter;
#line 518 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					if (_tmp53_) {
#line 3510 "sudoku-view.c"
						SudokuCellView** _tmp54_ = NULL;
						gint _tmp54__length1 = 0;
						gint _tmp54__length2 = 0;
						gint _tmp55_ = 0;
						gint _tmp56_ = 0;
						SudokuCellView* _tmp57_ = NULL;
#line 519 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						_tmp54_ = self->priv->cells;
#line 519 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						_tmp54__length1 = self->priv->cells_length1;
#line 519 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						_tmp54__length2 = self->priv->cells_length2;
#line 519 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						_tmp55_ = _data6_->cell_row;
#line 519 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						_tmp56_ = col_tmp;
#line 519 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						_tmp57_ = _tmp54_[(_tmp55_ * _tmp54__length2) + _tmp56_];
#line 519 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						sudoku_cell_view_set_background_color (_tmp57_, &highlight_color);
#line 3531 "sudoku-view.c"
					} else {
						SudokuCellView** _tmp58_ = NULL;
						gint _tmp58__length1 = 0;
						gint _tmp58__length2 = 0;
						gint _tmp59_ = 0;
						gint _tmp60_ = 0;
						SudokuCellView* _tmp61_ = NULL;
#line 521 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						_tmp58_ = self->priv->cells;
#line 521 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						_tmp58__length1 = self->priv->cells_length1;
#line 521 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						_tmp58__length2 = self->priv->cells_length2;
#line 521 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						_tmp59_ = _data6_->cell_row;
#line 521 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						_tmp60_ = col_tmp;
#line 521 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						_tmp61_ = _tmp58_[(_tmp59_ * _tmp58__length2) + _tmp60_];
#line 521 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						sudoku_cell_view_set_background_color (_tmp61_, &free_cell_color);
#line 3553 "sudoku-view.c"
					}
				}
			}
		}
	}
	{
		GeeList* _coord_list = NULL;
		SudokuGame* _tmp62_ = NULL;
		SudokuBoard* _tmp63_ = NULL;
		GeeMap* _tmp64_ = NULL;
		gint _tmp65_ = 0;
		SudokuGame* _tmp66_ = NULL;
		SudokuBoard* _tmp67_ = NULL;
		gint _tmp68_ = 0;
		gint _tmp69_ = 0;
		gint _tmp70_ = 0;
		SudokuGame* _tmp71_ = NULL;
		SudokuBoard* _tmp72_ = NULL;
		gint _tmp73_ = 0;
		gint _tmp74_ = 0;
		Coord _tmp75_ = {0};
		gpointer _tmp76_ = NULL;
		gint _coord_size = 0;
		GeeList* _tmp77_ = NULL;
		gint _tmp78_ = 0;
		gint _tmp79_ = 0;
		gint _coord_index = 0;
#line 524 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp62_ = _data5_->game;
#line 524 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp63_ = _tmp62_->board;
#line 524 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp64_ = _tmp63_->coords_for_block;
#line 524 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp65_ = _data6_->cell_row;
#line 524 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp66_ = _data5_->game;
#line 524 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp67_ = _tmp66_->board;
#line 524 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp68_ = sudoku_board_get_block_rows (_tmp67_);
#line 524 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp69_ = _tmp68_;
#line 524 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp70_ = _data6_->cell_col;
#line 524 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp71_ = _data5_->game;
#line 524 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp72_ = _tmp71_->board;
#line 524 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp73_ = sudoku_board_get_block_cols (_tmp72_);
#line 524 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp74_ = _tmp73_;
#line 524 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		coord_init (&_tmp75_, _tmp65_ / _tmp69_, _tmp70_ / _tmp74_);
#line 524 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp76_ = gee_map_get (_tmp64_, &_tmp75_);
#line 524 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_coord_list = (GeeList*) _tmp76_;
#line 524 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp77_ = _coord_list;
#line 524 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp78_ = gee_collection_get_size ((GeeCollection*) _tmp77_);
#line 524 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp79_ = _tmp78_;
#line 524 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_coord_size = _tmp79_;
#line 524 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_coord_index = -1;
#line 524 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		while (TRUE) {
#line 3625 "sudoku-view.c"
			gint _tmp80_ = 0;
			gint _tmp81_ = 0;
			gint _tmp82_ = 0;
			Coord* coord = NULL;
			GeeList* _tmp83_ = NULL;
			gint _tmp84_ = 0;
			gpointer _tmp85_ = NULL;
			SudokuCellView** _tmp86_ = NULL;
			gint _tmp86__length1 = 0;
			gint _tmp86__length2 = 0;
			Coord* _tmp87_ = NULL;
			gint _tmp88_ = 0;
			Coord* _tmp89_ = NULL;
			gint _tmp90_ = 0;
			SudokuCellView* _tmp91_ = NULL;
			gboolean _tmp92_ = FALSE;
			gboolean _tmp93_ = FALSE;
#line 524 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp80_ = _coord_index;
#line 524 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_coord_index = _tmp80_ + 1;
#line 524 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp81_ = _coord_index;
#line 524 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp82_ = _coord_size;
#line 524 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			if (!(_tmp81_ < _tmp82_)) {
#line 524 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				break;
#line 3655 "sudoku-view.c"
			}
#line 524 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp83_ = _coord_list;
#line 524 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp84_ = _coord_index;
#line 524 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp85_ = gee_list_get (_tmp83_, _tmp84_);
#line 524 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			coord = (Coord*) _tmp85_;
#line 526 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp86_ = self->priv->cells;
#line 526 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp86__length1 = self->priv->cells_length1;
#line 526 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp86__length2 = self->priv->cells_length2;
#line 526 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp87_ = coord;
#line 526 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp88_ = (*_tmp87_).row;
#line 526 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp89_ = coord;
#line 526 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp90_ = (*_tmp89_).col;
#line 526 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp91_ = _tmp86_[(_tmp88_ * _tmp86__length2) + _tmp90_];
#line 526 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp92_ = sudoku_cell_view_get_is_fixed (_tmp91_);
#line 526 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp93_ = _tmp92_;
#line 526 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			if (_tmp93_) {
#line 3687 "sudoku-view.c"
				SudokuCellView** _tmp94_ = NULL;
				gint _tmp94__length1 = 0;
				gint _tmp94__length2 = 0;
				Coord* _tmp95_ = NULL;
				gint _tmp96_ = 0;
				Coord* _tmp97_ = NULL;
				gint _tmp98_ = 0;
				SudokuCellView* _tmp99_ = NULL;
#line 527 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp94_ = self->priv->cells;
#line 527 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp94__length1 = self->priv->cells_length1;
#line 527 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp94__length2 = self->priv->cells_length2;
#line 527 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp95_ = coord;
#line 527 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp96_ = (*_tmp95_).row;
#line 527 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp97_ = coord;
#line 527 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp98_ = (*_tmp97_).col;
#line 527 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp99_ = _tmp94_[(_tmp96_ * _tmp94__length2) + _tmp98_];
#line 527 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				sudoku_cell_view_set_background_color (_tmp99_, &fixed_cell_color);
#line 3714 "sudoku-view.c"
			} else {
				gboolean _tmp100_ = FALSE;
#line 528 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp100_ = self->priv->_highlighter;
#line 528 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				if (_tmp100_) {
#line 3721 "sudoku-view.c"
					SudokuCellView** _tmp101_ = NULL;
					gint _tmp101__length1 = 0;
					gint _tmp101__length2 = 0;
					Coord* _tmp102_ = NULL;
					gint _tmp103_ = 0;
					Coord* _tmp104_ = NULL;
					gint _tmp105_ = 0;
					SudokuCellView* _tmp106_ = NULL;
#line 529 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp101_ = self->priv->cells;
#line 529 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp101__length1 = self->priv->cells_length1;
#line 529 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp101__length2 = self->priv->cells_length2;
#line 529 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp102_ = coord;
#line 529 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp103_ = (*_tmp102_).row;
#line 529 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp104_ = coord;
#line 529 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp105_ = (*_tmp104_).col;
#line 529 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp106_ = _tmp101_[(_tmp103_ * _tmp101__length2) + _tmp105_];
#line 529 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					sudoku_cell_view_set_background_color (_tmp106_, &highlight_color);
#line 3748 "sudoku-view.c"
				} else {
					SudokuCellView** _tmp107_ = NULL;
					gint _tmp107__length1 = 0;
					gint _tmp107__length2 = 0;
					Coord* _tmp108_ = NULL;
					gint _tmp109_ = 0;
					Coord* _tmp110_ = NULL;
					gint _tmp111_ = 0;
					SudokuCellView* _tmp112_ = NULL;
#line 531 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp107_ = self->priv->cells;
#line 531 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp107__length1 = self->priv->cells_length1;
#line 531 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp107__length2 = self->priv->cells_length2;
#line 531 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp108_ = coord;
#line 531 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp109_ = (*_tmp108_).row;
#line 531 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp110_ = coord;
#line 531 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp111_ = (*_tmp110_).col;
#line 531 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp112_ = _tmp107_[(_tmp109_ * _tmp107__length2) + _tmp111_];
#line 531 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					sudoku_cell_view_set_background_color (_tmp112_, &free_cell_color);
#line 3776 "sudoku-view.c"
				}
			}
#line 524 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_g_free0 (coord);
#line 3781 "sudoku-view.c"
		}
#line 524 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_g_object_unref0 (_coord_list);
#line 3785 "sudoku-view.c"
	}
#line 534 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp113_ = self->priv->cells;
#line 534 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp113__length1 = self->priv->cells_length1;
#line 534 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp113__length2 = self->priv->cells_length2;
#line 534 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp114_ = _data6_->cell_row;
#line 534 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp115_ = _data6_->cell_col;
#line 534 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp116_ = _tmp113_[(_tmp114_ * _tmp113__length2) + _tmp115_];
#line 534 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	sudoku_cell_view_set_background_color (_tmp116_, &selected_bg_color);
#line 536 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_widget_queue_draw ((GtkWidget*) self);
#line 538 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	result = FALSE;
#line 538 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	return result;
#line 3807 "sudoku-view.c"
}


static gboolean _________lambda13__gtk_widget_focus_in_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self) {
	gboolean result;
	result = ________lambda13_ (self);
#line 502 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	return result;
#line 3816 "sudoku-view.c"
}


static void ________lambda14_ (Block6Data* _data6_, GObject* s, GParamSpec* p) {
	Block5Data* _data5_;
	SudokuView* self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
#line 541 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_data5_ = _data6_->_data5_;
#line 541 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self = _data5_->self;
#line 541 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_if_fail (s != NULL);
#line 541 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_if_fail (p != NULL);
#line 542 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp3_ = self->priv->_show_possibilities;
#line 542 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp3_) {
#line 542 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp2_ = TRUE;
#line 3841 "sudoku-view.c"
	} else {
		gboolean _tmp4_ = FALSE;
#line 542 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp4_ = self->priv->_show_warnings;
#line 542 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp2_ = _tmp4_;
#line 3848 "sudoku-view.c"
	}
#line 542 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp2_) {
#line 542 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp1_ = TRUE;
#line 3854 "sudoku-view.c"
	} else {
		SudokuGame* _tmp5_ = NULL;
		SudokuBoard* _tmp6_ = NULL;
		gboolean _tmp7_ = FALSE;
		gboolean _tmp8_ = FALSE;
#line 542 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp5_ = _data5_->game;
#line 542 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp6_ = _tmp5_->board;
#line 542 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp7_ = sudoku_board_get_broken (_tmp6_);
#line 542 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp8_ = _tmp7_;
#line 542 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp1_ = _tmp8_;
#line 3870 "sudoku-view.c"
	}
#line 542 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp1_) {
#line 542 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp0_ = TRUE;
#line 3876 "sudoku-view.c"
	} else {
		gboolean _tmp9_ = FALSE;
#line 542 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp9_ = self->priv->previous_board_broken_state;
#line 542 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp0_ = _tmp9_;
#line 3883 "sudoku-view.c"
	}
#line 542 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp0_) {
#line 3887 "sudoku-view.c"
		SudokuGame* _tmp10_ = NULL;
		SudokuBoard* _tmp11_ = NULL;
		gboolean _tmp12_ = FALSE;
		gboolean _tmp13_ = FALSE;
#line 543 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp10_ = _data5_->game;
#line 543 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp11_ = _tmp10_->board;
#line 543 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp12_ = sudoku_board_get_broken (_tmp11_);
#line 543 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp13_ = _tmp12_;
#line 543 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		self->priv->previous_board_broken_state = _tmp13_;
#line 3902 "sudoku-view.c"
	}
#line 546 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_widget_queue_draw ((GtkWidget*) self);
#line 3906 "sudoku-view.c"
}


static void _________lambda14__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 541 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	________lambda14_ (self, _sender, pspec);
#line 3913 "sudoku-view.c"
}


SudokuView* sudoku_view_construct (GType object_type, SudokuGame* game) {
	SudokuView * self = NULL;
	Block5Data* _data5_;
	SudokuGame* _tmp0_ = NULL;
	SudokuGame* _tmp1_ = NULL;
	GtkOverlay* _tmp2_ = NULL;
	GtkOverlay* _tmp3_ = NULL;
	GtkDrawingArea* _tmp4_ = NULL;
	GtkDrawingArea* _tmp5_ = NULL;
	GtkGrid* _tmp6_ = NULL;
	SudokuGame* _tmp9_ = NULL;
	SudokuGame* _tmp10_ = NULL;
	GtkGrid* _tmp11_ = NULL;
	GtkGrid* _tmp12_ = NULL;
	GtkGrid* _tmp13_ = NULL;
	GtkGrid* _tmp14_ = NULL;
	GtkGrid* _tmp15_ = NULL;
	SudokuGame* _tmp16_ = NULL;
	SudokuBoard* _tmp17_ = NULL;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	SudokuGame* _tmp20_ = NULL;
	SudokuBoard* _tmp21_ = NULL;
	gint _tmp22_ = 0;
	gint _tmp23_ = 0;
	SudokuCellView** _tmp24_ = NULL;
	GtkOverlay* _tmp61_ = NULL;
	GtkDrawingArea* _tmp62_ = NULL;
	GtkOverlay* _tmp63_ = NULL;
	GtkGrid* _tmp64_ = NULL;
	GtkDrawingArea* _tmp65_ = NULL;
	GtkGrid* _tmp66_ = NULL;
	GtkOverlay* _tmp67_ = NULL;
#line 468 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_val_if_fail (game != NULL, NULL);
#line 468 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_data5_ = g_slice_new0 (Block5Data);
#line 468 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_data5_->_ref_count_ = 1;
#line 468 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = game;
#line 468 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 468 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_g_object_unref0 (_data5_->game);
#line 468 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_data5_->game = _tmp1_;
#line 468 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self = (SudokuView*) g_object_new (object_type, NULL);
#line 468 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_data5_->self = g_object_ref (self);
#line 470 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_frame_set_shadow_type ((GtkFrame*) self, GTK_SHADOW_NONE);
#line 471 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_object_set ((GtkAspectFrame*) self, "obey-child", FALSE, NULL);
#line 472 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_object_set ((GtkAspectFrame*) self, "ratio", (gfloat) 1, NULL);
#line 474 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp2_ = (GtkOverlay*) gtk_overlay_new ();
#line 474 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_object_ref_sink (_tmp2_);
#line 474 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_g_object_unref0 (self->priv->overlay);
#line 474 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->overlay = _tmp2_;
#line 475 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp3_ = self->priv->overlay;
#line 475 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp3_);
#line 477 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp4_ = (GtkDrawingArea*) gtk_drawing_area_new ();
#line 477 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_object_ref_sink (_tmp4_);
#line 477 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_g_object_unref0 (self->priv->drawing);
#line 477 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->drawing = _tmp4_;
#line 478 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp5_ = self->priv->drawing;
#line 478 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_signal_connect_object ((GtkWidget*) _tmp5_, "draw", (GCallback) _sudoku_view_draw_board_gtk_widget_draw, self, 0);
#line 480 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp6_ = self->priv->grid;
#line 480 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp6_ != NULL) {
#line 4002 "sudoku-view.c"
		GtkOverlay* _tmp7_ = NULL;
		GtkGrid* _tmp8_ = NULL;
#line 481 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp7_ = self->priv->overlay;
#line 481 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp8_ = self->priv->grid;
#line 481 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		gtk_container_remove ((GtkContainer*) _tmp7_, (GtkWidget*) _tmp8_);
#line 4011 "sudoku-view.c"
	}
#line 483 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp9_ = _data5_->game;
#line 483 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp10_ = _g_object_ref0 (_tmp9_);
#line 483 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_g_object_unref0 (self->game);
#line 483 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->game = _tmp10_;
#line 485 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp11_ = (GtkGrid*) gtk_grid_new ();
#line 485 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_object_ref_sink (_tmp11_);
#line 485 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_g_object_unref0 (self->priv->grid);
#line 485 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->grid = _tmp11_;
#line 486 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp12_ = self->priv->grid;
#line 486 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_grid_set_row_spacing (_tmp12_, 1);
#line 487 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp13_ = self->priv->grid;
#line 487 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_grid_set_column_spacing (_tmp13_, 1);
#line 488 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp14_ = self->priv->grid;
#line 488 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_grid_set_column_homogeneous (_tmp14_, TRUE);
#line 489 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp15_ = self->priv->grid;
#line 489 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_grid_set_row_homogeneous (_tmp15_, TRUE);
#line 491 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp16_ = _data5_->game;
#line 491 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp17_ = _tmp16_->board;
#line 491 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp18_ = sudoku_board_get_rows (_tmp17_);
#line 491 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp19_ = _tmp18_;
#line 491 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp20_ = _data5_->game;
#line 491 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp21_ = _tmp20_->board;
#line 491 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp22_ = sudoku_board_get_cols (_tmp21_);
#line 491 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp23_ = _tmp22_;
#line 491 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp24_ = g_new0 (SudokuCellView*, (_tmp19_ * _tmp23_) + 1);
#line 491 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->cells = (_vala_array_free (self->priv->cells, self->priv->cells_length1 * self->priv->cells_length2, (GDestroyNotify) g_object_unref), NULL);
#line 491 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->cells = _tmp24_;
#line 491 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->cells_length1 = _tmp19_;
#line 491 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->cells_length2 = _tmp23_;
#line 4071 "sudoku-view.c"
	{
		gint row = 0;
#line 492 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		row = 0;
#line 4076 "sudoku-view.c"
		{
			gboolean _tmp25_ = FALSE;
#line 492 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp25_ = TRUE;
#line 492 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			while (TRUE) {
#line 4083 "sudoku-view.c"
				gint _tmp27_ = 0;
				SudokuGame* _tmp28_ = NULL;
				SudokuBoard* _tmp29_ = NULL;
				gint _tmp30_ = 0;
				gint _tmp31_ = 0;
#line 492 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				if (!_tmp25_) {
#line 4091 "sudoku-view.c"
					gint _tmp26_ = 0;
#line 492 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp26_ = row;
#line 492 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					row = _tmp26_ + 1;
#line 4097 "sudoku-view.c"
				}
#line 492 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp25_ = FALSE;
#line 492 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp27_ = row;
#line 492 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp28_ = _data5_->game;
#line 492 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp29_ = _tmp28_->board;
#line 492 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp30_ = sudoku_board_get_rows (_tmp29_);
#line 492 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp31_ = _tmp30_;
#line 492 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				if (!(_tmp27_ < _tmp31_)) {
#line 492 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					break;
#line 4115 "sudoku-view.c"
				}
				{
					gint col = 0;
#line 494 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					col = 0;
#line 4121 "sudoku-view.c"
					{
						gboolean _tmp32_ = FALSE;
#line 494 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						_tmp32_ = TRUE;
#line 494 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						while (TRUE) {
#line 4128 "sudoku-view.c"
							Block6Data* _data6_;
							gint _tmp34_ = 0;
							SudokuGame* _tmp35_ = NULL;
							SudokuBoard* _tmp36_ = NULL;
							gint _tmp37_ = 0;
							gint _tmp38_ = 0;
							SudokuCellView* cell = NULL;
							gint _tmp39_ = 0;
							gint _tmp40_ = 0;
							SudokuCellView* _tmp41_ = NULL;
							gint _tmp42_ = 0;
							gint _tmp43_ = 0;
							GdkRGBA _tmp44_ = {0};
							SudokuCellView* _tmp45_ = NULL;
							gboolean _tmp46_ = FALSE;
							gboolean _tmp47_ = FALSE;
							SudokuCellView* _tmp48_ = NULL;
							SudokuCellView* _tmp49_ = NULL;
							SudokuCellView* _tmp50_ = NULL;
							SudokuCellView** _tmp51_ = NULL;
							gint _tmp51__length1 = 0;
							gint _tmp51__length2 = 0;
							gint _tmp52_ = 0;
							gint _tmp53_ = 0;
							SudokuCellView* _tmp54_ = NULL;
							SudokuCellView* _tmp55_ = NULL;
							SudokuCellView* _tmp56_ = NULL;
							GtkGrid* _tmp57_ = NULL;
							SudokuCellView* _tmp58_ = NULL;
							gint _tmp59_ = 0;
							gint _tmp60_ = 0;
#line 494 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_data6_ = g_slice_new0 (Block6Data);
#line 494 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_data6_->_ref_count_ = 1;
#line 494 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_data6_->_data5_ = block5_data_ref (_data5_);
#line 494 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							if (!_tmp32_) {
#line 4168 "sudoku-view.c"
								gint _tmp33_ = 0;
#line 494 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
								_tmp33_ = col;
#line 494 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
								col = _tmp33_ + 1;
#line 4174 "sudoku-view.c"
							}
#line 494 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp32_ = FALSE;
#line 494 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp34_ = col;
#line 494 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp35_ = _data5_->game;
#line 494 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp36_ = _tmp35_->board;
#line 494 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp37_ = sudoku_board_get_cols (_tmp36_);
#line 494 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp38_ = _tmp37_;
#line 494 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							if (!(_tmp34_ < _tmp38_)) {
#line 494 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
								block6_data_unref (_data6_);
#line 494 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
								_data6_ = NULL;
#line 494 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
								break;
#line 4196 "sudoku-view.c"
							}
#line 496 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp39_ = row;
#line 496 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp40_ = col;
#line 496 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp41_ = sudoku_cell_view_new (_tmp39_, _tmp40_, &self->game);
#line 496 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							g_object_ref_sink (_tmp41_);
#line 496 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							cell = _tmp41_;
#line 497 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp42_ = row;
#line 497 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_data6_->cell_row = _tmp42_;
#line 498 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp43_ = col;
#line 498 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_data6_->cell_col = _tmp43_;
#line 500 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp45_ = cell;
#line 500 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp46_ = sudoku_cell_view_get_is_fixed (_tmp45_);
#line 500 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp47_ = _tmp46_;
#line 500 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							if (_tmp47_) {
#line 500 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
								_tmp44_ = fixed_cell_color;
#line 4226 "sudoku-view.c"
							} else {
#line 500 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
								_tmp44_ = free_cell_color;
#line 4230 "sudoku-view.c"
							}
#line 500 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp48_ = cell;
#line 500 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							sudoku_cell_view_set_background_color (_tmp48_, &_tmp44_);
#line 502 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp49_ = cell;
#line 502 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							g_signal_connect_data ((GtkWidget*) _tmp49_, "focus-in-event", (GCallback) _________lambda13__gtk_widget_focus_in_event, block6_data_ref (_data6_), (GClosureNotify) block6_data_unref, 0);
#line 541 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp50_ = cell;
#line 541 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							g_signal_connect_data ((GObject*) _tmp50_, "notify::value", (GCallback) _________lambda14__g_object_notify, block6_data_ref (_data6_), (GClosureNotify) block6_data_unref, 0);
#line 549 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp51_ = self->priv->cells;
#line 549 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp51__length1 = self->priv->cells_length1;
#line 549 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp51__length2 = self->priv->cells_length2;
#line 549 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp52_ = row;
#line 549 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp53_ = col;
#line 549 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp54_ = cell;
#line 549 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp55_ = _g_object_ref0 (_tmp54_);
#line 549 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_g_object_unref0 (_tmp51_[(_tmp52_ * _tmp51__length2) + _tmp53_]);
#line 549 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp51_[(_tmp52_ * _tmp51__length2) + _tmp53_] = _tmp55_;
#line 549 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp56_ = _tmp51_[(_tmp52_ * _tmp51__length2) + _tmp53_];
#line 550 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp57_ = self->priv->grid;
#line 550 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp58_ = cell;
#line 550 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp59_ = col;
#line 550 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp60_ = row;
#line 550 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							gtk_grid_attach (_tmp57_, (GtkWidget*) _tmp58_, _tmp59_, _tmp60_, 1, 1);
#line 494 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_g_object_unref0 (cell);
#line 494 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							block6_data_unref (_data6_);
#line 494 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_data6_ = NULL;
#line 4280 "sudoku-view.c"
						}
					}
				}
			}
		}
	}
#line 554 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp61_ = self->priv->overlay;
#line 554 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp62_ = self->priv->drawing;
#line 554 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_container_add ((GtkContainer*) _tmp61_, (GtkWidget*) _tmp62_);
#line 555 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp63_ = self->priv->overlay;
#line 555 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp64_ = self->priv->grid;
#line 555 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_overlay_add_overlay (_tmp63_, (GtkWidget*) _tmp64_);
#line 556 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp65_ = self->priv->drawing;
#line 556 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_widget_show ((GtkWidget*) _tmp65_);
#line 557 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp66_ = self->priv->grid;
#line 557 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_widget_show_all ((GtkWidget*) _tmp66_);
#line 558 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp67_ = self->priv->overlay;
#line 558 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_widget_show ((GtkWidget*) _tmp67_);
#line 468 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	block5_data_unref (_data5_);
#line 468 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_data5_ = NULL;
#line 468 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	return self;
#line 4317 "sudoku-view.c"
}


SudokuView* sudoku_view_new (SudokuGame* game) {
#line 468 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	return sudoku_view_construct (TYPE_SUDOKU_VIEW, game);
#line 4324 "sudoku-view.c"
}


static gboolean sudoku_view_draw_board (SudokuView* self, cairo_t* c) {
	gboolean result = FALSE;
	gint board_length = 0;
	GtkGrid* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gdouble tile_length = 0.0;
	gint _tmp2_ = 0;
	SudokuGame* _tmp3_ = NULL;
	SudokuBoard* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	GtkTextDirection _tmp7_ = 0;
	cairo_t* _tmp48_ = NULL;
	cairo_t* _tmp49_ = NULL;
	cairo_t* _tmp88_ = NULL;
	cairo_t* _tmp89_ = NULL;
	cairo_t* _tmp126_ = NULL;
	SudokuGame* _tmp127_ = NULL;
	gboolean _tmp128_ = FALSE;
	gboolean _tmp129_ = FALSE;
#line 561 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 561 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_val_if_fail (c != NULL, FALSE);
#line 563 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = self->priv->grid;
#line 563 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp1_ = gtk_widget_get_allocated_width ((GtkWidget*) _tmp0_);
#line 563 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	board_length = _tmp1_;
#line 565 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp2_ = board_length;
#line 565 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp3_ = self->game;
#line 565 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp4_ = _tmp3_->board;
#line 565 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp5_ = sudoku_board_get_cols (_tmp4_);
#line 565 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp6_ = _tmp5_;
#line 565 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	tile_length = ((gdouble) (_tmp2_ - 1)) / _tmp6_;
#line 567 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp7_ = gtk_widget_get_default_direction ();
#line 567 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp7_ == GTK_TEXT_DIR_RTL) {
#line 4374 "sudoku-view.c"
		cairo_t* _tmp8_ = NULL;
		gint _tmp9_ = 0;
		cairo_t* _tmp10_ = NULL;
#line 569 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp8_ = c;
#line 569 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp9_ = board_length;
#line 569 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		cairo_translate (_tmp8_, (gdouble) _tmp9_, (gdouble) 0);
#line 570 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp10_ = c;
#line 570 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		cairo_scale (_tmp10_, (gdouble) (-1), (gdouble) 1);
#line 4388 "sudoku-view.c"
	}
	{
		gint i = 0;
#line 574 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		i = 0;
#line 4394 "sudoku-view.c"
		{
			gboolean _tmp11_ = FALSE;
#line 574 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp11_ = TRUE;
#line 574 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			while (TRUE) {
#line 4401 "sudoku-view.c"
				gint _tmp13_ = 0;
				SudokuGame* _tmp14_ = NULL;
				SudokuBoard* _tmp15_ = NULL;
				gint _tmp16_ = 0;
				gint _tmp17_ = 0;
#line 574 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				if (!_tmp11_) {
#line 4409 "sudoku-view.c"
					gint _tmp12_ = 0;
#line 574 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp12_ = i;
#line 574 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					i = _tmp12_ + 1;
#line 4415 "sudoku-view.c"
				}
#line 574 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp11_ = FALSE;
#line 574 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp13_ = i;
#line 574 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp14_ = self->game;
#line 574 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp15_ = _tmp14_->board;
#line 574 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp16_ = sudoku_board_get_cols (_tmp15_);
#line 574 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp17_ = _tmp16_;
#line 574 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				if (!(_tmp13_ < _tmp17_)) {
#line 574 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					break;
#line 4433 "sudoku-view.c"
				}
				{
					gint j = 0;
#line 576 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					j = 0;
#line 4439 "sudoku-view.c"
					{
						gboolean _tmp18_ = FALSE;
#line 576 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						_tmp18_ = TRUE;
#line 576 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						while (TRUE) {
#line 4446 "sudoku-view.c"
							gint _tmp20_ = 0;
							SudokuGame* _tmp21_ = NULL;
							SudokuBoard* _tmp22_ = NULL;
							gint _tmp23_ = 0;
							gint _tmp24_ = 0;
							GdkRGBA background_color = {0};
							SudokuCellView** _tmp25_ = NULL;
							gint _tmp25__length1 = 0;
							gint _tmp25__length2 = 0;
							gint _tmp26_ = 0;
							gint _tmp27_ = 0;
							SudokuCellView* _tmp28_ = NULL;
							GdkRGBA _tmp29_ = {0};
							GdkRGBA _tmp30_ = {0};
							cairo_t* _tmp31_ = NULL;
							GdkRGBA _tmp32_ = {0};
							gdouble _tmp33_ = 0.0;
							GdkRGBA _tmp34_ = {0};
							gdouble _tmp35_ = 0.0;
							GdkRGBA _tmp36_ = {0};
							gdouble _tmp37_ = 0.0;
							cairo_t* _tmp38_ = NULL;
							gint _tmp39_ = 0;
							gdouble _tmp40_ = 0.0;
							gint _tmp41_ = 0;
							gdouble _tmp42_ = 0.0;
							gint _tmp43_ = 0;
							gdouble _tmp44_ = 0.0;
							gint _tmp45_ = 0;
							gdouble _tmp46_ = 0.0;
							cairo_t* _tmp47_ = NULL;
#line 576 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							if (!_tmp18_) {
#line 4480 "sudoku-view.c"
								gint _tmp19_ = 0;
#line 576 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
								_tmp19_ = j;
#line 576 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
								j = _tmp19_ + 1;
#line 4486 "sudoku-view.c"
							}
#line 576 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp18_ = FALSE;
#line 576 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp20_ = j;
#line 576 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp21_ = self->game;
#line 576 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp22_ = _tmp21_->board;
#line 576 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp23_ = sudoku_board_get_cols (_tmp22_);
#line 576 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp24_ = _tmp23_;
#line 576 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							if (!(_tmp20_ < _tmp24_)) {
#line 576 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
								break;
#line 4504 "sudoku-view.c"
							}
#line 578 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp25_ = self->priv->cells;
#line 578 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp25__length1 = self->priv->cells_length1;
#line 578 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp25__length2 = self->priv->cells_length2;
#line 578 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp26_ = i;
#line 578 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp27_ = j;
#line 578 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp28_ = _tmp25_[(_tmp26_ * _tmp25__length2) + _tmp27_];
#line 578 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							sudoku_cell_view_get_background_color (_tmp28_, &_tmp29_);
#line 578 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp30_ = _tmp29_;
#line 578 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							background_color = _tmp30_;
#line 579 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp31_ = c;
#line 579 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp32_ = background_color;
#line 579 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp33_ = _tmp32_.red;
#line 579 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp34_ = background_color;
#line 579 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp35_ = _tmp34_.green;
#line 579 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp36_ = background_color;
#line 579 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp37_ = _tmp36_.blue;
#line 579 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							cairo_set_source_rgb (_tmp31_, _tmp33_, _tmp35_, _tmp37_);
#line 581 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp38_ = c;
#line 581 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp39_ = j;
#line 581 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp40_ = tile_length;
#line 581 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp41_ = i;
#line 581 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp42_ = tile_length;
#line 581 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp43_ = j;
#line 581 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp44_ = tile_length;
#line 581 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp45_ = i;
#line 581 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp46_ = tile_length;
#line 581 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							cairo_rectangle (_tmp38_, ((gint) (_tmp39_ * _tmp40_)) + 0.5, ((gint) (_tmp41_ * _tmp42_)) + 0.5, ((gint) ((_tmp43_ + 1) * _tmp44_)) + 0.5, ((gint) ((_tmp45_ + 1) * _tmp46_)) + 0.5);
#line 582 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp47_ = c;
#line 582 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							cairo_fill (_tmp47_);
#line 4564 "sudoku-view.c"
						}
					}
				}
			}
		}
	}
#line 586 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp48_ = c;
#line 586 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	cairo_set_line_width (_tmp48_, (gdouble) 1);
#line 587 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp49_ = c;
#line 587 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	cairo_set_source_rgb (_tmp49_, 0.6, 0.6, 0.6);
#line 4579 "sudoku-view.c"
	{
		gint i = 0;
#line 588 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		i = 1;
#line 4584 "sudoku-view.c"
		{
			gboolean _tmp50_ = FALSE;
#line 588 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp50_ = TRUE;
#line 588 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			while (TRUE) {
#line 4591 "sudoku-view.c"
				gint _tmp52_ = 0;
				SudokuGame* _tmp53_ = NULL;
				SudokuBoard* _tmp54_ = NULL;
				gint _tmp55_ = 0;
				gint _tmp56_ = 0;
				gint _tmp57_ = 0;
				SudokuGame* _tmp58_ = NULL;
				SudokuBoard* _tmp59_ = NULL;
				gint _tmp60_ = 0;
				gint _tmp61_ = 0;
				cairo_t* _tmp62_ = NULL;
				gint _tmp63_ = 0;
				gdouble _tmp64_ = 0.0;
				cairo_t* _tmp65_ = NULL;
				gint _tmp66_ = 0;
				gdouble _tmp67_ = 0.0;
				gint _tmp68_ = 0;
#line 588 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				if (!_tmp50_) {
#line 4611 "sudoku-view.c"
					gint _tmp51_ = 0;
#line 588 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp51_ = i;
#line 588 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					i = _tmp51_ + 1;
#line 4617 "sudoku-view.c"
				}
#line 588 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp50_ = FALSE;
#line 588 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp52_ = i;
#line 588 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp53_ = self->game;
#line 588 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp54_ = _tmp53_->board;
#line 588 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp55_ = sudoku_board_get_cols (_tmp54_);
#line 588 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp56_ = _tmp55_;
#line 588 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				if (!(_tmp52_ < _tmp56_)) {
#line 588 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					break;
#line 4635 "sudoku-view.c"
				}
#line 590 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp57_ = i;
#line 590 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp58_ = self->game;
#line 590 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp59_ = _tmp58_->board;
#line 590 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp60_ = sudoku_board_get_block_cols (_tmp59_);
#line 590 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp61_ = _tmp60_;
#line 590 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				if ((_tmp57_ % _tmp61_) == 0) {
#line 591 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					continue;
#line 4651 "sudoku-view.c"
				}
#line 593 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp62_ = c;
#line 593 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp63_ = i;
#line 593 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp64_ = tile_length;
#line 593 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				cairo_move_to (_tmp62_, ((gint) (_tmp63_ * _tmp64_)) + 0.5, (gdouble) 1);
#line 594 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp65_ = c;
#line 594 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp66_ = i;
#line 594 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp67_ = tile_length;
#line 594 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp68_ = board_length;
#line 594 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				cairo_line_to (_tmp65_, ((gint) (_tmp66_ * _tmp67_)) + 0.5, (gdouble) _tmp68_);
#line 4671 "sudoku-view.c"
			}
		}
	}
	{
		gint i = 0;
#line 596 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		i = 1;
#line 4679 "sudoku-view.c"
		{
			gboolean _tmp69_ = FALSE;
#line 596 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp69_ = TRUE;
#line 596 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			while (TRUE) {
#line 4686 "sudoku-view.c"
				gint _tmp71_ = 0;
				SudokuGame* _tmp72_ = NULL;
				SudokuBoard* _tmp73_ = NULL;
				gint _tmp74_ = 0;
				gint _tmp75_ = 0;
				gint _tmp76_ = 0;
				SudokuGame* _tmp77_ = NULL;
				SudokuBoard* _tmp78_ = NULL;
				gint _tmp79_ = 0;
				gint _tmp80_ = 0;
				cairo_t* _tmp81_ = NULL;
				gint _tmp82_ = 0;
				gdouble _tmp83_ = 0.0;
				cairo_t* _tmp84_ = NULL;
				gint _tmp85_ = 0;
				gint _tmp86_ = 0;
				gdouble _tmp87_ = 0.0;
#line 596 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				if (!_tmp69_) {
#line 4706 "sudoku-view.c"
					gint _tmp70_ = 0;
#line 596 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp70_ = i;
#line 596 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					i = _tmp70_ + 1;
#line 4712 "sudoku-view.c"
				}
#line 596 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp69_ = FALSE;
#line 596 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp71_ = i;
#line 596 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp72_ = self->game;
#line 596 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp73_ = _tmp72_->board;
#line 596 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp74_ = sudoku_board_get_cols (_tmp73_);
#line 596 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp75_ = _tmp74_;
#line 596 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				if (!(_tmp71_ < _tmp75_)) {
#line 596 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					break;
#line 4730 "sudoku-view.c"
				}
#line 598 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp76_ = i;
#line 598 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp77_ = self->game;
#line 598 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp78_ = _tmp77_->board;
#line 598 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp79_ = sudoku_board_get_block_rows (_tmp78_);
#line 598 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp80_ = _tmp79_;
#line 598 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				if ((_tmp76_ % _tmp80_) == 0) {
#line 599 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					continue;
#line 4746 "sudoku-view.c"
				}
#line 601 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp81_ = c;
#line 601 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp82_ = i;
#line 601 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp83_ = tile_length;
#line 601 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				cairo_move_to (_tmp81_, (gdouble) 1, ((gint) (_tmp82_ * _tmp83_)) + 0.5);
#line 602 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp84_ = c;
#line 602 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp85_ = board_length;
#line 602 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp86_ = i;
#line 602 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp87_ = tile_length;
#line 602 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				cairo_line_to (_tmp84_, (gdouble) _tmp85_, ((gint) (_tmp86_ * _tmp87_)) + 0.5);
#line 4766 "sudoku-view.c"
			}
		}
	}
#line 604 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp88_ = c;
#line 604 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	cairo_stroke (_tmp88_);
#line 606 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp89_ = c;
#line 606 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	cairo_set_source_rgb (_tmp89_, 0.0, 0.0, 0.0);
#line 4778 "sudoku-view.c"
	{
		gint i = 0;
#line 607 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		i = 0;
#line 4783 "sudoku-view.c"
		{
			gboolean _tmp90_ = FALSE;
#line 607 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp90_ = TRUE;
#line 607 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			while (TRUE) {
#line 4790 "sudoku-view.c"
				gint _tmp96_ = 0;
				SudokuGame* _tmp97_ = NULL;
				SudokuBoard* _tmp98_ = NULL;
				gint _tmp99_ = 0;
				gint _tmp100_ = 0;
				cairo_t* _tmp101_ = NULL;
				gint _tmp102_ = 0;
				gdouble _tmp103_ = 0.0;
				cairo_t* _tmp104_ = NULL;
				gint _tmp105_ = 0;
				gdouble _tmp106_ = 0.0;
				gint _tmp107_ = 0;
#line 607 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				if (!_tmp90_) {
#line 4805 "sudoku-view.c"
					gint _tmp91_ = 0;
					SudokuGame* _tmp92_ = NULL;
					SudokuBoard* _tmp93_ = NULL;
					gint _tmp94_ = 0;
					gint _tmp95_ = 0;
#line 607 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp91_ = i;
#line 607 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp92_ = self->game;
#line 607 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp93_ = _tmp92_->board;
#line 607 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp94_ = sudoku_board_get_block_cols (_tmp93_);
#line 607 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp95_ = _tmp94_;
#line 607 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					i = _tmp91_ + _tmp95_;
#line 4823 "sudoku-view.c"
				}
#line 607 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp90_ = FALSE;
#line 607 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp96_ = i;
#line 607 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp97_ = self->game;
#line 607 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp98_ = _tmp97_->board;
#line 607 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp99_ = sudoku_board_get_cols (_tmp98_);
#line 607 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp100_ = _tmp99_;
#line 607 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				if (!(_tmp96_ <= _tmp100_)) {
#line 607 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					break;
#line 4841 "sudoku-view.c"
				}
#line 609 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp101_ = c;
#line 609 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp102_ = i;
#line 609 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp103_ = tile_length;
#line 609 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				cairo_move_to (_tmp101_, ((gint) (_tmp102_ * _tmp103_)) + 0.5, (gdouble) 0);
#line 610 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp104_ = c;
#line 610 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp105_ = i;
#line 610 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp106_ = tile_length;
#line 610 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp107_ = board_length;
#line 610 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				cairo_line_to (_tmp104_, ((gint) (_tmp105_ * _tmp106_)) + 0.5, (gdouble) _tmp107_);
#line 4861 "sudoku-view.c"
			}
		}
	}
	{
		gint i = 0;
#line 612 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		i = 0;
#line 4869 "sudoku-view.c"
		{
			gboolean _tmp108_ = FALSE;
#line 612 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp108_ = TRUE;
#line 612 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			while (TRUE) {
#line 4876 "sudoku-view.c"
				gint _tmp114_ = 0;
				SudokuGame* _tmp115_ = NULL;
				SudokuBoard* _tmp116_ = NULL;
				gint _tmp117_ = 0;
				gint _tmp118_ = 0;
				cairo_t* _tmp119_ = NULL;
				gint _tmp120_ = 0;
				gdouble _tmp121_ = 0.0;
				cairo_t* _tmp122_ = NULL;
				gint _tmp123_ = 0;
				gint _tmp124_ = 0;
				gdouble _tmp125_ = 0.0;
#line 612 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				if (!_tmp108_) {
#line 4891 "sudoku-view.c"
					gint _tmp109_ = 0;
					SudokuGame* _tmp110_ = NULL;
					SudokuBoard* _tmp111_ = NULL;
					gint _tmp112_ = 0;
					gint _tmp113_ = 0;
#line 612 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp109_ = i;
#line 612 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp110_ = self->game;
#line 612 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp111_ = _tmp110_->board;
#line 612 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp112_ = sudoku_board_get_block_rows (_tmp111_);
#line 612 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp113_ = _tmp112_;
#line 612 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					i = _tmp109_ + _tmp113_;
#line 4909 "sudoku-view.c"
				}
#line 612 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp108_ = FALSE;
#line 612 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp114_ = i;
#line 612 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp115_ = self->game;
#line 612 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp116_ = _tmp115_->board;
#line 612 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp117_ = sudoku_board_get_cols (_tmp116_);
#line 612 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp118_ = _tmp117_;
#line 612 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				if (!(_tmp114_ <= _tmp118_)) {
#line 612 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					break;
#line 4927 "sudoku-view.c"
				}
#line 614 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp119_ = c;
#line 614 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp120_ = i;
#line 614 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp121_ = tile_length;
#line 614 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				cairo_move_to (_tmp119_, (gdouble) 0, ((gint) (_tmp120_ * _tmp121_)) + 0.5);
#line 615 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp122_ = c;
#line 615 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp123_ = board_length;
#line 615 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp124_ = i;
#line 615 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp125_ = tile_length;
#line 615 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				cairo_line_to (_tmp122_, (gdouble) _tmp123_, ((gint) (_tmp124_ * _tmp125_)) + 0.5);
#line 4947 "sudoku-view.c"
			}
		}
	}
#line 617 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp126_ = c;
#line 617 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	cairo_stroke (_tmp126_);
#line 619 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp127_ = self->game;
#line 619 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp128_ = sudoku_game_get_paused (_tmp127_);
#line 619 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp129_ = _tmp128_;
#line 619 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp129_) {
#line 4963 "sudoku-view.c"
		cairo_t* _tmp130_ = NULL;
		cairo_t* _tmp131_ = NULL;
		cairo_t* _tmp132_ = NULL;
		cairo_t* _tmp133_ = NULL;
		gint _tmp134_ = 0;
		gchar* text = NULL;
		const gchar* _tmp135_ = NULL;
		gchar* _tmp136_ = NULL;
		cairo_text_extents_t extents = {0};
		cairo_t* _tmp137_ = NULL;
		const gchar* _tmp138_ = NULL;
		cairo_text_extents_t _tmp139_ = {0};
		cairo_t* _tmp140_ = NULL;
		gint _tmp141_ = 0;
		cairo_text_extents_t _tmp142_ = {0};
		gdouble _tmp143_ = 0.0;
		gint _tmp144_ = 0;
		cairo_text_extents_t _tmp145_ = {0};
		gdouble _tmp146_ = 0.0;
		cairo_t* _tmp147_ = NULL;
		cairo_t* _tmp148_ = NULL;
		const gchar* _tmp149_ = NULL;
#line 621 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp130_ = c;
#line 621 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		cairo_set_source_rgba (_tmp130_, (gdouble) 0, (gdouble) 0, (gdouble) 0, 0.75);
#line 622 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp131_ = c;
#line 622 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		cairo_paint (_tmp131_);
#line 624 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp132_ = c;
#line 624 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		cairo_select_font_face (_tmp132_, "Sans", CAIRO_FONT_SLANT_NORMAL, CAIRO_FONT_WEIGHT_BOLD);
#line 625 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp133_ = c;
#line 625 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp134_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
#line 625 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		cairo_set_font_size (_tmp133_, _tmp134_ * 0.125);
#line 628 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp135_ = _ ("Paused");
#line 628 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp136_ = g_strdup (_tmp135_);
#line 628 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		text = _tmp136_;
#line 630 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp137_ = c;
#line 630 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp138_ = text;
#line 630 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		cairo_text_extents (_tmp137_, _tmp138_, &_tmp139_);
#line 630 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		extents = _tmp139_;
#line 631 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp140_ = c;
#line 631 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp141_ = board_length;
#line 631 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp142_ = extents;
#line 631 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp143_ = _tmp142_.width;
#line 631 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp144_ = board_length;
#line 631 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp145_ = extents;
#line 631 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp146_ = _tmp145_.height;
#line 631 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		cairo_move_to (_tmp140_, (_tmp141_ / 2.0) - (_tmp143_ / 2.0), (_tmp144_ / 2.0) + (_tmp146_ / 2.0));
#line 632 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp147_ = c;
#line 632 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		cairo_set_source_rgb (_tmp147_, (gdouble) 1, (gdouble) 1, (gdouble) 1);
#line 633 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp148_ = c;
#line 633 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp149_ = text;
#line 633 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		cairo_show_text (_tmp148_, _tmp149_);
#line 619 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_g_free0 (text);
#line 5046 "sudoku-view.c"
	}
#line 636 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	result = FALSE;
#line 636 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	return result;
#line 5052 "sudoku-view.c"
}


void sudoku_view_clear (SudokuView* self) {
#line 639 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_if_fail (self != NULL);
#line 5059 "sudoku-view.c"
	{
		gint i = 0;
#line 641 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		i = 0;
#line 5064 "sudoku-view.c"
		{
			gboolean _tmp0_ = FALSE;
#line 641 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp0_ = TRUE;
#line 641 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			while (TRUE) {
#line 5071 "sudoku-view.c"
				gint _tmp2_ = 0;
				SudokuGame* _tmp3_ = NULL;
				SudokuBoard* _tmp4_ = NULL;
				gint _tmp5_ = 0;
				gint _tmp6_ = 0;
#line 641 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				if (!_tmp0_) {
#line 5079 "sudoku-view.c"
					gint _tmp1_ = 0;
#line 641 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp1_ = i;
#line 641 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					i = _tmp1_ + 1;
#line 5085 "sudoku-view.c"
				}
#line 641 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp0_ = FALSE;
#line 641 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp2_ = i;
#line 641 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp3_ = self->game;
#line 641 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp4_ = _tmp3_->board;
#line 641 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp5_ = sudoku_board_get_rows (_tmp4_);
#line 641 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp6_ = _tmp5_;
#line 641 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				if (!(_tmp2_ < _tmp6_)) {
#line 641 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					break;
#line 5103 "sudoku-view.c"
				}
				{
					gint j = 0;
#line 642 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					j = 0;
#line 5109 "sudoku-view.c"
					{
						gboolean _tmp7_ = FALSE;
#line 642 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						_tmp7_ = TRUE;
#line 642 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						while (TRUE) {
#line 5116 "sudoku-view.c"
							gint _tmp9_ = 0;
							SudokuGame* _tmp10_ = NULL;
							SudokuBoard* _tmp11_ = NULL;
							gint _tmp12_ = 0;
							gint _tmp13_ = 0;
							SudokuCellView** _tmp14_ = NULL;
							gint _tmp14__length1 = 0;
							gint _tmp14__length2 = 0;
							gint _tmp15_ = 0;
							gint _tmp16_ = 0;
							SudokuCellView* _tmp17_ = NULL;
#line 642 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							if (!_tmp7_) {
#line 5130 "sudoku-view.c"
								gint _tmp8_ = 0;
#line 642 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
								_tmp8_ = j;
#line 642 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
								j = _tmp8_ + 1;
#line 5136 "sudoku-view.c"
							}
#line 642 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp7_ = FALSE;
#line 642 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp9_ = j;
#line 642 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp10_ = self->game;
#line 642 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp11_ = _tmp10_->board;
#line 642 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp12_ = sudoku_board_get_cols (_tmp11_);
#line 642 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp13_ = _tmp12_;
#line 642 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							if (!(_tmp9_ < _tmp13_)) {
#line 642 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
								break;
#line 5154 "sudoku-view.c"
							}
#line 643 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp14_ = self->priv->cells;
#line 643 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp14__length1 = self->priv->cells_length1;
#line 643 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp14__length2 = self->priv->cells_length2;
#line 643 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp15_ = i;
#line 643 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp16_ = j;
#line 643 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp17_ = _tmp14_[(_tmp15_ * _tmp14__length2) + _tmp16_];
#line 643 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							sudoku_cell_view_clear (_tmp17_);
#line 5170 "sudoku-view.c"
						}
					}
				}
			}
		}
	}
}


gboolean sudoku_view_get_show_warnings (SudokuView* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 649 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 649 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = self->priv->_show_warnings;
#line 649 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	result = _tmp0_;
#line 649 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	return result;
#line 5191 "sudoku-view.c"
}


void sudoku_view_set_show_warnings (SudokuView* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 650 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_if_fail (self != NULL);
#line 651 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = value;
#line 651 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->_show_warnings = _tmp0_;
#line 5203 "sudoku-view.c"
	{
		gint i = 0;
#line 652 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		i = 0;
#line 5208 "sudoku-view.c"
		{
			gboolean _tmp1_ = FALSE;
#line 652 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp1_ = TRUE;
#line 652 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			while (TRUE) {
#line 5215 "sudoku-view.c"
				gint _tmp3_ = 0;
				SudokuGame* _tmp4_ = NULL;
				SudokuBoard* _tmp5_ = NULL;
				gint _tmp6_ = 0;
				gint _tmp7_ = 0;
#line 652 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				if (!_tmp1_) {
#line 5223 "sudoku-view.c"
					gint _tmp2_ = 0;
#line 652 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp2_ = i;
#line 652 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					i = _tmp2_ + 1;
#line 5229 "sudoku-view.c"
				}
#line 652 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp1_ = FALSE;
#line 652 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp3_ = i;
#line 652 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp4_ = self->game;
#line 652 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp5_ = _tmp4_->board;
#line 652 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp6_ = sudoku_board_get_rows (_tmp5_);
#line 652 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp7_ = _tmp6_;
#line 652 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				if (!(_tmp3_ < _tmp7_)) {
#line 652 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					break;
#line 5247 "sudoku-view.c"
				}
				{
					gint j = 0;
#line 653 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					j = 0;
#line 5253 "sudoku-view.c"
					{
						gboolean _tmp8_ = FALSE;
#line 653 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						_tmp8_ = TRUE;
#line 653 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						while (TRUE) {
#line 5260 "sudoku-view.c"
							gint _tmp10_ = 0;
							SudokuGame* _tmp11_ = NULL;
							SudokuBoard* _tmp12_ = NULL;
							gint _tmp13_ = 0;
							gint _tmp14_ = 0;
							SudokuCellView** _tmp15_ = NULL;
							gint _tmp15__length1 = 0;
							gint _tmp15__length2 = 0;
							gint _tmp16_ = 0;
							gint _tmp17_ = 0;
							SudokuCellView* _tmp18_ = NULL;
							gboolean _tmp19_ = FALSE;
#line 653 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							if (!_tmp8_) {
#line 5275 "sudoku-view.c"
								gint _tmp9_ = 0;
#line 653 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
								_tmp9_ = j;
#line 653 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
								j = _tmp9_ + 1;
#line 5281 "sudoku-view.c"
							}
#line 653 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp8_ = FALSE;
#line 653 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp10_ = j;
#line 653 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp11_ = self->game;
#line 653 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp12_ = _tmp11_->board;
#line 653 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp13_ = sudoku_board_get_cols (_tmp12_);
#line 653 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp14_ = _tmp13_;
#line 653 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							if (!(_tmp10_ < _tmp14_)) {
#line 653 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
								break;
#line 5299 "sudoku-view.c"
							}
#line 654 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp15_ = self->priv->cells;
#line 654 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp15__length1 = self->priv->cells_length1;
#line 654 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp15__length2 = self->priv->cells_length2;
#line 654 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp16_ = i;
#line 654 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp17_ = j;
#line 654 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp18_ = _tmp15_[(_tmp16_ * _tmp15__length2) + _tmp17_];
#line 654 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp19_ = self->priv->_show_warnings;
#line 654 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							sudoku_cell_view_set_show_warnings (_tmp18_, _tmp19_);
#line 5317 "sudoku-view.c"
						}
					}
				}
			}
		}
	}
#line 650 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_object_notify ((GObject *) self, "show-warnings");
#line 5326 "sudoku-view.c"
}


gboolean sudoku_view_get_show_possibilities (SudokuView* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 661 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 661 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = self->priv->_show_possibilities;
#line 661 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	result = _tmp0_;
#line 661 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	return result;
#line 5341 "sudoku-view.c"
}


void sudoku_view_set_show_possibilities (SudokuView* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 662 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_if_fail (self != NULL);
#line 663 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = value;
#line 663 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->_show_possibilities = _tmp0_;
#line 5353 "sudoku-view.c"
	{
		gint i = 0;
#line 664 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		i = 0;
#line 5358 "sudoku-view.c"
		{
			gboolean _tmp1_ = FALSE;
#line 664 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp1_ = TRUE;
#line 664 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			while (TRUE) {
#line 5365 "sudoku-view.c"
				gint _tmp3_ = 0;
				SudokuGame* _tmp4_ = NULL;
				SudokuBoard* _tmp5_ = NULL;
				gint _tmp6_ = 0;
				gint _tmp7_ = 0;
#line 664 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				if (!_tmp1_) {
#line 5373 "sudoku-view.c"
					gint _tmp2_ = 0;
#line 664 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp2_ = i;
#line 664 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					i = _tmp2_ + 1;
#line 5379 "sudoku-view.c"
				}
#line 664 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp1_ = FALSE;
#line 664 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp3_ = i;
#line 664 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp4_ = self->game;
#line 664 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp5_ = _tmp4_->board;
#line 664 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp6_ = sudoku_board_get_rows (_tmp5_);
#line 664 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp7_ = _tmp6_;
#line 664 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				if (!(_tmp3_ < _tmp7_)) {
#line 664 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					break;
#line 5397 "sudoku-view.c"
				}
				{
					gint j = 0;
#line 665 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					j = 0;
#line 5403 "sudoku-view.c"
					{
						gboolean _tmp8_ = FALSE;
#line 665 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						_tmp8_ = TRUE;
#line 665 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						while (TRUE) {
#line 5410 "sudoku-view.c"
							gint _tmp10_ = 0;
							SudokuGame* _tmp11_ = NULL;
							SudokuBoard* _tmp12_ = NULL;
							gint _tmp13_ = 0;
							gint _tmp14_ = 0;
							SudokuCellView** _tmp15_ = NULL;
							gint _tmp15__length1 = 0;
							gint _tmp15__length2 = 0;
							gint _tmp16_ = 0;
							gint _tmp17_ = 0;
							SudokuCellView* _tmp18_ = NULL;
							gboolean _tmp19_ = FALSE;
#line 665 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							if (!_tmp8_) {
#line 5425 "sudoku-view.c"
								gint _tmp9_ = 0;
#line 665 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
								_tmp9_ = j;
#line 665 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
								j = _tmp9_ + 1;
#line 5431 "sudoku-view.c"
							}
#line 665 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp8_ = FALSE;
#line 665 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp10_ = j;
#line 665 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp11_ = self->game;
#line 665 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp12_ = _tmp11_->board;
#line 665 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp13_ = sudoku_board_get_cols (_tmp12_);
#line 665 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp14_ = _tmp13_;
#line 665 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							if (!(_tmp10_ < _tmp14_)) {
#line 665 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
								break;
#line 5449 "sudoku-view.c"
							}
#line 666 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp15_ = self->priv->cells;
#line 666 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp15__length1 = self->priv->cells_length1;
#line 666 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp15__length2 = self->priv->cells_length2;
#line 666 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp16_ = i;
#line 666 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp17_ = j;
#line 666 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp18_ = _tmp15_[(_tmp16_ * _tmp15__length2) + _tmp17_];
#line 666 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp19_ = value;
#line 666 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							sudoku_cell_view_set_show_possibilities (_tmp18_, _tmp19_);
#line 5467 "sudoku-view.c"
						}
					}
				}
			}
		}
	}
#line 662 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_object_notify ((GObject *) self, "show-possibilities");
#line 5476 "sudoku-view.c"
}


gboolean sudoku_view_get_highlighter (SudokuView* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 673 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 673 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = self->priv->_highlighter;
#line 673 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	result = _tmp0_;
#line 673 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	return result;
#line 5491 "sudoku-view.c"
}


void sudoku_view_set_highlighter (SudokuView* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 674 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_if_fail (self != NULL);
#line 675 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = value;
#line 675 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->_highlighter = _tmp0_;
#line 674 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_object_notify ((GObject *) self, "highlighter");
#line 5505 "sudoku-view.c"
}


static void sudoku_view_class_init (SudokuViewClass * klass) {
#line 446 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	sudoku_view_parent_class = g_type_class_peek_parent (klass);
#line 446 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_type_class_add_private (klass, sizeof (SudokuViewPrivate));
#line 446 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_sudoku_view_get_property;
#line 446 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_sudoku_view_set_property;
#line 446 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	G_OBJECT_CLASS (klass)->finalize = sudoku_view_finalize;
#line 446 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_VIEW_SHOW_WARNINGS, g_param_spec_boolean ("show-warnings", "show-warnings", "show-warnings", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 446 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_VIEW_SHOW_POSSIBILITIES, g_param_spec_boolean ("show-possibilities", "show-possibilities", "show-possibilities", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 446 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_VIEW_HIGHLIGHTER, g_param_spec_boolean ("highlighter", "highlighter", "highlighter", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 5526 "sudoku-view.c"
}


static void sudoku_view_instance_init (SudokuView * self) {
#line 446 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv = SUDOKU_VIEW_GET_PRIVATE (self);
#line 451 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->previous_board_broken_state = FALSE;
#line 457 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->selected_row = 0;
#line 458 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->selected_col = 0;
#line 646 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->_show_warnings = FALSE;
#line 658 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->_show_possibilities = FALSE;
#line 670 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->_highlighter = FALSE;
#line 5545 "sudoku-view.c"
}


static void sudoku_view_finalize (GObject* obj) {
	SudokuView * self;
#line 446 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SUDOKU_VIEW, SudokuView);
#line 448 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_g_object_unref0 (self->game);
#line 449 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->cells = (_vala_array_free (self->priv->cells, self->priv->cells_length1 * self->priv->cells_length2, (GDestroyNotify) g_object_unref), NULL);
#line 453 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_g_object_unref0 (self->priv->overlay);
#line 454 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_g_object_unref0 (self->priv->drawing);
#line 455 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_g_object_unref0 (self->priv->grid);
#line 446 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	G_OBJECT_CLASS (sudoku_view_parent_class)->finalize (obj);
#line 5565 "sudoku-view.c"
}


GType sudoku_view_get_type (void) {
	static volatile gsize sudoku_view_type_id__volatile = 0;
	if (g_once_init_enter (&sudoku_view_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SudokuViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sudoku_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SudokuView), 0, (GInstanceInitFunc) sudoku_view_instance_init, NULL };
		GType sudoku_view_type_id;
		sudoku_view_type_id = g_type_register_static (gtk_aspect_frame_get_type (), "SudokuView", &g_define_type_info, 0);
		g_once_init_leave (&sudoku_view_type_id__volatile, sudoku_view_type_id);
	}
	return sudoku_view_type_id__volatile;
}


static void _vala_sudoku_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SudokuView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SUDOKU_VIEW, SudokuView);
#line 446 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	switch (property_id) {
#line 446 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		case SUDOKU_VIEW_SHOW_WARNINGS:
#line 446 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		g_value_set_boolean (value, sudoku_view_get_show_warnings (self));
#line 446 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		break;
#line 446 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		case SUDOKU_VIEW_SHOW_POSSIBILITIES:
#line 446 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		g_value_set_boolean (value, sudoku_view_get_show_possibilities (self));
#line 446 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		break;
#line 446 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		case SUDOKU_VIEW_HIGHLIGHTER:
#line 446 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		g_value_set_boolean (value, sudoku_view_get_highlighter (self));
#line 446 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		break;
#line 5604 "sudoku-view.c"
		default:
#line 446 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 446 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		break;
#line 5610 "sudoku-view.c"
	}
}


static void _vala_sudoku_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SudokuView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SUDOKU_VIEW, SudokuView);
#line 446 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	switch (property_id) {
#line 446 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		case SUDOKU_VIEW_SHOW_WARNINGS:
#line 446 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		sudoku_view_set_show_warnings (self, g_value_get_boolean (value));
#line 446 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		break;
#line 446 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		case SUDOKU_VIEW_SHOW_POSSIBILITIES:
#line 446 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		sudoku_view_set_show_possibilities (self, g_value_get_boolean (value));
#line 446 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		break;
#line 446 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		case SUDOKU_VIEW_HIGHLIGHTER:
#line 446 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		sudoku_view_set_highlighter (self, g_value_get_boolean (value));
#line 446 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		break;
#line 5638 "sudoku-view.c"
		default:
#line 446 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 446 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		break;
#line 5644 "sudoku-view.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



