/* sudoku-saver.c generated by valac 0.27.2.2-e6bbc, the Vala compiler
 * generated from sudoku-saver.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * Copyright © 2014 Parin Porecha
 * Copyright © 2014 Michael Catanzaro
 *
 * This file is part of GNOME Sudoku.
 *
 * GNOME Sudoku is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * GNOME Sudoku is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME Sudoku. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gstdio.h>
#include <json-glib/json-glib.h>
#include <float.h>
#include <math.h>
#include <gee.h>


#define TYPE_SUDOKU_SAVER (sudoku_saver_get_type ())
#define SUDOKU_SAVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_SAVER, SudokuSaver))
#define SUDOKU_SAVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_SAVER, SudokuSaverClass))
#define IS_SUDOKU_SAVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_SAVER))
#define IS_SUDOKU_SAVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_SAVER))
#define SUDOKU_SAVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_SAVER, SudokuSaverClass))

typedef struct _SudokuSaver SudokuSaver;
typedef struct _SudokuSaverClass SudokuSaverClass;
typedef struct _SudokuSaverPrivate SudokuSaverPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_SUDOKU_GAME (sudoku_game_get_type ())
#define SUDOKU_GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_GAME, SudokuGame))
#define SUDOKU_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_GAME, SudokuGameClass))
#define IS_SUDOKU_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_GAME))
#define IS_SUDOKU_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_GAME))
#define SUDOKU_GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_GAME, SudokuGameClass))

typedef struct _SudokuGame SudokuGame;
typedef struct _SudokuGameClass SudokuGameClass;
typedef struct _SudokuGamePrivate SudokuGamePrivate;

#define TYPE_SUDOKU_BOARD (sudoku_board_get_type ())
#define SUDOKU_BOARD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_BOARD, SudokuBoard))
#define SUDOKU_BOARD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_BOARD, SudokuBoardClass))
#define IS_SUDOKU_BOARD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_BOARD))
#define IS_SUDOKU_BOARD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_BOARD))
#define SUDOKU_BOARD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_BOARD, SudokuBoardClass))

typedef struct _SudokuBoard SudokuBoard;
typedef struct _SudokuBoardClass SudokuBoardClass;

#define TYPE_DIFFICULTY_CATEGORY (difficulty_category_get_type ())
typedef struct _SudokuBoardPrivate SudokuBoardPrivate;

#define TYPE_COORD (coord_get_type ())
typedef struct _Coord Coord;
#define __vala_JsonNode_free0(var) ((var == NULL) ? NULL : (var = (_vala_JsonNode_free (var), NULL)))

struct _SudokuSaver {
	GObject parent_instance;
	SudokuSaverPrivate * priv;
};

struct _SudokuSaverClass {
	GObjectClass parent_class;
};

struct _SudokuGame {
	GObject parent_instance;
	SudokuGamePrivate * priv;
	SudokuBoard* board;
	GTimer* timer;
};

struct _SudokuGameClass {
	GObjectClass parent_class;
};

typedef enum  {
	DIFFICULTY_CATEGORY_UNKNOWN,
	DIFFICULTY_CATEGORY_EASY,
	DIFFICULTY_CATEGORY_MEDIUM,
	DIFFICULTY_CATEGORY_HARD,
	DIFFICULTY_CATEGORY_VERY_HARD
} DifficultyCategory;

struct _Coord {
	gint row;
	gint col;
};

struct _SudokuBoard {
	GObject parent_instance;
	SudokuBoardPrivate * priv;
	gint* cells;
	gint cells_length1;
	gint cells_length2;
	gboolean* is_fixed;
	gint is_fixed_length1;
	gint is_fixed_length2;
	GeeSet* broken_coords;
	GeeList* coords_for_col;
	GeeList* coords_for_row;
	GeeMap* coords_for_block;
};

struct _SudokuBoardClass {
	GObjectClass parent_class;
};


static gpointer sudoku_saver_parent_class = NULL;
static gchar* sudoku_saver__savegame_file;
static gchar* sudoku_saver__savegame_file = NULL;
static gchar* sudoku_saver__finishgame_dir;
static gchar* sudoku_saver__finishgame_dir = NULL;

GType sudoku_saver_get_type (void) G_GNUC_CONST;
enum  {
	SUDOKU_SAVER_DUMMY_PROPERTY
};
SudokuSaver* sudoku_saver_new (void);
SudokuSaver* sudoku_saver_construct (GType object_type);
const gchar* sudoku_saver_get_savegame_file (void);
static void sudoku_saver_set_savegame_file (const gchar* value);
const gchar* sudoku_saver_get_finishgame_dir (void);
static void sudoku_saver_set_finishgame_dir (const gchar* value);
GType sudoku_game_get_type (void) G_GNUC_CONST;
SudokuGame* sudoku_saver_get_savedgame (SudokuSaver* self);
static SudokuGame* sudoku_saver_parse_json_to_game (SudokuSaver* self, const gchar* file_path);
void sudoku_saver_save_game (SudokuSaver* self, SudokuGame* game);
static void sudoku_saver_create_file_for_game (SudokuSaver* self, SudokuGame* game, const gchar* file_name);
void sudoku_saver_add_game_to_finished (SudokuSaver* self, SudokuGame* game, gboolean delete_savegame);
GType sudoku_board_get_type (void) G_GNUC_CONST;
gchar* sudoku_board_to_string (SudokuBoard* self, gboolean get_original_state);
static gchar* sudoku_saver_serialize_game_to_json (SudokuSaver* self, SudokuGame* game);
gint* sudoku_board_get_cells (SudokuBoard* self, int* result_length1, int* result_length2);
GType difficulty_category_get_type (void) G_GNUC_CONST;
DifficultyCategory sudoku_board_get_difficulty_category (SudokuBoard* self);
gchar* difficulty_category_to_untranslated_string (DifficultyCategory self);
gdouble sudoku_game_get_total_time_played (SudokuGame* self);
gint sudoku_board_get_rows (SudokuBoard* self);
gint sudoku_board_get_cols (SudokuBoard* self);
gint sudoku_board_get_max_val (SudokuBoard* self);
gboolean sudoku_board_is_earmark_enabled (SudokuBoard* self, gint row, gint column, gint digit);
static void _vala_array_add1 (gint** array, int* length, int* size, gint value);
GType coord_get_type (void) G_GNUC_CONST;
Coord* coord_dup (const Coord* self);
void coord_free (Coord* self);
static void _vala_JsonNode_free (JsonNode* self);
SudokuBoard* sudoku_board_new (gint block_rows, gint block_cols);
SudokuBoard* sudoku_board_construct (GType object_type, gint block_rows, gint block_cols);
static JsonNode* _vala_JsonNode_copy (JsonNode* self);
void sudoku_board_insert (SudokuBoard* self, gint row, gint col, gint val, gboolean is_fixed);
void sudoku_board_enable_earmark (SudokuBoard* self, gint row, gint column, gint digit);
void sudoku_board_set_previous_played_time (SudokuBoard* self, gdouble value);
DifficultyCategory difficulty_category_from_string (const gchar* input);
void sudoku_board_set_difficulty_category (SudokuBoard* self, DifficultyCategory value);
SudokuGame* sudoku_game_new (SudokuBoard* board);
SudokuGame* sudoku_game_construct (GType object_type, SudokuBoard* board);
static void sudoku_saver_finalize (GObject* obj);
static void _vala_sudoku_saver_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_sudoku_saver_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


SudokuSaver* sudoku_saver_construct (GType object_type) {
	SudokuSaver * self = NULL;
	GError * _inner_error_ = NULL;
#line 29 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	self = (SudokuSaver*) g_object_new (object_type, NULL);
#line 192 "sudoku-saver.c"
	{
		gchar* config_dir = NULL;
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* sudoku_data_dir = NULL;
		const gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
#line 32 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		_tmp0_ = g_get_user_data_dir ();
#line 32 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		_tmp1_ = g_strdup (_tmp0_);
#line 32 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		config_dir = _tmp1_;
#line 33 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		_tmp2_ = config_dir;
#line 33 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		_tmp3_ = g_build_path (G_DIR_SEPARATOR_S, _tmp2_, "gnome-sudoku", NULL);
#line 33 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		sudoku_data_dir = _tmp3_;
#line 34 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		_tmp4_ = sudoku_saver_get_savegame_file ();
#line 34 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		_tmp5_ = _tmp4_;
#line 34 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		_tmp6_ = sudoku_data_dir;
#line 34 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		_tmp7_ = g_build_path (G_DIR_SEPARATOR_S, _tmp6_, "savefile", NULL);
#line 34 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		_tmp8_ = _tmp7_;
#line 34 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		sudoku_saver_set_savegame_file (_tmp8_);
#line 34 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		_g_free0 (_tmp8_);
#line 35 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		_tmp9_ = sudoku_saver_get_finishgame_dir ();
#line 35 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		_tmp10_ = _tmp9_;
#line 35 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		_tmp11_ = sudoku_data_dir;
#line 35 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		_tmp12_ = g_build_path (G_DIR_SEPARATOR_S, _tmp11_, "finished", NULL);
#line 35 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		_tmp13_ = _tmp12_;
#line 35 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		sudoku_saver_set_finishgame_dir (_tmp13_);
#line 35 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		_g_free0 (_tmp13_);
#line 250 "sudoku-saver.c"
		{
			GFile* file = NULL;
			const gchar* _tmp14_ = NULL;
			GFile* _tmp15_ = NULL;
			GFile* _tmp16_ = NULL;
			gboolean _tmp17_ = FALSE;
			const gchar* _tmp19_ = NULL;
			const gchar* _tmp20_ = NULL;
			GFile* _tmp21_ = NULL;
			GFile* _tmp22_ = NULL;
			gboolean _tmp23_ = FALSE;
#line 38 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
			_tmp14_ = sudoku_data_dir;
#line 38 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
			_tmp15_ = g_file_new_for_path (_tmp14_);
#line 38 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
			file = _tmp15_;
#line 39 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
			_tmp16_ = file;
#line 39 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
			_tmp17_ = g_file_query_exists (_tmp16_, NULL);
#line 39 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
			if (!_tmp17_) {
#line 274 "sudoku-saver.c"
				GFile* _tmp18_ = NULL;
#line 40 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_tmp18_ = file;
#line 40 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				g_file_make_directory (_tmp18_, NULL, &_inner_error_);
#line 40 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 40 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
					_g_object_unref0 (file);
#line 40 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
					_g_free0 (sudoku_data_dir);
#line 40 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
					_g_free0 (config_dir);
#line 288 "sudoku-saver.c"
					goto __catch0_g_error;
				}
			}
#line 42 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
			_tmp19_ = sudoku_saver_get_finishgame_dir ();
#line 42 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
			_tmp20_ = _tmp19_;
#line 42 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
			_tmp21_ = g_file_new_for_path (_tmp20_);
#line 42 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
			_g_object_unref0 (file);
#line 42 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
			file = _tmp21_;
#line 43 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
			_tmp22_ = file;
#line 43 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
			_tmp23_ = g_file_query_exists (_tmp22_, NULL);
#line 43 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
			if (!_tmp23_) {
#line 308 "sudoku-saver.c"
				GFile* _tmp24_ = NULL;
#line 44 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_tmp24_ = file;
#line 44 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				g_file_make_directory (_tmp24_, NULL, &_inner_error_);
#line 44 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 44 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
					_g_object_unref0 (file);
#line 44 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
					_g_free0 (sudoku_data_dir);
#line 44 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
					_g_free0 (config_dir);
#line 322 "sudoku-saver.c"
					goto __catch0_g_error;
				}
			}
#line 37 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
			_g_object_unref0 (file);
#line 328 "sudoku-saver.c"
		}
#line 30 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		_g_free0 (sudoku_data_dir);
#line 30 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		_g_free0 (config_dir);
#line 334 "sudoku-saver.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp25_ = NULL;
		const gchar* _tmp26_ = NULL;
#line 30 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		e = _inner_error_;
#line 30 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		_inner_error_ = NULL;
#line 47 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		_tmp25_ = e;
#line 47 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		_tmp26_ = _tmp25_->message;
#line 47 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		g_warning ("sudoku-saver.vala:47: %s", _tmp26_);
#line 30 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		_g_error_free0 (e);
#line 354 "sudoku-saver.c"
	}
	__finally0:
#line 30 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 30 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 30 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		g_clear_error (&_inner_error_);
#line 30 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		return NULL;
#line 365 "sudoku-saver.c"
	}
#line 29 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	return self;
#line 369 "sudoku-saver.c"
}


SudokuSaver* sudoku_saver_new (void) {
#line 29 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	return sudoku_saver_construct (TYPE_SUDOKU_SAVER);
#line 376 "sudoku-saver.c"
}


SudokuGame* sudoku_saver_get_savedgame (SudokuSaver* self) {
	SudokuGame* result = NULL;
	GFile* file = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	GFile* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	SudokuGame* _tmp7_ = NULL;
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 53 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp0_ = sudoku_saver_get_savegame_file ();
#line 53 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp1_ = _tmp0_;
#line 53 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp2_ = g_file_new_for_path (_tmp1_);
#line 53 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	file = _tmp2_;
#line 54 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp3_ = file;
#line 54 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp4_ = g_file_query_exists (_tmp3_, NULL);
#line 54 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	if (!_tmp4_) {
#line 55 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		result = NULL;
#line 55 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		_g_object_unref0 (file);
#line 55 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		return result;
#line 413 "sudoku-saver.c"
	}
#line 57 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp5_ = sudoku_saver_get_savegame_file ();
#line 57 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp6_ = _tmp5_;
#line 57 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp7_ = sudoku_saver_parse_json_to_game (self, _tmp6_);
#line 57 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	result = _tmp7_;
#line 57 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_g_object_unref0 (file);
#line 57 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	return result;
#line 427 "sudoku-saver.c"
}


void sudoku_saver_save_game (SudokuSaver* self, SudokuGame* game) {
	SudokuGame* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
#line 60 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	g_return_if_fail (self != NULL);
#line 60 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	g_return_if_fail (game != NULL);
#line 62 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp0_ = game;
#line 62 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp1_ = sudoku_saver_get_savegame_file ();
#line 62 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp2_ = _tmp1_;
#line 62 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	sudoku_saver_create_file_for_game (self, _tmp0_, _tmp2_);
#line 447 "sudoku-saver.c"
}


void sudoku_saver_add_game_to_finished (SudokuSaver* self, SudokuGame* game, gboolean delete_savegame) {
	gchar* file_name = NULL;
	SudokuGame* _tmp0_ = NULL;
	SudokuBoard* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* file_path = NULL;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	SudokuGame* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	gboolean _tmp12_ = FALSE;
	GError * _inner_error_ = NULL;
#line 65 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	g_return_if_fail (self != NULL);
#line 65 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	g_return_if_fail (game != NULL);
#line 67 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp0_ = game;
#line 67 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp1_ = _tmp0_->board;
#line 67 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp2_ = sudoku_board_to_string (_tmp1_, TRUE);
#line 67 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp3_ = _tmp2_;
#line 67 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp4_ = g_strconcat (_tmp3_, ".save", NULL);
#line 67 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp5_ = _tmp4_;
#line 67 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_g_free0 (_tmp3_);
#line 67 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	file_name = _tmp5_;
#line 68 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp6_ = sudoku_saver_get_finishgame_dir ();
#line 68 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp7_ = _tmp6_;
#line 68 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp8_ = file_name;
#line 68 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp9_ = g_build_path (G_DIR_SEPARATOR_S, _tmp7_, _tmp8_, NULL);
#line 68 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	file_path = _tmp9_;
#line 69 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp10_ = game;
#line 69 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp11_ = file_path;
#line 69 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	sudoku_saver_create_file_for_game (self, _tmp10_, _tmp11_);
#line 71 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp12_ = delete_savegame;
#line 71 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	if (_tmp12_) {
#line 508 "sudoku-saver.c"
		GFile* file = NULL;
		const gchar* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		GFile* _tmp15_ = NULL;
		GFile* _tmp16_ = NULL;
		gboolean _tmp17_ = FALSE;
#line 74 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		_tmp13_ = sudoku_saver_get_savegame_file ();
#line 74 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		_tmp14_ = _tmp13_;
#line 74 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		_tmp15_ = g_file_new_for_path (_tmp14_);
#line 74 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		file = _tmp15_;
#line 75 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		_tmp16_ = file;
#line 75 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		_tmp17_ = g_file_query_exists (_tmp16_, NULL);
#line 75 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		if (_tmp17_) {
#line 529 "sudoku-saver.c"
			{
				GFile* _tmp18_ = NULL;
#line 79 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_tmp18_ = file;
#line 79 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				g_file_delete (_tmp18_, NULL, &_inner_error_);
#line 79 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 538 "sudoku-saver.c"
					goto __catch1_g_error;
				}
			}
			goto __finally1;
			__catch1_g_error:
			{
				GError* e = NULL;
				GFile* _tmp19_ = NULL;
				gchar* _tmp20_ = NULL;
				gchar* _tmp21_ = NULL;
				GError* _tmp22_ = NULL;
				const gchar* _tmp23_ = NULL;
#line 77 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				e = _inner_error_;
#line 77 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_inner_error_ = NULL;
#line 83 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_tmp19_ = file;
#line 83 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_tmp20_ = g_file_get_uri (_tmp19_);
#line 83 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_tmp21_ = _tmp20_;
#line 83 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_tmp22_ = e;
#line 83 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_tmp23_ = _tmp22_->message;
#line 83 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				g_warning ("sudoku-saver.vala:83: Failed to delete %s: %s", _tmp21_, _tmp23_);
#line 83 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_g_free0 (_tmp21_);
#line 77 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_g_error_free0 (e);
#line 571 "sudoku-saver.c"
			}
			__finally1:
#line 77 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 77 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_g_object_unref0 (file);
#line 77 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_g_free0 (file_path);
#line 77 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_g_free0 (file_name);
#line 77 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 77 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				g_clear_error (&_inner_error_);
#line 77 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				return;
#line 588 "sudoku-saver.c"
			}
		}
#line 71 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		_g_object_unref0 (file);
#line 593 "sudoku-saver.c"
	}
#line 65 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_g_free0 (file_path);
#line 65 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_g_free0 (file_name);
#line 599 "sudoku-saver.c"
}


static void sudoku_saver_create_file_for_game (SudokuSaver* self, SudokuGame* game, const gchar* file_name) {
	gchar* json_str = NULL;
	SudokuGame* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	GError * _inner_error_ = NULL;
#line 89 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	g_return_if_fail (self != NULL);
#line 89 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	g_return_if_fail (game != NULL);
#line 89 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	g_return_if_fail (file_name != NULL);
#line 91 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp0_ = game;
#line 91 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp1_ = sudoku_saver_serialize_game_to_json (self, _tmp0_);
#line 91 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	json_str = _tmp1_;
#line 620 "sudoku-saver.c"
	{
		const gchar* _tmp2_ = NULL;
#line 94 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		_tmp2_ = file_name;
#line 94 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		g_file_set_contents (_tmp2_, json_str, (gssize) (-1), &_inner_error_);
#line 94 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 629 "sudoku-saver.c"
			goto __catch2_g_error;
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
#line 93 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		e = _inner_error_;
#line 93 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		_inner_error_ = NULL;
#line 96 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		_tmp3_ = e;
#line 96 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		_tmp4_ = _tmp3_->message;
#line 96 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		g_warning ("sudoku-saver.vala:96: %s", _tmp4_);
#line 93 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		_g_error_free0 (e);
#line 651 "sudoku-saver.c"
	}
	__finally2:
#line 93 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 93 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		_g_free0 (json_str);
#line 93 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 93 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		g_clear_error (&_inner_error_);
#line 93 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		return;
#line 664 "sudoku-saver.c"
	}
#line 89 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_g_free0 (json_str);
#line 668 "sudoku-saver.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 102 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	return self ? g_object_ref (self) : NULL;
#line 675 "sudoku-saver.c"
}


static void _vala_array_add1 (gint** array, int* length, int* size, gint value) {
#line 122 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	if ((*length) == (*size)) {
#line 122 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 122 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		*array = g_renew (gint, *array, *size);
#line 686 "sudoku-saver.c"
	}
#line 122 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	(*array)[(*length)++] = value;
#line 690 "sudoku-saver.c"
}


static void _vala_JsonNode_free (JsonNode* self) {
#line 158 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	g_boxed_free (json_node_get_type (), self);
#line 697 "sudoku-saver.c"
}


static gchar* sudoku_saver_serialize_game_to_json (SudokuSaver* self, SudokuGame* game) {
	gchar* result = NULL;
	SudokuBoard* board = NULL;
	SudokuGame* _tmp0_ = NULL;
	SudokuBoard* _tmp1_ = NULL;
	SudokuBoard* _tmp2_ = NULL;
	gint* board_cells = NULL;
	SudokuBoard* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gint* _tmp6_ = NULL;
	gint board_cells_length1 = 0;
	gint board_cells_length2 = 0;
	JsonBuilder* builder = NULL;
	JsonBuilder* _tmp7_ = NULL;
	JsonBuilder* _tmp8_ = NULL;
	JsonBuilder* _tmp9_ = NULL;
	JsonBuilder* _tmp10_ = NULL;
	SudokuBoard* _tmp11_ = NULL;
	DifficultyCategory _tmp12_ = 0;
	DifficultyCategory _tmp13_ = 0;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	JsonBuilder* _tmp16_ = NULL;
	JsonBuilder* _tmp17_ = NULL;
	SudokuGame* _tmp18_ = NULL;
	gdouble _tmp19_ = 0.0;
	JsonBuilder* _tmp20_ = NULL;
	JsonBuilder* _tmp21_ = NULL;
	JsonBuilder* _tmp82_ = NULL;
	JsonBuilder* _tmp83_ = NULL;
	JsonGenerator* generator = NULL;
	JsonGenerator* _tmp84_ = NULL;
	JsonNode* root = NULL;
	JsonBuilder* _tmp85_ = NULL;
	JsonNode* _tmp86_ = NULL;
	gchar* _tmp87_ = NULL;
#line 100 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 100 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	g_return_val_if_fail (game != NULL, NULL);
#line 102 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp0_ = game;
#line 102 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp1_ = _tmp0_->board;
#line 102 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 102 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	board = _tmp2_;
#line 103 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp3_ = board;
#line 103 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp6_ = sudoku_board_get_cells (_tmp3_, &_tmp4_, &_tmp5_);
#line 103 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	board_cells = _tmp6_;
#line 103 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	board_cells_length1 = _tmp4_;
#line 103 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	board_cells_length2 = _tmp5_;
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp7_ = json_builder_new ();
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	builder = _tmp7_;
#line 106 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp8_ = builder;
#line 106 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	json_builder_begin_object (_tmp8_);
#line 107 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp9_ = builder;
#line 107 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	json_builder_set_member_name (_tmp9_, "difficulty_category");
#line 108 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp10_ = builder;
#line 108 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp11_ = board;
#line 108 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp12_ = sudoku_board_get_difficulty_category (_tmp11_);
#line 108 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp13_ = _tmp12_;
#line 108 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp14_ = difficulty_category_to_untranslated_string (_tmp13_);
#line 108 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp15_ = _tmp14_;
#line 108 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	json_builder_add_string_value (_tmp10_, _tmp15_);
#line 108 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_g_free0 (_tmp15_);
#line 109 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp16_ = builder;
#line 109 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	json_builder_set_member_name (_tmp16_, "time_elapsed");
#line 110 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp17_ = builder;
#line 110 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp18_ = game;
#line 110 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp19_ = sudoku_game_get_total_time_played (_tmp18_);
#line 110 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	json_builder_add_double_value (_tmp17_, _tmp19_);
#line 112 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp20_ = builder;
#line 112 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	json_builder_set_member_name (_tmp20_, "cells");
#line 113 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp21_ = builder;
#line 113 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	json_builder_begin_array (_tmp21_);
#line 808 "sudoku-saver.c"
	{
		gint i = 0;
#line 115 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		i = 0;
#line 813 "sudoku-saver.c"
		{
			gboolean _tmp22_ = FALSE;
#line 115 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
			_tmp22_ = TRUE;
#line 115 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
			while (TRUE) {
#line 820 "sudoku-saver.c"
				gint _tmp24_ = 0;
				SudokuBoard* _tmp25_ = NULL;
				gint _tmp26_ = 0;
				gint _tmp27_ = 0;
#line 115 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				if (!_tmp22_) {
#line 827 "sudoku-saver.c"
					gint _tmp23_ = 0;
#line 115 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
					_tmp23_ = i;
#line 115 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
					i = _tmp23_ + 1;
#line 833 "sudoku-saver.c"
				}
#line 115 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_tmp22_ = FALSE;
#line 115 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_tmp24_ = i;
#line 115 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_tmp25_ = board;
#line 115 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_tmp26_ = sudoku_board_get_rows (_tmp25_);
#line 115 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_tmp27_ = _tmp26_;
#line 115 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				if (!(_tmp24_ < _tmp27_)) {
#line 115 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
					break;
#line 849 "sudoku-saver.c"
				}
				{
					gint j = 0;
#line 117 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
					j = 0;
#line 855 "sudoku-saver.c"
					{
						gboolean _tmp28_ = FALSE;
#line 117 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
						_tmp28_ = TRUE;
#line 117 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
						while (TRUE) {
#line 862 "sudoku-saver.c"
							gint _tmp30_ = 0;
							SudokuBoard* _tmp31_ = NULL;
							gint _tmp32_ = 0;
							gint _tmp33_ = 0;
							gint* earmarks = NULL;
							gint* _tmp34_ = NULL;
							gint earmarks_length1 = 0;
							gint _earmarks_size_ = 0;
							gboolean _tmp48_ = FALSE;
							gint* _tmp49_ = NULL;
							gint _tmp49__length1 = 0;
							gint _tmp49__length2 = 0;
							gint _tmp50_ = 0;
							gint _tmp51_ = 0;
							gint _tmp52_ = 0;
							JsonBuilder* _tmp54_ = NULL;
							JsonBuilder* _tmp55_ = NULL;
							JsonBuilder* _tmp56_ = NULL;
							JsonBuilder* _tmp57_ = NULL;
							gint _tmp58_ = 0;
							JsonBuilder* _tmp59_ = NULL;
							gint _tmp60_ = 0;
							JsonBuilder* _tmp61_ = NULL;
							JsonBuilder* _tmp62_ = NULL;
							JsonBuilder* _tmp63_ = NULL;
							gint* _tmp64_ = NULL;
							gint _tmp64__length1 = 0;
							gint _tmp64__length2 = 0;
							gint _tmp65_ = 0;
							gint _tmp66_ = 0;
							gint _tmp67_ = 0;
							JsonBuilder* _tmp68_ = NULL;
							JsonBuilder* _tmp69_ = NULL;
							SudokuBoard* _tmp70_ = NULL;
							gboolean* _tmp71_ = NULL;
							gint _tmp71__length1 = 0;
							gint _tmp71__length2 = 0;
							gint _tmp72_ = 0;
							gint _tmp73_ = 0;
							gboolean _tmp74_ = FALSE;
							JsonBuilder* _tmp75_ = NULL;
							JsonBuilder* _tmp76_ = NULL;
							gint* _tmp77_ = NULL;
							gint _tmp77__length1 = 0;
							JsonBuilder* _tmp80_ = NULL;
							JsonBuilder* _tmp81_ = NULL;
#line 117 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							if (!_tmp28_) {
#line 911 "sudoku-saver.c"
								gint _tmp29_ = 0;
#line 117 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
								_tmp29_ = j;
#line 117 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
								j = _tmp29_ + 1;
#line 917 "sudoku-saver.c"
							}
#line 117 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							_tmp28_ = FALSE;
#line 117 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							_tmp30_ = j;
#line 117 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							_tmp31_ = board;
#line 117 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							_tmp32_ = sudoku_board_get_cols (_tmp31_);
#line 117 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							_tmp33_ = _tmp32_;
#line 117 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							if (!(_tmp30_ < _tmp33_)) {
#line 117 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
								break;
#line 933 "sudoku-saver.c"
							}
#line 119 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							_tmp34_ = g_new0 (gint, 0);
#line 119 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							earmarks = _tmp34_;
#line 119 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							earmarks_length1 = 0;
#line 119 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							_earmarks_size_ = earmarks_length1;
#line 943 "sudoku-saver.c"
							{
								gint k = 0;
#line 120 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
								k = 1;
#line 948 "sudoku-saver.c"
								{
									gboolean _tmp35_ = FALSE;
#line 120 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
									_tmp35_ = TRUE;
#line 120 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
									while (TRUE) {
#line 955 "sudoku-saver.c"
										gint _tmp37_ = 0;
										SudokuBoard* _tmp38_ = NULL;
										gint _tmp39_ = 0;
										gint _tmp40_ = 0;
										SudokuBoard* _tmp41_ = NULL;
										gint _tmp42_ = 0;
										gint _tmp43_ = 0;
										gint _tmp44_ = 0;
										gboolean _tmp45_ = FALSE;
#line 120 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
										if (!_tmp35_) {
#line 967 "sudoku-saver.c"
											gint _tmp36_ = 0;
#line 120 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
											_tmp36_ = k;
#line 120 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
											k = _tmp36_ + 1;
#line 973 "sudoku-saver.c"
										}
#line 120 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
										_tmp35_ = FALSE;
#line 120 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
										_tmp37_ = k;
#line 120 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
										_tmp38_ = board;
#line 120 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
										_tmp39_ = sudoku_board_get_max_val (_tmp38_);
#line 120 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
										_tmp40_ = _tmp39_;
#line 120 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
										if (!(_tmp37_ <= _tmp40_)) {
#line 120 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
											break;
#line 989 "sudoku-saver.c"
										}
#line 121 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
										_tmp41_ = board;
#line 121 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
										_tmp42_ = i;
#line 121 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
										_tmp43_ = j;
#line 121 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
										_tmp44_ = k;
#line 121 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
										_tmp45_ = sudoku_board_is_earmark_enabled (_tmp41_, _tmp42_, _tmp43_, _tmp44_);
#line 121 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
										if (_tmp45_) {
#line 1003 "sudoku-saver.c"
											gint* _tmp46_ = NULL;
											gint _tmp46__length1 = 0;
											gint _tmp47_ = 0;
#line 122 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
											_tmp46_ = earmarks;
#line 122 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
											_tmp46__length1 = earmarks_length1;
#line 122 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
											_tmp47_ = k;
#line 122 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
											_vala_array_add1 (&earmarks, &earmarks_length1, &_earmarks_size_, _tmp47_);
#line 1015 "sudoku-saver.c"
										}
									}
								}
							}
#line 124 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							_tmp49_ = board_cells;
#line 124 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							_tmp49__length1 = board_cells_length1;
#line 124 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							_tmp49__length2 = board_cells_length2;
#line 124 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							_tmp50_ = i;
#line 124 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							_tmp51_ = j;
#line 124 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							_tmp52_ = _tmp49_[(_tmp50_ * _tmp49__length2) + _tmp51_];
#line 124 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							if (_tmp52_ == 0) {
#line 1034 "sudoku-saver.c"
								gint* _tmp53_ = NULL;
								gint _tmp53__length1 = 0;
#line 124 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
								_tmp53_ = earmarks;
#line 124 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
								_tmp53__length1 = earmarks_length1;
#line 124 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
								_tmp48_ = _tmp53__length1 == 0;
#line 1043 "sudoku-saver.c"
							} else {
#line 124 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
								_tmp48_ = FALSE;
#line 1047 "sudoku-saver.c"
							}
#line 124 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							if (_tmp48_) {
#line 125 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
								earmarks = (g_free (earmarks), NULL);
#line 125 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
								continue;
#line 1055 "sudoku-saver.c"
							}
#line 127 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							_tmp54_ = builder;
#line 127 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							json_builder_begin_object (_tmp54_);
#line 129 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							_tmp55_ = builder;
#line 129 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							json_builder_set_member_name (_tmp55_, "position");
#line 130 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							_tmp56_ = builder;
#line 130 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							json_builder_begin_array (_tmp56_);
#line 131 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							_tmp57_ = builder;
#line 131 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							_tmp58_ = i;
#line 131 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							json_builder_add_int_value (_tmp57_, (gint64) _tmp58_);
#line 132 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							_tmp59_ = builder;
#line 132 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							_tmp60_ = j;
#line 132 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							json_builder_add_int_value (_tmp59_, (gint64) _tmp60_);
#line 133 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							_tmp61_ = builder;
#line 133 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							json_builder_end_array (_tmp61_);
#line 134 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							_tmp62_ = builder;
#line 134 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							json_builder_set_member_name (_tmp62_, "value");
#line 135 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							_tmp63_ = builder;
#line 135 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							_tmp64_ = board_cells;
#line 135 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							_tmp64__length1 = board_cells_length1;
#line 135 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							_tmp64__length2 = board_cells_length2;
#line 135 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							_tmp65_ = i;
#line 135 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							_tmp66_ = j;
#line 135 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							_tmp67_ = _tmp64_[(_tmp65_ * _tmp64__length2) + _tmp66_];
#line 135 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							json_builder_add_int_value (_tmp63_, (gint64) _tmp67_);
#line 136 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							_tmp68_ = builder;
#line 136 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							json_builder_set_member_name (_tmp68_, "fixed");
#line 137 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							_tmp69_ = builder;
#line 137 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							_tmp70_ = board;
#line 137 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							_tmp71_ = _tmp70_->is_fixed;
#line 137 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							_tmp71__length1 = _tmp70_->is_fixed_length1;
#line 137 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							_tmp71__length2 = _tmp70_->is_fixed_length2;
#line 137 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							_tmp72_ = i;
#line 137 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							_tmp73_ = j;
#line 137 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							_tmp74_ = _tmp71_[(_tmp72_ * _tmp71__length2) + _tmp73_];
#line 137 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							json_builder_add_boolean_value (_tmp69_, _tmp74_);
#line 138 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							_tmp75_ = builder;
#line 138 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							json_builder_set_member_name (_tmp75_, "earmarks");
#line 139 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							_tmp76_ = builder;
#line 139 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							json_builder_begin_array (_tmp76_);
#line 141 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							_tmp77_ = earmarks;
#line 141 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							_tmp77__length1 = earmarks_length1;
#line 1139 "sudoku-saver.c"
							{
								gint* k_collection = NULL;
								gint k_collection_length1 = 0;
								gint _k_collection_size_ = 0;
								gint k_it = 0;
#line 141 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
								k_collection = _tmp77_;
#line 141 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
								k_collection_length1 = _tmp77__length1;
#line 141 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
								for (k_it = 0; k_it < _tmp77__length1; k_it = k_it + 1) {
#line 1151 "sudoku-saver.c"
									gint k = 0;
#line 141 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
									k = k_collection[k_it];
#line 1155 "sudoku-saver.c"
									{
										JsonBuilder* _tmp78_ = NULL;
										gint _tmp79_ = 0;
#line 142 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
										_tmp78_ = builder;
#line 142 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
										_tmp79_ = k;
#line 142 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
										json_builder_add_int_value (_tmp78_, (gint64) _tmp79_);
#line 1165 "sudoku-saver.c"
									}
								}
							}
#line 144 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							_tmp80_ = builder;
#line 144 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							json_builder_end_array (_tmp80_);
#line 146 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							_tmp81_ = builder;
#line 146 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							json_builder_end_object (_tmp81_);
#line 117 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							earmarks = (g_free (earmarks), NULL);
#line 1179 "sudoku-saver.c"
						}
					}
				}
			}
		}
	}
#line 150 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp82_ = builder;
#line 150 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	json_builder_end_array (_tmp82_);
#line 151 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp83_ = builder;
#line 151 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	json_builder_end_object (_tmp83_);
#line 153 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp84_ = json_generator_new ();
#line 153 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	generator = _tmp84_;
#line 154 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	json_generator_set_pretty (generator, TRUE);
#line 155 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp85_ = builder;
#line 155 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp86_ = json_builder_get_root (_tmp85_);
#line 155 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	root = _tmp86_;
#line 156 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	json_generator_set_root (generator, root);
#line 158 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp87_ = json_generator_to_data (generator, NULL);
#line 158 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	result = _tmp87_;
#line 158 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	__vala_JsonNode_free0 (root);
#line 158 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_g_object_unref0 (generator);
#line 158 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_g_object_unref0 (builder);
#line 158 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	board_cells = (g_free (board_cells), NULL);
#line 158 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_g_object_unref0 (board);
#line 158 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	return result;
#line 1224 "sudoku-saver.c"
}


static JsonNode* _vala_JsonNode_copy (JsonNode* self) {
#line 171 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	return g_boxed_copy (json_node_get_type (), self);
#line 1231 "sudoku-saver.c"
}


static gpointer __vala_JsonNode_copy0 (gpointer self) {
#line 171 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	return self ? _vala_JsonNode_copy (self) : NULL;
#line 1238 "sudoku-saver.c"
}


static SudokuGame* sudoku_saver_parse_json_to_game (SudokuSaver* self, const gchar* file_path) {
	SudokuGame* result = NULL;
	JsonParser* parser = NULL;
	JsonParser* _tmp0_ = NULL;
	SudokuBoard* board = NULL;
	SudokuBoard* _tmp3_ = NULL;
	JsonNode* node = NULL;
	JsonParser* _tmp4_ = NULL;
	JsonNode* _tmp5_ = NULL;
	JsonNode* _tmp6_ = NULL;
	JsonReader* reader = NULL;
	JsonNode* _tmp7_ = NULL;
	JsonReader* _tmp8_ = NULL;
	JsonReader* _tmp9_ = NULL;
	JsonReader* _tmp10_ = NULL;
	gboolean _tmp11_ = FALSE;
	JsonReader* _tmp75_ = NULL;
	JsonReader* _tmp76_ = NULL;
	JsonReader* _tmp77_ = NULL;
	gboolean _tmp78_ = FALSE;
	SudokuBoard* _tmp79_ = NULL;
	JsonReader* _tmp80_ = NULL;
	gdouble _tmp81_ = 0.0;
	JsonReader* _tmp82_ = NULL;
	JsonReader* _tmp83_ = NULL;
	JsonReader* _tmp84_ = NULL;
	gboolean _tmp85_ = FALSE;
	SudokuBoard* _tmp86_ = NULL;
	JsonReader* _tmp87_ = NULL;
	const gchar* _tmp88_ = NULL;
	DifficultyCategory _tmp89_ = 0;
	JsonReader* _tmp90_ = NULL;
	SudokuBoard* _tmp91_ = NULL;
	SudokuGame* _tmp92_ = NULL;
	GError * _inner_error_ = NULL;
#line 161 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 161 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	g_return_val_if_fail (file_path != NULL, NULL);
#line 163 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp0_ = json_parser_new ();
#line 163 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	parser = _tmp0_;
#line 1285 "sudoku-saver.c"
	{
		JsonParser* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
#line 165 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		_tmp1_ = parser;
#line 165 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		_tmp2_ = file_path;
#line 165 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		json_parser_load_from_file (_tmp1_, _tmp2_, &_inner_error_);
#line 165 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1297 "sudoku-saver.c"
			goto __catch3_g_error;
		}
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
#line 164 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		e = _inner_error_;
#line 164 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		_inner_error_ = NULL;
#line 167 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		result = NULL;
#line 167 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		_g_error_free0 (e);
#line 167 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		_g_object_unref0 (parser);
#line 167 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		return result;
#line 1317 "sudoku-saver.c"
	}
	__finally3:
#line 164 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 164 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		_g_object_unref0 (parser);
#line 164 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 164 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		g_clear_error (&_inner_error_);
#line 164 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		return NULL;
#line 1330 "sudoku-saver.c"
	}
#line 170 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp3_ = sudoku_board_new (3, 3);
#line 170 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	board = _tmp3_;
#line 171 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp4_ = parser;
#line 171 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp5_ = json_parser_get_root (_tmp4_);
#line 171 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp6_ = __vala_JsonNode_copy0 (_tmp5_);
#line 171 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	node = _tmp6_;
#line 172 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp7_ = node;
#line 172 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp8_ = json_reader_new (_tmp7_);
#line 172 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	reader = _tmp8_;
#line 173 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp9_ = reader;
#line 173 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	json_reader_read_member (_tmp9_, "cells");
#line 174 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp10_ = reader;
#line 174 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp11_ = json_reader_is_array (_tmp10_);
#line 174 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	g_return_val_if_fail (_tmp11_, NULL);
#line 1360 "sudoku-saver.c"
	{
		gint i = 0;
#line 176 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		i = 0;
#line 1365 "sudoku-saver.c"
		{
			gboolean _tmp12_ = FALSE;
#line 176 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
			_tmp12_ = TRUE;
#line 176 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
			while (TRUE) {
#line 1372 "sudoku-saver.c"
				gint _tmp14_ = 0;
				JsonReader* _tmp15_ = NULL;
				gint _tmp16_ = 0;
				JsonReader* _tmp17_ = NULL;
				gint _tmp18_ = 0;
				JsonReader* _tmp19_ = NULL;
				JsonReader* _tmp20_ = NULL;
				gboolean _tmp21_ = FALSE;
				JsonReader* _tmp22_ = NULL;
				gint _tmp23_ = 0;
				JsonReader* _tmp24_ = NULL;
				JsonReader* _tmp25_ = NULL;
				gboolean _tmp26_ = FALSE;
				gint row = 0;
				JsonReader* _tmp27_ = NULL;
				gint64 _tmp28_ = 0LL;
				JsonReader* _tmp29_ = NULL;
				JsonReader* _tmp30_ = NULL;
				JsonReader* _tmp31_ = NULL;
				gboolean _tmp32_ = FALSE;
				gint col = 0;
				JsonReader* _tmp33_ = NULL;
				gint64 _tmp34_ = 0LL;
				JsonReader* _tmp35_ = NULL;
				JsonReader* _tmp36_ = NULL;
				JsonReader* _tmp37_ = NULL;
				JsonReader* _tmp38_ = NULL;
				gboolean _tmp39_ = FALSE;
				gint val = 0;
				JsonReader* _tmp40_ = NULL;
				gint64 _tmp41_ = 0LL;
				JsonReader* _tmp42_ = NULL;
				JsonReader* _tmp43_ = NULL;
				JsonReader* _tmp44_ = NULL;
				gboolean _tmp45_ = FALSE;
				gboolean is_fixed = FALSE;
				JsonReader* _tmp46_ = NULL;
				gboolean _tmp47_ = FALSE;
				JsonReader* _tmp48_ = NULL;
				gint _tmp49_ = 0;
				JsonReader* _tmp55_ = NULL;
				JsonReader* _tmp56_ = NULL;
				gboolean _tmp57_ = FALSE;
				JsonReader* _tmp73_ = NULL;
				JsonReader* _tmp74_ = NULL;
#line 176 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				if (!_tmp12_) {
#line 1420 "sudoku-saver.c"
					gint _tmp13_ = 0;
#line 176 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
					_tmp13_ = i;
#line 176 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
					i = _tmp13_ + 1;
#line 1426 "sudoku-saver.c"
				}
#line 176 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_tmp12_ = FALSE;
#line 176 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_tmp14_ = i;
#line 176 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_tmp15_ = reader;
#line 176 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_tmp16_ = json_reader_count_elements (_tmp15_);
#line 176 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				if (!(_tmp14_ < _tmp16_)) {
#line 176 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
					break;
#line 1440 "sudoku-saver.c"
				}
#line 178 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_tmp17_ = reader;
#line 178 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_tmp18_ = i;
#line 178 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				json_reader_read_element (_tmp17_, (guint) _tmp18_);
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_tmp19_ = reader;
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				json_reader_read_member (_tmp19_, "position");
#line 181 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_tmp20_ = reader;
#line 181 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_tmp21_ = json_reader_is_array (_tmp20_);
#line 181 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				g_return_val_if_fail (_tmp21_, NULL);
#line 182 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_tmp22_ = reader;
#line 182 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_tmp23_ = json_reader_count_elements (_tmp22_);
#line 182 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				g_return_val_if_fail (_tmp23_ == 2, NULL);
#line 183 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_tmp24_ = reader;
#line 183 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				json_reader_read_element (_tmp24_, (guint) 0);
#line 184 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_tmp25_ = reader;
#line 184 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_tmp26_ = json_reader_is_value (_tmp25_);
#line 184 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				g_return_val_if_fail (_tmp26_, NULL);
#line 185 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_tmp27_ = reader;
#line 185 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_tmp28_ = json_reader_get_int_value (_tmp27_);
#line 185 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				row = (gint) _tmp28_;
#line 186 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_tmp29_ = reader;
#line 186 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				json_reader_end_element (_tmp29_);
#line 188 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_tmp30_ = reader;
#line 188 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				json_reader_read_element (_tmp30_, (guint) 1);
#line 189 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_tmp31_ = reader;
#line 189 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_tmp32_ = json_reader_is_value (_tmp31_);
#line 189 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				g_return_val_if_fail (_tmp32_, NULL);
#line 190 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_tmp33_ = reader;
#line 190 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_tmp34_ = json_reader_get_int_value (_tmp33_);
#line 190 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				col = (gint) _tmp34_;
#line 191 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_tmp35_ = reader;
#line 191 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				json_reader_end_element (_tmp35_);
#line 192 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_tmp36_ = reader;
#line 192 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				json_reader_end_member (_tmp36_);
#line 194 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_tmp37_ = reader;
#line 194 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				json_reader_read_member (_tmp37_, "value");
#line 195 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_tmp38_ = reader;
#line 195 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_tmp39_ = json_reader_is_value (_tmp38_);
#line 195 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				g_return_val_if_fail (_tmp39_, NULL);
#line 196 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_tmp40_ = reader;
#line 196 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_tmp41_ = json_reader_get_int_value (_tmp40_);
#line 196 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				val = (gint) _tmp41_;
#line 197 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_tmp42_ = reader;
#line 197 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				json_reader_end_member (_tmp42_);
#line 199 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_tmp43_ = reader;
#line 199 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				json_reader_read_member (_tmp43_, "fixed");
#line 200 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_tmp44_ = reader;
#line 200 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_tmp45_ = json_reader_is_value (_tmp44_);
#line 200 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				g_return_val_if_fail (_tmp45_, NULL);
#line 201 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_tmp46_ = reader;
#line 201 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_tmp47_ = json_reader_get_boolean_value (_tmp46_);
#line 201 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				is_fixed = _tmp47_;
#line 202 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_tmp48_ = reader;
#line 202 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				json_reader_end_member (_tmp48_);
#line 204 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_tmp49_ = val;
#line 204 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				if (_tmp49_ != 0) {
#line 1552 "sudoku-saver.c"
					SudokuBoard* _tmp50_ = NULL;
					gint _tmp51_ = 0;
					gint _tmp52_ = 0;
					gint _tmp53_ = 0;
					gboolean _tmp54_ = FALSE;
#line 205 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
					_tmp50_ = board;
#line 205 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
					_tmp51_ = row;
#line 205 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
					_tmp52_ = col;
#line 205 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
					_tmp53_ = val;
#line 205 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
					_tmp54_ = is_fixed;
#line 205 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
					sudoku_board_insert (_tmp50_, _tmp51_, _tmp52_, _tmp53_, _tmp54_);
#line 1570 "sudoku-saver.c"
				}
#line 207 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_tmp55_ = reader;
#line 207 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				json_reader_read_member (_tmp55_, "earmarks");
#line 208 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_tmp56_ = reader;
#line 208 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_tmp57_ = json_reader_is_array (_tmp56_);
#line 208 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				g_return_val_if_fail (_tmp57_, NULL);
#line 1582 "sudoku-saver.c"
				{
					gint k = 0;
#line 209 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
					k = 0;
#line 1587 "sudoku-saver.c"
					{
						gboolean _tmp58_ = FALSE;
#line 209 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
						_tmp58_ = TRUE;
#line 209 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
						while (TRUE) {
#line 1594 "sudoku-saver.c"
							gint _tmp60_ = 0;
							JsonReader* _tmp61_ = NULL;
							gint _tmp62_ = 0;
							JsonReader* _tmp63_ = NULL;
							gint _tmp64_ = 0;
							JsonReader* _tmp65_ = NULL;
							gboolean _tmp66_ = FALSE;
							SudokuBoard* _tmp67_ = NULL;
							gint _tmp68_ = 0;
							gint _tmp69_ = 0;
							JsonReader* _tmp70_ = NULL;
							gint64 _tmp71_ = 0LL;
							JsonReader* _tmp72_ = NULL;
#line 209 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							if (!_tmp58_) {
#line 1610 "sudoku-saver.c"
								gint _tmp59_ = 0;
#line 209 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
								_tmp59_ = k;
#line 209 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
								k = _tmp59_ + 1;
#line 1616 "sudoku-saver.c"
							}
#line 209 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							_tmp58_ = FALSE;
#line 209 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							_tmp60_ = k;
#line 209 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							_tmp61_ = reader;
#line 209 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							_tmp62_ = json_reader_count_elements (_tmp61_);
#line 209 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							if (!(_tmp60_ < _tmp62_)) {
#line 209 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
								break;
#line 1630 "sudoku-saver.c"
							}
#line 211 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							_tmp63_ = reader;
#line 211 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							_tmp64_ = k;
#line 211 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							json_reader_read_element (_tmp63_, (guint) _tmp64_);
#line 212 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							_tmp65_ = reader;
#line 212 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							_tmp66_ = json_reader_is_value (_tmp65_);
#line 212 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							g_return_val_if_fail (_tmp66_, NULL);
#line 213 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							_tmp67_ = board;
#line 213 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							_tmp68_ = row;
#line 213 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							_tmp69_ = col;
#line 213 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							_tmp70_ = reader;
#line 213 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							_tmp71_ = json_reader_get_int_value (_tmp70_);
#line 213 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							sudoku_board_enable_earmark (_tmp67_, _tmp68_, _tmp69_, (gint) _tmp71_);
#line 214 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							_tmp72_ = reader;
#line 214 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
							json_reader_end_element (_tmp72_);
#line 1660 "sudoku-saver.c"
						}
					}
				}
#line 216 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_tmp73_ = reader;
#line 216 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				json_reader_end_member (_tmp73_);
#line 218 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				_tmp74_ = reader;
#line 218 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
				json_reader_end_element (_tmp74_);
#line 1672 "sudoku-saver.c"
			}
		}
	}
#line 220 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp75_ = reader;
#line 220 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	json_reader_end_member (_tmp75_);
#line 222 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp76_ = reader;
#line 222 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	json_reader_read_member (_tmp76_, "time_elapsed");
#line 223 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp77_ = reader;
#line 223 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp78_ = json_reader_is_value (_tmp77_);
#line 223 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	g_return_val_if_fail (_tmp78_, NULL);
#line 224 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp79_ = board;
#line 224 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp80_ = reader;
#line 224 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp81_ = json_reader_get_double_value (_tmp80_);
#line 224 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	sudoku_board_set_previous_played_time (_tmp79_, _tmp81_);
#line 225 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp82_ = reader;
#line 225 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	json_reader_end_member (_tmp82_);
#line 227 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp83_ = reader;
#line 227 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	json_reader_read_member (_tmp83_, "difficulty_category");
#line 228 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp84_ = reader;
#line 228 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp85_ = json_reader_is_value (_tmp84_);
#line 228 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	g_return_val_if_fail (_tmp85_, NULL);
#line 229 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp86_ = board;
#line 229 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp87_ = reader;
#line 229 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp88_ = json_reader_get_string_value (_tmp87_);
#line 229 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp89_ = difficulty_category_from_string (_tmp88_);
#line 229 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	sudoku_board_set_difficulty_category (_tmp86_, _tmp89_);
#line 230 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp90_ = reader;
#line 230 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	json_reader_end_member (_tmp90_);
#line 232 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp91_ = board;
#line 232 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp92_ = sudoku_game_new (_tmp91_);
#line 232 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	result = _tmp92_;
#line 232 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_g_object_unref0 (reader);
#line 232 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	__vala_JsonNode_free0 (node);
#line 232 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_g_object_unref0 (board);
#line 232 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_g_object_unref0 (parser);
#line 232 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	return result;
#line 1742 "sudoku-saver.c"
}


const gchar* sudoku_saver_get_savegame_file (void) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 26 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp0_ = sudoku_saver__savegame_file;
#line 26 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	result = _tmp0_;
#line 26 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	return result;
#line 1755 "sudoku-saver.c"
}


static void sudoku_saver_set_savegame_file (const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 26 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp0_ = value;
#line 26 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 26 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_g_free0 (sudoku_saver__savegame_file);
#line 26 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	sudoku_saver__savegame_file = _tmp1_;
#line 1770 "sudoku-saver.c"
}


const gchar* sudoku_saver_get_finishgame_dir (void) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 27 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp0_ = sudoku_saver__finishgame_dir;
#line 27 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	result = _tmp0_;
#line 27 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	return result;
#line 1783 "sudoku-saver.c"
}


static void sudoku_saver_set_finishgame_dir (const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 27 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp0_ = value;
#line 27 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 27 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_g_free0 (sudoku_saver__finishgame_dir);
#line 27 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	sudoku_saver__finishgame_dir = _tmp1_;
#line 1798 "sudoku-saver.c"
}


static void sudoku_saver_class_init (SudokuSaverClass * klass) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	sudoku_saver_parent_class = g_type_class_peek_parent (klass);
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_sudoku_saver_get_property;
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_sudoku_saver_set_property;
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	G_OBJECT_CLASS (klass)->finalize = sudoku_saver_finalize;
#line 26 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp0_ = g_strdup ("");
#line 26 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	sudoku_saver__savegame_file = _tmp0_;
#line 27 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	_tmp1_ = g_strdup ("");
#line 27 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	sudoku_saver__finishgame_dir = _tmp1_;
#line 1821 "sudoku-saver.c"
}


static void sudoku_saver_instance_init (SudokuSaver * self) {
}


static void sudoku_saver_finalize (GObject* obj) {
	SudokuSaver * self;
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SUDOKU_SAVER, SudokuSaver);
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	G_OBJECT_CLASS (sudoku_saver_parent_class)->finalize (obj);
#line 1835 "sudoku-saver.c"
}


GType sudoku_saver_get_type (void) {
	static volatile gsize sudoku_saver_type_id__volatile = 0;
	if (g_once_init_enter (&sudoku_saver_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SudokuSaverClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sudoku_saver_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SudokuSaver), 0, (GInstanceInitFunc) sudoku_saver_instance_init, NULL };
		GType sudoku_saver_type_id;
		sudoku_saver_type_id = g_type_register_static (G_TYPE_OBJECT, "SudokuSaver", &g_define_type_info, 0);
		g_once_init_leave (&sudoku_saver_type_id__volatile, sudoku_saver_type_id);
	}
	return sudoku_saver_type_id__volatile;
}


static void _vala_sudoku_saver_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SudokuSaver * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SUDOKU_SAVER, SudokuSaver);
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	switch (property_id) {
#line 1856 "sudoku-saver.c"
		default:
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		break;
#line 1862 "sudoku-saver.c"
	}
}


static void _vala_sudoku_saver_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SudokuSaver * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SUDOKU_SAVER, SudokuSaver);
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
	switch (property_id) {
#line 1872 "sudoku-saver.c"
		default:
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-saver.vala"
		break;
#line 1878 "sudoku-saver.c"
	}
}



