/* sudoku-solver.c generated by valac 0.24.0.88-5dc64, the Vala compiler
 * generated from sudoku-solver.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>
#include <gobject/gvaluecollector.h>


#define TYPE_SUDOKU_SOLVER (sudoku_solver_get_type ())
#define SUDOKU_SOLVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_SOLVER, SudokuSolver))
#define SUDOKU_SOLVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_SOLVER, SudokuSolverClass))
#define IS_SUDOKU_SOLVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_SOLVER))
#define IS_SUDOKU_SOLVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_SOLVER))
#define SUDOKU_SOLVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_SOLVER, SudokuSolverClass))

typedef struct _SudokuSolver SudokuSolver;
typedef struct _SudokuSolverClass SudokuSolverClass;
typedef struct _SudokuSolverPrivate SudokuSolverPrivate;

#define TYPE_SUDOKU_BOARD (sudoku_board_get_type ())
#define SUDOKU_BOARD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_BOARD, SudokuBoard))
#define SUDOKU_BOARD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_BOARD, SudokuBoardClass))
#define IS_SUDOKU_BOARD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_BOARD))
#define IS_SUDOKU_BOARD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_BOARD))
#define SUDOKU_BOARD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_BOARD, SudokuBoardClass))

typedef struct _SudokuBoard SudokuBoard;
typedef struct _SudokuBoardClass SudokuBoardClass;

#define TYPE_GUESS_LIST (guess_list_get_type ())
#define GUESS_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GUESS_LIST, GuessList))
#define GUESS_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GUESS_LIST, GuessListClass))
#define IS_GUESS_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GUESS_LIST))
#define IS_GUESS_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GUESS_LIST))
#define GUESS_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GUESS_LIST, GuessListClass))

typedef struct _GuessList GuessList;
typedef struct _GuessListClass GuessListClass;

#define TYPE_BREADCRUMB_TRAIL (breadcrumb_trail_get_type ())
#define BREADCRUMB_TRAIL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BREADCRUMB_TRAIL, BreadcrumbTrail))
#define BREADCRUMB_TRAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BREADCRUMB_TRAIL, BreadcrumbTrailClass))
#define IS_BREADCRUMB_TRAIL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BREADCRUMB_TRAIL))
#define IS_BREADCRUMB_TRAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BREADCRUMB_TRAIL))
#define BREADCRUMB_TRAIL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BREADCRUMB_TRAIL, BreadcrumbTrailClass))

typedef struct _BreadcrumbTrail BreadcrumbTrail;
typedef struct _BreadcrumbTrailClass BreadcrumbTrailClass;

#define TYPE_PARALLEL_DICT (parallel_dict_get_type ())
#define PARALLEL_DICT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PARALLEL_DICT, ParallelDict))
#define PARALLEL_DICT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PARALLEL_DICT, ParallelDictClass))
#define IS_PARALLEL_DICT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PARALLEL_DICT))
#define IS_PARALLEL_DICT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PARALLEL_DICT))
#define PARALLEL_DICT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PARALLEL_DICT, ParallelDictClass))

typedef struct _ParallelDict ParallelDict;
typedef struct _ParallelDictClass ParallelDictClass;

#define TYPE_GUESS (guess_get_type ())
#define GUESS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GUESS, Guess))
#define GUESS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GUESS, GuessClass))
#define IS_GUESS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GUESS))
#define IS_GUESS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GUESS))
#define GUESS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GUESS, GuessClass))

typedef struct _Guess Guess;
typedef struct _GuessClass GuessClass;
#define _sudoku_board_unref0(var) ((var == NULL) ? NULL : (var = (sudoku_board_unref (var), NULL)))
#define _parallel_dict_unref0(var) ((var == NULL) ? NULL : (var = (parallel_dict_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _guess_unref0(var) ((var == NULL) ? NULL : (var = (guess_unref (var), NULL)))

#define SUDOKU_SOLVER_TYPE_ITERATOR (sudoku_solver_iterator_get_type ())
#define SUDOKU_SOLVER_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SUDOKU_SOLVER_TYPE_ITERATOR, SudokuSolverIterator))
#define SUDOKU_SOLVER_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SUDOKU_SOLVER_TYPE_ITERATOR, SudokuSolverIteratorClass))
#define SUDOKU_SOLVER_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SUDOKU_SOLVER_TYPE_ITERATOR))
#define SUDOKU_SOLVER_IS_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SUDOKU_SOLVER_TYPE_ITERATOR))
#define SUDOKU_SOLVER_ITERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SUDOKU_SOLVER_TYPE_ITERATOR, SudokuSolverIteratorClass))

typedef struct _SudokuSolverIterator SudokuSolverIterator;
typedef struct _SudokuSolverIteratorClass SudokuSolverIteratorClass;
#define _sudoku_solver_iterator_unref0(var) ((var == NULL) ? NULL : (var = (sudoku_solver_iterator_unref (var), NULL)))

#define TYPE_CELL (cell_get_type ())

#define TYPE_COORD (coord_get_type ())
typedef struct _Coord Coord;
typedef struct _Cell Cell;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _coord_free0(var) ((var == NULL) ? NULL : (var = (coord_free (var), NULL)))
typedef struct _SudokuBoardPrivate SudokuBoardPrivate;
typedef struct _GuessPrivate GuessPrivate;
typedef struct _SudokuSolverIteratorPrivate SudokuSolverIteratorPrivate;
#define _sudoku_solver_unref0(var) ((var == NULL) ? NULL : (var = (sudoku_solver_unref (var), NULL)))
typedef struct _SudokuSolverParamSpecIterator SudokuSolverParamSpecIterator;
typedef struct _ParamSpecSudokuSolver ParamSpecSudokuSolver;

#define TYPE_SUDOKU_RATER (sudoku_rater_get_type ())
#define SUDOKU_RATER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_RATER, SudokuRater))
#define SUDOKU_RATER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_RATER, SudokuRaterClass))
#define IS_SUDOKU_RATER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_RATER))
#define IS_SUDOKU_RATER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_RATER))
#define SUDOKU_RATER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_RATER, SudokuRaterClass))

typedef struct _SudokuRater SudokuRater;
typedef struct _SudokuRaterClass SudokuRaterClass;
typedef struct _SudokuRaterPrivate SudokuRaterPrivate;
#define _cell_free0(var) ((var == NULL) ? NULL : (var = (cell_free (var), NULL)))

#define TYPE_DIFFICULTY_RATING (difficulty_rating_get_type ())
#define DIFFICULTY_RATING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DIFFICULTY_RATING, DifficultyRating))
#define DIFFICULTY_RATING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DIFFICULTY_RATING, DifficultyRatingClass))
#define IS_DIFFICULTY_RATING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DIFFICULTY_RATING))
#define IS_DIFFICULTY_RATING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DIFFICULTY_RATING))
#define DIFFICULTY_RATING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DIFFICULTY_RATING, DifficultyRatingClass))

typedef struct _DifficultyRating DifficultyRating;
typedef struct _DifficultyRatingClass DifficultyRatingClass;
#define _difficulty_rating_unref0(var) ((var == NULL) ? NULL : (var = (difficulty_rating_unref (var), NULL)))
typedef struct _ParamSpecGuess ParamSpecGuess;
typedef struct _GuessListPrivate GuessListPrivate;
typedef struct _BreadcrumbTrailPrivate BreadcrumbTrailPrivate;
typedef struct _ParallelDictPrivate ParallelDictPrivate;
typedef struct _ParamSpecParallelDict ParamSpecParallelDict;

#define TYPE_DIFFICULTY_CATEGORY (difficulty_category_get_type ())
typedef struct _DifficultyRatingPrivate DifficultyRatingPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ParamSpecDifficultyRating ParamSpecDifficultyRating;

typedef enum  {
	SUDOKU_ERROR_UNSOLVABLE_PUZZLE,
	SUDOKU_ERROR_CONFLICT_ERROR,
	SUDOKU_ERROR_ALREADY_SET_ERROR
} SudokuError;
#define SUDOKU_ERROR sudoku_error_quark ()
struct _SudokuSolver {
	GTypeInstance parent_instance;
	volatile int ref_count;
	SudokuSolverPrivate * priv;
	SudokuBoard* board;
	GuessList* guesses;
	BreadcrumbTrail* breadcrumbs;
	gint backtraces;
	gboolean solved;
};

struct _SudokuSolverClass {
	GTypeClass parent_class;
	void (*finalize) (SudokuSolver *self);
	gboolean (*guess_least_open_square) (SudokuSolver* self, GError** error);
	void (*insert) (SudokuSolver* self, gint row, gint col, gint val);
};

struct _SudokuSolverPrivate {
	ParallelDict* conflicts;
	Guess* current_guess;
	gboolean count_solutions;
	gint break_at;
	GeeArrayList* trail;
	GeeArrayList* trailDetails;
	gint debug_indent;
};

struct _Coord {
	gint row;
	gint col;
};

struct _Cell {
	Coord coord;
	gint val;
};

struct _SudokuBoard {
	GTypeInstance parent_instance;
	volatile int ref_count;
	SudokuBoardPrivate * priv;
	gint* cells;
	gint cells_length1;
	gint cells_length2;
	gboolean* is_fixed;
	gint is_fixed_length1;
	gint is_fixed_length2;
	gboolean* earmarks;
	gint earmarks_length1;
	gint earmarks_length2;
	gint earmarks_length3;
	GeeSet* broken_coords;
	GeeList* coords_for_col;
	GeeList* coords_for_row;
	GeeMap* coords_for_block;
};

struct _SudokuBoardClass {
	GTypeClass parent_class;
	void (*finalize) (SudokuBoard *self);
};

struct _Guess {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GuessPrivate * priv;
	GeeArrayList* children;
	GeeHashMap* consequences;
};

struct _GuessClass {
	GTypeClass parent_class;
	void (*finalize) (Guess *self);
};

struct _SudokuSolverIterator {
	GTypeInstance parent_instance;
	volatile int ref_count;
	SudokuSolverIteratorPrivate * priv;
};

struct _SudokuSolverIteratorClass {
	GTypeClass parent_class;
	void (*finalize) (SudokuSolverIterator *self);
};

struct _SudokuSolverIteratorPrivate {
	SudokuSolver* solver;
	SudokuBoard* solution;
};

struct _SudokuSolverParamSpecIterator {
	GParamSpec parent_instance;
};

struct _ParamSpecSudokuSolver {
	GParamSpec parent_instance;
};

struct _SudokuRater {
	SudokuSolver parent_instance;
	SudokuRaterPrivate * priv;
};

struct _SudokuRaterClass {
	SudokuSolverClass parent_class;
};

struct _SudokuRaterPrivate {
	gboolean guessing;
	gboolean fake_add;
	GeeArrayList* fake_additions;
	GeeArrayList* add_me_queue;
	GeeHashSet* filled;
	GeeHashMap* fill_must_fillables;
	GeeHashMap* elimination_fillables;
	gint tier;
};

struct _GuessPrivate {
	gint _row;
	gint _col;
	gint _val;
};

struct _ParamSpecGuess {
	GParamSpec parent_instance;
};

struct _GuessList {
	GeeArrayList parent_instance;
	GuessListPrivate * priv;
};

struct _GuessListClass {
	GeeArrayListClass parent_class;
};

struct _BreadcrumbTrail {
	GuessList parent_instance;
	BreadcrumbTrailPrivate * priv;
};

struct _BreadcrumbTrailClass {
	GuessListClass parent_class;
};

struct _ParallelDict {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ParallelDictPrivate * priv;
};

struct _ParallelDictClass {
	GTypeClass parent_class;
	void (*finalize) (ParallelDict *self);
};

struct _ParallelDictPrivate {
	GeeHashMap* map;
};

struct _ParamSpecParallelDict {
	GParamSpec parent_instance;
};

typedef enum  {
	DIFFICULTY_CATEGORY_EASY,
	DIFFICULTY_CATEGORY_MEDIUM,
	DIFFICULTY_CATEGORY_HARD,
	DIFFICULTY_CATEGORY_VERY_HARD
} DifficultyCategory;

struct _DifficultyRating {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DifficultyRatingPrivate * priv;
	gfloat rating;
};

struct _DifficultyRatingClass {
	GTypeClass parent_class;
	void (*finalize) (DifficultyRating *self);
};

struct _DifficultyRatingPrivate {
	GeeHashMap* fill_must_fillables;
	GeeHashMap* elimination_fillables;
	GuessList* guesses;
	gint backtraces;
	gint squares_filled;
	gfloat elimination_ease;
	gfloat fillable_ease;
	gfloat instant_fill_fillable;
	gfloat instant_elimination_fillable;
	gfloat proportion_instant_elimination_fillable;
	gfloat proportion_instant_fill_fillable;
};

typedef gint (*DifficultyRatingDiminshBy) (gint a, void* user_data);
struct _ParamSpecDifficultyRating {
	GParamSpec parent_instance;
};


static gpointer sudoku_solver_parent_class = NULL;
static gpointer sudoku_solver_iterator_parent_class = NULL;
static gpointer sudoku_rater_parent_class = NULL;
static gpointer guess_parent_class = NULL;
static gpointer guess_list_parent_class = NULL;
static gpointer breadcrumb_trail_parent_class = NULL;
static gpointer parallel_dict_parent_class = NULL;
static gpointer difficulty_rating_parent_class = NULL;

GQuark sudoku_error_quark (void);
gpointer sudoku_solver_ref (gpointer instance);
void sudoku_solver_unref (gpointer instance);
GParamSpec* param_spec_sudoku_solver (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_sudoku_solver (GValue* value, gpointer v_object);
void value_take_sudoku_solver (GValue* value, gpointer v_object);
gpointer value_get_sudoku_solver (const GValue* value);
GType sudoku_solver_get_type (void) G_GNUC_CONST;
gpointer sudoku_board_ref (gpointer instance);
void sudoku_board_unref (gpointer instance);
GParamSpec* param_spec_sudoku_board (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_sudoku_board (GValue* value, gpointer v_object);
void value_take_sudoku_board (GValue* value, gpointer v_object);
gpointer value_get_sudoku_board (const GValue* value);
GType sudoku_board_get_type (void) G_GNUC_CONST;
GType guess_list_get_type (void) G_GNUC_CONST;
GType breadcrumb_trail_get_type (void) G_GNUC_CONST;
gpointer parallel_dict_ref (gpointer instance);
void parallel_dict_unref (gpointer instance);
GParamSpec* param_spec_parallel_dict (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_parallel_dict (GValue* value, gpointer v_object);
void value_take_parallel_dict (GValue* value, gpointer v_object);
gpointer value_get_parallel_dict (const GValue* value);
GType parallel_dict_get_type (void) G_GNUC_CONST;
gpointer guess_ref (gpointer instance);
void guess_unref (gpointer instance);
GParamSpec* param_spec_guess (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_guess (GValue* value, gpointer v_object);
void value_take_guess (GValue* value, gpointer v_object);
gpointer value_get_guess (const GValue* value);
GType guess_get_type (void) G_GNUC_CONST;
#define SUDOKU_SOLVER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SUDOKU_SOLVER, SudokuSolverPrivate))
enum  {
	SUDOKU_SOLVER_DUMMY_PROPERTY
};
SudokuSolver* sudoku_solver_new (SudokuBoard** board);
SudokuSolver* sudoku_solver_construct (GType object_type, SudokuBoard** board);
ParallelDict* parallel_dict_new (void);
ParallelDict* parallel_dict_construct (GType object_type);
GuessList* guess_list_new (void);
GuessList* guess_list_construct (GType object_type);
BreadcrumbTrail* breadcrumb_trail_new (void);
BreadcrumbTrail* breadcrumb_trail_construct (GType object_type);
gboolean sudoku_solver_quick_has_solution (SudokuSolver* self);
static void sudoku_solver_quick_solve (SudokuSolver* self, gint row, gint col, gint no, gint filled, gint* solution);
gboolean sudoku_solver_quick_has_unique_solution (SudokuSolver* self);
gboolean sudoku_solver_quick_has_many_solution (SudokuSolver* self);
gint sudoku_solver_quick_count_solutions (SudokuSolver* self, gint break_at);
gint sudoku_board_get_filled (SudokuBoard* self);
gint sudoku_board_get_rows (SudokuBoard* self);
gint sudoku_board_get_cols (SudokuBoard* self);
gint sudoku_board_get (SudokuBoard* self, gint row, gint col);
gint sudoku_board_get_max_val (SudokuBoard* self);
gboolean sudoku_board_is_possible (SudokuBoard* self, gint row, gint col, gint val);
void sudoku_board_insert (SudokuBoard* self, gint row, gint col, gint val, gboolean is_fixed);
void sudoku_board_remove (SudokuBoard* self, gint row, gint col, gboolean is_fixed);
gpointer sudoku_solver_iterator_ref (gpointer instance);
void sudoku_solver_iterator_unref (gpointer instance);
GParamSpec* sudoku_solver_param_spec_iterator (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void sudoku_solver_value_set_iterator (GValue* value, gpointer v_object);
void sudoku_solver_value_take_iterator (GValue* value, gpointer v_object);
gpointer sudoku_solver_value_get_iterator (const GValue* value);
GType sudoku_solver_iterator_get_type (void) G_GNUC_CONST;
SudokuSolverIterator* sudoku_solver_iterator (SudokuSolver* self);
SudokuSolverIterator* sudoku_solver_iterator_new (SudokuSolver* solver);
SudokuSolverIterator* sudoku_solver_iterator_construct (GType object_type, SudokuSolver* solver);
gboolean sudoku_solver_has_unique_solution (SudokuSolver* self);
gboolean sudoku_solver_iterator_next (SudokuSolverIterator* self);
SudokuBoard* sudoku_solver_solve (SudokuSolver* self);
GType cell_get_type (void) G_GNUC_CONST;
GType coord_get_type (void) G_GNUC_CONST;
Coord* coord_dup (const Coord* self);
void coord_free (Coord* self);
Cell* cell_dup (const Cell* self);
void cell_free (Cell* self);
static GeeArrayList* sudoku_solver_auto_fill (SudokuSolver* self);
gboolean sudoku_solver_guess_least_open_square (SudokuSolver* self, GError** error);
GeeArrayList* sudoku_solver_fill_must_fills (SudokuSolver* self, GError** error);
GeeArrayList* sudoku_solver_fill_deterministically (SudokuSolver* self);
GeeHashMap* sudoku_board_calculate_open_squares (SudokuBoard* self);
void sudoku_solver_insert (SudokuSolver* self, gint row, gint col, gint val);
void cell_init (Cell *self, Coord* coord, gint val);
static GeeArrayList* sudoku_solver_fill_must_fills_for (SudokuSolver* self, GeeList* coords, GError** error);
gint sudoku_board_get_block_cols (SudokuBoard* self);
gint sudoku_board_get_block_rows (SudokuBoard* self);
void coord_init (Coord *self, gint row, gint col);
gboolean parallel_dict_contains (ParallelDict* self, Coord* key);
gboolean coord_equal (Coord* a, Coord* b);
gint* sudoku_board_get_possibilities (SudokuBoard* self, gint row, gint col, int* result_length1);
static gboolean sudoku_solver_real_guess_least_open_square (SudokuSolver* self, GError** error);
Guess** guess_list_guesses_for (GuessList* self, gint row, gint col, int* result_length1);
gint guess_get_val (Guess* self);
static void sudoku_solver_unwrap_guess (SudokuSolver* self, Guess* guess);
Guess* guess_new (gint row, gint col, gint val);
Guess* guess_construct (GType object_type, gint row, gint col, gint val);
gint guess_get_row (Guess* self);
gint guess_get_col (Guess* self);
static void sudoku_solver_real_insert (SudokuSolver* self, gint row, gint col, gint val);
void guess_add_consequence (Guess* self, gint row, gint col, gint val);
#define SUDOKU_SOLVER_ITERATOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SUDOKU_SOLVER_TYPE_ITERATOR, SudokuSolverIteratorPrivate))
enum  {
	SUDOKU_SOLVER_ITERATOR_DUMMY_PROPERTY
};
SudokuBoard* sudoku_solver_iterator_get (SudokuSolverIterator* self);
static void sudoku_solver_iterator_finalize (SudokuSolverIterator* obj);
static void sudoku_solver_finalize (SudokuSolver* obj);
GType sudoku_rater_get_type (void) G_GNUC_CONST;
#define SUDOKU_RATER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SUDOKU_RATER, SudokuRaterPrivate))
enum  {
	SUDOKU_RATER_DUMMY_PROPERTY
};
SudokuRater* sudoku_rater_new (SudokuBoard** board);
SudokuRater* sudoku_rater_construct (GType object_type, SudokuBoard** board);
gint cell_hash (Cell* cell);
gboolean cell_equal (Cell* a, Cell* b);
static void sudoku_rater_real_insert (SudokuSolver* base, gint row, gint col, gint val);
static void sudoku_rater_scan_fillables (SudokuRater* self);
static gboolean sudoku_rater_real_guess_least_open_square (SudokuSolver* base, GError** error);
gpointer difficulty_rating_ref (gpointer instance);
void difficulty_rating_unref (gpointer instance);
GParamSpec* param_spec_difficulty_rating (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_difficulty_rating (GValue* value, gpointer v_object);
void value_take_difficulty_rating (GValue* value, gpointer v_object);
gpointer value_get_difficulty_rating (const GValue* value);
GType difficulty_rating_get_type (void) G_GNUC_CONST;
DifficultyRating* sudoku_rater_get_difficulty (SudokuRater* self);
DifficultyRating* difficulty_rating_new (GeeHashMap* fill_must_fillables, GeeHashMap* elimination_fillables, GuessList* guesses, gint backtraces, gint squares_filled);
DifficultyRating* difficulty_rating_construct (GType object_type, GeeHashMap* fill_must_fillables, GeeHashMap* elimination_fillables, GuessList* guesses, gint backtraces, gint squares_filled);
static void sudoku_rater_finalize (SudokuSolver* obj);
#define GUESS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_GUESS, GuessPrivate))
enum  {
	GUESS_DUMMY_PROPERTY
};
gint coord_hash (Coord* coord);
static void guess_finalize (Guess* obj);
enum  {
	GUESS_LIST_DUMMY_PROPERTY
};
static void _vala_array_add6 (Guess*** array, int* length, int* size, Guess* value);
Guess** guess_list_remove_children (GuessList* self, Guess* guess, int* result_length1);
static void _vala_array_add7 (Guess*** array, int* length, int* size, Guess* value);
Guess** guess_list_remove_guesses_for (GuessList* self, gint row, gint col, int* result_length1);
static void _vala_array_add8 (Guess*** array, int* length, int* size, Guess* value);
enum  {
	BREADCRUMB_TRAIL_DUMMY_PROPERTY
};
void breadcrumb_trail_append (BreadcrumbTrail* self, Guess* guess);
#define PARALLEL_DICT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PARALLEL_DICT, ParallelDictPrivate))
enum  {
	PARALLEL_DICT_DUMMY_PROPERTY
};
void parallel_dict_set (ParallelDict* self, Coord* k, GeeHashSet* v);
static gboolean _coord_equal (const Coord* s1, const Coord* s2);
void parallel_dict_unset (ParallelDict* self, Coord* k);
static void parallel_dict_finalize (ParallelDict* obj);
GType difficulty_category_get_type (void) G_GNUC_CONST;
gchar* difficulty_category_to_string (DifficultyCategory self);
#define DIFFICULTY_RATING_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_DIFFICULTY_RATING, DifficultyRatingPrivate))
enum  {
	DIFFICULTY_RATING_DUMMY_PROPERTY
};
static gfloat difficulty_rating_add_with_diminishing_importance (gint* array, int array_length1, DifficultyRatingDiminshBy diminish_by, void* diminish_by_target);
static gint* difficulty_rating_count_values (DifficultyRating* self, GeeHashMap* map, int* result_length1);
static gint difficulty_rating_diminsh_by_one (gint a);
static gint _difficulty_rating_diminsh_by_one_difficulty_rating_diminsh_by (gint a, gpointer self);
static gfloat difficulty_rating_calculate (DifficultyRating* self);
gboolean difficulty_rating_in_range (DifficultyRating* self, gfloat* range, int range_length1);
DifficultyCategory difficulty_rating_get_category (DifficultyRating* self);
gchar* difficulty_rating_to_string (DifficultyRating* self);
static void difficulty_rating_finalize (DifficultyRating* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

const gfloat DIFFICULTY_RATING_VERY_HARD_RANGE[2] = {0.75f, (gfloat) 10};
const gfloat DIFFICULTY_RATING_HARD_RANGE[2] = {0.6f, 0.75f};
const gfloat DIFFICULTY_RATING_MEDIUM_RANGE[2] = {0.45f, 0.6f};
const gfloat DIFFICULTY_RATING_EASY_RANGE[2] = {(gfloat) (-10), 0.45f};

GQuark sudoku_error_quark (void) {
	return g_quark_from_static_string ("sudoku_error-quark");
}


static gpointer _sudoku_board_ref0 (gpointer self) {
	return self ? sudoku_board_ref (self) : NULL;
}


SudokuSolver* sudoku_solver_construct (GType object_type, SudokuBoard** board) {
	SudokuSolver* self = NULL;
	SudokuBoard* _tmp0_ = NULL;
	SudokuBoard* _tmp1_ = NULL;
	ParallelDict* _tmp2_ = NULL;
	GuessList* _tmp3_ = NULL;
	BreadcrumbTrail* _tmp4_ = NULL;
	g_return_val_if_fail (*board != NULL, NULL);
	self = (SudokuSolver*) g_type_create_instance (object_type);
	_tmp0_ = *board;
	_tmp1_ = _sudoku_board_ref0 (_tmp0_);
	_sudoku_board_unref0 (self->board);
	self->board = _tmp1_;
	_tmp2_ = parallel_dict_new ();
	_parallel_dict_unref0 (self->priv->conflicts);
	self->priv->conflicts = _tmp2_;
	_tmp3_ = guess_list_new ();
	_g_object_unref0 (self->guesses);
	self->guesses = _tmp3_;
	_tmp4_ = breadcrumb_trail_new ();
	_g_object_unref0 (self->breadcrumbs);
	self->breadcrumbs = _tmp4_;
	self->solved = FALSE;
	return self;
}


SudokuSolver* sudoku_solver_new (SudokuBoard** board) {
	return sudoku_solver_construct (TYPE_SUDOKU_SOLVER, board);
}


gboolean sudoku_solver_quick_has_solution (SudokuSolver* self) {
	gboolean result = FALSE;
	gint solutions = 0;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	solutions = 0;
	self->priv->count_solutions = FALSE;
	sudoku_solver_quick_solve (self, -1, -1, -1, -1, &solutions);
	_tmp0_ = solutions;
	result = _tmp0_ > 0;
	return result;
}


gboolean sudoku_solver_quick_has_unique_solution (SudokuSolver* self) {
	gboolean result = FALSE;
	gint solutions = 0;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	solutions = 0;
	self->priv->count_solutions = FALSE;
	sudoku_solver_quick_solve (self, -1, -1, -1, -1, &solutions);
	_tmp0_ = solutions;
	result = _tmp0_ == 1;
	return result;
}


gboolean sudoku_solver_quick_has_many_solution (SudokuSolver* self) {
	gboolean result = FALSE;
	gint solutions = 0;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	solutions = 0;
	self->priv->count_solutions = FALSE;
	sudoku_solver_quick_solve (self, -1, -1, -1, -1, &solutions);
	_tmp0_ = solutions;
	result = _tmp0_ > 1;
	return result;
}


gint sudoku_solver_quick_count_solutions (SudokuSolver* self, gint break_at) {
	gint result = 0;
	gint solutions = 0;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	solutions = 0;
	self->priv->count_solutions = TRUE;
	_tmp0_ = break_at;
	self->priv->break_at = _tmp0_;
	sudoku_solver_quick_solve (self, -1, -1, -1, -1, &solutions);
	result = solutions;
	return result;
}


static void sudoku_solver_quick_solve (SudokuSolver* self, gint row, gint col, gint no, gint filled, gint* solution) {
	gint _tmp0_ = 0;
	gint _tmp4_ = 0;
	SudokuBoard* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	SudokuBoard* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	gboolean _tmp12_ = FALSE;
	gint _tmp13_ = 0;
	gint _tmp35_ = 0;
	SudokuBoard* _tmp57_ = NULL;
	gint _tmp58_ = 0;
	gint _tmp59_ = 0;
	gint _tmp60_ = 0;
	gint _tmp61_ = 0;
	SudokuBoard* _tmp62_ = NULL;
	gint _tmp63_ = 0;
	gint _tmp64_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = filled;
	if (_tmp0_ == (-1)) {
		SudokuBoard* _tmp1_ = NULL;
		gint _tmp2_ = 0;
		gint _tmp3_ = 0;
		_tmp1_ = self->board;
		_tmp2_ = sudoku_board_get_filled (_tmp1_);
		_tmp3_ = _tmp2_;
		filled = _tmp3_;
	}
	_tmp4_ = filled;
	_tmp5_ = self->board;
	_tmp6_ = sudoku_board_get_rows (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = self->board;
	_tmp9_ = sudoku_board_get_cols (_tmp8_);
	_tmp10_ = _tmp9_;
	if (_tmp4_ == (_tmp7_ * _tmp10_)) {
		gint _tmp11_ = 0;
		_tmp11_ = *solution;
		*solution = _tmp11_ + 1;
		return;
	}
	_tmp13_ = row;
	if (_tmp13_ == (-1)) {
		_tmp12_ = TRUE;
	} else {
		gint _tmp14_ = 0;
		_tmp14_ = col;
		_tmp12_ = _tmp14_ == (-1);
	}
	if (_tmp12_) {
		{
			gint l1 = 0;
			l1 = 0;
			{
				gboolean _tmp15_ = FALSE;
				_tmp15_ = TRUE;
				while (TRUE) {
					gint _tmp17_ = 0;
					SudokuBoard* _tmp18_ = NULL;
					gint _tmp19_ = 0;
					gint _tmp20_ = 0;
					if (!_tmp15_) {
						gint _tmp16_ = 0;
						_tmp16_ = l1;
						l1 = _tmp16_ + 1;
					}
					_tmp15_ = FALSE;
					_tmp17_ = l1;
					_tmp18_ = self->board;
					_tmp19_ = sudoku_board_get_rows (_tmp18_);
					_tmp20_ = _tmp19_;
					if (!(_tmp17_ < _tmp20_)) {
						break;
					}
					{
						gint l2 = 0;
						l2 = 0;
						{
							gboolean _tmp21_ = FALSE;
							_tmp21_ = TRUE;
							while (TRUE) {
								gint _tmp23_ = 0;
								SudokuBoard* _tmp24_ = NULL;
								gint _tmp25_ = 0;
								gint _tmp26_ = 0;
								SudokuBoard* _tmp27_ = NULL;
								gint _tmp28_ = 0;
								gint _tmp29_ = 0;
								gint _tmp30_ = 0;
								if (!_tmp21_) {
									gint _tmp22_ = 0;
									_tmp22_ = l2;
									l2 = _tmp22_ + 1;
								}
								_tmp21_ = FALSE;
								_tmp23_ = l2;
								_tmp24_ = self->board;
								_tmp25_ = sudoku_board_get_cols (_tmp24_);
								_tmp26_ = _tmp25_;
								if (!(_tmp23_ < _tmp26_)) {
									break;
								}
								_tmp27_ = self->board;
								_tmp28_ = l1;
								_tmp29_ = l2;
								_tmp30_ = sudoku_board_get (_tmp27_, _tmp28_, _tmp29_);
								if (_tmp30_ == 0) {
									gint _tmp31_ = 0;
									gint _tmp32_ = 0;
									gint _tmp33_ = 0;
									gint _tmp34_ = 0;
									_tmp31_ = l1;
									_tmp32_ = l2;
									_tmp33_ = no;
									_tmp34_ = filled;
									sudoku_solver_quick_solve (self, _tmp31_, _tmp32_, _tmp33_, _tmp34_, solution);
									return;
								}
							}
						}
					}
				}
			}
		}
	}
	_tmp35_ = no;
	if (_tmp35_ == (-1)) {
		{
			gint l1 = 0;
			l1 = 1;
			{
				gboolean _tmp36_ = FALSE;
				_tmp36_ = TRUE;
				while (TRUE) {
					gint _tmp38_ = 0;
					SudokuBoard* _tmp39_ = NULL;
					gint _tmp40_ = 0;
					gint _tmp41_ = 0;
					SudokuBoard* _tmp42_ = NULL;
					gint _tmp43_ = 0;
					gint _tmp44_ = 0;
					gint _tmp45_ = 0;
					gboolean _tmp46_ = FALSE;
					if (!_tmp36_) {
						gint _tmp37_ = 0;
						_tmp37_ = l1;
						l1 = _tmp37_ + 1;
					}
					_tmp36_ = FALSE;
					_tmp38_ = l1;
					_tmp39_ = self->board;
					_tmp40_ = sudoku_board_get_max_val (_tmp39_);
					_tmp41_ = _tmp40_;
					if (!(_tmp38_ <= _tmp41_)) {
						break;
					}
					_tmp42_ = self->board;
					_tmp43_ = row;
					_tmp44_ = col;
					_tmp45_ = l1;
					_tmp46_ = sudoku_board_is_possible (_tmp42_, _tmp43_, _tmp44_, _tmp45_);
					if (_tmp46_) {
						gint _tmp47_ = 0;
						gint _tmp48_ = 0;
						gint _tmp49_ = 0;
						gint _tmp50_ = 0;
						gboolean _tmp51_ = FALSE;
						gboolean _tmp52_ = FALSE;
						gboolean _tmp53_ = FALSE;
						_tmp47_ = row;
						_tmp48_ = col;
						_tmp49_ = l1;
						_tmp50_ = filled;
						sudoku_solver_quick_solve (self, _tmp47_, _tmp48_, _tmp49_, _tmp50_, solution);
						_tmp53_ = self->priv->count_solutions;
						if (!_tmp53_) {
							gint _tmp54_ = 0;
							_tmp54_ = *solution;
							_tmp52_ = _tmp54_ > 1;
						} else {
							_tmp52_ = FALSE;
						}
						if (_tmp52_) {
							_tmp51_ = TRUE;
						} else {
							gint _tmp55_ = 0;
							gint _tmp56_ = 0;
							_tmp55_ = *solution;
							_tmp56_ = self->priv->break_at;
							_tmp51_ = _tmp55_ > _tmp56_;
						}
						if (_tmp51_) {
							return;
						}
					}
				}
			}
		}
		return;
	}
	_tmp57_ = self->board;
	_tmp58_ = row;
	_tmp59_ = col;
	_tmp60_ = no;
	sudoku_board_insert (_tmp57_, _tmp58_, _tmp59_, _tmp60_, FALSE);
	_tmp61_ = filled;
	sudoku_solver_quick_solve (self, -1, -1, -1, _tmp61_ + 1, solution);
	_tmp62_ = self->board;
	_tmp63_ = row;
	_tmp64_ = col;
	sudoku_board_remove (_tmp62_, _tmp63_, _tmp64_, FALSE);
}


SudokuSolverIterator* sudoku_solver_iterator (SudokuSolver* self) {
	SudokuSolverIterator* result = NULL;
	SudokuSolverIterator* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = sudoku_solver_iterator_new (self);
	result = _tmp0_;
	return result;
}


gboolean sudoku_solver_has_unique_solution (SudokuSolver* self) {
	gboolean result = FALSE;
	SudokuSolverIterator* sf = NULL;
	SudokuSolverIterator* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	SudokuSolverIterator* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = sudoku_solver_iterator (self);
	sf = _tmp0_;
	_tmp2_ = sf;
	_tmp3_ = sudoku_solver_iterator_next (_tmp2_);
	if (_tmp3_ == TRUE) {
		SudokuSolverIterator* _tmp4_ = NULL;
		gboolean _tmp5_ = FALSE;
		_tmp4_ = sf;
		_tmp5_ = sudoku_solver_iterator_next (_tmp4_);
		_tmp1_ = _tmp5_ == FALSE;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		result = TRUE;
		_sudoku_solver_iterator_unref0 (sf);
		return result;
	} else {
		result = FALSE;
		_sudoku_solver_iterator_unref0 (sf);
		return result;
	}
	_sudoku_solver_iterator_unref0 (sf);
}


SudokuBoard* sudoku_solver_solve (SudokuSolver* self) {
	SudokuBoard* result = NULL;
	GeeArrayList* _tmp0_ = NULL;
	GeeArrayList* _tmp1_ = NULL;
	SudokuBoard* _tmp4_ = NULL;
	SudokuBoard* _tmp5_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = sudoku_solver_auto_fill (self);
	_tmp1_ = _tmp0_;
	_g_object_unref0 (_tmp1_);
	{
		while (TRUE) {
			gboolean _tmp2_ = FALSE;
			gboolean _tmp3_ = FALSE;
			_tmp3_ = sudoku_solver_guess_least_open_square (self, &_inner_error_);
			_tmp2_ = _tmp3_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == SUDOKU_ERROR) {
					goto __catch3_sudoku_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
			if (!(!_tmp2_)) {
				break;
			}
		}
	}
	goto __finally3;
	__catch3_sudoku_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (e);
	}
	__finally3:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	self->solved = TRUE;
	_tmp4_ = self->board;
	_tmp5_ = _sudoku_board_ref0 (_tmp4_);
	result = _tmp5_;
	return result;
}


static GeeArrayList* sudoku_solver_auto_fill (SudokuSolver* self) {
	GeeArrayList* result = NULL;
	GeeArrayList* changed = NULL;
	GeeArrayList* _tmp0_ = NULL;
	GeeArrayList* _tmp4_ = NULL;
	GeeArrayList* _tmp5_ = NULL;
	GeeArrayList* _tmp6_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gee_array_list_new (TYPE_CELL, (GBoxedCopyFunc) cell_dup, cell_free, NULL, NULL, NULL);
	changed = _tmp0_;
	{
		GeeArrayList* _tmp1_ = NULL;
		GeeArrayList* _tmp2_ = NULL;
		GeeArrayList* _tmp3_ = NULL;
		_tmp2_ = sudoku_solver_fill_must_fills (self, &_inner_error_);
		_tmp1_ = _tmp2_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == SUDOKU_ERROR) {
				goto __catch4_sudoku_error;
			}
			_g_object_unref0 (changed);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp3_ = changed;
		gee_array_list_add_all (_tmp3_, (GeeCollection*) _tmp1_);
		_g_object_unref0 (_tmp1_);
	}
	goto __finally4;
	__catch4_sudoku_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		result = changed;
		_g_error_free0 (e);
		return result;
	}
	__finally4:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (changed);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp4_ = changed;
	_tmp5_ = sudoku_solver_fill_deterministically (self);
	_tmp6_ = _tmp5_;
	gee_array_list_add_all (_tmp4_, (GeeCollection*) _tmp6_);
	_g_object_unref0 (_tmp6_);
	result = changed;
	return result;
}


GeeArrayList* sudoku_solver_fill_deterministically (SudokuSolver* self) {
	GeeArrayList* result = NULL;
	GeeHashMap* poss = NULL;
	SudokuBoard* _tmp0_ = NULL;
	GeeHashMap* _tmp1_ = NULL;
	GeeArrayList* changed = NULL;
	GeeArrayList* _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->board;
	_tmp1_ = sudoku_board_calculate_open_squares (_tmp0_);
	poss = _tmp1_;
	_tmp2_ = gee_array_list_new (TYPE_CELL, (GBoxedCopyFunc) cell_dup, cell_free, NULL, NULL, NULL);
	changed = _tmp2_;
	{
		GeeIterator* _coord_it = NULL;
		GeeHashMap* _tmp3_ = NULL;
		GeeSet* _tmp4_ = NULL;
		GeeSet* _tmp5_ = NULL;
		GeeSet* _tmp6_ = NULL;
		GeeIterator* _tmp7_ = NULL;
		GeeIterator* _tmp8_ = NULL;
		_tmp3_ = poss;
		_tmp4_ = gee_abstract_map_get_keys ((GeeMap*) _tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = _tmp5_;
		_tmp7_ = gee_iterable_iterator ((GeeIterable*) _tmp6_);
		_tmp8_ = _tmp7_;
		_g_object_unref0 (_tmp6_);
		_coord_it = _tmp8_;
		while (TRUE) {
			GeeIterator* _tmp9_ = NULL;
			gboolean _tmp10_ = FALSE;
			Coord coord = {0};
			GeeIterator* _tmp11_ = NULL;
			gpointer _tmp12_ = NULL;
			Coord* _tmp13_ = NULL;
			Coord _tmp14_ = {0};
			GeeArrayList* choices = NULL;
			GeeHashMap* _tmp15_ = NULL;
			Coord _tmp16_ = {0};
			gpointer _tmp17_ = NULL;
			GeeArrayList* _tmp18_ = NULL;
			gint _tmp19_ = 0;
			gint _tmp20_ = 0;
			gint val = 0;
			GeeArrayList* _tmp21_ = NULL;
			gpointer _tmp22_ = NULL;
			Coord _tmp23_ = {0};
			gint _tmp24_ = 0;
			Coord _tmp25_ = {0};
			gint _tmp26_ = 0;
			gint _tmp27_ = 0;
			GeeArrayList* _tmp28_ = NULL;
			Coord _tmp29_ = {0};
			gint _tmp30_ = 0;
			Cell _tmp31_ = {0};
			_tmp9_ = _coord_it;
			_tmp10_ = gee_iterator_next (_tmp9_);
			if (!_tmp10_) {
				break;
			}
			_tmp11_ = _coord_it;
			_tmp12_ = gee_iterator_get (_tmp11_);
			_tmp13_ = (Coord*) _tmp12_;
			_tmp14_ = *_tmp13_;
			_coord_free0 (_tmp13_);
			coord = _tmp14_;
			_tmp15_ = poss;
			_tmp16_ = coord;
			_tmp17_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp15_, &_tmp16_);
			choices = (GeeArrayList*) _tmp17_;
			_tmp18_ = choices;
			_tmp19_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp18_);
			_tmp20_ = _tmp19_;
			if (_tmp20_ != 1) {
				_g_object_unref0 (choices);
				continue;
			}
			_tmp21_ = choices;
			_tmp22_ = gee_abstract_list_get ((GeeAbstractList*) _tmp21_, 0);
			val = (gint) ((gintptr) _tmp22_);
			_tmp23_ = coord;
			_tmp24_ = _tmp23_.row;
			_tmp25_ = coord;
			_tmp26_ = _tmp25_.col;
			_tmp27_ = val;
			sudoku_solver_insert (self, _tmp24_, _tmp26_, _tmp27_);
			_tmp28_ = changed;
			_tmp29_ = coord;
			_tmp30_ = val;
			cell_init (&_tmp31_, &_tmp29_, _tmp30_);
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp28_, &_tmp31_);
			_g_object_unref0 (choices);
		}
		_g_object_unref0 (_coord_it);
	}
	result = changed;
	_g_object_unref0 (poss);
	return result;
}


GeeArrayList* sudoku_solver_fill_must_fills (SudokuSolver* self, GError** error) {
	GeeArrayList* result = NULL;
	GeeArrayList* changed = NULL;
	GeeArrayList* _tmp0_ = NULL;
	gint blocks_across = 0;
	SudokuBoard* _tmp31_ = NULL;
	gint _tmp32_ = 0;
	gint _tmp33_ = 0;
	SudokuBoard* _tmp34_ = NULL;
	gint _tmp35_ = 0;
	gint _tmp36_ = 0;
	gint blocks_down = 0;
	SudokuBoard* _tmp37_ = NULL;
	gint _tmp38_ = 0;
	gint _tmp39_ = 0;
	SudokuBoard* _tmp40_ = NULL;
	gint _tmp41_ = 0;
	gint _tmp42_ = 0;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gee_array_list_new (TYPE_CELL, (GBoxedCopyFunc) cell_dup, cell_free, NULL, NULL, NULL);
	changed = _tmp0_;
	{
		gint col = 0;
		col = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gint _tmp3_ = 0;
				SudokuBoard* _tmp4_ = NULL;
				gint _tmp5_ = 0;
				gint _tmp6_ = 0;
				GeeArrayList* _tmp7_ = NULL;
				SudokuBoard* _tmp8_ = NULL;
				GeeList* _tmp9_ = NULL;
				gint _tmp10_ = 0;
				gpointer _tmp11_ = NULL;
				GeeList* _tmp12_ = NULL;
				GeeArrayList* _tmp13_ = NULL;
				GeeArrayList* _tmp14_ = NULL;
				GeeArrayList* _tmp15_ = NULL;
				if (!_tmp1_) {
					gint _tmp2_ = 0;
					_tmp2_ = col;
					col = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = col;
				_tmp4_ = self->board;
				_tmp5_ = sudoku_board_get_cols (_tmp4_);
				_tmp6_ = _tmp5_;
				if (!(_tmp3_ < _tmp6_)) {
					break;
				}
				_tmp8_ = self->board;
				_tmp9_ = _tmp8_->coords_for_col;
				_tmp10_ = col;
				_tmp11_ = gee_list_get (_tmp9_, _tmp10_);
				_tmp12_ = (GeeList*) _tmp11_;
				_tmp13_ = sudoku_solver_fill_must_fills_for (self, _tmp12_, &_inner_error_);
				_tmp14_ = _tmp13_;
				_g_object_unref0 (_tmp12_);
				_tmp7_ = _tmp14_;
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					if (_inner_error_->domain == SUDOKU_ERROR) {
						g_propagate_error (error, _inner_error_);
						_g_object_unref0 (changed);
						return NULL;
					} else {
						_g_object_unref0 (changed);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				_tmp15_ = changed;
				gee_array_list_add_all (_tmp15_, (GeeCollection*) _tmp7_);
				_g_object_unref0 (_tmp7_);
			}
		}
	}
	{
		gint row = 0;
		row = 0;
		{
			gboolean _tmp16_ = FALSE;
			_tmp16_ = TRUE;
			while (TRUE) {
				gint _tmp18_ = 0;
				SudokuBoard* _tmp19_ = NULL;
				gint _tmp20_ = 0;
				gint _tmp21_ = 0;
				GeeArrayList* _tmp22_ = NULL;
				SudokuBoard* _tmp23_ = NULL;
				GeeList* _tmp24_ = NULL;
				gint _tmp25_ = 0;
				gpointer _tmp26_ = NULL;
				GeeList* _tmp27_ = NULL;
				GeeArrayList* _tmp28_ = NULL;
				GeeArrayList* _tmp29_ = NULL;
				GeeArrayList* _tmp30_ = NULL;
				if (!_tmp16_) {
					gint _tmp17_ = 0;
					_tmp17_ = row;
					row = _tmp17_ + 1;
				}
				_tmp16_ = FALSE;
				_tmp18_ = row;
				_tmp19_ = self->board;
				_tmp20_ = sudoku_board_get_rows (_tmp19_);
				_tmp21_ = _tmp20_;
				if (!(_tmp18_ < _tmp21_)) {
					break;
				}
				_tmp23_ = self->board;
				_tmp24_ = _tmp23_->coords_for_row;
				_tmp25_ = row;
				_tmp26_ = gee_list_get (_tmp24_, _tmp25_);
				_tmp27_ = (GeeList*) _tmp26_;
				_tmp28_ = sudoku_solver_fill_must_fills_for (self, _tmp27_, &_inner_error_);
				_tmp29_ = _tmp28_;
				_g_object_unref0 (_tmp27_);
				_tmp22_ = _tmp29_;
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					if (_inner_error_->domain == SUDOKU_ERROR) {
						g_propagate_error (error, _inner_error_);
						_g_object_unref0 (changed);
						return NULL;
					} else {
						_g_object_unref0 (changed);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				_tmp30_ = changed;
				gee_array_list_add_all (_tmp30_, (GeeCollection*) _tmp22_);
				_g_object_unref0 (_tmp22_);
			}
		}
	}
	_tmp31_ = self->board;
	_tmp32_ = sudoku_board_get_cols (_tmp31_);
	_tmp33_ = _tmp32_;
	_tmp34_ = self->board;
	_tmp35_ = sudoku_board_get_block_cols (_tmp34_);
	_tmp36_ = _tmp35_;
	blocks_across = _tmp33_ / _tmp36_;
	_tmp37_ = self->board;
	_tmp38_ = sudoku_board_get_rows (_tmp37_);
	_tmp39_ = _tmp38_;
	_tmp40_ = self->board;
	_tmp41_ = sudoku_board_get_block_rows (_tmp40_);
	_tmp42_ = _tmp41_;
	blocks_down = _tmp39_ / _tmp42_;
	{
		gint block_down = 0;
		block_down = 0;
		{
			gboolean _tmp43_ = FALSE;
			_tmp43_ = TRUE;
			while (TRUE) {
				gint _tmp45_ = 0;
				gint _tmp46_ = 0;
				if (!_tmp43_) {
					gint _tmp44_ = 0;
					_tmp44_ = block_down;
					block_down = _tmp44_ + 1;
				}
				_tmp43_ = FALSE;
				_tmp45_ = block_down;
				_tmp46_ = blocks_down;
				if (!(_tmp45_ < _tmp46_)) {
					break;
				}
				{
					gint block_across = 0;
					block_across = 0;
					{
						gboolean _tmp47_ = FALSE;
						_tmp47_ = TRUE;
						while (TRUE) {
							gint _tmp49_ = 0;
							gint _tmp50_ = 0;
							GeeArrayList* _tmp51_ = NULL;
							SudokuBoard* _tmp52_ = NULL;
							GeeMap* _tmp53_ = NULL;
							gint _tmp54_ = 0;
							gint _tmp55_ = 0;
							Coord _tmp56_ = {0};
							gpointer _tmp57_ = NULL;
							GeeList* _tmp58_ = NULL;
							GeeArrayList* _tmp59_ = NULL;
							GeeArrayList* _tmp60_ = NULL;
							GeeArrayList* _tmp61_ = NULL;
							if (!_tmp47_) {
								gint _tmp48_ = 0;
								_tmp48_ = block_across;
								block_across = _tmp48_ + 1;
							}
							_tmp47_ = FALSE;
							_tmp49_ = block_across;
							_tmp50_ = blocks_across;
							if (!(_tmp49_ < _tmp50_)) {
								break;
							}
							_tmp52_ = self->board;
							_tmp53_ = _tmp52_->coords_for_block;
							_tmp54_ = block_across;
							_tmp55_ = block_down;
							coord_init (&_tmp56_, _tmp54_, _tmp55_);
							_tmp57_ = gee_map_get (_tmp53_, &_tmp56_);
							_tmp58_ = (GeeList*) _tmp57_;
							_tmp59_ = sudoku_solver_fill_must_fills_for (self, _tmp58_, &_inner_error_);
							_tmp60_ = _tmp59_;
							_g_object_unref0 (_tmp58_);
							_tmp51_ = _tmp60_;
							if (G_UNLIKELY (_inner_error_ != NULL)) {
								if (_inner_error_->domain == SUDOKU_ERROR) {
									g_propagate_error (error, _inner_error_);
									_g_object_unref0 (changed);
									return NULL;
								} else {
									_g_object_unref0 (changed);
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return NULL;
								}
							}
							_tmp61_ = changed;
							gee_array_list_add_all (_tmp61_, (GeeCollection*) _tmp51_);
							_g_object_unref0 (_tmp51_);
						}
					}
				}
			}
		}
	}
	result = changed;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static GeeArrayList* sudoku_solver_fill_must_fills_for (SudokuSolver* self, GeeList* coords, GError** error) {
	GeeArrayList* result = NULL;
	gboolean skip_set = FALSE;
	gboolean _tmp16_ = FALSE;
	GeeArrayList* changed = NULL;
	GeeArrayList* _tmp18_ = NULL;
	GeeHashMap* needs = NULL;
	GeeHashMap* _tmp19_ = NULL;
	GeeHashMap* _tmp74_ = NULL;
	gint _tmp75_ = 0;
	gint _tmp76_ = 0;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (coords != NULL, NULL);
	skip_set = FALSE;
	{
		GeeList* _coord_list = NULL;
		GeeList* _tmp0_ = NULL;
		GeeList* _tmp1_ = NULL;
		gint _coord_size = 0;
		GeeList* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint _coord_index = 0;
		_tmp0_ = coords;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_coord_list = _tmp1_;
		_tmp2_ = _coord_list;
		_tmp3_ = gee_collection_get_size ((GeeCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_coord_size = _tmp4_;
		_coord_index = -1;
		while (TRUE) {
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			Coord coord = {0};
			GeeList* _tmp8_ = NULL;
			gint _tmp9_ = 0;
			gpointer _tmp10_ = NULL;
			Coord* _tmp11_ = NULL;
			Coord _tmp12_ = {0};
			ParallelDict* _tmp13_ = NULL;
			Coord _tmp14_ = {0};
			gboolean _tmp15_ = FALSE;
			_tmp5_ = _coord_index;
			_coord_index = _tmp5_ + 1;
			_tmp6_ = _coord_index;
			_tmp7_ = _coord_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _coord_list;
			_tmp9_ = _coord_index;
			_tmp10_ = gee_list_get (_tmp8_, _tmp9_);
			_tmp11_ = (Coord*) _tmp10_;
			_tmp12_ = *_tmp11_;
			_coord_free0 (_tmp11_);
			coord = _tmp12_;
			_tmp13_ = self->priv->conflicts;
			_tmp14_ = coord;
			_tmp15_ = parallel_dict_contains (_tmp13_, &_tmp14_);
			if (_tmp15_) {
				skip_set = TRUE;
				break;
			}
		}
		_g_object_unref0 (_coord_list);
	}
	_tmp16_ = skip_set;
	if (_tmp16_) {
		GeeArrayList* _tmp17_ = NULL;
		_tmp17_ = gee_array_list_new (TYPE_CELL, (GBoxedCopyFunc) cell_dup, cell_free, NULL, NULL, NULL);
		result = _tmp17_;
		return result;
	}
	_tmp18_ = gee_array_list_new (TYPE_CELL, (GBoxedCopyFunc) cell_dup, cell_free, (GeeEqualDataFunc) coord_equal, NULL, NULL);
	changed = _tmp18_;
	_tmp19_ = gee_hash_map_new (G_TYPE_INT, NULL, NULL, TYPE_COORD, (GBoxedCopyFunc) coord_dup, coord_free, NULL, NULL, NULL, NULL, NULL, NULL, (GeeEqualDataFunc) coord_equal, NULL, NULL);
	needs = _tmp19_;
	{
		gint i = 0;
		i = 1;
		{
			gboolean _tmp20_ = FALSE;
			_tmp20_ = TRUE;
			while (TRUE) {
				gint _tmp22_ = 0;
				SudokuBoard* _tmp23_ = NULL;
				gint _tmp24_ = 0;
				gint _tmp25_ = 0;
				GeeHashMap* _tmp26_ = NULL;
				gint _tmp27_ = 0;
				if (!_tmp20_) {
					gint _tmp21_ = 0;
					_tmp21_ = i;
					i = _tmp21_ + 1;
				}
				_tmp20_ = FALSE;
				_tmp22_ = i;
				_tmp23_ = self->board;
				_tmp24_ = sudoku_board_get_max_val (_tmp23_);
				_tmp25_ = _tmp24_;
				if (!(_tmp22_ <= _tmp25_)) {
					break;
				}
				_tmp26_ = needs;
				_tmp27_ = i;
				gee_abstract_map_set ((GeeAbstractMap*) _tmp26_, (gpointer) ((gintptr) _tmp27_), NULL);
			}
		}
	}
	{
		GeeList* _coord_list = NULL;
		GeeList* _tmp28_ = NULL;
		GeeList* _tmp29_ = NULL;
		gint _coord_size = 0;
		GeeList* _tmp30_ = NULL;
		gint _tmp31_ = 0;
		gint _tmp32_ = 0;
		gint _coord_index = 0;
		_tmp28_ = coords;
		_tmp29_ = _g_object_ref0 (_tmp28_);
		_coord_list = _tmp29_;
		_tmp30_ = _coord_list;
		_tmp31_ = gee_collection_get_size ((GeeCollection*) _tmp30_);
		_tmp32_ = _tmp31_;
		_coord_size = _tmp32_;
		_coord_index = -1;
		while (TRUE) {
			gint _tmp33_ = 0;
			gint _tmp34_ = 0;
			gint _tmp35_ = 0;
			Coord coord = {0};
			GeeList* _tmp36_ = NULL;
			gint _tmp37_ = 0;
			gpointer _tmp38_ = NULL;
			Coord* _tmp39_ = NULL;
			Coord _tmp40_ = {0};
			gint val = 0;
			SudokuBoard* _tmp41_ = NULL;
			Coord _tmp42_ = {0};
			gint _tmp43_ = 0;
			Coord _tmp44_ = {0};
			gint _tmp45_ = 0;
			gint _tmp46_ = 0;
			gint _tmp47_ = 0;
			_tmp33_ = _coord_index;
			_coord_index = _tmp33_ + 1;
			_tmp34_ = _coord_index;
			_tmp35_ = _coord_size;
			if (!(_tmp34_ < _tmp35_)) {
				break;
			}
			_tmp36_ = _coord_list;
			_tmp37_ = _coord_index;
			_tmp38_ = gee_list_get (_tmp36_, _tmp37_);
			_tmp39_ = (Coord*) _tmp38_;
			_tmp40_ = *_tmp39_;
			_coord_free0 (_tmp39_);
			coord = _tmp40_;
			_tmp41_ = self->board;
			_tmp42_ = coord;
			_tmp43_ = _tmp42_.row;
			_tmp44_ = coord;
			_tmp45_ = _tmp44_.col;
			_tmp46_ = sudoku_board_get (_tmp41_, _tmp43_, _tmp45_);
			val = _tmp46_;
			_tmp47_ = val;
			if (_tmp47_ != 0) {
				GeeHashMap* _tmp48_ = NULL;
				gint _tmp49_ = 0;
				gboolean _tmp50_ = FALSE;
				_tmp48_ = needs;
				_tmp49_ = val;
				_tmp50_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp48_, (gpointer) ((gintptr) _tmp49_));
				if (_tmp50_) {
					GeeHashMap* _tmp51_ = NULL;
					gint _tmp52_ = 0;
					_tmp51_ = needs;
					_tmp52_ = val;
					gee_abstract_map_unset ((GeeAbstractMap*) _tmp51_, (gpointer) ((gintptr) _tmp52_), NULL);
				}
			} else {
				gint* possibilities = NULL;
				SudokuBoard* _tmp53_ = NULL;
				Coord _tmp54_ = {0};
				gint _tmp55_ = 0;
				Coord _tmp56_ = {0};
				gint _tmp57_ = 0;
				gint _tmp58_ = 0;
				gint* _tmp59_ = NULL;
				gint possibilities_length1 = 0;
				gint _possibilities_size_ = 0;
				gint* _tmp60_ = NULL;
				gint _tmp60__length1 = 0;
				_tmp53_ = self->board;
				_tmp54_ = coord;
				_tmp55_ = _tmp54_.row;
				_tmp56_ = coord;
				_tmp57_ = _tmp56_.col;
				_tmp59_ = sudoku_board_get_possibilities (_tmp53_, _tmp55_, _tmp57_, &_tmp58_);
				possibilities = _tmp59_;
				possibilities_length1 = _tmp58_;
				_possibilities_size_ = possibilities_length1;
				_tmp60_ = possibilities;
				_tmp60__length1 = possibilities_length1;
				{
					gint* possibility_collection = NULL;
					gint possibility_collection_length1 = 0;
					gint _possibility_collection_size_ = 0;
					gint possibility_it = 0;
					possibility_collection = _tmp60_;
					possibility_collection_length1 = _tmp60__length1;
					for (possibility_it = 0; possibility_it < _tmp60__length1; possibility_it = possibility_it + 1) {
						gint possibility = 0;
						possibility = possibility_collection[possibility_it];
						{
							GeeHashMap* _tmp61_ = NULL;
							gint _tmp62_ = 0;
							gboolean _tmp63_ = FALSE;
							_tmp61_ = needs;
							_tmp62_ = possibility;
							_tmp63_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp61_, (gpointer) ((gintptr) _tmp62_));
							if (_tmp63_) {
								GeeHashMap* _tmp64_ = NULL;
								gint _tmp65_ = 0;
								gpointer _tmp66_ = NULL;
								Coord* _tmp67_ = NULL;
								gboolean _tmp68_ = FALSE;
								_tmp64_ = needs;
								_tmp65_ = possibility;
								_tmp66_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp64_, (gpointer) ((gintptr) _tmp65_));
								_tmp67_ = (Coord*) _tmp66_;
								_tmp68_ = _tmp67_ == NULL;
								_coord_free0 (_tmp67_);
								if (_tmp68_) {
									GeeHashMap* _tmp69_ = NULL;
									gint _tmp70_ = 0;
									Coord _tmp71_ = {0};
									_tmp69_ = needs;
									_tmp70_ = possibility;
									_tmp71_ = coord;
									gee_abstract_map_set ((GeeAbstractMap*) _tmp69_, (gpointer) ((gintptr) _tmp70_), &_tmp71_);
								} else {
									GeeHashMap* _tmp72_ = NULL;
									gint _tmp73_ = 0;
									_tmp72_ = needs;
									_tmp73_ = possibility;
									gee_abstract_map_unset ((GeeAbstractMap*) _tmp72_, (gpointer) ((gintptr) _tmp73_), NULL);
								}
							}
						}
					}
				}
				possibilities = (g_free (possibilities), NULL);
			}
		}
		_g_object_unref0 (_coord_list);
	}
	_tmp74_ = needs;
	_tmp75_ = gee_abstract_map_get_size ((GeeMap*) _tmp74_);
	_tmp76_ = _tmp75_;
	if (_tmp76_ != 0) {
		{
			GeeIterator* _n_it = NULL;
			GeeHashMap* _tmp77_ = NULL;
			GeeSet* _tmp78_ = NULL;
			GeeSet* _tmp79_ = NULL;
			GeeSet* _tmp80_ = NULL;
			GeeIterator* _tmp81_ = NULL;
			GeeIterator* _tmp82_ = NULL;
			_tmp77_ = needs;
			_tmp78_ = gee_abstract_map_get_keys ((GeeMap*) _tmp77_);
			_tmp79_ = _tmp78_;
			_tmp80_ = _tmp79_;
			_tmp81_ = gee_iterable_iterator ((GeeIterable*) _tmp80_);
			_tmp82_ = _tmp81_;
			_g_object_unref0 (_tmp80_);
			_n_it = _tmp82_;
			while (TRUE) {
				GeeIterator* _tmp83_ = NULL;
				gboolean _tmp84_ = FALSE;
				gint n = 0;
				GeeIterator* _tmp85_ = NULL;
				gpointer _tmp86_ = NULL;
				GeeHashMap* _tmp87_ = NULL;
				gint _tmp88_ = 0;
				gpointer _tmp89_ = NULL;
				Coord* _tmp90_ = NULL;
				gboolean _tmp91_ = FALSE;
				_tmp83_ = _n_it;
				_tmp84_ = gee_iterator_next (_tmp83_);
				if (!_tmp84_) {
					break;
				}
				_tmp85_ = _n_it;
				_tmp86_ = gee_iterator_get (_tmp85_);
				n = (gint) ((gintptr) _tmp86_);
				_tmp87_ = needs;
				_tmp88_ = n;
				_tmp89_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp87_, (gpointer) ((gintptr) _tmp88_));
				_tmp90_ = (Coord*) _tmp89_;
				_tmp91_ = _tmp90_ == NULL;
				_coord_free0 (_tmp90_);
				if (_tmp91_) {
					gint _tmp92_ = 0;
					GError* _tmp93_ = NULL;
					_tmp92_ = n;
					_tmp93_ = g_error_new (SUDOKU_ERROR, SUDOKU_ERROR_UNSOLVABLE_PUZZLE, "Missing a %d in\n", _tmp92_);
					_inner_error_ = _tmp93_;
					if (_inner_error_->domain == SUDOKU_ERROR) {
						g_propagate_error (error, _inner_error_);
						_g_object_unref0 (_n_it);
						_g_object_unref0 (needs);
						_g_object_unref0 (changed);
						return NULL;
					} else {
						_g_object_unref0 (_n_it);
						_g_object_unref0 (needs);
						_g_object_unref0 (changed);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				} else {
					gint val = 0;
					SudokuBoard* _tmp94_ = NULL;
					GeeHashMap* _tmp95_ = NULL;
					gint _tmp96_ = 0;
					gpointer _tmp97_ = NULL;
					Coord* _tmp98_ = NULL;
					gint _tmp99_ = 0;
					GeeHashMap* _tmp100_ = NULL;
					gint _tmp101_ = 0;
					gpointer _tmp102_ = NULL;
					Coord* _tmp103_ = NULL;
					gint _tmp104_ = 0;
					gint _tmp105_ = 0;
					gint _tmp106_ = 0;
					gboolean _tmp107_ = FALSE;
					gint _tmp108_ = 0;
					_tmp94_ = self->board;
					_tmp95_ = needs;
					_tmp96_ = n;
					_tmp97_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp95_, (gpointer) ((gintptr) _tmp96_));
					_tmp98_ = (Coord*) _tmp97_;
					_tmp99_ = (*_tmp98_).row;
					_tmp100_ = needs;
					_tmp101_ = n;
					_tmp102_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp100_, (gpointer) ((gintptr) _tmp101_));
					_tmp103_ = (Coord*) _tmp102_;
					_tmp104_ = (*_tmp103_).col;
					_tmp105_ = sudoku_board_get (_tmp94_, _tmp99_, _tmp104_);
					_tmp106_ = _tmp105_;
					_coord_free0 (_tmp103_);
					_coord_free0 (_tmp98_);
					val = _tmp106_;
					_tmp108_ = val;
					if (_tmp108_ == 0) {
						_tmp107_ = TRUE;
					} else {
						gint _tmp109_ = 0;
						gint _tmp110_ = 0;
						_tmp109_ = val;
						_tmp110_ = n;
						_tmp107_ = _tmp109_ == _tmp110_;
					}
					if (_tmp107_) {
						GeeHashMap* _tmp111_ = NULL;
						gint _tmp112_ = 0;
						gpointer _tmp113_ = NULL;
						Coord* _tmp114_ = NULL;
						gint _tmp115_ = 0;
						GeeHashMap* _tmp116_ = NULL;
						gint _tmp117_ = 0;
						gpointer _tmp118_ = NULL;
						Coord* _tmp119_ = NULL;
						gint _tmp120_ = 0;
						gint _tmp121_ = 0;
						GeeArrayList* _tmp122_ = NULL;
						GeeHashMap* _tmp123_ = NULL;
						gint _tmp124_ = 0;
						gpointer _tmp125_ = NULL;
						Coord* _tmp126_ = NULL;
						gint _tmp127_ = 0;
						Cell _tmp128_ = {0};
						Coord _tmp129_ = {0};
						_tmp111_ = needs;
						_tmp112_ = n;
						_tmp113_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp111_, (gpointer) ((gintptr) _tmp112_));
						_tmp114_ = (Coord*) _tmp113_;
						_tmp115_ = (*_tmp114_).row;
						_tmp116_ = needs;
						_tmp117_ = n;
						_tmp118_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp116_, (gpointer) ((gintptr) _tmp117_));
						_tmp119_ = (Coord*) _tmp118_;
						_tmp120_ = (*_tmp119_).col;
						_tmp121_ = n;
						sudoku_solver_insert (self, _tmp115_, _tmp120_, _tmp121_);
						_coord_free0 (_tmp119_);
						_coord_free0 (_tmp114_);
						_tmp122_ = changed;
						_tmp123_ = needs;
						_tmp124_ = n;
						_tmp125_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp123_, (gpointer) ((gintptr) _tmp124_));
						_tmp126_ = (Coord*) _tmp125_;
						_tmp127_ = n;
						_tmp129_ = *_tmp126_;
						cell_init (&_tmp128_, &_tmp129_, _tmp127_);
						gee_abstract_collection_add ((GeeAbstractCollection*) _tmp122_, &_tmp128_);
						_coord_free0 (_tmp126_);
					} else {
						GeeHashMap* _tmp130_ = NULL;
						gint _tmp131_ = 0;
						gpointer _tmp132_ = NULL;
						Coord* _tmp133_ = NULL;
						gint _tmp134_ = 0;
						GeeHashMap* _tmp135_ = NULL;
						gint _tmp136_ = 0;
						gpointer _tmp137_ = NULL;
						Coord* _tmp138_ = NULL;
						gint _tmp139_ = 0;
						gint _tmp140_ = 0;
						gint _tmp141_ = 0;
						GError* _tmp142_ = NULL;
						GError* _tmp143_ = NULL;
						_tmp130_ = needs;
						_tmp131_ = n;
						_tmp132_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp130_, (gpointer) ((gintptr) _tmp131_));
						_tmp133_ = (Coord*) _tmp132_;
						_tmp134_ = (*_tmp133_).col;
						_tmp135_ = needs;
						_tmp136_ = n;
						_tmp137_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp135_, (gpointer) ((gintptr) _tmp136_));
						_tmp138_ = (Coord*) _tmp137_;
						_tmp139_ = (*_tmp138_).row;
						_tmp140_ = val;
						_tmp141_ = n;
						_tmp142_ = g_error_new (SUDOKU_ERROR, SUDOKU_ERROR_UNSOLVABLE_PUZZLE, "%d, %d must be two values at once! %d and %d", _tmp134_, _tmp139_, _tmp140_, _tmp141_);
						_tmp143_ = _tmp142_;
						_coord_free0 (_tmp138_);
						_coord_free0 (_tmp133_);
						_inner_error_ = _tmp143_;
						if (_inner_error_->domain == SUDOKU_ERROR) {
							g_propagate_error (error, _inner_error_);
							_g_object_unref0 (_n_it);
							_g_object_unref0 (needs);
							_g_object_unref0 (changed);
							return NULL;
						} else {
							_g_object_unref0 (_n_it);
							_g_object_unref0 (needs);
							_g_object_unref0 (changed);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
				}
			}
			_g_object_unref0 (_n_it);
		}
	}
	result = changed;
	_g_object_unref0 (needs);
	return result;
}


static gpointer _guess_ref0 (gpointer self) {
	return self ? guess_ref (self) : NULL;
}


static gboolean sudoku_solver_real_guess_least_open_square (SudokuSolver* self, GError** error) {
	gboolean result = FALSE;
	GeeHashMap* poss = NULL;
	SudokuBoard* _tmp0_ = NULL;
	GeeHashMap* _tmp1_ = NULL;
	GeeHashMap* _tmp2_ = NULL;
	GeeSet* _tmp3_ = NULL;
	GeeSet* _tmp4_ = NULL;
	GeeSet* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	gboolean _tmp8_ = FALSE;
	GeeMapIterator* iter = NULL;
	GeeHashMap* _tmp9_ = NULL;
	GeeMapIterator* _tmp10_ = NULL;
	GeeMapIterator* _tmp11_ = NULL;
	Coord least_coord = {0};
	GeeMapIterator* _tmp12_ = NULL;
	gpointer _tmp13_ = NULL;
	Coord* _tmp14_ = NULL;
	Coord _tmp15_ = {0};
	GeeArrayList* least_coord_possibilties = NULL;
	GeeMapIterator* _tmp16_ = NULL;
	gpointer _tmp17_ = NULL;
	GeeArrayList* possible_values = NULL;
	GeeArrayList* _tmp75_ = NULL;
	Guess** guesses_for_coord = NULL;
	GuessList* _tmp76_ = NULL;
	Coord _tmp77_ = {0};
	gint _tmp78_ = 0;
	Coord _tmp79_ = {0};
	gint _tmp80_ = 0;
	gint _tmp81_ = 0;
	Guess** _tmp82_ = NULL;
	gint guesses_for_coord_length1 = 0;
	gint _guesses_for_coord_size_ = 0;
	GeeArrayList* _tmp103_ = NULL;
	gint _tmp104_ = 0;
	gint _tmp105_ = 0;
	gint guess = 0;
	GeeArrayList* _tmp120_ = NULL;
	GeeArrayList* _tmp121_ = NULL;
	gint _tmp122_ = 0;
	gint _tmp123_ = 0;
	gint32 _tmp124_ = 0;
	gpointer _tmp125_ = NULL;
	Guess* guess_obj = NULL;
	Coord _tmp126_ = {0};
	gint _tmp127_ = 0;
	Coord _tmp128_ = {0};
	gint _tmp129_ = 0;
	gint _tmp130_ = 0;
	Guess* _tmp131_ = NULL;
	BreadcrumbTrail* _tmp132_ = NULL;
	gint _tmp133_ = 0;
	gint _tmp134_ = 0;
	Coord _tmp143_ = {0};
	gint _tmp144_ = 0;
	Coord _tmp145_ = {0};
	gint _tmp146_ = 0;
	gint _tmp147_ = 0;
	Guess* _tmp148_ = NULL;
	Guess* _tmp149_ = NULL;
	GuessList* _tmp150_ = NULL;
	Guess* _tmp151_ = NULL;
	GeeArrayList* _tmp152_ = NULL;
	Guess* _tmp153_ = NULL;
	GeeArrayList* _tmp154_ = NULL;
	BreadcrumbTrail* _tmp155_ = NULL;
	Guess* _tmp156_ = NULL;
	gboolean contains_empty = FALSE;
	GeeCollection* possibilties_left = NULL;
	SudokuBoard* _tmp157_ = NULL;
	GeeHashMap* _tmp158_ = NULL;
	GeeHashMap* _tmp159_ = NULL;
	GeeCollection* _tmp160_ = NULL;
	GeeCollection* _tmp161_ = NULL;
	GeeCollection* _tmp162_ = NULL;
	gboolean _tmp172_ = FALSE;
	GError * _inner_error_ = NULL;
	_tmp0_ = self->board;
	_tmp1_ = sudoku_board_calculate_open_squares (_tmp0_);
	poss = _tmp1_;
	_tmp2_ = poss;
	_tmp3_ = gee_abstract_map_get_keys ((GeeMap*) _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_;
	_tmp6_ = gee_collection_get_size ((GeeCollection*) _tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _tmp7_ == 0;
	_g_object_unref0 (_tmp5_);
	if (_tmp8_) {
		result = TRUE;
		_g_object_unref0 (poss);
		return result;
	}
	_tmp9_ = poss;
	_tmp10_ = gee_abstract_map_map_iterator ((GeeAbstractMap*) _tmp9_);
	iter = _tmp10_;
	_tmp11_ = iter;
	gee_map_iterator_next (_tmp11_);
	_tmp12_ = iter;
	_tmp13_ = gee_map_iterator_get_key (_tmp12_);
	_tmp14_ = (Coord*) _tmp13_;
	_tmp15_ = *_tmp14_;
	_coord_free0 (_tmp14_);
	least_coord = _tmp15_;
	_tmp16_ = iter;
	_tmp17_ = gee_map_iterator_get_value (_tmp16_);
	least_coord_possibilties = (GeeArrayList*) _tmp17_;
	{
		GeeIterator* _coord_it = NULL;
		GeeHashMap* _tmp18_ = NULL;
		GeeSet* _tmp19_ = NULL;
		GeeSet* _tmp20_ = NULL;
		GeeSet* _tmp21_ = NULL;
		GeeIterator* _tmp22_ = NULL;
		GeeIterator* _tmp23_ = NULL;
		_tmp18_ = poss;
		_tmp19_ = gee_abstract_map_get_keys ((GeeMap*) _tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = _tmp20_;
		_tmp22_ = gee_iterable_iterator ((GeeIterable*) _tmp21_);
		_tmp23_ = _tmp22_;
		_g_object_unref0 (_tmp21_);
		_coord_it = _tmp23_;
		while (TRUE) {
			GeeIterator* _tmp24_ = NULL;
			gboolean _tmp25_ = FALSE;
			Coord coord = {0};
			GeeIterator* _tmp26_ = NULL;
			gpointer _tmp27_ = NULL;
			Coord* _tmp28_ = NULL;
			Coord _tmp29_ = {0};
			GeeHashMap* _tmp30_ = NULL;
			Coord _tmp31_ = {0};
			gpointer _tmp32_ = NULL;
			GeeArrayList* _tmp33_ = NULL;
			gint _tmp34_ = 0;
			gint _tmp35_ = 0;
			GeeArrayList* _tmp36_ = NULL;
			gint _tmp37_ = 0;
			gint _tmp38_ = 0;
			gboolean _tmp39_ = FALSE;
			_tmp24_ = _coord_it;
			_tmp25_ = gee_iterator_next (_tmp24_);
			if (!_tmp25_) {
				break;
			}
			_tmp26_ = _coord_it;
			_tmp27_ = gee_iterator_get (_tmp26_);
			_tmp28_ = (Coord*) _tmp27_;
			_tmp29_ = *_tmp28_;
			_coord_free0 (_tmp28_);
			coord = _tmp29_;
			_tmp30_ = poss;
			_tmp31_ = coord;
			_tmp32_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp30_, &_tmp31_);
			_tmp33_ = (GeeArrayList*) _tmp32_;
			_tmp34_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp33_);
			_tmp35_ = _tmp34_;
			_tmp36_ = least_coord_possibilties;
			_tmp37_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp36_);
			_tmp38_ = _tmp37_;
			_tmp39_ = _tmp35_ > _tmp38_;
			_g_object_unref0 (_tmp33_);
			if (_tmp39_) {
				continue;
			} else {
				GeeHashMap* _tmp40_ = NULL;
				Coord _tmp41_ = {0};
				gpointer _tmp42_ = NULL;
				GeeArrayList* _tmp43_ = NULL;
				gint _tmp44_ = 0;
				gint _tmp45_ = 0;
				GeeArrayList* _tmp46_ = NULL;
				gint _tmp47_ = 0;
				gint _tmp48_ = 0;
				gboolean _tmp49_ = FALSE;
				_tmp40_ = poss;
				_tmp41_ = coord;
				_tmp42_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp40_, &_tmp41_);
				_tmp43_ = (GeeArrayList*) _tmp42_;
				_tmp44_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp43_);
				_tmp45_ = _tmp44_;
				_tmp46_ = least_coord_possibilties;
				_tmp47_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp46_);
				_tmp48_ = _tmp47_;
				_tmp49_ = _tmp45_ < _tmp48_;
				_g_object_unref0 (_tmp43_);
				if (_tmp49_) {
					Coord _tmp50_ = {0};
					GeeHashMap* _tmp51_ = NULL;
					Coord _tmp52_ = {0};
					gpointer _tmp53_ = NULL;
					_tmp50_ = coord;
					least_coord = _tmp50_;
					_tmp51_ = poss;
					_tmp52_ = coord;
					_tmp53_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp51_, &_tmp52_);
					_g_object_unref0 (least_coord_possibilties);
					least_coord_possibilties = (GeeArrayList*) _tmp53_;
				} else {
					Coord _tmp54_ = {0};
					gint _tmp55_ = 0;
					Coord _tmp56_ = {0};
					gint _tmp57_ = 0;
					_tmp54_ = coord;
					_tmp55_ = _tmp54_.col;
					_tmp56_ = least_coord;
					_tmp57_ = _tmp56_.col;
					if (_tmp55_ < _tmp57_) {
						Coord _tmp58_ = {0};
						GeeHashMap* _tmp59_ = NULL;
						Coord _tmp60_ = {0};
						gpointer _tmp61_ = NULL;
						_tmp58_ = coord;
						least_coord = _tmp58_;
						_tmp59_ = poss;
						_tmp60_ = coord;
						_tmp61_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp59_, &_tmp60_);
						_g_object_unref0 (least_coord_possibilties);
						least_coord_possibilties = (GeeArrayList*) _tmp61_;
					} else {
						gboolean _tmp62_ = FALSE;
						Coord _tmp63_ = {0};
						gint _tmp64_ = 0;
						Coord _tmp65_ = {0};
						gint _tmp66_ = 0;
						_tmp63_ = coord;
						_tmp64_ = _tmp63_.col;
						_tmp65_ = least_coord;
						_tmp66_ = _tmp65_.col;
						if (_tmp64_ == _tmp66_) {
							Coord _tmp67_ = {0};
							gint _tmp68_ = 0;
							Coord _tmp69_ = {0};
							gint _tmp70_ = 0;
							_tmp67_ = coord;
							_tmp68_ = _tmp67_.row;
							_tmp69_ = least_coord;
							_tmp70_ = _tmp69_.row;
							_tmp62_ = _tmp68_ < _tmp70_;
						} else {
							_tmp62_ = FALSE;
						}
						if (_tmp62_) {
							Coord _tmp71_ = {0};
							GeeHashMap* _tmp72_ = NULL;
							Coord _tmp73_ = {0};
							gpointer _tmp74_ = NULL;
							_tmp71_ = coord;
							least_coord = _tmp71_;
							_tmp72_ = poss;
							_tmp73_ = coord;
							_tmp74_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp72_, &_tmp73_);
							_g_object_unref0 (least_coord_possibilties);
							least_coord_possibilties = (GeeArrayList*) _tmp74_;
						}
					}
				}
			}
		}
		_g_object_unref0 (_coord_it);
	}
	_tmp75_ = gee_array_list_new (G_TYPE_INT, NULL, NULL, NULL, NULL, NULL);
	possible_values = _tmp75_;
	_tmp76_ = self->guesses;
	_tmp77_ = least_coord;
	_tmp78_ = _tmp77_.row;
	_tmp79_ = least_coord;
	_tmp80_ = _tmp79_.col;
	_tmp82_ = guess_list_guesses_for (_tmp76_, _tmp78_, _tmp80_, &_tmp81_);
	guesses_for_coord = _tmp82_;
	guesses_for_coord_length1 = _tmp81_;
	_guesses_for_coord_size_ = guesses_for_coord_length1;
	{
		GeeArrayList* _possibility_list = NULL;
		GeeArrayList* _tmp83_ = NULL;
		GeeArrayList* _tmp84_ = NULL;
		gint _possibility_size = 0;
		GeeArrayList* _tmp85_ = NULL;
		gint _tmp86_ = 0;
		gint _tmp87_ = 0;
		gint _possibility_index = 0;
		_tmp83_ = least_coord_possibilties;
		_tmp84_ = _g_object_ref0 (_tmp83_);
		_possibility_list = _tmp84_;
		_tmp85_ = _possibility_list;
		_tmp86_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp85_);
		_tmp87_ = _tmp86_;
		_possibility_size = _tmp87_;
		_possibility_index = -1;
		while (TRUE) {
			gint _tmp88_ = 0;
			gint _tmp89_ = 0;
			gint _tmp90_ = 0;
			gint possibility = 0;
			GeeArrayList* _tmp91_ = NULL;
			gint _tmp92_ = 0;
			gpointer _tmp93_ = NULL;
			gboolean found = FALSE;
			Guess** _tmp94_ = NULL;
			gint _tmp94__length1 = 0;
			gboolean _tmp100_ = FALSE;
			_tmp88_ = _possibility_index;
			_possibility_index = _tmp88_ + 1;
			_tmp89_ = _possibility_index;
			_tmp90_ = _possibility_size;
			if (!(_tmp89_ < _tmp90_)) {
				break;
			}
			_tmp91_ = _possibility_list;
			_tmp92_ = _possibility_index;
			_tmp93_ = gee_abstract_list_get ((GeeAbstractList*) _tmp91_, _tmp92_);
			possibility = (gint) ((gintptr) _tmp93_);
			found = FALSE;
			_tmp94_ = guesses_for_coord;
			_tmp94__length1 = guesses_for_coord_length1;
			{
				Guess** guess_collection = NULL;
				gint guess_collection_length1 = 0;
				gint _guess_collection_size_ = 0;
				gint guess_it = 0;
				guess_collection = _tmp94_;
				guess_collection_length1 = _tmp94__length1;
				for (guess_it = 0; guess_it < _tmp94__length1; guess_it = guess_it + 1) {
					Guess* _tmp95_ = NULL;
					Guess* guess = NULL;
					_tmp95_ = _guess_ref0 (guess_collection[guess_it]);
					guess = _tmp95_;
					{
						Guess* _tmp96_ = NULL;
						gint _tmp97_ = 0;
						gint _tmp98_ = 0;
						gint _tmp99_ = 0;
						_tmp96_ = guess;
						_tmp97_ = guess_get_val (_tmp96_);
						_tmp98_ = _tmp97_;
						_tmp99_ = possibility;
						if (_tmp98_ == _tmp99_) {
							found = TRUE;
							_guess_unref0 (guess);
							break;
						}
						_guess_unref0 (guess);
					}
				}
			}
			_tmp100_ = found;
			if (!_tmp100_) {
				GeeArrayList* _tmp101_ = NULL;
				gint _tmp102_ = 0;
				_tmp101_ = possible_values;
				_tmp102_ = possibility;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp101_, (gpointer) ((gintptr) _tmp102_));
			}
		}
		_g_object_unref0 (_possibility_list);
	}
	_tmp103_ = possible_values;
	_tmp104_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp103_);
	_tmp105_ = _tmp104_;
	if (_tmp105_ == 0) {
		BreadcrumbTrail* _tmp106_ = NULL;
		gint _tmp107_ = 0;
		gint _tmp108_ = 0;
		_tmp106_ = self->breadcrumbs;
		_tmp107_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp106_);
		_tmp108_ = _tmp107_;
		if (_tmp108_ != 0) {
			gint _tmp109_ = 0;
			BreadcrumbTrail* _tmp110_ = NULL;
			BreadcrumbTrail* _tmp111_ = NULL;
			gint _tmp112_ = 0;
			gint _tmp113_ = 0;
			gpointer _tmp114_ = NULL;
			Guess* _tmp115_ = NULL;
			gint _tmp116_ = 0;
			gboolean _tmp117_ = FALSE;
			gboolean _tmp118_ = FALSE;
			_tmp109_ = self->backtraces;
			self->backtraces = _tmp109_ + 1;
			_tmp110_ = self->breadcrumbs;
			_tmp111_ = self->breadcrumbs;
			_tmp112_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp111_);
			_tmp113_ = _tmp112_;
			_tmp114_ = gee_abstract_list_get ((GeeAbstractList*) _tmp110_, _tmp113_ - 1);
			_tmp115_ = (Guess*) _tmp114_;
			sudoku_solver_unwrap_guess (self, _tmp115_);
			_guess_unref0 (_tmp115_);
			_tmp116_ = self->priv->debug_indent;
			self->priv->debug_indent = _tmp116_ + 1;
			_tmp118_ = sudoku_solver_guess_least_open_square (self, &_inner_error_);
			_tmp117_ = _tmp118_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == SUDOKU_ERROR) {
					g_propagate_error (error, _inner_error_);
					guesses_for_coord = (_vala_array_free (guesses_for_coord, guesses_for_coord_length1, (GDestroyNotify) guess_unref), NULL);
					_g_object_unref0 (possible_values);
					_g_object_unref0 (least_coord_possibilties);
					_g_object_unref0 (iter);
					_g_object_unref0 (poss);
					return FALSE;
				} else {
					guesses_for_coord = (_vala_array_free (guesses_for_coord, guesses_for_coord_length1, (GDestroyNotify) guess_unref), NULL);
					_g_object_unref0 (possible_values);
					_g_object_unref0 (least_coord_possibilties);
					_g_object_unref0 (iter);
					_g_object_unref0 (poss);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return FALSE;
				}
			}
			result = _tmp117_;
			guesses_for_coord = (_vala_array_free (guesses_for_coord, guesses_for_coord_length1, (GDestroyNotify) guess_unref), NULL);
			_g_object_unref0 (possible_values);
			_g_object_unref0 (least_coord_possibilties);
			_g_object_unref0 (iter);
			_g_object_unref0 (poss);
			return result;
		} else {
			GError* _tmp119_ = NULL;
			_tmp119_ = g_error_new_literal (SUDOKU_ERROR, SUDOKU_ERROR_UNSOLVABLE_PUZZLE, "Unsolvable");
			_inner_error_ = _tmp119_;
			if (_inner_error_->domain == SUDOKU_ERROR) {
				g_propagate_error (error, _inner_error_);
				guesses_for_coord = (_vala_array_free (guesses_for_coord, guesses_for_coord_length1, (GDestroyNotify) guess_unref), NULL);
				_g_object_unref0 (possible_values);
				_g_object_unref0 (least_coord_possibilties);
				_g_object_unref0 (iter);
				_g_object_unref0 (poss);
				return FALSE;
			} else {
				guesses_for_coord = (_vala_array_free (guesses_for_coord, guesses_for_coord_length1, (GDestroyNotify) guess_unref), NULL);
				_g_object_unref0 (possible_values);
				_g_object_unref0 (least_coord_possibilties);
				_g_object_unref0 (iter);
				_g_object_unref0 (poss);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	_tmp120_ = possible_values;
	_tmp121_ = possible_values;
	_tmp122_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp121_);
	_tmp123_ = _tmp122_;
	_tmp124_ = g_random_int_range ((gint32) 0, (gint32) _tmp123_);
	_tmp125_ = gee_abstract_list_get ((GeeAbstractList*) _tmp120_, (gint) _tmp124_);
	guess = (gint) ((gintptr) _tmp125_);
	_tmp126_ = least_coord;
	_tmp127_ = _tmp126_.row;
	_tmp128_ = least_coord;
	_tmp129_ = _tmp128_.col;
	_tmp130_ = guess;
	_tmp131_ = guess_new (_tmp127_, _tmp129_, _tmp130_);
	guess_obj = _tmp131_;
	_tmp132_ = self->breadcrumbs;
	_tmp133_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp132_);
	_tmp134_ = _tmp133_;
	if (_tmp134_ != 0) {
		BreadcrumbTrail* _tmp135_ = NULL;
		BreadcrumbTrail* _tmp136_ = NULL;
		gint _tmp137_ = 0;
		gint _tmp138_ = 0;
		gpointer _tmp139_ = NULL;
		Guess* _tmp140_ = NULL;
		GeeArrayList* _tmp141_ = NULL;
		Guess* _tmp142_ = NULL;
		_tmp135_ = self->breadcrumbs;
		_tmp136_ = self->breadcrumbs;
		_tmp137_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp136_);
		_tmp138_ = _tmp137_;
		_tmp139_ = gee_abstract_list_get ((GeeAbstractList*) _tmp135_, _tmp138_ - 1);
		_tmp140_ = (Guess*) _tmp139_;
		_tmp141_ = _tmp140_->children;
		_tmp142_ = guess_obj;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp141_, _tmp142_);
		_guess_unref0 (_tmp140_);
	}
	_guess_unref0 (self->priv->current_guess);
	self->priv->current_guess = NULL;
	_tmp143_ = least_coord;
	_tmp144_ = _tmp143_.row;
	_tmp145_ = least_coord;
	_tmp146_ = _tmp145_.col;
	_tmp147_ = guess;
	sudoku_solver_insert (self, _tmp144_, _tmp146_, _tmp147_);
	_tmp148_ = guess_obj;
	_tmp149_ = _guess_ref0 (_tmp148_);
	_guess_unref0 (self->priv->current_guess);
	self->priv->current_guess = _tmp149_;
	_tmp150_ = self->guesses;
	_tmp151_ = guess_obj;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp150_, _tmp151_);
	_tmp152_ = self->priv->trail;
	_tmp153_ = guess_obj;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp152_, _tmp153_);
	_tmp154_ = self->priv->trailDetails;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp154_, "+");
	_tmp155_ = self->breadcrumbs;
	_tmp156_ = guess_obj;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp155_, _tmp156_);
	contains_empty = FALSE;
	_tmp157_ = self->board;
	_tmp158_ = sudoku_board_calculate_open_squares (_tmp157_);
	_tmp159_ = _tmp158_;
	_tmp160_ = gee_abstract_map_get_values ((GeeMap*) _tmp159_);
	_tmp161_ = _tmp160_;
	_tmp162_ = _tmp161_;
	_g_object_unref0 (_tmp159_);
	possibilties_left = _tmp162_;
	{
		GeeIterator* _i_it = NULL;
		GeeCollection* _tmp163_ = NULL;
		GeeIterator* _tmp164_ = NULL;
		_tmp163_ = possibilties_left;
		_tmp164_ = gee_iterable_iterator ((GeeIterable*) _tmp163_);
		_i_it = _tmp164_;
		while (TRUE) {
			GeeIterator* _tmp165_ = NULL;
			gboolean _tmp166_ = FALSE;
			GeeArrayList* i = NULL;
			GeeIterator* _tmp167_ = NULL;
			gpointer _tmp168_ = NULL;
			GeeArrayList* _tmp169_ = NULL;
			gint _tmp170_ = 0;
			gint _tmp171_ = 0;
			_tmp165_ = _i_it;
			_tmp166_ = gee_iterator_next (_tmp165_);
			if (!_tmp166_) {
				break;
			}
			_tmp167_ = _i_it;
			_tmp168_ = gee_iterator_get (_tmp167_);
			i = (GeeArrayList*) _tmp168_;
			_tmp169_ = i;
			_tmp170_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp169_);
			_tmp171_ = _tmp170_;
			if (_tmp171_ == 0) {
				contains_empty = TRUE;
			}
			_g_object_unref0 (i);
		}
		_g_object_unref0 (_i_it);
	}
	_tmp172_ = contains_empty;
	if (_tmp172_) {
		GeeArrayList* _tmp173_ = NULL;
		Guess* _tmp174_ = NULL;
		gint _tmp175_ = 0;
		gboolean _tmp176_ = FALSE;
		gboolean _tmp177_ = FALSE;
		_tmp173_ = self->priv->trailDetails;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp173_, "Guess leaves us with impossible squares.");
		_tmp174_ = guess_obj;
		sudoku_solver_unwrap_guess (self, _tmp174_);
		_tmp175_ = self->priv->debug_indent;
		self->priv->debug_indent = _tmp175_ + 1;
		_tmp177_ = sudoku_solver_guess_least_open_square (self, &_inner_error_);
		_tmp176_ = _tmp177_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == SUDOKU_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (possibilties_left);
				_guess_unref0 (guess_obj);
				guesses_for_coord = (_vala_array_free (guesses_for_coord, guesses_for_coord_length1, (GDestroyNotify) guess_unref), NULL);
				_g_object_unref0 (possible_values);
				_g_object_unref0 (least_coord_possibilties);
				_g_object_unref0 (iter);
				_g_object_unref0 (poss);
				return FALSE;
			} else {
				_g_object_unref0 (possibilties_left);
				_guess_unref0 (guess_obj);
				guesses_for_coord = (_vala_array_free (guesses_for_coord, guesses_for_coord_length1, (GDestroyNotify) guess_unref), NULL);
				_g_object_unref0 (possible_values);
				_g_object_unref0 (least_coord_possibilties);
				_g_object_unref0 (iter);
				_g_object_unref0 (poss);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		result = _tmp176_;
		_g_object_unref0 (possibilties_left);
		_guess_unref0 (guess_obj);
		guesses_for_coord = (_vala_array_free (guesses_for_coord, guesses_for_coord_length1, (GDestroyNotify) guess_unref), NULL);
		_g_object_unref0 (possible_values);
		_g_object_unref0 (least_coord_possibilties);
		_g_object_unref0 (iter);
		_g_object_unref0 (poss);
		return result;
	}
	result = FALSE;
	_g_object_unref0 (possibilties_left);
	_guess_unref0 (guess_obj);
	guesses_for_coord = (_vala_array_free (guesses_for_coord, guesses_for_coord_length1, (GDestroyNotify) guess_unref), NULL);
	_g_object_unref0 (possible_values);
	_g_object_unref0 (least_coord_possibilties);
	_g_object_unref0 (iter);
	_g_object_unref0 (poss);
	return result;
}


gboolean sudoku_solver_guess_least_open_square (SudokuSolver* self, GError** error) {
	g_return_val_if_fail (self != NULL, FALSE);
	return SUDOKU_SOLVER_GET_CLASS (self)->guess_least_open_square (self, error);
}


static void sudoku_solver_unwrap_guess (SudokuSolver* self, Guess* guess) {
	GeeArrayList* _tmp0_ = NULL;
	Guess* _tmp1_ = NULL;
	GeeArrayList* _tmp2_ = NULL;
	SudokuBoard* _tmp3_ = NULL;
	Guess* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	Guess* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	BreadcrumbTrail* _tmp60_ = NULL;
	Guess* _tmp61_ = NULL;
	gboolean _tmp62_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (guess != NULL);
	_tmp0_ = self->priv->trail;
	_tmp1_ = guess;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp0_, _tmp1_);
	_tmp2_ = self->priv->trailDetails;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp2_, "-");
	_tmp3_ = self->board;
	_tmp4_ = guess;
	_tmp5_ = guess_get_row (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = guess;
	_tmp8_ = guess_get_col (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = sudoku_board_get (_tmp3_, _tmp6_, _tmp9_);
	if (_tmp10_ != 0) {
		SudokuBoard* _tmp11_ = NULL;
		Guess* _tmp12_ = NULL;
		gint _tmp13_ = 0;
		gint _tmp14_ = 0;
		Guess* _tmp15_ = NULL;
		gint _tmp16_ = 0;
		gint _tmp17_ = 0;
		_tmp11_ = self->board;
		_tmp12_ = guess;
		_tmp13_ = guess_get_row (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = guess;
		_tmp16_ = guess_get_col (_tmp15_);
		_tmp17_ = _tmp16_;
		sudoku_board_remove (_tmp11_, _tmp14_, _tmp17_, FALSE);
	}
	{
		GeeIterator* _coord_it = NULL;
		Guess* _tmp18_ = NULL;
		GeeHashMap* _tmp19_ = NULL;
		GeeSet* _tmp20_ = NULL;
		GeeSet* _tmp21_ = NULL;
		GeeSet* _tmp22_ = NULL;
		GeeIterator* _tmp23_ = NULL;
		GeeIterator* _tmp24_ = NULL;
		_tmp18_ = guess;
		_tmp19_ = _tmp18_->consequences;
		_tmp20_ = gee_abstract_map_get_keys ((GeeMap*) _tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = _tmp21_;
		_tmp23_ = gee_iterable_iterator ((GeeIterable*) _tmp22_);
		_tmp24_ = _tmp23_;
		_g_object_unref0 (_tmp22_);
		_coord_it = _tmp24_;
		while (TRUE) {
			GeeIterator* _tmp25_ = NULL;
			gboolean _tmp26_ = FALSE;
			Coord coord = {0};
			GeeIterator* _tmp27_ = NULL;
			gpointer _tmp28_ = NULL;
			Coord* _tmp29_ = NULL;
			Coord _tmp30_ = {0};
			SudokuBoard* _tmp31_ = NULL;
			Coord _tmp32_ = {0};
			gint _tmp33_ = 0;
			Coord _tmp34_ = {0};
			gint _tmp35_ = 0;
			gint _tmp36_ = 0;
			_tmp25_ = _coord_it;
			_tmp26_ = gee_iterator_next (_tmp25_);
			if (!_tmp26_) {
				break;
			}
			_tmp27_ = _coord_it;
			_tmp28_ = gee_iterator_get (_tmp27_);
			_tmp29_ = (Coord*) _tmp28_;
			_tmp30_ = *_tmp29_;
			_coord_free0 (_tmp29_);
			coord = _tmp30_;
			_tmp31_ = self->board;
			_tmp32_ = coord;
			_tmp33_ = _tmp32_.row;
			_tmp34_ = coord;
			_tmp35_ = _tmp34_.col;
			_tmp36_ = sudoku_board_get (_tmp31_, _tmp33_, _tmp35_);
			if (_tmp36_ != 0) {
				SudokuBoard* _tmp37_ = NULL;
				Coord _tmp38_ = {0};
				gint _tmp39_ = 0;
				Coord _tmp40_ = {0};
				gint _tmp41_ = 0;
				_tmp37_ = self->board;
				_tmp38_ = coord;
				_tmp39_ = _tmp38_.row;
				_tmp40_ = coord;
				_tmp41_ = _tmp40_.col;
				sudoku_board_remove (_tmp37_, _tmp39_, _tmp41_, FALSE);
			}
		}
		_g_object_unref0 (_coord_it);
	}
	{
		GeeArrayList* _child_list = NULL;
		Guess* _tmp42_ = NULL;
		GeeArrayList* _tmp43_ = NULL;
		GeeArrayList* _tmp44_ = NULL;
		gint _child_size = 0;
		GeeArrayList* _tmp45_ = NULL;
		gint _tmp46_ = 0;
		gint _tmp47_ = 0;
		gint _child_index = 0;
		_tmp42_ = guess;
		_tmp43_ = _tmp42_->children;
		_tmp44_ = _g_object_ref0 (_tmp43_);
		_child_list = _tmp44_;
		_tmp45_ = _child_list;
		_tmp46_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp45_);
		_tmp47_ = _tmp46_;
		_child_size = _tmp47_;
		_child_index = -1;
		while (TRUE) {
			gint _tmp48_ = 0;
			gint _tmp49_ = 0;
			gint _tmp50_ = 0;
			Guess* child = NULL;
			GeeArrayList* _tmp51_ = NULL;
			gint _tmp52_ = 0;
			gpointer _tmp53_ = NULL;
			Guess* _tmp54_ = NULL;
			GuessList* _tmp55_ = NULL;
			Guess* _tmp56_ = NULL;
			gboolean _tmp57_ = FALSE;
			_tmp48_ = _child_index;
			_child_index = _tmp48_ + 1;
			_tmp49_ = _child_index;
			_tmp50_ = _child_size;
			if (!(_tmp49_ < _tmp50_)) {
				break;
			}
			_tmp51_ = _child_list;
			_tmp52_ = _child_index;
			_tmp53_ = gee_abstract_list_get ((GeeAbstractList*) _tmp51_, _tmp52_);
			child = (Guess*) _tmp53_;
			_tmp54_ = child;
			sudoku_solver_unwrap_guess (self, _tmp54_);
			_tmp55_ = self->guesses;
			_tmp56_ = child;
			_tmp57_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp55_, _tmp56_);
			if (_tmp57_) {
				GuessList* _tmp58_ = NULL;
				Guess* _tmp59_ = NULL;
				_tmp58_ = self->guesses;
				_tmp59_ = child;
				gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp58_, _tmp59_);
			}
			_guess_unref0 (child);
		}
		_g_object_unref0 (_child_list);
	}
	_tmp60_ = self->breadcrumbs;
	_tmp61_ = guess;
	_tmp62_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp60_, _tmp61_);
	if (_tmp62_) {
		BreadcrumbTrail* _tmp63_ = NULL;
		Guess* _tmp64_ = NULL;
		_tmp63_ = self->breadcrumbs;
		_tmp64_ = guess;
		gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp63_, _tmp64_);
	}
}


static void sudoku_solver_real_insert (SudokuSolver* self, gint row, gint col, gint val) {
	Guess* _tmp0_ = NULL;
	SudokuBoard* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	_tmp0_ = self->priv->current_guess;
	if (_tmp0_ != NULL) {
		Guess* _tmp1_ = NULL;
		gint _tmp2_ = 0;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		_tmp1_ = self->priv->current_guess;
		_tmp2_ = row;
		_tmp3_ = col;
		_tmp4_ = val;
		guess_add_consequence (_tmp1_, _tmp2_, _tmp3_, _tmp4_);
	}
	_tmp5_ = self->board;
	_tmp6_ = row;
	_tmp7_ = col;
	_tmp8_ = val;
	sudoku_board_insert (_tmp5_, _tmp6_, _tmp7_, _tmp8_, FALSE);
}


void sudoku_solver_insert (SudokuSolver* self, gint row, gint col, gint val) {
	g_return_if_fail (self != NULL);
	SUDOKU_SOLVER_GET_CLASS (self)->insert (self, row, col, val);
}


static gpointer _sudoku_solver_ref0 (gpointer self) {
	return self ? sudoku_solver_ref (self) : NULL;
}


SudokuSolverIterator* sudoku_solver_iterator_construct (GType object_type, SudokuSolver* solver) {
	SudokuSolverIterator* self = NULL;
	SudokuSolver* _tmp0_ = NULL;
	SudokuSolver* _tmp1_ = NULL;
	g_return_val_if_fail (solver != NULL, NULL);
	self = (SudokuSolverIterator*) g_type_create_instance (object_type);
	_tmp0_ = solver;
	_tmp1_ = _sudoku_solver_ref0 (_tmp0_);
	_sudoku_solver_unref0 (self->priv->solver);
	self->priv->solver = _tmp1_;
	return self;
}


SudokuSolverIterator* sudoku_solver_iterator_new (SudokuSolver* solver) {
	return sudoku_solver_iterator_construct (SUDOKU_SOLVER_TYPE_ITERATOR, solver);
}


gboolean sudoku_solver_iterator_next (SudokuSolverIterator* self) {
	gboolean result = FALSE;
	SudokuSolver* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->solver;
	_tmp1_ = _tmp0_->solved;
	if (!_tmp1_) {
		SudokuSolver* _tmp2_ = NULL;
		GeeArrayList* _tmp3_ = NULL;
		GeeArrayList* _tmp4_ = NULL;
		SudokuSolver* _tmp8_ = NULL;
		SudokuSolver* _tmp9_ = NULL;
		SudokuBoard* _tmp10_ = NULL;
		SudokuBoard* _tmp11_ = NULL;
		_tmp2_ = self->priv->solver;
		_tmp3_ = sudoku_solver_auto_fill (_tmp2_);
		_tmp4_ = _tmp3_;
		_g_object_unref0 (_tmp4_);
		{
			while (TRUE) {
				gboolean _tmp5_ = FALSE;
				SudokuSolver* _tmp6_ = NULL;
				gboolean _tmp7_ = FALSE;
				_tmp6_ = self->priv->solver;
				_tmp7_ = sudoku_solver_guess_least_open_square (_tmp6_, &_inner_error_);
				_tmp5_ = _tmp7_;
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					if (_inner_error_->domain == SUDOKU_ERROR) {
						goto __catch5_sudoku_error;
					}
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return FALSE;
				}
				if (!(!_tmp5_)) {
					break;
				}
			}
		}
		goto __finally5;
		__catch5_sudoku_error:
		{
			GError* e = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_sudoku_board_unref0 (self->priv->solution);
			self->priv->solution = NULL;
			result = FALSE;
			_g_error_free0 (e);
			return result;
		}
		__finally5:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		_tmp8_ = self->priv->solver;
		_tmp8_->solved = TRUE;
		_tmp9_ = self->priv->solver;
		_tmp10_ = _tmp9_->board;
		_tmp11_ = _sudoku_board_ref0 (_tmp10_);
		_sudoku_board_unref0 (self->priv->solution);
		self->priv->solution = _tmp11_;
		result = TRUE;
		return result;
	} else {
		while (TRUE) {
			SudokuSolver* _tmp12_ = NULL;
			BreadcrumbTrail* _tmp13_ = NULL;
			gint _tmp14_ = 0;
			gint _tmp15_ = 0;
			SudokuSolver* _tmp16_ = NULL;
			SudokuSolver* _tmp17_ = NULL;
			BreadcrumbTrail* _tmp18_ = NULL;
			SudokuSolver* _tmp19_ = NULL;
			BreadcrumbTrail* _tmp20_ = NULL;
			gint _tmp21_ = 0;
			gint _tmp22_ = 0;
			gpointer _tmp23_ = NULL;
			Guess* _tmp24_ = NULL;
			SudokuSolver* _tmp28_ = NULL;
			SudokuBoard* _tmp29_ = NULL;
			SudokuBoard* _tmp30_ = NULL;
			_tmp12_ = self->priv->solver;
			_tmp13_ = _tmp12_->breadcrumbs;
			_tmp14_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp13_);
			_tmp15_ = _tmp14_;
			if (!(_tmp15_ != 0)) {
				break;
			}
			_tmp16_ = self->priv->solver;
			_tmp17_ = self->priv->solver;
			_tmp18_ = _tmp17_->breadcrumbs;
			_tmp19_ = self->priv->solver;
			_tmp20_ = _tmp19_->breadcrumbs;
			_tmp21_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp20_);
			_tmp22_ = _tmp21_;
			_tmp23_ = gee_abstract_list_get ((GeeAbstractList*) _tmp18_, _tmp22_ - 1);
			_tmp24_ = (Guess*) _tmp23_;
			sudoku_solver_unwrap_guess (_tmp16_, _tmp24_);
			_guess_unref0 (_tmp24_);
			{
				while (TRUE) {
					gboolean _tmp25_ = FALSE;
					SudokuSolver* _tmp26_ = NULL;
					gboolean _tmp27_ = FALSE;
					_tmp26_ = self->priv->solver;
					_tmp27_ = sudoku_solver_guess_least_open_square (_tmp26_, &_inner_error_);
					_tmp25_ = _tmp27_;
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						if (_inner_error_->domain == SUDOKU_ERROR) {
							goto __catch6_sudoku_error;
						}
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return FALSE;
					}
					if (!(!_tmp25_)) {
						break;
					}
				}
			}
			goto __finally6;
			__catch6_sudoku_error:
			{
				GError* e = NULL;
				e = _inner_error_;
				_inner_error_ = NULL;
				_sudoku_board_unref0 (self->priv->solution);
				self->priv->solution = NULL;
				result = FALSE;
				_g_error_free0 (e);
				return result;
			}
			__finally6:
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
			_tmp28_ = self->priv->solver;
			_tmp29_ = _tmp28_->board;
			_tmp30_ = _sudoku_board_ref0 (_tmp29_);
			_sudoku_board_unref0 (self->priv->solution);
			self->priv->solution = _tmp30_;
			result = TRUE;
			return result;
		}
		result = FALSE;
		return result;
	}
}


SudokuBoard* sudoku_solver_iterator_get (SudokuSolverIterator* self) {
	SudokuBoard* result = NULL;
	SudokuBoard* _tmp0_ = NULL;
	SudokuBoard* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->solution;
	_tmp1_ = _sudoku_board_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


static void sudoku_solver_value_iterator_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void sudoku_solver_value_iterator_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		sudoku_solver_iterator_unref (value->data[0].v_pointer);
	}
}


static void sudoku_solver_value_iterator_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = sudoku_solver_iterator_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer sudoku_solver_value_iterator_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* sudoku_solver_value_iterator_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		SudokuSolverIterator* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = sudoku_solver_iterator_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* sudoku_solver_value_iterator_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	SudokuSolverIterator** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = sudoku_solver_iterator_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* sudoku_solver_param_spec_iterator (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	SudokuSolverParamSpecIterator* spec;
	g_return_val_if_fail (g_type_is_a (object_type, SUDOKU_SOLVER_TYPE_ITERATOR), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer sudoku_solver_value_get_iterator (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SUDOKU_SOLVER_TYPE_ITERATOR), NULL);
	return value->data[0].v_pointer;
}


void sudoku_solver_value_set_iterator (GValue* value, gpointer v_object) {
	SudokuSolverIterator* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SUDOKU_SOLVER_TYPE_ITERATOR));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, SUDOKU_SOLVER_TYPE_ITERATOR));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		sudoku_solver_iterator_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		sudoku_solver_iterator_unref (old);
	}
}


void sudoku_solver_value_take_iterator (GValue* value, gpointer v_object) {
	SudokuSolverIterator* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SUDOKU_SOLVER_TYPE_ITERATOR));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, SUDOKU_SOLVER_TYPE_ITERATOR));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		sudoku_solver_iterator_unref (old);
	}
}


static void sudoku_solver_iterator_class_init (SudokuSolverIteratorClass * klass) {
	sudoku_solver_iterator_parent_class = g_type_class_peek_parent (klass);
	SUDOKU_SOLVER_ITERATOR_CLASS (klass)->finalize = sudoku_solver_iterator_finalize;
	g_type_class_add_private (klass, sizeof (SudokuSolverIteratorPrivate));
}


static void sudoku_solver_iterator_instance_init (SudokuSolverIterator * self) {
	self->priv = SUDOKU_SOLVER_ITERATOR_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void sudoku_solver_iterator_finalize (SudokuSolverIterator* obj) {
	SudokuSolverIterator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SUDOKU_SOLVER_TYPE_ITERATOR, SudokuSolverIterator);
	_sudoku_solver_unref0 (self->priv->solver);
	_sudoku_board_unref0 (self->priv->solution);
}


GType sudoku_solver_iterator_get_type (void) {
	static volatile gsize sudoku_solver_iterator_type_id__volatile = 0;
	if (g_once_init_enter (&sudoku_solver_iterator_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { sudoku_solver_value_iterator_init, sudoku_solver_value_iterator_free_value, sudoku_solver_value_iterator_copy_value, sudoku_solver_value_iterator_peek_pointer, "p", sudoku_solver_value_iterator_collect_value, "p", sudoku_solver_value_iterator_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (SudokuSolverIteratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sudoku_solver_iterator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SudokuSolverIterator), 0, (GInstanceInitFunc) sudoku_solver_iterator_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType sudoku_solver_iterator_type_id;
		sudoku_solver_iterator_type_id = g_type_register_fundamental (g_type_fundamental_next (), "SudokuSolverIterator", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&sudoku_solver_iterator_type_id__volatile, sudoku_solver_iterator_type_id);
	}
	return sudoku_solver_iterator_type_id__volatile;
}


gpointer sudoku_solver_iterator_ref (gpointer instance) {
	SudokuSolverIterator* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void sudoku_solver_iterator_unref (gpointer instance) {
	SudokuSolverIterator* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		SUDOKU_SOLVER_ITERATOR_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void value_sudoku_solver_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_sudoku_solver_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		sudoku_solver_unref (value->data[0].v_pointer);
	}
}


static void value_sudoku_solver_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = sudoku_solver_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_sudoku_solver_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_sudoku_solver_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		SudokuSolver* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = sudoku_solver_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_sudoku_solver_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	SudokuSolver** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = sudoku_solver_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_sudoku_solver (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecSudokuSolver* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_SUDOKU_SOLVER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_sudoku_solver (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SUDOKU_SOLVER), NULL);
	return value->data[0].v_pointer;
}


void value_set_sudoku_solver (GValue* value, gpointer v_object) {
	SudokuSolver* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SUDOKU_SOLVER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SUDOKU_SOLVER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		sudoku_solver_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		sudoku_solver_unref (old);
	}
}


void value_take_sudoku_solver (GValue* value, gpointer v_object) {
	SudokuSolver* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SUDOKU_SOLVER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SUDOKU_SOLVER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		sudoku_solver_unref (old);
	}
}


static void sudoku_solver_class_init (SudokuSolverClass * klass) {
	sudoku_solver_parent_class = g_type_class_peek_parent (klass);
	SUDOKU_SOLVER_CLASS (klass)->finalize = sudoku_solver_finalize;
	g_type_class_add_private (klass, sizeof (SudokuSolverPrivate));
	SUDOKU_SOLVER_CLASS (klass)->guess_least_open_square = sudoku_solver_real_guess_least_open_square;
	SUDOKU_SOLVER_CLASS (klass)->insert = sudoku_solver_real_insert;
}


static void sudoku_solver_instance_init (SudokuSolver * self) {
	GeeArrayList* _tmp0_ = NULL;
	GeeArrayList* _tmp1_ = NULL;
	self->priv = SUDOKU_SOLVER_GET_PRIVATE (self);
	self->backtraces = 0;
	self->priv->count_solutions = FALSE;
	self->priv->break_at = 100;
	_tmp0_ = gee_array_list_new (TYPE_GUESS, (GBoxedCopyFunc) guess_ref, guess_unref, NULL, NULL, NULL);
	self->priv->trail = _tmp0_;
	_tmp1_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
	self->priv->trailDetails = _tmp1_;
	self->priv->debug_indent = 0;
	self->ref_count = 1;
}


static void sudoku_solver_finalize (SudokuSolver* obj) {
	SudokuSolver * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SUDOKU_SOLVER, SudokuSolver);
	_sudoku_board_unref0 (self->board);
	_parallel_dict_unref0 (self->priv->conflicts);
	_g_object_unref0 (self->guesses);
	_g_object_unref0 (self->breadcrumbs);
	_guess_unref0 (self->priv->current_guess);
	_g_object_unref0 (self->priv->trail);
	_g_object_unref0 (self->priv->trailDetails);
}


GType sudoku_solver_get_type (void) {
	static volatile gsize sudoku_solver_type_id__volatile = 0;
	if (g_once_init_enter (&sudoku_solver_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_sudoku_solver_init, value_sudoku_solver_free_value, value_sudoku_solver_copy_value, value_sudoku_solver_peek_pointer, "p", value_sudoku_solver_collect_value, "p", value_sudoku_solver_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (SudokuSolverClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sudoku_solver_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SudokuSolver), 0, (GInstanceInitFunc) sudoku_solver_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType sudoku_solver_type_id;
		sudoku_solver_type_id = g_type_register_fundamental (g_type_fundamental_next (), "SudokuSolver", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&sudoku_solver_type_id__volatile, sudoku_solver_type_id);
	}
	return sudoku_solver_type_id__volatile;
}


gpointer sudoku_solver_ref (gpointer instance) {
	SudokuSolver* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void sudoku_solver_unref (gpointer instance) {
	SudokuSolver* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		SUDOKU_SOLVER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


SudokuRater* sudoku_rater_construct (GType object_type, SudokuBoard** board) {
	SudokuRater* self = NULL;
	GeeArrayList* _tmp0_ = NULL;
	GeeHashSet* _tmp1_ = NULL;
	GeeHashMap* _tmp2_ = NULL;
	GeeHashMap* _tmp3_ = NULL;
	g_return_val_if_fail (*board != NULL, NULL);
	self = (SudokuRater*) sudoku_solver_construct (object_type, board);
	self->priv->guessing = FALSE;
	self->priv->fake_add = FALSE;
	_tmp0_ = gee_array_list_new (TYPE_CELL, (GBoxedCopyFunc) cell_dup, cell_free, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->fake_additions);
	self->priv->fake_additions = _tmp0_;
	_tmp1_ = gee_hash_set_new (TYPE_CELL, (GBoxedCopyFunc) cell_dup, cell_free, (GeeHashDataFunc) cell_hash, NULL, NULL, (GeeEqualDataFunc) cell_equal, NULL, NULL);
	_g_object_unref0 (self->priv->filled);
	self->priv->filled = _tmp1_;
	_tmp2_ = gee_hash_map_new (G_TYPE_INT, NULL, NULL, GEE_TYPE_HASH_SET, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->fill_must_fillables);
	self->priv->fill_must_fillables = _tmp2_;
	_tmp3_ = gee_hash_map_new (G_TYPE_INT, NULL, NULL, GEE_TYPE_HASH_SET, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->elimination_fillables);
	self->priv->elimination_fillables = _tmp3_;
	self->priv->tier = 0;
	return self;
}


SudokuRater* sudoku_rater_new (SudokuBoard** board) {
	return sudoku_rater_construct (TYPE_SUDOKU_RATER, board);
}


static void sudoku_rater_real_insert (SudokuSolver* base, gint row, gint col, gint val) {
	SudokuRater * self;
	gboolean _tmp0_ = FALSE;
	self = (SudokuRater*) base;
	_tmp0_ = self->priv->fake_add;
	if (!_tmp0_) {
		gboolean _tmp1_ = FALSE;
		_tmp1_ = self->priv->guessing;
		if (!_tmp1_) {
			SudokuBoard* _tmp31_ = NULL;
			gint _tmp32_ = 0;
			gint _tmp33_ = 0;
			gint _tmp34_ = 0;
			gint _tmp38_ = 0;
			sudoku_rater_scan_fillables (self);
			{
				GeeArrayList* _delayed_cell_list = NULL;
				GeeArrayList* _tmp2_ = NULL;
				GeeArrayList* _tmp3_ = NULL;
				gint _delayed_cell_size = 0;
				GeeArrayList* _tmp4_ = NULL;
				gint _tmp5_ = 0;
				gint _tmp6_ = 0;
				gint _delayed_cell_index = 0;
				_tmp2_ = self->priv->add_me_queue;
				_tmp3_ = _g_object_ref0 (_tmp2_);
				_delayed_cell_list = _tmp3_;
				_tmp4_ = _delayed_cell_list;
				_tmp5_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp4_);
				_tmp6_ = _tmp5_;
				_delayed_cell_size = _tmp6_;
				_delayed_cell_index = -1;
				while (TRUE) {
					gint _tmp7_ = 0;
					gint _tmp8_ = 0;
					gint _tmp9_ = 0;
					Cell delayed_cell = {0};
					GeeArrayList* _tmp10_ = NULL;
					gint _tmp11_ = 0;
					gpointer _tmp12_ = NULL;
					Cell* _tmp13_ = NULL;
					Cell _tmp14_ = {0};
					SudokuBoard* _tmp15_ = NULL;
					Cell _tmp16_ = {0};
					Coord _tmp17_ = {0};
					gint _tmp18_ = 0;
					Cell _tmp19_ = {0};
					Coord _tmp20_ = {0};
					gint _tmp21_ = 0;
					gint _tmp22_ = 0;
					_tmp7_ = _delayed_cell_index;
					_delayed_cell_index = _tmp7_ + 1;
					_tmp8_ = _delayed_cell_index;
					_tmp9_ = _delayed_cell_size;
					if (!(_tmp8_ < _tmp9_)) {
						break;
					}
					_tmp10_ = _delayed_cell_list;
					_tmp11_ = _delayed_cell_index;
					_tmp12_ = gee_abstract_list_get ((GeeAbstractList*) _tmp10_, _tmp11_);
					_tmp13_ = (Cell*) _tmp12_;
					_tmp14_ = *_tmp13_;
					_cell_free0 (_tmp13_);
					delayed_cell = _tmp14_;
					_tmp15_ = ((SudokuSolver*) self)->board;
					_tmp16_ = delayed_cell;
					_tmp17_ = _tmp16_.coord;
					_tmp18_ = _tmp17_.row;
					_tmp19_ = delayed_cell;
					_tmp20_ = _tmp19_.coord;
					_tmp21_ = _tmp20_.col;
					_tmp22_ = sudoku_board_get (_tmp15_, _tmp18_, _tmp21_);
					if (_tmp22_ == 0) {
						Cell _tmp23_ = {0};
						Coord _tmp24_ = {0};
						gint _tmp25_ = 0;
						Cell _tmp26_ = {0};
						Coord _tmp27_ = {0};
						gint _tmp28_ = 0;
						Cell _tmp29_ = {0};
						gint _tmp30_ = 0;
						_tmp23_ = delayed_cell;
						_tmp24_ = _tmp23_.coord;
						_tmp25_ = _tmp24_.row;
						_tmp26_ = delayed_cell;
						_tmp27_ = _tmp26_.coord;
						_tmp28_ = _tmp27_.col;
						_tmp29_ = delayed_cell;
						_tmp30_ = _tmp29_.val;
						SUDOKU_SOLVER_CLASS (sudoku_rater_parent_class)->insert (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SUDOKU_SOLVER, SudokuSolver), _tmp25_, _tmp28_, _tmp30_);
					}
				}
				_g_object_unref0 (_delayed_cell_list);
			}
			_tmp31_ = ((SudokuSolver*) self)->board;
			_tmp32_ = row;
			_tmp33_ = col;
			_tmp34_ = sudoku_board_get (_tmp31_, _tmp32_, _tmp33_);
			if (_tmp34_ == 0) {
				gint _tmp35_ = 0;
				gint _tmp36_ = 0;
				gint _tmp37_ = 0;
				_tmp35_ = row;
				_tmp36_ = col;
				_tmp37_ = val;
				SUDOKU_SOLVER_CLASS (sudoku_rater_parent_class)->insert (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SUDOKU_SOLVER, SudokuSolver), _tmp35_, _tmp36_, _tmp37_);
			}
			_tmp38_ = self->priv->tier;
			self->priv->tier = _tmp38_ + 1;
		} else {
			gint _tmp39_ = 0;
			gint _tmp40_ = 0;
			gint _tmp41_ = 0;
			_tmp39_ = row;
			_tmp40_ = col;
			_tmp41_ = val;
			SUDOKU_SOLVER_CLASS (sudoku_rater_parent_class)->insert (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SUDOKU_SOLVER, SudokuSolver), _tmp39_, _tmp40_, _tmp41_);
		}
	} else {
		GeeArrayList* _tmp42_ = NULL;
		gint _tmp43_ = 0;
		gint _tmp44_ = 0;
		Coord _tmp45_ = {0};
		gint _tmp46_ = 0;
		Cell _tmp47_ = {0};
		_tmp42_ = self->priv->fake_additions;
		_tmp43_ = row;
		_tmp44_ = col;
		coord_init (&_tmp45_, _tmp43_, _tmp44_);
		_tmp46_ = val;
		cell_init (&_tmp47_, &_tmp45_, _tmp46_);
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp42_, &_tmp47_);
	}
}


static void sudoku_rater_scan_fillables (SudokuRater* self) {
	GeeArrayList* _tmp0_ = NULL;
	GeeHashMap* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	GeeHashSet* _tmp5_ = NULL;
	GeeHashSet* _tmp6_ = NULL;
	GeeArrayList* _tmp28_ = NULL;
	GeeArrayList* _tmp29_ = NULL;
	GeeArrayList* _tmp30_ = NULL;
	GeeArrayList* _tmp31_ = NULL;
	GeeArrayList* _tmp32_ = NULL;
	GeeHashMap* _tmp33_ = NULL;
	gint _tmp34_ = 0;
	GeeHashSet* _tmp35_ = NULL;
	GeeHashSet* _tmp36_ = NULL;
	GeeHashSet* _tmp58_ = NULL;
	GeeHashMap* _tmp59_ = NULL;
	gint _tmp60_ = 0;
	gpointer _tmp61_ = NULL;
	GeeHashSet* _tmp62_ = NULL;
	GeeHashSet* _tmp63_ = NULL;
	GeeHashMap* _tmp64_ = NULL;
	gint _tmp65_ = 0;
	gpointer _tmp66_ = NULL;
	GeeHashSet* _tmp67_ = NULL;
	GeeArrayList* _tmp68_ = NULL;
	GeeArrayList* _tmp69_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	self->priv->fake_add = TRUE;
	_tmp0_ = gee_array_list_new (TYPE_CELL, (GBoxedCopyFunc) cell_dup, cell_free, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->fake_additions);
	self->priv->fake_additions = _tmp0_;
	{
		GeeArrayList* _tmp1_ = NULL;
		GeeArrayList* _tmp2_ = NULL;
		_tmp1_ = sudoku_solver_fill_must_fills ((SudokuSolver*) self, &_inner_error_);
		_tmp2_ = _tmp1_;
		_g_object_unref0 (_tmp2_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == SUDOKU_ERROR) {
				goto __catch7_sudoku_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally7;
	__catch7_sudoku_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (e);
	}
	__finally7:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp3_ = self->priv->fill_must_fillables;
	_tmp4_ = self->priv->tier;
	_tmp5_ = gee_hash_set_new (TYPE_CELL, (GBoxedCopyFunc) cell_dup, cell_free, (GeeHashDataFunc) cell_hash, NULL, NULL, (GeeEqualDataFunc) cell_equal, NULL, NULL);
	_tmp6_ = _tmp5_;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp3_, (gpointer) ((gintptr) _tmp4_), _tmp6_);
	_g_object_unref0 (_tmp6_);
	{
		GeeArrayList* _cell_list = NULL;
		GeeArrayList* _tmp7_ = NULL;
		GeeArrayList* _tmp8_ = NULL;
		gint _cell_size = 0;
		GeeArrayList* _tmp9_ = NULL;
		gint _tmp10_ = 0;
		gint _tmp11_ = 0;
		gint _cell_index = 0;
		_tmp7_ = self->priv->fake_additions;
		_tmp8_ = _g_object_ref0 (_tmp7_);
		_cell_list = _tmp8_;
		_tmp9_ = _cell_list;
		_tmp10_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp9_);
		_tmp11_ = _tmp10_;
		_cell_size = _tmp11_;
		_cell_index = -1;
		while (TRUE) {
			gint _tmp12_ = 0;
			gint _tmp13_ = 0;
			gint _tmp14_ = 0;
			Cell cell = {0};
			GeeArrayList* _tmp15_ = NULL;
			gint _tmp16_ = 0;
			gpointer _tmp17_ = NULL;
			Cell* _tmp18_ = NULL;
			Cell _tmp19_ = {0};
			GeeHashSet* _tmp20_ = NULL;
			Cell _tmp21_ = {0};
			gboolean _tmp22_ = FALSE;
			_tmp12_ = _cell_index;
			_cell_index = _tmp12_ + 1;
			_tmp13_ = _cell_index;
			_tmp14_ = _cell_size;
			if (!(_tmp13_ < _tmp14_)) {
				break;
			}
			_tmp15_ = _cell_list;
			_tmp16_ = _cell_index;
			_tmp17_ = gee_abstract_list_get ((GeeAbstractList*) _tmp15_, _tmp16_);
			_tmp18_ = (Cell*) _tmp17_;
			_tmp19_ = *_tmp18_;
			_cell_free0 (_tmp18_);
			cell = _tmp19_;
			_tmp20_ = self->priv->filled;
			_tmp21_ = cell;
			_tmp22_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp20_, &_tmp21_);
			if (!_tmp22_) {
				GeeHashMap* _tmp23_ = NULL;
				gint _tmp24_ = 0;
				gpointer _tmp25_ = NULL;
				GeeHashSet* _tmp26_ = NULL;
				Cell _tmp27_ = {0};
				_tmp23_ = self->priv->fill_must_fillables;
				_tmp24_ = self->priv->tier;
				_tmp25_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp23_, (gpointer) ((gintptr) _tmp24_));
				_tmp26_ = (GeeHashSet*) _tmp25_;
				_tmp27_ = cell;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp26_, &_tmp27_);
				_g_object_unref0 (_tmp26_);
			}
		}
		_g_object_unref0 (_cell_list);
	}
	_tmp28_ = self->priv->fake_additions;
	_tmp29_ = _g_object_ref0 (_tmp28_);
	_g_object_unref0 (self->priv->add_me_queue);
	self->priv->add_me_queue = _tmp29_;
	_tmp30_ = gee_array_list_new (TYPE_CELL, (GBoxedCopyFunc) cell_dup, cell_free, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->fake_additions);
	self->priv->fake_additions = _tmp30_;
	_tmp31_ = sudoku_solver_fill_deterministically ((SudokuSolver*) self);
	_tmp32_ = _tmp31_;
	_g_object_unref0 (_tmp32_);
	_tmp33_ = self->priv->elimination_fillables;
	_tmp34_ = self->priv->tier;
	_tmp35_ = gee_hash_set_new (TYPE_CELL, (GBoxedCopyFunc) cell_dup, cell_free, (GeeHashDataFunc) cell_hash, NULL, NULL, (GeeEqualDataFunc) cell_equal, NULL, NULL);
	_tmp36_ = _tmp35_;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp33_, (gpointer) ((gintptr) _tmp34_), _tmp36_);
	_g_object_unref0 (_tmp36_);
	{
		GeeArrayList* _cell_list = NULL;
		GeeArrayList* _tmp37_ = NULL;
		GeeArrayList* _tmp38_ = NULL;
		gint _cell_size = 0;
		GeeArrayList* _tmp39_ = NULL;
		gint _tmp40_ = 0;
		gint _tmp41_ = 0;
		gint _cell_index = 0;
		_tmp37_ = self->priv->fake_additions;
		_tmp38_ = _g_object_ref0 (_tmp37_);
		_cell_list = _tmp38_;
		_tmp39_ = _cell_list;
		_tmp40_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp39_);
		_tmp41_ = _tmp40_;
		_cell_size = _tmp41_;
		_cell_index = -1;
		while (TRUE) {
			gint _tmp42_ = 0;
			gint _tmp43_ = 0;
			gint _tmp44_ = 0;
			Cell cell = {0};
			GeeArrayList* _tmp45_ = NULL;
			gint _tmp46_ = 0;
			gpointer _tmp47_ = NULL;
			Cell* _tmp48_ = NULL;
			Cell _tmp49_ = {0};
			GeeHashSet* _tmp50_ = NULL;
			Cell _tmp51_ = {0};
			gboolean _tmp52_ = FALSE;
			_tmp42_ = _cell_index;
			_cell_index = _tmp42_ + 1;
			_tmp43_ = _cell_index;
			_tmp44_ = _cell_size;
			if (!(_tmp43_ < _tmp44_)) {
				break;
			}
			_tmp45_ = _cell_list;
			_tmp46_ = _cell_index;
			_tmp47_ = gee_abstract_list_get ((GeeAbstractList*) _tmp45_, _tmp46_);
			_tmp48_ = (Cell*) _tmp47_;
			_tmp49_ = *_tmp48_;
			_cell_free0 (_tmp48_);
			cell = _tmp49_;
			_tmp50_ = self->priv->filled;
			_tmp51_ = cell;
			_tmp52_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp50_, &_tmp51_);
			if (!_tmp52_) {
				GeeHashMap* _tmp53_ = NULL;
				gint _tmp54_ = 0;
				gpointer _tmp55_ = NULL;
				GeeHashSet* _tmp56_ = NULL;
				Cell _tmp57_ = {0};
				_tmp53_ = self->priv->elimination_fillables;
				_tmp54_ = self->priv->tier;
				_tmp55_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp53_, (gpointer) ((gintptr) _tmp54_));
				_tmp56_ = (GeeHashSet*) _tmp55_;
				_tmp57_ = cell;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp56_, &_tmp57_);
				_g_object_unref0 (_tmp56_);
			}
		}
		_g_object_unref0 (_cell_list);
	}
	_tmp58_ = self->priv->filled;
	_tmp59_ = self->priv->fill_must_fillables;
	_tmp60_ = self->priv->tier;
	_tmp61_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp59_, (gpointer) ((gintptr) _tmp60_));
	_tmp62_ = (GeeHashSet*) _tmp61_;
	gee_collection_add_all ((GeeCollection*) _tmp58_, (GeeCollection*) _tmp62_);
	_g_object_unref0 (_tmp62_);
	_tmp63_ = self->priv->filled;
	_tmp64_ = self->priv->elimination_fillables;
	_tmp65_ = self->priv->tier;
	_tmp66_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp64_, (gpointer) ((gintptr) _tmp65_));
	_tmp67_ = (GeeHashSet*) _tmp66_;
	gee_collection_add_all ((GeeCollection*) _tmp63_, (GeeCollection*) _tmp67_);
	_g_object_unref0 (_tmp67_);
	_tmp68_ = self->priv->add_me_queue;
	_tmp69_ = self->priv->fake_additions;
	gee_array_list_add_all (_tmp68_, (GeeCollection*) _tmp69_);
	self->priv->fake_add = FALSE;
}


static gboolean sudoku_rater_real_guess_least_open_square (SudokuSolver* base, GError** error) {
	SudokuRater * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
	self = (SudokuRater*) base;
	self->priv->guessing = TRUE;
	_tmp1_ = SUDOKU_SOLVER_CLASS (sudoku_rater_parent_class)->guess_least_open_square (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SUDOKU_SOLVER, SudokuSolver), &_inner_error_);
	_tmp0_ = _tmp1_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == SUDOKU_ERROR) {
			g_propagate_error (error, _inner_error_);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = _tmp0_;
	return result;
}


DifficultyRating* sudoku_rater_get_difficulty (SudokuRater* self) {
	DifficultyRating* result = NULL;
	gboolean _tmp0_ = FALSE;
	gint clues = 0;
	gint numbers_added = 0;
	SudokuBoard* _tmp21_ = NULL;
	gint _tmp22_ = 0;
	gint _tmp23_ = 0;
	SudokuBoard* _tmp24_ = NULL;
	gint _tmp25_ = 0;
	gint _tmp26_ = 0;
	gint _tmp27_ = 0;
	DifficultyRating* rating = NULL;
	GeeHashMap* _tmp28_ = NULL;
	GeeHashMap* _tmp29_ = NULL;
	GuessList* _tmp30_ = NULL;
	gint _tmp31_ = 0;
	DifficultyRating* _tmp32_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = ((SudokuSolver*) self)->solved;
	if (!_tmp0_) {
		SudokuBoard* _tmp1_ = NULL;
		SudokuBoard* _tmp2_ = NULL;
		_tmp1_ = sudoku_solver_solve ((SudokuSolver*) self);
		_tmp2_ = _tmp1_;
		_sudoku_board_unref0 (_tmp2_);
	}
	clues = 0;
	{
		gint row = 0;
		row = 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				gint _tmp5_ = 0;
				SudokuBoard* _tmp6_ = NULL;
				gint _tmp7_ = 0;
				gint _tmp8_ = 0;
				if (!_tmp3_) {
					gint _tmp4_ = 0;
					_tmp4_ = row;
					row = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp5_ = row;
				_tmp6_ = ((SudokuSolver*) self)->board;
				_tmp7_ = sudoku_board_get_rows (_tmp6_);
				_tmp8_ = _tmp7_;
				if (!(_tmp5_ < _tmp8_)) {
					break;
				}
				{
					gint col = 0;
					col = 0;
					{
						gboolean _tmp9_ = FALSE;
						_tmp9_ = TRUE;
						while (TRUE) {
							gint _tmp11_ = 0;
							SudokuBoard* _tmp12_ = NULL;
							gint _tmp13_ = 0;
							gint _tmp14_ = 0;
							SudokuBoard* _tmp15_ = NULL;
							gboolean* _tmp16_ = NULL;
							gint _tmp16__length1 = 0;
							gint _tmp16__length2 = 0;
							gint _tmp17_ = 0;
							gint _tmp18_ = 0;
							gboolean _tmp19_ = FALSE;
							if (!_tmp9_) {
								gint _tmp10_ = 0;
								_tmp10_ = col;
								col = _tmp10_ + 1;
							}
							_tmp9_ = FALSE;
							_tmp11_ = col;
							_tmp12_ = ((SudokuSolver*) self)->board;
							_tmp13_ = sudoku_board_get_cols (_tmp12_);
							_tmp14_ = _tmp13_;
							if (!(_tmp11_ < _tmp14_)) {
								break;
							}
							_tmp15_ = ((SudokuSolver*) self)->board;
							_tmp16_ = _tmp15_->is_fixed;
							_tmp16__length1 = _tmp15_->is_fixed_length1;
							_tmp16__length2 = _tmp15_->is_fixed_length2;
							_tmp17_ = row;
							_tmp18_ = col;
							_tmp19_ = _tmp16_[(_tmp17_ * _tmp16__length2) + _tmp18_];
							if (_tmp19_) {
								gint _tmp20_ = 0;
								_tmp20_ = clues;
								clues = _tmp20_ + 1;
							}
						}
					}
				}
			}
		}
	}
	_tmp21_ = ((SudokuSolver*) self)->board;
	_tmp22_ = sudoku_board_get_rows (_tmp21_);
	_tmp23_ = _tmp22_;
	_tmp24_ = ((SudokuSolver*) self)->board;
	_tmp25_ = sudoku_board_get_cols (_tmp24_);
	_tmp26_ = _tmp25_;
	_tmp27_ = clues;
	numbers_added = (_tmp23_ * _tmp26_) - _tmp27_;
	_tmp28_ = self->priv->fill_must_fillables;
	_tmp29_ = self->priv->elimination_fillables;
	_tmp30_ = ((SudokuSolver*) self)->guesses;
	_tmp31_ = ((SudokuSolver*) self)->backtraces;
	_tmp32_ = difficulty_rating_new (_tmp28_, _tmp29_, _tmp30_, _tmp31_, numbers_added);
	rating = _tmp32_;
	result = rating;
	return result;
}


static void sudoku_rater_class_init (SudokuRaterClass * klass) {
	sudoku_rater_parent_class = g_type_class_peek_parent (klass);
	SUDOKU_SOLVER_CLASS (klass)->finalize = sudoku_rater_finalize;
	g_type_class_add_private (klass, sizeof (SudokuRaterPrivate));
	SUDOKU_SOLVER_CLASS (klass)->insert = sudoku_rater_real_insert;
	SUDOKU_SOLVER_CLASS (klass)->guess_least_open_square = sudoku_rater_real_guess_least_open_square;
}


static void sudoku_rater_instance_init (SudokuRater * self) {
	self->priv = SUDOKU_RATER_GET_PRIVATE (self);
}


static void sudoku_rater_finalize (SudokuSolver* obj) {
	SudokuRater * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SUDOKU_RATER, SudokuRater);
	_g_object_unref0 (self->priv->fake_additions);
	_g_object_unref0 (self->priv->add_me_queue);
	_g_object_unref0 (self->priv->filled);
	_g_object_unref0 (self->priv->fill_must_fillables);
	_g_object_unref0 (self->priv->elimination_fillables);
	SUDOKU_SOLVER_CLASS (sudoku_rater_parent_class)->finalize (obj);
}


GType sudoku_rater_get_type (void) {
	static volatile gsize sudoku_rater_type_id__volatile = 0;
	if (g_once_init_enter (&sudoku_rater_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SudokuRaterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sudoku_rater_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SudokuRater), 0, (GInstanceInitFunc) sudoku_rater_instance_init, NULL };
		GType sudoku_rater_type_id;
		sudoku_rater_type_id = g_type_register_static (TYPE_SUDOKU_SOLVER, "SudokuRater", &g_define_type_info, 0);
		g_once_init_leave (&sudoku_rater_type_id__volatile, sudoku_rater_type_id);
	}
	return sudoku_rater_type_id__volatile;
}


Guess* guess_construct (GType object_type, gint row, gint col, gint val) {
	Guess* self = NULL;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	GeeHashMap* _tmp3_ = NULL;
	GeeArrayList* _tmp4_ = NULL;
	self = (Guess*) g_type_create_instance (object_type);
	_tmp0_ = row;
	self->priv->_row = _tmp0_;
	_tmp1_ = col;
	self->priv->_col = _tmp1_;
	_tmp2_ = val;
	self->priv->_val = _tmp2_;
	_tmp3_ = gee_hash_map_new (TYPE_COORD, (GBoxedCopyFunc) coord_dup, coord_free, G_TYPE_INT, NULL, NULL, (GeeHashDataFunc) coord_hash, NULL, NULL, (GeeEqualDataFunc) coord_equal, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->consequences);
	self->consequences = _tmp3_;
	_tmp4_ = gee_array_list_new (TYPE_GUESS, (GBoxedCopyFunc) guess_ref, guess_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->children);
	self->children = _tmp4_;
	return self;
}


Guess* guess_new (gint row, gint col, gint val) {
	return guess_construct (TYPE_GUESS, row, col, val);
}


void guess_add_consequence (Guess* self, gint row, gint col, gint val) {
	GeeHashMap* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	Coord _tmp3_ = {0};
	gint _tmp4_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->consequences;
	_tmp1_ = row;
	_tmp2_ = col;
	coord_init (&_tmp3_, _tmp1_, _tmp2_);
	_tmp4_ = val;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp0_, &_tmp3_, (gpointer) ((gintptr) _tmp4_));
}


gint guess_get_row (Guess* self) {
	gint result;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_row;
	result = _tmp0_;
	return result;
}


gint guess_get_col (Guess* self) {
	gint result;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_col;
	result = _tmp0_;
	return result;
}


gint guess_get_val (Guess* self) {
	gint result;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_val;
	result = _tmp0_;
	return result;
}


static void value_guess_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_guess_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		guess_unref (value->data[0].v_pointer);
	}
}


static void value_guess_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = guess_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_guess_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_guess_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		Guess* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = guess_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_guess_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	Guess** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = guess_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_guess (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecGuess* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_GUESS), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_guess (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_GUESS), NULL);
	return value->data[0].v_pointer;
}


void value_set_guess (GValue* value, gpointer v_object) {
	Guess* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_GUESS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_GUESS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		guess_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		guess_unref (old);
	}
}


void value_take_guess (GValue* value, gpointer v_object) {
	Guess* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_GUESS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_GUESS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		guess_unref (old);
	}
}


static void guess_class_init (GuessClass * klass) {
	guess_parent_class = g_type_class_peek_parent (klass);
	GUESS_CLASS (klass)->finalize = guess_finalize;
	g_type_class_add_private (klass, sizeof (GuessPrivate));
}


static void guess_instance_init (Guess * self) {
	self->priv = GUESS_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void guess_finalize (Guess* obj) {
	Guess * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_GUESS, Guess);
	_g_object_unref0 (self->children);
	_g_object_unref0 (self->consequences);
}


GType guess_get_type (void) {
	static volatile gsize guess_type_id__volatile = 0;
	if (g_once_init_enter (&guess_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_guess_init, value_guess_free_value, value_guess_copy_value, value_guess_peek_pointer, "p", value_guess_collect_value, "p", value_guess_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (GuessClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) guess_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Guess), 0, (GInstanceInitFunc) guess_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType guess_type_id;
		guess_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Guess", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&guess_type_id__volatile, guess_type_id);
	}
	return guess_type_id__volatile;
}


gpointer guess_ref (gpointer instance) {
	Guess* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void guess_unref (gpointer instance) {
	Guess* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		GUESS_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _vala_array_add6 (Guess*** array, int* length, int* size, Guess* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (Guess*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


Guess** guess_list_guesses_for (GuessList* self, gint row, gint col, int* result_length1) {
	Guess** result = NULL;
	Guess** guesses = NULL;
	Guess** _tmp0_ = NULL;
	gint guesses_length1 = 0;
	gint _guesses_size_ = 0;
	Guess** _tmp23_ = NULL;
	gint _tmp23__length1 = 0;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_new0 (Guess*, 0 + 1);
	guesses = _tmp0_;
	guesses_length1 = 0;
	_guesses_size_ = guesses_length1;
	{
		GuessList* _guess_list = NULL;
		GuessList* _tmp1_ = NULL;
		gint _guess_size = 0;
		GuessList* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint _guess_index = 0;
		_tmp1_ = _g_object_ref0 (self);
		_guess_list = _tmp1_;
		_tmp2_ = _guess_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_guess_size = _tmp4_;
		_guess_index = -1;
		while (TRUE) {
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			Guess* guess = NULL;
			GuessList* _tmp8_ = NULL;
			gint _tmp9_ = 0;
			gpointer _tmp10_ = NULL;
			gboolean _tmp11_ = FALSE;
			Guess* _tmp12_ = NULL;
			gint _tmp13_ = 0;
			gint _tmp14_ = 0;
			gint _tmp15_ = 0;
			_tmp5_ = _guess_index;
			_guess_index = _tmp5_ + 1;
			_tmp6_ = _guess_index;
			_tmp7_ = _guess_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _guess_list;
			_tmp9_ = _guess_index;
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
			guess = (Guess*) _tmp10_;
			_tmp12_ = guess;
			_tmp13_ = guess_get_row (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = row;
			if (_tmp14_ == _tmp15_) {
				Guess* _tmp16_ = NULL;
				gint _tmp17_ = 0;
				gint _tmp18_ = 0;
				gint _tmp19_ = 0;
				_tmp16_ = guess;
				_tmp17_ = guess_get_col (_tmp16_);
				_tmp18_ = _tmp17_;
				_tmp19_ = col;
				_tmp11_ = _tmp18_ == _tmp19_;
			} else {
				_tmp11_ = FALSE;
			}
			if (_tmp11_) {
				Guess** _tmp20_ = NULL;
				gint _tmp20__length1 = 0;
				Guess* _tmp21_ = NULL;
				Guess* _tmp22_ = NULL;
				_tmp20_ = guesses;
				_tmp20__length1 = guesses_length1;
				_tmp21_ = guess;
				_tmp22_ = _guess_ref0 (_tmp21_);
				_vala_array_add6 (&guesses, &guesses_length1, &_guesses_size_, _tmp22_);
			}
			_guess_unref0 (guess);
		}
		_g_object_unref0 (_guess_list);
	}
	_tmp23_ = guesses;
	_tmp23__length1 = guesses_length1;
	if (result_length1) {
		*result_length1 = _tmp23__length1;
	}
	result = _tmp23_;
	return result;
}


static void _vala_array_add7 (Guess*** array, int* length, int* size, Guess* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (Guess*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


Guess** guess_list_remove_children (GuessList* self, Guess* guess, int* result_length1) {
	Guess** result = NULL;
	Guess** removed = NULL;
	Guess** _tmp0_ = NULL;
	gint removed_length1 = 0;
	gint _removed_size_ = 0;
	Guess** _tmp19_ = NULL;
	gint _tmp19__length1 = 0;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (guess != NULL, NULL);
	_tmp0_ = g_new0 (Guess*, 0 + 1);
	removed = _tmp0_;
	removed_length1 = 0;
	_removed_size_ = removed_length1;
	{
		GeeArrayList* _g_list = NULL;
		Guess* _tmp1_ = NULL;
		GeeArrayList* _tmp2_ = NULL;
		GeeArrayList* _tmp3_ = NULL;
		gint _g_size = 0;
		GeeArrayList* _tmp4_ = NULL;
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
		gint _g_index = 0;
		_tmp1_ = guess;
		_tmp2_ = _tmp1_->children;
		_tmp3_ = _g_object_ref0 (_tmp2_);
		_g_list = _tmp3_;
		_tmp4_ = _g_list;
		_tmp5_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_g_size = _tmp6_;
		_g_index = -1;
		while (TRUE) {
			gint _tmp7_ = 0;
			gint _tmp8_ = 0;
			gint _tmp9_ = 0;
			Guess* g = NULL;
			GeeArrayList* _tmp10_ = NULL;
			gint _tmp11_ = 0;
			gpointer _tmp12_ = NULL;
			Guess* _tmp13_ = NULL;
			gboolean _tmp14_ = FALSE;
			_tmp7_ = _g_index;
			_g_index = _tmp7_ + 1;
			_tmp8_ = _g_index;
			_tmp9_ = _g_size;
			if (!(_tmp8_ < _tmp9_)) {
				break;
			}
			_tmp10_ = _g_list;
			_tmp11_ = _g_index;
			_tmp12_ = gee_abstract_list_get ((GeeAbstractList*) _tmp10_, _tmp11_);
			g = (Guess*) _tmp12_;
			_tmp13_ = g;
			_tmp14_ = gee_abstract_collection_contains ((GeeAbstractCollection*) self, _tmp13_);
			if (_tmp14_) {
				Guess** _tmp15_ = NULL;
				gint _tmp15__length1 = 0;
				Guess* _tmp16_ = NULL;
				Guess* _tmp17_ = NULL;
				Guess* _tmp18_ = NULL;
				_tmp15_ = removed;
				_tmp15__length1 = removed_length1;
				_tmp16_ = g;
				_tmp17_ = _guess_ref0 (_tmp16_);
				_vala_array_add7 (&removed, &removed_length1, &_removed_size_, _tmp17_);
				_tmp18_ = g;
				gee_abstract_collection_remove ((GeeAbstractCollection*) self, _tmp18_);
			}
			_guess_unref0 (g);
		}
		_g_object_unref0 (_g_list);
	}
	_tmp19_ = removed;
	_tmp19__length1 = removed_length1;
	if (result_length1) {
		*result_length1 = _tmp19__length1;
	}
	result = _tmp19_;
	return result;
}


static void _vala_array_add8 (Guess*** array, int* length, int* size, Guess* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (Guess*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


Guess** guess_list_remove_guesses_for (GuessList* self, gint row, gint col, int* result_length1) {
	Guess** result = NULL;
	Guess** removed = NULL;
	Guess** _tmp0_ = NULL;
	gint removed_length1 = 0;
	gint _removed_size_ = 0;
	Guess** _tmp24_ = NULL;
	gint _tmp24__length1 = 0;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_new0 (Guess*, 0 + 1);
	removed = _tmp0_;
	removed_length1 = 0;
	_removed_size_ = removed_length1;
	{
		GuessList* _guess_list = NULL;
		GuessList* _tmp1_ = NULL;
		gint _guess_size = 0;
		GuessList* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint _guess_index = 0;
		_tmp1_ = _g_object_ref0 (self);
		_guess_list = _tmp1_;
		_tmp2_ = _guess_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_guess_size = _tmp4_;
		_guess_index = -1;
		while (TRUE) {
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			Guess* guess = NULL;
			GuessList* _tmp8_ = NULL;
			gint _tmp9_ = 0;
			gpointer _tmp10_ = NULL;
			gboolean _tmp11_ = FALSE;
			Guess* _tmp12_ = NULL;
			gint _tmp13_ = 0;
			gint _tmp14_ = 0;
			gint _tmp15_ = 0;
			_tmp5_ = _guess_index;
			_guess_index = _tmp5_ + 1;
			_tmp6_ = _guess_index;
			_tmp7_ = _guess_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _guess_list;
			_tmp9_ = _guess_index;
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
			guess = (Guess*) _tmp10_;
			_tmp12_ = guess;
			_tmp13_ = guess_get_row (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = row;
			if (_tmp14_ == _tmp15_) {
				Guess* _tmp16_ = NULL;
				gint _tmp17_ = 0;
				gint _tmp18_ = 0;
				gint _tmp19_ = 0;
				_tmp16_ = guess;
				_tmp17_ = guess_get_col (_tmp16_);
				_tmp18_ = _tmp17_;
				_tmp19_ = col;
				_tmp11_ = _tmp18_ == _tmp19_;
			} else {
				_tmp11_ = FALSE;
			}
			if (_tmp11_) {
				Guess** _tmp20_ = NULL;
				gint _tmp20__length1 = 0;
				Guess* _tmp21_ = NULL;
				Guess* _tmp22_ = NULL;
				Guess* _tmp23_ = NULL;
				_tmp20_ = removed;
				_tmp20__length1 = removed_length1;
				_tmp21_ = guess;
				_tmp22_ = _guess_ref0 (_tmp21_);
				_vala_array_add8 (&removed, &removed_length1, &_removed_size_, _tmp22_);
				_tmp23_ = guess;
				gee_abstract_collection_remove ((GeeAbstractCollection*) self, _tmp23_);
			}
			_guess_unref0 (guess);
		}
		_g_object_unref0 (_guess_list);
	}
	_tmp24_ = removed;
	_tmp24__length1 = removed_length1;
	if (result_length1) {
		*result_length1 = _tmp24__length1;
	}
	result = _tmp24_;
	return result;
}


GuessList* guess_list_construct (GType object_type) {
	GuessList * self = NULL;
	self = (GuessList*) gee_array_list_construct (object_type, TYPE_GUESS, (GBoxedCopyFunc) guess_ref, guess_unref, NULL, NULL, NULL);
	return self;
}


GuessList* guess_list_new (void) {
	return guess_list_construct (TYPE_GUESS_LIST);
}


static void guess_list_class_init (GuessListClass * klass) {
	guess_list_parent_class = g_type_class_peek_parent (klass);
}


static void guess_list_instance_init (GuessList * self) {
}


GType guess_list_get_type (void) {
	static volatile gsize guess_list_type_id__volatile = 0;
	if (g_once_init_enter (&guess_list_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GuessListClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) guess_list_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GuessList), 0, (GInstanceInitFunc) guess_list_instance_init, NULL };
		GType guess_list_type_id;
		guess_list_type_id = g_type_register_static (GEE_TYPE_ARRAY_LIST, "GuessList", &g_define_type_info, 0);
		g_once_init_leave (&guess_list_type_id__volatile, guess_list_type_id);
	}
	return guess_list_type_id__volatile;
}


void breadcrumb_trail_append (BreadcrumbTrail* self, Guess* guess) {
	Guess* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	Guess* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	Guess** _tmp7_ = NULL;
	Guess** _tmp8_ = NULL;
	gint _tmp8__length1 = 0;
	gboolean _tmp9_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (guess != NULL);
	_tmp0_ = guess;
	_tmp1_ = guess_get_row (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = guess;
	_tmp4_ = guess_get_col (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp7_ = guess_list_guesses_for ((GuessList*) self, _tmp2_, _tmp5_, &_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp8__length1 = _tmp6_;
	_tmp9_ = _tmp6_ != 0;
	_tmp8_ = (_vala_array_free (_tmp8_, _tmp8__length1, (GDestroyNotify) guess_unref), NULL);
	if (_tmp9_) {
	} else {
		Guess* _tmp10_ = NULL;
		_tmp10_ = guess;
		gee_abstract_collection_add ((GeeAbstractCollection*) self, _tmp10_);
	}
}


BreadcrumbTrail* breadcrumb_trail_construct (GType object_type) {
	BreadcrumbTrail * self = NULL;
	self = (BreadcrumbTrail*) guess_list_construct (object_type);
	return self;
}


BreadcrumbTrail* breadcrumb_trail_new (void) {
	return breadcrumb_trail_construct (TYPE_BREADCRUMB_TRAIL);
}


static void breadcrumb_trail_class_init (BreadcrumbTrailClass * klass) {
	breadcrumb_trail_parent_class = g_type_class_peek_parent (klass);
}


static void breadcrumb_trail_instance_init (BreadcrumbTrail * self) {
}


GType breadcrumb_trail_get_type (void) {
	static volatile gsize breadcrumb_trail_type_id__volatile = 0;
	if (g_once_init_enter (&breadcrumb_trail_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BreadcrumbTrailClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) breadcrumb_trail_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BreadcrumbTrail), 0, (GInstanceInitFunc) breadcrumb_trail_instance_init, NULL };
		GType breadcrumb_trail_type_id;
		breadcrumb_trail_type_id = g_type_register_static (TYPE_GUESS_LIST, "BreadcrumbTrail", &g_define_type_info, 0);
		g_once_init_leave (&breadcrumb_trail_type_id__volatile, breadcrumb_trail_type_id);
	}
	return breadcrumb_trail_type_id__volatile;
}


static gboolean _coord_equal (const Coord* s1, const Coord* s2) {
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	if (s1->row != s2->row) {
		return FALSE;
	}
	if (s1->col != s2->col) {
		return FALSE;
	}
	return TRUE;
}


void parallel_dict_set (ParallelDict* self, Coord* k, GeeHashSet* v) {
	GeeHashMap* _tmp0_ = NULL;
	Coord _tmp1_ = {0};
	GeeHashSet* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (k != NULL);
	g_return_if_fail (v != NULL);
	_tmp0_ = self->priv->map;
	_tmp1_ = *k;
	_tmp2_ = v;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp0_, &_tmp1_, _tmp2_);
	{
		GeeIterator* _i_it = NULL;
		GeeHashSet* _tmp3_ = NULL;
		GeeIterator* _tmp4_ = NULL;
		_tmp3_ = v;
		_tmp4_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp3_);
		_i_it = _tmp4_;
		while (TRUE) {
			GeeIterator* _tmp5_ = NULL;
			gboolean _tmp6_ = FALSE;
			Coord i = {0};
			GeeIterator* _tmp7_ = NULL;
			gpointer _tmp8_ = NULL;
			Coord* _tmp9_ = NULL;
			Coord _tmp10_ = {0};
			Coord _tmp11_ = {0};
			Coord _tmp12_ = {0};
			GeeHashMap* _tmp13_ = NULL;
			Coord _tmp14_ = {0};
			gboolean _tmp15_ = FALSE;
			_tmp5_ = _i_it;
			_tmp6_ = gee_iterator_next (_tmp5_);
			if (!_tmp6_) {
				break;
			}
			_tmp7_ = _i_it;
			_tmp8_ = gee_iterator_get (_tmp7_);
			_tmp9_ = (Coord*) _tmp8_;
			_tmp10_ = *_tmp9_;
			_coord_free0 (_tmp9_);
			i = _tmp10_;
			_tmp11_ = i;
			_tmp12_ = *k;
			if (_coord_equal (&_tmp11_, &_tmp12_) == TRUE) {
				continue;
			}
			_tmp13_ = self->priv->map;
			_tmp14_ = i;
			_tmp15_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp13_, &_tmp14_);
			if (_tmp15_) {
				GeeHashMap* _tmp16_ = NULL;
				Coord _tmp17_ = {0};
				gpointer _tmp18_ = NULL;
				GeeHashSet* _tmp19_ = NULL;
				Coord _tmp20_ = {0};
				_tmp16_ = self->priv->map;
				_tmp17_ = *k;
				_tmp18_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp16_, &_tmp17_);
				_tmp19_ = (GeeHashSet*) _tmp18_;
				_tmp20_ = i;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp19_, &_tmp20_);
				_g_object_unref0 (_tmp19_);
			} else {
				GeeHashSet* kSet = NULL;
				GeeHashSet* _tmp21_ = NULL;
				GeeHashSet* _tmp22_ = NULL;
				Coord _tmp23_ = {0};
				GeeHashMap* _tmp24_ = NULL;
				Coord _tmp25_ = {0};
				GeeHashSet* _tmp26_ = NULL;
				_tmp21_ = gee_hash_set_new (TYPE_COORD, (GBoxedCopyFunc) coord_dup, coord_free, NULL, NULL, NULL, NULL, NULL, NULL);
				kSet = _tmp21_;
				_tmp22_ = kSet;
				_tmp23_ = *k;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp22_, &_tmp23_);
				_tmp24_ = self->priv->map;
				_tmp25_ = i;
				_tmp26_ = kSet;
				gee_abstract_map_set ((GeeAbstractMap*) _tmp24_, &_tmp25_, _tmp26_);
				_g_object_unref0 (kSet);
			}
		}
		_g_object_unref0 (_i_it);
	}
}


void parallel_dict_unset (ParallelDict* self, Coord* k) {
	GeeHashSet* v = NULL;
	GeeHashMap* _tmp0_ = NULL;
	Coord _tmp1_ = {0};
	gpointer _tmp2_ = NULL;
	GeeHashMap* _tmp3_ = NULL;
	Coord _tmp4_ = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (k != NULL);
	_tmp0_ = self->priv->map;
	_tmp1_ = *k;
	_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, &_tmp1_);
	v = (GeeHashSet*) _tmp2_;
	_tmp3_ = self->priv->map;
	_tmp4_ = *k;
	gee_abstract_map_unset ((GeeAbstractMap*) _tmp3_, &_tmp4_, NULL);
	{
		GeeIterator* _i_it = NULL;
		GeeHashSet* _tmp5_ = NULL;
		GeeIterator* _tmp6_ = NULL;
		_tmp5_ = v;
		_tmp6_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp5_);
		_i_it = _tmp6_;
		while (TRUE) {
			GeeIterator* _tmp7_ = NULL;
			gboolean _tmp8_ = FALSE;
			Coord i = {0};
			GeeIterator* _tmp9_ = NULL;
			gpointer _tmp10_ = NULL;
			Coord* _tmp11_ = NULL;
			Coord _tmp12_ = {0};
			Coord _tmp13_ = {0};
			Coord _tmp14_ = {0};
			GeeHashMap* _tmp15_ = NULL;
			Coord _tmp16_ = {0};
			gboolean _tmp17_ = FALSE;
			_tmp7_ = _i_it;
			_tmp8_ = gee_iterator_next (_tmp7_);
			if (!_tmp8_) {
				break;
			}
			_tmp9_ = _i_it;
			_tmp10_ = gee_iterator_get (_tmp9_);
			_tmp11_ = (Coord*) _tmp10_;
			_tmp12_ = *_tmp11_;
			_coord_free0 (_tmp11_);
			i = _tmp12_;
			_tmp13_ = i;
			_tmp14_ = *k;
			if (_coord_equal (&_tmp13_, &_tmp14_) == TRUE) {
				continue;
			}
			_tmp15_ = self->priv->map;
			_tmp16_ = i;
			_tmp17_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp15_, &_tmp16_);
			if (_tmp17_) {
				GeeHashMap* _tmp18_ = NULL;
				Coord _tmp19_ = {0};
				gpointer _tmp20_ = NULL;
				GeeHashSet* _tmp21_ = NULL;
				Coord _tmp22_ = {0};
				gboolean _tmp23_ = FALSE;
				gboolean _tmp24_ = FALSE;
				GeeHashMap* _tmp30_ = NULL;
				Coord _tmp31_ = {0};
				gpointer _tmp32_ = NULL;
				GeeHashSet* _tmp33_ = NULL;
				gint _tmp34_ = 0;
				gint _tmp35_ = 0;
				gboolean _tmp36_ = FALSE;
				_tmp18_ = self->priv->map;
				_tmp19_ = i;
				_tmp20_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp18_, &_tmp19_);
				_tmp21_ = (GeeHashSet*) _tmp20_;
				_tmp22_ = *k;
				_tmp23_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp21_, &_tmp22_);
				_tmp24_ = _tmp23_;
				_g_object_unref0 (_tmp21_);
				if (_tmp24_) {
					GeeHashMap* _tmp25_ = NULL;
					Coord _tmp26_ = {0};
					gpointer _tmp27_ = NULL;
					GeeHashSet* _tmp28_ = NULL;
					Coord _tmp29_ = {0};
					_tmp25_ = self->priv->map;
					_tmp26_ = i;
					_tmp27_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp25_, &_tmp26_);
					_tmp28_ = (GeeHashSet*) _tmp27_;
					_tmp29_ = *k;
					gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp28_, &_tmp29_);
					_g_object_unref0 (_tmp28_);
				}
				_tmp30_ = self->priv->map;
				_tmp31_ = i;
				_tmp32_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp30_, &_tmp31_);
				_tmp33_ = (GeeHashSet*) _tmp32_;
				_tmp34_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp33_);
				_tmp35_ = _tmp34_;
				_tmp36_ = _tmp35_ == 0;
				_g_object_unref0 (_tmp33_);
				if (_tmp36_) {
					GeeHashMap* _tmp37_ = NULL;
					Coord _tmp38_ = {0};
					_tmp37_ = self->priv->map;
					_tmp38_ = i;
					gee_abstract_map_unset ((GeeAbstractMap*) _tmp37_, &_tmp38_, NULL);
				}
			}
		}
		_g_object_unref0 (_i_it);
	}
	_g_object_unref0 (v);
}


gboolean parallel_dict_contains (ParallelDict* self, Coord* key) {
	gboolean result = FALSE;
	GeeHashMap* _tmp0_ = NULL;
	Coord _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (key != NULL, FALSE);
	_tmp0_ = self->priv->map;
	_tmp1_ = *key;
	_tmp2_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, &_tmp1_);
	result = _tmp2_;
	return result;
}


ParallelDict* parallel_dict_construct (GType object_type) {
	ParallelDict* self = NULL;
	self = (ParallelDict*) g_type_create_instance (object_type);
	return self;
}


ParallelDict* parallel_dict_new (void) {
	return parallel_dict_construct (TYPE_PARALLEL_DICT);
}


static void value_parallel_dict_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_parallel_dict_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		parallel_dict_unref (value->data[0].v_pointer);
	}
}


static void value_parallel_dict_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = parallel_dict_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_parallel_dict_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_parallel_dict_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		ParallelDict* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = parallel_dict_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_parallel_dict_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ParallelDict** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = parallel_dict_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_parallel_dict (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecParallelDict* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_PARALLEL_DICT), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_parallel_dict (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PARALLEL_DICT), NULL);
	return value->data[0].v_pointer;
}


void value_set_parallel_dict (GValue* value, gpointer v_object) {
	ParallelDict* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PARALLEL_DICT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PARALLEL_DICT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		parallel_dict_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		parallel_dict_unref (old);
	}
}


void value_take_parallel_dict (GValue* value, gpointer v_object) {
	ParallelDict* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PARALLEL_DICT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PARALLEL_DICT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		parallel_dict_unref (old);
	}
}


static void parallel_dict_class_init (ParallelDictClass * klass) {
	parallel_dict_parent_class = g_type_class_peek_parent (klass);
	PARALLEL_DICT_CLASS (klass)->finalize = parallel_dict_finalize;
	g_type_class_add_private (klass, sizeof (ParallelDictPrivate));
}


static void parallel_dict_instance_init (ParallelDict * self) {
	GeeHashMap* _tmp0_ = NULL;
	self->priv = PARALLEL_DICT_GET_PRIVATE (self);
	_tmp0_ = gee_hash_map_new (TYPE_COORD, (GBoxedCopyFunc) coord_dup, coord_free, GEE_TYPE_HASH_SET, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->map = _tmp0_;
	self->ref_count = 1;
}


static void parallel_dict_finalize (ParallelDict* obj) {
	ParallelDict * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PARALLEL_DICT, ParallelDict);
	_g_object_unref0 (self->priv->map);
}


GType parallel_dict_get_type (void) {
	static volatile gsize parallel_dict_type_id__volatile = 0;
	if (g_once_init_enter (&parallel_dict_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_parallel_dict_init, value_parallel_dict_free_value, value_parallel_dict_copy_value, value_parallel_dict_peek_pointer, "p", value_parallel_dict_collect_value, "p", value_parallel_dict_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ParallelDictClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) parallel_dict_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ParallelDict), 0, (GInstanceInitFunc) parallel_dict_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType parallel_dict_type_id;
		parallel_dict_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ParallelDict", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&parallel_dict_type_id__volatile, parallel_dict_type_id);
	}
	return parallel_dict_type_id__volatile;
}


gpointer parallel_dict_ref (gpointer instance) {
	ParallelDict* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void parallel_dict_unref (gpointer instance) {
	ParallelDict* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		PARALLEL_DICT_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


gchar* difficulty_category_to_string (DifficultyCategory self) {
	gchar* result = NULL;
	switch (self) {
		case DIFFICULTY_CATEGORY_EASY:
		{
			const gchar* _tmp0_ = NULL;
			gchar* _tmp1_ = NULL;
			_tmp0_ = _ ("Easy Difficulty");
			_tmp1_ = g_strdup (_tmp0_);
			result = _tmp1_;
			return result;
		}
		case DIFFICULTY_CATEGORY_MEDIUM:
		{
			const gchar* _tmp2_ = NULL;
			gchar* _tmp3_ = NULL;
			_tmp2_ = _ ("Medium Difficulty");
			_tmp3_ = g_strdup (_tmp2_);
			result = _tmp3_;
			return result;
		}
		case DIFFICULTY_CATEGORY_HARD:
		{
			const gchar* _tmp4_ = NULL;
			gchar* _tmp5_ = NULL;
			_tmp4_ = _ ("Hard Difficulty");
			_tmp5_ = g_strdup (_tmp4_);
			result = _tmp5_;
			return result;
		}
		case DIFFICULTY_CATEGORY_VERY_HARD:
		{
			const gchar* _tmp6_ = NULL;
			gchar* _tmp7_ = NULL;
			_tmp6_ = _ ("Very Hard Difficulty");
			_tmp7_ = g_strdup (_tmp6_);
			result = _tmp7_;
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}


GType difficulty_category_get_type (void) {
	static volatile gsize difficulty_category_type_id__volatile = 0;
	if (g_once_init_enter (&difficulty_category_type_id__volatile)) {
		static const GEnumValue values[] = {{DIFFICULTY_CATEGORY_EASY, "DIFFICULTY_CATEGORY_EASY", "easy"}, {DIFFICULTY_CATEGORY_MEDIUM, "DIFFICULTY_CATEGORY_MEDIUM", "medium"}, {DIFFICULTY_CATEGORY_HARD, "DIFFICULTY_CATEGORY_HARD", "hard"}, {DIFFICULTY_CATEGORY_VERY_HARD, "DIFFICULTY_CATEGORY_VERY_HARD", "very-hard"}, {0, NULL, NULL}};
		GType difficulty_category_type_id;
		difficulty_category_type_id = g_enum_register_static ("DifficultyCategory", values);
		g_once_init_leave (&difficulty_category_type_id__volatile, difficulty_category_type_id);
	}
	return difficulty_category_type_id__volatile;
}


static gint _difficulty_rating_diminsh_by_one_difficulty_rating_diminsh_by (gint a, gpointer self) {
	gint result;
	result = difficulty_rating_diminsh_by_one (a);
	return result;
}


DifficultyRating* difficulty_rating_construct (GType object_type, GeeHashMap* fill_must_fillables, GeeHashMap* elimination_fillables, GuessList* guesses, gint backtraces, gint squares_filled) {
	DifficultyRating* self = NULL;
	GeeHashMap* _tmp0_ = NULL;
	GeeHashMap* _tmp1_ = NULL;
	GeeHashMap* _tmp2_ = NULL;
	GeeHashMap* _tmp3_ = NULL;
	GuessList* _tmp4_ = NULL;
	GuessList* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	GeeHashMap* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	GeeHashMap* _tmp16_ = NULL;
	gint _tmp17_ = 0;
	gint _tmp18_ = 0;
	gfloat _tmp24_ = 0.0F;
	gint _tmp25_ = 0;
	gfloat _tmp26_ = 0.0F;
	gint _tmp27_ = 0;
	GeeHashMap* _tmp28_ = NULL;
	gint _tmp29_ = 0;
	gint* _tmp30_ = NULL;
	gint* _tmp31_ = NULL;
	gint _tmp31__length1 = 0;
	gfloat _tmp32_ = 0.0F;
	GeeHashMap* _tmp33_ = NULL;
	gint _tmp34_ = 0;
	gint* _tmp35_ = NULL;
	gint* _tmp36_ = NULL;
	gint _tmp36__length1 = 0;
	gfloat _tmp37_ = 0.0F;
	gfloat _tmp38_ = 0.0F;
	g_return_val_if_fail (fill_must_fillables != NULL, NULL);
	g_return_val_if_fail (elimination_fillables != NULL, NULL);
	g_return_val_if_fail (guesses != NULL, NULL);
	self = (DifficultyRating*) g_type_create_instance (object_type);
	_tmp0_ = fill_must_fillables;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->fill_must_fillables);
	self->priv->fill_must_fillables = _tmp1_;
	_tmp2_ = elimination_fillables;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (self->priv->elimination_fillables);
	self->priv->elimination_fillables = _tmp3_;
	_tmp4_ = guesses;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	_g_object_unref0 (self->priv->guesses);
	self->priv->guesses = _tmp5_;
	_tmp6_ = backtraces;
	self->priv->backtraces = _tmp6_;
	_tmp7_ = squares_filled;
	self->priv->squares_filled = _tmp7_;
	_tmp8_ = fill_must_fillables;
	_tmp9_ = gee_abstract_map_get_size ((GeeMap*) _tmp8_);
	_tmp10_ = _tmp9_;
	if (_tmp10_ != 0) {
		GeeHashMap* _tmp11_ = NULL;
		gpointer _tmp12_ = NULL;
		GeeHashSet* _tmp13_ = NULL;
		gint _tmp14_ = 0;
		gint _tmp15_ = 0;
		_tmp11_ = fill_must_fillables;
		_tmp12_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp11_, (gpointer) ((gintptr) 0));
		_tmp13_ = (GeeHashSet*) _tmp12_;
		_tmp14_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp13_);
		_tmp15_ = _tmp14_;
		self->priv->instant_fill_fillable = (gfloat) _tmp15_;
		_g_object_unref0 (_tmp13_);
	} else {
		self->priv->instant_fill_fillable = 0.0f;
	}
	_tmp16_ = elimination_fillables;
	_tmp17_ = gee_abstract_map_get_size ((GeeMap*) _tmp16_);
	_tmp18_ = _tmp17_;
	if (_tmp18_ != 0) {
		GeeHashMap* _tmp19_ = NULL;
		gpointer _tmp20_ = NULL;
		GeeHashSet* _tmp21_ = NULL;
		gint _tmp22_ = 0;
		gint _tmp23_ = 0;
		_tmp19_ = elimination_fillables;
		_tmp20_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp19_, (gpointer) ((gintptr) 0));
		_tmp21_ = (GeeHashSet*) _tmp20_;
		_tmp22_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp21_);
		_tmp23_ = _tmp22_;
		self->priv->instant_elimination_fillable = (gfloat) _tmp23_;
		_g_object_unref0 (_tmp21_);
	} else {
		self->priv->instant_elimination_fillable = 0.0f;
	}
	_tmp24_ = self->priv->instant_elimination_fillable;
	_tmp25_ = squares_filled;
	self->priv->proportion_instant_elimination_fillable = _tmp24_ / _tmp25_;
	_tmp26_ = self->priv->instant_fill_fillable;
	_tmp27_ = squares_filled;
	self->priv->proportion_instant_fill_fillable = _tmp26_ / _tmp27_;
	_tmp28_ = elimination_fillables;
	_tmp30_ = difficulty_rating_count_values (self, _tmp28_, &_tmp29_);
	_tmp31_ = _tmp30_;
	_tmp31__length1 = _tmp29_;
	_tmp32_ = difficulty_rating_add_with_diminishing_importance (_tmp31_, _tmp29_, _difficulty_rating_diminsh_by_one_difficulty_rating_diminsh_by, NULL);
	self->priv->elimination_ease = _tmp32_;
	_tmp31_ = (g_free (_tmp31_), NULL);
	_tmp33_ = fill_must_fillables;
	_tmp35_ = difficulty_rating_count_values (self, _tmp33_, &_tmp34_);
	_tmp36_ = _tmp35_;
	_tmp36__length1 = _tmp34_;
	_tmp37_ = difficulty_rating_add_with_diminishing_importance (_tmp36_, _tmp34_, _difficulty_rating_diminsh_by_one_difficulty_rating_diminsh_by, NULL);
	self->priv->fillable_ease = _tmp37_;
	_tmp36_ = (g_free (_tmp36_), NULL);
	_tmp38_ = difficulty_rating_calculate (self);
	self->rating = _tmp38_;
	return self;
}


DifficultyRating* difficulty_rating_new (GeeHashMap* fill_must_fillables, GeeHashMap* elimination_fillables, GuessList* guesses, gint backtraces, gint squares_filled) {
	return difficulty_rating_construct (TYPE_DIFFICULTY_RATING, fill_must_fillables, elimination_fillables, guesses, backtraces, squares_filled);
}


static gint* difficulty_rating_count_values (DifficultyRating* self, GeeHashMap* map, int* result_length1) {
	gint* result = NULL;
	GeeTreeMap* sortedMap = NULL;
	GeeTreeMap* _tmp0_ = NULL;
	gint* array = NULL;
	GeeHashMap* _tmp17_ = NULL;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	gint* _tmp20_ = NULL;
	gint array_length1 = 0;
	gint _array_size_ = 0;
	gint p = 0;
	gint* _tmp41_ = NULL;
	gint _tmp41__length1 = 0;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (map != NULL, NULL);
	_tmp0_ = gee_tree_map_new (G_TYPE_INT, NULL, NULL, GEE_TYPE_HASH_SET, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	sortedMap = _tmp0_;
	{
		GeeIterator* _key_it = NULL;
		GeeHashMap* _tmp1_ = NULL;
		GeeSet* _tmp2_ = NULL;
		GeeSet* _tmp3_ = NULL;
		GeeSet* _tmp4_ = NULL;
		GeeIterator* _tmp5_ = NULL;
		GeeIterator* _tmp6_ = NULL;
		_tmp1_ = map;
		_tmp2_ = gee_abstract_map_get_keys ((GeeMap*) _tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = _tmp3_;
		_tmp5_ = gee_iterable_iterator ((GeeIterable*) _tmp4_);
		_tmp6_ = _tmp5_;
		_g_object_unref0 (_tmp4_);
		_key_it = _tmp6_;
		while (TRUE) {
			GeeIterator* _tmp7_ = NULL;
			gboolean _tmp8_ = FALSE;
			gint key = 0;
			GeeIterator* _tmp9_ = NULL;
			gpointer _tmp10_ = NULL;
			GeeTreeMap* _tmp11_ = NULL;
			gint _tmp12_ = 0;
			GeeHashMap* _tmp13_ = NULL;
			gint _tmp14_ = 0;
			gpointer _tmp15_ = NULL;
			GeeHashSet* _tmp16_ = NULL;
			_tmp7_ = _key_it;
			_tmp8_ = gee_iterator_next (_tmp7_);
			if (!_tmp8_) {
				break;
			}
			_tmp9_ = _key_it;
			_tmp10_ = gee_iterator_get (_tmp9_);
			key = (gint) ((gintptr) _tmp10_);
			_tmp11_ = sortedMap;
			_tmp12_ = key;
			_tmp13_ = map;
			_tmp14_ = key;
			_tmp15_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp13_, (gpointer) ((gintptr) _tmp14_));
			_tmp16_ = (GeeHashSet*) _tmp15_;
			gee_abstract_map_set ((GeeAbstractMap*) _tmp11_, (gpointer) ((gintptr) _tmp12_), _tmp16_);
			_g_object_unref0 (_tmp16_);
		}
		_g_object_unref0 (_key_it);
	}
	_tmp17_ = map;
	_tmp18_ = gee_abstract_map_get_size ((GeeMap*) _tmp17_);
	_tmp19_ = _tmp18_;
	_tmp20_ = g_new0 (gint, _tmp19_);
	array = _tmp20_;
	array_length1 = _tmp19_;
	_array_size_ = array_length1;
	p = 0;
	{
		GeeIterator* _i_it = NULL;
		GeeTreeMap* _tmp21_ = NULL;
		GeeSet* _tmp22_ = NULL;
		GeeSet* _tmp23_ = NULL;
		GeeSet* _tmp24_ = NULL;
		GeeIterator* _tmp25_ = NULL;
		GeeIterator* _tmp26_ = NULL;
		_tmp21_ = sortedMap;
		_tmp22_ = gee_abstract_map_get_keys ((GeeMap*) _tmp21_);
		_tmp23_ = _tmp22_;
		_tmp24_ = _tmp23_;
		_tmp25_ = gee_iterable_iterator ((GeeIterable*) _tmp24_);
		_tmp26_ = _tmp25_;
		_g_object_unref0 (_tmp24_);
		_i_it = _tmp26_;
		while (TRUE) {
			GeeIterator* _tmp27_ = NULL;
			gboolean _tmp28_ = FALSE;
			gint i = 0;
			GeeIterator* _tmp29_ = NULL;
			gpointer _tmp30_ = NULL;
			gint* _tmp31_ = NULL;
			gint _tmp31__length1 = 0;
			gint _tmp32_ = 0;
			GeeTreeMap* _tmp33_ = NULL;
			gint _tmp34_ = 0;
			gpointer _tmp35_ = NULL;
			GeeHashSet* _tmp36_ = NULL;
			gint _tmp37_ = 0;
			gint _tmp38_ = 0;
			gint _tmp39_ = 0;
			gint _tmp40_ = 0;
			_tmp27_ = _i_it;
			_tmp28_ = gee_iterator_next (_tmp27_);
			if (!_tmp28_) {
				break;
			}
			_tmp29_ = _i_it;
			_tmp30_ = gee_iterator_get (_tmp29_);
			i = (gint) ((gintptr) _tmp30_);
			_tmp31_ = array;
			_tmp31__length1 = array_length1;
			_tmp32_ = p;
			_tmp33_ = sortedMap;
			_tmp34_ = i;
			_tmp35_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp33_, (gpointer) ((gintptr) _tmp34_));
			_tmp36_ = (GeeHashSet*) _tmp35_;
			_tmp37_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp36_);
			_tmp38_ = _tmp37_;
			_tmp31_[_tmp32_] = _tmp38_;
			_tmp39_ = _tmp31_[_tmp32_];
			_g_object_unref0 (_tmp36_);
			_tmp40_ = p;
			p = _tmp40_ + 1;
		}
		_g_object_unref0 (_i_it);
	}
	_tmp41_ = array;
	_tmp41__length1 = array_length1;
	if (result_length1) {
		*result_length1 = _tmp41__length1;
	}
	result = _tmp41_;
	_g_object_unref0 (sortedMap);
	return result;
}


static gfloat difficulty_rating_calculate (DifficultyRating* self) {
	gfloat result = 0.0F;
	gfloat _tmp0_ = 0.0F;
	gint _tmp1_ = 0;
	gfloat _tmp2_ = 0.0F;
	gint _tmp3_ = 0;
	GuessList* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	g_return_val_if_fail (self != NULL, 0.0F);
	_tmp0_ = self->priv->fillable_ease;
	_tmp1_ = self->priv->squares_filled;
	_tmp2_ = self->priv->elimination_ease;
	_tmp3_ = self->priv->squares_filled;
	_tmp4_ = self->priv->guesses;
	_tmp5_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = self->priv->squares_filled;
	_tmp8_ = self->priv->backtraces;
	_tmp9_ = self->priv->squares_filled;
	result = (((1 - (((gfloat) _tmp0_) / _tmp1_)) - (((gfloat) _tmp2_) / _tmp3_)) + (_tmp6_ / _tmp7_)) + (_tmp8_ / _tmp9_);
	return result;
}


static gint difficulty_rating_diminsh_by_one (gint a) {
	gint result = 0;
	gint _tmp0_ = 0;
	_tmp0_ = a;
	result = _tmp0_ + 1;
	return result;
}


gboolean difficulty_rating_in_range (DifficultyRating* self, gfloat* range, int range_length1) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gfloat _tmp1_ = 0.0F;
	gfloat* _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	gfloat _tmp3_ = 0.0F;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->rating;
	_tmp2_ = range;
	_tmp2__length1 = range_length1;
	_tmp3_ = _tmp2_[0];
	if (_tmp1_ >= _tmp3_) {
		gfloat _tmp4_ = 0.0F;
		gfloat* _tmp5_ = NULL;
		gint _tmp5__length1 = 0;
		gfloat _tmp6_ = 0.0F;
		_tmp4_ = self->rating;
		_tmp5_ = range;
		_tmp5__length1 = range_length1;
		_tmp6_ = _tmp5_[1];
		_tmp0_ = _tmp4_ < _tmp6_;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


DifficultyCategory difficulty_rating_get_category (DifficultyRating* self) {
	DifficultyCategory result = 0;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = difficulty_rating_in_range (self, DIFFICULTY_RATING_EASY_RANGE, G_N_ELEMENTS (DIFFICULTY_RATING_EASY_RANGE));
	if (_tmp0_) {
		result = DIFFICULTY_CATEGORY_EASY;
		return result;
	} else {
		gboolean _tmp1_ = FALSE;
		_tmp1_ = difficulty_rating_in_range (self, DIFFICULTY_RATING_MEDIUM_RANGE, G_N_ELEMENTS (DIFFICULTY_RATING_MEDIUM_RANGE));
		if (_tmp1_) {
			result = DIFFICULTY_CATEGORY_MEDIUM;
			return result;
		} else {
			gboolean _tmp2_ = FALSE;
			_tmp2_ = difficulty_rating_in_range (self, DIFFICULTY_RATING_HARD_RANGE, G_N_ELEMENTS (DIFFICULTY_RATING_HARD_RANGE));
			if (_tmp2_) {
				result = DIFFICULTY_CATEGORY_HARD;
				return result;
			} else {
				gboolean _tmp3_ = FALSE;
				_tmp3_ = difficulty_rating_in_range (self, DIFFICULTY_RATING_VERY_HARD_RANGE, G_N_ELEMENTS (DIFFICULTY_RATING_VERY_HARD_RANGE));
				if (_tmp3_) {
					result = DIFFICULTY_CATEGORY_VERY_HARD;
					return result;
				} else {
					g_assert_not_reached ();
				}
			}
		}
	}
}


static gfloat difficulty_rating_add_with_diminishing_importance (gint* array, int array_length1, DifficultyRatingDiminshBy diminish_by, void* diminish_by_target) {
	gfloat result = 0.0F;
	gfloat sum = 0.0F;
	sum = (gfloat) 0;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				gint* _tmp3_ = NULL;
				gint _tmp3__length1 = 0;
				gfloat _tmp4_ = 0.0F;
				gint* _tmp5_ = NULL;
				gint _tmp5__length1 = 0;
				gint _tmp6_ = 0;
				gint _tmp7_ = 0;
				DifficultyRatingDiminshBy _tmp8_ = NULL;
				void* _tmp8__target = NULL;
				gint _tmp9_ = 0;
				gint _tmp10_ = 0;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = array;
				_tmp3__length1 = array_length1;
				if (!(_tmp2_ < _tmp3__length1)) {
					break;
				}
				_tmp4_ = sum;
				_tmp5_ = array;
				_tmp5__length1 = array_length1;
				_tmp6_ = i;
				_tmp7_ = _tmp5_[_tmp6_];
				_tmp8_ = diminish_by;
				_tmp8__target = diminish_by_target;
				_tmp9_ = i;
				_tmp10_ = _tmp8_ (_tmp9_, _tmp8__target);
				sum = _tmp4_ + (((gfloat) _tmp7_) / _tmp10_);
			}
		}
	}
	result = sum;
	return result;
}


gchar* difficulty_rating_to_string (DifficultyRating* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gfloat _tmp3_ = 0.0F;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	gfloat _tmp9_ = 0.0F;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	gfloat _tmp15_ = 0.0F;
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	const gchar* _tmp19_ = NULL;
	const gchar* _tmp20_ = NULL;
	gfloat _tmp21_ = 0.0F;
	gchar* _tmp22_ = NULL;
	gchar* _tmp23_ = NULL;
	gchar* _tmp24_ = NULL;
	const gchar* _tmp25_ = NULL;
	const gchar* _tmp26_ = NULL;
	GuessList* _tmp27_ = NULL;
	gint _tmp28_ = 0;
	gint _tmp29_ = 0;
	gchar* _tmp30_ = NULL;
	gchar* _tmp31_ = NULL;
	gchar* _tmp32_ = NULL;
	const gchar* _tmp33_ = NULL;
	const gchar* _tmp34_ = NULL;
	gint _tmp35_ = 0;
	gchar* _tmp36_ = NULL;
	gchar* _tmp37_ = NULL;
	gchar* _tmp38_ = NULL;
	const gchar* _tmp39_ = NULL;
	const gchar* _tmp40_ = NULL;
	gfloat _tmp41_ = 0.0F;
	gchar* _tmp42_ = NULL;
	gchar* _tmp43_ = NULL;
	gchar* _tmp44_ = NULL;
	const gchar* _tmp45_ = NULL;
	const gchar* _tmp46_ = NULL;
	gfloat _tmp47_ = 0.0F;
	gchar* _tmp48_ = NULL;
	gchar* _tmp49_ = NULL;
	gchar* _tmp50_ = NULL;
	const gchar* _tmp51_ = NULL;
	const gchar* _tmp52_ = NULL;
	gfloat _tmp53_ = 0.0F;
	gchar* _tmp54_ = NULL;
	gchar* _tmp55_ = NULL;
	gchar* _tmp56_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup ("");
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	_tmp2_ = _ ("Number of moves instantly fillable by elimination:");
	_tmp3_ = self->priv->instant_elimination_fillable;
	_tmp4_ = g_strdup_printf ("%s %f\n", _tmp2_, (gdouble) _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strconcat (_tmp1_, _tmp5_, NULL);
	_g_free0 (_result_);
	_result_ = _tmp6_;
	_g_free0 (_tmp5_);
	_tmp7_ = _result_;
	_tmp8_ = _ ("Percentage of moves instantly fillable by elimination:");
	_tmp9_ = self->priv->proportion_instant_elimination_fillable;
	_tmp10_ = g_strdup_printf ("%s %f\n", _tmp8_, (gdouble) (_tmp9_ * 100));
	_tmp11_ = _tmp10_;
	_tmp12_ = g_strconcat (_tmp7_, _tmp11_, NULL);
	_g_free0 (_result_);
	_result_ = _tmp12_;
	_g_free0 (_tmp11_);
	_tmp13_ = _result_;
	_tmp14_ = _ ("Number of moves instantly fillable by filling:");
	_tmp15_ = self->priv->instant_fill_fillable;
	_tmp16_ = g_strdup_printf ("%s %f\n", _tmp14_, (gdouble) _tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = g_strconcat (_tmp13_, _tmp17_, NULL);
	_g_free0 (_result_);
	_result_ = _tmp18_;
	_g_free0 (_tmp17_);
	_tmp19_ = _result_;
	_tmp20_ = _ ("Percentage of moves instantly fillable by filling:");
	_tmp21_ = self->priv->proportion_instant_fill_fillable;
	_tmp22_ = g_strdup_printf ("%s %f\n", _tmp20_, (gdouble) (_tmp21_ * 100));
	_tmp23_ = _tmp22_;
	_tmp24_ = g_strconcat (_tmp19_, _tmp23_, NULL);
	_g_free0 (_result_);
	_result_ = _tmp24_;
	_g_free0 (_tmp23_);
	_tmp25_ = _result_;
	_tmp26_ = _ ("Number of guesses made:");
	_tmp27_ = self->priv->guesses;
	_tmp28_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp27_);
	_tmp29_ = _tmp28_;
	_tmp30_ = g_strdup_printf ("%s %d\n", _tmp26_, _tmp29_);
	_tmp31_ = _tmp30_;
	_tmp32_ = g_strconcat (_tmp25_, _tmp31_, NULL);
	_g_free0 (_result_);
	_result_ = _tmp32_;
	_g_free0 (_tmp31_);
	_tmp33_ = _result_;
	_tmp34_ = _ ("Number of backtraces:");
	_tmp35_ = self->priv->backtraces;
	_tmp36_ = g_strdup_printf ("%s %d\n", _tmp34_, _tmp35_);
	_tmp37_ = _tmp36_;
	_tmp38_ = g_strconcat (_tmp33_, _tmp37_, NULL);
	_g_free0 (_result_);
	_result_ = _tmp38_;
	_g_free0 (_tmp37_);
	_tmp39_ = _result_;
	_tmp40_ = _ ("Ease by filling:");
	_tmp41_ = self->priv->fillable_ease;
	_tmp42_ = g_strdup_printf ("%s %f\n", _tmp40_, (gdouble) _tmp41_);
	_tmp43_ = _tmp42_;
	_tmp44_ = g_strconcat (_tmp39_, _tmp43_, NULL);
	_g_free0 (_result_);
	_result_ = _tmp44_;
	_g_free0 (_tmp43_);
	_tmp45_ = _result_;
	_tmp46_ = _ ("Ease by elimination:");
	_tmp47_ = self->priv->elimination_ease;
	_tmp48_ = g_strdup_printf ("%s %f\n", _tmp46_, (gdouble) _tmp47_);
	_tmp49_ = _tmp48_;
	_tmp50_ = g_strconcat (_tmp45_, _tmp49_, NULL);
	_g_free0 (_result_);
	_result_ = _tmp50_;
	_g_free0 (_tmp49_);
	_tmp51_ = _result_;
	_tmp52_ = _ ("Calculated difficulty:");
	_tmp53_ = self->rating;
	_tmp54_ = g_strdup_printf ("%s %f", _tmp52_, (gdouble) _tmp53_);
	_tmp55_ = _tmp54_;
	_tmp56_ = g_strconcat (_tmp51_, _tmp55_, NULL);
	_g_free0 (_result_);
	_result_ = _tmp56_;
	_g_free0 (_tmp55_);
	result = _result_;
	return result;
}


static void value_difficulty_rating_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_difficulty_rating_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		difficulty_rating_unref (value->data[0].v_pointer);
	}
}


static void value_difficulty_rating_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = difficulty_rating_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_difficulty_rating_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_difficulty_rating_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		DifficultyRating* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = difficulty_rating_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_difficulty_rating_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	DifficultyRating** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = difficulty_rating_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_difficulty_rating (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecDifficultyRating* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_DIFFICULTY_RATING), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_difficulty_rating (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_DIFFICULTY_RATING), NULL);
	return value->data[0].v_pointer;
}


void value_set_difficulty_rating (GValue* value, gpointer v_object) {
	DifficultyRating* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_DIFFICULTY_RATING));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_DIFFICULTY_RATING));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		difficulty_rating_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		difficulty_rating_unref (old);
	}
}


void value_take_difficulty_rating (GValue* value, gpointer v_object) {
	DifficultyRating* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_DIFFICULTY_RATING));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_DIFFICULTY_RATING));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		difficulty_rating_unref (old);
	}
}


static void difficulty_rating_class_init (DifficultyRatingClass * klass) {
	difficulty_rating_parent_class = g_type_class_peek_parent (klass);
	DIFFICULTY_RATING_CLASS (klass)->finalize = difficulty_rating_finalize;
	g_type_class_add_private (klass, sizeof (DifficultyRatingPrivate));
}


static void difficulty_rating_instance_init (DifficultyRating * self) {
	self->priv = DIFFICULTY_RATING_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void difficulty_rating_finalize (DifficultyRating* obj) {
	DifficultyRating * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DIFFICULTY_RATING, DifficultyRating);
	_g_object_unref0 (self->priv->fill_must_fillables);
	_g_object_unref0 (self->priv->elimination_fillables);
	_g_object_unref0 (self->priv->guesses);
}


GType difficulty_rating_get_type (void) {
	static volatile gsize difficulty_rating_type_id__volatile = 0;
	if (g_once_init_enter (&difficulty_rating_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_difficulty_rating_init, value_difficulty_rating_free_value, value_difficulty_rating_copy_value, value_difficulty_rating_peek_pointer, "p", value_difficulty_rating_collect_value, "p", value_difficulty_rating_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (DifficultyRatingClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) difficulty_rating_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DifficultyRating), 0, (GInstanceInitFunc) difficulty_rating_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType difficulty_rating_type_id;
		difficulty_rating_type_id = g_type_register_fundamental (g_type_fundamental_next (), "DifficultyRating", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&difficulty_rating_type_id__volatile, difficulty_rating_type_id);
	}
	return difficulty_rating_type_id__volatile;
}


gpointer difficulty_rating_ref (gpointer instance) {
	DifficultyRating* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void difficulty_rating_unref (gpointer instance) {
	DifficultyRating* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		DIFFICULTY_RATING_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



