/* sudoku-saver.c generated by valac 0.24.0.88-5dc64, the Vala compiler
 * generated from sudoku-saver.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gstdio.h>
#include <json-glib/json-glib.h>
#include <float.h>
#include <math.h>
#include <gee.h>
#include <gobject/gvaluecollector.h>


#define TYPE_SUDOKU_SAVER (sudoku_saver_get_type ())
#define SUDOKU_SAVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_SAVER, SudokuSaver))
#define SUDOKU_SAVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_SAVER, SudokuSaverClass))
#define IS_SUDOKU_SAVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_SAVER))
#define IS_SUDOKU_SAVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_SAVER))
#define SUDOKU_SAVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_SAVER, SudokuSaverClass))

typedef struct _SudokuSaver SudokuSaver;
typedef struct _SudokuSaverClass SudokuSaverClass;
typedef struct _SudokuSaverPrivate SudokuSaverPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_SUDOKU_GAME (sudoku_game_get_type ())
#define SUDOKU_GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_GAME, SudokuGame))
#define SUDOKU_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_GAME, SudokuGameClass))
#define IS_SUDOKU_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_GAME))
#define IS_SUDOKU_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_GAME))
#define SUDOKU_GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_GAME, SudokuGameClass))

typedef struct _SudokuGame SudokuGame;
typedef struct _SudokuGameClass SudokuGameClass;
typedef struct _SudokuGamePrivate SudokuGamePrivate;

#define TYPE_SUDOKU_BOARD (sudoku_board_get_type ())
#define SUDOKU_BOARD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_BOARD, SudokuBoard))
#define SUDOKU_BOARD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_BOARD, SudokuBoardClass))
#define IS_SUDOKU_BOARD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_BOARD))
#define IS_SUDOKU_BOARD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_BOARD))
#define SUDOKU_BOARD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_BOARD, SudokuBoardClass))

typedef struct _SudokuBoard SudokuBoard;
typedef struct _SudokuBoardClass SudokuBoardClass;

#define TYPE_DIFFICULTY_CATEGORY (difficulty_category_get_type ())
typedef struct _SudokuBoardPrivate SudokuBoardPrivate;

#define TYPE_COORD (coord_get_type ())
typedef struct _Coord Coord;
#define __vala_JsonNode_free0(var) ((var == NULL) ? NULL : (var = (_vala_JsonNode_free (var), NULL)))
#define _sudoku_board_unref0(var) ((var == NULL) ? NULL : (var = (sudoku_board_unref (var), NULL)))
typedef struct _ParamSpecSudokuSaver ParamSpecSudokuSaver;

struct _SudokuSaver {
	GTypeInstance parent_instance;
	volatile int ref_count;
	SudokuSaverPrivate * priv;
};

struct _SudokuSaverClass {
	GTypeClass parent_class;
	void (*finalize) (SudokuSaver *self);
};

struct _SudokuGame {
	GTypeInstance parent_instance;
	volatile int ref_count;
	SudokuGamePrivate * priv;
	SudokuBoard* board;
	GTimer* timer;
};

struct _SudokuGameClass {
	GTypeClass parent_class;
	void (*finalize) (SudokuGame *self);
};

typedef enum  {
	DIFFICULTY_CATEGORY_EASY,
	DIFFICULTY_CATEGORY_MEDIUM,
	DIFFICULTY_CATEGORY_HARD,
	DIFFICULTY_CATEGORY_VERY_HARD
} DifficultyCategory;

struct _Coord {
	gint row;
	gint col;
};

struct _SudokuBoard {
	GTypeInstance parent_instance;
	volatile int ref_count;
	SudokuBoardPrivate * priv;
	gint* cells;
	gint cells_length1;
	gint cells_length2;
	gboolean* is_fixed;
	gint is_fixed_length1;
	gint is_fixed_length2;
	gboolean* earmarks;
	gint earmarks_length1;
	gint earmarks_length2;
	gint earmarks_length3;
	GeeSet* broken_coords;
	GeeList* coords_for_col;
	GeeList* coords_for_row;
	GeeMap* coords_for_block;
};

struct _SudokuBoardClass {
	GTypeClass parent_class;
	void (*finalize) (SudokuBoard *self);
};

struct _ParamSpecSudokuSaver {
	GParamSpec parent_instance;
};


static gpointer sudoku_saver_parent_class = NULL;
static gchar* sudoku_saver__savegame_file;
static gchar* sudoku_saver__savegame_file = NULL;
static gchar* sudoku_saver__finishgame_dir;
static gchar* sudoku_saver__finishgame_dir = NULL;

gpointer sudoku_saver_ref (gpointer instance);
void sudoku_saver_unref (gpointer instance);
GParamSpec* param_spec_sudoku_saver (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_sudoku_saver (GValue* value, gpointer v_object);
void value_take_sudoku_saver (GValue* value, gpointer v_object);
gpointer value_get_sudoku_saver (const GValue* value);
GType sudoku_saver_get_type (void) G_GNUC_CONST;
enum  {
	SUDOKU_SAVER_DUMMY_PROPERTY
};
SudokuSaver* sudoku_saver_new (void);
SudokuSaver* sudoku_saver_construct (GType object_type);
const gchar* sudoku_saver_get_savegame_file (void);
static void sudoku_saver_set_savegame_file (const gchar* value);
const gchar* sudoku_saver_get_finishgame_dir (void);
static void sudoku_saver_set_finishgame_dir (const gchar* value);
gpointer sudoku_game_ref (gpointer instance);
void sudoku_game_unref (gpointer instance);
GParamSpec* param_spec_sudoku_game (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_sudoku_game (GValue* value, gpointer v_object);
void value_take_sudoku_game (GValue* value, gpointer v_object);
gpointer value_get_sudoku_game (const GValue* value);
GType sudoku_game_get_type (void) G_GNUC_CONST;
SudokuGame* sudoku_saver_get_savedgame (SudokuSaver* self);
static SudokuGame* sudoku_saver_parse_json_to_game (SudokuSaver* self, const gchar* file_path);
void sudoku_saver_save_game (SudokuSaver* self, SudokuGame* game);
static void sudoku_saver_create_file_for_game (SudokuSaver* self, SudokuGame* game, const gchar* file_name);
void sudoku_saver_add_game_to_finished (SudokuSaver* self, SudokuGame* game, gboolean delete_savegame);
gpointer sudoku_board_ref (gpointer instance);
void sudoku_board_unref (gpointer instance);
GParamSpec* param_spec_sudoku_board (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_sudoku_board (GValue* value, gpointer v_object);
void value_take_sudoku_board (GValue* value, gpointer v_object);
gpointer value_get_sudoku_board (const GValue* value);
GType sudoku_board_get_type (void) G_GNUC_CONST;
gchar* sudoku_board_to_string (SudokuBoard* self, gboolean get_original_state);
static gchar* sudoku_saver_serialize_game_to_json (SudokuSaver* self, SudokuGame* game);
gint* sudoku_board_get_cells (SudokuBoard* self, int* result_length1, int* result_length2);
gdouble sudoku_board_get_difficulty_rating (SudokuBoard* self);
GType difficulty_category_get_type (void) G_GNUC_CONST;
DifficultyCategory sudoku_board_get_difficulty_category (SudokuBoard* self);
gchar* difficulty_category_to_string (DifficultyCategory self);
gdouble sudoku_game_get_total_time_played (SudokuGame* self);
gint sudoku_board_get_rows (SudokuBoard* self);
gint sudoku_board_get_cols (SudokuBoard* self);
gint sudoku_board_get_max_val (SudokuBoard* self);
GType coord_get_type (void) G_GNUC_CONST;
Coord* coord_dup (const Coord* self);
void coord_free (Coord* self);
static void _vala_array_add9 (gint** array, int* length, int* size, gint value);
static void _vala_JsonNode_free (JsonNode* self);
SudokuBoard* sudoku_board_new (gint block_rows, gint block_cols);
SudokuBoard* sudoku_board_construct (GType object_type, gint block_rows, gint block_cols);
static JsonNode* _vala_JsonNode_copy (JsonNode* self);
void sudoku_board_insert (SudokuBoard* self, gint row, gint col, gint val, gboolean is_fixed);
void sudoku_board_set_previous_played_time (SudokuBoard* self, gdouble value);
SudokuGame* sudoku_game_new (SudokuBoard* board);
SudokuGame* sudoku_game_construct (GType object_type, SudokuBoard* board);
static void sudoku_saver_finalize (SudokuSaver* obj);


SudokuSaver* sudoku_saver_construct (GType object_type) {
	SudokuSaver* self = NULL;
	GError * _inner_error_ = NULL;
	self = (SudokuSaver*) g_type_create_instance (object_type);
	{
		gchar* config_dir = NULL;
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* sudoku_data_dir = NULL;
		const gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		_tmp0_ = g_get_user_data_dir ();
		_tmp1_ = g_strdup (_tmp0_);
		config_dir = _tmp1_;
		_tmp2_ = config_dir;
		_tmp3_ = g_build_path (G_DIR_SEPARATOR_S, _tmp2_, "gnome-sudoku", NULL);
		sudoku_data_dir = _tmp3_;
		_tmp4_ = sudoku_saver_get_savegame_file ();
		_tmp5_ = _tmp4_;
		_tmp6_ = sudoku_data_dir;
		_tmp7_ = g_build_path (G_DIR_SEPARATOR_S, _tmp6_, "savefile", NULL);
		_tmp8_ = _tmp7_;
		sudoku_saver_set_savegame_file (_tmp8_);
		_g_free0 (_tmp8_);
		_tmp9_ = sudoku_saver_get_finishgame_dir ();
		_tmp10_ = _tmp9_;
		_tmp11_ = sudoku_data_dir;
		_tmp12_ = g_build_path (G_DIR_SEPARATOR_S, _tmp11_, "finished", NULL);
		_tmp13_ = _tmp12_;
		sudoku_saver_set_finishgame_dir (_tmp13_);
		_g_free0 (_tmp13_);
		{
			GFile* file = NULL;
			const gchar* _tmp14_ = NULL;
			GFile* _tmp15_ = NULL;
			GFile* _tmp16_ = NULL;
			gboolean _tmp17_ = FALSE;
			const gchar* _tmp19_ = NULL;
			const gchar* _tmp20_ = NULL;
			GFile* _tmp21_ = NULL;
			GFile* _tmp22_ = NULL;
			gboolean _tmp23_ = FALSE;
			_tmp14_ = sudoku_data_dir;
			_tmp15_ = g_file_new_for_path (_tmp14_);
			file = _tmp15_;
			_tmp16_ = file;
			_tmp17_ = g_file_query_exists (_tmp16_, NULL);
			if (!_tmp17_) {
				GFile* _tmp18_ = NULL;
				_tmp18_ = file;
				g_file_make_directory (_tmp18_, NULL, &_inner_error_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					_g_object_unref0 (file);
					_g_free0 (sudoku_data_dir);
					_g_free0 (config_dir);
					goto __catch10_g_error;
				}
			}
			_tmp19_ = sudoku_saver_get_finishgame_dir ();
			_tmp20_ = _tmp19_;
			_tmp21_ = g_file_new_for_path (_tmp20_);
			_g_object_unref0 (file);
			file = _tmp21_;
			_tmp22_ = file;
			_tmp23_ = g_file_query_exists (_tmp22_, NULL);
			if (!_tmp23_) {
				GFile* _tmp24_ = NULL;
				_tmp24_ = file;
				g_file_make_directory (_tmp24_, NULL, &_inner_error_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					_g_object_unref0 (file);
					_g_free0 (sudoku_data_dir);
					_g_free0 (config_dir);
					goto __catch10_g_error;
				}
			}
			_g_object_unref0 (file);
		}
		_g_free0 (sudoku_data_dir);
		_g_free0 (config_dir);
	}
	goto __finally10;
	__catch10_g_error:
	{
		GError* e = NULL;
		GError* _tmp25_ = NULL;
		const gchar* _tmp26_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp25_ = e;
		_tmp26_ = _tmp25_->message;
		g_warning ("sudoku-saver.vala:28: %s", _tmp26_);
		_g_error_free0 (e);
	}
	__finally10:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	return self;
}


SudokuSaver* sudoku_saver_new (void) {
	return sudoku_saver_construct (TYPE_SUDOKU_SAVER);
}


SudokuGame* sudoku_saver_get_savedgame (SudokuSaver* self) {
	SudokuGame* result = NULL;
	GFile* file = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	GFile* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	SudokuGame* _tmp7_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = sudoku_saver_get_savegame_file ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_file_new_for_path (_tmp1_);
	file = _tmp2_;
	_tmp3_ = file;
	_tmp4_ = g_file_query_exists (_tmp3_, NULL);
	if (!_tmp4_) {
		result = NULL;
		_g_object_unref0 (file);
		return result;
	}
	_tmp5_ = sudoku_saver_get_savegame_file ();
	_tmp6_ = _tmp5_;
	_tmp7_ = sudoku_saver_parse_json_to_game (self, _tmp6_);
	result = _tmp7_;
	_g_object_unref0 (file);
	return result;
}


void sudoku_saver_save_game (SudokuSaver* self, SudokuGame* game) {
	SudokuGame* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (game != NULL);
	_tmp0_ = game;
	_tmp1_ = sudoku_saver_get_savegame_file ();
	_tmp2_ = _tmp1_;
	sudoku_saver_create_file_for_game (self, _tmp0_, _tmp2_);
}


void sudoku_saver_add_game_to_finished (SudokuSaver* self, SudokuGame* game, gboolean delete_savegame) {
	gchar* file_name = NULL;
	SudokuGame* _tmp0_ = NULL;
	SudokuBoard* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* file_path = NULL;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	SudokuGame* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	gboolean _tmp12_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (game != NULL);
	_tmp0_ = game;
	_tmp1_ = _tmp0_->board;
	_tmp2_ = sudoku_board_to_string (_tmp1_, TRUE);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat (_tmp3_, ".save", NULL);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	file_name = _tmp5_;
	_tmp6_ = sudoku_saver_get_finishgame_dir ();
	_tmp7_ = _tmp6_;
	_tmp8_ = file_name;
	_tmp9_ = g_build_path (G_DIR_SEPARATOR_S, _tmp7_, _tmp8_, NULL);
	file_path = _tmp9_;
	_tmp10_ = game;
	_tmp11_ = file_path;
	sudoku_saver_create_file_for_game (self, _tmp10_, _tmp11_);
	_tmp12_ = delete_savegame;
	if (_tmp12_) {
		GFile* file = NULL;
		const gchar* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		GFile* _tmp15_ = NULL;
		GFile* _tmp16_ = NULL;
		gboolean _tmp17_ = FALSE;
		_tmp13_ = sudoku_saver_get_savegame_file ();
		_tmp14_ = _tmp13_;
		_tmp15_ = g_file_new_for_path (_tmp14_);
		file = _tmp15_;
		_tmp16_ = file;
		_tmp17_ = g_file_query_exists (_tmp16_, NULL);
		if (_tmp17_) {
			{
				GFile* _tmp18_ = NULL;
				_tmp18_ = file;
				g_file_delete (_tmp18_, NULL, &_inner_error_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					goto __catch11_g_error;
				}
			}
			goto __finally11;
			__catch11_g_error:
			{
				GError* e = NULL;
				GFile* _tmp19_ = NULL;
				gchar* _tmp20_ = NULL;
				gchar* _tmp21_ = NULL;
				GError* _tmp22_ = NULL;
				const gchar* _tmp23_ = NULL;
				e = _inner_error_;
				_inner_error_ = NULL;
				_tmp19_ = file;
				_tmp20_ = g_file_get_uri (_tmp19_);
				_tmp21_ = _tmp20_;
				_tmp22_ = e;
				_tmp23_ = _tmp22_->message;
				g_warning ("sudoku-saver.vala:64: Failed to delete %s: %s", _tmp21_, _tmp23_);
				_g_free0 (_tmp21_);
				_g_error_free0 (e);
			}
			__finally11:
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_g_object_unref0 (file);
				_g_free0 (file_path);
				_g_free0 (file_name);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_g_object_unref0 (file);
	}
	_g_free0 (file_path);
	_g_free0 (file_name);
}


static void sudoku_saver_create_file_for_game (SudokuSaver* self, SudokuGame* game, const gchar* file_name) {
	gchar* json_str = NULL;
	SudokuGame* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (game != NULL);
	g_return_if_fail (file_name != NULL);
	_tmp0_ = game;
	_tmp1_ = sudoku_saver_serialize_game_to_json (self, _tmp0_);
	json_str = _tmp1_;
	{
		const gchar* _tmp2_ = NULL;
		_tmp2_ = file_name;
		g_file_set_contents (_tmp2_, json_str, (gssize) (-1), &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch12_g_error;
		}
	}
	goto __finally12;
	__catch12_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_warning ("sudoku-saver.vala:77: %s", _tmp4_);
		_g_error_free0 (e);
	}
	__finally12:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (json_str);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (json_str);
}


static gpointer _sudoku_board_ref0 (gpointer self) {
	return self ? sudoku_board_ref (self) : NULL;
}


static void _vala_array_add9 (gint** array, int* length, int* size, gint value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gint, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void _vala_JsonNode_free (JsonNode* self) {
	g_boxed_free (json_node_get_type (), self);
}


static gchar* sudoku_saver_serialize_game_to_json (SudokuSaver* self, SudokuGame* game) {
	gchar* result = NULL;
	SudokuBoard* board = NULL;
	SudokuGame* _tmp0_ = NULL;
	SudokuBoard* _tmp1_ = NULL;
	SudokuBoard* _tmp2_ = NULL;
	gint* board_cells = NULL;
	SudokuBoard* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gint* _tmp6_ = NULL;
	gint board_cells_length1 = 0;
	gint board_cells_length2 = 0;
	JsonBuilder* builder = NULL;
	JsonBuilder* _tmp7_ = NULL;
	JsonBuilder* _tmp8_ = NULL;
	JsonBuilder* _tmp9_ = NULL;
	JsonBuilder* _tmp10_ = NULL;
	SudokuBoard* _tmp11_ = NULL;
	gdouble _tmp12_ = 0.0;
	gdouble _tmp13_ = 0.0;
	JsonBuilder* _tmp14_ = NULL;
	JsonBuilder* _tmp15_ = NULL;
	SudokuBoard* _tmp16_ = NULL;
	DifficultyCategory _tmp17_ = 0;
	gchar* _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
	JsonBuilder* _tmp20_ = NULL;
	JsonBuilder* _tmp21_ = NULL;
	SudokuGame* _tmp22_ = NULL;
	gdouble _tmp23_ = 0.0;
	JsonBuilder* _tmp24_ = NULL;
	JsonBuilder* _tmp25_ = NULL;
	JsonBuilder* _tmp87_ = NULL;
	JsonBuilder* _tmp88_ = NULL;
	JsonGenerator* generator = NULL;
	JsonGenerator* _tmp89_ = NULL;
	JsonNode* root = NULL;
	JsonBuilder* _tmp90_ = NULL;
	JsonNode* _tmp91_ = NULL;
	gchar* _tmp92_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (game != NULL, NULL);
	_tmp0_ = game;
	_tmp1_ = _tmp0_->board;
	_tmp2_ = _sudoku_board_ref0 (_tmp1_);
	board = _tmp2_;
	_tmp3_ = board;
	_tmp6_ = sudoku_board_get_cells (_tmp3_, &_tmp4_, &_tmp5_);
	board_cells = _tmp6_;
	board_cells_length1 = _tmp4_;
	board_cells_length2 = _tmp5_;
	_tmp7_ = json_builder_new ();
	builder = _tmp7_;
	_tmp8_ = builder;
	json_builder_begin_object (_tmp8_);
	_tmp9_ = builder;
	json_builder_set_member_name (_tmp9_, "difficulty_rating");
	_tmp10_ = builder;
	_tmp11_ = board;
	_tmp12_ = sudoku_board_get_difficulty_rating (_tmp11_);
	_tmp13_ = _tmp12_;
	json_builder_add_double_value (_tmp10_, _tmp13_);
	_tmp14_ = builder;
	json_builder_set_member_name (_tmp14_, "difficulty_category");
	_tmp15_ = builder;
	_tmp16_ = board;
	_tmp17_ = sudoku_board_get_difficulty_category (_tmp16_);
	_tmp18_ = difficulty_category_to_string (_tmp17_);
	_tmp19_ = _tmp18_;
	json_builder_add_string_value (_tmp15_, _tmp19_);
	_g_free0 (_tmp19_);
	_tmp20_ = builder;
	json_builder_set_member_name (_tmp20_, "time_elapsed");
	_tmp21_ = builder;
	_tmp22_ = game;
	_tmp23_ = sudoku_game_get_total_time_played (_tmp22_);
	json_builder_add_double_value (_tmp21_, _tmp23_);
	_tmp24_ = builder;
	json_builder_set_member_name (_tmp24_, "cells");
	_tmp25_ = builder;
	json_builder_begin_array (_tmp25_);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp26_ = FALSE;
			_tmp26_ = TRUE;
			while (TRUE) {
				gint _tmp28_ = 0;
				SudokuBoard* _tmp29_ = NULL;
				gint _tmp30_ = 0;
				gint _tmp31_ = 0;
				if (!_tmp26_) {
					gint _tmp27_ = 0;
					_tmp27_ = i;
					i = _tmp27_ + 1;
				}
				_tmp26_ = FALSE;
				_tmp28_ = i;
				_tmp29_ = board;
				_tmp30_ = sudoku_board_get_rows (_tmp29_);
				_tmp31_ = _tmp30_;
				if (!(_tmp28_ < _tmp31_)) {
					break;
				}
				{
					gint j = 0;
					j = 0;
					{
						gboolean _tmp32_ = FALSE;
						_tmp32_ = TRUE;
						while (TRUE) {
							gint _tmp34_ = 0;
							SudokuBoard* _tmp35_ = NULL;
							gint _tmp36_ = 0;
							gint _tmp37_ = 0;
							gint* earmarks = NULL;
							gint* _tmp38_ = NULL;
							gint earmarks_length1 = 0;
							gint _earmarks_size_ = 0;
							gboolean _tmp53_ = FALSE;
							gint* _tmp54_ = NULL;
							gint _tmp54__length1 = 0;
							gint _tmp54__length2 = 0;
							gint _tmp55_ = 0;
							gint _tmp56_ = 0;
							gint _tmp57_ = 0;
							JsonBuilder* _tmp59_ = NULL;
							JsonBuilder* _tmp60_ = NULL;
							JsonBuilder* _tmp61_ = NULL;
							JsonBuilder* _tmp62_ = NULL;
							gint _tmp63_ = 0;
							JsonBuilder* _tmp64_ = NULL;
							gint _tmp65_ = 0;
							JsonBuilder* _tmp66_ = NULL;
							JsonBuilder* _tmp67_ = NULL;
							JsonBuilder* _tmp68_ = NULL;
							gint* _tmp69_ = NULL;
							gint _tmp69__length1 = 0;
							gint _tmp69__length2 = 0;
							gint _tmp70_ = 0;
							gint _tmp71_ = 0;
							gint _tmp72_ = 0;
							JsonBuilder* _tmp73_ = NULL;
							JsonBuilder* _tmp74_ = NULL;
							SudokuBoard* _tmp75_ = NULL;
							gboolean* _tmp76_ = NULL;
							gint _tmp76__length1 = 0;
							gint _tmp76__length2 = 0;
							gint _tmp77_ = 0;
							gint _tmp78_ = 0;
							gboolean _tmp79_ = FALSE;
							JsonBuilder* _tmp80_ = NULL;
							JsonBuilder* _tmp81_ = NULL;
							gint* _tmp82_ = NULL;
							gint _tmp82__length1 = 0;
							JsonBuilder* _tmp85_ = NULL;
							JsonBuilder* _tmp86_ = NULL;
							if (!_tmp32_) {
								gint _tmp33_ = 0;
								_tmp33_ = j;
								j = _tmp33_ + 1;
							}
							_tmp32_ = FALSE;
							_tmp34_ = j;
							_tmp35_ = board;
							_tmp36_ = sudoku_board_get_cols (_tmp35_);
							_tmp37_ = _tmp36_;
							if (!(_tmp34_ < _tmp37_)) {
								break;
							}
							_tmp38_ = g_new0 (gint, 0);
							earmarks = _tmp38_;
							earmarks_length1 = 0;
							_earmarks_size_ = earmarks_length1;
							{
								gint k = 0;
								k = 0;
								{
									gboolean _tmp39_ = FALSE;
									_tmp39_ = TRUE;
									while (TRUE) {
										gint _tmp41_ = 0;
										SudokuBoard* _tmp42_ = NULL;
										gint _tmp43_ = 0;
										gint _tmp44_ = 0;
										SudokuBoard* _tmp45_ = NULL;
										gboolean* _tmp46_ = NULL;
										gint _tmp46__length1 = 0;
										gint _tmp46__length2 = 0;
										gint _tmp46__length3 = 0;
										gint _tmp47_ = 0;
										gint _tmp48_ = 0;
										gint _tmp49_ = 0;
										gboolean _tmp50_ = FALSE;
										if (!_tmp39_) {
											gint _tmp40_ = 0;
											_tmp40_ = k;
											k = _tmp40_ + 1;
										}
										_tmp39_ = FALSE;
										_tmp41_ = k;
										_tmp42_ = board;
										_tmp43_ = sudoku_board_get_max_val (_tmp42_);
										_tmp44_ = _tmp43_;
										if (!(_tmp41_ < _tmp44_)) {
											break;
										}
										_tmp45_ = board;
										_tmp46_ = _tmp45_->earmarks;
										_tmp46__length1 = _tmp45_->earmarks_length1;
										_tmp46__length2 = _tmp45_->earmarks_length2;
										_tmp46__length3 = _tmp45_->earmarks_length3;
										_tmp47_ = i;
										_tmp48_ = j;
										_tmp49_ = k;
										_tmp50_ = _tmp46_[(((_tmp47_ * _tmp46__length2) + _tmp48_) * _tmp46__length3) + _tmp49_];
										if (_tmp50_) {
											gint* _tmp51_ = NULL;
											gint _tmp51__length1 = 0;
											gint _tmp52_ = 0;
											_tmp51_ = earmarks;
											_tmp51__length1 = earmarks_length1;
											_tmp52_ = k;
											_vala_array_add9 (&earmarks, &earmarks_length1, &_earmarks_size_, _tmp52_);
										}
									}
								}
							}
							_tmp54_ = board_cells;
							_tmp54__length1 = board_cells_length1;
							_tmp54__length2 = board_cells_length2;
							_tmp55_ = i;
							_tmp56_ = j;
							_tmp57_ = _tmp54_[(_tmp55_ * _tmp54__length2) + _tmp56_];
							if (_tmp57_ == 0) {
								gint* _tmp58_ = NULL;
								gint _tmp58__length1 = 0;
								_tmp58_ = earmarks;
								_tmp58__length1 = earmarks_length1;
								_tmp53_ = _tmp58__length1 == 0;
							} else {
								_tmp53_ = FALSE;
							}
							if (_tmp53_) {
								earmarks = (g_free (earmarks), NULL);
								continue;
							}
							_tmp59_ = builder;
							json_builder_begin_object (_tmp59_);
							_tmp60_ = builder;
							json_builder_set_member_name (_tmp60_, "position");
							_tmp61_ = builder;
							json_builder_begin_array (_tmp61_);
							_tmp62_ = builder;
							_tmp63_ = i;
							json_builder_add_int_value (_tmp62_, (gint64) _tmp63_);
							_tmp64_ = builder;
							_tmp65_ = j;
							json_builder_add_int_value (_tmp64_, (gint64) _tmp65_);
							_tmp66_ = builder;
							json_builder_end_array (_tmp66_);
							_tmp67_ = builder;
							json_builder_set_member_name (_tmp67_, "value");
							_tmp68_ = builder;
							_tmp69_ = board_cells;
							_tmp69__length1 = board_cells_length1;
							_tmp69__length2 = board_cells_length2;
							_tmp70_ = i;
							_tmp71_ = j;
							_tmp72_ = _tmp69_[(_tmp70_ * _tmp69__length2) + _tmp71_];
							json_builder_add_int_value (_tmp68_, (gint64) _tmp72_);
							_tmp73_ = builder;
							json_builder_set_member_name (_tmp73_, "fixed");
							_tmp74_ = builder;
							_tmp75_ = board;
							_tmp76_ = _tmp75_->is_fixed;
							_tmp76__length1 = _tmp75_->is_fixed_length1;
							_tmp76__length2 = _tmp75_->is_fixed_length2;
							_tmp77_ = i;
							_tmp78_ = j;
							_tmp79_ = _tmp76_[(_tmp77_ * _tmp76__length2) + _tmp78_];
							json_builder_add_boolean_value (_tmp74_, _tmp79_);
							_tmp80_ = builder;
							json_builder_set_member_name (_tmp80_, "earmarks");
							_tmp81_ = builder;
							json_builder_begin_array (_tmp81_);
							_tmp82_ = earmarks;
							_tmp82__length1 = earmarks_length1;
							{
								gint* k_collection = NULL;
								gint k_collection_length1 = 0;
								gint _k_collection_size_ = 0;
								gint k_it = 0;
								k_collection = _tmp82_;
								k_collection_length1 = _tmp82__length1;
								for (k_it = 0; k_it < _tmp82__length1; k_it = k_it + 1) {
									gint k = 0;
									k = k_collection[k_it];
									{
										JsonBuilder* _tmp83_ = NULL;
										gint _tmp84_ = 0;
										_tmp83_ = builder;
										_tmp84_ = k;
										json_builder_add_int_value (_tmp83_, (gint64) _tmp84_);
									}
								}
							}
							_tmp85_ = builder;
							json_builder_end_array (_tmp85_);
							_tmp86_ = builder;
							json_builder_end_object (_tmp86_);
							earmarks = (g_free (earmarks), NULL);
						}
					}
				}
			}
		}
	}
	_tmp87_ = builder;
	json_builder_end_array (_tmp87_);
	_tmp88_ = builder;
	json_builder_end_object (_tmp88_);
	_tmp89_ = json_generator_new ();
	generator = _tmp89_;
	json_generator_set_pretty (generator, TRUE);
	_tmp90_ = builder;
	_tmp91_ = json_builder_get_root (_tmp90_);
	root = _tmp91_;
	json_generator_set_root (generator, root);
	_tmp92_ = json_generator_to_data (generator, NULL);
	result = _tmp92_;
	__vala_JsonNode_free0 (root);
	_g_object_unref0 (generator);
	_g_object_unref0 (builder);
	board_cells = (g_free (board_cells), NULL);
	_sudoku_board_unref0 (board);
	return result;
}


static JsonNode* _vala_JsonNode_copy (JsonNode* self) {
	return g_boxed_copy (json_node_get_type (), self);
}


static gpointer __vala_JsonNode_copy0 (gpointer self) {
	return self ? _vala_JsonNode_copy (self) : NULL;
}


static SudokuGame* sudoku_saver_parse_json_to_game (SudokuSaver* self, const gchar* file_path) {
	SudokuGame* result = NULL;
	JsonParser* parser = NULL;
	JsonParser* _tmp0_ = NULL;
	SudokuBoard* board = NULL;
	SudokuBoard* _tmp3_ = NULL;
	JsonNode* node = NULL;
	JsonParser* _tmp4_ = NULL;
	JsonNode* _tmp5_ = NULL;
	JsonNode* _tmp6_ = NULL;
	JsonReader* reader = NULL;
	JsonNode* _tmp7_ = NULL;
	JsonReader* _tmp8_ = NULL;
	JsonReader* _tmp9_ = NULL;
	JsonReader* _tmp10_ = NULL;
	gboolean _tmp11_ = FALSE;
	JsonReader* _tmp77_ = NULL;
	JsonReader* _tmp78_ = NULL;
	JsonReader* _tmp79_ = NULL;
	gboolean _tmp80_ = FALSE;
	SudokuBoard* _tmp81_ = NULL;
	JsonReader* _tmp82_ = NULL;
	gdouble _tmp83_ = 0.0;
	JsonReader* _tmp84_ = NULL;
	SudokuBoard* _tmp85_ = NULL;
	SudokuGame* _tmp86_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (file_path != NULL, NULL);
	_tmp0_ = json_parser_new ();
	parser = _tmp0_;
	{
		JsonParser* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		_tmp1_ = parser;
		_tmp2_ = file_path;
		json_parser_load_from_file (_tmp1_, _tmp2_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch13_g_error;
		}
	}
	goto __finally13;
	__catch13_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		result = NULL;
		_g_error_free0 (e);
		_g_object_unref0 (parser);
		return result;
	}
	__finally13:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (parser);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp3_ = sudoku_board_new (3, 3);
	board = _tmp3_;
	_tmp4_ = parser;
	_tmp5_ = json_parser_get_root (_tmp4_);
	_tmp6_ = __vala_JsonNode_copy0 (_tmp5_);
	node = _tmp6_;
	_tmp7_ = node;
	_tmp8_ = json_reader_new (_tmp7_);
	reader = _tmp8_;
	_tmp9_ = reader;
	json_reader_read_member (_tmp9_, "cells");
	_tmp10_ = reader;
	_tmp11_ = json_reader_is_array (_tmp10_);
	g_return_val_if_fail (_tmp11_, NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp12_ = FALSE;
			_tmp12_ = TRUE;
			while (TRUE) {
				gint _tmp14_ = 0;
				JsonReader* _tmp15_ = NULL;
				gint _tmp16_ = 0;
				JsonReader* _tmp17_ = NULL;
				gint _tmp18_ = 0;
				JsonReader* _tmp19_ = NULL;
				JsonReader* _tmp20_ = NULL;
				gboolean _tmp21_ = FALSE;
				JsonReader* _tmp22_ = NULL;
				gint _tmp23_ = 0;
				JsonReader* _tmp24_ = NULL;
				JsonReader* _tmp25_ = NULL;
				gboolean _tmp26_ = FALSE;
				gint row = 0;
				JsonReader* _tmp27_ = NULL;
				gint64 _tmp28_ = 0LL;
				JsonReader* _tmp29_ = NULL;
				JsonReader* _tmp30_ = NULL;
				JsonReader* _tmp31_ = NULL;
				gboolean _tmp32_ = FALSE;
				gint col = 0;
				JsonReader* _tmp33_ = NULL;
				gint64 _tmp34_ = 0LL;
				JsonReader* _tmp35_ = NULL;
				JsonReader* _tmp36_ = NULL;
				JsonReader* _tmp37_ = NULL;
				JsonReader* _tmp38_ = NULL;
				gboolean _tmp39_ = FALSE;
				gint val = 0;
				JsonReader* _tmp40_ = NULL;
				gint64 _tmp41_ = 0LL;
				JsonReader* _tmp42_ = NULL;
				JsonReader* _tmp43_ = NULL;
				JsonReader* _tmp44_ = NULL;
				gboolean _tmp45_ = FALSE;
				gboolean is_fixed = FALSE;
				JsonReader* _tmp46_ = NULL;
				gboolean _tmp47_ = FALSE;
				JsonReader* _tmp48_ = NULL;
				gint _tmp49_ = 0;
				JsonReader* _tmp55_ = NULL;
				JsonReader* _tmp56_ = NULL;
				gboolean _tmp57_ = FALSE;
				JsonReader* _tmp75_ = NULL;
				JsonReader* _tmp76_ = NULL;
				if (!_tmp12_) {
					gint _tmp13_ = 0;
					_tmp13_ = i;
					i = _tmp13_ + 1;
				}
				_tmp12_ = FALSE;
				_tmp14_ = i;
				_tmp15_ = reader;
				_tmp16_ = json_reader_count_elements (_tmp15_);
				if (!(_tmp14_ < _tmp16_)) {
					break;
				}
				_tmp17_ = reader;
				_tmp18_ = i;
				json_reader_read_element (_tmp17_, (guint) _tmp18_);
				_tmp19_ = reader;
				json_reader_read_member (_tmp19_, "position");
				_tmp20_ = reader;
				_tmp21_ = json_reader_is_array (_tmp20_);
				g_return_val_if_fail (_tmp21_, NULL);
				_tmp22_ = reader;
				_tmp23_ = json_reader_count_elements (_tmp22_);
				g_return_val_if_fail (_tmp23_ == 2, NULL);
				_tmp24_ = reader;
				json_reader_read_element (_tmp24_, (guint) 0);
				_tmp25_ = reader;
				_tmp26_ = json_reader_is_value (_tmp25_);
				g_return_val_if_fail (_tmp26_, NULL);
				_tmp27_ = reader;
				_tmp28_ = json_reader_get_int_value (_tmp27_);
				row = (gint) _tmp28_;
				_tmp29_ = reader;
				json_reader_end_element (_tmp29_);
				_tmp30_ = reader;
				json_reader_read_element (_tmp30_, (guint) 1);
				_tmp31_ = reader;
				_tmp32_ = json_reader_is_value (_tmp31_);
				g_return_val_if_fail (_tmp32_, NULL);
				_tmp33_ = reader;
				_tmp34_ = json_reader_get_int_value (_tmp33_);
				col = (gint) _tmp34_;
				_tmp35_ = reader;
				json_reader_end_element (_tmp35_);
				_tmp36_ = reader;
				json_reader_end_member (_tmp36_);
				_tmp37_ = reader;
				json_reader_read_member (_tmp37_, "value");
				_tmp38_ = reader;
				_tmp39_ = json_reader_is_value (_tmp38_);
				g_return_val_if_fail (_tmp39_, NULL);
				_tmp40_ = reader;
				_tmp41_ = json_reader_get_int_value (_tmp40_);
				val = (gint) _tmp41_;
				_tmp42_ = reader;
				json_reader_end_member (_tmp42_);
				_tmp43_ = reader;
				json_reader_read_member (_tmp43_, "fixed");
				_tmp44_ = reader;
				_tmp45_ = json_reader_is_value (_tmp44_);
				g_return_val_if_fail (_tmp45_, NULL);
				_tmp46_ = reader;
				_tmp47_ = json_reader_get_boolean_value (_tmp46_);
				is_fixed = _tmp47_;
				_tmp48_ = reader;
				json_reader_end_member (_tmp48_);
				_tmp49_ = val;
				if (_tmp49_ != 0) {
					SudokuBoard* _tmp50_ = NULL;
					gint _tmp51_ = 0;
					gint _tmp52_ = 0;
					gint _tmp53_ = 0;
					gboolean _tmp54_ = FALSE;
					_tmp50_ = board;
					_tmp51_ = row;
					_tmp52_ = col;
					_tmp53_ = val;
					_tmp54_ = is_fixed;
					sudoku_board_insert (_tmp50_, _tmp51_, _tmp52_, _tmp53_, _tmp54_);
				}
				_tmp55_ = reader;
				json_reader_read_member (_tmp55_, "earmarks");
				_tmp56_ = reader;
				_tmp57_ = json_reader_is_array (_tmp56_);
				g_return_val_if_fail (_tmp57_, NULL);
				{
					gint k = 0;
					k = 0;
					{
						gboolean _tmp58_ = FALSE;
						_tmp58_ = TRUE;
						while (TRUE) {
							gint _tmp60_ = 0;
							JsonReader* _tmp61_ = NULL;
							gint _tmp62_ = 0;
							JsonReader* _tmp63_ = NULL;
							gint _tmp64_ = 0;
							JsonReader* _tmp65_ = NULL;
							gboolean _tmp66_ = FALSE;
							SudokuBoard* _tmp67_ = NULL;
							gboolean* _tmp68_ = NULL;
							gint _tmp68__length1 = 0;
							gint _tmp68__length2 = 0;
							gint _tmp68__length3 = 0;
							gint _tmp69_ = 0;
							gint _tmp70_ = 0;
							JsonReader* _tmp71_ = NULL;
							gint64 _tmp72_ = 0LL;
							gboolean _tmp73_ = FALSE;
							JsonReader* _tmp74_ = NULL;
							if (!_tmp58_) {
								gint _tmp59_ = 0;
								_tmp59_ = k;
								k = _tmp59_ + 1;
							}
							_tmp58_ = FALSE;
							_tmp60_ = k;
							_tmp61_ = reader;
							_tmp62_ = json_reader_count_elements (_tmp61_);
							if (!(_tmp60_ < _tmp62_)) {
								break;
							}
							_tmp63_ = reader;
							_tmp64_ = k;
							json_reader_read_element (_tmp63_, (guint) _tmp64_);
							_tmp65_ = reader;
							_tmp66_ = json_reader_is_value (_tmp65_);
							g_return_val_if_fail (_tmp66_, NULL);
							_tmp67_ = board;
							_tmp68_ = _tmp67_->earmarks;
							_tmp68__length1 = _tmp67_->earmarks_length1;
							_tmp68__length2 = _tmp67_->earmarks_length2;
							_tmp68__length3 = _tmp67_->earmarks_length3;
							_tmp69_ = row;
							_tmp70_ = col;
							_tmp71_ = reader;
							_tmp72_ = json_reader_get_int_value (_tmp71_);
							_tmp68_[(((_tmp69_ * _tmp68__length2) + _tmp70_) * _tmp68__length3) + ((gint) _tmp72_)] = TRUE;
							_tmp73_ = _tmp68_[(((_tmp69_ * _tmp68__length2) + _tmp70_) * _tmp68__length3) + ((gint) _tmp72_)];
							_tmp74_ = reader;
							json_reader_end_element (_tmp74_);
						}
					}
				}
				_tmp75_ = reader;
				json_reader_end_member (_tmp75_);
				_tmp76_ = reader;
				json_reader_end_element (_tmp76_);
			}
		}
	}
	_tmp77_ = reader;
	json_reader_end_member (_tmp77_);
	_tmp78_ = reader;
	json_reader_read_member (_tmp78_, "time_elapsed");
	_tmp79_ = reader;
	_tmp80_ = json_reader_is_value (_tmp79_);
	g_return_val_if_fail (_tmp80_, NULL);
	_tmp81_ = board;
	_tmp82_ = reader;
	_tmp83_ = json_reader_get_double_value (_tmp82_);
	sudoku_board_set_previous_played_time (_tmp81_, _tmp83_);
	_tmp84_ = reader;
	json_reader_end_member (_tmp84_);
	_tmp85_ = board;
	_tmp86_ = sudoku_game_new (_tmp85_);
	result = _tmp86_;
	_g_object_unref0 (reader);
	__vala_JsonNode_free0 (node);
	_sudoku_board_unref0 (board);
	_g_object_unref0 (parser);
	return result;
}


const gchar* sudoku_saver_get_savegame_file (void) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	_tmp0_ = sudoku_saver__savegame_file;
	result = _tmp0_;
	return result;
}


static void sudoku_saver_set_savegame_file (const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (sudoku_saver__savegame_file);
	sudoku_saver__savegame_file = _tmp1_;
}


const gchar* sudoku_saver_get_finishgame_dir (void) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	_tmp0_ = sudoku_saver__finishgame_dir;
	result = _tmp0_;
	return result;
}


static void sudoku_saver_set_finishgame_dir (const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (sudoku_saver__finishgame_dir);
	sudoku_saver__finishgame_dir = _tmp1_;
}


static void value_sudoku_saver_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_sudoku_saver_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		sudoku_saver_unref (value->data[0].v_pointer);
	}
}


static void value_sudoku_saver_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = sudoku_saver_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_sudoku_saver_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_sudoku_saver_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		SudokuSaver* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = sudoku_saver_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_sudoku_saver_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	SudokuSaver** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = sudoku_saver_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_sudoku_saver (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecSudokuSaver* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_SUDOKU_SAVER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_sudoku_saver (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SUDOKU_SAVER), NULL);
	return value->data[0].v_pointer;
}


void value_set_sudoku_saver (GValue* value, gpointer v_object) {
	SudokuSaver* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SUDOKU_SAVER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SUDOKU_SAVER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		sudoku_saver_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		sudoku_saver_unref (old);
	}
}


void value_take_sudoku_saver (GValue* value, gpointer v_object) {
	SudokuSaver* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SUDOKU_SAVER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SUDOKU_SAVER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		sudoku_saver_unref (old);
	}
}


static void sudoku_saver_class_init (SudokuSaverClass * klass) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	sudoku_saver_parent_class = g_type_class_peek_parent (klass);
	SUDOKU_SAVER_CLASS (klass)->finalize = sudoku_saver_finalize;
	_tmp0_ = g_strdup ("");
	sudoku_saver__savegame_file = _tmp0_;
	_tmp1_ = g_strdup ("");
	sudoku_saver__finishgame_dir = _tmp1_;
}


static void sudoku_saver_instance_init (SudokuSaver * self) {
	self->ref_count = 1;
}


static void sudoku_saver_finalize (SudokuSaver* obj) {
	SudokuSaver * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SUDOKU_SAVER, SudokuSaver);
}


GType sudoku_saver_get_type (void) {
	static volatile gsize sudoku_saver_type_id__volatile = 0;
	if (g_once_init_enter (&sudoku_saver_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_sudoku_saver_init, value_sudoku_saver_free_value, value_sudoku_saver_copy_value, value_sudoku_saver_peek_pointer, "p", value_sudoku_saver_collect_value, "p", value_sudoku_saver_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (SudokuSaverClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sudoku_saver_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SudokuSaver), 0, (GInstanceInitFunc) sudoku_saver_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType sudoku_saver_type_id;
		sudoku_saver_type_id = g_type_register_fundamental (g_type_fundamental_next (), "SudokuSaver", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&sudoku_saver_type_id__volatile, sudoku_saver_type_id);
	}
	return sudoku_saver_type_id__volatile;
}


gpointer sudoku_saver_ref (gpointer instance) {
	SudokuSaver* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void sudoku_saver_unref (gpointer instance) {
	SudokuSaver* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		SUDOKU_SAVER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}



