/* Flegita - Scanner utility
 * Copyright © 2006-2008  Étienne Bersac <bersace@gnome.org>
 *
 * Flegita is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * Flegita is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with Flegita. If not, write to:
 *
 *	the Free Software Foundation, Inc.
 *	51 Franklin Street, Fifth Floor
 *	Boston, MA 02110-1301, USA
 */

#ifndef __FLEGITA_SINK_H__
#define __FLEGITA_SINK_H__

#include <glib.h>
#include <glib-object.h>
#include <gnome-scan-sink.h>

G_BEGIN_DECLS


#define FLEGITA_TYPE_SINK (flegita_sink_get_type ())
#define FLEGITA_SINK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FLEGITA_TYPE_SINK, FlegitaSink))
#define FLEGITA_SINK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FLEGITA_TYPE_SINK, FlegitaSinkClass))
#define FLEGITA_IS_SINK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FLEGITA_TYPE_SINK))
#define FLEGITA_IS_SINK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FLEGITA_TYPE_SINK))
#define FLEGITA_SINK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FLEGITA_TYPE_SINK, FlegitaSinkClass))

typedef struct _FlegitaSink FlegitaSink;
typedef struct _FlegitaSinkClass FlegitaSinkClass;
typedef struct _FlegitaSinkPrivate FlegitaSinkPrivate;

struct _FlegitaSink {
	GnomeScanSink parent_instance;
	FlegitaSinkPrivate * priv;
};

struct _FlegitaSinkClass {
	GnomeScanSinkClass parent_class;
};


FlegitaSink* flegita_sink_construct (GType object_type);
FlegitaSink* flegita_sink_new (void);
GType flegita_sink_get_type (void);


G_END_DECLS

#endif
