/* Flegita - Scanner utility
 * Copyright © 2006-2008  Étienne Bersac <bersace@gnome.org>
 *
 * Flegita is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * Flegita is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with Flegita. If not, write to:
 *
 *	the Free Software Foundation, Inc.
 *	51 Franklin Street, Fifth Floor
 *	Boston, MA 02110-1301, USA
 */

#include "flegita-options.h"




struct _FlegitaOptionOutputFilenamePrivate {
	char* _value;
	char* directory;
	char* filename;
	GnomeScanFormat* format;
	GSList* formats;
};

#define FLEGITA_OPTION_OUTPUT_FILENAME_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), FLEGITA_TYPE_OPTION_OUTPUT_FILENAME, FlegitaOptionOutputFilenamePrivate))
enum  {
	FLEGITA_OPTION_OUTPUT_FILENAME_DUMMY_PROPERTY,
	FLEGITA_OPTION_OUTPUT_FILENAME_VALUE
};
static void _g_slist_free_g_object_unref (GSList* self);
static void flegita_option_output_filename_update_value (FlegitaOptionOutputFilename* self);
static gpointer flegita_option_output_filename_parent_class = NULL;
static void flegita_option_output_filename_finalize (GObject* obj);



static void _g_slist_free_g_object_unref (GSList* self) {
	g_slist_foreach (self, (GFunc) g_object_unref, NULL);
	g_slist_free (self);
}


FlegitaOptionOutputFilename* flegita_option_output_filename_construct (GType object_type, const char* name, const char* title, const char* desc, const char* domain, const char* group, GnomeScanOptionHint hint) {
	GParameter * __params;
	GParameter * __params_it;
	FlegitaOptionOutputFilename * self;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (title != NULL, NULL);
	g_return_val_if_fail (desc != NULL, NULL);
	g_return_val_if_fail (domain != NULL, NULL);
	g_return_val_if_fail (group != NULL, NULL);
	__params = g_new0 (GParameter, 6);
	__params_it = __params;
	__params_it->name = "name";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, name);
	__params_it++;
	__params_it->name = "title";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, title);
	__params_it++;
	__params_it->name = "desc";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, desc);
	__params_it++;
	__params_it->name = "domain";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, domain);
	__params_it++;
	__params_it->name = "group";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, group);
	__params_it++;
	__params_it->name = "hint";
	g_value_init (&__params_it->value, GNOME_SCAN_TYPE_OPTION_HINT);
	g_value_set_enum (&__params_it->value, hint);
	__params_it++;
	self = g_object_newv (object_type, __params_it - __params, __params);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


FlegitaOptionOutputFilename* flegita_option_output_filename_new (const char* name, const char* title, const char* desc, const char* domain, const char* group, GnomeScanOptionHint hint) {
	return flegita_option_output_filename_construct (FLEGITA_TYPE_OPTION_OUTPUT_FILENAME, name, title, desc, domain, group, hint);
}


void flegita_option_output_filename_install_format (FlegitaOptionOutputFilename* self, GnomeScanFormat* format) {
	GnomeScanFormat* _tmp0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (format != NULL);
	_tmp0 = NULL;
	self->priv->formats = g_slist_append (self->priv->formats, (_tmp0 = format, (_tmp0 == NULL) ? NULL : g_object_ref (_tmp0)));
	if (self->priv->format == NULL) {
		GnomeScanFormat* _tmp2;
		GnomeScanFormat* _tmp1;
		_tmp2 = NULL;
		_tmp1 = NULL;
		self->priv->format = (_tmp2 = (_tmp1 = (GnomeScanFormat*) g_slist_nth_data (self->priv->formats, (guint) 0), (_tmp1 == NULL) ? NULL : g_object_ref (_tmp1)), (self->priv->format == NULL) ? NULL : (self->priv->format = (g_object_unref (self->priv->format), NULL)), _tmp2);
		flegita_option_output_filename_update_value (self);
	}
}


GSList* flegita_option_output_filename_list_formats (FlegitaOptionOutputFilename* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->formats;
}


static void flegita_option_output_filename_update_value (FlegitaOptionOutputFilename* self) {
	gboolean _tmp0;
	gboolean _tmp1;
	g_return_if_fail (self != NULL);
	_tmp0 = FALSE;
	_tmp1 = FALSE;
	if (g_utf8_strlen (self->priv->directory, -1) > 2) {
		_tmp1 = g_utf8_strlen (self->priv->filename, -1) > 2;
	} else {
		_tmp1 = FALSE;
	}
	if (_tmp1) {
		_tmp0 = self->priv->format != NULL;
	} else {
		_tmp0 = FALSE;
	}
	if (_tmp0) {
		char* _tmp2;
		_tmp2 = NULL;
		flegita_option_output_filename_set_value (self, _tmp2 = g_strconcat (self->priv->directory, G_DIR_SEPARATOR_S, self->priv->filename, ".", self->priv->format->suffixes[0], NULL));
		_tmp2 = (g_free (_tmp2), NULL);
	} else {
		flegita_option_output_filename_set_value (self, NULL);
	}
}


const char* flegita_option_output_filename_get_value (FlegitaOptionOutputFilename* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_value;
}


void flegita_option_output_filename_set_value (FlegitaOptionOutputFilename* self, const char* value) {
	char* _tmp2;
	const char* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_value = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : g_strdup (_tmp1)), self->priv->_value = (g_free (self->priv->_value), NULL), _tmp2);
	g_object_notify ((GObject *) self, "value");
}


static void flegita_option_output_filename_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	FlegitaOptionOutputFilename * self;
	gpointer boxed;
	self = FLEGITA_OPTION_OUTPUT_FILENAME (object);
	switch (property_id) {
		case FLEGITA_OPTION_OUTPUT_FILENAME_VALUE:
		g_value_set_string (value, flegita_option_output_filename_get_value (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void flegita_option_output_filename_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	FlegitaOptionOutputFilename * self;
	self = FLEGITA_OPTION_OUTPUT_FILENAME (object);
	switch (property_id) {
		case FLEGITA_OPTION_OUTPUT_FILENAME_VALUE:
		flegita_option_output_filename_set_value (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void flegita_option_output_filename_class_init (FlegitaOptionOutputFilenameClass * klass) {
	flegita_option_output_filename_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (FlegitaOptionOutputFilenamePrivate));
	G_OBJECT_CLASS (klass)->get_property = flegita_option_output_filename_get_property;
	G_OBJECT_CLASS (klass)->set_property = flegita_option_output_filename_set_property;
	G_OBJECT_CLASS (klass)->finalize = flegita_option_output_filename_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), FLEGITA_OPTION_OUTPUT_FILENAME_VALUE, g_param_spec_string ("value", "value", "value", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void flegita_option_output_filename_instance_init (FlegitaOptionOutputFilename * self) {
	self->priv = FLEGITA_OPTION_OUTPUT_FILENAME_GET_PRIVATE (self);
	self->priv->format = NULL;
}


static void flegita_option_output_filename_finalize (GObject* obj) {
	FlegitaOptionOutputFilename * self;
	self = FLEGITA_OPTION_OUTPUT_FILENAME (obj);
	self->priv->_value = (g_free (self->priv->_value), NULL);
	self->priv->directory = (g_free (self->priv->directory), NULL);
	self->priv->filename = (g_free (self->priv->filename), NULL);
	(self->priv->format == NULL) ? NULL : (self->priv->format = (g_object_unref (self->priv->format), NULL));
	(self->priv->formats == NULL) ? NULL : (self->priv->formats = (_g_slist_free_g_object_unref (self->priv->formats), NULL));
	G_OBJECT_CLASS (flegita_option_output_filename_parent_class)->finalize (obj);
}


GType flegita_option_output_filename_get_type (void) {
	static GType flegita_option_output_filename_type_id = 0;
	if (flegita_option_output_filename_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (FlegitaOptionOutputFilenameClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) flegita_option_output_filename_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FlegitaOptionOutputFilename), 0, (GInstanceInitFunc) flegita_option_output_filename_instance_init, NULL };
		flegita_option_output_filename_type_id = g_type_register_static (GNOME_SCAN_TYPE_OPTION, "FlegitaOptionOutputFilename", &g_define_type_info, 0);
	}
	return flegita_option_output_filename_type_id;
}




