/* GNOME Scan - Scan as easy as you print
 * Copyright © 2006-2008  Étienne Bersac <bersace@gnome.org>
 *
 * GNOME Scan is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * GNOME Scan is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with GNOME Scan. If not, write to:
 *
 *	the Free Software Foundation, Inc.
 *	51 Franklin Street, Fifth Floor
 *	Boston, MA 02110-1301, USA
 */

#ifndef __GNOME_SCAN_SCANNER_SELECTOR_H__
#define __GNOME_SCAN_SCANNER_SELECTOR_H__

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gnome-scan-job.h>

G_BEGIN_DECLS


#define GNOME_SCAN_TYPE_SCANNER_SELECTOR (gnome_scan_scanner_selector_get_type ())
#define GNOME_SCAN_SCANNER_SELECTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_SCANNER_SELECTOR, GnomeScanScannerSelector))
#define GNOME_SCAN_SCANNER_SELECTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_SCANNER_SELECTOR, GnomeScanScannerSelectorClass))
#define GNOME_SCAN_IS_SCANNER_SELECTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_SCANNER_SELECTOR))
#define GNOME_SCAN_IS_SCANNER_SELECTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_SCANNER_SELECTOR))
#define GNOME_SCAN_SCANNER_SELECTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_SCANNER_SELECTOR, GnomeScanScannerSelectorClass))

typedef struct _GnomeScanScannerSelector GnomeScanScannerSelector;
typedef struct _GnomeScanScannerSelectorClass GnomeScanScannerSelectorClass;
typedef struct _GnomeScanScannerSelectorPrivate GnomeScanScannerSelectorPrivate;

struct _GnomeScanScannerSelector {
	GtkScrolledWindow parent_instance;
	GnomeScanScannerSelectorPrivate * priv;
};

struct _GnomeScanScannerSelectorClass {
	GtkScrolledWindowClass parent_class;
};


GnomeScanScannerSelector* gnome_scan_scanner_selector_construct (GType object_type, GnomeScanJob* job);
GnomeScanScannerSelector* gnome_scan_scanner_selector_new (GnomeScanJob* job);
void gnome_scan_scanner_selector_probe_scanners (GnomeScanScannerSelector* self);
GnomeScanJob* gnome_scan_scanner_selector_get_job (GnomeScanScannerSelector* self);
void gnome_scan_scanner_selector_set_job (GnomeScanScannerSelector* self, GnomeScanJob* value);
GType gnome_scan_scanner_selector_get_type (void);


G_END_DECLS

#endif
