/* GNOME Scan - Scan as easy as you print
 * Copyright © 2006-2008  Étienne Bersac <bersace@gnome.org>
 *
 * GNOME Scan is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * GNOME Scan is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with GNOME Scan. If not, write to:
 *
 *	the Free Software Foundation, Inc.
 *	51 Franklin Street, Fifth Floor
 *	Boston, MA 02110-1301, USA
 */

using Gtk;

namespace Gnome.Scan {
	public class ScaleWidget : OptionWidget {
		private Adjustment adj;

		construct {
			this.expand = false;
			this.no_label = false;

			SpinButton spin;
			Scale scale;
			int digits = 0;
			if (option is OptionInt) {
				var option = this.option as OptionInt;

				adj = new Adjustment(option.value, option.min, option.max, option.step, option.step, 0);

				scale = new HScale(adj);
				scale.draw_value = false;
				scale.set_digits(digits);

				spin = new SpinButton(adj, option.step, digits);

				adj.notify["value"] += this.on_int_adj_value_changed;
				option.notify["value"] += this.on_int_option_value_changed;
			}
			else if (option is OptionDouble) {
				var option = this.option as OptionDouble;

				if (option.step < 1.0)
					digits = 2;

				adj = new Adjustment(option.value, option.min, option.max, option.step, option.step, 0);

				scale = new HScale(adj);
				scale.draw_value = false;
				scale.set_digits(digits);

				spin = new SpinButton(adj, option.step, digits);

				adj.notify["value"] += this.on_double_adj_value_changed;
				option.notify["value"] += this.on_double_option_value_changed;
			}

			this.pack_start(scale, true, true, 0);
			this.pack_start(spin, false, true, 0);
		}

		private void on_int_option_value_changed()
		{
			var option = option as OptionInt;
			adj.value = (double) option.value;
		}

		private void on_int_adj_value_changed()
		{
			var option = option as OptionInt;
			option.value = (int) adj.value;
		}

		private void on_double_option_value_changed()
		{
			var option = option as OptionDouble;
			adj.value = option.value;
		}

		private void on_double_adj_value_changed()
		{
			var option = option as OptionDouble;
			option.value = adj.value;
		}
	}
}
