/* GNOME Scan - Scan as easy as you print
 * Copyright © 2006-2008  Étienne Bersac <bersace@gnome.org>
 *
 * GNOME Scan is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * GNOME Scan is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with GNOME Scan. If not, write to:
 *
 *	the Free Software Foundation, Inc.
 *	51 Franklin Street, Fifth Floor
 *	Boston, MA 02110-1301, USA
 */

#include <gnome-scan-option.h>
#include <glib/gi18n-lib.h>




struct _GnomeScanOptionPrivate {
	char* _name;
	char* _title;
	char* _desc;
	char* _group;
	char* _domain;
	GnomeScanUnit _unit;
	GnomeScanOptionHint _hint;
	gboolean _active;
};

#define GNOME_SCAN_OPTION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GNOME_SCAN_TYPE_OPTION, GnomeScanOptionPrivate))
enum  {
	GNOME_SCAN_OPTION_DUMMY_PROPERTY,
	GNOME_SCAN_OPTION_NAME,
	GNOME_SCAN_OPTION_TITLE,
	GNOME_SCAN_OPTION_DESC,
	GNOME_SCAN_OPTION_GROUP,
	GNOME_SCAN_OPTION_DOMAIN,
	GNOME_SCAN_OPTION_UNIT,
	GNOME_SCAN_OPTION_HINT,
	GNOME_SCAN_OPTION_ACTIVE
};
static gpointer gnome_scan_option_parent_class = NULL;
static void gnome_scan_option_finalize (GObject* obj);
struct _GnomeScanOptionBoolPrivate {
	gboolean _value;
};

#define GNOME_SCAN_OPTION_BOOL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GNOME_SCAN_TYPE_OPTION_BOOL, GnomeScanOptionBoolPrivate))
enum  {
	GNOME_SCAN_OPTION_BOOL_DUMMY_PROPERTY,
	GNOME_SCAN_OPTION_BOOL_VALUE
};
static gpointer gnome_scan_option_bool_parent_class = NULL;
static void gnome_scan_option_bool_finalize (GObject* obj);
struct _GnomeScanOptionIntPrivate {
	gint _value;
	gint _min;
	gint _step;
	gint _max;
};

#define GNOME_SCAN_OPTION_INT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GNOME_SCAN_TYPE_OPTION_INT, GnomeScanOptionIntPrivate))
enum  {
	GNOME_SCAN_OPTION_INT_DUMMY_PROPERTY,
	GNOME_SCAN_OPTION_INT_VALUE,
	GNOME_SCAN_OPTION_INT_MIN,
	GNOME_SCAN_OPTION_INT_STEP,
	GNOME_SCAN_OPTION_INT_MAX
};
static gpointer gnome_scan_option_int_parent_class = NULL;
static void gnome_scan_option_int_finalize (GObject* obj);
struct _GnomeScanOptionDoublePrivate {
	double _value;
	double _min;
	double _step;
	double _max;
};

#define GNOME_SCAN_OPTION_DOUBLE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GNOME_SCAN_TYPE_OPTION_DOUBLE, GnomeScanOptionDoublePrivate))
enum  {
	GNOME_SCAN_OPTION_DOUBLE_DUMMY_PROPERTY,
	GNOME_SCAN_OPTION_DOUBLE_VALUE,
	GNOME_SCAN_OPTION_DOUBLE_MIN,
	GNOME_SCAN_OPTION_DOUBLE_STEP,
	GNOME_SCAN_OPTION_DOUBLE_MAX
};
static gpointer gnome_scan_option_double_parent_class = NULL;
static void gnome_scan_option_double_finalize (GObject* obj);
struct _GnomeScanOptionStringPrivate {
	char* _value;
};

#define GNOME_SCAN_OPTION_STRING_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GNOME_SCAN_TYPE_OPTION_STRING, GnomeScanOptionStringPrivate))
enum  {
	GNOME_SCAN_OPTION_STRING_DUMMY_PROPERTY,
	GNOME_SCAN_OPTION_STRING_VALUE
};
static gpointer gnome_scan_option_string_parent_class = NULL;
static void gnome_scan_option_string_finalize (GObject* obj);
struct _GnomeScanOptionEnumPrivate {
	GnomeScanEnumValue* _value;
	GSList* _values;
};

#define GNOME_SCAN_OPTION_ENUM_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GNOME_SCAN_TYPE_OPTION_ENUM, GnomeScanOptionEnumPrivate))
enum  {
	GNOME_SCAN_OPTION_ENUM_DUMMY_PROPERTY,
	GNOME_SCAN_OPTION_ENUM_VALUE,
	GNOME_SCAN_OPTION_ENUM_VALUES
};
static gpointer gnome_scan_option_enum_parent_class = NULL;
static void gnome_scan_option_enum_finalize (GObject* obj);
struct _GnomeScanOptionBoxedPrivate {
	gpointer* _value;
};

#define GNOME_SCAN_OPTION_BOXED_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GNOME_SCAN_TYPE_OPTION_BOXED, GnomeScanOptionBoxedPrivate))
enum  {
	GNOME_SCAN_OPTION_BOXED_DUMMY_PROPERTY,
	GNOME_SCAN_OPTION_BOXED_VALUE
};
static gpointer gnome_scan_option_boxed_parent_class = NULL;
static void gnome_scan_option_boxed_finalize (GObject* obj);
struct _GnomeScanOptionPointerPrivate {
	void* _value;
};

#define GNOME_SCAN_OPTION_POINTER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GNOME_SCAN_TYPE_OPTION_POINTER, GnomeScanOptionPointerPrivate))
enum  {
	GNOME_SCAN_OPTION_POINTER_DUMMY_PROPERTY,
	GNOME_SCAN_OPTION_POINTER_VALUE
};
static gpointer gnome_scan_option_pointer_parent_class = NULL;
static void gnome_scan_option_pointer_finalize (GObject* obj);




GType gnome_scan_option_hint_get_type (void) {
	static GType gnome_scan_option_hint_type_id = 0;
	if (G_UNLIKELY (gnome_scan_option_hint_type_id == 0)) {
		static const GEnumValue values[] = {{GNOME_SCAN_OPTION_HINT_HIDDEN, "GNOME_SCAN_OPTION_HINT_HIDDEN", "hidden"}, {GNOME_SCAN_OPTION_HINT_PRIMARY, "GNOME_SCAN_OPTION_HINT_PRIMARY", "primary"}, {GNOME_SCAN_OPTION_HINT_SECONDARY, "GNOME_SCAN_OPTION_HINT_SECONDARY", "secondary"}, {GNOME_SCAN_OPTION_HINT_PREVIEW, "GNOME_SCAN_OPTION_HINT_PREVIEW", "preview"}, {GNOME_SCAN_OPTION_HINT_REPEAT, "GNOME_SCAN_OPTION_HINT_REPEAT", "repeat"}, {0, NULL, NULL}};
		gnome_scan_option_hint_type_id = g_enum_register_static ("GnomeScanOptionHint", values);
	}
	return gnome_scan_option_hint_type_id;
}


const char* gnome_scan_option_get_name (GnomeScanOption* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_name;
}


void gnome_scan_option_set_name (GnomeScanOption* self, const char* value) {
	char* _tmp2;
	const char* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_name = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : g_strdup (_tmp1)), self->priv->_name = (g_free (self->priv->_name), NULL), _tmp2);
	g_object_notify ((GObject *) self, "name");
}


const char* gnome_scan_option_get_title (GnomeScanOption* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_title;
}


void gnome_scan_option_set_title (GnomeScanOption* self, const char* value) {
	char* _tmp2;
	const char* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_title = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : g_strdup (_tmp1)), self->priv->_title = (g_free (self->priv->_title), NULL), _tmp2);
	g_object_notify ((GObject *) self, "title");
}


const char* gnome_scan_option_get_desc (GnomeScanOption* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_desc;
}


void gnome_scan_option_set_desc (GnomeScanOption* self, const char* value) {
	char* _tmp2;
	const char* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_desc = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : g_strdup (_tmp1)), self->priv->_desc = (g_free (self->priv->_desc), NULL), _tmp2);
	g_object_notify ((GObject *) self, "desc");
}


const char* gnome_scan_option_get_group (GnomeScanOption* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_group;
}


void gnome_scan_option_set_group (GnomeScanOption* self, const char* value) {
	char* _tmp2;
	const char* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_group = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : g_strdup (_tmp1)), self->priv->_group = (g_free (self->priv->_group), NULL), _tmp2);
	g_object_notify ((GObject *) self, "group");
}


const char* gnome_scan_option_get_domain (GnomeScanOption* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_domain;
}


void gnome_scan_option_set_domain (GnomeScanOption* self, const char* value) {
	char* _tmp2;
	const char* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_domain = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : g_strdup (_tmp1)), self->priv->_domain = (g_free (self->priv->_domain), NULL), _tmp2);
	g_object_notify ((GObject *) self, "domain");
}


GnomeScanUnit gnome_scan_option_get_unit (GnomeScanOption* self) {
	g_return_val_if_fail (self != NULL, 0);
	return self->priv->_unit;
}


void gnome_scan_option_set_unit (GnomeScanOption* self, GnomeScanUnit value) {
	g_return_if_fail (self != NULL);
	self->priv->_unit = value;
	g_object_notify ((GObject *) self, "unit");
}


GnomeScanOptionHint gnome_scan_option_get_hint (GnomeScanOption* self) {
	g_return_val_if_fail (self != NULL, 0);
	return self->priv->_hint;
}


void gnome_scan_option_set_hint (GnomeScanOption* self, GnomeScanOptionHint value) {
	g_return_if_fail (self != NULL);
	self->priv->_hint = value;
	g_object_notify ((GObject *) self, "hint");
}


gboolean gnome_scan_option_get_active (GnomeScanOption* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return self->priv->_active;
}


void gnome_scan_option_set_active (GnomeScanOption* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_active = value;
	g_object_notify ((GObject *) self, "active");
}


static void gnome_scan_option_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GnomeScanOption * self;
	gpointer boxed;
	self = GNOME_SCAN_OPTION (object);
	switch (property_id) {
		case GNOME_SCAN_OPTION_NAME:
		g_value_set_string (value, gnome_scan_option_get_name (self));
		break;
		case GNOME_SCAN_OPTION_TITLE:
		g_value_set_string (value, gnome_scan_option_get_title (self));
		break;
		case GNOME_SCAN_OPTION_DESC:
		g_value_set_string (value, gnome_scan_option_get_desc (self));
		break;
		case GNOME_SCAN_OPTION_GROUP:
		g_value_set_string (value, gnome_scan_option_get_group (self));
		break;
		case GNOME_SCAN_OPTION_DOMAIN:
		g_value_set_string (value, gnome_scan_option_get_domain (self));
		break;
		case GNOME_SCAN_OPTION_UNIT:
		g_value_set_enum (value, gnome_scan_option_get_unit (self));
		break;
		case GNOME_SCAN_OPTION_HINT:
		g_value_set_enum (value, gnome_scan_option_get_hint (self));
		break;
		case GNOME_SCAN_OPTION_ACTIVE:
		g_value_set_boolean (value, gnome_scan_option_get_active (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gnome_scan_option_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GnomeScanOption * self;
	self = GNOME_SCAN_OPTION (object);
	switch (property_id) {
		case GNOME_SCAN_OPTION_NAME:
		gnome_scan_option_set_name (self, g_value_get_string (value));
		break;
		case GNOME_SCAN_OPTION_TITLE:
		gnome_scan_option_set_title (self, g_value_get_string (value));
		break;
		case GNOME_SCAN_OPTION_DESC:
		gnome_scan_option_set_desc (self, g_value_get_string (value));
		break;
		case GNOME_SCAN_OPTION_GROUP:
		gnome_scan_option_set_group (self, g_value_get_string (value));
		break;
		case GNOME_SCAN_OPTION_DOMAIN:
		gnome_scan_option_set_domain (self, g_value_get_string (value));
		break;
		case GNOME_SCAN_OPTION_UNIT:
		gnome_scan_option_set_unit (self, g_value_get_enum (value));
		break;
		case GNOME_SCAN_OPTION_HINT:
		gnome_scan_option_set_hint (self, g_value_get_enum (value));
		break;
		case GNOME_SCAN_OPTION_ACTIVE:
		gnome_scan_option_set_active (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gnome_scan_option_class_init (GnomeScanOptionClass * klass) {
	gnome_scan_option_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GnomeScanOptionPrivate));
	G_OBJECT_CLASS (klass)->get_property = gnome_scan_option_get_property;
	G_OBJECT_CLASS (klass)->set_property = gnome_scan_option_set_property;
	G_OBJECT_CLASS (klass)->finalize = gnome_scan_option_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_SCAN_OPTION_NAME, g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_SCAN_OPTION_TITLE, g_param_spec_string ("title", "title", "title", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_SCAN_OPTION_DESC, g_param_spec_string ("desc", "desc", "desc", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_SCAN_OPTION_GROUP, g_param_spec_string ("group", "group", "group", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_SCAN_OPTION_DOMAIN, g_param_spec_string ("domain", "domain", "domain", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_SCAN_OPTION_UNIT, g_param_spec_enum ("unit", "unit", "unit", GNOME_SCAN_TYPE_UNIT, GNOME_SCAN_UNIT_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_SCAN_OPTION_HINT, g_param_spec_enum ("hint", "hint", "hint", GNOME_SCAN_TYPE_OPTION_HINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_SCAN_OPTION_ACTIVE, g_param_spec_boolean ("active", "active", "active", TRUE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void gnome_scan_option_instance_init (GnomeScanOption * self) {
	self->priv = GNOME_SCAN_OPTION_GET_PRIVATE (self);
	self->priv->_unit = GNOME_SCAN_UNIT_NONE;
	self->priv->_active = TRUE;
}


static void gnome_scan_option_finalize (GObject* obj) {
	GnomeScanOption * self;
	self = GNOME_SCAN_OPTION (obj);
	self->priv->_name = (g_free (self->priv->_name), NULL);
	self->priv->_title = (g_free (self->priv->_title), NULL);
	self->priv->_desc = (g_free (self->priv->_desc), NULL);
	self->priv->_group = (g_free (self->priv->_group), NULL);
	self->priv->_domain = (g_free (self->priv->_domain), NULL);
	G_OBJECT_CLASS (gnome_scan_option_parent_class)->finalize (obj);
}


GType gnome_scan_option_get_type (void) {
	static GType gnome_scan_option_type_id = 0;
	if (gnome_scan_option_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (GnomeScanOptionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gnome_scan_option_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GnomeScanOption), 0, (GInstanceInitFunc) gnome_scan_option_instance_init, NULL };
		gnome_scan_option_type_id = g_type_register_static (G_TYPE_OBJECT, "GnomeScanOption", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	}
	return gnome_scan_option_type_id;
}


GnomeScanOptionBool* gnome_scan_option_bool_construct (GType object_type, const char* name, const char* title, const char* desc, const char* group, const char* domain, gboolean value, GnomeScanOptionHint hint) {
	GParameter * __params;
	GParameter * __params_it;
	GnomeScanOptionBool * self;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (title != NULL, NULL);
	g_return_val_if_fail (desc != NULL, NULL);
	g_return_val_if_fail (group != NULL, NULL);
	g_return_val_if_fail (domain != NULL, NULL);
	__params = g_new0 (GParameter, 6);
	__params_it = __params;
	__params_it->name = "name";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, name);
	__params_it++;
	__params_it->name = "title";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, title);
	__params_it++;
	__params_it->name = "desc";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, desc);
	__params_it++;
	__params_it->name = "group";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, group);
	__params_it++;
	__params_it->name = "domain";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, domain);
	__params_it++;
	__params_it->name = "hint";
	g_value_init (&__params_it->value, GNOME_SCAN_TYPE_OPTION_HINT);
	g_value_set_enum (&__params_it->value, hint);
	__params_it++;
	self = g_object_newv (object_type, __params_it - __params, __params);
	gnome_scan_option_bool_set_value (self, value);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


GnomeScanOptionBool* gnome_scan_option_bool_new (const char* name, const char* title, const char* desc, const char* group, const char* domain, gboolean value, GnomeScanOptionHint hint) {
	return gnome_scan_option_bool_construct (GNOME_SCAN_TYPE_OPTION_BOOL, name, title, desc, group, domain, value, hint);
}


gboolean gnome_scan_option_bool_get_value (GnomeScanOptionBool* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return self->priv->_value;
}


void gnome_scan_option_bool_set_value (GnomeScanOptionBool* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_value = value;
	g_object_notify ((GObject *) self, "value");
}


static void gnome_scan_option_bool_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GnomeScanOptionBool * self;
	gpointer boxed;
	self = GNOME_SCAN_OPTION_BOOL (object);
	switch (property_id) {
		case GNOME_SCAN_OPTION_BOOL_VALUE:
		g_value_set_boolean (value, gnome_scan_option_bool_get_value (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gnome_scan_option_bool_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GnomeScanOptionBool * self;
	self = GNOME_SCAN_OPTION_BOOL (object);
	switch (property_id) {
		case GNOME_SCAN_OPTION_BOOL_VALUE:
		gnome_scan_option_bool_set_value (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gnome_scan_option_bool_class_init (GnomeScanOptionBoolClass * klass) {
	gnome_scan_option_bool_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GnomeScanOptionBoolPrivate));
	G_OBJECT_CLASS (klass)->get_property = gnome_scan_option_bool_get_property;
	G_OBJECT_CLASS (klass)->set_property = gnome_scan_option_bool_set_property;
	G_OBJECT_CLASS (klass)->finalize = gnome_scan_option_bool_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_SCAN_OPTION_BOOL_VALUE, g_param_spec_boolean ("value", "value", "value", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void gnome_scan_option_bool_instance_init (GnomeScanOptionBool * self) {
	self->priv = GNOME_SCAN_OPTION_BOOL_GET_PRIVATE (self);
}


static void gnome_scan_option_bool_finalize (GObject* obj) {
	GnomeScanOptionBool * self;
	self = GNOME_SCAN_OPTION_BOOL (obj);
	G_OBJECT_CLASS (gnome_scan_option_bool_parent_class)->finalize (obj);
}


GType gnome_scan_option_bool_get_type (void) {
	static GType gnome_scan_option_bool_type_id = 0;
	if (gnome_scan_option_bool_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (GnomeScanOptionBoolClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gnome_scan_option_bool_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GnomeScanOptionBool), 0, (GInstanceInitFunc) gnome_scan_option_bool_instance_init, NULL };
		gnome_scan_option_bool_type_id = g_type_register_static (GNOME_SCAN_TYPE_OPTION, "GnomeScanOptionBool", &g_define_type_info, 0);
	}
	return gnome_scan_option_bool_type_id;
}


GnomeScanOptionInt* gnome_scan_option_int_construct (GType object_type, const char* name, const char* title, const char* desc, const char* group, const char* domain, gint value, gint min, gint step, gint max, GnomeScanUnit unit, GnomeScanOptionHint hint) {
	GParameter * __params;
	GParameter * __params_it;
	GnomeScanOptionInt * self;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (title != NULL, NULL);
	g_return_val_if_fail (desc != NULL, NULL);
	g_return_val_if_fail (group != NULL, NULL);
	g_return_val_if_fail (domain != NULL, NULL);
	__params = g_new0 (GParameter, 10);
	__params_it = __params;
	__params_it->name = "name";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, name);
	__params_it++;
	__params_it->name = "title";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, title);
	__params_it++;
	__params_it->name = "desc";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, desc);
	__params_it++;
	__params_it->name = "group";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, group);
	__params_it++;
	__params_it->name = "domain";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, domain);
	__params_it++;
	__params_it->name = "min";
	g_value_init (&__params_it->value, G_TYPE_INT);
	g_value_set_int (&__params_it->value, min);
	__params_it++;
	__params_it->name = "step";
	g_value_init (&__params_it->value, G_TYPE_INT);
	g_value_set_int (&__params_it->value, step);
	__params_it++;
	__params_it->name = "max";
	g_value_init (&__params_it->value, G_TYPE_INT);
	g_value_set_int (&__params_it->value, max);
	__params_it++;
	__params_it->name = "unit";
	g_value_init (&__params_it->value, GNOME_SCAN_TYPE_UNIT);
	g_value_set_enum (&__params_it->value, unit);
	__params_it++;
	__params_it->name = "hint";
	g_value_init (&__params_it->value, GNOME_SCAN_TYPE_OPTION_HINT);
	g_value_set_enum (&__params_it->value, hint);
	__params_it++;
	self = g_object_newv (object_type, __params_it - __params, __params);
	gnome_scan_option_int_set_value (self, value);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


GnomeScanOptionInt* gnome_scan_option_int_new (const char* name, const char* title, const char* desc, const char* group, const char* domain, gint value, gint min, gint step, gint max, GnomeScanUnit unit, GnomeScanOptionHint hint) {
	return gnome_scan_option_int_construct (GNOME_SCAN_TYPE_OPTION_INT, name, title, desc, group, domain, value, min, step, max, unit, hint);
}


gint gnome_scan_option_int_get_value (GnomeScanOptionInt* self) {
	g_return_val_if_fail (self != NULL, 0);
	return self->priv->_value;
}


void gnome_scan_option_int_set_value (GnomeScanOptionInt* self, gint value) {
	g_return_if_fail (self != NULL);
	self->priv->_value = value;
	g_object_notify ((GObject *) self, "value");
}


gint gnome_scan_option_int_get_min (GnomeScanOptionInt* self) {
	g_return_val_if_fail (self != NULL, 0);
	return self->priv->_min;
}


void gnome_scan_option_int_set_min (GnomeScanOptionInt* self, gint value) {
	g_return_if_fail (self != NULL);
	self->priv->_min = value;
	g_object_notify ((GObject *) self, "min");
}


gint gnome_scan_option_int_get_step (GnomeScanOptionInt* self) {
	g_return_val_if_fail (self != NULL, 0);
	return self->priv->_step;
}


void gnome_scan_option_int_set_step (GnomeScanOptionInt* self, gint value) {
	g_return_if_fail (self != NULL);
	self->priv->_step = value;
	g_object_notify ((GObject *) self, "step");
}


gint gnome_scan_option_int_get_max (GnomeScanOptionInt* self) {
	g_return_val_if_fail (self != NULL, 0);
	return self->priv->_max;
}


void gnome_scan_option_int_set_max (GnomeScanOptionInt* self, gint value) {
	g_return_if_fail (self != NULL);
	self->priv->_max = value;
	g_object_notify ((GObject *) self, "max");
}


static void gnome_scan_option_int_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GnomeScanOptionInt * self;
	gpointer boxed;
	self = GNOME_SCAN_OPTION_INT (object);
	switch (property_id) {
		case GNOME_SCAN_OPTION_INT_VALUE:
		g_value_set_int (value, gnome_scan_option_int_get_value (self));
		break;
		case GNOME_SCAN_OPTION_INT_MIN:
		g_value_set_int (value, gnome_scan_option_int_get_min (self));
		break;
		case GNOME_SCAN_OPTION_INT_STEP:
		g_value_set_int (value, gnome_scan_option_int_get_step (self));
		break;
		case GNOME_SCAN_OPTION_INT_MAX:
		g_value_set_int (value, gnome_scan_option_int_get_max (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gnome_scan_option_int_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GnomeScanOptionInt * self;
	self = GNOME_SCAN_OPTION_INT (object);
	switch (property_id) {
		case GNOME_SCAN_OPTION_INT_VALUE:
		gnome_scan_option_int_set_value (self, g_value_get_int (value));
		break;
		case GNOME_SCAN_OPTION_INT_MIN:
		gnome_scan_option_int_set_min (self, g_value_get_int (value));
		break;
		case GNOME_SCAN_OPTION_INT_STEP:
		gnome_scan_option_int_set_step (self, g_value_get_int (value));
		break;
		case GNOME_SCAN_OPTION_INT_MAX:
		gnome_scan_option_int_set_max (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gnome_scan_option_int_class_init (GnomeScanOptionIntClass * klass) {
	gnome_scan_option_int_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GnomeScanOptionIntPrivate));
	G_OBJECT_CLASS (klass)->get_property = gnome_scan_option_int_get_property;
	G_OBJECT_CLASS (klass)->set_property = gnome_scan_option_int_set_property;
	G_OBJECT_CLASS (klass)->finalize = gnome_scan_option_int_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_SCAN_OPTION_INT_VALUE, g_param_spec_int ("value", "value", "value", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_SCAN_OPTION_INT_MIN, g_param_spec_int ("min", "min", "min", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_SCAN_OPTION_INT_STEP, g_param_spec_int ("step", "step", "step", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_SCAN_OPTION_INT_MAX, g_param_spec_int ("max", "max", "max", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}


static void gnome_scan_option_int_instance_init (GnomeScanOptionInt * self) {
	self->priv = GNOME_SCAN_OPTION_INT_GET_PRIVATE (self);
}


static void gnome_scan_option_int_finalize (GObject* obj) {
	GnomeScanOptionInt * self;
	self = GNOME_SCAN_OPTION_INT (obj);
	G_OBJECT_CLASS (gnome_scan_option_int_parent_class)->finalize (obj);
}


GType gnome_scan_option_int_get_type (void) {
	static GType gnome_scan_option_int_type_id = 0;
	if (gnome_scan_option_int_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (GnomeScanOptionIntClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gnome_scan_option_int_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GnomeScanOptionInt), 0, (GInstanceInitFunc) gnome_scan_option_int_instance_init, NULL };
		gnome_scan_option_int_type_id = g_type_register_static (GNOME_SCAN_TYPE_OPTION, "GnomeScanOptionInt", &g_define_type_info, 0);
	}
	return gnome_scan_option_int_type_id;
}


GnomeScanOptionDouble* gnome_scan_option_double_construct (GType object_type, const char* name, const char* title, const char* desc, const char* group, const char* domain, double value, double min, double step, double max, GnomeScanUnit unit, GnomeScanOptionHint hint) {
	GParameter * __params;
	GParameter * __params_it;
	GnomeScanOptionDouble * self;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (title != NULL, NULL);
	g_return_val_if_fail (desc != NULL, NULL);
	g_return_val_if_fail (group != NULL, NULL);
	g_return_val_if_fail (domain != NULL, NULL);
	__params = g_new0 (GParameter, 10);
	__params_it = __params;
	__params_it->name = "name";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, name);
	__params_it++;
	__params_it->name = "title";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, title);
	__params_it++;
	__params_it->name = "desc";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, desc);
	__params_it++;
	__params_it->name = "group";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, group);
	__params_it++;
	__params_it->name = "domain";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, domain);
	__params_it++;
	__params_it->name = "min";
	g_value_init (&__params_it->value, G_TYPE_DOUBLE);
	g_value_set_double (&__params_it->value, min);
	__params_it++;
	__params_it->name = "step";
	g_value_init (&__params_it->value, G_TYPE_DOUBLE);
	g_value_set_double (&__params_it->value, step);
	__params_it++;
	__params_it->name = "max";
	g_value_init (&__params_it->value, G_TYPE_DOUBLE);
	g_value_set_double (&__params_it->value, max);
	__params_it++;
	__params_it->name = "unit";
	g_value_init (&__params_it->value, GNOME_SCAN_TYPE_UNIT);
	g_value_set_enum (&__params_it->value, unit);
	__params_it++;
	__params_it->name = "hint";
	g_value_init (&__params_it->value, GNOME_SCAN_TYPE_OPTION_HINT);
	g_value_set_enum (&__params_it->value, hint);
	__params_it++;
	self = g_object_newv (object_type, __params_it - __params, __params);
	gnome_scan_option_double_set_value (self, value);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


GnomeScanOptionDouble* gnome_scan_option_double_new (const char* name, const char* title, const char* desc, const char* group, const char* domain, double value, double min, double step, double max, GnomeScanUnit unit, GnomeScanOptionHint hint) {
	return gnome_scan_option_double_construct (GNOME_SCAN_TYPE_OPTION_DOUBLE, name, title, desc, group, domain, value, min, step, max, unit, hint);
}


double gnome_scan_option_double_get_value (GnomeScanOptionDouble* self) {
	g_return_val_if_fail (self != NULL, 0.0);
	return self->priv->_value;
}


void gnome_scan_option_double_set_value (GnomeScanOptionDouble* self, double value) {
	g_return_if_fail (self != NULL);
	self->priv->_value = value;
	g_object_notify ((GObject *) self, "value");
}


double gnome_scan_option_double_get_min (GnomeScanOptionDouble* self) {
	g_return_val_if_fail (self != NULL, 0.0);
	return self->priv->_min;
}


void gnome_scan_option_double_set_min (GnomeScanOptionDouble* self, double value) {
	g_return_if_fail (self != NULL);
	self->priv->_min = value;
	g_object_notify ((GObject *) self, "min");
}


double gnome_scan_option_double_get_step (GnomeScanOptionDouble* self) {
	g_return_val_if_fail (self != NULL, 0.0);
	return self->priv->_step;
}


void gnome_scan_option_double_set_step (GnomeScanOptionDouble* self, double value) {
	g_return_if_fail (self != NULL);
	self->priv->_step = value;
	g_object_notify ((GObject *) self, "step");
}


double gnome_scan_option_double_get_max (GnomeScanOptionDouble* self) {
	g_return_val_if_fail (self != NULL, 0.0);
	return self->priv->_max;
}


void gnome_scan_option_double_set_max (GnomeScanOptionDouble* self, double value) {
	g_return_if_fail (self != NULL);
	self->priv->_max = value;
	g_object_notify ((GObject *) self, "max");
}


static void gnome_scan_option_double_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GnomeScanOptionDouble * self;
	gpointer boxed;
	self = GNOME_SCAN_OPTION_DOUBLE (object);
	switch (property_id) {
		case GNOME_SCAN_OPTION_DOUBLE_VALUE:
		g_value_set_double (value, gnome_scan_option_double_get_value (self));
		break;
		case GNOME_SCAN_OPTION_DOUBLE_MIN:
		g_value_set_double (value, gnome_scan_option_double_get_min (self));
		break;
		case GNOME_SCAN_OPTION_DOUBLE_STEP:
		g_value_set_double (value, gnome_scan_option_double_get_step (self));
		break;
		case GNOME_SCAN_OPTION_DOUBLE_MAX:
		g_value_set_double (value, gnome_scan_option_double_get_max (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gnome_scan_option_double_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GnomeScanOptionDouble * self;
	self = GNOME_SCAN_OPTION_DOUBLE (object);
	switch (property_id) {
		case GNOME_SCAN_OPTION_DOUBLE_VALUE:
		gnome_scan_option_double_set_value (self, g_value_get_double (value));
		break;
		case GNOME_SCAN_OPTION_DOUBLE_MIN:
		gnome_scan_option_double_set_min (self, g_value_get_double (value));
		break;
		case GNOME_SCAN_OPTION_DOUBLE_STEP:
		gnome_scan_option_double_set_step (self, g_value_get_double (value));
		break;
		case GNOME_SCAN_OPTION_DOUBLE_MAX:
		gnome_scan_option_double_set_max (self, g_value_get_double (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gnome_scan_option_double_class_init (GnomeScanOptionDoubleClass * klass) {
	gnome_scan_option_double_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GnomeScanOptionDoublePrivate));
	G_OBJECT_CLASS (klass)->get_property = gnome_scan_option_double_get_property;
	G_OBJECT_CLASS (klass)->set_property = gnome_scan_option_double_set_property;
	G_OBJECT_CLASS (klass)->finalize = gnome_scan_option_double_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_SCAN_OPTION_DOUBLE_VALUE, g_param_spec_double ("value", "value", "value", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_SCAN_OPTION_DOUBLE_MIN, g_param_spec_double ("min", "min", "min", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_SCAN_OPTION_DOUBLE_STEP, g_param_spec_double ("step", "step", "step", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_SCAN_OPTION_DOUBLE_MAX, g_param_spec_double ("max", "max", "max", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}


static void gnome_scan_option_double_instance_init (GnomeScanOptionDouble * self) {
	self->priv = GNOME_SCAN_OPTION_DOUBLE_GET_PRIVATE (self);
}


static void gnome_scan_option_double_finalize (GObject* obj) {
	GnomeScanOptionDouble * self;
	self = GNOME_SCAN_OPTION_DOUBLE (obj);
	G_OBJECT_CLASS (gnome_scan_option_double_parent_class)->finalize (obj);
}


GType gnome_scan_option_double_get_type (void) {
	static GType gnome_scan_option_double_type_id = 0;
	if (gnome_scan_option_double_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (GnomeScanOptionDoubleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gnome_scan_option_double_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GnomeScanOptionDouble), 0, (GInstanceInitFunc) gnome_scan_option_double_instance_init, NULL };
		gnome_scan_option_double_type_id = g_type_register_static (GNOME_SCAN_TYPE_OPTION, "GnomeScanOptionDouble", &g_define_type_info, 0);
	}
	return gnome_scan_option_double_type_id;
}


GnomeScanOptionString* gnome_scan_option_string_construct (GType object_type, const char* name, const char* title, const char* desc, const char* group, const char* domain, const char* value, GnomeScanOptionHint hint) {
	GParameter * __params;
	GParameter * __params_it;
	GnomeScanOptionString * self;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (title != NULL, NULL);
	g_return_val_if_fail (desc != NULL, NULL);
	g_return_val_if_fail (group != NULL, NULL);
	g_return_val_if_fail (domain != NULL, NULL);
	g_return_val_if_fail (value != NULL, NULL);
	__params = g_new0 (GParameter, 6);
	__params_it = __params;
	__params_it->name = "name";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, name);
	__params_it++;
	__params_it->name = "title";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, title);
	__params_it++;
	__params_it->name = "desc";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, desc);
	__params_it++;
	__params_it->name = "group";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, group);
	__params_it++;
	__params_it->name = "domain";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, domain);
	__params_it++;
	__params_it->name = "hint";
	g_value_init (&__params_it->value, GNOME_SCAN_TYPE_OPTION_HINT);
	g_value_set_enum (&__params_it->value, hint);
	__params_it++;
	self = g_object_newv (object_type, __params_it - __params, __params);
	gnome_scan_option_string_set_value (self, value);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


GnomeScanOptionString* gnome_scan_option_string_new (const char* name, const char* title, const char* desc, const char* group, const char* domain, const char* value, GnomeScanOptionHint hint) {
	return gnome_scan_option_string_construct (GNOME_SCAN_TYPE_OPTION_STRING, name, title, desc, group, domain, value, hint);
}


const char* gnome_scan_option_string_get_value (GnomeScanOptionString* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_value;
}


void gnome_scan_option_string_set_value (GnomeScanOptionString* self, const char* value) {
	char* _tmp2;
	const char* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_value = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : g_strdup (_tmp1)), self->priv->_value = (g_free (self->priv->_value), NULL), _tmp2);
	g_object_notify ((GObject *) self, "value");
}


static void gnome_scan_option_string_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GnomeScanOptionString * self;
	gpointer boxed;
	self = GNOME_SCAN_OPTION_STRING (object);
	switch (property_id) {
		case GNOME_SCAN_OPTION_STRING_VALUE:
		g_value_set_string (value, gnome_scan_option_string_get_value (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gnome_scan_option_string_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GnomeScanOptionString * self;
	self = GNOME_SCAN_OPTION_STRING (object);
	switch (property_id) {
		case GNOME_SCAN_OPTION_STRING_VALUE:
		gnome_scan_option_string_set_value (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gnome_scan_option_string_class_init (GnomeScanOptionStringClass * klass) {
	gnome_scan_option_string_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GnomeScanOptionStringPrivate));
	G_OBJECT_CLASS (klass)->get_property = gnome_scan_option_string_get_property;
	G_OBJECT_CLASS (klass)->set_property = gnome_scan_option_string_set_property;
	G_OBJECT_CLASS (klass)->finalize = gnome_scan_option_string_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_SCAN_OPTION_STRING_VALUE, g_param_spec_string ("value", "value", "value", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void gnome_scan_option_string_instance_init (GnomeScanOptionString * self) {
	self->priv = GNOME_SCAN_OPTION_STRING_GET_PRIVATE (self);
}


static void gnome_scan_option_string_finalize (GObject* obj) {
	GnomeScanOptionString * self;
	self = GNOME_SCAN_OPTION_STRING (obj);
	self->priv->_value = (g_free (self->priv->_value), NULL);
	G_OBJECT_CLASS (gnome_scan_option_string_parent_class)->finalize (obj);
}


GType gnome_scan_option_string_get_type (void) {
	static GType gnome_scan_option_string_type_id = 0;
	if (gnome_scan_option_string_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (GnomeScanOptionStringClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gnome_scan_option_string_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GnomeScanOptionString), 0, (GInstanceInitFunc) gnome_scan_option_string_instance_init, NULL };
		gnome_scan_option_string_type_id = g_type_register_static (GNOME_SCAN_TYPE_OPTION, "GnomeScanOptionString", &g_define_type_info, 0);
	}
	return gnome_scan_option_string_type_id;
}


GnomeScanOptionEnum* gnome_scan_option_enum_construct (GType object_type, const char* name, const char* title, const char* desc, const char* group, const char* domain, const GnomeScanEnumValue* value, GSList* values, GnomeScanOptionHint hint) {
	GParameter * __params;
	GParameter * __params_it;
	GnomeScanOptionEnum * self;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (title != NULL, NULL);
	g_return_val_if_fail (desc != NULL, NULL);
	g_return_val_if_fail (group != NULL, NULL);
	g_return_val_if_fail (domain != NULL, NULL);
	g_return_val_if_fail (values != NULL, NULL);
	__params = g_new0 (GParameter, 6);
	__params_it = __params;
	__params_it->name = "name";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, name);
	__params_it++;
	__params_it->name = "title";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, title);
	__params_it++;
	__params_it->name = "desc";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, desc);
	__params_it++;
	__params_it->name = "group";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, group);
	__params_it++;
	__params_it->name = "domain";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, domain);
	__params_it++;
	__params_it->name = "hint";
	g_value_init (&__params_it->value, GNOME_SCAN_TYPE_OPTION_HINT);
	g_value_set_enum (&__params_it->value, hint);
	__params_it++;
	self = g_object_newv (object_type, __params_it - __params, __params);
	gnome_scan_option_enum_set_value (self, &value);
	self->priv->_values = values;
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


GnomeScanOptionEnum* gnome_scan_option_enum_new (const char* name, const char* title, const char* desc, const char* group, const char* domain, const GnomeScanEnumValue* value, GSList* values, GnomeScanOptionHint hint) {
	return gnome_scan_option_enum_construct (GNOME_SCAN_TYPE_OPTION_ENUM, name, title, desc, group, domain, value, values, hint);
}


void gnome_scan_option_enum_get_value (GnomeScanOptionEnum* self, GnomeScanEnumValue** value) {
	g_return_if_fail (self != NULL);
	*value = self->priv->_value;
	return;
}


void gnome_scan_option_enum_set_value (GnomeScanOptionEnum* self, GnomeScanEnumValue** value) {
	g_return_if_fail (self != NULL);
	self->priv->_value = (*value);
	g_object_notify ((GObject *) self, "value");
}


GSList* gnome_scan_option_enum_get_values (GnomeScanOptionEnum* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_values;
}


static void gnome_scan_option_enum_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GnomeScanOptionEnum * self;
	gpointer boxed;
	self = GNOME_SCAN_OPTION_ENUM (object);
	switch (property_id) {
		case GNOME_SCAN_OPTION_ENUM_VALUE:
		boxed = g_new0 (GnomeScanEnumValue, 1);
		g_value_take_boxed (value, boxed);
		break;
		case GNOME_SCAN_OPTION_ENUM_VALUES:
		g_value_set_pointer (value, gnome_scan_option_enum_get_values (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gnome_scan_option_enum_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GnomeScanOptionEnum * self;
	self = GNOME_SCAN_OPTION_ENUM (object);
	switch (property_id) {
		case GNOME_SCAN_OPTION_ENUM_VALUE:
		gnome_scan_option_enum_set_value (self, g_value_get_boxed (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gnome_scan_option_enum_class_init (GnomeScanOptionEnumClass * klass) {
	gnome_scan_option_enum_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GnomeScanOptionEnumPrivate));
	G_OBJECT_CLASS (klass)->get_property = gnome_scan_option_enum_get_property;
	G_OBJECT_CLASS (klass)->set_property = gnome_scan_option_enum_set_property;
	G_OBJECT_CLASS (klass)->finalize = gnome_scan_option_enum_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_SCAN_OPTION_ENUM_VALUE, g_param_spec_boxed ("value", "value", "value", GNOME_SCAN_TYPE_ENUM_VALUE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_SCAN_OPTION_ENUM_VALUES, g_param_spec_pointer ("values", "values", "values", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void gnome_scan_option_enum_instance_init (GnomeScanOptionEnum * self) {
	self->priv = GNOME_SCAN_OPTION_ENUM_GET_PRIVATE (self);
}


static void gnome_scan_option_enum_finalize (GObject* obj) {
	GnomeScanOptionEnum * self;
	self = GNOME_SCAN_OPTION_ENUM (obj);
	G_OBJECT_CLASS (gnome_scan_option_enum_parent_class)->finalize (obj);
}


GType gnome_scan_option_enum_get_type (void) {
	static GType gnome_scan_option_enum_type_id = 0;
	if (gnome_scan_option_enum_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (GnomeScanOptionEnumClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gnome_scan_option_enum_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GnomeScanOptionEnum), 0, (GInstanceInitFunc) gnome_scan_option_enum_instance_init, NULL };
		gnome_scan_option_enum_type_id = g_type_register_static (GNOME_SCAN_TYPE_OPTION, "GnomeScanOptionEnum", &g_define_type_info, 0);
	}
	return gnome_scan_option_enum_type_id;
}


GnomeScanOptionBoxed* gnome_scan_option_boxed_construct (GType object_type, const char* name, const char* title, const char* desc, const char* group, const char* domain, gpointer* value, GnomeScanOptionHint hint) {
	GParameter * __params;
	GParameter * __params_it;
	GnomeScanOptionBoxed * self;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (title != NULL, NULL);
	g_return_val_if_fail (desc != NULL, NULL);
	g_return_val_if_fail (group != NULL, NULL);
	g_return_val_if_fail (domain != NULL, NULL);
	g_return_val_if_fail (value != NULL, NULL);
	__params = g_new0 (GParameter, 6);
	__params_it = __params;
	__params_it->name = "name";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, name);
	__params_it++;
	__params_it->name = "title";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, title);
	__params_it++;
	__params_it->name = "desc";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, desc);
	__params_it++;
	__params_it->name = "group";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, group);
	__params_it++;
	__params_it->name = "domain";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, domain);
	__params_it++;
	__params_it->name = "hint";
	g_value_init (&__params_it->value, GNOME_SCAN_TYPE_OPTION_HINT);
	g_value_set_enum (&__params_it->value, hint);
	__params_it++;
	self = g_object_newv (object_type, __params_it - __params, __params);
	gnome_scan_option_boxed_set_value (self, value);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


GnomeScanOptionBoxed* gnome_scan_option_boxed_new (const char* name, const char* title, const char* desc, const char* group, const char* domain, gpointer* value, GnomeScanOptionHint hint) {
	return gnome_scan_option_boxed_construct (GNOME_SCAN_TYPE_OPTION_BOXED, name, title, desc, group, domain, value, hint);
}


gpointer* gnome_scan_option_boxed_get_value (GnomeScanOptionBoxed* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_value;
}


void gnome_scan_option_boxed_set_value (GnomeScanOptionBoxed* self, gpointer* value) {
	g_return_if_fail (self != NULL);
	self->priv->_value = value;
	g_object_notify ((GObject *) self, "value");
}


static void gnome_scan_option_boxed_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GnomeScanOptionBoxed * self;
	gpointer boxed;
	self = GNOME_SCAN_OPTION_BOXED (object);
	switch (property_id) {
		case GNOME_SCAN_OPTION_BOXED_VALUE:
		g_value_set_boxed (value, gnome_scan_option_boxed_get_value (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gnome_scan_option_boxed_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GnomeScanOptionBoxed * self;
	self = GNOME_SCAN_OPTION_BOXED (object);
	switch (property_id) {
		case GNOME_SCAN_OPTION_BOXED_VALUE:
		gnome_scan_option_boxed_set_value (self, g_value_get_boxed (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gnome_scan_option_boxed_class_init (GnomeScanOptionBoxedClass * klass) {
	gnome_scan_option_boxed_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GnomeScanOptionBoxedPrivate));
	G_OBJECT_CLASS (klass)->get_property = gnome_scan_option_boxed_get_property;
	G_OBJECT_CLASS (klass)->set_property = gnome_scan_option_boxed_set_property;
	G_OBJECT_CLASS (klass)->finalize = gnome_scan_option_boxed_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_SCAN_OPTION_BOXED_VALUE, g_param_spec_pointer ("value", "value", "value", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void gnome_scan_option_boxed_instance_init (GnomeScanOptionBoxed * self) {
	self->priv = GNOME_SCAN_OPTION_BOXED_GET_PRIVATE (self);
}


static void gnome_scan_option_boxed_finalize (GObject* obj) {
	GnomeScanOptionBoxed * self;
	self = GNOME_SCAN_OPTION_BOXED (obj);
	G_OBJECT_CLASS (gnome_scan_option_boxed_parent_class)->finalize (obj);
}


GType gnome_scan_option_boxed_get_type (void) {
	static GType gnome_scan_option_boxed_type_id = 0;
	if (gnome_scan_option_boxed_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (GnomeScanOptionBoxedClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gnome_scan_option_boxed_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GnomeScanOptionBoxed), 0, (GInstanceInitFunc) gnome_scan_option_boxed_instance_init, NULL };
		gnome_scan_option_boxed_type_id = g_type_register_static (GNOME_SCAN_TYPE_OPTION, "GnomeScanOptionBoxed", &g_define_type_info, 0);
	}
	return gnome_scan_option_boxed_type_id;
}


GnomeScanOptionPointer* gnome_scan_option_pointer_construct (GType object_type, const char* name, const char* title, const char* desc, const char* group, const char* domain, void* value, GnomeScanOptionHint hint) {
	GParameter * __params;
	GParameter * __params_it;
	GnomeScanOptionPointer * self;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (title != NULL, NULL);
	g_return_val_if_fail (desc != NULL, NULL);
	g_return_val_if_fail (group != NULL, NULL);
	g_return_val_if_fail (domain != NULL, NULL);
	__params = g_new0 (GParameter, 6);
	__params_it = __params;
	__params_it->name = "name";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, name);
	__params_it++;
	__params_it->name = "title";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, title);
	__params_it++;
	__params_it->name = "desc";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, desc);
	__params_it++;
	__params_it->name = "group";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, group);
	__params_it++;
	__params_it->name = "domain";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, domain);
	__params_it++;
	__params_it->name = "hint";
	g_value_init (&__params_it->value, GNOME_SCAN_TYPE_OPTION_HINT);
	g_value_set_enum (&__params_it->value, hint);
	__params_it++;
	self = g_object_newv (object_type, __params_it - __params, __params);
	gnome_scan_option_pointer_set_value (self, value);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


GnomeScanOptionPointer* gnome_scan_option_pointer_new (const char* name, const char* title, const char* desc, const char* group, const char* domain, void* value, GnomeScanOptionHint hint) {
	return gnome_scan_option_pointer_construct (GNOME_SCAN_TYPE_OPTION_POINTER, name, title, desc, group, domain, value, hint);
}


void* gnome_scan_option_pointer_get_value (GnomeScanOptionPointer* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_value;
}


void gnome_scan_option_pointer_set_value (GnomeScanOptionPointer* self, void* value) {
	g_return_if_fail (self != NULL);
	self->priv->_value = value;
	g_object_notify ((GObject *) self, "value");
}


static void gnome_scan_option_pointer_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GnomeScanOptionPointer * self;
	gpointer boxed;
	self = GNOME_SCAN_OPTION_POINTER (object);
	switch (property_id) {
		case GNOME_SCAN_OPTION_POINTER_VALUE:
		g_value_set_pointer (value, gnome_scan_option_pointer_get_value (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gnome_scan_option_pointer_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GnomeScanOptionPointer * self;
	self = GNOME_SCAN_OPTION_POINTER (object);
	switch (property_id) {
		case GNOME_SCAN_OPTION_POINTER_VALUE:
		gnome_scan_option_pointer_set_value (self, g_value_get_pointer (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gnome_scan_option_pointer_class_init (GnomeScanOptionPointerClass * klass) {
	gnome_scan_option_pointer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GnomeScanOptionPointerPrivate));
	G_OBJECT_CLASS (klass)->get_property = gnome_scan_option_pointer_get_property;
	G_OBJECT_CLASS (klass)->set_property = gnome_scan_option_pointer_set_property;
	G_OBJECT_CLASS (klass)->finalize = gnome_scan_option_pointer_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_SCAN_OPTION_POINTER_VALUE, g_param_spec_pointer ("value", "value", "value", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void gnome_scan_option_pointer_instance_init (GnomeScanOptionPointer * self) {
	self->priv = GNOME_SCAN_OPTION_POINTER_GET_PRIVATE (self);
}


static void gnome_scan_option_pointer_finalize (GObject* obj) {
	GnomeScanOptionPointer * self;
	self = GNOME_SCAN_OPTION_POINTER (obj);
	G_OBJECT_CLASS (gnome_scan_option_pointer_parent_class)->finalize (obj);
}


GType gnome_scan_option_pointer_get_type (void) {
	static GType gnome_scan_option_pointer_type_id = 0;
	if (gnome_scan_option_pointer_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (GnomeScanOptionPointerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gnome_scan_option_pointer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GnomeScanOptionPointer), 0, (GInstanceInitFunc) gnome_scan_option_pointer_instance_init, NULL };
		gnome_scan_option_pointer_type_id = g_type_register_static (GNOME_SCAN_TYPE_OPTION, "GnomeScanOptionPointer", &g_define_type_info, 0);
	}
	return gnome_scan_option_pointer_type_id;
}




