/* GNOME Scan - Scan as easy as you print
 * Copyright © 2006-2008  Étienne Bersac <bersace@gnome.org>
 *
 * GNOME Scan is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * GNOME Scan is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with GNOME Scan. If not, write to:
 *
 *	the Free Software Foundation, Inc.
 *	51 Franklin Street, Fifth Floor
 *	Boston, MA 02110-1301, USA
 */

#include <gnome-scan-option-manager.h>




GnomeScanOptionManager* gnome_scan_option_manager = NULL;
struct _GnomeScanOptionManagerPrivate {
	GHashTable* rules_by_name;
	GHashTable* rules_by_type;
	GHashTable* options;
	GHashTable* defaults;
	GHashTable* ranges;
	GHashTable* enums;
};

#define GNOME_SCAN_OPTION_MANAGER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GNOME_SCAN_TYPE_OPTION_MANAGER, GnomeScanOptionManagerPrivate))
enum  {
	GNOME_SCAN_OPTION_MANAGER_DUMMY_PROPERTY
};
static GValue* _g_value_dup (GValue* self);
static GObject * gnome_scan_option_manager_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static gpointer gnome_scan_option_manager_parent_class = NULL;
static void gnome_scan_option_manager_finalize (GObject* obj);



void gnome_scan_option_manager_register_option (GnomeScanOptionManager* self, GnomeScanOption* option) {
	GnomeScanOption* _tmp0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (option != NULL);
	_tmp0 = NULL;
	g_hash_table_insert (self->priv->options, gnome_scan_option_get_name (option), (_tmp0 = option, (_tmp0 == NULL) ? NULL : g_object_ref (_tmp0)));
}


void gnome_scan_option_manager_register_rule_by_name (GnomeScanOptionManager* self, const char* option_name, GType handler_type) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (option_name != NULL);
	g_hash_table_insert (self->priv->rules_by_name, option_name, GINT_TO_POINTER (handler_type));
}


void gnome_scan_option_manager_register_rule_by_type (GnomeScanOptionManager* self, GType option_type, GType handler_type) {
	g_return_if_fail (self != NULL);
	g_hash_table_insert (self->priv->rules_by_type, GINT_TO_POINTER (option_type), GINT_TO_POINTER (handler_type));
}


GType gnome_scan_option_manager_get_widget_type_for (GnomeScanOptionManager* self, GnomeScanOption* option) {
	GType wtype;
	g_return_val_if_fail (self != NULL, 0UL);
	g_return_val_if_fail (option != NULL, 0UL);
	wtype = 0UL;
	wtype = GPOINTER_TO_INT (g_hash_table_lookup (self->priv->rules_by_name, gnome_scan_option_get_name (option)));
	if (wtype != G_TYPE_INVALID) {
		return wtype;
	}
	wtype = GPOINTER_TO_INT (g_hash_table_lookup (self->priv->rules_by_type, GINT_TO_POINTER (G_TYPE_FROM_INSTANCE ((GObject*) option))));
	if (wtype != G_TYPE_INVALID) {
		return wtype;
	}
	return G_TYPE_INVALID;
}


static GValue* _g_value_dup (GValue* self) {
	return g_boxed_copy (G_TYPE_VALUE, self);
}


void gnome_scan_option_manager_register_default_value (GnomeScanOptionManager* self, const char* option_name, const GValue* value) {
	GValue* _tmp0 = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (option_name != NULL);
	g_hash_table_insert (self->priv->defaults, option_name, (_tmp0 = &(*value), (_tmp0 == NULL) ? NULL : _g_value_dup (_tmp0)));
}


void gnome_scan_option_manager_register_constraint_range (GnomeScanOptionManager* self, const char* option_name, const GnomeScanRange* range) {
	GnomeScanRange* _tmp0 = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (option_name != NULL);
	g_hash_table_insert (self->priv->ranges, option_name, (_tmp0 = &(*range), (_tmp0 == NULL) ? NULL : gnome_scan_range_dup (_tmp0)));
}


void gnome_scan_option_manager_register_constraint_enum (GnomeScanOptionManager* self, const char* option_name, GSList* values) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (option_name != NULL);
	g_return_if_fail (values != NULL);
	g_hash_table_insert (self->priv->enums, option_name, g_slist_copy (values));
}


GnomeScanOptionManager* gnome_scan_option_manager_construct (GType object_type) {
	GnomeScanOptionManager * self;
	self = g_object_newv (object_type, 0, NULL);
	return self;
}


GnomeScanOptionManager* gnome_scan_option_manager_new (void) {
	return gnome_scan_option_manager_construct (GNOME_SCAN_TYPE_OPTION_MANAGER);
}


static GObject * gnome_scan_option_manager_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GnomeScanOptionManagerClass * klass;
	GObjectClass * parent_class;
	GnomeScanOptionManager * self;
	klass = GNOME_SCAN_OPTION_MANAGER_CLASS (g_type_class_peek (GNOME_SCAN_TYPE_OPTION_MANAGER));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = GNOME_SCAN_OPTION_MANAGER (obj);
	{
		GHashTable* _tmp0;
		GHashTable* _tmp1;
		GHashTable* _tmp2;
		GHashTable* _tmp3;
		GHashTable* _tmp4;
		GHashTable* _tmp5;
		_tmp0 = NULL;
		self->priv->rules_by_name = (_tmp0 = g_hash_table_new (g_str_hash, g_str_equal), (self->priv->rules_by_name == NULL) ? NULL : (self->priv->rules_by_name = (g_hash_table_unref (self->priv->rules_by_name), NULL)), _tmp0);
		_tmp1 = NULL;
		self->priv->rules_by_type = (_tmp1 = g_hash_table_new (g_direct_hash, g_direct_equal), (self->priv->rules_by_type == NULL) ? NULL : (self->priv->rules_by_type = (g_hash_table_unref (self->priv->rules_by_type), NULL)), _tmp1);
		_tmp2 = NULL;
		self->priv->options = (_tmp2 = g_hash_table_new (g_str_hash, g_str_equal), (self->priv->options == NULL) ? NULL : (self->priv->options = (g_hash_table_unref (self->priv->options), NULL)), _tmp2);
		_tmp3 = NULL;
		self->priv->defaults = (_tmp3 = g_hash_table_new (g_str_hash, g_str_equal), (self->priv->defaults == NULL) ? NULL : (self->priv->defaults = (g_hash_table_unref (self->priv->defaults), NULL)), _tmp3);
		_tmp4 = NULL;
		self->priv->ranges = (_tmp4 = g_hash_table_new (g_str_hash, g_str_equal), (self->priv->ranges == NULL) ? NULL : (self->priv->ranges = (g_hash_table_unref (self->priv->ranges), NULL)), _tmp4);
		_tmp5 = NULL;
		self->priv->enums = (_tmp5 = g_hash_table_new (g_str_hash, g_str_equal), (self->priv->enums == NULL) ? NULL : (self->priv->enums = (g_hash_table_unref (self->priv->enums), NULL)), _tmp5);
	}
	return obj;
}


static void gnome_scan_option_manager_class_init (GnomeScanOptionManagerClass * klass) {
	gnome_scan_option_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GnomeScanOptionManagerPrivate));
	G_OBJECT_CLASS (klass)->constructor = gnome_scan_option_manager_constructor;
	G_OBJECT_CLASS (klass)->finalize = gnome_scan_option_manager_finalize;
}


static void gnome_scan_option_manager_instance_init (GnomeScanOptionManager * self) {
	self->priv = GNOME_SCAN_OPTION_MANAGER_GET_PRIVATE (self);
}


static void gnome_scan_option_manager_finalize (GObject* obj) {
	GnomeScanOptionManager * self;
	self = GNOME_SCAN_OPTION_MANAGER (obj);
	(self->priv->rules_by_name == NULL) ? NULL : (self->priv->rules_by_name = (g_hash_table_unref (self->priv->rules_by_name), NULL));
	(self->priv->rules_by_type == NULL) ? NULL : (self->priv->rules_by_type = (g_hash_table_unref (self->priv->rules_by_type), NULL));
	(self->priv->options == NULL) ? NULL : (self->priv->options = (g_hash_table_unref (self->priv->options), NULL));
	(self->priv->defaults == NULL) ? NULL : (self->priv->defaults = (g_hash_table_unref (self->priv->defaults), NULL));
	(self->priv->ranges == NULL) ? NULL : (self->priv->ranges = (g_hash_table_unref (self->priv->ranges), NULL));
	(self->priv->enums == NULL) ? NULL : (self->priv->enums = (g_hash_table_unref (self->priv->enums), NULL));
	G_OBJECT_CLASS (gnome_scan_option_manager_parent_class)->finalize (obj);
}


GType gnome_scan_option_manager_get_type (void) {
	static GType gnome_scan_option_manager_type_id = 0;
	if (gnome_scan_option_manager_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (GnomeScanOptionManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gnome_scan_option_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GnomeScanOptionManager), 0, (GInstanceInitFunc) gnome_scan_option_manager_instance_init, NULL };
		gnome_scan_option_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "GnomeScanOptionManager", &g_define_type_info, 0);
	}
	return gnome_scan_option_manager_type_id;
}




