/* GNOME Scan - Scan as easy as you print
 * Copyright © 2007  Étienne Bersac <bersace03@laposte.net>
 *
 * GNOME Scan is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * GNOME Scan is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with GNOME Scan. If not, write to:
 *
 *	the Free Software Foundation, Inc.
 *	51 Franklin Street, Fifth Floor
 *	Boston, MA 02110-1301, USA
 */

#ifndef __GNOME_SCAN_BACKEND_H__
#define __GNOME_SCAN_BACKEND_H__

#include <glib.h>
#include <glib-object.h>
#include <gnome-scan-scanner.h>

G_BEGIN_DECLS


#define GNOME_SCAN_TYPE_BACKEND (gnome_scan_backend_get_type ())
#define GNOME_SCAN_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_BACKEND, GnomeScanBackend))
#define GNOME_SCAN_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_BACKEND, GnomeScanBackendClass))
#define GNOME_SCAN_IS_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_BACKEND))
#define GNOME_SCAN_IS_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_BACKEND))
#define GNOME_SCAN_BACKEND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_BACKEND, GnomeScanBackendClass))

typedef struct _GnomeScanBackend GnomeScanBackend;
typedef struct _GnomeScanBackendClass GnomeScanBackendClass;
typedef struct _GnomeScanBackendPrivate GnomeScanBackendPrivate;

struct _GnomeScanBackend {
	GObject parent_instance;
	GnomeScanBackendPrivate * priv;
};

struct _GnomeScanBackendClass {
	GObjectClass parent_class;
	void* (*probe_scanners) (GnomeScanBackend* self);
};


void* gnome_scan_backend_probe_scanners (GnomeScanBackend* self);
GType gnome_scan_backend_get_type (void);


G_END_DECLS

#endif
