/* Flegita - Scanner utility
 * Copyright © 2006-2008  Étienne Bersac <bersace@gnome.org>
 *
 * Flegita is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * Flegita is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with Flegita. If not, write to:
 *
 *	the Free Software Foundation, Inc.
 *	51 Franklin Street, Fifth Floor
 *	Boston, MA 02110-1301, USA
 */
 
using Gtk;
using Gnome.Scan;
using Flegita;

public int main(string[] args) {
	Job job;
	Gnome.Scan.Dialog dialog;
	Flegita.Sink sink;

	GLib.Environment.set_prgname("flegita");
	GLib.Environment.set_application_name(_("Scanner Utility"));

	Gnome.Scan.init(ref args);
	Gtk.init(ref args);

	Gnome.Scan.option_manager.register_rule_by_type(typeof(Flegita.OptionOutputFilename), typeof(Flegita.OutputFilenameWidget));

	sink = new Flegita.Sink();
	job = new Gnome.Scan.Job(sink);
	dialog = new Gnome.Scan.Dialog(null, job);
	dialog.run();

	return 0;
}
