/* GNOME Scan - Scan as easy as you print
 * Copyright © 2006-2008  Étienne Bersac <bersace@gnome.org>
 *
 * GNOME Scan is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * GNOME Scan is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with GNOME Scan. If not, write to:
 *
 *	the Free Software Foundation, Inc.
 *	51 Franklin Street, Fifth Floor
 *	Boston, MA 02110-1301, USA
 */

#ifndef __GNOME_SCAN_SCANNER_H__
#define __GNOME_SCAN_SCANNER_H__

#include <glib.h>
#include <glib-object.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <gegl.h>
#include <gnome-scan-node.h>

G_BEGIN_DECLS


#define GNOME_SCAN_TYPE_SCANNER (gnome_scan_scanner_get_type ())
#define GNOME_SCAN_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_SCANNER, GnomeScanScanner))
#define GNOME_SCAN_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_SCANNER, GnomeScanScannerClass))
#define GNOME_SCAN_IS_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_SCANNER))
#define GNOME_SCAN_IS_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_SCANNER))
#define GNOME_SCAN_SCANNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_SCANNER, GnomeScanScannerClass))

typedef struct _GnomeScanScanner GnomeScanScanner;
typedef struct _GnomeScanScannerClass GnomeScanScannerClass;
typedef struct _GnomeScanScannerPrivate GnomeScanScannerPrivate;

struct _GnomeScanScanner {
	GnomeScanNode parent_instance;
	GnomeScanScannerPrivate * priv;
};

struct _GnomeScanScannerClass {
	GnomeScanNodeClass parent_class;
	gboolean (*work) (GnomeScanScanner* self, double* progress);
};


gboolean gnome_scan_scanner_work (GnomeScanScanner* self, double* progress);
const char* gnome_scan_scanner_get_name (GnomeScanScanner* self);
void gnome_scan_scanner_set_name (GnomeScanScanner* self, const char* value);
const char* gnome_scan_scanner_get_blurb (GnomeScanScanner* self);
void gnome_scan_scanner_set_blurb (GnomeScanScanner* self, const char* value);
const char* gnome_scan_scanner_get_icon_name (GnomeScanScanner* self);
void gnome_scan_scanner_set_icon_name (GnomeScanScanner* self, const char* value);
GeglBuffer* gnome_scan_scanner_get_buffer (GnomeScanScanner* self);
void gnome_scan_scanner_set_buffer (GnomeScanScanner* self, GeglBuffer* value);
GType gnome_scan_scanner_get_type (void);


G_END_DECLS

#endif
