/* GNOME Scan - Scan as easy as you print
 * Copyright © 2006-2009  Étienne Bersac <bersace@gnome.org>
 *
 * GNOME Scan is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * GNOME Scan is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with GNOME Scan. If not, write to:
 *
 *	the Free Software Foundation, Inc.
 *	51 Franklin Street, Fifth Floor
 *	Boston, MA 02110-1301, USA
 */

#include <gnome-scan-page-orientation-widget.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gnome-scan-option.h>
#include <gnome-scan-common.h>




struct _GnomeScanPageOrientationWidgetPrivate {
	GHashTable* radio_map;
};

#define GNOME_SCAN_PAGE_ORIENTATION_WIDGET_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GNOME_SCAN_TYPE_PAGE_ORIENTATION_WIDGET, GnomeScanPageOrientationWidgetPrivate))
enum  {
	GNOME_SCAN_PAGE_ORIENTATION_WIDGET_DUMMY_PROPERTY
};
static void gnome_scan_page_orientation_widget_on_radio_toggled (GnomeScanPageOrientationWidget* self, GtkRadioButton* button);
static void _gnome_scan_page_orientation_widget_on_radio_toggled_gtk_toggle_button_toggled (GtkRadioButton* _sender, gpointer self);
static GObject * gnome_scan_page_orientation_widget_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static gpointer gnome_scan_page_orientation_widget_parent_class = NULL;
static void gnome_scan_page_orientation_widget_finalize (GObject* obj);



static void gnome_scan_page_orientation_widget_on_radio_toggled (GnomeScanPageOrientationWidget* self, GtkRadioButton* button) {
	GnomeScanOptionEnum* _tmp1;
	GnomeScanOption* _tmp0;
	GnomeScanOptionEnum* option;
	GnomeScanEnumValue* value;
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	if (!gtk_toggle_button_get_active ((GtkToggleButton*) button)) {
		return;
	}
	_tmp1 = NULL;
	_tmp0 = NULL;
	option = (_tmp1 = (_tmp0 = gnome_scan_option_widget_get_option ((GnomeScanOptionWidget*) self), GNOME_SCAN_IS_OPTION_ENUM (_tmp0) ? ((GnomeScanOptionEnum*) _tmp0) : NULL), (_tmp1 == NULL) ? NULL : g_object_ref (_tmp1));
	value = (GnomeScanEnumValue*) g_hash_table_lookup (self->priv->radio_map, button);
	gnome_scan_option_enum_set_value (option, &value);
	(option == NULL) ? NULL : (option = (g_object_unref (option), NULL));
}


GnomeScanPageOrientationWidget* gnome_scan_page_orientation_widget_construct (GType object_type) {
	GnomeScanPageOrientationWidget * self;
	self = g_object_newv (object_type, 0, NULL);
	return self;
}


GnomeScanPageOrientationWidget* gnome_scan_page_orientation_widget_new (void) {
	return gnome_scan_page_orientation_widget_construct (GNOME_SCAN_TYPE_PAGE_ORIENTATION_WIDGET);
}


static void _gnome_scan_page_orientation_widget_on_radio_toggled_gtk_toggle_button_toggled (GtkRadioButton* _sender, gpointer self) {
	gnome_scan_page_orientation_widget_on_radio_toggled (self, _sender);
}


static GObject * gnome_scan_page_orientation_widget_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GnomeScanPageOrientationWidgetClass * klass;
	GObjectClass * parent_class;
	GnomeScanPageOrientationWidget * self;
	klass = GNOME_SCAN_PAGE_ORIENTATION_WIDGET_CLASS (g_type_class_peek (GNOME_SCAN_TYPE_PAGE_ORIENTATION_WIDGET));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = GNOME_SCAN_PAGE_ORIENTATION_WIDGET (obj);
	{
		GHashTable* _tmp0;
		GnomeScanOptionEnum* _tmp2;
		GnomeScanOption* _tmp1;
		GnomeScanOptionEnum* option;
		GtkRadioButton* radio;
		GtkImage* icon;
		GtkLabel* label;
		GtkVBox* parent;
		GtkHBox* box;
		GtkStockItem item = {0};
		GSList* group;
		gnome_scan_option_widget_set_no_label ((GnomeScanOptionWidget*) self, TRUE);
		_tmp0 = NULL;
		self->priv->radio_map = (_tmp0 = g_hash_table_new (g_direct_hash, g_direct_equal), (self->priv->radio_map == NULL) ? NULL : (self->priv->radio_map = (g_hash_table_unref (self->priv->radio_map), NULL)), _tmp0);
		_tmp2 = NULL;
		_tmp1 = NULL;
		option = (_tmp2 = (_tmp1 = gnome_scan_option_widget_get_option ((GnomeScanOptionWidget*) self), GNOME_SCAN_IS_OPTION_ENUM (_tmp1) ? ((GnomeScanOptionEnum*) _tmp1) : NULL), (_tmp2 == NULL) ? NULL : g_object_ref (_tmp2));
		radio = NULL;
		icon = NULL;
		label = NULL;
		parent = g_object_ref_sink ((GtkVBox*) gtk_vbox_new (TRUE, 0));
		gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) parent, FALSE, TRUE, (guint) 0);
		box = NULL;
		group = NULL;
		{
			GSList* value_collection;
			GSList* value_it;
			value_collection = gnome_scan_option_enum_get_values (option);
			for (value_it = value_collection; value_it != NULL; value_it = value_it->next) {
				GnomeScanEnumValue* value;
				value = (GnomeScanEnumValue*) value_it->data;
				{
					GtkHBox* _tmp3;
					GtkImage* _tmp4;
					GtkLabel* _tmp5;
					GtkRadioButton* _tmp6;
					GtkRadioButton* _tmp7;
					_tmp3 = NULL;
					box = (_tmp3 = g_object_ref_sink ((GtkHBox*) gtk_hbox_new (FALSE, 4)), (box == NULL) ? NULL : (box = (g_object_unref (box), NULL)), _tmp3);
					/* icon*/
					_tmp4 = NULL;
					icon = (_tmp4 = g_object_ref_sink ((GtkImage*) gtk_image_new_from_stock ((*value).label, GTK_ICON_SIZE_BUTTON)), (icon == NULL) ? NULL : (icon = (g_object_unref (icon), NULL)), _tmp4);
					gtk_box_pack_start ((GtkBox*) box, (GtkWidget*) icon, FALSE, FALSE, (guint) 0);
					/* label*/
					gtk_stock_lookup ((*value).label, &item);
					_tmp5 = NULL;
					label = (_tmp5 = g_object_ref_sink ((GtkLabel*) gtk_label_new (item.label)), (label == NULL) ? NULL : (label = (g_object_unref (label), NULL)), _tmp5);
					gtk_box_pack_start ((GtkBox*) box, (GtkWidget*) label, TRUE, TRUE, (guint) 0);
					/* radio*/
					_tmp6 = NULL;
					radio = (_tmp6 = g_object_ref_sink ((GtkRadioButton*) gtk_radio_button_new (group)), (radio == NULL) ? NULL : (radio = (g_object_unref (radio), NULL)), _tmp6);
					gtk_container_add ((GtkContainer*) radio, (GtkWidget*) box);
					g_signal_connect_object ((GtkToggleButton*) radio, "toggled", (GCallback) _gnome_scan_page_orientation_widget_on_radio_toggled_gtk_toggle_button_toggled, self, 0);
					group = gtk_radio_button_get_group (radio);
					gtk_box_pack_start ((GtkBox*) parent, (GtkWidget*) radio, FALSE, TRUE, (guint) 0);
					_tmp7 = NULL;
					g_hash_table_insert (self->priv->radio_map, (_tmp7 = radio, (_tmp7 == NULL) ? NULL : g_object_ref (_tmp7)), value);
				}
			}
		}
		(option == NULL) ? NULL : (option = (g_object_unref (option), NULL));
		(radio == NULL) ? NULL : (radio = (g_object_unref (radio), NULL));
		(icon == NULL) ? NULL : (icon = (g_object_unref (icon), NULL));
		(label == NULL) ? NULL : (label = (g_object_unref (label), NULL));
		(parent == NULL) ? NULL : (parent = (g_object_unref (parent), NULL));
		(box == NULL) ? NULL : (box = (g_object_unref (box), NULL));
	}
	return obj;
}


static void gnome_scan_page_orientation_widget_class_init (GnomeScanPageOrientationWidgetClass * klass) {
	gnome_scan_page_orientation_widget_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GnomeScanPageOrientationWidgetPrivate));
	G_OBJECT_CLASS (klass)->constructor = gnome_scan_page_orientation_widget_constructor;
	G_OBJECT_CLASS (klass)->finalize = gnome_scan_page_orientation_widget_finalize;
}


static void gnome_scan_page_orientation_widget_instance_init (GnomeScanPageOrientationWidget * self) {
	self->priv = GNOME_SCAN_PAGE_ORIENTATION_WIDGET_GET_PRIVATE (self);
}


static void gnome_scan_page_orientation_widget_finalize (GObject* obj) {
	GnomeScanPageOrientationWidget * self;
	self = GNOME_SCAN_PAGE_ORIENTATION_WIDGET (obj);
	(self->priv->radio_map == NULL) ? NULL : (self->priv->radio_map = (g_hash_table_unref (self->priv->radio_map), NULL));
	G_OBJECT_CLASS (gnome_scan_page_orientation_widget_parent_class)->finalize (obj);
}


GType gnome_scan_page_orientation_widget_get_type (void) {
	static GType gnome_scan_page_orientation_widget_type_id = 0;
	if (gnome_scan_page_orientation_widget_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (GnomeScanPageOrientationWidgetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gnome_scan_page_orientation_widget_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GnomeScanPageOrientationWidget), 0, (GInstanceInitFunc) gnome_scan_page_orientation_widget_instance_init, NULL };
		gnome_scan_page_orientation_widget_type_id = g_type_register_static (GNOME_SCAN_TYPE_OPTION_WIDGET, "GnomeScanPageOrientationWidget", &g_define_type_info, 0);
	}
	return gnome_scan_page_orientation_widget_type_id;
}




