/* GNOME Scan - Scan as easy as you print
 * Copyright © 2006-2008  Étienne Bersac <bersace@gnome.org>
 *
 * GNOME Scan is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * GNOME Scan is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with GNOME Scan. If not, write to:
 *
 *	the Free Software Foundation, Inc.
 *	51 Franklin Street, Fifth Floor
 *	Boston, MA 02110-1301, USA
 */

#ifndef __GNOME_SCAN_OPTION_PAGE_H__
#define __GNOME_SCAN_OPTION_PAGE_H__

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gnome-scan-option.h>

G_BEGIN_DECLS


#define GNOME_SCAN_TYPE_OPTION_PAGE (gnome_scan_option_page_get_type ())
#define GNOME_SCAN_OPTION_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_OPTION_PAGE, GnomeScanOptionPage))
#define GNOME_SCAN_OPTION_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_OPTION_PAGE, GnomeScanOptionPageClass))
#define GNOME_SCAN_IS_OPTION_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_OPTION_PAGE))
#define GNOME_SCAN_IS_OPTION_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_OPTION_PAGE))
#define GNOME_SCAN_OPTION_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_OPTION_PAGE, GnomeScanOptionPageClass))

typedef struct _GnomeScanOptionPage GnomeScanOptionPage;
typedef struct _GnomeScanOptionPageClass GnomeScanOptionPageClass;
typedef struct _GnomeScanOptionPagePrivate GnomeScanOptionPagePrivate;

#define GNOME_SCAN_TYPE_OPTION_VPAGE (gnome_scan_option_vpage_get_type ())
#define GNOME_SCAN_OPTION_VPAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_OPTION_VPAGE, GnomeScanOptionVPage))
#define GNOME_SCAN_OPTION_VPAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_OPTION_VPAGE, GnomeScanOptionVPageClass))
#define GNOME_SCAN_IS_OPTION_VPAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_OPTION_VPAGE))
#define GNOME_SCAN_IS_OPTION_VPAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_OPTION_VPAGE))
#define GNOME_SCAN_OPTION_VPAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_OPTION_VPAGE, GnomeScanOptionVPageClass))

typedef struct _GnomeScanOptionVPage GnomeScanOptionVPage;
typedef struct _GnomeScanOptionVPageClass GnomeScanOptionVPageClass;
typedef struct _GnomeScanOptionVPagePrivate GnomeScanOptionVPagePrivate;

#define GNOME_SCAN_TYPE_OPTION_HPAGE (gnome_scan_option_hpage_get_type ())
#define GNOME_SCAN_OPTION_HPAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_OPTION_HPAGE, GnomeScanOptionHPage))
#define GNOME_SCAN_OPTION_HPAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_OPTION_HPAGE, GnomeScanOptionHPageClass))
#define GNOME_SCAN_IS_OPTION_HPAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_OPTION_HPAGE))
#define GNOME_SCAN_IS_OPTION_HPAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_OPTION_HPAGE))
#define GNOME_SCAN_OPTION_HPAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_OPTION_HPAGE, GnomeScanOptionHPageClass))

typedef struct _GnomeScanOptionHPage GnomeScanOptionHPage;
typedef struct _GnomeScanOptionHPageClass GnomeScanOptionHPageClass;
typedef struct _GnomeScanOptionHPagePrivate GnomeScanOptionHPagePrivate;

/* waiting for Gtk+ 2.16 for extendings directly Gtk.Box :)*/
struct _GnomeScanOptionPage {
	GtkAlignment parent_instance;
	GnomeScanOptionPagePrivate * priv;
};

struct _GnomeScanOptionPageClass {
	GtkAlignmentClass parent_class;
};

struct _GnomeScanOptionVPage {
	GnomeScanOptionPage parent_instance;
	GnomeScanOptionVPagePrivate * priv;
};

struct _GnomeScanOptionVPageClass {
	GnomeScanOptionPageClass parent_class;
};

struct _GnomeScanOptionHPage {
	GnomeScanOptionPage parent_instance;
	GnomeScanOptionHPagePrivate * priv;
};

struct _GnomeScanOptionHPageClass {
	GnomeScanOptionPageClass parent_class;
};


void gnome_scan_option_page_pack_option (GnomeScanOptionPage* self, GnomeScanOption* option);
void gnome_scan_option_page_unpack_option (GnomeScanOptionPage* self, GnomeScanOption* option);
gboolean gnome_scan_option_page_get_scrolled (GnomeScanOptionPage* self);
void gnome_scan_option_page_set_scrolled (GnomeScanOptionPage* self, gboolean value);
GtkBox* gnome_scan_option_page_get_container (GnomeScanOptionPage* self);
void gnome_scan_option_page_set_container (GnomeScanOptionPage* self, GtkBox* value);
GType gnome_scan_option_page_get_type (void);
GnomeScanOptionVPage* gnome_scan_option_vpage_construct (GType object_type, gboolean scrolled);
GnomeScanOptionVPage* gnome_scan_option_vpage_new (gboolean scrolled);
GType gnome_scan_option_vpage_get_type (void);
GnomeScanOptionHPage* gnome_scan_option_hpage_construct (GType object_type);
GnomeScanOptionHPage* gnome_scan_option_hpage_new (void);
GType gnome_scan_option_hpage_get_type (void);


G_END_DECLS

#endif
