/* GNOME Scan - Scan as easy as you print
 * Copyright © 2006-2008  Étienne Bersac <bersace@gnome.org>
 *
 * GNOME Scan is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * GNOME Scan is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with GNOME Scan. If not, write to:
 *
 *	the Free Software Foundation, Inc.
 *	51 Franklin Street, Fifth Floor
 *	Boston, MA 02110-1301, USA
 */

#include <gnome-scan-node.h>
#include <glib/gi18n-lib.h>




struct _GnomeScanNodePrivate {
	GnomeScanStatus _status;
	char* _message;
	GSList* _options;
	GSList* _nodes;
};

#define GNOME_SCAN_NODE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GNOME_SCAN_TYPE_NODE, GnomeScanNodePrivate))
enum  {
	GNOME_SCAN_NODE_DUMMY_PROPERTY,
	GNOME_SCAN_NODE_STATUS,
	GNOME_SCAN_NODE_MESSAGE,
	GNOME_SCAN_NODE_OPTIONS,
	GNOME_SCAN_NODE_NODES
};
static void _g_slist_free_g_object_unref (GSList* self);
static void gnome_scan_node_real_start_scan (GnomeScanNode* self);
static gboolean gnome_scan_node_real_start_image (GnomeScanNode* self);
static void gnome_scan_node_real_end_image (GnomeScanNode* self);
static void gnome_scan_node_real_end_scan (GnomeScanNode* self);
static GObject * gnome_scan_node_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static gpointer gnome_scan_node_parent_class = NULL;
static void gnome_scan_node_finalize (GObject* obj);



static void _g_slist_free_g_object_unref (GSList* self) {
	g_slist_foreach (self, (GFunc) g_object_unref, NULL);
	g_slist_free (self);
}


static void gnome_scan_node_real_start_scan (GnomeScanNode* self) {
	g_return_if_fail (self != NULL);
}


void gnome_scan_node_start_scan (GnomeScanNode* self) {
	GNOME_SCAN_NODE_GET_CLASS (self)->start_scan (self);
}


/* scanner returns true whend new image is to acquire. Allows
 nodes to prepare next image (e.g. next filename, next page
 in pdf, etc.) for multi-image acquisition*/
static gboolean gnome_scan_node_real_start_image (GnomeScanNode* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return FALSE;
}


gboolean gnome_scan_node_start_image (GnomeScanNode* self) {
	return GNOME_SCAN_NODE_GET_CLASS (self)->start_image (self);
}


static void gnome_scan_node_real_end_image (GnomeScanNode* self) {
	g_return_if_fail (self != NULL);
}


void gnome_scan_node_end_image (GnomeScanNode* self) {
	GNOME_SCAN_NODE_GET_CLASS (self)->end_image (self);
}


static void gnome_scan_node_real_end_scan (GnomeScanNode* self) {
	g_return_if_fail (self != NULL);
}


void gnome_scan_node_end_scan (GnomeScanNode* self) {
	GNOME_SCAN_NODE_GET_CLASS (self)->end_scan (self);
}


/* Let message to null and the message will be determined from
 status.*/
void gnome_scan_node_update_status (GnomeScanNode* self, GnomeScanStatus status, const char* message) {
	g_return_if_fail (self != NULL);
	if (message == NULL) {
		switch (status) {
			case GNOME_SCAN_STATUS_UNKNOWN:
			{
				gnome_scan_node_set_message (self, _ ("Unknown"));
				break;
			}
			case GNOME_SCAN_STATUS_FAILED:
			{
				gnome_scan_node_set_message (self, _ ("Failed"));
				break;
			}
			case GNOME_SCAN_STATUS_INITIALIZING:
			{
				gnome_scan_node_set_message (self, _ ("Initializing"));
				break;
			}
			case GNOME_SCAN_STATUS_UNCONFIGURED:
			{
				gnome_scan_node_set_message (self, _ ("Unconfigured"));
				break;
			}
			case GNOME_SCAN_STATUS_READY:
			{
				gnome_scan_node_set_message (self, _ ("Ready"));
				break;
			}
			case GNOME_SCAN_STATUS_PROCESSING:
			{
				gnome_scan_node_set_message (self, _ ("Processing"));
				break;
			}
			case GNOME_SCAN_STATUS_DONE:
			{
				gnome_scan_node_set_message (self, _ ("Done"));
				break;
			}
		}
	} else {
		gnome_scan_node_set_message (self, message);
	}
	gnome_scan_node_set_status (self, status);
}


void gnome_scan_node_install_option (GnomeScanNode* self, GnomeScanOption* option) {
	GnomeScanOption* _tmp0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (option != NULL);
	_tmp0 = NULL;
	self->priv->_options = g_slist_append (self->priv->_options, (_tmp0 = option, (_tmp0 == NULL) ? NULL : g_object_ref (_tmp0)));
}


void gnome_scan_node_append_node (GnomeScanNode* self, GeglNode* node) {
	GeglNode* _tmp0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	_tmp0 = NULL;
	self->priv->_nodes = g_slist_append (self->priv->_nodes, (_tmp0 = node, (_tmp0 == NULL) ? NULL : g_object_ref (_tmp0)));
}


/* notify ?*/
void gnome_scan_node_remove_node (GnomeScanNode* self, GeglNode* node) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	self->priv->_nodes = g_slist_remove (self->priv->_nodes, node);
}


GnomeScanStatus gnome_scan_node_get_status (GnomeScanNode* self) {
	g_return_val_if_fail (self != NULL, 0);
	return self->priv->_status;
}


void gnome_scan_node_set_status (GnomeScanNode* self, GnomeScanStatus value) {
	g_return_if_fail (self != NULL);
	self->priv->_status = value;
	g_object_notify ((GObject *) self, "status");
}


const char* gnome_scan_node_get_message (GnomeScanNode* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_message;
}


void gnome_scan_node_set_message (GnomeScanNode* self, const char* value) {
	char* _tmp2;
	const char* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_message = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : g_strdup (_tmp1)), self->priv->_message = (g_free (self->priv->_message), NULL), _tmp2);
	g_object_notify ((GObject *) self, "message");
}


GSList* gnome_scan_node_get_options (GnomeScanNode* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_options;
}


GSList* gnome_scan_node_get_nodes (GnomeScanNode* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_nodes;
}


static GObject * gnome_scan_node_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GnomeScanNodeClass * klass;
	GObjectClass * parent_class;
	GnomeScanNode * self;
	klass = GNOME_SCAN_NODE_CLASS (g_type_class_peek (GNOME_SCAN_TYPE_NODE));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = GNOME_SCAN_NODE (obj);
	{
		gnome_scan_node_update_status (self, GNOME_SCAN_STATUS_INITIALIZING, NULL);
	}
	return obj;
}


static void gnome_scan_node_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GnomeScanNode * self;
	gpointer boxed;
	self = GNOME_SCAN_NODE (object);
	switch (property_id) {
		case GNOME_SCAN_NODE_STATUS:
		g_value_set_enum (value, gnome_scan_node_get_status (self));
		break;
		case GNOME_SCAN_NODE_MESSAGE:
		g_value_set_string (value, gnome_scan_node_get_message (self));
		break;
		case GNOME_SCAN_NODE_OPTIONS:
		g_value_set_pointer (value, gnome_scan_node_get_options (self));
		break;
		case GNOME_SCAN_NODE_NODES:
		g_value_set_pointer (value, gnome_scan_node_get_nodes (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gnome_scan_node_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GnomeScanNode * self;
	self = GNOME_SCAN_NODE (object);
	switch (property_id) {
		case GNOME_SCAN_NODE_STATUS:
		gnome_scan_node_set_status (self, g_value_get_enum (value));
		break;
		case GNOME_SCAN_NODE_MESSAGE:
		gnome_scan_node_set_message (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gnome_scan_node_class_init (GnomeScanNodeClass * klass) {
	gnome_scan_node_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GnomeScanNodePrivate));
	G_OBJECT_CLASS (klass)->get_property = gnome_scan_node_get_property;
	G_OBJECT_CLASS (klass)->set_property = gnome_scan_node_set_property;
	G_OBJECT_CLASS (klass)->constructor = gnome_scan_node_constructor;
	G_OBJECT_CLASS (klass)->finalize = gnome_scan_node_finalize;
	GNOME_SCAN_NODE_CLASS (klass)->start_scan = gnome_scan_node_real_start_scan;
	GNOME_SCAN_NODE_CLASS (klass)->start_image = gnome_scan_node_real_start_image;
	GNOME_SCAN_NODE_CLASS (klass)->end_image = gnome_scan_node_real_end_image;
	GNOME_SCAN_NODE_CLASS (klass)->end_scan = gnome_scan_node_real_end_scan;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_SCAN_NODE_STATUS, g_param_spec_enum ("status", "status", "status", GNOME_SCAN_TYPE_STATUS, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_SCAN_NODE_MESSAGE, g_param_spec_string ("message", "message", "message", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_SCAN_NODE_OPTIONS, g_param_spec_pointer ("options", "options", "options", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_SCAN_NODE_NODES, g_param_spec_pointer ("nodes", "nodes", "nodes", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void gnome_scan_node_instance_init (GnomeScanNode * self) {
	self->priv = GNOME_SCAN_NODE_GET_PRIVATE (self);
}


static void gnome_scan_node_finalize (GObject* obj) {
	GnomeScanNode * self;
	self = GNOME_SCAN_NODE (obj);
	self->priv->_message = (g_free (self->priv->_message), NULL);
	(self->priv->_options == NULL) ? NULL : (self->priv->_options = (_g_slist_free_g_object_unref (self->priv->_options), NULL));
	(self->priv->_nodes == NULL) ? NULL : (self->priv->_nodes = (_g_slist_free_g_object_unref (self->priv->_nodes), NULL));
	G_OBJECT_CLASS (gnome_scan_node_parent_class)->finalize (obj);
}


GType gnome_scan_node_get_type (void) {
	static GType gnome_scan_node_type_id = 0;
	if (gnome_scan_node_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (GnomeScanNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gnome_scan_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GnomeScanNode), 0, (GInstanceInitFunc) gnome_scan_node_instance_init, NULL };
		gnome_scan_node_type_id = g_type_register_static (G_TYPE_OBJECT, "GnomeScanNode", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	}
	return gnome_scan_node_type_id;
}




