/* Gnome Scan - Scan as easy as you print
 * Copyright © 2007  Étienne Bersac <bersace03@laposte.net>
 *
 * Gnome Scan is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * gnome-scan is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with gnome-scan.  If not, write to:
 *
 *	the Free Software Foundation, Inc.
 *	51 Franklin Street, Fifth Floor
 *	Boston, MA 02110-1301, USA
 */

#ifndef _GNOME_SCAN_PARAM_WIDGET_H_
#define _GNOME_SCAN_PARAM_WIDGET_H_

#include <glib-object.h>
#include <gtk/gtk.h>
#include "gnome-scan-settings.h"
#include "gnome-scan-plugin.h"

G_BEGIN_DECLS

#define GNOME_TYPE_SCAN_PARAM_WIDGET             (gnome_scan_param_widget_get_type ())
#define GNOME_SCAN_PARAM_WIDGET(obj)             (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_TYPE_SCAN_PARAM_WIDGET, GnomeScanParamWidget))
#define GNOME_SCAN_PARAM_WIDGET_CLASS(klass)     (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_TYPE_SCAN_PARAM_WIDGET, GnomeScanParamWidgetClass))
#define GNOME_IS_SCAN_PARAM_WIDGET(obj)          (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_TYPE_SCAN_PARAM_WIDGET))
#define GNOME_IS_SCAN_PARAM_WIDGET_CLASS(klass)  (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_TYPE_SCAN_PARAM_WIDGET))
#define GNOME_SCAN_PARAM_WIDGET_GET_CLASS(obj)   (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_TYPE_SCAN_PARAM_WIDGET, GnomeScanParamWidgetClass))

#define GS_DEFINE_PARAM_WIDGET(TypeName, type_name)			\
  G_DEFINE_TYPE(TypeName, type_name, GNOME_TYPE_SCAN_PARAM_WIDGET)	\
									\
  static void type_name##_finalize (GObject *object);			\
  static void type_name##_build (GnomeScanParamWidget *widget);		\
  static void type_name##_set (GnomeScanParamWidget *widget, GValue *value); \
  static void								\
  type_name##_class_init (TypeName##Class *klass) {			\
    GObjectClass* object_class = G_OBJECT_CLASS (klass);		\
    g_type_class_add_private(object_class, sizeof (TypeName##Private)); \
    GnomeScanParamWidgetClass *parent_class = GNOME_SCAN_PARAM_WIDGET_CLASS (klass); \
    parent_class->build   = type_name##_build;				\
    parent_class->set     = type_name##_set;				\
    object_class->finalize = type_name##_finalize;			\
  }
    
#define	GS_DEFINE_PARAM_WIDGET_HEADER(TypeName, type_name)	\
  typedef struct _##TypeName##Class TypeName##Class;		\
								\
  struct _##TypeName##Class					\
  {								\
    GnomeScanParamWidgetClass parent_class;			\
  };								\
  GType type_name##_get_type (void) G_GNUC_CONST;


typedef struct _GnomeScanParamWidgetClass GnomeScanParamWidgetClass;
typedef struct _GnomeScanParamWidget GnomeScanParamWidget;

struct _GnomeScanParamWidgetClass
{
  GtkHBoxClass parent_class;

  /* Interface */
  void  (* build)   (GnomeScanParamWidget *widget);
  void  (* show)    (GnomeScanParamWidget *widget);
  void  (* set)	    (GnomeScanParamWidget *gspw, GValue *value);
};

struct _GnomeScanParamWidget
{
  /*< private >*/
  GtkHBox parent_instance;
	
  /*< public >*/
  GnomeScanSettings*	settings;
  GnomeScanPlugin*	plugin;
  GParamSpec		*pspec;
  GValue		*value;

  gboolean		shows_label;
  gboolean		expands;
  gboolean		shows_unit;
};

GType gnome_scan_param_widget_get_type (void) G_GNUC_CONST;
GtkWidget* gnome_scan_param_widget_new (GnomeScanSettings *settings,
					GnomeScanPlugin *plugin,
					GParamSpec *pspec);
GParamSpec* gnome_scan_param_widget_get_param_spec (GnomeScanParamWidget *widget);
void gnome_scan_param_widget_set_value (GnomeScanParamWidget *widget, GValue *value);
GValue* gnome_scan_param_widget_get_value (GnomeScanParamWidget *widget);
void	gnome_scan_param_widget_changed (GnomeScanParamWidget *widget);
gboolean gnome_scan_param_widget_shows_label (GnomeScanParamWidget *widget);
gboolean gnome_scan_param_widget_expands (GnomeScanParamWidget *widget);

G_END_DECLS

#endif /* _GNOME_SCAN_PARAM_WIDGET_H_ */
