/* GnomeScan - Gnome Scanning Infrastructure
 *
 * gnome-scanbackend.h
 *
 * Copyright © 2006 Étienne Bersac
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

/**
 * SECTION:gnomescanbackend
 * @short_description: The glue between SANE and GnomeScan APIs
 *
 * Just remember that : YOU MUST NOT USE #GnomeScanBackend !
 *
 * #GnomeScanBackend is actually a glib-ish SANE wrapper. SANE has a
 * procedural API that does not fit the glib GObject paradigm. The
 * backend retreive data from the backend and convert them into glib
 * type such as the one declared by the GnomeScan. For example, the
 * #GnomeScanBackend is responsible to instanciate all #GnomeScanner
 * and #GnomeScannerOption. #GnomeScanBackend also convert raw data
 * into #GdkPixbuf.
 **/

#ifndef __GNOME_SCAN_BACKEND_H__
#define __GNOME_SCAN_BACKEND_H__


#include <glib.h>
#include <glib-object.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include "gnomescantypes.h"
#include "gnomescantypebuiltins.h"
#include "gnomescanner.h"
#include "gnomescanneroption.h"

G_BEGIN_DECLS

#define	GNOME_TYPE_SCAN_BACKEND			(gnome_scan_backend_get_type ())
#define GNOME_SCAN_BACKEND(obj)			(G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_TYPE_SCAN_BACKEND, GnomeScanBackend))
#define GNOME_SCAN_BACKEND_CLASS(klass)		(G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_TYPE_SCAN_BACKEND, GnomeScanBackendClass))
#define GNOME_IS_SCAN_BACKEND(obj)		(G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_TYPE_SCAN_BACKEND))
#define GNOME_IS_SCAN_BACKEND_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_TYPE_SCAN_BACKEND))
#define GNOME_SCAN_BACKEND_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_TYPE_SCAN_BACKEND, GnomeScanBackendClass))

typedef struct _GnomeScanBackend		GnomeScanBackend;
typedef struct _GnomeScanBackendClass		GnomeScanBackendClass;

struct _GnomeScanBackend {
  GObject			parent;
};

struct _GnomeScanBackendClass {
  GObjectClass			parent;

  /* SIGNALS */
  void (* data_received)		(GnomeScanBackend *backend,
					 gsize *sizes,
					 gpointer data);

  void (* image_acquired)		(GnomeScanBackend *backend,
					 GnomeScanResult *result,
					 gpointer data);
};

enum {
  GNOME_SCAN_BACKEND_ERROR_UNSUPPORTED_SANE_VERSION,
  GNOME_SCAN_BACKEND_ERROR_SANE_ERROR,
  GNOME_SCAN_BACKEND_ERROR_FAILED
};

GType				gnome_scan_backend_get_type		(void) G_GNUC_CONST;

GnomeScanBackend*		gnome_scan_backend_new 			(GError **error);
void				gnome_scan_backend_destroy 		(GnomeScanBackend *backend);
GSList*				gnome_scan_backend_probe_scanners	(GnomeScanBackend *backend,
									 GError **error);
GnomeScanForecast*		gnome_scan_backend_forecast		(GnomeScanBackend *backend,
									 GnomeScanContextInfo *info,
									 GError **error);
void				gnome_scan_backend_acquire		(GnomeScanBackend *backend,
									 GnomeScanContextInfo *info,
									 GError **error);
void				gnome_scan_backend_stop			(GnomeScanBackend *backend,
									 GnomeScanner *scanner);

G_END_DECLS

#endif
