/*
 *
 * gnomescanneroption.h
 *
 * Copyright © 2006 Étienne Bersac
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

/**
 * SECTION:gnomescanneroption
 * @short_description: An object representing a device option
 * @see_also: #GnomeScanner, #GnomeScannerOptionSet
 *
 * Each devices has a variable list of options. Each option is
 * represented by a GnomeScannerOption widget which hold meta-data and
 * data concerning one option. This object must be instanciate only by
 * the #GnomeScanBackend.
 *
 * The GnomeScan project distinguish two kind of options. Device
 * options and Scan options. #GnomeScannerOption handle both because
 * of a sane heritage. This is not intend to continue like
 * this. Device option are light management and such. They are un
 * common and often misdocumented. Applications must not us
 * #GnomeScannerOption to handle Scan option such as resolution or
 * area, because #GnomeScannerOption depend on one device. If the user
 * choose another device, option value is lost. See #GnomeScanContext
 * to handle Scan options.
 *
 **/

#ifndef GNOME_SCANNER_OPTION_H
#define GNOME_SCANNER_OPTION_H

#include <glib.h>
#include <glib-object.h>
#include "gnomescantypes.h"
#include "gnomescanutils.h"

#define	GNOME_TYPE_SCANNER_OPTION		(gnome_scanner_option_get_type ())
#define GNOME_SCANNER_OPTION(obj)		(G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_TYPE_SCANNER_OPTION, GnomeScannerOption))
#define GNOME_SCANNER_OPTION_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_TYPE_SCANNER_OPTION, GnomeScannerOptionClass))
#define GNOME_IS_SCANNER_OPTION(obj)		(G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_TYPE_SCANNER_OPTION))
#define GNOME_IS_SCANNER_OPTION_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_TYPE_SCANNER_OPTION))
#define GNOME_SCANNER_OPTION_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_TYPE_SCANNER_OPTION, GnomeScannerOptionClass))

typedef struct _GnomeScannerOption		GnomeScannerOption;
typedef struct _GnomeScannerOptionClass		GnomeScannerOptionClass;

typedef enum {
  GNOME_SCANNER_OPTION_READONLY 	= 1 << 0,
  GNOME_SCANNER_OPTION_INACTIVE		= 1 << 1,
  GNOME_SCANNER_OPTION_ADVANCED		= 1 << 2,
  GNOME_SCANNER_OPTION_AUTOMATIC	= 1 << 3,
  GNOME_SCANNER_OPTION_ENUMERATION	= 1 << 4,
  GNOME_SCANNER_OPTION_RANGE		= 1 << 5,
  /* Emulated ? soft detect ? */
} GnomeScannerOptionFlags;

struct _GnomeScannerOption {
  GObject			parent;
  const gchar			*name;
  const gchar			*title;
  const gchar			*desc;
  GnomeScanUnit			unit;
  GnomeScannerOptionConstraint	*constraint;
  GnomeScannerOptionFlags	flags;
};

struct _GnomeScannerOptionClass {

  GObjectClass			parent;
  /* SIGNALS */
  void		(*changed)	(GnomeScannerOption *option,
				 gpointer data);
};

typedef enum {
  GNOME_SCANNER_OPTION_ERROR_FAILED
} GnomeScannerOptionError;

/* GObject functions */
GType					gnome_scanner_option_get_type 			(void);

/* Methods */

gint					gnome_scanner_option_get_int			(GnomeScannerOption *option);
void					gnome_scanner_option_set_int			(GnomeScannerOption *option,
											 gint value);

gfloat					gnome_scanner_option_get_float			(GnomeScannerOption *option);
void					gnome_scanner_option_set_float			(GnomeScannerOption *option,
											 gfloat value);

/* Properties */
gpointer				gnome_scanner_option_get_id 			(GnomeScannerOption *option);
const gchar*				gnome_scanner_option_get_name 			(GnomeScannerOption *option);
const gchar*				gnome_scanner_option_get_title 			(GnomeScannerOption *option);
const gchar*				gnome_scanner_option_get_desc 			(GnomeScannerOption *option);
GValue*					gnome_scanner_option_get_value 			(GnomeScannerOption *option);
GType					gnome_scanner_option_get_value_type		(GnomeScannerOption *option);
GnomeScannerOptionFlags			gnome_scanner_option_get_flags			(GnomeScannerOption *option);

GnomeScanUnit				gnome_scanner_option_get_unit			(GnomeScannerOption *option);

GnomeScannerOptionConstraint*		gnome_scanner_option_get_constraint		(GnomeScannerOption *option);

void					gnome_scanner_option_set_value 			(GnomeScannerOption *option,
											 GValue *value);
#endif
