/* GnomeScanUI - Widgets for scan dialogs
 *
 * gnomescanui.h
 * 
 * Copyright © 2006 Étienne Bersac
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

/**
 * SECTION:gnomescanui
 * @title: Icons
 * @short_description: Stock icons and UI initialisation
 *
 * GnomeScan UI provide stocks icons and icons for each devices types
 * and scan actions. All this icons aren't usable unless you call
 * gnome_scan_ui_init(). A Gnome module (like LIBGNOMEUI_MODULE) would
 * be a nicer solution.
 */


#ifndef	__GNOME_SCAN_UI_H__
#define	__GNOME_SCAN_UI_H__

#include <gnomescanacquisitiondialog.h>
#include <gnomescanadvancedpreview.h>
#include <gnomescandialog.h>
#include <gnomescannerselector.h>
#include <gnomescanoptionwidget.h>
#include <gnomescanpreview.h>
#include <gnomescanpreviewarea.h>
#include <gnomescanresolutionselector.h>
#include <gnomescansourceselector.h>

/**
 * GS_STOCK_ROTATE_COUNTER_CLOCKWISE
 *
 */
#define GS_STOCK_ROTATE_COUNTER_CLOCKWISE	"rotate-90"
#define	GS_STOCK_ROTATE_CLOCKWISE		"rotate-270"
#define	GS_STOCK_SCAN		                "scan"

void		gnome_scan_ui_init	(void);

#endif  /* ! __GNOME_SCAN_UI_H__ */
