/* GnomeScanUI - Widgets for scan dialogs
 *
 * gnomescanpreview.c
 *
 * Copyright © 2006 Étienne Bersac
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include <gnomescan.h>
#include "gnomescanui.h"
#include "gnomescanui-intl.h"

#define GNOME_SCAN_PREVIEW_ERROR		(g_type_qname (GNOME_TYPE_SCAN_PREVIEW))
#define	GNOME_SCAN_PREVIEW_PARENT_CLASS(klass)	(GTK_WIDGET_CLASS (g_type_class_peek_parent ((klass))))
#define GET_PRIVATE(obj)			(G_TYPE_INSTANCE_GET_PRIVATE ((obj), GNOME_TYPE_SCAN_PREVIEW, GnomeScanPreviewPrivate))

typedef struct _GnomeScanPreviewPrivate		GnomeScanPreviewPrivate;

struct _GnomeScanPreviewPrivate {
  gboolean		dispose_has_run;
  GtkWidget		*area;
};

enum {
  PROP_0,
  PROP_CONTEXT
};

enum {
  N_SIGNALS
};

static guint signals[N_SIGNALS];

void				gsp_refresh_clicked					(GtkButton *button,
										 GnomeScanPreview *preview);

/* GOBJECTS */
void				gnome_scan_preview_dispose			(GObject *obj);

void				gnome_scan_preview_set_property 		(GObject *obj,
										 guint property_id,
										 const GValue *value,
										 GParamSpec *pspec);

void				gnome_scan_preview_get_property 		(GObject *obj,
										 guint property_id,
										 GValue *value,
										 GParamSpec *pspec);


/********************************
 * 	      GOBJECT		*
 ********************************/

G_DEFINE_TYPE (GnomeScanPreview, gnome_scan_preview, GTK_TYPE_VBOX);

void
gnome_scan_preview_class_init (GnomeScanPreviewClass *klass)
{
  GObjectClass* gobject_class = G_OBJECT_CLASS (klass);

  gobject_class->set_property = gnome_scan_preview_set_property;
  gobject_class->get_property = gnome_scan_preview_get_property;
  gobject_class->dispose 	= gnome_scan_preview_dispose;
  /*   gobject_class->finalize 	= gnome_scan_preview_finalize; */

  g_type_class_add_private (gobject_class, sizeof (GnomeScanPreviewPrivate));

  /* Properties */

  g_object_class_install_property (gobject_class,
				   PROP_CONTEXT,
				   g_param_spec_object ("context",
							"Context",
							"The GnomeScanContext the widget is connected to.",
							GNOME_TYPE_SCAN_CONTEXT,
							G_PARAM_READWRITE));
}

void
gnome_scan_preview_init (GnomeScanPreview *widget)
{
  GnomeScanPreviewPrivate *priv = GET_PRIVATE (widget);

  widget->context = NULL;

  priv->dispose_has_run = FALSE;
  priv->area = NULL;
}

void
gnome_scan_preview_dispose (GObject *obj)
{
  GnomeScanPreview *widget = GNOME_SCAN_PREVIEW (obj);
  GnomeScanPreviewPrivate *priv = GET_PRIVATE (widget);
  GnomeScanPreviewClass *b_klass = GNOME_SCAN_PREVIEW_GET_CLASS (obj);

  /* That would be nice if g_return_if_fail were noiseless. */
  if (priv->dispose_has_run == TRUE) {
    return;
  }

  /* unref devices */
  g_object_unref (widget->context);
  g_object_unref (priv->area);
  priv->dispose_has_run = TRUE;

  /* chain */
  /*   GNOME_SCAN_PREVIEW_PARENT_CLASS (b_klass)->dispose (obj); */
}

void
gnome_scan_preview_set_property (GObject *obj,
				 guint property_id,
				 const GValue *value,
				 GParamSpec *pspec)
{
  GnomeScanPreview *preview = GNOME_SCAN_PREVIEW (obj);

  switch (property_id) {
  case PROP_CONTEXT:
    preview->context = GNOME_SCAN_CONTEXT (g_value_dup_object (value));
    break;
  default:
    G_OBJECT_WARN_INVALID_PROPERTY_ID(obj,
				      property_id,
				      pspec);
    break;
  }
}

void
gnome_scan_preview_get_property (GObject *obj,
				 guint property_id,
				 GValue *value,
				 GParamSpec *pspec)
{
  GnomeScanPreview *preview = GNOME_SCAN_PREVIEW (obj);

  switch (property_id) {
  case PROP_CONTEXT:
    g_value_set_object (value, preview->context);
    break;
  default:
    G_OBJECT_WARN_INVALID_PROPERTY_ID(obj,
				      property_id,
				      pspec);
    break;
  }
}



/********************************
 * 	      METHODS		*
 ********************************/

/**
 * gnome_scan_preview_new:
 * @context: a #GnomeScanContext
 * 
 * Create a new #GnomeScanPreview widget connected to @context.
 * 
 * Return value: a new #GnomeScanPreview
 */
GtkWidget*
gnome_scan_preview_new (GnomeScanContext *context)
{
  GnomeScanPreview *gsp;
  GnomeScanPreviewPrivate *priv;
  GtkWidget *widget, *toolbar, *pa, *ruler;
  GtkToolItem *item;

  widget = GTK_WIDGET (g_object_new (GNOME_TYPE_SCAN_PREVIEW,	
				     "context", context,
				     NULL));

  gsp = GNOME_SCAN_PREVIEW (widget);
  priv = GET_PRIVATE (gsp);

  gtk_box_set_spacing (GTK_BOX (gsp), 0);

  /* PREVIEW AREA */
  pa = gnome_scan_preview_area_new (context);
  priv->area = pa;

  gtk_box_pack_end (GTK_BOX (gsp),
		    pa,
		    TRUE, TRUE,	0);

  /* TOOLBAR */
  toolbar = gtk_toolbar_new ();

  gtk_box_pack_start (GTK_BOX (gsp),
		      toolbar,
		      FALSE, TRUE, 0);

  item = gtk_tool_button_new_from_stock (GTK_STOCK_REFRESH);

  g_signal_connect (GTK_TOOL_BUTTON (item),
		    "clicked",
		    G_CALLBACK (gsp_refresh_clicked),
		    gsp);

  gtk_toolbar_insert (GTK_TOOLBAR (toolbar),
		      item, -1);

  item = gtk_tool_button_new_from_stock (GS_STOCK_ROTATE_COUNTER_CLOCKWISE);
  gtk_toolbar_insert (GTK_TOOLBAR (toolbar),
		      item, -1);

  g_signal_connect_swapped (GTK_TOOL_BUTTON (item),
			    "clicked",
			    G_CALLBACK (GNOME_SCAN_PREVIEW_AREA_GET_CLASS (pa)->rotate_counter_clockwise_clicked),
			    pa);

  item = gtk_tool_button_new_from_stock (GS_STOCK_ROTATE_CLOCKWISE);

  gtk_toolbar_insert (GTK_TOOLBAR (toolbar),
		      item, -1);

  g_signal_connect_swapped (GTK_TOOL_BUTTON (item),
			    "clicked",
			    G_CALLBACK (GNOME_SCAN_PREVIEW_AREA_GET_CLASS (pa)->rotate_clockwise_clicked),
			    pa);

  
  /* other buttons: fixed, auto, fit. */

/*   ruler = gtk_hruler_new (); */
/*   /\* ??????????????????????????? *\/ */
/*   g_signal_connect_swapped (G_OBJECT (pa), */
/* 			    "motion-notify-event", */
/* 			    G_CALLBACK (GTK_WIDGET_GET_CLASS (ruler)->motion_notify_event), */
/* 			    G_OBJECT (ruler)); */

  return widget;
}

void
gsp_refresh_clicked (GtkButton *button,
		 GnomeScanPreview *preview)
{
  gnome_scan_preview_area_refresh (GNOME_SCAN_PREVIEW_AREA (GET_PRIVATE (preview)->area));
}
