%define py_prefix   /usr
%define py_ver      1.5
%define pygtk_ver   0.5.11
%define pygnome_ver 0.100

Summary: pygtk and pygnome
Name: gnome-python
Version: %{pygnome_ver}
Release: 1
Source: gnome-python-%{pygnome_ver}.tar.gz
Copyright: LGPL
Group: Development/Languages
BuildRoot: /var/tmp/gnome-python-root
Packager: James Henstridge <james@daa.com.au>

%description
Source package for python bindings for GTK+ and GNOME.  The binary packages
give better descriptions of what they do.

%package -n pygtk
Version: %{pygtk_ver}
Summary: Python bindings for the GTK+ widget set
Group: Development/Languages
Requires: glib, gtk+, imlib, python

%description -n pygtk
PyGTK is an extension module for python that gives you access to the GTK+
widget set.  Just about anything you can write in C with GTK+ you can write
in python with PyGTK (within reason), but with all of python's benefits.

%package -n pygnome
Version: %{pygnome_ver}
Summary: Python bindings for the GNOME libraries
Group: Development/Languages
Requires: pygtk = %{pygtk_ver}
Requires: gnome-libs

%description -n pygnome
PyGNOME is an extension module for python that gives you access to the
base GNOME libraries.  This means you have access to more widgets, simple
configuration interface, metadata support and many other features.

%prep
%setup
CFLAGS="$RPM_OPT_FLAGS" ./configure

%build
make

%install
rm -rf $RPM_BUILD_ROOT
make DESTDIR=$RPM_BUILD_ROOT install

%files -n pygtk
%{py_prefix}/lib/python%{py_ver}/site-packages/gtk.py*
%{py_prefix}/lib/python%{py_ver}/site-packages/Gtkinter.py*
%{py_prefix}/lib/python%{py_ver}/site-packages/GtkExtra.py*
%{py_prefix}/lib/python%{py_ver}/site-packages/GTK.py*
%{py_prefix}/lib/python%{py_ver}/site-packages/GDK.py*
%{py_prefix}/lib/python%{py_ver}/site-packages/GdkImlib.py*
%{py_prefix}/lib/python%{py_ver}/site-packages/pyglade/*.py*

%{py_prefix}/lib/python%{py_ver}/site-packages/_gtkmodule.so
%{py_prefix}/lib/python%{py_ver}/site-packages/_gdkimlibmodule.so

%doc pygtk/AUTHORS pygtk/NEWS pygtk/README pygtk/MAPPING pygtk/ChangeLog
%doc pygtk/description.py pygtk/examples

%files -n pygnome
%{py_prefix}/lib/python%{py_ver}/site-packages/gettext.py*
%{py_prefix}/lib/python%{py_ver}/site-packages/gnome/*.py*

%{py_prefix}/lib/python%{py_ver}/site-packages/_gnomemodule.so
%{py_prefix}/lib/python%{py_ver}/site-packages/_gnomeuimodule.so
%{py_prefix}/lib/python%{py_ver}/site-packages/_zvtmodule.so
%{py_prefix}/lib/python%{py_ver}/site-packages/_gtkxmhtmlmodule.so

%doc AUTHORS NEWS README ChangeLog
%doc pygnome/examples
