import os
import sys


modules = [
    "gtkhtml2",
    "gnomeapplet",
    "gnomeprint",
    ("gnomeprint.ui", "gnomeprint"),
    "gtksourceview",
    ("egg.trayicon", "egg/tray"),
    ("egg.recent", "egg/recent"),
    "wnck",
    "gtkmozembed",
    "gtkspell",
    "gdl",
    ("totem.plparser", "totem"),
    "gtop",
    "nautilusburn",
    "gda",
    "gksu",
    ("gksu.ui", "gksu"),
    "mediaprofiles",
    ]

import ltihooks

for item in modules:
    if isinstance(item, tuple):
        module, dirname = item
    else:
        module = item
        dirname = item
    sys.path.insert(0, os.path.join("..", dirname))
    try:
        __import__(module) # try to import the module to catch undefined symbols
    except ImportError, ex:
        if ex.args[0].startswith("No module named"):
            pass
        else:
            raise

ltihooks.uninstall()
