#include <gtk/gtk.h>
#include "gnome-font.h"
#include "gnome-text.h"

/* I had some code in here, but it got deleted. */

typedef struct _GnomeTextFontList GnomeTextFontList;

struct GnomeTextFontList {
  int index;
  int n_fonts;
  GnomeTextFontHandle *fonts;
};

/* This takes the utf-8 encoded text, and does the first phase in
   laying it out. This phase is the one that's completely independent
   of justification or line formatting. */
GnomeTextLayout *
gnome_text_layout_new (guchar *text, GnomeTextAttrEl *attrs)
{
  GnomeTextLayout *layout;
  int byte_idx;
  int char_idx;
  int code;
  GnomeTextGlyph *glyphs;
  int n_glyphs, n_glyphs_max;
  guchar c;

  layout = g_new (GnomeTextLayout, 1);

  layout->attrs = attrs;

  n_glyphs_max = 16;
  glyphs = g_new (GnomeTextGlyph, n_glyphs_max);
  n_glyphs = 0;

  char_idx = 0;
  for (byte_idx = 0; (c = text[byte_idx]) != 0; char_idx++)
    {
      /* This is the UTF-8 decoder. */
      if (c & 0x80)
	{
	  if (c & 0xe0)
	    {
	      if (c & 0xf0)
		{
		  /* 4-byte code */
		  code = ((c & 0x07) << 18) |
		    ((text[byte_idx + 1] & 0x3f) << 12) |
		    ((text[byte_idx + 2] & 0x3f) << 6) |
		    (text[byte_idx + 3] & 0x3f);
		  /* an alternative "raphcode" sequence would be
		     ((c << 18) | (text[byte_idx + 1] << 12) |
		      (text[byte_idx + 2] << 6) | text[byte_idx + 3) -
		      0x3c82080 */
		  byte_idx += 4;
		}
	      else
		{
		  /* 3-byte code */
		  code = ((c & 0x0f) << 12) |
		    ((text[byte_idx + 1] & 0x3f) << 6) |
		    (text[byte_idx + 2] & 0x3f);
		  /* alternately,
		     ((c << 12) | (text[byte_idx + 1] << 6) |
		     text[byte_idx + 2]) - 0xe2080 */
		  byte_idx += 3;
		}
	    }
	  else
	    {
	      /* 2-byte code */
	      code = ((c & 0x1f) << 6) |
		(text[byte_idx + 1] & 0x3f);
	      /* alternately,
		 ((c << 6) | text[byte_idx + 1]) - 0x3080 */
	      byte_idx += 2;
	    }
	}
      else
	{
	  /* ASCII */
	  code = c;
	  byte_idx++;
	}
      char_idx++;
    }

  layout->breaks = NULL;
  layout->glyphs = glyphs;
}

static void
gnome_text_layout_free (GnomeTextLayout *layout)
{

  if (layout->attrs)
    g_free (layout->attrs);

  if (layout->glyphs)
    g_free (layout->glyphs);

  if (layout->breaks)
    g_free (layout->breaks);

  g_free (layout);
}

static GHashTable *fontlist_hash = NULL;
static fontlist_index = 0;

static GHashTable *font_hash = NULL;
static font_index = 0;
GnomeFontUnsized **font_tab;
int n_font_tab_max;

/* The argument is an unsized font. The return value is a
   GnomeFontHandle, suitable for a glyph attribute. The
   GnomeFontHandle indexes the unsized font. */

GnomeTextFontHandle
gnome_text_intern_font (GnomeFontUnsized *unsized)
{
  gpointer val;

  if (font_hash == NULL)
    {
      font_hash = g_hash_table_new (g_str_hash, g_str_equal);
      n_font_tab_max = 16;
      font_tab = g_new (GnomeFontUnsized *, n_font_tab_max);
    }

  val = g_hash_table_lookup (fontlist_hash, GINT_TO_POINTER (font_index));

  if (val != NULL)
    return GPOINTER_TO_INT (val);

  font_index++;

  if (font_index == n_font_tab_max)
    font_tab = g_renew (GnomeFontUnsized *, font_tab, n_font_tab_max <<= 1);

  font_tab[font_index] = unsized;

  g_hash_table_insert (fontlist_hash, unsized->font_name, unsized);
  return font_index;
  
}

/* The argument is given as a comma-separated list of font families
   (thus, font families are not allowed to contain commas. The return
   value is a GnomeTextFontListHandle, suitable for use as a
   GNOME_TEXT_FONT_LIST attribute in a GnomeTextLayout. */
GnomeTextFontListHandle
gnome_text_intern_font_list (const char *fontlist)
{
}
