/* Generated by GOB (v2.0.3) on Mon Jul 14 13:32:01 2003
   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */

#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 3

#define selfp (self->_priv)

#include "gnome-pilot-conduit-management.h"

#include "gnome-pilot-conduit-management-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */

#line 80 "gnome-pilot-conduit-management.gob"

#include <config.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <dirent.h>
#include <unistd.h>
#include <libxml/tree.h>
#include <libxml/parser.h>

/* 
   MT-Level :
   Change these defines to make the lib MT safe. 
   (UN)LOCK_MY_HASHES should mutex the conduitname_to_datastruct hash
   (UN)LOCK_MY_COUNTER should mutex the number_of_instances counter
   (UN)LOCK_INSTANCE should mutex the current Gnome:Pilot:Conduit:Management instance
   uhm, don't think I'll use LOCK_INSTANCE
*/
#define LOCK_MY_COUNTER
#define UNLOCK_MY_COUNTER

#define LOCK_MY_HASHES
#define UNLOCK_MY_HASHES

#define LOCK_INSTANCE
#define UNLOCK_INSTANCE

  /* the version that the conduit xml spec files should have */
#define CONDUIT_XML_VERSION "1.0"

gboolean initialized = FALSE;
int number_of_instances  = 0;
GHashTable *conduitname_to_datastruct; 
GHashTable *conduitid_to_datastruct; 

/* these are the list of valid tags in addition to conduit-attribute */
static const gchar *valid_tags[] = {"conduit","name",NULL};

#line 63 "gnome-pilot-conduit-management.c"
/* self casting macros */
#define SELF(x) GNOME_PILOT_CONDUIT_MANAGEMENT(x)
#define SELF_CONST(x) GNOME_PILOT_CONDUIT_MANAGEMENT_CONST(x)
#define IS_SELF(x) GNOME_IS_PILOT_CONDUIT_MANAGEMENT(x)
#define TYPE_SELF GNOME_TYPE_PILOT_CONDUIT_MANAGEMENT
#define SELF_CLASS(x) GNOME_PILOT_CONDUIT_MANAGEMENT_CLASS(x)

#define SELF_GET_CLASS(x) GNOME_PILOT_CONDUIT_MANAGEMENT_GET_CLASS(x)

/* self typedefs */
typedef GnomePilotConduitManagement Self;
typedef GnomePilotConduitManagementClass SelfClass;

/* here are local prototypes */
static void gnome_pilot_conduit_management_init (GnomePilotConduitManagement * o) G_GNUC_UNUSED;
static void gnome_pilot_conduit_management_class_init (GnomePilotConduitManagementClass * c) G_GNUC_UNUSED;
static void gnome_pilot_conduit_management_initializer (void) G_GNUC_UNUSED;
static gchar * gnome_pilot_conduit_management_select_dir_entry (gchar * path, gchar * filename, gchar * extension) G_GNUC_UNUSED;
static GList * gnome_pilot_conduit_management_get_conduit_file_names (gchar * path, gchar * ext) G_GNUC_UNUSED;
static gboolean gnome_pilot_conduit_management_is_other_valid_tag (const gchar * s) G_GNUC_UNUSED;
static GnomePilotConduitMgmtData * gnome_pilot_conduit_management_check_xml_version (xmlNodePtr root) G_GNUC_UNUSED;
static gboolean gnome_pilot_conduit_management_read_conduit_topdata (GnomePilotConduitMgmtData * obj, xmlNodePtr root) G_GNUC_UNUSED;
static const char * gnome_pilot_conduit_management_get_lang (void) G_GNUC_UNUSED;
static gboolean gnome_pilot_conduit_management_read_conduit_name (GnomePilotConduitMgmtData * obj, xmlNodePtr root) G_GNUC_UNUSED;
static void gnome_pilot_conduit_management_read_conduit_attributes (GnomePilotConduitMgmtData * obj, xmlNodePtr root) G_GNUC_UNUSED;
static GnomePilotConduitMgmtData * gnome_pilot_conduit_management_read_conduit_xml (gchar * filename) G_GNUC_UNUSED;
static void gnome_pilot_conduit_management_hfunc_build_name_list (gchar * name, GnomePilotConduitMgmtData * data, GList ** output) G_GNUC_UNUSED;
static void gnome_pilot_conduit_management_attribs_foreach (gchar * key, gpointer unused, GList ** l) G_GNUC_UNUSED;
static void gnome_pilot_conduit_management_attribs_filter_lang_foreach (gchar * key, gpointer unused, GList ** l) G_GNUC_UNUSED;
static gint gnome_pilot_conduit_management_shlib_loader (GnomePilotConduitManagement * self) G_GNUC_UNUSED;

/* pointer to the class of our parent */
static GtkObjectClass *parent_class = NULL;

/* Short form macros */
#if defined(__GNUC__) && !defined(__STRICT_ANSI__)
#define self_initializer() gnome_pilot_conduit_management_initializer()
#define self_new(args...) gnome_pilot_conduit_management_new(args)
#define self_destroy(args...) gnome_pilot_conduit_management_destroy(args)
#define self_select_dir_entry(args...) gnome_pilot_conduit_management_select_dir_entry(args)
#define self_get_conduit_file_names(args...) gnome_pilot_conduit_management_get_conduit_file_names(args)
#define self_is_other_valid_tag(args...) gnome_pilot_conduit_management_is_other_valid_tag(args)
#define self_check_xml_version(args...) gnome_pilot_conduit_management_check_xml_version(args)
#define self_read_conduit_topdata(args...) gnome_pilot_conduit_management_read_conduit_topdata(args)
#define self_get_lang() gnome_pilot_conduit_management_get_lang()
#define self_read_conduit_name(args...) gnome_pilot_conduit_management_read_conduit_name(args)
#define self_read_conduit_attributes(args...) gnome_pilot_conduit_management_read_conduit_attributes(args)
#define self_read_conduit_xml(args...) gnome_pilot_conduit_management_read_conduit_xml(args)
#define self_get_name(args...) gnome_pilot_conduit_management_get_name(args)
#define self_get_id(args...) gnome_pilot_conduit_management_get_id(args)
#define self_hfunc_build_name_list(args...) gnome_pilot_conduit_management_hfunc_build_name_list(args)
#define self_get_conduits(args...) gnome_pilot_conduit_management_get_conduits(args)
#define self_attribs_foreach(args...) gnome_pilot_conduit_management_attribs_foreach(args)
#define self_attribs_filter_lang_foreach(args...) gnome_pilot_conduit_management_attribs_filter_lang_foreach(args)
#define self_get_attribute_list(args...) gnome_pilot_conduit_management_get_attribute_list(args)
#define self_get_attribute(args...) gnome_pilot_conduit_management_get_attribute(args)
#define self_shlib_loader(args...) gnome_pilot_conduit_management_shlib_loader(args)
#define self_instantiate_conduit(args...) gnome_pilot_conduit_management_instantiate_conduit(args)
#define self_destroy_conduit(args...) gnome_pilot_conduit_management_destroy_conduit(args)
#endif /* __GNUC__ && !__STRICT_ANSI__ */

/* Short form pointers */
static void (* const self_initializer) (void) = gnome_pilot_conduit_management_initializer;
static GnomePilotConduitManagement * (* const self_new) (gchar * _name, enum GnomePilotConduitFilter filter) = gnome_pilot_conduit_management_new;
static void (* const self_destroy) (GnomePilotConduitManagement * self) = gnome_pilot_conduit_management_destroy;
static gchar * (* const self_select_dir_entry) (gchar * path, gchar * filename, gchar * extension) = gnome_pilot_conduit_management_select_dir_entry;
static GList * (* const self_get_conduit_file_names) (gchar * path, gchar * ext) = gnome_pilot_conduit_management_get_conduit_file_names;
static gboolean (* const self_is_other_valid_tag) (const gchar * s) = gnome_pilot_conduit_management_is_other_valid_tag;
static GnomePilotConduitMgmtData * (* const self_check_xml_version) (xmlNodePtr root) = gnome_pilot_conduit_management_check_xml_version;
static gboolean (* const self_read_conduit_topdata) (GnomePilotConduitMgmtData * obj, xmlNodePtr root) = gnome_pilot_conduit_management_read_conduit_topdata;
static const char * (* const self_get_lang) (void) = gnome_pilot_conduit_management_get_lang;
static gboolean (* const self_read_conduit_name) (GnomePilotConduitMgmtData * obj, xmlNodePtr root) = gnome_pilot_conduit_management_read_conduit_name;
static void (* const self_read_conduit_attributes) (GnomePilotConduitMgmtData * obj, xmlNodePtr root) = gnome_pilot_conduit_management_read_conduit_attributes;
static GnomePilotConduitMgmtData * (* const self_read_conduit_xml) (gchar * filename) = gnome_pilot_conduit_management_read_conduit_xml;
static const gchar * (* const self_get_name) (GnomePilotConduitManagement * self) = gnome_pilot_conduit_management_get_name;
static const gchar * (* const self_get_id) (GnomePilotConduitManagement * self) = gnome_pilot_conduit_management_get_id;
static void (* const self_hfunc_build_name_list) (gchar * name, GnomePilotConduitMgmtData * data, GList ** output) = gnome_pilot_conduit_management_hfunc_build_name_list;
static gint (* const self_get_conduits) (GList ** output, enum GnomePilotConduitFilter filter) = gnome_pilot_conduit_management_get_conduits;
static void (* const self_attribs_foreach) (gchar * key, gpointer unused, GList ** l) = gnome_pilot_conduit_management_attribs_foreach;
static void (* const self_attribs_filter_lang_foreach) (gchar * key, gpointer unused, GList ** l) = gnome_pilot_conduit_management_attribs_filter_lang_foreach;
static GList * (* const self_get_attribute_list) (GnomePilotConduitManagement * self, gboolean filter_lang) = gnome_pilot_conduit_management_get_attribute_list;
static const gpointer * (* const self_get_attribute) (GnomePilotConduitManagement * self, gchar * attribute_name, gchar * lang) = gnome_pilot_conduit_management_get_attribute;
static gint (* const self_shlib_loader) (GnomePilotConduitManagement * self) = gnome_pilot_conduit_management_shlib_loader;
static gint (* const self_instantiate_conduit) (GnomePilotConduitManagement * self, GPilotPilot * pilot, GnomePilotConduit ** instance) = gnome_pilot_conduit_management_instantiate_conduit;
static gint (* const self_destroy_conduit) (GnomePilotConduitManagement * self, GnomePilotConduit ** instance) = gnome_pilot_conduit_management_destroy_conduit;

GType
gnome_pilot_conduit_management_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (GnomePilotConduitManagementClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) gnome_pilot_conduit_management_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (GnomePilotConduitManagement),
			0 /* n_preallocs */,
			(GInstanceInitFunc) gnome_pilot_conduit_management_init,
		};

		type = g_type_register_static (GTK_TYPE_OBJECT, "GnomePilotConduitManagement", &info, (GTypeFlags)0);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((GnomePilotConduitManagement *)g_object_new(gnome_pilot_conduit_management_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static GnomePilotConduitManagement * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static GnomePilotConduitManagement *
GET_NEW_VARG (const char *first, ...)
{
	GnomePilotConduitManagement *ret;
	va_list ap;
	va_start (ap, first);
	ret = (GnomePilotConduitManagement *)g_object_new_valist (gnome_pilot_conduit_management_get_type (), first, ap);
	va_end (ap);
	return ret;
}


static void
___finalize(GObject *obj_self)
{
#define __GOB_FUNCTION__ "Gnome:Pilot:Conduit:Management::finalize"
	GnomePilotConduitManagement *self = GNOME_PILOT_CONDUIT_MANAGEMENT (obj_self);
	gpointer priv = self->_priv;
	if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(obj_self);
	g_free (priv);
	return;
	self = NULL;
}
#undef __GOB_FUNCTION__

static void 
gnome_pilot_conduit_management_init (GnomePilotConduitManagement * o)
{
#define __GOB_FUNCTION__ "Gnome:Pilot:Conduit:Management::init"
	o->_priv = g_new0 (GnomePilotConduitManagementPrivate, 1);
	return;
	o = NULL;
}
#undef __GOB_FUNCTION__
static void 
gnome_pilot_conduit_management_class_init (GnomePilotConduitManagementClass * c)
{
#define __GOB_FUNCTION__ "Gnome:Pilot:Conduit:Management::class_init"
	GObjectClass *g_object_class = (GObjectClass*) c;

	parent_class = g_type_class_ref (GTK_TYPE_OBJECT);

	g_object_class->finalize = ___finalize;
	return;
	c = NULL;
	g_object_class = NULL;
}
#undef __GOB_FUNCTION__



#line 141 "gnome-pilot-conduit-management.gob"
static void 
gnome_pilot_conduit_management_initializer (void)
#line 235 "gnome-pilot-conduit-management.c"
{
#define __GOB_FUNCTION__ "Gnome:Pilot:Conduit:Management::initializer"
{
#line 142 "gnome-pilot-conduit-management.gob"
	
		if (!initialized) {
			GList *conduit_files;
			GList *iterator;

			/* Do read of all .conduit files here */
			conduit_files = self_get_conduit_file_names ("share/gnome-pilot/conduits", ".conduit");
 
			LOCK_MY_HASHES;
			conduitname_to_datastruct  = g_hash_table_new (g_str_hash,g_str_equal);
			conduitid_to_datastruct  = g_hash_table_new (g_str_hash,g_str_equal);

			/* g_message ("direntries = %d",dirs); */
			for (iterator = conduit_files; iterator; iterator = g_list_next (iterator)) {
				GnomePilotConduitMgmtData *conduitdata;
				gchar *filename = (char*)iterator->data;

				conduitdata = self_read_conduit_xml (filename);
			}

			UNLOCK_MY_HASHES;
			g_list_foreach (conduit_files, (GFunc)g_free, NULL);
			g_list_free (conduit_files);
		}
		initialized = TRUE;
	}}
#line 266 "gnome-pilot-conduit-management.c"
#undef __GOB_FUNCTION__

#line 172 "gnome-pilot-conduit-management.gob"
GnomePilotConduitManagement * 
gnome_pilot_conduit_management_new (gchar * _name, enum GnomePilotConduitFilter filter)
#line 272 "gnome-pilot-conduit-management.c"
{
#define __GOB_FUNCTION__ "Gnome:Pilot:Conduit:Management::new"
#line 172 "gnome-pilot-conduit-management.gob"
	g_return_val_if_fail (_name != NULL, (GnomePilotConduitManagement * )NULL);
#line 277 "gnome-pilot-conduit-management.c"
{
#line 175 "gnome-pilot-conduit-management.gob"
	
		GtkObject *ret = NULL;
		GHashTable *which_to_use = NULL;
		GnomePilotConduitManagement *obj  = NULL;
		GnomePilotConduitMgmtData *_mgmtdata = NULL;

		LOCK_MY_COUNTER;
		if (number_of_instances==0) {
			gnome_pilot_conduit_management_initializer ();
		}
		number_of_instances++;
		UNLOCK_MY_COUNTER;
		
		switch (filter) {
		case GNOME_PILOT_CONDUIT_MGMT_ID:
			which_to_use = conduitid_to_datastruct;
			break;
		case GNOME_PILOT_CONDUIT_MGMT_NAME:
			which_to_use = conduitname_to_datastruct;
			break;
		}

		_mgmtdata = g_hash_table_lookup (which_to_use,_name);
		if (_mgmtdata) {
			ret = GTK_OBJECT (GET_NEW);
			obj = SELF (ret);
			obj->_priv->loaded = FALSE;
			obj->_priv->mgmtdata = _mgmtdata;
		} else {
			g_warning ("Unknown conduit, name=\"%s\"",_name);
		}

		return obj;
	}}
#line 314 "gnome-pilot-conduit-management.c"
#undef __GOB_FUNCTION__

#line 213 "gnome-pilot-conduit-management.gob"
void 
gnome_pilot_conduit_management_destroy (GnomePilotConduitManagement * self)
#line 320 "gnome-pilot-conduit-management.c"
{
#define __GOB_FUNCTION__ "Gnome:Pilot:Conduit:Management::destroy"
#line 213 "gnome-pilot-conduit-management.gob"
	g_return_if_fail (self != NULL);
#line 213 "gnome-pilot-conduit-management.gob"
	g_return_if_fail (GNOME_IS_PILOT_CONDUIT_MANAGEMENT (self));
#line 327 "gnome-pilot-conduit-management.c"
{
#line 214 "gnome-pilot-conduit-management.gob"
	
		LOCK_INSTANCE;
		LOCK_MY_COUNTER;
		number_of_instances--;
		if (number_of_instances==0) {
			/* g_message ("No more instances"); */
		}
		gtk_object_destroy (GTK_OBJECT (self));
		UNLOCK_MY_COUNTER;
		UNLOCK_INSTANCE;
	}}
#line 341 "gnome-pilot-conduit-management.c"
#undef __GOB_FUNCTION__

#line 233 "gnome-pilot-conduit-management.gob"
static gchar * 
gnome_pilot_conduit_management_select_dir_entry (gchar * path, gchar * filename, gchar * extension)
#line 347 "gnome-pilot-conduit-management.c"
{
#define __GOB_FUNCTION__ "Gnome:Pilot:Conduit:Management::select_dir_entry"
{
#line 234 "gnome-pilot-conduit-management.gob"
	
		gchar *result = NULL;
		gchar *ptr;
		struct stat st;

		if (filename==NULL) {
			return NULL;
		}

		if (strlen (filename) < strlen (extension)) {
			return NULL;
		}

		ptr = filename;
		ptr += (strlen (filename) - strlen (extension));

		if (strcmp (ptr, extension)) {
			return NULL;
		}

		result = g_strdup_printf ("%s/%s", path, filename);

		stat (result, &st);
		if (S_ISDIR (st.st_mode) || 
		    S_ISCHR (st.st_mode) || 
		    S_ISFIFO (st.st_mode) || 
		    S_ISSOCK (st.st_mode)) {
			g_free (result);
			return NULL;
		}

		return result;
	}}
#line 385 "gnome-pilot-conduit-management.c"
#undef __GOB_FUNCTION__

#line 269 "gnome-pilot-conduit-management.gob"
static GList * 
gnome_pilot_conduit_management_get_conduit_file_names (gchar * path, gchar * ext)
#line 391 "gnome-pilot-conduit-management.c"
{
#define __GOB_FUNCTION__ "Gnome:Pilot:Conduit:Management::get_conduit_file_names"
{
#line 270 "gnome-pilot-conduit-management.gob"
	
		gchar *gnome_path = NULL;
		const gchar *susepath, *gnome2path;
		GList *result = NULL;
		GDir *dir;
		const char *name;
		gchar **paths;
		int idx;
		
		susepath = g_getenv ("GNOMEPATH");
		gnome2path = g_getenv ("GNOME2_PATH");
		/* Concat SuSE's GNOMEPATH, GNOME2_PATH, and CONDUITDIR
		   This is so that we can load all conduits in these paths */
		gnome_path = g_strconcat (CONDUITDIR, ":",
					  susepath ? susepath : "", ":",
					  gnome2path ? gnome2path : "",
					  NULL);

		if (gnome_path == NULL) {
			g_warning ("Cannot locate the %s files", ext);
			return NULL;
		}

		paths = g_strsplit (gnome_path, ":", -1);

		for (idx = 0; paths[idx]; idx++) {
			gchar *cur_path;

			/* Ensure we end in / */
			cur_path = g_strdup_printf ("%s/%s/", paths[idx], path);

			/* Go through all the files and select the ones we want */
			dir = g_dir_open (cur_path, 0, NULL);
			if (dir == NULL) {
				g_free (cur_path);
				continue;
			}
			while (name = g_dir_read_name (dir)) {
				gchar *fullname;
				if ((fullname = self_select_dir_entry (cur_path, (char *)name, ext))!=NULL) {
					result = g_list_prepend (result, fullname);
				}
			}
			g_dir_close (dir);
			g_free (cur_path);
		}
		
		g_strfreev (paths);
		g_free (gnome_path);
		return result;
	}}
#line 447 "gnome-pilot-conduit-management.c"
#undef __GOB_FUNCTION__

#line 323 "gnome-pilot-conduit-management.gob"
static gboolean 
gnome_pilot_conduit_management_is_other_valid_tag (const gchar * s)
#line 453 "gnome-pilot-conduit-management.c"
{
#define __GOB_FUNCTION__ "Gnome:Pilot:Conduit:Management::is_other_valid_tag"
{
#line 324 "gnome-pilot-conduit-management.gob"
	
		gint i = 0;
		for (i=0;valid_tags[i];i++)
			if (g_strcasecmp (s,valid_tags[i])==0) return TRUE;
		return FALSE;
		
	}}
#line 465 "gnome-pilot-conduit-management.c"
#undef __GOB_FUNCTION__

#line 333 "gnome-pilot-conduit-management.gob"
static GnomePilotConduitMgmtData * 
gnome_pilot_conduit_management_check_xml_version (xmlNodePtr root)
#line 471 "gnome-pilot-conduit-management.c"
{
#define __GOB_FUNCTION__ "Gnome:Pilot:Conduit:Management::check_xml_version"
{
#line 334 "gnome-pilot-conduit-management.gob"
	
		GnomePilotConduitMgmtData *ret;
		xmlChar *version;
		
		version = xmlGetProp (root,"version");
		/* g_message ("version = %s",version); */
		if (version==NULL || g_strcasecmp (version,CONDUIT_XML_VERSION)!=0) {
			g_warning ("incompatible version");
			return NULL;	
		}
		/* g_message ("XML version is ok, creating entry"); */
		ret = g_new (GnomePilotConduitMgmtData,1);
		ret->string_attributes = g_hash_table_new (g_str_hash,g_str_equal);
		return ret;
	}}
#line 491 "gnome-pilot-conduit-management.c"
#undef __GOB_FUNCTION__

#line 351 "gnome-pilot-conduit-management.gob"
static gboolean 
gnome_pilot_conduit_management_read_conduit_topdata (GnomePilotConduitMgmtData * obj, xmlNodePtr root)
#line 497 "gnome-pilot-conduit-management.c"
{
#define __GOB_FUNCTION__ "Gnome:Pilot:Conduit:Management::read_conduit_topdata"
{
#line 352 "gnome-pilot-conduit-management.gob"
	
		xmlNodePtr node;
		xmlChar *type,*location,*id_string;

		node = root->children;
		/* until we find the "conduit" node */
		while (node && g_strcasecmp (node->name,"conduit")!=0) {
			node = node->next;
		}
		if (!node) {
			g_warning ("error in XML, missing the \"conduit\" node");
			return FALSE;
		}
		type = xmlGetProp (node,"type");
		location = xmlGetProp (node,"location");
		id_string = xmlGetProp (node,"id");

		if (id_string==NULL) {
			g_warning ("error in XML, missing id_string");
			return FALSE;
		} else {
			if (strchr (id_string,' ')) {
				g_warning ("error in XML, id_string bad");
				return FALSE;
			}
		}
		if (location==NULL) {
			g_warning ("error in XML, missing location");
			return FALSE;
		}

		if (g_strcasecmp (type,"shlib")==0) {
			obj->type = GNOME_PILOT_CONDUIT_TYPE_SHLIB;
		} else {
			g_warning ("Unknown conduit type");
			return FALSE;	
		}
		obj->location = g_strdup (location);
		obj->id = g_strdup (id_string);
		g_hash_table_insert (conduitid_to_datastruct,
				    obj->id,
				    obj);
		return TRUE;
	}}
#line 546 "gnome-pilot-conduit-management.c"
#undef __GOB_FUNCTION__

#line 397 "gnome-pilot-conduit-management.gob"
static const char * 
gnome_pilot_conduit_management_get_lang (void)
#line 552 "gnome-pilot-conduit-management.c"
{
#define __GOB_FUNCTION__ "Gnome:Pilot:Conduit:Management::get_lang"
{
#line 399 "gnome-pilot-conduit-management.gob"
	
		const GList *ll;
	
		ll = gnome_i18n_get_language_list (NULL);
		return ll->data;
	}}
#line 563 "gnome-pilot-conduit-management.c"
#undef __GOB_FUNCTION__

#line 407 "gnome-pilot-conduit-management.gob"
static gboolean 
gnome_pilot_conduit_management_read_conduit_name (GnomePilotConduitMgmtData * obj, xmlNodePtr root)
#line 569 "gnome-pilot-conduit-management.c"
{
#define __GOB_FUNCTION__ "Gnome:Pilot:Conduit:Management::read_conduit_name"
{
#line 408 "gnome-pilot-conduit-management.gob"
	
		xmlNodePtr node;
		xmlChar *value,*lang;
		gchar *current_name=NULL;

		node = root->children;
		/* until we find a name node */
		while (node) {
			while (node && g_strcasecmp (node->name,"name")) {
				node = node->next;
			}
			if (node) {
				value = xmlGetProp (node,"value");
				lang = xmlGetProp (node,"lang");
				/* if this is a default name, and there
				   is no current_name, set it. If on the
				   other hand there is a lang, and it's the current, set it*/
				if ((!lang && !current_name) ||
				    (lang && g_strcasecmp (lang, self_get_lang ())==0)) {
					if (current_name) g_free (current_name);
					current_name = g_strdup (value);
				}
				node = node->next;
			}
		}
		if (!current_name) {
			g_warning ("could not determine name from XML");
			return FALSE;
		}

		obj->name = g_strdup (current_name);
		g_hash_table_insert (conduitname_to_datastruct,
				    obj->name,
				    obj);
		return TRUE;
	}}
#line 610 "gnome-pilot-conduit-management.c"
#undef __GOB_FUNCTION__

#line 447 "gnome-pilot-conduit-management.gob"
static void 
gnome_pilot_conduit_management_read_conduit_attributes (GnomePilotConduitMgmtData * obj, xmlNodePtr root)
#line 616 "gnome-pilot-conduit-management.c"
{
#define __GOB_FUNCTION__ "Gnome:Pilot:Conduit:Management::read_conduit_attributes"
{
#line 448 "gnome-pilot-conduit-management.gob"
	
		xmlNodePtr node;

		/* loop over the children */
		for (node = root->children; node!=NULL; node=node->next) {
			if (g_strcasecmp (node->name,"conduit-attribute")==0) {
				xmlChar *lang,*name,*type,*value;
				gchar *attr_with_lang;
				
				lang = xmlGetProp (node,"lang");
				name = xmlGetProp (node,"name");
				type = xmlGetProp (node,"type");
				value = xmlGetProp (node,"value");

				if (value==NULL) {
					g_warning ("attribute %s for %s(%s) has no value",
						   name, obj->name, obj->id);
					continue;
				}
				if (name==NULL) {
					g_warning ("attribute has no name");
					continue;
				}

				/* g_message ("conduit-attribute [%s-%s] is \"%s\"/%s",
				  name,lang,value,type); */
				if (lang) {
					attr_with_lang = g_strdup_printf ("%s-%s",
									 name, lang);
				} else {
					attr_with_lang = g_strdup (name);
				}
				/* if no type, assume string */
				if (type==NULL || g_strcasecmp (type,"string")==0) {
					g_hash_table_insert (obj->string_attributes,
							     attr_with_lang,
							     g_strdup (value));
				} else {
					g_warning ("Unknown type %s",type);
				}
				
			} else if (g_strcasecmp (node->name, "text") == 0) {
				/* ignore text */
			} else if (!self_is_other_valid_tag (node->name)) { 
				g_warning ("node->name = \"%s\", unhandled ",node->name);
			} 
		} 
	}}
#line 669 "gnome-pilot-conduit-management.c"
#undef __GOB_FUNCTION__

#line 499 "gnome-pilot-conduit-management.gob"
static GnomePilotConduitMgmtData * 
gnome_pilot_conduit_management_read_conduit_xml (gchar * filename)
#line 675 "gnome-pilot-conduit-management.c"
{
#define __GOB_FUNCTION__ "Gnome:Pilot:Conduit:Management::read_conduit_xml"
{
#line 500 "gnome-pilot-conduit-management.gob"
	
		xmlDocPtr doc;
		xmlNodePtr root;
		GnomePilotConduitMgmtData *ret;

		/* g_message ("read_conduit_xml: reading from %s",name); */
		
		/* load the thing */
		doc = xmlParseFile (filename);

		/* check validity 1 */
		if (!doc)
			return NULL;

		root = xmlDocGetRootElement (doc);
		if (!root ||
		    !root->name ||
		    g_strcasecmp (root->name,"gnome-pilot-conduit")!=0) {
			xmlFreeDoc (doc);
			return NULL;
		}      
		
		ret = self_check_xml_version (root);
		if (!self_read_conduit_topdata (ret,root) ||
		    !self_read_conduit_name (ret,root)) {
			g_hash_table_destroy (ret->string_attributes);
			g_free (ret);
			xmlFreeDoc (doc);
			return NULL;
		}
		;
		self_read_conduit_attributes (ret,root);

		xmlFreeDoc (doc);
		return ret;
	}}
#line 716 "gnome-pilot-conduit-management.c"
#undef __GOB_FUNCTION__

#line 543 "gnome-pilot-conduit-management.gob"
const gchar * 
gnome_pilot_conduit_management_get_name (GnomePilotConduitManagement * self)
#line 722 "gnome-pilot-conduit-management.c"
{
#define __GOB_FUNCTION__ "Gnome:Pilot:Conduit:Management::get_name"
#line 543 "gnome-pilot-conduit-management.gob"
	g_return_val_if_fail (self != NULL, (const gchar * )0);
#line 543 "gnome-pilot-conduit-management.gob"
	g_return_val_if_fail (GNOME_IS_PILOT_CONDUIT_MANAGEMENT (self), (const gchar * )0);
#line 729 "gnome-pilot-conduit-management.c"
{
#line 544 "gnome-pilot-conduit-management.gob"
	
		return self->_priv->mgmtdata->name;
	}}
#line 735 "gnome-pilot-conduit-management.c"
#undef __GOB_FUNCTION__

#line 549 "gnome-pilot-conduit-management.gob"
const gchar * 
gnome_pilot_conduit_management_get_id (GnomePilotConduitManagement * self)
#line 741 "gnome-pilot-conduit-management.c"
{
#define __GOB_FUNCTION__ "Gnome:Pilot:Conduit:Management::get_id"
#line 549 "gnome-pilot-conduit-management.gob"
	g_return_val_if_fail (self != NULL, (const gchar * )0);
#line 549 "gnome-pilot-conduit-management.gob"
	g_return_val_if_fail (GNOME_IS_PILOT_CONDUIT_MANAGEMENT (self), (const gchar * )0);
#line 748 "gnome-pilot-conduit-management.c"
{
#line 550 "gnome-pilot-conduit-management.gob"
	
		return self->_priv->mgmtdata->id;
	}}
#line 754 "gnome-pilot-conduit-management.c"
#undef __GOB_FUNCTION__

#line 555 "gnome-pilot-conduit-management.gob"
static void 
gnome_pilot_conduit_management_hfunc_build_name_list (gchar * name, GnomePilotConduitMgmtData * data, GList ** output)
#line 760 "gnome-pilot-conduit-management.c"
{
#define __GOB_FUNCTION__ "Gnome:Pilot:Conduit:Management::hfunc_build_name_list"
{
#line 556 "gnome-pilot-conduit-management.gob"
	
		(*output) = g_list_append (*output,name);
	}}
#line 768 "gnome-pilot-conduit-management.c"
#undef __GOB_FUNCTION__

#line 560 "gnome-pilot-conduit-management.gob"
gint 
gnome_pilot_conduit_management_get_conduits (GList ** output, enum GnomePilotConduitFilter filter)
#line 774 "gnome-pilot-conduit-management.c"
{
#define __GOB_FUNCTION__ "Gnome:Pilot:Conduit:Management::get_conduits"
#line 560 "gnome-pilot-conduit-management.gob"
	g_return_val_if_fail (output != NULL, (gint )GNOME_PILOT_CONDUIT_MGMT_ERROR);
#line 779 "gnome-pilot-conduit-management.c"
{
#line 563 "gnome-pilot-conduit-management.gob"
	
		GHashTable *which_to_use = NULL;
		gnome_pilot_conduit_management_initializer ();
		LOCK_MY_HASHES;
		switch (filter) {
		case GNOME_PILOT_CONDUIT_MGMT_ID:
			which_to_use = conduitid_to_datastruct;
			break;
		case GNOME_PILOT_CONDUIT_MGMT_NAME:
			which_to_use = conduitname_to_datastruct;
			break;
		}
		g_hash_table_foreach (which_to_use,
				     (GHFunc)self_hfunc_build_name_list,
				     output);
		UNLOCK_MY_HASHES;		
		return GNOME_PILOT_CONDUIT_MGMT_OK;
	}}
#line 800 "gnome-pilot-conduit-management.c"
#undef __GOB_FUNCTION__

#line 584 "gnome-pilot-conduit-management.gob"
static void 
gnome_pilot_conduit_management_attribs_foreach (gchar * key, gpointer unused, GList ** l)
#line 806 "gnome-pilot-conduit-management.c"
{
#define __GOB_FUNCTION__ "Gnome:Pilot:Conduit:Management::attribs_foreach"
{
#line 585 "gnome-pilot-conduit-management.gob"
	
		(*l) = g_list_append (*l,key);
	}}
#line 814 "gnome-pilot-conduit-management.c"
#undef __GOB_FUNCTION__

#line 590 "gnome-pilot-conduit-management.gob"
static void 
gnome_pilot_conduit_management_attribs_filter_lang_foreach (gchar * key, gpointer unused, GList ** l)
#line 820 "gnome-pilot-conduit-management.c"
{
#define __GOB_FUNCTION__ "Gnome:Pilot:Conduit:Management::attribs_filter_lang_foreach"
{
#line 591 "gnome-pilot-conduit-management.gob"
	
		if (!strstr (key,"##"))
			(*l) = g_list_append (*l,key);
	}}
#line 829 "gnome-pilot-conduit-management.c"
#undef __GOB_FUNCTION__

#line 600 "gnome-pilot-conduit-management.gob"
GList * 
gnome_pilot_conduit_management_get_attribute_list (GnomePilotConduitManagement * self, gboolean filter_lang)
#line 835 "gnome-pilot-conduit-management.c"
{
#define __GOB_FUNCTION__ "Gnome:Pilot:Conduit:Management::get_attribute_list"
#line 600 "gnome-pilot-conduit-management.gob"
	g_return_val_if_fail (self != NULL, (GList * )0);
#line 600 "gnome-pilot-conduit-management.gob"
	g_return_val_if_fail (GNOME_IS_PILOT_CONDUIT_MANAGEMENT (self), (GList * )0);
#line 842 "gnome-pilot-conduit-management.c"
{
#line 601 "gnome-pilot-conduit-management.gob"
	
		GList *attribs = NULL;
		LOCK_MY_HASHES;
		
		if (filter_lang) {
			g_hash_table_foreach (self->_priv->mgmtdata->string_attributes,(GHFunc)self_attribs_filter_lang_foreach,&attribs);
		} else {
			g_hash_table_foreach (self->_priv->mgmtdata->string_attributes,(GHFunc)self_attribs_foreach,&attribs);
		}
		UNLOCK_MY_HASHES;
		return attribs;
	}}
#line 857 "gnome-pilot-conduit-management.c"
#undef __GOB_FUNCTION__

#line 616 "gnome-pilot-conduit-management.gob"
const gpointer * 
gnome_pilot_conduit_management_get_attribute (GnomePilotConduitManagement * self, gchar * attribute_name, gchar * lang)
#line 863 "gnome-pilot-conduit-management.c"
{
#define __GOB_FUNCTION__ "Gnome:Pilot:Conduit:Management::get_attribute"
#line 616 "gnome-pilot-conduit-management.gob"
	g_return_val_if_fail (self != NULL, (const gpointer * )NULL);
#line 616 "gnome-pilot-conduit-management.gob"
	g_return_val_if_fail (GNOME_IS_PILOT_CONDUIT_MANAGEMENT (self), (const gpointer * )NULL);
#line 616 "gnome-pilot-conduit-management.gob"
	g_return_val_if_fail (attribute_name != NULL, (const gpointer * )NULL);
#line 872 "gnome-pilot-conduit-management.c"
{
#line 621 "gnome-pilot-conduit-management.gob"
			
		gpointer *attr = NULL;		
		gchar *attribute_name_with_lang;
		LOCK_MY_HASHES;
		/* if no such conduit, do nothing and NULL will be returned */
		if (strstr (attribute_name,"##")==NULL) {
			attribute_name_with_lang = g_strdup_printf ("%s##%s",
								   lang?lang:self_get_lang (),
								   attribute_name);
		} else {
			attribute_name_with_lang = g_strdup (attribute_name);
		}
		attr = g_hash_table_lookup (self->_priv->mgmtdata->string_attributes,
					   attribute_name_with_lang);
		g_free (attribute_name_with_lang);
		if (!attr) {
			/* no luck, try without language */
			attr = g_hash_table_lookup (self->_priv->mgmtdata->string_attributes,attribute_name);
		}
		UNLOCK_MY_HASHES;
		return attr;
	}}
#line 897 "gnome-pilot-conduit-management.c"
#undef __GOB_FUNCTION__

#line 651 "gnome-pilot-conduit-management.gob"
static gint 
gnome_pilot_conduit_management_shlib_loader (GnomePilotConduitManagement * self)
#line 903 "gnome-pilot-conduit-management.c"
{
#define __GOB_FUNCTION__ "Gnome:Pilot:Conduit:Management::shlib_loader"
#line 651 "gnome-pilot-conduit-management.gob"
	g_return_val_if_fail (self != NULL, (gint )0);
#line 651 "gnome-pilot-conduit-management.gob"
	g_return_val_if_fail (GNOME_IS_PILOT_CONDUIT_MANAGEMENT (self), (gint )0);
#line 910 "gnome-pilot-conduit-management.c"
{
#line 652 "gnome-pilot-conduit-management.gob"
	
		gchar *location = self->_priv->mgmtdata->location;
		GModule *dlhandle = self->_priv->dlhandle;
		if (g_module_supported ()!=TRUE) {
			g_warning (_("module loading not supported, fatal!"));
			return GNOME_PILOT_CONDUIT_MGMT_FATAL;
		}
		if ((dlhandle = g_module_open (location,0))==NULL) {
			g_warning ("unable to g_module_open (%s), reason %s", location, g_module_error ());
#ifdef DLOPEN_TEST
			{
				void *handle;
				g_warning ("doing dlopen_test");
				handle = dlopen (location, RTLD_LAZY);
				if (handle == NULL) {
					g_message ("dlopen error is %s",dlerror ());
				}
				dlclose (handle);
			}
#endif
			return GNOME_PILOT_CONDUIT_MGMT_ERROR;
		} 
		if (g_module_symbol (dlhandle,"conduit_load_gpilot_conduit",
				    (gpointer)&(self->_priv->load_func))==FALSE) {
			self->_priv->load_func = NULL;
			/* Try the old loader */
			if (g_module_symbol (dlhandle,"conduit_get_gpilot_conduit",
					     (gpointer)&(self->_priv->old_load_func))==FALSE) {
				g_warning ("malformed conduit, cannot locate symbol"
					   "\"conduit_get_gpilot_conduit\", error %s",
					   g_module_error ());
				return GNOME_PILOT_CONDUIT_MGMT_ERROR;
			}
		}
		if (g_module_symbol (dlhandle,"conduit_destroy_gpilot_conduit",
				    (gpointer)&(self->_priv->destroy_func))==FALSE) {
			g_warning ("malformed conduit, cannot locate symbol"
				  "\"conduit_destroy_gpilot_conduit\", error %s",
				  g_module_error ());
			return GNOME_PILOT_CONDUIT_MGMT_ERROR;
		}
		self->_priv->loaded = TRUE;
		return GNOME_PILOT_CONDUIT_MGMT_OK;
	}}
#line 957 "gnome-pilot-conduit-management.c"
#undef __GOB_FUNCTION__

#line 701 "gnome-pilot-conduit-management.gob"
gint 
gnome_pilot_conduit_management_instantiate_conduit (GnomePilotConduitManagement * self, GPilotPilot * pilot, GnomePilotConduit ** instance)
#line 963 "gnome-pilot-conduit-management.c"
{
#define __GOB_FUNCTION__ "Gnome:Pilot:Conduit:Management::instantiate_conduit"
#line 701 "gnome-pilot-conduit-management.gob"
	g_return_val_if_fail (self != NULL, (gint )GNOME_PILOT_CONDUIT_MGMT_ERROR);
#line 701 "gnome-pilot-conduit-management.gob"
	g_return_val_if_fail (GNOME_IS_PILOT_CONDUIT_MANAGEMENT (self), (gint )GNOME_PILOT_CONDUIT_MGMT_ERROR);
#line 701 "gnome-pilot-conduit-management.gob"
	g_return_val_if_fail (pilot != NULL, (gint )GNOME_PILOT_CONDUIT_MGMT_ERROR);
#line 701 "gnome-pilot-conduit-management.gob"
	g_return_val_if_fail (instance != NULL, (gint )GNOME_PILOT_CONDUIT_MGMT_ERROR);
#line 974 "gnome-pilot-conduit-management.c"
{
#line 706 "gnome-pilot-conduit-management.gob"
	
		gint err = GNOME_PILOT_CONDUIT_MGMT_OK;
		(*instance) = NULL;
		LOCK_INSTANCE;
		if (self->_priv->loaded==FALSE) {
			switch (self->_priv->mgmtdata->type) {
			case GNOME_PILOT_CONDUIT_TYPE_SHLIB: 
				err = self_shlib_loader (self);
				break;
			default:
				g_warning ("unknown conduit type");
				break;
			}
		}
		if (err == GNOME_PILOT_CONDUIT_MGMT_OK) {
			/* Here we check between the old and the new loader */
			if (self->_priv->load_func) {
				(*instance) = self->_priv->load_func (pilot);
			} else {
				(*instance) = self->_priv->old_load_func (pilot->pilot_id);
			}
			/* Set the conduits name field */
			gnome_pilot_conduit_set_name (*instance, self->_priv->mgmtdata->name);
		}
		UNLOCK_INSTANCE;
		return err;
	}}
#line 1004 "gnome-pilot-conduit-management.c"
#undef __GOB_FUNCTION__

#line 735 "gnome-pilot-conduit-management.gob"
gint 
gnome_pilot_conduit_management_destroy_conduit (GnomePilotConduitManagement * self, GnomePilotConduit ** instance)
#line 1010 "gnome-pilot-conduit-management.c"
{
#define __GOB_FUNCTION__ "Gnome:Pilot:Conduit:Management::destroy_conduit"
#line 735 "gnome-pilot-conduit-management.gob"
	g_return_val_if_fail (self != NULL, (gint )GNOME_PILOT_CONDUIT_MGMT_ERROR);
#line 735 "gnome-pilot-conduit-management.gob"
	g_return_val_if_fail (GNOME_IS_PILOT_CONDUIT_MANAGEMENT (self), (gint )GNOME_PILOT_CONDUIT_MGMT_ERROR);
#line 735 "gnome-pilot-conduit-management.gob"
	g_return_val_if_fail (instance != NULL, (gint )GNOME_PILOT_CONDUIT_MGMT_ERROR);
#line 1019 "gnome-pilot-conduit-management.c"
{
#line 738 "gnome-pilot-conduit-management.gob"
	
		LOCK_INSTANCE;
		if (self->_priv->loaded==TRUE) {
			self->_priv->destroy_func (*instance);
		}
		UNLOCK_INSTANCE;
		return GNOME_PILOT_CONDUIT_MGMT_OK;
	}}
#line 1030 "gnome-pilot-conduit-management.c"
#undef __GOB_FUNCTION__


#if (!defined __GNUC__) || (defined __GNUC__ && defined __STRICT_ANSI__)
/*REALLY BAD HACK
  This is to avoid unused warnings if you don't call
  some method.  I need to find a better way to do
  this, not needed in GCC since we use some gcc
  extentions to make saner, faster code */
static void
___gnome_pilot_conduit_management_really_bad_hack_to_avoid_warnings(void)
{
	((void (*)(void))GET_NEW_VARG)();
	((void (*)(void))self_initializer)();
	((void (*)(void))self_new)();
	((void (*)(void))self_destroy)();
	((void (*)(void))self_select_dir_entry)();
	((void (*)(void))self_get_conduit_file_names)();
	((void (*)(void))self_is_other_valid_tag)();
	((void (*)(void))self_check_xml_version)();
	((void (*)(void))self_read_conduit_topdata)();
	((void (*)(void))self_get_lang)();
	((void (*)(void))self_read_conduit_name)();
	((void (*)(void))self_read_conduit_attributes)();
	((void (*)(void))self_read_conduit_xml)();
	((void (*)(void))self_get_name)();
	((void (*)(void))self_get_id)();
	((void (*)(void))self_hfunc_build_name_list)();
	((void (*)(void))self_get_conduits)();
	((void (*)(void))self_attribs_foreach)();
	((void (*)(void))self_attribs_filter_lang_foreach)();
	((void (*)(void))self_get_attribute_list)();
	((void (*)(void))self_get_attribute)();
	((void (*)(void))self_shlib_loader)();
	((void (*)(void))self_instantiate_conduit)();
	((void (*)(void))self_destroy_conduit)();
	___gnome_pilot_conduit_management_really_bad_hack_to_avoid_warnings();
}
#endif /* !__GNUC__ || (__GNUC__ && __STRICT_ANSI__) */


#line 748 "gnome-pilot-conduit-management.gob"



#line 1076 "gnome-pilot-conduit-management.c"
