/* gnome-netinfo - A GUI Interface for network utilities
 * Copyright (C) 2002 by German Poo-Caaman~o
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>

#include "callbacks.h"
#include "traceroute.h"
#include "info.h"
#include "ping.h"
#include "netstat.h"

/* Ping callbacks */
#ifdef PING_PROGRAM
void
on_ping_activate (GtkWidget * widget, gpointer data)
{
	Netinfo *pinger = data;

	g_return_if_fail (pinger != NULL);

	if (pinger->running) {
		ping_stop (pinger);
	} else {
		ping_do (pinger);
	}
}
#endif

/* Traceroute callbacks */
#ifdef TCPTRACEROUTE_PROGRAM
void
on_traceroute_activate (GtkWidget * widget, gpointer data)
{
	Netinfo *tracer = data;

	g_return_if_fail (tracer != NULL);

	if (tracer->running) {
		traceroute_stop (tracer);
	} else {
		traceroute_do (tracer);
	}
}
#endif

#ifdef NETSTAT_PROGRAM
void
on_netstat_activate (GtkWidget * widget, gpointer data)
{
	Netinfo *netstat = data;

	g_return_if_fail (netstat != NULL);

	if (netstat->running) {
		netstat_stop (netstat);
	} else {
		netstat_do (netstat);
	}
}
#endif

/* Info callbacks */
#ifdef IFCONFIG_PROGRAM
void
on_info_nic_changed (GtkEntry * entry, gpointer info)
{
	const gchar *nic;

	g_return_if_fail (info != NULL);

	nic = gtk_entry_get_text (entry);

	if (strlen (nic) > 0) {
		info_do (nic, (netinfo_info *) & info);
	}
}
#endif

void
on_scan_activate (GtkWidget * widget, gpointer data)
{
	Netinfo *scan = data;

	g_return_if_fail (scan != NULL);

	if (scan->running) {
		scan_stop (scan);
	} else {
		scan_do (scan);
	}
}
