/* Device.c generated by valac 0.16.0, the Vala compiler
 * generated from Device.vala, do not modify */

/*
 * Copyright (C) 2008,2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gst/gst.h>


#define DVB_TYPE_ADAPTER_TYPE (dvb_adapter_type_get_type ())

#define DVB_TYPE_DEVICE (dvb_device_get_type ())
#define DVB_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_DEVICE, DVBDevice))
#define DVB_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_DEVICE, DVBDeviceClass))
#define DVB_IS_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_DEVICE))
#define DVB_IS_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_DEVICE))
#define DVB_DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_DEVICE, DVBDeviceClass))

typedef struct _DVBDevice DVBDevice;
typedef struct _DVBDeviceClass DVBDeviceClass;
typedef struct _DVBDevicePrivate DVBDevicePrivate;

#define DVB_TYPE_CHANNEL_LIST (dvb_channel_list_get_type ())
#define DVB_CHANNEL_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL_LIST, DVBChannelList))
#define DVB_CHANNEL_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL_LIST, DVBChannelListClass))
#define DVB_IS_CHANNEL_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL_LIST))
#define DVB_IS_CHANNEL_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL_LIST))
#define DVB_CHANNEL_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL_LIST, DVBChannelListClass))

typedef struct _DVBChannelList DVBChannelList;
typedef struct _DVBChannelListClass DVBChannelListClass;

#define DVB_LOGGING_TYPE_LOGGER (dvb_logging_logger_get_type ())
#define DVB_LOGGING_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLogger))
#define DVB_LOGGING_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLoggerClass))
#define DVB_LOGGING_IS_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_LOGGING_TYPE_LOGGER))
#define DVB_LOGGING_IS_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_LOGGING_TYPE_LOGGER))
#define DVB_LOGGING_LOGGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLoggerClass))

typedef struct _DVBLoggingLogger DVBLoggingLogger;
typedef struct _DVBLoggingLoggerClass DVBLoggingLoggerClass;

#define DVB_LOGGING_TYPE_LOG_MANAGER (dvb_logging_log_manager_get_type ())
#define DVB_LOGGING_LOG_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManager))
#define DVB_LOGGING_LOG_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManagerClass))
#define DVB_LOGGING_IS_LOG_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_LOGGING_TYPE_LOG_MANAGER))
#define DVB_LOGGING_IS_LOG_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_LOGGING_TYPE_LOG_MANAGER))
#define DVB_LOGGING_LOG_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManagerClass))

typedef struct _DVBLoggingLogManager DVBLoggingLogManager;
typedef struct _DVBLoggingLogManagerClass DVBLoggingLogManagerClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _gst_object_unref0(var) ((var == NULL) ? NULL : (var = (gst_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _gst_message_unref0(var) ((var == NULL) ? NULL : (var = (gst_message_unref (var), NULL)))

typedef enum  {
	DVB_DEVICE_ERROR_UNKNOWN_TYPE
} DVBDeviceError;
#define DVB_DEVICE_ERROR dvb_device_error_quark ()
typedef enum  {
	DVB_ADAPTER_TYPE_UNKNOWN,
	DVB_ADAPTER_TYPE_DVB_T,
	DVB_ADAPTER_TYPE_DVB_S,
	DVB_ADAPTER_TYPE_DVB_C
} DVBAdapterType;

struct _DVBDevice {
	GObject parent_instance;
	DVBDevicePrivate * priv;
};

struct _DVBDeviceClass {
	GObjectClass parent_class;
};

struct _DVBDevicePrivate {
	guint _Adapter;
	guint _Frontend;
	DVBChannelList* _Channels;
	GFile* _RecordingsDirectory;
	gchar* adapter_name;
	DVBAdapterType adapter_type;
};


static gpointer dvb_device_parent_class = NULL;
static DVBLoggingLogger* dvb_device_log;
static DVBLoggingLogger* dvb_device_log = NULL;

GQuark dvb_device_error_quark (void);
GType dvb_adapter_type_get_type (void) G_GNUC_CONST;
GType dvb_device_get_type (void) G_GNUC_CONST;
GType dvb_channel_list_get_type (void) G_GNUC_CONST;
#define DVB_DEVICE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_TYPE_DEVICE, DVBDevicePrivate))
enum  {
	DVB_DEVICE_DUMMY_PROPERTY,
	DVB_DEVICE_ADAPTER,
	DVB_DEVICE_FRONTEND,
	DVB_DEVICE_TYPE,
	DVB_DEVICE_NAME,
	DVB_DEVICE_CHANNELS,
	DVB_DEVICE_RECORDINGS_DIRECTORY
};
GType dvb_logging_logger_get_type (void) G_GNUC_CONST;
GType dvb_logging_log_manager_get_type (void) G_GNUC_CONST;
DVBLoggingLogManager* dvb_logging_log_manager_getLogManager (void);
DVBLoggingLogger* dvb_logging_log_manager_getDefaultLogger (DVBLoggingLogManager* self);
#define DVB_DEVICE_PRIME 31
DVBDevice* dvb_device_new (guint adapter, guint frontend);
DVBDevice* dvb_device_construct (GType object_type, guint adapter, guint frontend);
DVBDevice* dvb_device_new_set_type (guint adapter, guint frontend, GFile* channels_conf, GFile* recordings_dir, const gchar* name, DVBAdapterType type);
void dvb_device_set_RecordingsDirectory (DVBDevice* self, GFile* value);
DVBChannelList* dvb_channel_list_new (GFile* channels);
DVBChannelList* dvb_channel_list_construct (GType object_type, GFile* channels);
void dvb_device_set_Channels (DVBDevice* self, DVBChannelList* value);
DVBDevice* dvb_device_new_with_type (guint adapter, guint frontend);
static gboolean dvb_device_setAdapterTypeAndName (DVBDevice* self, guint adapter, guint frontend);
DVBDevice* dvb_device_new_full (guint adapter, guint frontend, GFile* channels_conf, GFile* recordings_dir, GError** error);
DVBAdapterType dvb_device_get_Type (DVBDevice* self);
gboolean dvb_device_equal (DVBDevice* dev1, DVBDevice* dev2);
guint dvb_device_get_Adapter (DVBDevice* self);
guint dvb_device_get_Frontend (DVBDevice* self);
guint dvb_device_hash (DVBDevice* device);
guint dvb_device_hash_without_device (guint adapter, guint frontend);
gboolean dvb_device_is_busy (DVBDevice* self);
void dvb_logging_logger_error (DVBLoggingLogger* self, const gchar* format, ...);
void dvb_logging_logger_debug (DVBLoggingLogger* self, const gchar* format, ...);
DVBAdapterType dvb_device_get_type_from_string (const gchar* adapter_type);
static void dvb_device_set_Adapter (DVBDevice* self, guint value);
static void dvb_device_set_Frontend (DVBDevice* self, guint value);
const gchar* dvb_device_get_Name (DVBDevice* self);
DVBChannelList* dvb_device_get_Channels (DVBDevice* self);
GFile* dvb_device_get_RecordingsDirectory (DVBDevice* self);
static void dvb_device_finalize (GObject* obj);
static void _vala_dvb_device_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_dvb_device_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


GQuark dvb_device_error_quark (void) {
	return g_quark_from_static_string ("dvb_device_error-quark");
}


GType dvb_adapter_type_get_type (void) {
	static volatile gsize dvb_adapter_type_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_adapter_type_type_id__volatile)) {
		static const GEnumValue values[] = {{DVB_ADAPTER_TYPE_UNKNOWN, "DVB_ADAPTER_TYPE_UNKNOWN", "unknown"}, {DVB_ADAPTER_TYPE_DVB_T, "DVB_ADAPTER_TYPE_DVB_T", "dvb-t"}, {DVB_ADAPTER_TYPE_DVB_S, "DVB_ADAPTER_TYPE_DVB_S", "dvb-s"}, {DVB_ADAPTER_TYPE_DVB_C, "DVB_ADAPTER_TYPE_DVB_C", "dvb-c"}, {0, NULL, NULL}};
		GType dvb_adapter_type_type_id;
		dvb_adapter_type_type_id = g_enum_register_static ("DVBAdapterType", values);
		g_once_init_leave (&dvb_adapter_type_type_id__volatile, dvb_adapter_type_type_id);
	}
	return dvb_adapter_type_type_id__volatile;
}


DVBDevice* dvb_device_construct (GType object_type, guint adapter, guint frontend) {
	DVBDevice * self = NULL;
	guint _tmp0_;
	guint _tmp1_;
	_tmp0_ = adapter;
	_tmp1_ = frontend;
	self = (DVBDevice*) g_object_new (object_type, "Adapter", _tmp0_, "Frontend", _tmp1_, NULL);
	return self;
}


DVBDevice* dvb_device_new (guint adapter, guint frontend) {
	return dvb_device_construct (DVB_TYPE_DEVICE, adapter, frontend);
}


DVBDevice* dvb_device_new_set_type (guint adapter, guint frontend, GFile* channels_conf, GFile* recordings_dir, const gchar* name, DVBAdapterType type) {
	DVBDevice* result = NULL;
	guint _tmp0_;
	guint _tmp1_;
	DVBDevice* _tmp2_;
	DVBDevice* dev;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	DVBAdapterType _tmp5_;
	GFile* _tmp6_;
	GFile* _tmp7_;
	DVBChannelList* _tmp8_;
	DVBChannelList* _tmp9_;
	g_return_val_if_fail (channels_conf != NULL, NULL);
	g_return_val_if_fail (recordings_dir != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = adapter;
	_tmp1_ = frontend;
	_tmp2_ = dvb_device_new (_tmp0_, _tmp1_);
	dev = _tmp2_;
	_tmp3_ = name;
	_tmp4_ = g_strdup (_tmp3_);
	_g_free0 (dev->priv->adapter_name);
	dev->priv->adapter_name = _tmp4_;
	_tmp5_ = type;
	dev->priv->adapter_type = _tmp5_;
	_tmp6_ = recordings_dir;
	dvb_device_set_RecordingsDirectory (dev, _tmp6_);
	_tmp7_ = channels_conf;
	_tmp8_ = dvb_channel_list_new (_tmp7_);
	_tmp9_ = _tmp8_;
	dvb_device_set_Channels (dev, _tmp9_);
	_g_object_unref0 (_tmp9_);
	result = dev;
	return result;
}


DVBDevice* dvb_device_new_with_type (guint adapter, guint frontend) {
	DVBDevice* result = NULL;
	guint _tmp0_;
	guint _tmp1_;
	DVBDevice* _tmp2_;
	DVBDevice* device;
	guint _tmp3_;
	guint _tmp4_;
	_tmp0_ = adapter;
	_tmp1_ = frontend;
	_tmp2_ = dvb_device_new (_tmp0_, _tmp1_);
	device = _tmp2_;
	_tmp3_ = adapter;
	_tmp4_ = frontend;
	dvb_device_setAdapterTypeAndName (device, _tmp3_, _tmp4_);
	result = device;
	return result;
}


DVBDevice* dvb_device_new_full (guint adapter, guint frontend, GFile* channels_conf, GFile* recordings_dir, GError** error) {
	DVBDevice* result = NULL;
	guint _tmp0_;
	guint _tmp1_;
	DVBDevice* _tmp2_ = NULL;
	DVBDevice* device;
	DVBDevice* _tmp3_;
	DVBAdapterType _tmp4_;
	DVBAdapterType _tmp5_;
	DVBDevice* _tmp9_;
	GFile* _tmp10_;
	DVBDevice* _tmp11_;
	GFile* _tmp12_;
	DVBChannelList* _tmp13_;
	DVBChannelList* _tmp14_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (channels_conf != NULL, NULL);
	g_return_val_if_fail (recordings_dir != NULL, NULL);
	_tmp0_ = adapter;
	_tmp1_ = frontend;
	_tmp2_ = dvb_device_new_with_type (_tmp0_, _tmp1_);
	device = _tmp2_;
	_tmp3_ = device;
	_tmp4_ = dvb_device_get_Type (_tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_ == DVB_ADAPTER_TYPE_UNKNOWN) {
		guint _tmp6_;
		guint _tmp7_;
		GError* _tmp8_;
		_tmp6_ = adapter;
		_tmp7_ = frontend;
		_tmp8_ = g_error_new (DVB_DEVICE_ERROR, DVB_DEVICE_ERROR_UNKNOWN_TYPE, "device %u,%u has unknown type", _tmp6_, _tmp7_);
		_inner_error_ = _tmp8_;
		if (_inner_error_->domain == DVB_DEVICE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (device);
			return NULL;
		} else {
			_g_object_unref0 (device);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp9_ = device;
	_tmp10_ = recordings_dir;
	dvb_device_set_RecordingsDirectory (_tmp9_, _tmp10_);
	_tmp11_ = device;
	_tmp12_ = channels_conf;
	_tmp13_ = dvb_channel_list_new (_tmp12_);
	_tmp14_ = _tmp13_;
	dvb_device_set_Channels (_tmp11_, _tmp14_);
	_g_object_unref0 (_tmp14_);
	result = device;
	return result;
}


gboolean dvb_device_equal (DVBDevice* dev1, DVBDevice* dev2) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	DVBDevice* _tmp1_;
	gboolean _tmp3_;
	gboolean _tmp4_ = FALSE;
	DVBDevice* _tmp5_;
	guint _tmp6_;
	DVBDevice* _tmp7_;
	guint _tmp8_;
	gboolean _tmp13_;
	_tmp1_ = dev1;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		DVBDevice* _tmp2_;
		_tmp2_ = dev2;
		_tmp0_ = _tmp2_ == NULL;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		result = FALSE;
		return result;
	}
	_tmp5_ = dev1;
	_tmp6_ = _tmp5_->priv->_Adapter;
	_tmp7_ = dev2;
	_tmp8_ = _tmp7_->priv->_Adapter;
	if (_tmp6_ == _tmp8_) {
		DVBDevice* _tmp9_;
		guint _tmp10_;
		DVBDevice* _tmp11_;
		guint _tmp12_;
		_tmp9_ = dev2;
		_tmp10_ = _tmp9_->priv->_Frontend;
		_tmp11_ = dev2;
		_tmp12_ = _tmp11_->priv->_Frontend;
		_tmp4_ = _tmp10_ == _tmp12_;
	} else {
		_tmp4_ = FALSE;
	}
	_tmp13_ = _tmp4_;
	result = _tmp13_;
	return result;
}


guint dvb_device_hash (DVBDevice* device) {
	guint result = 0U;
	DVBDevice* _tmp0_;
	DVBDevice* _tmp1_;
	guint _tmp2_;
	DVBDevice* _tmp3_;
	guint _tmp4_;
	guint _tmp5_ = 0U;
	_tmp0_ = device;
	if (_tmp0_ == NULL) {
		result = (guint) 0;
		return result;
	}
	_tmp1_ = device;
	_tmp2_ = _tmp1_->priv->_Adapter;
	_tmp3_ = device;
	_tmp4_ = _tmp3_->priv->_Frontend;
	_tmp5_ = dvb_device_hash_without_device (_tmp2_, _tmp4_);
	result = _tmp5_;
	return result;
}


guint dvb_device_hash_without_device (guint adapter, guint frontend) {
	guint result = 0U;
	guint _tmp0_;
	guint _tmp1_;
	_tmp0_ = adapter;
	_tmp1_ = frontend;
	result = ((2 * DVB_DEVICE_PRIME) + (DVB_DEVICE_PRIME * _tmp0_)) + _tmp1_;
	return result;
}


gboolean dvb_device_is_busy (DVBDevice* self) {
	gboolean result = FALSE;
	GstElement* _tmp0_ = NULL;
	GstElement* dvbsrc;
	GstElement* _tmp1_;
	GstElement* _tmp3_;
	guint _tmp4_;
	GstElement* _tmp5_;
	guint _tmp6_;
	GstPipeline* _tmp7_;
	GstElement* pipeline;
	GstElement* _tmp8_;
	GstElement* _tmp9_;
	GstElement* _tmp10_;
	GstElement* _tmp11_;
	GstBus* _tmp12_ = NULL;
	GstBus* bus;
	gboolean busy_val;
	GstElement* _tmp31_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = gst_element_factory_make ("dvbsrc", "text_dvbsrc");
	gst_object_ref_sink (_tmp0_);
	dvbsrc = _tmp0_;
	_tmp1_ = dvbsrc;
	if (_tmp1_ == NULL) {
		DVBLoggingLogger* _tmp2_;
		_tmp2_ = dvb_device_log;
		dvb_logging_logger_error (_tmp2_, "Device.vala:121: Could not create dvbsrc element");
		result = TRUE;
		_gst_object_unref0 (dvbsrc);
		return result;
	}
	_tmp3_ = dvbsrc;
	_tmp4_ = self->priv->_Adapter;
	g_object_set ((GObject*) _tmp3_, "adapter", _tmp4_, NULL);
	_tmp5_ = dvbsrc;
	_tmp6_ = self->priv->_Frontend;
	g_object_set ((GObject*) _tmp5_, "frontend", _tmp6_, NULL);
	_tmp7_ = (GstPipeline*) gst_pipeline_new ("");
	gst_object_ref_sink (_tmp7_);
	pipeline = (GstElement*) _tmp7_;
	_tmp8_ = pipeline;
	_tmp9_ = dvbsrc;
	gst_bin_add (GST_BIN (_tmp8_), _tmp9_);
	_tmp10_ = pipeline;
	gst_element_set_state (_tmp10_, GST_STATE_READY);
	_tmp11_ = pipeline;
	_tmp12_ = gst_element_get_bus (_tmp11_);
	bus = _tmp12_;
	busy_val = FALSE;
	while (TRUE) {
		GstBus* _tmp13_;
		gboolean _tmp14_ = FALSE;
		GstBus* _tmp15_;
		GstMessage* _tmp16_ = NULL;
		GstMessage* msg;
		gboolean _tmp17_ = FALSE;
		GstMessage* _tmp18_;
		GstMessageType _tmp19_;
		gboolean _tmp23_;
		_tmp13_ = bus;
		_tmp14_ = gst_bus_have_pending (_tmp13_);
		if (!_tmp14_) {
			break;
		}
		_tmp15_ = bus;
		_tmp16_ = gst_bus_pop (_tmp15_);
		msg = _tmp16_;
		_tmp18_ = msg;
		_tmp19_ = _tmp18_->type;
		if (_tmp19_ == GST_MESSAGE_ERROR) {
			GstMessage* _tmp20_;
			GstObject* _tmp21_;
			GstElement* _tmp22_;
			_tmp20_ = msg;
			_tmp21_ = _tmp20_->src;
			_tmp22_ = dvbsrc;
			_tmp17_ = _tmp21_ == GST_OBJECT (_tmp22_);
		} else {
			_tmp17_ = FALSE;
		}
		_tmp23_ = _tmp17_;
		if (_tmp23_) {
			GError* gerror = NULL;
			gchar* debug_text = NULL;
			GstMessage* _tmp24_;
			GError* _tmp25_ = NULL;
			gchar* _tmp26_ = NULL;
			DVBLoggingLogger* _tmp27_;
			GError* _tmp28_;
			const gchar* _tmp29_;
			const gchar* _tmp30_;
			_tmp24_ = msg;
			gst_message_parse_error (_tmp24_, &_tmp25_, &_tmp26_);
			_g_error_free0 (gerror);
			gerror = _tmp25_;
			_g_free0 (debug_text);
			debug_text = _tmp26_;
			_tmp27_ = dvb_device_log;
			_tmp28_ = gerror;
			_tmp29_ = _tmp28_->message;
			_tmp30_ = debug_text;
			dvb_logging_logger_debug (_tmp27_, "Device.vala:143: Error tuning: %s; %s", _tmp29_, _tmp30_);
			busy_val = TRUE;
			_g_free0 (debug_text);
			_g_error_free0 (gerror);
		}
		_gst_message_unref0 (msg);
	}
	_tmp31_ = pipeline;
	gst_element_set_state (_tmp31_, GST_STATE_NULL);
	result = busy_val;
	_gst_object_unref0 (bus);
	_gst_object_unref0 (pipeline);
	_gst_object_unref0 (dvbsrc);
	return result;
}


static gboolean dvb_device_setAdapterTypeAndName (DVBDevice* self, guint adapter, guint frontend) {
	gboolean result = FALSE;
	GstElement* _tmp0_ = NULL;
	GstElement* dvbsrc;
	GstElement* _tmp1_;
	GstElement* _tmp3_;
	guint _tmp4_;
	GstElement* _tmp5_;
	guint _tmp6_;
	GstPipeline* _tmp7_;
	GstElement* pipeline;
	GstElement* _tmp8_;
	GstElement* _tmp9_;
	GstElement* _tmp10_;
	GstElement* _tmp11_;
	GstBus* _tmp12_ = NULL;
	GstBus* bus;
	gboolean success;
	gchar* adapter_type;
	GstElement* _tmp42_;
	const gchar* _tmp43_;
	DVBAdapterType _tmp44_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = gst_element_factory_make ("dvbsrc", "test_dvbsrc");
	gst_object_ref_sink (_tmp0_);
	dvbsrc = _tmp0_;
	_tmp1_ = dvbsrc;
	if (_tmp1_ == NULL) {
		DVBLoggingLogger* _tmp2_;
		_tmp2_ = dvb_device_log;
		dvb_logging_logger_error (_tmp2_, "Device.vala:157: Could not create dvbsrc element");
		result = FALSE;
		_gst_object_unref0 (dvbsrc);
		return result;
	}
	_tmp3_ = dvbsrc;
	_tmp4_ = adapter;
	g_object_set ((GObject*) _tmp3_, "adapter", _tmp4_, NULL);
	_tmp5_ = dvbsrc;
	_tmp6_ = frontend;
	g_object_set ((GObject*) _tmp5_, "frontend", _tmp6_, NULL);
	_tmp7_ = (GstPipeline*) gst_pipeline_new ("type_name");
	gst_object_ref_sink (_tmp7_);
	pipeline = (GstElement*) _tmp7_;
	_tmp8_ = pipeline;
	_tmp9_ = dvbsrc;
	gst_bin_add (GST_BIN (_tmp8_), _tmp9_);
	_tmp10_ = pipeline;
	gst_element_set_state (_tmp10_, GST_STATE_READY);
	_tmp11_ = pipeline;
	_tmp12_ = gst_element_get_bus (_tmp11_);
	bus = _tmp12_;
	success = FALSE;
	adapter_type = NULL;
	while (TRUE) {
		GstBus* _tmp13_;
		gboolean _tmp14_ = FALSE;
		GstBus* _tmp15_;
		GstMessage* _tmp16_ = NULL;
		GstMessage* msg;
		gboolean _tmp17_ = FALSE;
		GstMessage* _tmp18_;
		GstMessageType _tmp19_;
		gboolean _tmp23_;
		_tmp13_ = bus;
		_tmp14_ = gst_bus_have_pending (_tmp13_);
		if (!_tmp14_) {
			break;
		}
		_tmp15_ = bus;
		_tmp16_ = gst_bus_pop (_tmp15_);
		msg = _tmp16_;
		_tmp18_ = msg;
		_tmp19_ = _tmp18_->type;
		if (_tmp19_ == GST_MESSAGE_ELEMENT) {
			GstMessage* _tmp20_;
			GstObject* _tmp21_;
			GstElement* _tmp22_;
			_tmp20_ = msg;
			_tmp21_ = _tmp20_->src;
			_tmp22_ = dvbsrc;
			_tmp17_ = _tmp21_ == GST_OBJECT (_tmp22_);
		} else {
			_tmp17_ = FALSE;
		}
		_tmp23_ = _tmp17_;
		if (_tmp23_) {
			GstMessage* _tmp24_;
			const GstStructure* _tmp25_ = NULL;
			const GstStructure* structure;
			const GstStructure* _tmp26_;
			const gchar* _tmp27_ = NULL;
			_tmp24_ = msg;
			_tmp25_ = gst_message_get_structure (_tmp24_);
			structure = _tmp25_;
			_tmp26_ = structure;
			_tmp27_ = gst_structure_get_name (_tmp26_);
			if (g_strcmp0 (_tmp27_, "dvb-adapter") == 0) {
				const GstStructure* _tmp28_;
				const gchar* _tmp29_ = NULL;
				gchar* _tmp30_ = NULL;
				const GstStructure* _tmp31_;
				const gchar* _tmp32_ = NULL;
				gchar* _tmp33_ = NULL;
				_tmp28_ = structure;
				_tmp29_ = gst_structure_get_string (_tmp28_, "type");
				_tmp30_ = g_strdup_printf ("%s", _tmp29_);
				_g_free0 (adapter_type);
				adapter_type = _tmp30_;
				_tmp31_ = structure;
				_tmp32_ = gst_structure_get_string (_tmp31_, "name");
				_tmp33_ = g_strdup_printf ("%s", _tmp32_);
				_g_free0 (self->priv->adapter_name);
				self->priv->adapter_name = _tmp33_;
				success = TRUE;
				_gst_message_unref0 (msg);
				break;
			}
		} else {
			GstMessage* _tmp34_;
			GstMessageType _tmp35_;
			_tmp34_ = msg;
			_tmp35_ = _tmp34_->type;
			if (_tmp35_ == GST_MESSAGE_ERROR) {
				GError* gerror = NULL;
				gchar* debug = NULL;
				GstMessage* _tmp36_;
				GError* _tmp37_ = NULL;
				gchar* _tmp38_ = NULL;
				GError* _tmp39_;
				const gchar* _tmp40_;
				const gchar* _tmp41_;
				_tmp36_ = msg;
				gst_message_parse_error (_tmp36_, &_tmp37_, &_tmp38_);
				_g_error_free0 (gerror);
				gerror = _tmp37_;
				_g_free0 (debug);
				debug = _tmp38_;
				_tmp39_ = gerror;
				_tmp40_ = _tmp39_->message;
				_tmp41_ = debug;
				g_warning ("Device.vala:188: %s %s", _tmp40_, _tmp41_);
				_g_free0 (debug);
				_g_error_free0 (gerror);
			}
		}
		_gst_message_unref0 (msg);
	}
	_tmp42_ = pipeline;
	gst_element_set_state (_tmp42_, GST_STATE_NULL);
	_tmp43_ = adapter_type;
	_tmp44_ = dvb_device_get_type_from_string (_tmp43_);
	self->priv->adapter_type = _tmp44_;
	result = success;
	_g_free0 (adapter_type);
	_gst_object_unref0 (bus);
	_gst_object_unref0 (pipeline);
	_gst_object_unref0 (dvbsrc);
	return result;
}


DVBAdapterType dvb_device_get_type_from_string (const gchar* adapter_type) {
	DVBAdapterType result = 0;
	const gchar* _tmp0_;
	DVBAdapterType type = 0;
	const gchar* _tmp1_;
	_tmp0_ = adapter_type;
	if (_tmp0_ == NULL) {
		result = DVB_ADAPTER_TYPE_UNKNOWN;
		return result;
	}
	_tmp1_ = adapter_type;
	if (g_strcmp0 (_tmp1_, "DVB-T") == 0) {
		type = DVB_ADAPTER_TYPE_DVB_T;
	} else {
		const gchar* _tmp2_;
		_tmp2_ = adapter_type;
		if (g_strcmp0 (_tmp2_, "DVB-S") == 0) {
			type = DVB_ADAPTER_TYPE_DVB_S;
		} else {
			const gchar* _tmp3_;
			_tmp3_ = adapter_type;
			if (g_strcmp0 (_tmp3_, "DVB-C") == 0) {
				type = DVB_ADAPTER_TYPE_DVB_C;
			} else {
				type = DVB_ADAPTER_TYPE_UNKNOWN;
			}
		}
	}
	result = type;
	return result;
}


guint dvb_device_get_Adapter (DVBDevice* self) {
	guint result;
	guint _tmp0_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->_Adapter;
	result = _tmp0_;
	return result;
}


static void dvb_device_set_Adapter (DVBDevice* self, guint value) {
	guint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_Adapter = _tmp0_;
	g_object_notify ((GObject *) self, "Adapter");
}


guint dvb_device_get_Frontend (DVBDevice* self) {
	guint result;
	guint _tmp0_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->_Frontend;
	result = _tmp0_;
	return result;
}


static void dvb_device_set_Frontend (DVBDevice* self, guint value) {
	guint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_Frontend = _tmp0_;
	g_object_notify ((GObject *) self, "Frontend");
}


DVBAdapterType dvb_device_get_Type (DVBDevice* self) {
	DVBAdapterType result;
	DVBAdapterType _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->adapter_type;
	result = _tmp0_;
	return result;
}


const gchar* dvb_device_get_Name (DVBDevice* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->adapter_name;
	result = _tmp0_;
	return result;
}


DVBChannelList* dvb_device_get_Channels (DVBDevice* self) {
	DVBChannelList* result;
	DVBChannelList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_Channels;
	result = _tmp0_;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void dvb_device_set_Channels (DVBDevice* self, DVBChannelList* value) {
	DVBChannelList* _tmp0_;
	DVBChannelList* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_Channels);
	self->priv->_Channels = _tmp1_;
	g_object_notify ((GObject *) self, "Channels");
}


GFile* dvb_device_get_RecordingsDirectory (DVBDevice* self) {
	GFile* result;
	GFile* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_RecordingsDirectory;
	result = _tmp0_;
	return result;
}


void dvb_device_set_RecordingsDirectory (DVBDevice* self, GFile* value) {
	GFile* _tmp0_;
	GFile* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_RecordingsDirectory);
	self->priv->_RecordingsDirectory = _tmp1_;
	g_object_notify ((GObject *) self, "RecordingsDirectory");
}


static void dvb_device_class_init (DVBDeviceClass * klass) {
	DVBLoggingLogManager* _tmp0_ = NULL;
	DVBLoggingLogger* _tmp1_ = NULL;
	dvb_device_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBDevicePrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_dvb_device_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_dvb_device_set_property;
	G_OBJECT_CLASS (klass)->finalize = dvb_device_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_DEVICE_ADAPTER, g_param_spec_uint ("Adapter", "Adapter", "Adapter", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_DEVICE_FRONTEND, g_param_spec_uint ("Frontend", "Frontend", "Frontend", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_DEVICE_TYPE, g_param_spec_enum ("Type", "Type", "Type", DVB_TYPE_ADAPTER_TYPE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_DEVICE_NAME, g_param_spec_string ("Name", "Name", "Name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_DEVICE_CHANNELS, g_param_spec_object ("Channels", "Channels", "Channels", DVB_TYPE_CHANNEL_LIST, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_DEVICE_RECORDINGS_DIRECTORY, g_param_spec_object ("RecordingsDirectory", "RecordingsDirectory", "RecordingsDirectory", G_TYPE_FILE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	_tmp0_ = dvb_logging_log_manager_getLogManager ();
	_tmp1_ = dvb_logging_log_manager_getDefaultLogger (_tmp0_);
	dvb_device_log = _tmp1_;
}


static void dvb_device_instance_init (DVBDevice * self) {
	self->priv = DVB_DEVICE_GET_PRIVATE (self);
}


static void dvb_device_finalize (GObject* obj) {
	DVBDevice * self;
	self = DVB_DEVICE (obj);
	_g_object_unref0 (self->priv->_Channels);
	_g_object_unref0 (self->priv->_RecordingsDirectory);
	_g_free0 (self->priv->adapter_name);
	G_OBJECT_CLASS (dvb_device_parent_class)->finalize (obj);
}


GType dvb_device_get_type (void) {
	static volatile gsize dvb_device_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_device_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBDeviceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_device_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBDevice), 0, (GInstanceInitFunc) dvb_device_instance_init, NULL };
		GType dvb_device_type_id;
		dvb_device_type_id = g_type_register_static (G_TYPE_OBJECT, "DVBDevice", &g_define_type_info, 0);
		g_once_init_leave (&dvb_device_type_id__volatile, dvb_device_type_id);
	}
	return dvb_device_type_id__volatile;
}


static void _vala_dvb_device_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DVBDevice * self;
	self = DVB_DEVICE (object);
	switch (property_id) {
		case DVB_DEVICE_ADAPTER:
		g_value_set_uint (value, dvb_device_get_Adapter (self));
		break;
		case DVB_DEVICE_FRONTEND:
		g_value_set_uint (value, dvb_device_get_Frontend (self));
		break;
		case DVB_DEVICE_TYPE:
		g_value_set_enum (value, dvb_device_get_Type (self));
		break;
		case DVB_DEVICE_NAME:
		g_value_set_string (value, dvb_device_get_Name (self));
		break;
		case DVB_DEVICE_CHANNELS:
		g_value_set_object (value, dvb_device_get_Channels (self));
		break;
		case DVB_DEVICE_RECORDINGS_DIRECTORY:
		g_value_set_object (value, dvb_device_get_RecordingsDirectory (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_dvb_device_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DVBDevice * self;
	self = DVB_DEVICE (object);
	switch (property_id) {
		case DVB_DEVICE_ADAPTER:
		dvb_device_set_Adapter (self, g_value_get_uint (value));
		break;
		case DVB_DEVICE_FRONTEND:
		dvb_device_set_Frontend (self, g_value_get_uint (value));
		break;
		case DVB_DEVICE_CHANNELS:
		dvb_device_set_Channels (self, g_value_get_object (value));
		break;
		case DVB_DEVICE_RECORDINGS_DIRECTORY:
		dvb_device_set_RecordingsDirectory (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



