/* CableScanner.c generated by valac 0.16.0, the Vala compiler
 * generated from CableScanner.vala, do not modify */

/*
 * Copyright (C) 2008-2010 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gst/gst.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gio/gio.h>


#define DVB_TYPE_SCANNER (dvb_scanner_get_type ())
#define DVB_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_SCANNER, DVBScanner))
#define DVB_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_SCANNER, DVBScannerClass))
#define DVB_IS_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_SCANNER))
#define DVB_IS_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_SCANNER))
#define DVB_SCANNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_SCANNER, DVBScannerClass))

typedef struct _DVBScanner DVBScanner;
typedef struct _DVBScannerClass DVBScannerClass;
typedef struct _DVBScannerPrivate DVBScannerPrivate;

#define DVB_TYPE_SCANNED_ITEM (dvb_scanned_item_get_type ())
#define DVB_SCANNED_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_SCANNED_ITEM, DVBScannedItem))
#define DVB_SCANNED_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_SCANNED_ITEM, DVBScannedItemClass))
#define DVB_IS_SCANNED_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_SCANNED_ITEM))
#define DVB_IS_SCANNED_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_SCANNED_ITEM))
#define DVB_SCANNED_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_SCANNED_ITEM, DVBScannedItemClass))

typedef struct _DVBScannedItem DVBScannedItem;
typedef struct _DVBScannedItemClass DVBScannedItemClass;

#define DVB_TYPE_CHANNEL (dvb_channel_get_type ())
#define DVB_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL, DVBChannel))
#define DVB_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL, DVBChannelClass))
#define DVB_IS_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL))
#define DVB_IS_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL))
#define DVB_CHANNEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL, DVBChannelClass))

typedef struct _DVBChannel DVBChannel;
typedef struct _DVBChannelClass DVBChannelClass;

#define DVB_TYPE_CHANNEL_LIST (dvb_channel_list_get_type ())
#define DVB_CHANNEL_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL_LIST, DVBChannelList))
#define DVB_CHANNEL_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL_LIST, DVBChannelListClass))
#define DVB_IS_CHANNEL_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL_LIST))
#define DVB_IS_CHANNEL_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL_LIST))
#define DVB_CHANNEL_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL_LIST, DVBChannelListClass))

typedef struct _DVBChannelList DVBChannelList;
typedef struct _DVBChannelListClass DVBChannelListClass;

#define DVB_TYPE_ID_BUS_SCANNER (dvb_id_bus_scanner_get_type ())
#define DVB_ID_BUS_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_ID_BUS_SCANNER, DVBIDBusScanner))
#define DVB_IS_ID_BUS_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_ID_BUS_SCANNER))
#define DVB_ID_BUS_SCANNER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DVB_TYPE_ID_BUS_SCANNER, DVBIDBusScannerIface))

typedef struct _DVBIDBusScanner DVBIDBusScanner;
typedef struct _DVBIDBusScannerIface DVBIDBusScannerIface;

#define DVB_TYPE_ID_BUS_SCANNER_PROXY (dvb_id_bus_scanner_proxy_get_type ())

#define DVB_TYPE_CABLE_SCANNER (dvb_cable_scanner_get_type ())
#define DVB_CABLE_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CABLE_SCANNER, DVBCableScanner))
#define DVB_CABLE_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CABLE_SCANNER, DVBCableScannerClass))
#define DVB_IS_CABLE_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CABLE_SCANNER))
#define DVB_IS_CABLE_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CABLE_SCANNER))
#define DVB_CABLE_SCANNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CABLE_SCANNER, DVBCableScannerClass))

typedef struct _DVBCableScanner DVBCableScanner;
typedef struct _DVBCableScannerClass DVBCableScannerClass;
typedef struct _DVBCableScannerPrivate DVBCableScannerPrivate;

#define DVB_TYPE_DEVICE (dvb_device_get_type ())
#define DVB_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_DEVICE, DVBDevice))
#define DVB_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_DEVICE, DVBDeviceClass))
#define DVB_IS_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_DEVICE))
#define DVB_IS_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_DEVICE))
#define DVB_DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_DEVICE, DVBDeviceClass))

typedef struct _DVBDevice DVBDevice;
typedef struct _DVBDeviceClass DVBDeviceClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _gst_structure_free0(var) ((var == NULL) ? NULL : (var = (gst_structure_free (var), NULL)))

#define DVB_TYPE_DVB_SRC_MODULATION (dvb_dvb_src_modulation_get_type ())

#define DVB_TYPE_DVB_SRC_CODE_RATE (dvb_dvb_src_code_rate_get_type ())
#define _gst_object_unref0(var) ((var == NULL) ? NULL : (var = (gst_object_unref (var), NULL)))

#define DVB_TYPE_CABLE_CHANNEL (dvb_cable_channel_get_type ())
#define DVB_CABLE_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CABLE_CHANNEL, DVBCableChannel))
#define DVB_CABLE_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CABLE_CHANNEL, DVBCableChannelClass))
#define DVB_IS_CABLE_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CABLE_CHANNEL))
#define DVB_IS_CABLE_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CABLE_CHANNEL))
#define DVB_CABLE_CHANNEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CABLE_CHANNEL, DVBCableChannelClass))

typedef struct _DVBCableChannel DVBCableChannel;
typedef struct _DVBCableChannelClass DVBCableChannelClass;

#define DVB_TYPE_DVB_SRC_INVERSION (dvb_dvb_src_inversion_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _DVBScanner {
	GObject parent_instance;
	DVBScannerPrivate * priv;
	DVBChannelList* channels;
	GstElement* pipeline;
	GQueue* frequencies;
	GstStructure* current_tuning_params;
	GeeHashSet* scanned_frequencies;
};

struct _DVBScannerClass {
	GObjectClass parent_class;
	void (*prepare) (DVBScanner* self);
	DVBScannedItem* (*get_scanned_item) (DVBScanner* self, const GstStructure* structure);
	DVBChannel* (*get_new_channel) (DVBScanner* self);
	void (*add_values_from_structure_to_channel) (DVBScanner* self, const GstStructure* delivery, DVBChannel* channel);
	void (*add_scanning_data_from_string) (DVBScanner* self, const gchar* line);
};

struct _DVBIDBusScannerIface {
	GTypeInterface parent_iface;
	void (*Run) (DVBIDBusScanner* self, GError** error);
	void (*Destroy) (DVBIDBusScanner* self, GError** error);
	gboolean (*WriteAllChannelsToFile) (DVBIDBusScanner* self, const gchar* path, GError** error);
	gboolean (*WriteChannelsToFile) (DVBIDBusScanner* self, guint* channel_sids, int channel_sids_length1, const gchar* path, GError** error);
	gboolean (*AddScanningData) (DVBIDBusScanner* self, GHashTable* data, GError** error);
	gboolean (*AddScanningDataFromFile) (DVBIDBusScanner* self, const gchar* path, GError** error);
};

struct _DVBCableScanner {
	DVBScanner parent_instance;
	DVBCableScannerPrivate * priv;
};

struct _DVBCableScannerClass {
	DVBScannerClass parent_class;
};

typedef enum  {
	DVB_DVB_SRC_MODULATION_QPSK,
	DVB_DVB_SRC_MODULATION_QAM_16,
	DVB_DVB_SRC_MODULATION_QAM_32,
	DVB_DVB_SRC_MODULATION_QAM_64,
	DVB_DVB_SRC_MODULATION_QAM_128,
	DVB_DVB_SRC_MODULATION_QAM_256,
	DVB_DVB_SRC_MODULATION_QAM_AUTO
} DVBDvbSrcModulation;

typedef enum  {
	DVB_DVB_SRC_CODE_RATE_FEC_NONE,
	DVB_DVB_SRC_CODE_RATE_FEC_1_2,
	DVB_DVB_SRC_CODE_RATE_FEC_2_3,
	DVB_DVB_SRC_CODE_RATE_FEC_3_4,
	DVB_DVB_SRC_CODE_RATE_FEC_4_5,
	DVB_DVB_SRC_CODE_RATE_FEC_5_6,
	DVB_DVB_SRC_CODE_RATE_FEC_6_7,
	DVB_DVB_SRC_CODE_RATE_FEC_7_8,
	DVB_DVB_SRC_CODE_RATE_FEC_8_9,
	DVB_DVB_SRC_CODE_RATE_FEC_AUTO
} DVBDvbSrcCodeRate;

typedef enum  {
	DVB_DVB_SRC_INVERSION_INVERSION_OFF,
	DVB_DVB_SRC_INVERSION_INVERSION_ON,
	DVB_DVB_SRC_INVERSION_INVERSION_AUTO
} DVBDvbSrcInversion;


static gpointer dvb_cable_scanner_parent_class = NULL;
static DVBIDBusScannerIface* dvb_cable_scanner_dvb_id_bus_scanner_parent_iface = NULL;

GType dvb_scanner_get_type (void) G_GNUC_CONST;
GType dvb_scanned_item_get_type (void) G_GNUC_CONST;
GType dvb_channel_get_type (void) G_GNUC_CONST;
GType dvb_channel_list_get_type (void) G_GNUC_CONST;
GType dvb_id_bus_scanner_proxy_get_type (void) G_GNUC_CONST;
guint dvb_id_bus_scanner_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType dvb_id_bus_scanner_get_type (void) G_GNUC_CONST;
GType dvb_cable_scanner_get_type (void) G_GNUC_CONST;
enum  {
	DVB_CABLE_SCANNER_DUMMY_PROPERTY
};
GType dvb_device_get_type (void) G_GNUC_CONST;
DVBCableScanner* dvb_cable_scanner_new (DVBDevice* device);
DVBCableScanner* dvb_cable_scanner_construct (GType object_type, DVBDevice* device);
static gboolean dvb_cable_scanner_real_AddScanningData (DVBIDBusScanner* base, GHashTable* data, GError** error);
static inline void dvb_cable_scanner_add_scanning_data (DVBCableScanner* self, guint frequency, const gchar* modulation, guint symbol_rate, const gchar* code_rate);
void dvb_scanner_add_structure_to_scan (DVBScanner* self, GstStructure* structure);
static void dvb_cable_scanner_real_add_scanning_data_from_string (DVBScanner* base, const gchar* line);
static void dvb_cable_scanner_real_prepare (DVBScanner* base);
void dvb_scanner_set_uint_property (GstElement* src, const GstStructure* params, const gchar* key);
GType dvb_dvb_src_modulation_get_type (void) G_GNUC_CONST;
DVBDvbSrcModulation dvb_get_modulation_val (const gchar* constellation);
GType dvb_dvb_src_code_rate_get_type (void) G_GNUC_CONST;
DVBDvbSrcCodeRate dvb_get_code_rate_val (const gchar* code_rate_string);
static DVBScannedItem* dvb_cable_scanner_real_get_scanned_item (DVBScanner* base, const GstStructure* structure);
DVBScannedItem* dvb_scanned_item_new (guint frequency);
DVBScannedItem* dvb_scanned_item_construct (GType object_type, guint frequency);
static DVBChannel* dvb_cable_scanner_real_get_new_channel (DVBScanner* base);
DVBCableChannel* dvb_cable_channel_new_without_schedule (void);
DVBCableChannel* dvb_cable_channel_construct_without_schedule (GType object_type);
GType dvb_cable_channel_get_type (void) G_GNUC_CONST;
static void dvb_cable_scanner_real_add_values_from_structure_to_channel (DVBScanner* base, const GstStructure* delivery, DVBChannel* channel);
GType dvb_dvb_src_inversion_get_type (void) G_GNUC_CONST;
void dvb_cable_channel_set_Inversion (DVBCableChannel* self, DVBDvbSrcInversion value);
void dvb_cable_channel_set_Modulation (DVBCableChannel* self, DVBDvbSrcModulation value);
void dvb_channel_set_Frequency (DVBChannel* self, guint value);
void dvb_cable_channel_set_SymbolRate (DVBCableChannel* self, guint value);
void dvb_cable_channel_set_CodeRate (DVBCableChannel* self, DVBDvbSrcCodeRate value);
void dvb_scanner_Run (DVBScanner* self, GError** error);
void dvb_scanner_Destroy (DVBScanner* self, GError** error);
gboolean dvb_scanner_WriteAllChannelsToFile (DVBScanner* self, const gchar* path, GError** error);
gboolean dvb_scanner_WriteChannelsToFile (DVBScanner* self, guint* channel_sids, int channel_sids_length1, const gchar* path, GError** error);
gboolean dvb_scanner_AddScanningDataFromFile (DVBScanner* self, const gchar* path, GError** error);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


DVBCableScanner* dvb_cable_scanner_construct (GType object_type, DVBDevice* device) {
	DVBCableScanner * self = NULL;
	DVBDevice* _tmp0_;
	g_return_val_if_fail (device != NULL, NULL);
	_tmp0_ = device;
	self = (DVBCableScanner*) g_object_new (object_type, "Device", _tmp0_, NULL);
	return self;
}


DVBCableScanner* dvb_cable_scanner_new (DVBDevice* device) {
	return dvb_cable_scanner_construct (DVB_TYPE_CABLE_SCANNER, device);
}


static gboolean dvb_cable_scanner_real_AddScanningData (DVBIDBusScanner* base, GHashTable* data, GError** error) {
	DVBCableScanner * self;
	gboolean result = FALSE;
	guint frequency = 0U;
	guint symbol_rate = 0U;
	gchar* modulation = NULL;
	gchar* code_rate = NULL;
	GVariant* _var = NULL;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_ = NULL;
	GVariant* _tmp2_;
	GVariant* _tmp3_;
	guint32 _tmp4_ = 0U;
	GHashTable* _tmp5_;
	gconstpointer _tmp6_ = NULL;
	GVariant* _tmp7_;
	GVariant* _tmp8_;
	guint32 _tmp9_ = 0U;
	GHashTable* _tmp10_;
	gconstpointer _tmp11_ = NULL;
	GVariant* _tmp12_;
	GVariant* _tmp13_;
	const gchar* _tmp14_ = NULL;
	gchar* _tmp15_;
	GHashTable* _tmp16_;
	gconstpointer _tmp17_ = NULL;
	GVariant* _tmp18_;
	GVariant* _tmp19_;
	const gchar* _tmp20_ = NULL;
	gchar* _tmp21_;
	guint _tmp22_;
	const gchar* _tmp23_;
	guint _tmp24_;
	const gchar* _tmp25_;
	self = (DVBCableScanner*) base;
	g_return_val_if_fail (data != NULL, FALSE);
	_tmp0_ = data;
	_tmp1_ = g_hash_table_lookup (_tmp0_, "frequency");
	_var = (GVariant*) _tmp1_;
	_tmp2_ = _var;
	if (_tmp2_ == NULL) {
		result = FALSE;
		_g_free0 (code_rate);
		_g_free0 (modulation);
		return result;
	}
	_tmp3_ = _var;
	_tmp4_ = g_variant_get_uint32 (_tmp3_);
	frequency = (guint) _tmp4_;
	_tmp5_ = data;
	_tmp6_ = g_hash_table_lookup (_tmp5_, "symbol-rate");
	_var = (GVariant*) _tmp6_;
	_tmp7_ = _var;
	if (_tmp7_ == NULL) {
		result = FALSE;
		_g_free0 (code_rate);
		_g_free0 (modulation);
		return result;
	}
	_tmp8_ = _var;
	_tmp9_ = g_variant_get_uint32 (_tmp8_);
	symbol_rate = (guint) _tmp9_;
	_tmp10_ = data;
	_tmp11_ = g_hash_table_lookup (_tmp10_, "inner-fec");
	_var = (GVariant*) _tmp11_;
	_tmp12_ = _var;
	if (_tmp12_ == NULL) {
		result = FALSE;
		_g_free0 (code_rate);
		_g_free0 (modulation);
		return result;
	}
	_tmp13_ = _var;
	_tmp14_ = g_variant_get_string (_tmp13_, NULL);
	_tmp15_ = g_strdup (_tmp14_);
	_g_free0 (code_rate);
	code_rate = _tmp15_;
	_tmp16_ = data;
	_tmp17_ = g_hash_table_lookup (_tmp16_, "modulation");
	_var = (GVariant*) _tmp17_;
	_tmp18_ = _var;
	if (_tmp18_ == NULL) {
		result = FALSE;
		_g_free0 (code_rate);
		_g_free0 (modulation);
		return result;
	}
	_tmp19_ = _var;
	_tmp20_ = g_variant_get_string (_tmp19_, NULL);
	_tmp21_ = g_strdup (_tmp20_);
	_g_free0 (modulation);
	modulation = _tmp21_;
	_tmp22_ = frequency;
	_tmp23_ = modulation;
	_tmp24_ = symbol_rate;
	_tmp25_ = code_rate;
	dvb_cable_scanner_add_scanning_data (self, _tmp22_, _tmp23_, _tmp24_, _tmp25_);
	result = TRUE;
	_g_free0 (code_rate);
	_g_free0 (modulation);
	return result;
}


static gpointer _gst_structure_copy0 (gpointer self) {
	return self ? gst_structure_copy (self) : NULL;
}


static inline void dvb_cable_scanner_add_scanning_data (DVBCableScanner* self, guint frequency, const gchar* modulation, guint symbol_rate, const gchar* code_rate) {
	guint _tmp0_;
	guint _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	GstStructure* _tmp4_;
	GstStructure* tuning_params;
	GstStructure* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (modulation != NULL);
	g_return_if_fail (code_rate != NULL);
	_tmp0_ = frequency;
	_tmp1_ = symbol_rate;
	_tmp2_ = code_rate;
	_tmp3_ = modulation;
	_tmp4_ = gst_structure_new ("tuning_params", "frequency", G_TYPE_UINT, _tmp0_, "symbol-rate", G_TYPE_UINT, _tmp1_, "inner-fec", G_TYPE_STRING, _tmp2_, "modulation", G_TYPE_STRING, _tmp3_, NULL);
	tuning_params = _tmp4_;
	_tmp5_ = _gst_structure_copy0 (tuning_params);
	dvb_scanner_add_structure_to_scan (DVB_SCANNER (self), _tmp5_);
	_gst_structure_free0 (tuning_params);
}


static void dvb_cable_scanner_real_add_scanning_data_from_string (DVBScanner* base, const gchar* line) {
	DVBCableScanner * self;
	const gchar* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_ = NULL;
	gchar** cols;
	gint cols_length1;
	gint _cols_size_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gchar** _tmp4_;
	gint _tmp4__length1;
	const gchar* _tmp5_;
	gint _tmp6_ = 0;
	guint freq;
	gchar** _tmp7_;
	gint _tmp7__length1;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* modulation;
	gchar** _tmp10_;
	gint _tmp10__length1;
	const gchar* _tmp11_;
	gint _tmp12_ = 0;
	guint symbol_rate;
	gchar** _tmp13_;
	gint _tmp13__length1;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* code_rate;
	guint _tmp16_;
	const gchar* _tmp17_;
	guint _tmp18_;
	const gchar* _tmp19_;
	self = (DVBCableScanner*) base;
	g_return_if_fail (line != NULL);
	_tmp0_ = line;
	_tmp2_ = _tmp1_ = g_regex_split_simple ("\\s+", _tmp0_, 0, 0);
	cols = _tmp2_;
	cols_length1 = _vala_array_length (_tmp1_);
	_cols_size_ = cols_length1;
	_tmp3_ = cols;
	_tmp3__length1 = cols_length1;
	if (_tmp3__length1 < 5) {
		cols = (_vala_array_free (cols, cols_length1, (GDestroyNotify) g_free), NULL);
		return;
	}
	_tmp4_ = cols;
	_tmp4__length1 = cols_length1;
	_tmp5_ = _tmp4_[1];
	_tmp6_ = atoi (_tmp5_);
	freq = (guint) _tmp6_;
	_tmp7_ = cols;
	_tmp7__length1 = cols_length1;
	_tmp8_ = _tmp7_[4];
	_tmp9_ = g_strdup (_tmp8_);
	modulation = _tmp9_;
	_tmp10_ = cols;
	_tmp10__length1 = cols_length1;
	_tmp11_ = _tmp10_[2];
	_tmp12_ = atoi (_tmp11_);
	symbol_rate = (guint) (_tmp12_ / 1000);
	_tmp13_ = cols;
	_tmp13__length1 = cols_length1;
	_tmp14_ = _tmp13_[3];
	_tmp15_ = g_strdup (_tmp14_);
	code_rate = _tmp15_;
	_tmp16_ = freq;
	_tmp17_ = modulation;
	_tmp18_ = symbol_rate;
	_tmp19_ = code_rate;
	dvb_cable_scanner_add_scanning_data (self, _tmp16_, _tmp17_, _tmp18_, _tmp19_);
	_g_free0 (code_rate);
	_g_free0 (modulation);
	cols = (_vala_array_free (cols, cols_length1, (GDestroyNotify) g_free), NULL);
}


static void dvb_cable_scanner_real_prepare (DVBScanner* base) {
	DVBCableScanner * self;
	GstElement* _tmp0_;
	GstElement* _tmp1_ = NULL;
	GstElement* dvbsrc;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar** _tmp4_ = NULL;
	gchar** keys;
	gint keys_length1;
	gint _keys_size_;
	gchar** _tmp5_;
	gint _tmp5__length1;
	GstElement* _tmp10_;
	const GstStructure* _tmp11_;
	const gchar* _tmp12_ = NULL;
	DVBDvbSrcModulation _tmp13_ = 0;
	GstElement* _tmp14_;
	const GstStructure* _tmp15_;
	const gchar* _tmp16_ = NULL;
	DVBDvbSrcCodeRate _tmp17_ = 0;
	self = (DVBCableScanner*) base;
	g_debug ("CableScanner.vala:87: Setting up pipeline for DVB-C scan");
	_tmp0_ = ((DVBScanner*) self)->pipeline;
	_tmp1_ = gst_bin_get_by_name (GST_BIN (_tmp0_), "dvbsrc");
	dvbsrc = _tmp1_;
	_tmp2_ = g_strdup ("frequency");
	_tmp3_ = g_strdup ("symbol-rate");
	_tmp4_ = g_new0 (gchar*, 2 + 1);
	_tmp4_[0] = _tmp2_;
	_tmp4_[1] = _tmp3_;
	keys = _tmp4_;
	keys_length1 = 2;
	_keys_size_ = keys_length1;
	_tmp5_ = keys;
	_tmp5__length1 = keys_length1;
	{
		gchar** key_collection = NULL;
		gint key_collection_length1 = 0;
		gint _key_collection_size_ = 0;
		gint key_it = 0;
		key_collection = _tmp5_;
		key_collection_length1 = _tmp5__length1;
		for (key_it = 0; key_it < _tmp5__length1; key_it = key_it + 1) {
			gchar* _tmp6_;
			gchar* key = NULL;
			_tmp6_ = g_strdup (key_collection[key_it]);
			key = _tmp6_;
			{
				GstElement* _tmp7_;
				const GstStructure* _tmp8_;
				const gchar* _tmp9_;
				_tmp7_ = dvbsrc;
				_tmp8_ = ((DVBScanner*) self)->current_tuning_params;
				_tmp9_ = key;
				dvb_scanner_set_uint_property (_tmp7_, _tmp8_, _tmp9_);
				_g_free0 (key);
			}
		}
	}
	_tmp10_ = dvbsrc;
	_tmp11_ = ((DVBScanner*) self)->current_tuning_params;
	_tmp12_ = gst_structure_get_string (_tmp11_, "modulation");
	_tmp13_ = dvb_get_modulation_val (_tmp12_);
	g_object_set ((GObject*) _tmp10_, "modulation", _tmp13_, NULL);
	_tmp14_ = dvbsrc;
	_tmp15_ = ((DVBScanner*) self)->current_tuning_params;
	_tmp16_ = gst_structure_get_string (_tmp15_, "inner-fec");
	_tmp17_ = dvb_get_code_rate_val (_tmp16_);
	g_object_set ((GObject*) _tmp14_, "code-rate-hp", _tmp17_, NULL);
	keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
	_gst_object_unref0 (dvbsrc);
}


static DVBScannedItem* dvb_cable_scanner_real_get_scanned_item (DVBScanner* base, const GstStructure* structure) {
	DVBCableScanner * self;
	DVBScannedItem* result = NULL;
	guint freq = 0U;
	const GstStructure* _tmp0_;
	guint _tmp1_ = 0U;
	DVBScannedItem* _tmp2_;
	self = (DVBCableScanner*) base;
	g_return_val_if_fail (structure != NULL, NULL);
	_tmp0_ = structure;
	gst_structure_get_uint (_tmp0_, "frequency", &_tmp1_);
	freq = _tmp1_;
	_tmp2_ = dvb_scanned_item_new (freq);
	result = _tmp2_;
	return result;
}


static DVBChannel* dvb_cable_scanner_real_get_new_channel (DVBScanner* base) {
	DVBCableScanner * self;
	DVBChannel* result = NULL;
	DVBCableChannel* _tmp0_;
	self = (DVBCableScanner*) base;
	_tmp0_ = dvb_cable_channel_new_without_schedule ();
	result = (DVBChannel*) _tmp0_;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void dvb_cable_scanner_real_add_values_from_structure_to_channel (DVBScanner* base, const GstStructure* delivery, DVBChannel* channel) {
	DVBCableScanner * self;
	DVBChannel* _tmp0_;
	DVBChannel* _tmp1_;
	DVBCableChannel* _tmp2_;
	DVBCableChannel* cc;
	DVBCableChannel* _tmp3_;
	DVBCableChannel* _tmp4_;
	const GstStructure* _tmp5_;
	const gchar* _tmp6_ = NULL;
	DVBDvbSrcModulation _tmp7_ = 0;
	guint freq = 0U;
	const GstStructure* _tmp8_;
	guint _tmp9_ = 0U;
	DVBCableChannel* _tmp10_;
	guint _tmp11_;
	guint symbol_rate = 0U;
	const GstStructure* _tmp12_;
	guint _tmp13_ = 0U;
	DVBCableChannel* _tmp14_;
	guint _tmp15_;
	DVBCableChannel* _tmp16_;
	const GstStructure* _tmp17_;
	const gchar* _tmp18_ = NULL;
	DVBDvbSrcCodeRate _tmp19_ = 0;
	self = (DVBCableScanner*) base;
	g_return_if_fail (delivery != NULL);
	g_return_if_fail (channel != NULL);
	_tmp0_ = channel;
	if (!DVB_IS_CABLE_CHANNEL (_tmp0_)) {
		return;
	}
	_tmp1_ = channel;
	_tmp2_ = _g_object_ref0 (DVB_CABLE_CHANNEL (_tmp1_));
	cc = _tmp2_;
	_tmp3_ = cc;
	dvb_cable_channel_set_Inversion (_tmp3_, DVB_DVB_SRC_INVERSION_INVERSION_AUTO);
	_tmp4_ = cc;
	_tmp5_ = delivery;
	_tmp6_ = gst_structure_get_string (_tmp5_, "modulation");
	_tmp7_ = dvb_get_modulation_val (_tmp6_);
	dvb_cable_channel_set_Modulation (_tmp4_, _tmp7_);
	_tmp8_ = delivery;
	gst_structure_get_uint (_tmp8_, "frequency", &_tmp9_);
	freq = _tmp9_;
	_tmp10_ = cc;
	_tmp11_ = freq;
	dvb_channel_set_Frequency ((DVBChannel*) _tmp10_, _tmp11_);
	_tmp12_ = delivery;
	gst_structure_get_uint (_tmp12_, "symbol-rate", &_tmp13_);
	symbol_rate = _tmp13_;
	_tmp14_ = cc;
	_tmp15_ = symbol_rate;
	dvb_cable_channel_set_SymbolRate (_tmp14_, _tmp15_);
	_tmp16_ = cc;
	_tmp17_ = delivery;
	_tmp18_ = gst_structure_get_string (_tmp17_, "inner-fec");
	_tmp19_ = dvb_get_code_rate_val (_tmp18_);
	dvb_cable_channel_set_CodeRate (_tmp16_, _tmp19_);
	_g_object_unref0 (cc);
}


static void dvb_cable_scanner_class_init (DVBCableScannerClass * klass) {
	dvb_cable_scanner_parent_class = g_type_class_peek_parent (klass);
	DVB_SCANNER_CLASS (klass)->add_scanning_data_from_string = dvb_cable_scanner_real_add_scanning_data_from_string;
	DVB_SCANNER_CLASS (klass)->prepare = dvb_cable_scanner_real_prepare;
	DVB_SCANNER_CLASS (klass)->get_scanned_item = dvb_cable_scanner_real_get_scanned_item;
	DVB_SCANNER_CLASS (klass)->get_new_channel = dvb_cable_scanner_real_get_new_channel;
	DVB_SCANNER_CLASS (klass)->add_values_from_structure_to_channel = dvb_cable_scanner_real_add_values_from_structure_to_channel;
}


static void dvb_cable_scanner_dvb_id_bus_scanner_interface_init (DVBIDBusScannerIface * iface) {
	dvb_cable_scanner_dvb_id_bus_scanner_parent_iface = g_type_interface_peek_parent (iface);
	iface->AddScanningData = (gboolean (*)(DVBIDBusScanner*, GHashTable*, GError**)) dvb_cable_scanner_real_AddScanningData;
	iface->Run = (void (*)(DVBIDBusScanner*, GError**)) dvb_scanner_Run;
	iface->Destroy = (void (*)(DVBIDBusScanner*, GError**)) dvb_scanner_Destroy;
	iface->WriteAllChannelsToFile = (gboolean (*)(DVBIDBusScanner*, const gchar*, GError**)) dvb_scanner_WriteAllChannelsToFile;
	iface->WriteChannelsToFile = (gboolean (*)(DVBIDBusScanner*, guint*, int, const gchar*, GError**)) dvb_scanner_WriteChannelsToFile;
	iface->AddScanningDataFromFile = (gboolean (*)(DVBIDBusScanner*, const gchar*, GError**)) dvb_scanner_AddScanningDataFromFile;
}


static void dvb_cable_scanner_instance_init (DVBCableScanner * self) {
}


GType dvb_cable_scanner_get_type (void) {
	static volatile gsize dvb_cable_scanner_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_cable_scanner_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBCableScannerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_cable_scanner_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBCableScanner), 0, (GInstanceInitFunc) dvb_cable_scanner_instance_init, NULL };
		static const GInterfaceInfo dvb_id_bus_scanner_info = { (GInterfaceInitFunc) dvb_cable_scanner_dvb_id_bus_scanner_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType dvb_cable_scanner_type_id;
		dvb_cable_scanner_type_id = g_type_register_static (DVB_TYPE_SCANNER, "DVBCableScanner", &g_define_type_info, 0);
		g_type_add_interface_static (dvb_cable_scanner_type_id, DVB_TYPE_ID_BUS_SCANNER, &dvb_id_bus_scanner_info);
		g_once_init_leave (&dvb_cable_scanner_type_id__volatile, dvb_cable_scanner_type_id);
	}
	return dvb_cable_scanner_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



