/* Settings.c generated by valac 0.14.0, the Vala compiler
 * generated from Settings.vala, do not modify */

/*
 * Copyright (C) 2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gio/gio.h>
#include <float.h>
#include <math.h>


#define DVB_TYPE_SETTINGS (dvb_settings_get_type ())
#define DVB_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_SETTINGS, DVBSettings))
#define DVB_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_SETTINGS, DVBSettingsClass))
#define DVB_IS_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_SETTINGS))
#define DVB_IS_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_SETTINGS))
#define DVB_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_SETTINGS, DVBSettingsClass))

typedef struct _DVBSettings DVBSettings;
typedef struct _DVBSettingsClass DVBSettingsClass;
typedef struct _DVBSettingsPrivate DVBSettingsPrivate;

#define DVB_LOGGING_TYPE_LOGGER (dvb_logging_logger_get_type ())
#define DVB_LOGGING_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLogger))
#define DVB_LOGGING_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLoggerClass))
#define DVB_LOGGING_IS_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_LOGGING_TYPE_LOGGER))
#define DVB_LOGGING_IS_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_LOGGING_TYPE_LOGGER))
#define DVB_LOGGING_LOGGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLoggerClass))

typedef struct _DVBLoggingLogger DVBLoggingLogger;
typedef struct _DVBLoggingLoggerClass DVBLoggingLoggerClass;

#define DVB_LOGGING_TYPE_LOG_MANAGER (dvb_logging_log_manager_get_type ())
#define DVB_LOGGING_LOG_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManager))
#define DVB_LOGGING_LOG_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManagerClass))
#define DVB_LOGGING_IS_LOG_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_LOGGING_TYPE_LOG_MANAGER))
#define DVB_LOGGING_IS_LOG_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_LOGGING_TYPE_LOG_MANAGER))
#define DVB_LOGGING_LOG_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManagerClass))

typedef struct _DVBLoggingLogManager DVBLoggingLogManager;
typedef struct _DVBLoggingLogManagerClass DVBLoggingLogManagerClass;
#define _g_key_file_free0(var) ((var == NULL) ? NULL : (var = (g_key_file_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define DVB_TYPE_DEVICE (dvb_device_get_type ())
#define DVB_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_DEVICE, DVBDevice))
#define DVB_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_DEVICE, DVBDeviceClass))
#define DVB_IS_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_DEVICE))
#define DVB_IS_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_DEVICE))
#define DVB_DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_DEVICE, DVBDeviceClass))

typedef struct _DVBDevice DVBDevice;
typedef struct _DVBDeviceClass DVBDeviceClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define DVB_TYPE_ADAPTER_TYPE (dvb_adapter_type_get_type ())

struct _DVBSettings {
	GObject parent_instance;
	DVBSettingsPrivate * priv;
};

struct _DVBSettingsClass {
	GObjectClass parent_class;
};

struct _DVBSettingsPrivate {
	GKeyFile* keyfile;
};

typedef enum  {
	DVB_ADAPTER_TYPE_UNKNOWN,
	DVB_ADAPTER_TYPE_DVB_T,
	DVB_ADAPTER_TYPE_DVB_S,
	DVB_ADAPTER_TYPE_DVB_C
} DVBAdapterType;


static gpointer dvb_settings_parent_class = NULL;
static DVBLoggingLogger* dvb_settings_log;
static DVBLoggingLogger* dvb_settings_log = NULL;

GType dvb_settings_get_type (void) G_GNUC_CONST;
#define DVB_SETTINGS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_TYPE_SETTINGS, DVBSettingsPrivate))
enum  {
	DVB_SETTINGS_DUMMY_PROPERTY
};
GType dvb_logging_logger_get_type (void) G_GNUC_CONST;
GType dvb_logging_log_manager_get_type (void) G_GNUC_CONST;
DVBLoggingLogManager* dvb_logging_log_manager_getLogManager (void);
DVBLoggingLogger* dvb_logging_log_manager_getDefaultLogger (DVBLoggingLogManager* self);
#define DVB_SETTINGS_TIMERS_SECTION "timers"
#define DVB_SETTINGS_MARGIN_START "margin_start"
#define DVB_SETTINGS_MARGIN_END "margin_end"
#define DVB_SETTINGS_EPG_SECTION "epg"
#define DVB_SETTINGS_SCAN_INTERVAL "scan_interval"
#define DVB_SETTINGS_STREAMING_SECTION "streaming"
#define DVB_SETTINGS_INTERFACE "interface"
#define DVB_SETTINGS_DEVICE_SECTION_PREFIX "device."
#define DVB_SETTINGS_DEVICE_NAME "name"
#define DVB_SETTINGS_DEVICE_TYPE "type"
#define DVB_SETTINGS_DEVICE_ADAPTER "adapter"
#define DVB_SETTINGS_DEVICE_FRONTEND "frontend"
#define DVB_SETTINGS_DEVICE_CHANNELS_FILE "channels_file"
#define DVB_SETTINGS_DEVICE_RECORDINGS_DIR "recordings_dir"
#define DVB_SETTINGS_DEFAULT_MARGIN_START 5
#define DVB_SETTINGS_DEFAULT_MARGIN_END 5
#define DVB_SETTINGS_DEFAULT_SCAN_INTERVAL 30
#define DVB_SETTINGS_DEFAULT_INTERFACE "lo"
#define DVB_SETTINGS_DEFAULT_SETTINGS "[timers]\n" \
"        margin_start=5\n" \
"        margin_end=5\n" \
"        [epg]\n" \
"        scan_interval=30\n" \
"        [streaming]\n" \
"        interface=lo"
gint dvb_settings_get_epg_scan_interval (DVBSettings* self);
gint dvb_settings_get_integer (DVBSettings* self, const gchar* group_name, const gchar* key, GError** error);
void dvb_logging_logger_warning (DVBLoggingLogger* self, const gchar* format, ...);
gint dvb_settings_get_timers_margin_start (DVBSettings* self);
gint dvb_settings_get_timers_margin_end (DVBSettings* self);
gchar* dvb_settings_get_streaming_interface (DVBSettings* self);
gchar* dvb_settings_get_string (DVBSettings* self, const gchar* group_name, const gchar* key, GError** error);
GType dvb_device_get_type (void) G_GNUC_CONST;
GeeList* dvb_settings_get_fake_devices (DVBSettings* self);
static DVBDevice* dvb_settings_get_device (DVBSettings* self, const gchar* group, GError** error);
GType dvb_adapter_type_get_type (void) G_GNUC_CONST;
DVBAdapterType dvb_device_get_type_from_string (const gchar* adapter_type);
DVBDevice* dvb_device_new_set_type (guint adapter, guint frontend, GFile* channels_conf, GFile* recordings_dir, const gchar* name, DVBAdapterType type);
GFile* dvb_settings_get_settings_file (DVBSettings* self);
gboolean dvb_settings_load (DVBSettings* self);
void dvb_logging_logger_error (DVBLoggingLogger* self, const gchar* format, ...);
gboolean dvb_settings_save (DVBSettings* self);
gboolean dvb_settings_get_boolean (DVBSettings* self, const gchar* group_name, const gchar* key, GError** error);
gdouble dvb_settings_get_double (DVBSettings* self, const gchar* group_name, const gchar* key, GError** error);
gchar** dvb_settings_get_string_list (DVBSettings* self, const gchar* group_name, const gchar* key, int* result_length1, GError** error);
gboolean* dvb_settings_get_boolean_list (DVBSettings* self, const gchar* group_name, const gchar* key, int* result_length1, GError** error);
gint* dvb_settings_get_integer_list (DVBSettings* self, const gchar* group_name, const gchar* key, int* result_length1, GError** error);
gdouble* dvb_settings_get_double_list (DVBSettings* self, const gchar* group_name, const gchar* key, int* result_length1, GError** error);
void dvb_settings_set_string (DVBSettings* self, const gchar* group_name, const gchar* key, const gchar* val, GError** error);
void dvb_settings_set_boolean (DVBSettings* self, const gchar* group_name, const gchar* key, gboolean val, GError** error);
void dvb_settings_set_double (DVBSettings* self, const gchar* group_name, const gchar* key, gdouble val, GError** error);
void dvb_settings_set_integer (DVBSettings* self, const gchar* group_name, const gchar* key, gint val, GError** error);
void dvb_settings_set_string_list (DVBSettings* self, const gchar* group_name, const gchar* key, gchar** val, int val_length1, GError** error);
void dvb_settings_set_boolean_list (DVBSettings* self, const gchar* group_name, const gchar* key, gboolean* val, int val_length1, GError** error);
void dvb_settings_set_double_list (DVBSettings* self, const gchar* group_name, const gchar* key, gdouble* val, int val_length1, GError** error);
void dvb_settings_set_integer_list (DVBSettings* self, const gchar* group_name, const gchar* key, gint* val, int val_length1, GError** error);
DVBSettings* dvb_settings_new (void);
DVBSettings* dvb_settings_construct (GType object_type);
static GObject * dvb_settings_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void dvb_settings_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


gint dvb_settings_get_epg_scan_interval (DVBSettings* self) {
	gint result = 0;
	gint val = 0;
	gint _tmp5_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	{
		gint _tmp0_ = 0;
		gint _tmp1_;
		_tmp0_ = dvb_settings_get_integer (self, DVB_SETTINGS_EPG_SECTION, DVB_SETTINGS_SCAN_INTERVAL, &_inner_error_);
		_tmp1_ = _tmp0_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch186_g_key_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
		val = _tmp1_;
	}
	goto __finally186;
	__catch186_g_key_file_error:
	{
		GError* e = NULL;
		DVBLoggingLogger* _tmp2_;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = dvb_settings_log;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		dvb_logging_logger_warning (_tmp2_, "Settings.vala:72: %s", _tmp4_);
		val = DVB_SETTINGS_DEFAULT_SCAN_INTERVAL;
		_g_error_free0 (e);
	}
	__finally186:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	_tmp5_ = val;
	result = _tmp5_ * 60;
	return result;
}


gint dvb_settings_get_timers_margin_start (DVBSettings* self) {
	gint result = 0;
	gint start_margin = 0;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	{
		gint _tmp0_ = 0;
		gint _tmp1_;
		_tmp0_ = dvb_settings_get_integer (self, DVB_SETTINGS_TIMERS_SECTION, DVB_SETTINGS_MARGIN_START, &_inner_error_);
		_tmp1_ = _tmp0_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch187_g_key_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
		start_margin = _tmp1_;
	}
	goto __finally187;
	__catch187_g_key_file_error:
	{
		GError* e = NULL;
		DVBLoggingLogger* _tmp2_;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = dvb_settings_log;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		dvb_logging_logger_warning (_tmp2_, "Settings.vala:83: %s", _tmp4_);
		start_margin = DVB_SETTINGS_DEFAULT_MARGIN_START;
		_g_error_free0 (e);
	}
	__finally187:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	result = start_margin;
	return result;
}


gint dvb_settings_get_timers_margin_end (DVBSettings* self) {
	gint result = 0;
	gint end_margin = 0;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	{
		gint _tmp0_ = 0;
		gint _tmp1_;
		_tmp0_ = dvb_settings_get_integer (self, DVB_SETTINGS_TIMERS_SECTION, DVB_SETTINGS_MARGIN_END, &_inner_error_);
		_tmp1_ = _tmp0_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch188_g_key_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
		end_margin = _tmp1_;
	}
	goto __finally188;
	__catch188_g_key_file_error:
	{
		GError* e = NULL;
		DVBLoggingLogger* _tmp2_;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = dvb_settings_log;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		dvb_logging_logger_warning (_tmp2_, "Settings.vala:94: %s", _tmp4_);
		end_margin = DVB_SETTINGS_DEFAULT_MARGIN_END;
		_g_error_free0 (e);
	}
	__finally188:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	result = end_margin;
	return result;
}


gchar* dvb_settings_get_streaming_interface (DVBSettings* self) {
	gchar* result = NULL;
	gchar* val = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	{
		gchar* _tmp0_ = NULL;
		gchar* _tmp1_;
		_tmp0_ = dvb_settings_get_string (self, DVB_SETTINGS_STREAMING_SECTION, DVB_SETTINGS_INTERFACE, &_inner_error_);
		_tmp1_ = _tmp0_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch189_g_key_file_error;
			}
			_g_free0 (val);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_g_free0 (val);
		val = _tmp1_;
	}
	goto __finally189;
	__catch189_g_key_file_error:
	{
		GError* e = NULL;
		DVBLoggingLogger* _tmp2_;
		GError* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = dvb_settings_log;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		dvb_logging_logger_warning (_tmp2_, "Settings.vala:105: %s", _tmp4_);
		_tmp5_ = g_strdup (DVB_SETTINGS_DEFAULT_INTERFACE);
		_g_free0 (val);
		val = _tmp5_;
		_g_error_free0 (e);
	}
	__finally189:
	if (_inner_error_ != NULL) {
		_g_free0 (val);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = val;
	return result;
}


GeeList* dvb_settings_get_fake_devices (DVBSettings* self) {
	GeeList* result = NULL;
	GeeArrayList* _tmp0_;
	GeeList* devices;
	GKeyFile* _tmp1_;
	gsize _tmp2_;
	gchar** _tmp3_ = NULL;
	gchar** groups;
	gint groups_length1;
	gint _groups_size_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gee_array_list_new (DVB_TYPE_DEVICE, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL);
	devices = (GeeList*) _tmp0_;
	_tmp1_ = self->priv->keyfile;
	_tmp3_ = g_key_file_get_groups (_tmp1_, &_tmp2_);
	groups = _tmp3_;
	groups_length1 = _tmp2_;
	_groups_size_ = groups_length1;
	_tmp4_ = groups;
	_tmp4__length1 = groups_length1;
	{
		gchar** group_collection = NULL;
		gint group_collection_length1 = 0;
		gint _group_collection_size_ = 0;
		gint group_it = 0;
		group_collection = _tmp4_;
		group_collection_length1 = _tmp4__length1;
		for (group_it = 0; group_it < _tmp4__length1; group_it = group_it + 1) {
			gchar* _tmp5_;
			gchar* group = NULL;
			_tmp5_ = g_strdup (group_collection[group_it]);
			group = _tmp5_;
			{
				const gchar* _tmp6_;
				gboolean _tmp7_ = FALSE;
				_tmp6_ = group;
				_tmp7_ = g_str_has_prefix (_tmp6_, DVB_SETTINGS_DEVICE_SECTION_PREFIX);
				if (_tmp7_) {
					{
						const gchar* _tmp8_;
						DVBDevice* _tmp9_ = NULL;
						DVBDevice* dev;
						GeeList* _tmp10_;
						DVBDevice* _tmp11_;
						_tmp8_ = group;
						_tmp9_ = dvb_settings_get_device (self, _tmp8_, &_inner_error_);
						dev = _tmp9_;
						if (_inner_error_ != NULL) {
							if (_inner_error_->domain == G_KEY_FILE_ERROR) {
								goto __catch190_g_key_file_error;
							}
							_g_free0 (group);
							groups = (_vala_array_free (groups, groups_length1, (GDestroyNotify) g_free), NULL);
							_g_object_unref0 (devices);
							g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
						_tmp10_ = devices;
						_tmp11_ = dev;
						gee_collection_add ((GeeCollection*) _tmp10_, _tmp11_);
						_g_object_unref0 (dev);
					}
					goto __finally190;
					__catch190_g_key_file_error:
					{
						GError* e = NULL;
						DVBLoggingLogger* _tmp12_;
						GError* _tmp13_;
						const gchar* _tmp14_;
						e = _inner_error_;
						_inner_error_ = NULL;
						_tmp12_ = dvb_settings_log;
						_tmp13_ = e;
						_tmp14_ = _tmp13_->message;
						dvb_logging_logger_warning (_tmp12_, "Settings.vala:120: %s", _tmp14_);
						_g_error_free0 (e);
					}
					__finally190:
					if (_inner_error_ != NULL) {
						_g_free0 (group);
						groups = (_vala_array_free (groups, groups_length1, (GDestroyNotify) g_free), NULL);
						_g_object_unref0 (devices);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				_g_free0 (group);
			}
		}
	}
	result = devices;
	groups = (_vala_array_free (groups, groups_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static DVBDevice* dvb_settings_get_device (DVBSettings* self, const gchar* group, GError** error) {
	DVBDevice* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* name;
	const gchar* _tmp2_;
	gint _tmp3_ = 0;
	gint adapter;
	const gchar* _tmp4_;
	gint _tmp5_ = 0;
	gint frontend;
	const gchar* _tmp6_;
	gchar* _tmp7_ = NULL;
	gchar* typestr;
	const gchar* _tmp8_;
	DVBAdapterType _tmp9_ = 0;
	DVBAdapterType type;
	const gchar* _tmp10_;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_;
	gchar* _tmp13_;
	GFile* _tmp14_ = NULL;
	GFile* _tmp15_;
	GFile* channels;
	const gchar* _tmp16_;
	gchar* _tmp17_ = NULL;
	gchar* _tmp18_;
	gchar* _tmp19_;
	GFile* _tmp20_ = NULL;
	GFile* _tmp21_;
	GFile* rec_dir;
	gint _tmp22_;
	gint _tmp23_;
	GFile* _tmp24_;
	GFile* _tmp25_;
	const gchar* _tmp26_;
	DVBAdapterType _tmp27_;
	DVBDevice* _tmp28_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (group != NULL, NULL);
	_tmp0_ = group;
	_tmp1_ = dvb_settings_get_string (self, _tmp0_, DVB_SETTINGS_DEVICE_NAME, &_inner_error_);
	name = _tmp1_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_KEY_FILE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp2_ = group;
	_tmp3_ = dvb_settings_get_integer (self, _tmp2_, DVB_SETTINGS_DEVICE_ADAPTER, &_inner_error_);
	adapter = _tmp3_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_KEY_FILE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (name);
			return NULL;
		} else {
			_g_free0 (name);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp4_ = group;
	_tmp5_ = dvb_settings_get_integer (self, _tmp4_, DVB_SETTINGS_DEVICE_FRONTEND, &_inner_error_);
	frontend = _tmp5_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_KEY_FILE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (name);
			return NULL;
		} else {
			_g_free0 (name);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp6_ = group;
	_tmp7_ = dvb_settings_get_string (self, _tmp6_, DVB_SETTINGS_DEVICE_TYPE, &_inner_error_);
	typestr = _tmp7_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_KEY_FILE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (name);
			return NULL;
		} else {
			_g_free0 (name);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp8_ = typestr;
	_tmp9_ = dvb_device_get_type_from_string (_tmp8_);
	type = _tmp9_;
	_tmp10_ = group;
	_tmp11_ = dvb_settings_get_string (self, _tmp10_, DVB_SETTINGS_DEVICE_CHANNELS_FILE, &_inner_error_);
	_tmp12_ = _tmp11_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_KEY_FILE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (typestr);
			_g_free0 (name);
			return NULL;
		} else {
			_g_free0 (typestr);
			_g_free0 (name);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp13_ = _tmp12_;
	_tmp14_ = g_file_new_for_path (_tmp13_);
	_tmp15_ = _tmp14_;
	_g_free0 (_tmp13_);
	channels = _tmp15_;
	_tmp16_ = group;
	_tmp17_ = dvb_settings_get_string (self, _tmp16_, DVB_SETTINGS_DEVICE_RECORDINGS_DIR, &_inner_error_);
	_tmp18_ = _tmp17_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_KEY_FILE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (channels);
			_g_free0 (typestr);
			_g_free0 (name);
			return NULL;
		} else {
			_g_object_unref0 (channels);
			_g_free0 (typestr);
			_g_free0 (name);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp19_ = _tmp18_;
	_tmp20_ = g_file_new_for_path (_tmp19_);
	_tmp21_ = _tmp20_;
	_g_free0 (_tmp19_);
	rec_dir = _tmp21_;
	_tmp22_ = adapter;
	_tmp23_ = frontend;
	_tmp24_ = channels;
	_tmp25_ = rec_dir;
	_tmp26_ = name;
	_tmp27_ = type;
	_tmp28_ = dvb_device_new_set_type ((guint) _tmp22_, (guint) _tmp23_, _tmp24_, _tmp25_, _tmp26_, _tmp27_);
	result = _tmp28_;
	_g_object_unref0 (rec_dir);
	_g_object_unref0 (channels);
	_g_free0 (typestr);
	_g_free0 (name);
	return result;
}


GFile* dvb_settings_get_settings_file (DVBSettings* self) {
	GFile* result = NULL;
	const gchar* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GFile* config_dir;
	GFile* _tmp2_ = NULL;
	GFile* our_config;
	GFile* _tmp3_ = NULL;
	GFile* settings_file;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_get_user_config_dir ();
	_tmp1_ = g_file_new_for_path (_tmp0_);
	config_dir = _tmp1_;
	_tmp2_ = g_file_get_child (config_dir, "gnome-dvb-daemon");
	our_config = _tmp2_;
	_tmp3_ = g_file_get_child (our_config, "settings.ini");
	settings_file = _tmp3_;
	result = settings_file;
	_g_object_unref0 (our_config);
	_g_object_unref0 (config_dir);
	return result;
}


static guint8* string_get_data (const gchar* self, int* result_length1) {
	guint8* result;
	guint8* res;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	guint8* _tmp3_;
	gint _tmp3__length1;
	guint8* _tmp4_;
	gint _tmp4__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res_length1;
	_tmp3_ = res;
	_tmp3__length1 = res_length1;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp3__length1;
	if (result_length1) {
		*result_length1 = _tmp4__length1;
	}
	result = _tmp4_;
	return result;
}


gboolean dvb_settings_load (DVBSettings* self) {
	gboolean result = FALSE;
	GFile* _tmp0_ = NULL;
	GFile* settings_file;
	gboolean success;
	GFile* _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp25_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = dvb_settings_get_settings_file (self);
	settings_file = _tmp0_;
	success = TRUE;
	_tmp1_ = settings_file;
	_tmp2_ = g_file_query_exists (_tmp1_, NULL);
	if (!_tmp2_) {
		GFileOutputStream* stream;
		stream = NULL;
		{
			GFile* _tmp3_;
			GFileOutputStream* _tmp4_ = NULL;
			GFileOutputStream* _tmp5_;
			_tmp3_ = settings_file;
			_tmp4_ = g_file_create (_tmp3_, 0, NULL, &_inner_error_);
			_tmp5_ = _tmp4_;
			if (_inner_error_ != NULL) {
				goto __catch191_g_error;
			}
			_g_object_unref0 (stream);
			stream = _tmp5_;
		}
		goto __finally191;
		__catch191_g_error:
		{
			GError* e = NULL;
			DVBLoggingLogger* _tmp6_;
			GFile* _tmp7_;
			gchar* _tmp8_ = NULL;
			gchar* _tmp9_;
			GError* _tmp10_;
			const gchar* _tmp11_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp6_ = dvb_settings_log;
			_tmp7_ = settings_file;
			_tmp8_ = g_file_get_path (_tmp7_);
			_tmp9_ = _tmp8_;
			_tmp10_ = e;
			_tmp11_ = _tmp10_->message;
			dvb_logging_logger_error (_tmp6_, "Settings.vala:159: Could not create file %s: %s", _tmp9_, _tmp11_);
			_g_free0 (_tmp9_);
			result = FALSE;
			_g_error_free0 (e);
			_g_object_unref0 (stream);
			_g_object_unref0 (settings_file);
			return result;
		}
		__finally191:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (stream);
			_g_object_unref0 (settings_file);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		{
			GFileOutputStream* _tmp12_;
			guint8* _tmp13_;
			gint _tmp13__length1;
			guint8* _tmp14_;
			gint _tmp14__length1;
			_tmp12_ = stream;
			_tmp13_ = string_get_data (DVB_SETTINGS_DEFAULT_SETTINGS, &_tmp13__length1);
			_tmp14_ = _tmp13_;
			_tmp14__length1 = _tmp13__length1;
			g_output_stream_write ((GOutputStream*) _tmp12_, _tmp14_, (gsize) _tmp14__length1, NULL, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch192_g_error;
			}
		}
		goto __finally192;
		__catch192_g_error:
		{
			GError* e = NULL;
			DVBLoggingLogger* _tmp15_;
			GFile* _tmp16_;
			gchar* _tmp17_ = NULL;
			gchar* _tmp18_;
			GError* _tmp19_;
			const gchar* _tmp20_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp15_ = dvb_settings_log;
			_tmp16_ = settings_file;
			_tmp17_ = g_file_get_path (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = e;
			_tmp20_ = _tmp19_->message;
			dvb_logging_logger_error (_tmp15_, "Settings.vala:167: Could not write to file %s: %s", _tmp18_, _tmp20_);
			_g_free0 (_tmp18_);
			success = FALSE;
			_g_error_free0 (e);
		}
		__finally192:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (stream);
			_g_object_unref0 (settings_file);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		{
			GFileOutputStream* _tmp21_;
			_tmp21_ = stream;
			g_output_stream_close ((GOutputStream*) _tmp21_, NULL, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch193_g_error;
			}
		}
		goto __finally193;
		__catch193_g_error:
		{
			GError* e = NULL;
			DVBLoggingLogger* _tmp22_;
			GError* _tmp23_;
			const gchar* _tmp24_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp22_ = dvb_settings_log;
			_tmp23_ = e;
			_tmp24_ = _tmp23_->message;
			dvb_logging_logger_error (_tmp22_, "Settings.vala:175: %s", _tmp24_);
			success = FALSE;
			_g_error_free0 (e);
		}
		__finally193:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (stream);
			_g_object_unref0 (settings_file);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		_g_object_unref0 (stream);
	}
	_tmp25_ = success;
	if (_tmp25_) {
		{
			GKeyFile* _tmp26_;
			GFile* _tmp27_;
			gchar* _tmp28_ = NULL;
			gchar* _tmp29_;
			_tmp26_ = self->priv->keyfile;
			_tmp27_ = settings_file;
			_tmp28_ = g_file_get_path (_tmp27_);
			_tmp29_ = _tmp28_;
			g_key_file_load_from_file (_tmp26_, _tmp29_, 0, &_inner_error_);
			_g_free0 (_tmp29_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == G_KEY_FILE_ERROR) {
					goto __catch194_g_key_file_error;
				}
				if (_inner_error_->domain == G_FILE_ERROR) {
					goto __catch194_g_file_error;
				}
				_g_object_unref0 (settings_file);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		goto __finally194;
		__catch194_g_key_file_error:
		{
			GError* e = NULL;
			DVBLoggingLogger* _tmp30_;
			GError* _tmp31_;
			const gchar* _tmp32_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp30_ = dvb_settings_log;
			_tmp31_ = e;
			_tmp32_ = _tmp31_->message;
			dvb_logging_logger_error (_tmp30_, "Settings.vala:184: Could not load settings: %s", _tmp32_);
			success = FALSE;
			_g_error_free0 (e);
		}
		goto __finally194;
		__catch194_g_file_error:
		{
			GError* e = NULL;
			DVBLoggingLogger* _tmp33_;
			GError* _tmp34_;
			const gchar* _tmp35_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp33_ = dvb_settings_log;
			_tmp34_ = e;
			_tmp35_ = _tmp34_->message;
			dvb_logging_logger_error (_tmp33_, "Settings.vala:187: Could not load settings: %s", _tmp35_);
			success = FALSE;
			_g_error_free0 (e);
		}
		__finally194:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (settings_file);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = success;
	_g_object_unref0 (settings_file);
	return result;
}


gboolean dvb_settings_save (DVBSettings* self) {
	gboolean result = FALSE;
	GFile* _tmp0_ = NULL;
	GFile* settings_file;
	GFileOutputStream* stream;
	gchar* data;
	gsize data_len = 0UL;
	GKeyFile* _tmp10_;
	gsize _tmp11_ = 0UL;
	gchar* _tmp12_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = dvb_settings_get_settings_file (self);
	settings_file = _tmp0_;
	stream = NULL;
	{
		GFile* _tmp1_;
		GFileOutputStream* _tmp2_ = NULL;
		GFileOutputStream* _tmp3_;
		_tmp1_ = settings_file;
		_tmp2_ = g_file_replace (_tmp1_, NULL, TRUE, 0, NULL, &_inner_error_);
		_tmp3_ = _tmp2_;
		if (_inner_error_ != NULL) {
			goto __catch195_g_error;
		}
		_g_object_unref0 (stream);
		stream = _tmp3_;
	}
	goto __finally195;
	__catch195_g_error:
	{
		GError* e = NULL;
		DVBLoggingLogger* _tmp4_;
		GFile* _tmp5_;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_;
		GError* _tmp8_;
		const gchar* _tmp9_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = dvb_settings_log;
		_tmp5_ = settings_file;
		_tmp6_ = g_file_get_path (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = e;
		_tmp9_ = _tmp8_->message;
		dvb_logging_logger_error (_tmp4_, "Settings.vala:202: Could not replace file %s: %s", _tmp7_, _tmp9_);
		_g_free0 (_tmp7_);
		result = FALSE;
		_g_error_free0 (e);
		_g_object_unref0 (stream);
		_g_object_unref0 (settings_file);
		return result;
	}
	__finally195:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (stream);
		_g_object_unref0 (settings_file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	data = NULL;
	_tmp10_ = self->priv->keyfile;
	_tmp12_ = g_key_file_to_data (_tmp10_, &_tmp11_, NULL);
	data_len = _tmp11_;
	_g_free0 (data);
	data = _tmp12_;
	{
		GFileOutputStream* _tmp13_;
		const gchar* _tmp14_;
		guint8* _tmp15_;
		gint _tmp15__length1;
		guint8* _tmp16_;
		gint _tmp16__length1;
		_tmp13_ = stream;
		_tmp14_ = data;
		_tmp15_ = string_get_data (_tmp14_, &_tmp15__length1);
		_tmp16_ = _tmp15_;
		_tmp16__length1 = _tmp15__length1;
		g_output_stream_write_all ((GOutputStream*) _tmp13_, _tmp16_, (gsize) _tmp16__length1, NULL, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch196_g_error;
		}
	}
	goto __finally196;
	__catch196_g_error:
	{
		GError* e = NULL;
		DVBLoggingLogger* _tmp17_;
		GFile* _tmp18_;
		gchar* _tmp19_ = NULL;
		gchar* _tmp20_;
		GError* _tmp21_;
		const gchar* _tmp22_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp17_ = dvb_settings_log;
		_tmp18_ = settings_file;
		_tmp19_ = g_file_get_path (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = e;
		_tmp22_ = _tmp21_->message;
		dvb_logging_logger_error (_tmp17_, "Settings.vala:214: Could not write to file %s: %s", _tmp20_, _tmp22_);
		_g_free0 (_tmp20_);
		result = FALSE;
		_g_error_free0 (e);
		_g_free0 (data);
		_g_object_unref0 (stream);
		_g_object_unref0 (settings_file);
		return result;
	}
	__finally196:
	if (_inner_error_ != NULL) {
		_g_free0 (data);
		_g_object_unref0 (stream);
		_g_object_unref0 (settings_file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	{
		GFileOutputStream* _tmp23_;
		_tmp23_ = stream;
		g_output_stream_close ((GOutputStream*) _tmp23_, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch197_g_error;
		}
	}
	goto __finally197;
	__catch197_g_error:
	{
		GError* e = NULL;
		DVBLoggingLogger* _tmp24_;
		GError* _tmp25_;
		const gchar* _tmp26_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp24_ = dvb_settings_log;
		_tmp25_ = e;
		_tmp26_ = _tmp25_->message;
		dvb_logging_logger_error (_tmp24_, "Settings.vala:223: %s", _tmp26_);
		_g_error_free0 (e);
	}
	__finally197:
	if (_inner_error_ != NULL) {
		_g_free0 (data);
		_g_object_unref0 (stream);
		_g_object_unref0 (settings_file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = FALSE;
	_g_free0 (data);
	_g_object_unref0 (stream);
	_g_object_unref0 (settings_file);
	return result;
}


gchar* dvb_settings_get_string (DVBSettings* self, const gchar* group_name, const gchar* key, GError** error) {
	gchar* result = NULL;
	GKeyFile* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (group_name != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	_tmp0_ = self->priv->keyfile;
	_tmp1_ = group_name;
	_tmp2_ = key;
	_tmp3_ = g_key_file_get_string (_tmp0_, _tmp1_, _tmp2_, &_inner_error_);
	_tmp4_ = _tmp3_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_KEY_FILE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = _tmp4_;
	return result;
}


gboolean dvb_settings_get_boolean (DVBSettings* self, const gchar* group_name, const gchar* key, GError** error) {
	gboolean result = FALSE;
	GKeyFile* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (group_name != NULL, FALSE);
	g_return_val_if_fail (key != NULL, FALSE);
	_tmp0_ = self->priv->keyfile;
	_tmp1_ = group_name;
	_tmp2_ = key;
	_tmp3_ = g_key_file_get_boolean (_tmp0_, _tmp1_, _tmp2_, &_inner_error_);
	_tmp4_ = _tmp3_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_KEY_FILE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = _tmp4_;
	return result;
}


gint dvb_settings_get_integer (DVBSettings* self, const gchar* group_name, const gchar* key, GError** error) {
	gint result = 0;
	GKeyFile* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gint _tmp3_ = 0;
	gint _tmp4_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (group_name != NULL, 0);
	g_return_val_if_fail (key != NULL, 0);
	_tmp0_ = self->priv->keyfile;
	_tmp1_ = group_name;
	_tmp2_ = key;
	_tmp3_ = g_key_file_get_integer (_tmp0_, _tmp1_, _tmp2_, &_inner_error_);
	_tmp4_ = _tmp3_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_KEY_FILE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	result = _tmp4_;
	return result;
}


gdouble dvb_settings_get_double (DVBSettings* self, const gchar* group_name, const gchar* key, GError** error) {
	gdouble result = 0.0;
	GKeyFile* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gdouble _tmp3_ = 0.0;
	gdouble _tmp4_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0.0);
	g_return_val_if_fail (group_name != NULL, 0.0);
	g_return_val_if_fail (key != NULL, 0.0);
	_tmp0_ = self->priv->keyfile;
	_tmp1_ = group_name;
	_tmp2_ = key;
	_tmp3_ = g_key_file_get_double (_tmp0_, _tmp1_, _tmp2_, &_inner_error_);
	_tmp4_ = _tmp3_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_KEY_FILE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0.0;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0.0;
		}
	}
	result = _tmp4_;
	return result;
}


gchar** dvb_settings_get_string_list (DVBSettings* self, const gchar* group_name, const gchar* key, int* result_length1, GError** error) {
	gchar** result = NULL;
	GKeyFile* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gsize _tmp3_;
	gchar** _tmp4_ = NULL;
	gchar** _tmp5_;
	gint _tmp5__length1;
	gint __tmp5__size_;
	gchar** _tmp6_;
	gint _tmp6__length1;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (group_name != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	_tmp0_ = self->priv->keyfile;
	_tmp1_ = group_name;
	_tmp2_ = key;
	_tmp4_ = g_key_file_get_string_list (_tmp0_, _tmp1_, _tmp2_, &_tmp3_, &_inner_error_);
	_tmp5_ = _tmp4_;
	_tmp5__length1 = _tmp3_;
	__tmp5__size_ = _tmp5__length1;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_KEY_FILE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp6_ = _tmp5_;
	_tmp6__length1 = _tmp5__length1;
	if (result_length1) {
		*result_length1 = _tmp6__length1;
	}
	result = _tmp6_;
	return result;
}


gboolean* dvb_settings_get_boolean_list (DVBSettings* self, const gchar* group_name, const gchar* key, int* result_length1, GError** error) {
	gboolean* result = NULL;
	GKeyFile* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gsize _tmp3_;
	gboolean* _tmp4_ = NULL;
	gboolean* _tmp5_;
	gint _tmp5__length1;
	gint __tmp5__size_;
	gboolean* _tmp6_;
	gint _tmp6__length1;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (group_name != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	_tmp0_ = self->priv->keyfile;
	_tmp1_ = group_name;
	_tmp2_ = key;
	_tmp4_ = g_key_file_get_boolean_list (_tmp0_, _tmp1_, _tmp2_, &_tmp3_, &_inner_error_);
	_tmp5_ = _tmp4_;
	_tmp5__length1 = _tmp3_;
	__tmp5__size_ = _tmp5__length1;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_KEY_FILE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp6_ = _tmp5_;
	_tmp6__length1 = _tmp5__length1;
	if (result_length1) {
		*result_length1 = _tmp6__length1;
	}
	result = _tmp6_;
	return result;
}


gint* dvb_settings_get_integer_list (DVBSettings* self, const gchar* group_name, const gchar* key, int* result_length1, GError** error) {
	gint* result = NULL;
	GKeyFile* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gsize _tmp3_;
	gint* _tmp4_ = NULL;
	gint* _tmp5_;
	gint _tmp5__length1;
	gint __tmp5__size_;
	gint* _tmp6_;
	gint _tmp6__length1;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (group_name != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	_tmp0_ = self->priv->keyfile;
	_tmp1_ = group_name;
	_tmp2_ = key;
	_tmp4_ = g_key_file_get_integer_list (_tmp0_, _tmp1_, _tmp2_, &_tmp3_, &_inner_error_);
	_tmp5_ = _tmp4_;
	_tmp5__length1 = _tmp3_;
	__tmp5__size_ = _tmp5__length1;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_KEY_FILE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp6_ = _tmp5_;
	_tmp6__length1 = _tmp5__length1;
	if (result_length1) {
		*result_length1 = _tmp6__length1;
	}
	result = _tmp6_;
	return result;
}


gdouble* dvb_settings_get_double_list (DVBSettings* self, const gchar* group_name, const gchar* key, int* result_length1, GError** error) {
	gdouble* result = NULL;
	GKeyFile* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gsize _tmp3_;
	gdouble* _tmp4_ = NULL;
	gdouble* _tmp5_;
	gint _tmp5__length1;
	gint __tmp5__size_;
	gdouble* _tmp6_;
	gint _tmp6__length1;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (group_name != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	_tmp0_ = self->priv->keyfile;
	_tmp1_ = group_name;
	_tmp2_ = key;
	_tmp4_ = g_key_file_get_double_list (_tmp0_, _tmp1_, _tmp2_, &_tmp3_, &_inner_error_);
	_tmp5_ = _tmp4_;
	_tmp5__length1 = _tmp3_;
	__tmp5__size_ = _tmp5__length1;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_KEY_FILE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp6_ = _tmp5_;
	_tmp6__length1 = _tmp5__length1;
	if (result_length1) {
		*result_length1 = _tmp6__length1;
	}
	result = _tmp6_;
	return result;
}


void dvb_settings_set_string (DVBSettings* self, const gchar* group_name, const gchar* key, const gchar* val, GError** error) {
	GKeyFile* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (group_name != NULL);
	g_return_if_fail (key != NULL);
	g_return_if_fail (val != NULL);
	_tmp0_ = self->priv->keyfile;
	_tmp1_ = group_name;
	_tmp2_ = key;
	_tmp3_ = val;
	g_key_file_set_string (_tmp0_, _tmp1_, _tmp2_, _tmp3_);
}


void dvb_settings_set_boolean (DVBSettings* self, const gchar* group_name, const gchar* key, gboolean val, GError** error) {
	GKeyFile* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (group_name != NULL);
	g_return_if_fail (key != NULL);
	_tmp0_ = self->priv->keyfile;
	_tmp1_ = group_name;
	_tmp2_ = key;
	_tmp3_ = val;
	g_key_file_set_boolean (_tmp0_, _tmp1_, _tmp2_, _tmp3_);
}


void dvb_settings_set_double (DVBSettings* self, const gchar* group_name, const gchar* key, gdouble val, GError** error) {
	GKeyFile* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gdouble _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (group_name != NULL);
	g_return_if_fail (key != NULL);
	_tmp0_ = self->priv->keyfile;
	_tmp1_ = group_name;
	_tmp2_ = key;
	_tmp3_ = val;
	g_key_file_set_double (_tmp0_, _tmp1_, _tmp2_, _tmp3_);
}


void dvb_settings_set_integer (DVBSettings* self, const gchar* group_name, const gchar* key, gint val, GError** error) {
	GKeyFile* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gint _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (group_name != NULL);
	g_return_if_fail (key != NULL);
	_tmp0_ = self->priv->keyfile;
	_tmp1_ = group_name;
	_tmp2_ = key;
	_tmp3_ = val;
	g_key_file_set_integer (_tmp0_, _tmp1_, _tmp2_, _tmp3_);
}


void dvb_settings_set_string_list (DVBSettings* self, const gchar* group_name, const gchar* key, gchar** val, int val_length1, GError** error) {
	GKeyFile* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (group_name != NULL);
	g_return_if_fail (key != NULL);
	_tmp0_ = self->priv->keyfile;
	_tmp1_ = group_name;
	_tmp2_ = key;
	_tmp3_ = val;
	_tmp3__length1 = val_length1;
	g_key_file_set_string_list (_tmp0_, _tmp1_, _tmp2_, (const gchar* const*) _tmp3_, _tmp3__length1);
}


void dvb_settings_set_boolean_list (DVBSettings* self, const gchar* group_name, const gchar* key, gboolean* val, int val_length1, GError** error) {
	GKeyFile* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gboolean* _tmp3_;
	gint _tmp3__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (group_name != NULL);
	g_return_if_fail (key != NULL);
	_tmp0_ = self->priv->keyfile;
	_tmp1_ = group_name;
	_tmp2_ = key;
	_tmp3_ = val;
	_tmp3__length1 = val_length1;
	g_key_file_set_boolean_list (_tmp0_, _tmp1_, _tmp2_, _tmp3_, _tmp3__length1);
}


void dvb_settings_set_double_list (DVBSettings* self, const gchar* group_name, const gchar* key, gdouble* val, int val_length1, GError** error) {
	GKeyFile* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gdouble* _tmp3_;
	gint _tmp3__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (group_name != NULL);
	g_return_if_fail (key != NULL);
	_tmp0_ = self->priv->keyfile;
	_tmp1_ = group_name;
	_tmp2_ = key;
	_tmp3_ = val;
	_tmp3__length1 = val_length1;
	g_key_file_set_double_list (_tmp0_, _tmp1_, _tmp2_, _tmp3_, _tmp3__length1);
}


void dvb_settings_set_integer_list (DVBSettings* self, const gchar* group_name, const gchar* key, gint* val, int val_length1, GError** error) {
	GKeyFile* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gint* _tmp3_;
	gint _tmp3__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (group_name != NULL);
	g_return_if_fail (key != NULL);
	_tmp0_ = self->priv->keyfile;
	_tmp1_ = group_name;
	_tmp2_ = key;
	_tmp3_ = val;
	_tmp3__length1 = val_length1;
	g_key_file_set_integer_list (_tmp0_, _tmp1_, _tmp2_, _tmp3_, _tmp3__length1);
}


DVBSettings* dvb_settings_construct (GType object_type) {
	DVBSettings * self = NULL;
	self = (DVBSettings*) g_object_new (object_type, NULL);
	return self;
}


DVBSettings* dvb_settings_new (void) {
	return dvb_settings_construct (DVB_TYPE_SETTINGS);
}


static GObject * dvb_settings_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	DVBSettings * self;
	GKeyFile* _tmp0_;
	parent_class = G_OBJECT_CLASS (dvb_settings_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = DVB_SETTINGS (obj);
	_tmp0_ = g_key_file_new ();
	_g_key_file_free0 (self->priv->keyfile);
	self->priv->keyfile = _tmp0_;
	return obj;
}


static void dvb_settings_class_init (DVBSettingsClass * klass) {
	DVBLoggingLogManager* _tmp0_ = NULL;
	DVBLoggingLogger* _tmp1_ = NULL;
	dvb_settings_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBSettingsPrivate));
	G_OBJECT_CLASS (klass)->constructor = dvb_settings_constructor;
	G_OBJECT_CLASS (klass)->finalize = dvb_settings_finalize;
	_tmp0_ = dvb_logging_log_manager_getLogManager ();
	_tmp1_ = dvb_logging_log_manager_getDefaultLogger (_tmp0_);
	dvb_settings_log = _tmp1_;
}


static void dvb_settings_instance_init (DVBSettings * self) {
	self->priv = DVB_SETTINGS_GET_PRIVATE (self);
}


static void dvb_settings_finalize (GObject* obj) {
	DVBSettings * self;
	self = DVB_SETTINGS (obj);
	_g_key_file_free0 (self->priv->keyfile);
	G_OBJECT_CLASS (dvb_settings_parent_class)->finalize (obj);
}


GType dvb_settings_get_type (void) {
	static volatile gsize dvb_settings_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_settings_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBSettingsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_settings_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBSettings), 0, (GInstanceInitFunc) dvb_settings_instance_init, NULL };
		GType dvb_settings_type_id;
		dvb_settings_type_id = g_type_register_static (G_TYPE_OBJECT, "DVBSettings", &g_define_type_info, 0);
		g_once_init_leave (&dvb_settings_type_id__volatile, dvb_settings_type_id);
	}
	return dvb_settings_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



