/* Server.c generated by valac 0.12.0, the Vala compiler
 * generated from Server.vala, do not modify */

/*
 * Copyright (C) 2008-2010 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gst/rtsp-server/rtsp-server.h>
#include <stdlib.h>
#include <string.h>
#include <cstuff.h>
#include <gio/gio.h>
#include <gst/rtsp-server/rtsp-media-mapping.h>
#include <gst/rtsp-server/rtsp-session-pool.h>
#include <gst/rtsp-server/rtsp-session.h>
#include <gst/rtsp/gstrtspconnection.h>
#include <gobject/gvaluecollector.h>


#define DVB_LOGGING_TYPE_LOGGER (dvb_logging_logger_get_type ())
#define DVB_LOGGING_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLogger))
#define DVB_LOGGING_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLoggerClass))
#define DVB_LOGGING_IS_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_LOGGING_TYPE_LOGGER))
#define DVB_LOGGING_IS_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_LOGGING_TYPE_LOGGER))
#define DVB_LOGGING_LOGGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLoggerClass))

typedef struct _DVBLoggingLogger DVBLoggingLogger;
typedef struct _DVBLoggingLoggerClass DVBLoggingLoggerClass;

#define DVB_TYPE_SETTINGS (dvb_settings_get_type ())
#define DVB_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_SETTINGS, DVBSettings))
#define DVB_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_SETTINGS, DVBSettingsClass))
#define DVB_IS_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_SETTINGS))
#define DVB_IS_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_SETTINGS))
#define DVB_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_SETTINGS, DVBSettingsClass))

typedef struct _DVBSettings DVBSettings;
typedef struct _DVBSettingsClass DVBSettingsClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define DVB_LOGGING_TYPE_LOG_MANAGER (dvb_logging_log_manager_get_type ())
#define DVB_LOGGING_LOG_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManager))
#define DVB_LOGGING_LOG_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManagerClass))
#define DVB_LOGGING_IS_LOG_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_LOGGING_TYPE_LOG_MANAGER))
#define DVB_LOGGING_IS_LOG_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_LOGGING_TYPE_LOG_MANAGER))
#define DVB_LOGGING_LOG_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManagerClass))

typedef struct _DVBLoggingLogManager DVBLoggingLogManager;
typedef struct _DVBLoggingLogManagerClass DVBLoggingLogManagerClass;

#define DVB_TYPE_MEDIA_MAPPING (dvb_media_mapping_get_type ())
#define DVB_MEDIA_MAPPING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_MEDIA_MAPPING, DVBMediaMapping))
#define DVB_MEDIA_MAPPING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_MEDIA_MAPPING, DVBMediaMappingClass))
#define DVB_IS_MEDIA_MAPPING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_MEDIA_MAPPING))
#define DVB_IS_MEDIA_MAPPING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_MEDIA_MAPPING))
#define DVB_MEDIA_MAPPING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_MEDIA_MAPPING, DVBMediaMappingClass))

typedef struct _DVBMediaMapping DVBMediaMapping;
typedef struct _DVBMediaMappingClass DVBMediaMappingClass;
typedef struct _DvbRtspServerStartData DvbRtspServerStartData;

#define DVB_TYPE_CHANNEL (dvb_channel_get_type ())
#define DVB_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL, DVBChannel))
#define DVB_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL, DVBChannelClass))
#define DVB_IS_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL))
#define DVB_IS_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL))
#define DVB_CHANNEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL, DVBChannelClass))

typedef struct _DVBChannel DVBChannel;
typedef struct _DVBChannelClass DVBChannelClass;

#define DVB_RTSP_SERVER_TYPE_STOP_CHANNEL_HELPER (dvb_rtsp_server_stop_channel_helper_get_type ())
#define DVB_RTSP_SERVER_STOP_CHANNEL_HELPER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_RTSP_SERVER_TYPE_STOP_CHANNEL_HELPER, DVBRTSPServerStopChannelHelper))
#define DVB_RTSP_SERVER_STOP_CHANNEL_HELPER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_RTSP_SERVER_TYPE_STOP_CHANNEL_HELPER, DVBRTSPServerStopChannelHelperClass))
#define DVB_RTSP_SERVER_IS_STOP_CHANNEL_HELPER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_RTSP_SERVER_TYPE_STOP_CHANNEL_HELPER))
#define DVB_RTSP_SERVER_IS_STOP_CHANNEL_HELPER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_RTSP_SERVER_TYPE_STOP_CHANNEL_HELPER))
#define DVB_RTSP_SERVER_STOP_CHANNEL_HELPER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_RTSP_SERVER_TYPE_STOP_CHANNEL_HELPER, DVBRTSPServerStopChannelHelperClass))

typedef struct _DVBRTSPServerStopChannelHelper DVBRTSPServerStopChannelHelper;
typedef struct _DVBRTSPServerStopChannelHelperClass DVBRTSPServerStopChannelHelperClass;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _dvb_rtsp_server_stop_channel_helper_unref0(var) ((var == NULL) ? NULL : (var = (dvb_rtsp_server_stop_channel_helper_unref (var), NULL)))
typedef struct _DVBRTSPServerStopChannelHelperPrivate DVBRTSPServerStopChannelHelperPrivate;
#define _gst_rtsp_url_free0(var) ((var == NULL) ? NULL : (var = (gst_rtsp_url_free (var), NULL)))
typedef struct _DVBRTSPServerParamSpecStopChannelHelper DVBRTSPServerParamSpecStopChannelHelper;

struct _DvbRtspServerStartData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	DVBLoggingLogManager* _tmp0_;
	DVBLoggingLogger* _tmp1_;
	GstRTSPServer* _tmp2_;
	DVBMediaMapping* _tmp3_;
	DVBMediaMapping* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	GSourceFunc _tmp7_;
	guint _tmp8_;
};

struct _DVBRTSPServerStopChannelHelper {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DVBRTSPServerStopChannelHelperPrivate * priv;
};

struct _DVBRTSPServerStopChannelHelperClass {
	GTypeClass parent_class;
	void (*finalize) (DVBRTSPServerStopChannelHelper *self);
};

struct _DVBRTSPServerStopChannelHelperPrivate {
	GstRTSPUrl* url;
};

struct _DVBRTSPServerParamSpecStopChannelHelper {
	GParamSpec parent_instance;
};


extern DVBLoggingLogger* dvb_rtsp_server_log;
DVBLoggingLogger* dvb_rtsp_server_log = NULL;
extern GstRTSPServer* dvb_rtsp_server_server;
GstRTSPServer* dvb_rtsp_server_server = NULL;
extern guint dvb_rtsp_server_timeout_id;
guint dvb_rtsp_server_timeout_id = 0U;
static gpointer dvb_rtsp_server_stop_channel_helper_parent_class = NULL;

GType dvb_logging_logger_get_type (void) G_GNUC_CONST;
gchar* dvb_rtsp_server_get_address (void);
GType dvb_settings_get_type (void) G_GNUC_CONST;
DVBSettings* dvb_factory_get_settings (void);
gchar* dvb_settings_get_streaming_interface (DVBSettings* self);
static void dvb_rtsp_server_start_data_free (gpointer _data);
void dvb_rtsp_server_start (GAsyncReadyCallback _callback_, gpointer _user_data_);
void dvb_rtsp_server_start_finish (GAsyncResult* _res_);
static gboolean dvb_rtsp_server_start_co (DvbRtspServerStartData* data);
GType dvb_logging_log_manager_get_type (void) G_GNUC_CONST;
DVBLoggingLogManager* dvb_logging_log_manager_getLogManager (void);
DVBLoggingLogger* dvb_logging_log_manager_getDefaultLogger (DVBLoggingLogManager* self);
void dvb_logging_logger_info (DVBLoggingLogger* self, const gchar* format, ...);
DVBMediaMapping* dvb_media_mapping_new (void);
DVBMediaMapping* dvb_media_mapping_construct (GType object_type);
GType dvb_media_mapping_get_type (void) G_GNUC_CONST;
gboolean dvb_rtsp_server_timeout (void);
void dvb_rtsp_server_shutdown (void);
GType dvb_channel_get_type (void) G_GNUC_CONST;
void dvb_rtsp_server_stop_streaming (DVBChannel* channel);
void dvb_logging_logger_debug (DVBLoggingLogger* self, const gchar* format, ...);
const gchar* dvb_channel_get_Name (DVBChannel* self);
gchar* dvb_channel_get_URL (DVBChannel* self);
DVBRTSPServerStopChannelHelper* dvb_rtsp_server_stop_channel_helper_new (const gchar* url_str);
DVBRTSPServerStopChannelHelper* dvb_rtsp_server_stop_channel_helper_construct (GType object_type, const gchar* url_str);
gpointer dvb_rtsp_server_stop_channel_helper_ref (gpointer instance);
void dvb_rtsp_server_stop_channel_helper_unref (gpointer instance);
GParamSpec* dvb_rtsp_server_param_spec_stop_channel_helper (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void dvb_rtsp_server_value_set_stop_channel_helper (GValue* value, gpointer v_object);
void dvb_rtsp_server_value_take_stop_channel_helper (GValue* value, gpointer v_object);
gpointer dvb_rtsp_server_value_get_stop_channel_helper (const GValue* value);
GType dvb_rtsp_server_stop_channel_helper_get_type (void) G_GNUC_CONST;
GstRTSPFilterResult dvb_rtsp_server_stop_channel_helper_session_filter_func (DVBRTSPServerStopChannelHelper* self, GstRTSPSessionPool* pool, GstRTSPSession* session);
static GstRTSPFilterResult _dvb_rtsp_server_stop_channel_helper_session_filter_func_gst_rtsp_session_filter_func (GstRTSPSessionPool* pool, GstRTSPSession* session, gpointer self);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
#define DVB_RTSP_SERVER_STOP_CHANNEL_HELPER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_RTSP_SERVER_TYPE_STOP_CHANNEL_HELPER, DVBRTSPServerStopChannelHelperPrivate))
enum  {
	DVB_RTSP_SERVER_STOP_CHANNEL_HELPER_DUMMY_PROPERTY
};
static void dvb_rtsp_server_stop_channel_helper_finalize (DVBRTSPServerStopChannelHelper* obj);


gchar* dvb_rtsp_server_get_address (void) {
	gchar* result = NULL;
	DVBSettings* _tmp0_ = NULL;
	DVBSettings* settings;
	gchar* _tmp1_ = NULL;
	gchar* iface;
	gchar* address;
	GList* _tmp2_ = NULL;
	GList* adapters;
	_tmp0_ = dvb_factory_get_settings ();
	settings = _tmp0_;
	_tmp1_ = dvb_settings_get_streaming_interface (settings);
	iface = _tmp1_;
	address = NULL;
	_tmp2_ = get_adapters ();
	adapters = _tmp2_;
	{
		GList* na_collection;
		GList* na_it;
		na_collection = adapters;
		for (na_it = na_collection; na_it != NULL; na_it = na_it->next) {
			struct net_adapter* na;
			na = (struct net_adapter*) na_it->data;
			{
				if (g_strcmp0 (na->name, iface) == 0) {
					gchar* _tmp3_;
					_tmp3_ = g_strdup (na->address);
					_g_free0 (address);
					address = _tmp3_;
					break;
				}
			}
		}
	}
	if (address == NULL) {
		gchar* _tmp4_;
		g_warning ("Server.vala:43: Could not find network interface '%s'", iface);
		_tmp4_ = g_strdup ("127.0.0.1");
		_g_free0 (address);
		address = _tmp4_;
	}
	result = address;
	_g_list_free0 (adapters);
	_g_free0 (iface);
	_g_object_unref0 (settings);
	return result;
}


static void dvb_rtsp_server_start_data_free (gpointer _data) {
	DvbRtspServerStartData* data;
	data = _data;
	g_slice_free (DvbRtspServerStartData, data);
}


void dvb_rtsp_server_start (GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DvbRtspServerStartData* _data_;
	_data_ = g_slice_new0 (DvbRtspServerStartData);
	_data_->_async_result = g_simple_async_result_new (g_object_newv (G_TYPE_OBJECT, 0, NULL), _callback_, _user_data_, dvb_rtsp_server_start);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, dvb_rtsp_server_start_data_free);
	dvb_rtsp_server_start_co (_data_);
}


void dvb_rtsp_server_start_finish (GAsyncResult* _res_) {
	DvbRtspServerStartData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean dvb_rtsp_server_start_co (DvbRtspServerStartData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->_tmp0_ = dvb_logging_log_manager_getLogManager ();
	data->_tmp1_ = NULL;
	data->_tmp1_ = dvb_logging_log_manager_getDefaultLogger (data->_tmp0_);
	_g_object_unref0 (dvb_rtsp_server_log);
	dvb_rtsp_server_log = data->_tmp1_;
	dvb_logging_logger_info (dvb_rtsp_server_log, "Server.vala:52: Starting RTSP server");
	data->_tmp2_ = NULL;
	data->_tmp2_ = gst_rtsp_server_new ();
	_g_object_unref0 (dvb_rtsp_server_server);
	dvb_rtsp_server_server = data->_tmp2_;
	data->_tmp3_ = NULL;
	data->_tmp3_ = dvb_media_mapping_new ();
	data->_tmp4_ = data->_tmp3_;
	gst_rtsp_server_set_media_mapping (dvb_rtsp_server_server, (GstRTSPMediaMapping*) data->_tmp4_);
	_g_object_unref0 (data->_tmp4_);
	data->_tmp5_ = NULL;
	data->_tmp5_ = dvb_rtsp_server_get_address ();
	data->_tmp6_ = data->_tmp5_;
	gst_rtsp_server_set_address (dvb_rtsp_server_server, data->_tmp6_);
	_g_free0 (data->_tmp6_);
	gst_rtsp_server_attach (dvb_rtsp_server_server, NULL);
	data->_tmp7_ = (GSourceFunc) dvb_rtsp_server_timeout;
	data->_tmp8_ = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 2, data->_tmp7_, NULL, NULL);
	dvb_rtsp_server_timeout_id = data->_tmp8_;
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


void dvb_rtsp_server_shutdown (void) {
	g_source_remove (dvb_rtsp_server_timeout_id);
	_g_object_unref0 (dvb_rtsp_server_server);
	dvb_rtsp_server_server = NULL;
}


static GstRTSPFilterResult _dvb_rtsp_server_stop_channel_helper_session_filter_func_gst_rtsp_session_filter_func (GstRTSPSessionPool* pool, GstRTSPSession* session, gpointer self) {
	GstRTSPFilterResult result;
	result = dvb_rtsp_server_stop_channel_helper_session_filter_func (self, pool, session);
	return result;
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


void dvb_rtsp_server_stop_streaming (DVBChannel* channel) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	DVBRTSPServerStopChannelHelper* _tmp3_ = NULL;
	DVBRTSPServerStopChannelHelper* _tmp4_;
	DVBRTSPServerStopChannelHelper* helper;
	GstRTSPSessionPool* _tmp5_ = NULL;
	GList* _tmp6_ = NULL;
	GList* _tmp7_;
	g_return_if_fail (channel != NULL);
	_tmp0_ = dvb_channel_get_Name (channel);
	dvb_logging_logger_debug (dvb_rtsp_server_log, "Server.vala:66: Stop streaming channel %s", _tmp0_);
	_tmp1_ = dvb_channel_get_URL (channel);
	_tmp2_ = _tmp1_;
	_tmp3_ = dvb_rtsp_server_stop_channel_helper_new (_tmp2_);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	helper = _tmp4_;
	_tmp5_ = gst_rtsp_server_get_session_pool (dvb_rtsp_server_server);
	_tmp6_ = gst_rtsp_session_pool_filter (_tmp5_, _dvb_rtsp_server_stop_channel_helper_session_filter_func_gst_rtsp_session_filter_func, helper);
	_tmp7_ = _tmp6_;
	__g_list_free__g_object_unref0_0 (_tmp7_);
	_dvb_rtsp_server_stop_channel_helper_unref0 (helper);
}


gboolean dvb_rtsp_server_timeout (void) {
	gboolean result = FALSE;
	GstRTSPSessionPool* _tmp0_ = NULL;
	GstRTSPSessionPool* pool;
	_tmp0_ = gst_rtsp_server_get_session_pool (dvb_rtsp_server_server);
	pool = _tmp0_;
	gst_rtsp_session_pool_cleanup (pool);
	result = TRUE;
	_g_object_unref0 (pool);
	return result;
}


DVBRTSPServerStopChannelHelper* dvb_rtsp_server_stop_channel_helper_construct (GType object_type, const gchar* url_str) {
	DVBRTSPServerStopChannelHelper* self = NULL;
	GstRTSPUrl* _tmp0_ = NULL;
	g_return_val_if_fail (url_str != NULL, NULL);
	self = (DVBRTSPServerStopChannelHelper*) g_type_create_instance (object_type);
	gst_rtsp_url_parse (url_str, &_tmp0_);
	_gst_rtsp_url_free0 (self->priv->url);
	self->priv->url = _tmp0_;
	return self;
}


DVBRTSPServerStopChannelHelper* dvb_rtsp_server_stop_channel_helper_new (const gchar* url_str) {
	return dvb_rtsp_server_stop_channel_helper_construct (DVB_RTSP_SERVER_TYPE_STOP_CHANNEL_HELPER, url_str);
}


GstRTSPFilterResult dvb_rtsp_server_stop_channel_helper_session_filter_func (DVBRTSPServerStopChannelHelper* self, GstRTSPSessionPool* pool, GstRTSPSession* session) {
	GstRTSPFilterResult result = 0;
	GstRTSPSessionMedia* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (pool != NULL, 0);
	g_return_val_if_fail (session != NULL, 0);
	_tmp0_ = gst_rtsp_session_get_media (session, self->priv->url);
	if (_tmp0_ != NULL) {
		result = GST_RTSP_FILTER_REMOVE;
		return result;
	} else {
		result = GST_RTSP_FILTER_KEEP;
		return result;
	}
}


static void dvb_rtsp_server_value_stop_channel_helper_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void dvb_rtsp_server_value_stop_channel_helper_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		dvb_rtsp_server_stop_channel_helper_unref (value->data[0].v_pointer);
	}
}


static void dvb_rtsp_server_value_stop_channel_helper_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = dvb_rtsp_server_stop_channel_helper_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer dvb_rtsp_server_value_stop_channel_helper_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* dvb_rtsp_server_value_stop_channel_helper_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		DVBRTSPServerStopChannelHelper* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = dvb_rtsp_server_stop_channel_helper_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* dvb_rtsp_server_value_stop_channel_helper_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	DVBRTSPServerStopChannelHelper** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = dvb_rtsp_server_stop_channel_helper_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* dvb_rtsp_server_param_spec_stop_channel_helper (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	DVBRTSPServerParamSpecStopChannelHelper* spec;
	g_return_val_if_fail (g_type_is_a (object_type, DVB_RTSP_SERVER_TYPE_STOP_CHANNEL_HELPER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer dvb_rtsp_server_value_get_stop_channel_helper (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, DVB_RTSP_SERVER_TYPE_STOP_CHANNEL_HELPER), NULL);
	return value->data[0].v_pointer;
}


void dvb_rtsp_server_value_set_stop_channel_helper (GValue* value, gpointer v_object) {
	DVBRTSPServerStopChannelHelper* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, DVB_RTSP_SERVER_TYPE_STOP_CHANNEL_HELPER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, DVB_RTSP_SERVER_TYPE_STOP_CHANNEL_HELPER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		dvb_rtsp_server_stop_channel_helper_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		dvb_rtsp_server_stop_channel_helper_unref (old);
	}
}


void dvb_rtsp_server_value_take_stop_channel_helper (GValue* value, gpointer v_object) {
	DVBRTSPServerStopChannelHelper* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, DVB_RTSP_SERVER_TYPE_STOP_CHANNEL_HELPER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, DVB_RTSP_SERVER_TYPE_STOP_CHANNEL_HELPER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		dvb_rtsp_server_stop_channel_helper_unref (old);
	}
}


static void dvb_rtsp_server_stop_channel_helper_class_init (DVBRTSPServerStopChannelHelperClass * klass) {
	dvb_rtsp_server_stop_channel_helper_parent_class = g_type_class_peek_parent (klass);
	DVB_RTSP_SERVER_STOP_CHANNEL_HELPER_CLASS (klass)->finalize = dvb_rtsp_server_stop_channel_helper_finalize;
	g_type_class_add_private (klass, sizeof (DVBRTSPServerStopChannelHelperPrivate));
}


static void dvb_rtsp_server_stop_channel_helper_instance_init (DVBRTSPServerStopChannelHelper * self) {
	self->priv = DVB_RTSP_SERVER_STOP_CHANNEL_HELPER_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void dvb_rtsp_server_stop_channel_helper_finalize (DVBRTSPServerStopChannelHelper* obj) {
	DVBRTSPServerStopChannelHelper * self;
	self = DVB_RTSP_SERVER_STOP_CHANNEL_HELPER (obj);
	_gst_rtsp_url_free0 (self->priv->url);
}


GType dvb_rtsp_server_stop_channel_helper_get_type (void) {
	static volatile gsize dvb_rtsp_server_stop_channel_helper_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_rtsp_server_stop_channel_helper_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { dvb_rtsp_server_value_stop_channel_helper_init, dvb_rtsp_server_value_stop_channel_helper_free_value, dvb_rtsp_server_value_stop_channel_helper_copy_value, dvb_rtsp_server_value_stop_channel_helper_peek_pointer, "p", dvb_rtsp_server_value_stop_channel_helper_collect_value, "p", dvb_rtsp_server_value_stop_channel_helper_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (DVBRTSPServerStopChannelHelperClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_rtsp_server_stop_channel_helper_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBRTSPServerStopChannelHelper), 0, (GInstanceInitFunc) dvb_rtsp_server_stop_channel_helper_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType dvb_rtsp_server_stop_channel_helper_type_id;
		dvb_rtsp_server_stop_channel_helper_type_id = g_type_register_fundamental (g_type_fundamental_next (), "DVBRTSPServerStopChannelHelper", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&dvb_rtsp_server_stop_channel_helper_type_id__volatile, dvb_rtsp_server_stop_channel_helper_type_id);
	}
	return dvb_rtsp_server_stop_channel_helper_type_id__volatile;
}


gpointer dvb_rtsp_server_stop_channel_helper_ref (gpointer instance) {
	DVBRTSPServerStopChannelHelper* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void dvb_rtsp_server_stop_channel_helper_unref (gpointer instance) {
	DVBRTSPServerStopChannelHelper* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		DVB_RTSP_SERVER_STOP_CHANNEL_HELPER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}



