/* MediaFactory.c generated by valac 0.12.0, the Vala compiler
 * generated from MediaFactory.vala, do not modify */

/*
 * Copyright (C) 2008,2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gst/rtsp-server/rtsp-media-factory.h>
#include <gst/rtsp/gstrtspconnection.h>
#include <gst/rtsp-server/rtsp-media.h>
#include <stdlib.h>
#include <string.h>
#include <gst/gst.h>


#define DVB_TYPE_MEDIA_FACTORY (dvb_media_factory_get_type ())
#define DVB_MEDIA_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_MEDIA_FACTORY, DVBMediaFactory))
#define DVB_MEDIA_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_MEDIA_FACTORY, DVBMediaFactoryClass))
#define DVB_IS_MEDIA_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_MEDIA_FACTORY))
#define DVB_IS_MEDIA_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_MEDIA_FACTORY))
#define DVB_MEDIA_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_MEDIA_FACTORY, DVBMediaFactoryClass))

typedef struct _DVBMediaFactory DVBMediaFactory;
typedef struct _DVBMediaFactoryClass DVBMediaFactoryClass;
typedef struct _DVBMediaFactoryPrivate DVBMediaFactoryPrivate;

#define DVB_LOGGING_TYPE_LOGGER (dvb_logging_logger_get_type ())
#define DVB_LOGGING_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLogger))
#define DVB_LOGGING_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLoggerClass))
#define DVB_LOGGING_IS_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_LOGGING_TYPE_LOGGER))
#define DVB_LOGGING_IS_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_LOGGING_TYPE_LOGGER))
#define DVB_LOGGING_LOGGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLoggerClass))

typedef struct _DVBLoggingLogger DVBLoggingLogger;
typedef struct _DVBLoggingLoggerClass DVBLoggingLoggerClass;

#define DVB_LOGGING_TYPE_LOG_MANAGER (dvb_logging_log_manager_get_type ())
#define DVB_LOGGING_LOG_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManager))
#define DVB_LOGGING_LOG_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManagerClass))
#define DVB_LOGGING_IS_LOG_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_LOGGING_TYPE_LOG_MANAGER))
#define DVB_LOGGING_IS_LOG_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_LOGGING_TYPE_LOG_MANAGER))
#define DVB_LOGGING_LOG_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManagerClass))

typedef struct _DVBLoggingLogManager DVBLoggingLogManager;
typedef struct _DVBLoggingLogManagerClass DVBLoggingLogManagerClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define DVB_TYPE_MANAGER (dvb_manager_get_type ())
#define DVB_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_MANAGER, DVBManager))
#define DVB_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_MANAGER, DVBManagerClass))
#define DVB_IS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_MANAGER))
#define DVB_IS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_MANAGER))
#define DVB_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_MANAGER, DVBManagerClass))

typedef struct _DVBManager DVBManager;
typedef struct _DVBManagerClass DVBManagerClass;

#define DVB_TYPE_DEVICE_GROUP (dvb_device_group_get_type ())
#define DVB_DEVICE_GROUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_DEVICE_GROUP, DVBDeviceGroup))
#define DVB_DEVICE_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_DEVICE_GROUP, DVBDeviceGroupClass))
#define DVB_IS_DEVICE_GROUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_DEVICE_GROUP))
#define DVB_IS_DEVICE_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_DEVICE_GROUP))
#define DVB_DEVICE_GROUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_DEVICE_GROUP, DVBDeviceGroupClass))

typedef struct _DVBDeviceGroup DVBDeviceGroup;
typedef struct _DVBDeviceGroupClass DVBDeviceGroupClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _gst_object_unref0(var) ((var == NULL) ? NULL : (var = (gst_object_unref (var), NULL)))

#define DVB_TYPE_CHANNEL_LIST (dvb_channel_list_get_type ())
#define DVB_CHANNEL_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL_LIST, DVBChannelList))
#define DVB_CHANNEL_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL_LIST, DVBChannelListClass))
#define DVB_IS_CHANNEL_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL_LIST))
#define DVB_IS_CHANNEL_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL_LIST))
#define DVB_CHANNEL_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL_LIST, DVBChannelListClass))

typedef struct _DVBChannelList DVBChannelList;
typedef struct _DVBChannelListClass DVBChannelListClass;

#define DVB_TYPE_CHANNEL (dvb_channel_get_type ())
#define DVB_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL, DVBChannel))
#define DVB_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL, DVBChannelClass))
#define DVB_IS_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL))
#define DVB_IS_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL))
#define DVB_CHANNEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL, DVBChannelClass))

typedef struct _DVBChannel DVBChannel;
typedef struct _DVBChannelClass DVBChannelClass;

#define DVB_TYPE_CHANNEL_FACTORY (dvb_channel_factory_get_type ())
#define DVB_CHANNEL_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL_FACTORY, DVBChannelFactory))
#define DVB_CHANNEL_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL_FACTORY, DVBChannelFactoryClass))
#define DVB_IS_CHANNEL_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL_FACTORY))
#define DVB_IS_CHANNEL_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL_FACTORY))
#define DVB_CHANNEL_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL_FACTORY, DVBChannelFactoryClass))

typedef struct _DVBChannelFactory DVBChannelFactory;
typedef struct _DVBChannelFactoryClass DVBChannelFactoryClass;

#define DVB_TYPE_PLAYER_THREAD (dvb_player_thread_get_type ())
#define DVB_PLAYER_THREAD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_PLAYER_THREAD, DVBPlayerThread))
#define DVB_PLAYER_THREAD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_PLAYER_THREAD, DVBPlayerThreadClass))
#define DVB_IS_PLAYER_THREAD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_PLAYER_THREAD))
#define DVB_IS_PLAYER_THREAD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_PLAYER_THREAD))
#define DVB_PLAYER_THREAD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_PLAYER_THREAD, DVBPlayerThreadClass))

typedef struct _DVBPlayerThread DVBPlayerThread;
typedef struct _DVBPlayerThreadClass DVBPlayerThreadClass;

#define DVB_TYPE_DVB_MEDIA (dvb_dvb_media_get_type ())
#define DVB_DVB_MEDIA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_DVB_MEDIA, DVBDVBMedia))
#define DVB_DVB_MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_DVB_MEDIA, DVBDVBMediaClass))
#define DVB_IS_DVB_MEDIA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_DVB_MEDIA))
#define DVB_IS_DVB_MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_DVB_MEDIA))
#define DVB_DVB_MEDIA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_DVB_MEDIA, DVBDVBMediaClass))

typedef struct _DVBDVBMedia DVBDVBMedia;
typedef struct _DVBDVBMediaClass DVBDVBMediaClass;
typedef struct _DVBDVBMediaPrivate DVBDVBMediaPrivate;

struct _DVBMediaFactory {
	GstRTSPMediaFactory parent_instance;
	DVBMediaFactoryPrivate * priv;
};

struct _DVBMediaFactoryClass {
	GstRTSPMediaFactoryClass parent_class;
};

typedef void (*DVBForcedStopNotify) (DVBChannel* channel, void* user_data);
struct _DVBDVBMedia {
	GstRTSPMedia parent_instance;
	DVBDVBMediaPrivate * priv;
	DVBDeviceGroup* group;
	DVBChannel* channel;
	GstElement* payloader;
};

struct _DVBDVBMediaClass {
	GstRTSPMediaClass parent_class;
};


static gpointer dvb_media_factory_parent_class = NULL;
static DVBLoggingLogger* dvb_media_factory_log;
static DVBLoggingLogger* dvb_media_factory_log = NULL;
static gpointer dvb_dvb_media_parent_class = NULL;

GType dvb_media_factory_get_type (void) G_GNUC_CONST;
enum  {
	DVB_MEDIA_FACTORY_DUMMY_PROPERTY
};
GType dvb_logging_logger_get_type (void) G_GNUC_CONST;
GType dvb_logging_log_manager_get_type (void) G_GNUC_CONST;
DVBLoggingLogManager* dvb_logging_log_manager_getLogManager (void);
DVBLoggingLogger* dvb_logging_log_manager_getDefaultLogger (DVBLoggingLogManager* self);
static GstRTSPMedia* dvb_media_factory_real_construct (GstRTSPMediaFactory* base, GstRTSPUrl* url);
GType dvb_manager_get_type (void) G_GNUC_CONST;
DVBManager* dvb_manager_get_instance (void);
GType dvb_device_group_get_type (void) G_GNUC_CONST;
DVBDeviceGroup* dvb_manager_get_device_group_if_exists (DVBManager* self, guint group_id);
void dvb_logging_logger_error (DVBLoggingLogger* self, const gchar* format, ...);
GType dvb_channel_list_get_type (void) G_GNUC_CONST;
DVBChannelList* dvb_device_group_get_Channels (DVBDeviceGroup* self);
GType dvb_channel_get_type (void) G_GNUC_CONST;
DVBChannel* dvb_channel_list_get_channel (DVBChannelList* self, guint sid);
GType dvb_channel_factory_get_type (void) G_GNUC_CONST;
DVBChannelFactory* dvb_device_group_get_channel_factory (DVBDeviceGroup* self);
GType dvb_player_thread_get_type (void) G_GNUC_CONST;
DVBPlayerThread* dvb_channel_factory_watch_channel (DVBChannelFactory* self, DVBChannel* channel, GstElement* sink_element, gboolean force, DVBForcedStopNotify notify_func, void* notify_func_target);
void dvb_rtsp_server_stop_streaming (DVBChannel* channel);
static void _dvb_rtsp_server_stop_streaming_dvb_forced_stop_notify (DVBChannel* channel, gpointer self);
void dvb_logging_logger_debug (DVBLoggingLogger* self, const gchar* format, ...);
GstElement* dvb_player_thread_get_sink_bin (DVBPlayerThread* self, guint sid, GstElement* sink);
DVBDVBMedia* dvb_dvb_media_new (DVBDeviceGroup* group, DVBChannel* channel, GstElement* payloader);
DVBDVBMedia* dvb_dvb_media_construct (GType object_type, DVBDeviceGroup* group, DVBChannel* channel, GstElement* payloader);
GType dvb_dvb_media_get_type (void) G_GNUC_CONST;
GstElement* dvb_player_thread_get_pipeline (DVBPlayerThread* self);
static gchar* dvb_media_factory_real_gen_key (GstRTSPMediaFactory* base, GstRTSPUrl* url);
DVBMediaFactory* dvb_media_factory_new (void);
DVBMediaFactory* dvb_media_factory_construct (GType object_type);
static GObject * dvb_media_factory_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void dvb_media_factory_finalize (GObject* obj);
enum  {
	DVB_DVB_MEDIA_DUMMY_PROPERTY
};
static gboolean dvb_dvb_media_real_unprepare (GstRTSPMedia* base);
gboolean dvb_channel_factory_stop_channel (DVBChannelFactory* self, DVBChannel* channel, GstElement* sink);
static void dvb_dvb_media_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gpointer _gst_object_ref0 (gpointer self) {
	return self ? gst_object_ref (self) : NULL;
}


static void _dvb_rtsp_server_stop_streaming_dvb_forced_stop_notify (DVBChannel* channel, gpointer self) {
	dvb_rtsp_server_stop_streaming (channel);
}


static GstRTSPMedia* dvb_media_factory_real_construct (GstRTSPMediaFactory* base, GstRTSPUrl* url) {
	DVBMediaFactory * self;
	GstRTSPMedia* result = NULL;
	guint sidnr;
	guint grpnr;
	gchar** _tmp0_;
	gchar** _tmp1_ = NULL;
	gchar** path_elements;
	gint path_elements_length1;
	gint _path_elements_size_;
	gint i;
	gchar* elem = NULL;
	DVBManager* _tmp5_ = NULL;
	DVBManager* _tmp6_;
	DVBManager* manager;
	DVBDeviceGroup* _tmp7_ = NULL;
	DVBDeviceGroup* devgrp;
	GstElement* _tmp8_ = NULL;
	GstElement* payload;
	DVBChannelList* _tmp9_ = NULL;
	DVBChannel* _tmp10_ = NULL;
	DVBChannel* channel;
	DVBChannelFactory* _tmp11_ = NULL;
	DVBChannelFactory* _tmp12_;
	DVBChannelFactory* channels_factory;
	GstElement* _tmp13_;
	DVBPlayerThread* _tmp14_ = NULL;
	DVBPlayerThread* player;
	GstElement* _tmp15_ = NULL;
	GstElement* bin;
	DVBDVBMedia* _tmp16_ = NULL;
	GstRTSPMedia* media;
	GstElement* _tmp17_ = NULL;
	self = (DVBMediaFactory*) base;
	g_return_val_if_fail (url != NULL, NULL);
	sidnr = (guint) 0;
	grpnr = (guint) 0;
	_tmp1_ = _tmp0_ = g_strsplit (url->abspath, "/", 0);
	path_elements = _tmp1_;
	path_elements_length1 = _vala_array_length (_tmp0_);
	_path_elements_size_ = _vala_array_length (_tmp0_);
	i = 0;
	while (TRUE) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (path_elements[i]);
		_g_free0 (elem);
		elem = _tmp2_;
		if (!(elem != NULL)) {
			break;
		}
		if (i == 1) {
			gint _tmp3_;
			_tmp3_ = atoi (elem);
			grpnr = (guint) _tmp3_;
		} else {
			if (i == 2) {
				gint _tmp4_;
				_tmp4_ = atoi (elem);
				sidnr = (guint) _tmp4_;
			}
		}
		i++;
	}
	_tmp5_ = dvb_manager_get_instance ();
	_tmp6_ = _g_object_ref0 (_tmp5_);
	manager = _tmp6_;
	_tmp7_ = dvb_manager_get_device_group_if_exists (manager, grpnr);
	devgrp = _tmp7_;
	if (devgrp == NULL) {
		g_warning ("MediaFactory.vala:54: Unknown group %u", grpnr);
		result = NULL;
		_g_object_unref0 (devgrp);
		_g_object_unref0 (manager);
		_g_free0 (elem);
		path_elements = (_vala_array_free (path_elements, path_elements_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	_tmp8_ = gst_element_factory_make ("rtpmp2tpay", "pay0");
	payload = _tmp8_;
	if (payload == NULL) {
		dvb_logging_logger_error (dvb_media_factory_log, "MediaFactory.vala:61: Could not create rtpmp2tpay element");
		result = NULL;
		_gst_object_unref0 (payload);
		_g_object_unref0 (devgrp);
		_g_object_unref0 (manager);
		_g_free0 (elem);
		path_elements = (_vala_array_free (path_elements, path_elements_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	g_object_set ((GObject*) payload, "pt", 96, NULL);
	_tmp9_ = dvb_device_group_get_Channels (devgrp);
	_tmp10_ = dvb_channel_list_get_channel (_tmp9_, sidnr);
	channel = _tmp10_;
	if (channel == NULL) {
		dvb_logging_logger_error (dvb_media_factory_log, "MediaFactory.vala:68: No channel with SID %u", sidnr);
		result = NULL;
		_g_object_unref0 (channel);
		_gst_object_unref0 (payload);
		_g_object_unref0 (devgrp);
		_g_object_unref0 (manager);
		_g_free0 (elem);
		path_elements = (_vala_array_free (path_elements, path_elements_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	_tmp11_ = dvb_device_group_get_channel_factory (devgrp);
	_tmp12_ = _g_object_ref0 (_tmp11_);
	channels_factory = _tmp12_;
	_tmp13_ = _gst_object_ref0 (payload);
	_tmp14_ = dvb_channel_factory_watch_channel (channels_factory, channel, _tmp13_, FALSE, _dvb_rtsp_server_stop_streaming_dvb_forced_stop_notify, NULL);
	player = _tmp14_;
	if (player == NULL) {
		dvb_logging_logger_debug (dvb_media_factory_log, "MediaFactory.vala:76: Could not create player");
		result = NULL;
		_g_object_unref0 (player);
		_g_object_unref0 (channels_factory);
		_g_object_unref0 (channel);
		_gst_object_unref0 (payload);
		_g_object_unref0 (devgrp);
		_g_object_unref0 (manager);
		_g_free0 (elem);
		path_elements = (_vala_array_free (path_elements, path_elements_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	dvb_logging_logger_debug (dvb_media_factory_log, "MediaFactory.vala:79: Retrieving sink bin with payloader");
	_tmp15_ = dvb_player_thread_get_sink_bin (player, sidnr, payload);
	bin = _tmp15_;
	_tmp16_ = dvb_dvb_media_new (devgrp, channel, payload);
	media = (GstRTSPMedia*) _tmp16_;
	media->element = bin;
	_tmp17_ = dvb_player_thread_get_pipeline (player);
	_gst_object_unref0 (media->pipeline);
	media->pipeline = _tmp17_;
	gst_rtsp_media_factory_collect_streams ((GstRTSPMediaFactory*) self, url, media);
	result = media;
	_gst_object_unref0 (bin);
	_g_object_unref0 (player);
	_g_object_unref0 (channels_factory);
	_g_object_unref0 (channel);
	_gst_object_unref0 (payload);
	_g_object_unref0 (devgrp);
	_g_object_unref0 (manager);
	_g_free0 (elem);
	path_elements = (_vala_array_free (path_elements, path_elements_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static gchar* dvb_media_factory_real_gen_key (GstRTSPMediaFactory* base, GstRTSPUrl* url) {
	DVBMediaFactory * self;
	gchar* result = NULL;
	gchar* _tmp0_;
	self = (DVBMediaFactory*) base;
	g_return_val_if_fail (url != NULL, NULL);
	_tmp0_ = g_strdup (url->abspath);
	result = _tmp0_;
	return result;
}


DVBMediaFactory* dvb_media_factory_construct (GType object_type) {
	DVBMediaFactory * self = NULL;
	self = (DVBMediaFactory*) g_object_new (object_type, NULL);
	return self;
}


DVBMediaFactory* dvb_media_factory_new (void) {
	return dvb_media_factory_construct (DVB_TYPE_MEDIA_FACTORY);
}


static GObject * dvb_media_factory_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	DVBMediaFactory * self;
	parent_class = G_OBJECT_CLASS (dvb_media_factory_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = DVB_MEDIA_FACTORY (obj);
	gst_rtsp_media_factory_set_shared ((GstRTSPMediaFactory*) self, TRUE);
	return obj;
}


static void dvb_media_factory_class_init (DVBMediaFactoryClass * klass) {
	DVBLoggingLogManager* _tmp0_ = NULL;
	DVBLoggingLogger* _tmp1_ = NULL;
	dvb_media_factory_parent_class = g_type_class_peek_parent (klass);
	GST_RTSP_MEDIA_FACTORY_CLASS (klass)->construct = dvb_media_factory_real_construct;
	GST_RTSP_MEDIA_FACTORY_CLASS (klass)->gen_key = dvb_media_factory_real_gen_key;
	G_OBJECT_CLASS (klass)->constructor = dvb_media_factory_constructor;
	G_OBJECT_CLASS (klass)->finalize = dvb_media_factory_finalize;
	_tmp0_ = dvb_logging_log_manager_getLogManager ();
	_tmp1_ = dvb_logging_log_manager_getDefaultLogger (_tmp0_);
	dvb_media_factory_log = _tmp1_;
}


static void dvb_media_factory_instance_init (DVBMediaFactory * self) {
}


static void dvb_media_factory_finalize (GObject* obj) {
	DVBMediaFactory * self;
	self = DVB_MEDIA_FACTORY (obj);
	G_OBJECT_CLASS (dvb_media_factory_parent_class)->finalize (obj);
}


GType dvb_media_factory_get_type (void) {
	static volatile gsize dvb_media_factory_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_media_factory_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBMediaFactoryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_media_factory_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBMediaFactory), 0, (GInstanceInitFunc) dvb_media_factory_instance_init, NULL };
		GType dvb_media_factory_type_id;
		dvb_media_factory_type_id = g_type_register_static (GST_TYPE_RTSP_MEDIA_FACTORY, "DVBMediaFactory", &g_define_type_info, 0);
		g_once_init_leave (&dvb_media_factory_type_id__volatile, dvb_media_factory_type_id);
	}
	return dvb_media_factory_type_id__volatile;
}


DVBDVBMedia* dvb_dvb_media_construct (GType object_type, DVBDeviceGroup* group, DVBChannel* channel, GstElement* payloader) {
	DVBDVBMedia * self = NULL;
	DVBDeviceGroup* _tmp0_;
	DVBChannel* _tmp1_;
	GstElement* _tmp2_;
	g_return_val_if_fail (group != NULL, NULL);
	g_return_val_if_fail (channel != NULL, NULL);
	g_return_val_if_fail (payloader != NULL, NULL);
	self = (DVBDVBMedia*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (group);
	_g_object_unref0 (self->group);
	self->group = _tmp0_;
	_tmp1_ = _g_object_ref0 (channel);
	_g_object_unref0 (self->channel);
	self->channel = _tmp1_;
	_tmp2_ = _gst_object_ref0 (payloader);
	_gst_object_unref0 (self->payloader);
	self->payloader = _tmp2_;
	return self;
}


DVBDVBMedia* dvb_dvb_media_new (DVBDeviceGroup* group, DVBChannel* channel, GstElement* payloader) {
	return dvb_dvb_media_construct (DVB_TYPE_DVB_MEDIA, group, channel, payloader);
}


static gboolean dvb_dvb_media_real_unprepare (GstRTSPMedia* base) {
	DVBDVBMedia * self;
	gboolean result = FALSE;
	DVBChannelFactory* _tmp0_ = NULL;
	DVBChannelFactory* _tmp1_;
	DVBChannelFactory* channels_factory;
	self = (DVBDVBMedia*) base;
	gst_rtsp_media_remove_elements ((GstRTSPMedia*) self);
	_tmp0_ = dvb_device_group_get_channel_factory (self->group);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	channels_factory = _tmp1_;
	dvb_channel_factory_stop_channel (channels_factory, self->channel, self->payloader);
	result = TRUE;
	_g_object_unref0 (channels_factory);
	return result;
}


static void dvb_dvb_media_class_init (DVBDVBMediaClass * klass) {
	dvb_dvb_media_parent_class = g_type_class_peek_parent (klass);
	GST_RTSP_MEDIA_CLASS (klass)->unprepare = dvb_dvb_media_real_unprepare;
	G_OBJECT_CLASS (klass)->finalize = dvb_dvb_media_finalize;
}


static void dvb_dvb_media_instance_init (DVBDVBMedia * self) {
}


static void dvb_dvb_media_finalize (GObject* obj) {
	DVBDVBMedia * self;
	self = DVB_DVB_MEDIA (obj);
	_g_object_unref0 (self->group);
	_g_object_unref0 (self->channel);
	_gst_object_unref0 (self->payloader);
	G_OBJECT_CLASS (dvb_dvb_media_parent_class)->finalize (obj);
}


GType dvb_dvb_media_get_type (void) {
	static volatile gsize dvb_dvb_media_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_dvb_media_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBDVBMediaClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_dvb_media_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBDVBMedia), 0, (GInstanceInitFunc) dvb_dvb_media_instance_init, NULL };
		GType dvb_dvb_media_type_id;
		dvb_dvb_media_type_id = g_type_register_static (GST_TYPE_RTSP_MEDIA, "DVBDVBMedia", &g_define_type_info, 0);
		g_once_init_leave (&dvb_dvb_media_type_id__volatile, dvb_dvb_media_type_id);
	}
	return dvb_dvb_media_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



