/* SatelliteScanner.c generated by valac 0.12.0, the Vala compiler
 * generated from SatelliteScanner.vala, do not modify */

/*
 * Copyright (C) 2008-2010 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <gst/gst.h>
#include <gee.h>


#define DVB_TYPE_ID_BUS_SATELLITE_SCANNER (dvb_id_bus_satellite_scanner_get_type ())
#define DVB_ID_BUS_SATELLITE_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_ID_BUS_SATELLITE_SCANNER, DVBIDBusSatelliteScanner))
#define DVB_IS_ID_BUS_SATELLITE_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_ID_BUS_SATELLITE_SCANNER))
#define DVB_ID_BUS_SATELLITE_SCANNER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DVB_TYPE_ID_BUS_SATELLITE_SCANNER, DVBIDBusSatelliteScannerIface))

typedef struct _DVBIDBusSatelliteScanner DVBIDBusSatelliteScanner;
typedef struct _DVBIDBusSatelliteScannerIface DVBIDBusSatelliteScannerIface;

#define DVB_TYPE_ID_BUS_SATELLITE_SCANNER_PROXY (dvb_id_bus_satellite_scanner_proxy_get_type ())
typedef GDBusProxy DVBIDBusSatelliteScannerProxy;
typedef GDBusProxyClass DVBIDBusSatelliteScannerProxyClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define DVB_TYPE_SCANNER (dvb_scanner_get_type ())
#define DVB_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_SCANNER, DVBScanner))
#define DVB_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_SCANNER, DVBScannerClass))
#define DVB_IS_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_SCANNER))
#define DVB_IS_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_SCANNER))
#define DVB_SCANNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_SCANNER, DVBScannerClass))

typedef struct _DVBScanner DVBScanner;
typedef struct _DVBScannerClass DVBScannerClass;
typedef struct _DVBScannerPrivate DVBScannerPrivate;

#define DVB_TYPE_SCANNED_ITEM (dvb_scanned_item_get_type ())
#define DVB_SCANNED_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_SCANNED_ITEM, DVBScannedItem))
#define DVB_SCANNED_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_SCANNED_ITEM, DVBScannedItemClass))
#define DVB_IS_SCANNED_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_SCANNED_ITEM))
#define DVB_IS_SCANNED_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_SCANNED_ITEM))
#define DVB_SCANNED_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_SCANNED_ITEM, DVBScannedItemClass))

typedef struct _DVBScannedItem DVBScannedItem;
typedef struct _DVBScannedItemClass DVBScannedItemClass;

#define DVB_TYPE_CHANNEL (dvb_channel_get_type ())
#define DVB_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL, DVBChannel))
#define DVB_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL, DVBChannelClass))
#define DVB_IS_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL))
#define DVB_IS_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL))
#define DVB_CHANNEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL, DVBChannelClass))

typedef struct _DVBChannel DVBChannel;
typedef struct _DVBChannelClass DVBChannelClass;

#define DVB_TYPE_CHANNEL_LIST (dvb_channel_list_get_type ())
#define DVB_CHANNEL_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL_LIST, DVBChannelList))
#define DVB_CHANNEL_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL_LIST, DVBChannelListClass))
#define DVB_IS_CHANNEL_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL_LIST))
#define DVB_IS_CHANNEL_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL_LIST))
#define DVB_CHANNEL_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL_LIST, DVBChannelListClass))

typedef struct _DVBChannelList DVBChannelList;
typedef struct _DVBChannelListClass DVBChannelListClass;

#define DVB_TYPE_ID_BUS_SCANNER (dvb_id_bus_scanner_get_type ())
#define DVB_ID_BUS_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_ID_BUS_SCANNER, DVBIDBusScanner))
#define DVB_IS_ID_BUS_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_ID_BUS_SCANNER))
#define DVB_ID_BUS_SCANNER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DVB_TYPE_ID_BUS_SCANNER, DVBIDBusScannerIface))

typedef struct _DVBIDBusScanner DVBIDBusScanner;
typedef struct _DVBIDBusScannerIface DVBIDBusScannerIface;

#define DVB_TYPE_ID_BUS_SCANNER_PROXY (dvb_id_bus_scanner_proxy_get_type ())

#define DVB_TYPE_SATELLITE_SCANNER (dvb_satellite_scanner_get_type ())
#define DVB_SATELLITE_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_SATELLITE_SCANNER, DVBSatelliteScanner))
#define DVB_SATELLITE_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_SATELLITE_SCANNER, DVBSatelliteScannerClass))
#define DVB_IS_SATELLITE_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_SATELLITE_SCANNER))
#define DVB_IS_SATELLITE_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_SATELLITE_SCANNER))
#define DVB_SATELLITE_SCANNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_SATELLITE_SCANNER, DVBSatelliteScannerClass))

typedef struct _DVBSatelliteScanner DVBSatelliteScanner;
typedef struct _DVBSatelliteScannerClass DVBSatelliteScannerClass;
typedef struct _DVBSatelliteScannerPrivate DVBSatelliteScannerPrivate;

#define DVB_TYPE_DEVICE (dvb_device_get_type ())
#define DVB_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_DEVICE, DVBDevice))
#define DVB_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_DEVICE, DVBDeviceClass))
#define DVB_IS_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_DEVICE))
#define DVB_IS_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_DEVICE))
#define DVB_DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_DEVICE, DVBDeviceClass))

typedef struct _DVBDevice DVBDevice;
typedef struct _DVBDeviceClass DVBDeviceClass;
#define _gst_structure_free0(var) ((var == NULL) ? NULL : (var = (gst_structure_free (var), NULL)))
#define _gst_object_unref0(var) ((var == NULL) ? NULL : (var = (gst_object_unref (var), NULL)))

#define DVB_TYPE_SCANNED_SATTELITE_ITEM (dvb_scanned_sattelite_item_get_type ())
#define DVB_SCANNED_SATTELITE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_SCANNED_SATTELITE_ITEM, DVBScannedSatteliteItem))
#define DVB_SCANNED_SATTELITE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_SCANNED_SATTELITE_ITEM, DVBScannedSatteliteItemClass))
#define DVB_IS_SCANNED_SATTELITE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_SCANNED_SATTELITE_ITEM))
#define DVB_IS_SCANNED_SATTELITE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_SCANNED_SATTELITE_ITEM))
#define DVB_SCANNED_SATTELITE_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_SCANNED_SATTELITE_ITEM, DVBScannedSatteliteItemClass))

typedef struct _DVBScannedSatteliteItem DVBScannedSatteliteItem;
typedef struct _DVBScannedSatteliteItemClass DVBScannedSatteliteItemClass;

#define DVB_TYPE_SATELLITE_CHANNEL (dvb_satellite_channel_get_type ())
#define DVB_SATELLITE_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_SATELLITE_CHANNEL, DVBSatelliteChannel))
#define DVB_SATELLITE_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_SATELLITE_CHANNEL, DVBSatelliteChannelClass))
#define DVB_IS_SATELLITE_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_SATELLITE_CHANNEL))
#define DVB_IS_SATELLITE_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_SATELLITE_CHANNEL))
#define DVB_SATELLITE_CHANNEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_SATELLITE_CHANNEL, DVBSatelliteChannelClass))

typedef struct _DVBSatelliteChannel DVBSatelliteChannel;
typedef struct _DVBSatelliteChannelClass DVBSatelliteChannelClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _DVBIDBusSatelliteScannerIface {
	GTypeInterface parent_iface;
	void (*Run) (DVBIDBusSatelliteScanner* self, GError** error);
	void (*Destroy) (DVBIDBusSatelliteScanner* self, GError** error);
	gboolean (*WriteAllChannelsToFile) (DVBIDBusSatelliteScanner* self, const gchar* path, GError** error);
	gboolean (*WriteChannelsToFile) (DVBIDBusSatelliteScanner* self, guint* channel_sids, int channel_sids_length1, const gchar* path, GError** error);
	void (*AddScanningData) (DVBIDBusSatelliteScanner* self, guint frequency, const gchar* polarization, guint symbol_rate, GError** error);
	gboolean (*AddScanningDataFromFile) (DVBIDBusSatelliteScanner* self, const gchar* path, GError** error);
};

struct _DVBScanner {
	GObject parent_instance;
	DVBScannerPrivate * priv;
	DVBChannelList* channels;
	GstElement* pipeline;
	GQueue* frequencies;
	GstStructure* current_tuning_params;
	GeeHashSet* scanned_frequencies;
};

struct _DVBScannerClass {
	GObjectClass parent_class;
	void (*prepare) (DVBScanner* self);
	DVBScannedItem* (*get_scanned_item) (DVBScanner* self, const GstStructure* structure);
	DVBChannel* (*get_new_channel) (DVBScanner* self);
	void (*add_values_from_structure_to_channel) (DVBScanner* self, const GstStructure* delivery, DVBChannel* channel);
	void (*add_scanning_data_from_string) (DVBScanner* self, const gchar* line);
};

struct _DVBIDBusScannerIface {
	GTypeInterface parent_iface;
	void (*Run) (DVBIDBusScanner* self, GError** error);
	void (*Destroy) (DVBIDBusScanner* self, GError** error);
	gboolean (*WriteAllChannelsToFile) (DVBIDBusScanner* self, const gchar* path, GError** error);
	gboolean (*WriteChannelsToFile) (DVBIDBusScanner* self, guint* channel_sids, int channel_sids_length1, const gchar* path, GError** error);
	gboolean (*AddScanningData) (DVBIDBusScanner* self, GHashTable* data, GError** error);
	gboolean (*AddScanningDataFromFile) (DVBIDBusScanner* self, const gchar* path, GError** error);
};

struct _DVBSatelliteScanner {
	DVBScanner parent_instance;
	DVBSatelliteScannerPrivate * priv;
};

struct _DVBSatelliteScannerClass {
	DVBScannerClass parent_class;
};


static gpointer dvb_satellite_scanner_parent_class = NULL;
static DVBIDBusScannerIface* dvb_satellite_scanner_dvb_id_bus_scanner_parent_iface = NULL;

GType dvb_id_bus_satellite_scanner_proxy_get_type (void) G_GNUC_CONST;
guint dvb_id_bus_satellite_scanner_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType dvb_id_bus_satellite_scanner_get_type (void) G_GNUC_CONST;
void dvb_id_bus_satellite_scanner_Run (DVBIDBusSatelliteScanner* self, GError** error);
void dvb_id_bus_satellite_scanner_Destroy (DVBIDBusSatelliteScanner* self, GError** error);
gboolean dvb_id_bus_satellite_scanner_WriteAllChannelsToFile (DVBIDBusSatelliteScanner* self, const gchar* path, GError** error);
gboolean dvb_id_bus_satellite_scanner_WriteChannelsToFile (DVBIDBusSatelliteScanner* self, guint* channel_sids, int channel_sids_length1, const gchar* path, GError** error);
void dvb_id_bus_satellite_scanner_AddScanningData (DVBIDBusSatelliteScanner* self, guint frequency, const gchar* polarization, guint symbol_rate, GError** error);
gboolean dvb_id_bus_satellite_scanner_AddScanningDataFromFile (DVBIDBusSatelliteScanner* self, const gchar* path, GError** error);
static void g_cclosure_user_marshal_VOID__UINT_UINT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__UINT_UINT_STRING_STRING_STRING_BOOLEAN (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__DOUBLE_DOUBLE (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void dvb_id_bus_satellite_scanner_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters);
static void _dbus_handle_dvb_id_bus_satellite_scanner_frequency_scanned (DVBIDBusSatelliteScanner* self, GVariant* parameters);
static void _dbus_handle_dvb_id_bus_satellite_scanner_finished (DVBIDBusSatelliteScanner* self, GVariant* parameters);
static void _dbus_handle_dvb_id_bus_satellite_scanner_channel_added (DVBIDBusSatelliteScanner* self, GVariant* parameters);
static void _dbus_handle_dvb_id_bus_satellite_scanner_frontend_stats (DVBIDBusSatelliteScanner* self, GVariant* parameters);
static void dvb_id_bus_satellite_scanner_proxy_Run (DVBIDBusSatelliteScanner* self, GError** error);
static void dvb_id_bus_satellite_scanner_proxy_Destroy (DVBIDBusSatelliteScanner* self, GError** error);
static gboolean dvb_id_bus_satellite_scanner_proxy_WriteAllChannelsToFile (DVBIDBusSatelliteScanner* self, const gchar* path, GError** error);
static gboolean dvb_id_bus_satellite_scanner_proxy_WriteChannelsToFile (DVBIDBusSatelliteScanner* self, guint* channel_sids, int channel_sids_length1, const gchar* path, GError** error);
static void dvb_id_bus_satellite_scanner_proxy_AddScanningData (DVBIDBusSatelliteScanner* self, guint frequency, const gchar* polarization, guint symbol_rate, GError** error);
static gboolean dvb_id_bus_satellite_scanner_proxy_AddScanningDataFromFile (DVBIDBusSatelliteScanner* self, const gchar* path, GError** error);
static void dvb_id_bus_satellite_scanner_proxy_dvb_id_bus_satellite_scanner_interface_init (DVBIDBusSatelliteScannerIface* iface);
static void _dbus_dvb_id_bus_satellite_scanner_Run (DVBIDBusSatelliteScanner* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_dvb_id_bus_satellite_scanner_Destroy (DVBIDBusSatelliteScanner* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_dvb_id_bus_satellite_scanner_WriteAllChannelsToFile (DVBIDBusSatelliteScanner* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_dvb_id_bus_satellite_scanner_WriteChannelsToFile (DVBIDBusSatelliteScanner* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_dvb_id_bus_satellite_scanner_AddScanningData (DVBIDBusSatelliteScanner* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_dvb_id_bus_satellite_scanner_AddScanningDataFromFile (DVBIDBusSatelliteScanner* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void dvb_id_bus_satellite_scanner_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* dvb_id_bus_satellite_scanner_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static gboolean dvb_id_bus_satellite_scanner_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _dbus_dvb_id_bus_satellite_scanner_frequency_scanned (GObject* _sender, guint frequency, guint freq_left, gpointer* _data);
static void _dbus_dvb_id_bus_satellite_scanner_finished (GObject* _sender, gpointer* _data);
static void _dbus_dvb_id_bus_satellite_scanner_channel_added (GObject* _sender, guint frequency, guint sid, const gchar* name, const gchar* network, const gchar* type, gboolean scrambled, gpointer* _data);
static void _dbus_dvb_id_bus_satellite_scanner_frontend_stats (GObject* _sender, gdouble signal_strength, gdouble signal_noise_ratio, gpointer* _data);
static void _dvb_id_bus_satellite_scanner_unregister_object (gpointer user_data);
GType dvb_scanner_get_type (void) G_GNUC_CONST;
GType dvb_scanned_item_get_type (void) G_GNUC_CONST;
GType dvb_channel_get_type (void) G_GNUC_CONST;
GType dvb_channel_list_get_type (void) G_GNUC_CONST;
GType dvb_id_bus_scanner_proxy_get_type (void) G_GNUC_CONST;
guint dvb_id_bus_scanner_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType dvb_id_bus_scanner_get_type (void) G_GNUC_CONST;
GType dvb_satellite_scanner_get_type (void) G_GNUC_CONST;
enum  {
	DVB_SATELLITE_SCANNER_DUMMY_PROPERTY
};
GType dvb_device_get_type (void) G_GNUC_CONST;
DVBSatelliteScanner* dvb_satellite_scanner_new (DVBDevice* device);
DVBSatelliteScanner* dvb_satellite_scanner_construct (GType object_type, DVBDevice* device);
static gboolean dvb_satellite_scanner_real_AddScanningData (DVBIDBusScanner* base, GHashTable* data, GError** error);
static inline void dvb_satellite_scanner_add_scanning_data (DVBSatelliteScanner* self, guint frequency, const gchar* polarization, guint symbol_rate);
void dvb_scanner_add_structure_to_scan (DVBScanner* self, GstStructure* structure);
static void dvb_satellite_scanner_real_add_scanning_data_from_string (DVBScanner* base, const gchar* line);
static void dvb_satellite_scanner_real_prepare (DVBScanner* base);
void dvb_scanner_set_uint_property (GstElement* src, const GstStructure* params, const gchar* key);
static DVBScannedItem* dvb_satellite_scanner_real_get_scanned_item (DVBScanner* base, const GstStructure* structure);
DVBScannedSatteliteItem* dvb_scanned_sattelite_item_new (guint frequency, const gchar* polarization);
DVBScannedSatteliteItem* dvb_scanned_sattelite_item_construct (GType object_type, guint frequency, const gchar* polarization);
GType dvb_scanned_sattelite_item_get_type (void) G_GNUC_CONST;
static DVBChannel* dvb_satellite_scanner_real_get_new_channel (DVBScanner* base);
DVBSatelliteChannel* dvb_satellite_channel_new_without_schedule (void);
DVBSatelliteChannel* dvb_satellite_channel_construct_without_schedule (GType object_type);
GType dvb_satellite_channel_get_type (void) G_GNUC_CONST;
static void dvb_satellite_scanner_real_add_values_from_structure_to_channel (DVBScanner* base, const GstStructure* delivery, DVBChannel* channel);
void dvb_channel_set_Frequency (DVBChannel* self, guint value);
void dvb_satellite_channel_set_Polarization (DVBSatelliteChannel* self, const gchar* value);
void dvb_satellite_channel_set_SymbolRate (DVBSatelliteChannel* self, guint value);
void dvb_satellite_channel_set_DiseqcSource (DVBSatelliteChannel* self, gint value);
void dvb_scanner_Run (DVBScanner* self, GError** error);
void dvb_scanner_Destroy (DVBScanner* self, GError** error);
gboolean dvb_scanner_WriteAllChannelsToFile (DVBScanner* self, const gchar* path, GError** error);
gboolean dvb_scanner_WriteChannelsToFile (DVBScanner* self, guint* channel_sids, int channel_sids_length1, const gchar* path, GError** error);
gboolean dvb_scanner_AddScanningDataFromFile (DVBScanner* self, const gchar* path, GError** error);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const GDBusArgInfo * const _dvb_id_bus_satellite_scanner_dbus_arg_info_Run_in[] = {NULL};
static const GDBusArgInfo * const _dvb_id_bus_satellite_scanner_dbus_arg_info_Run_out[] = {NULL};
static const GDBusMethodInfo _dvb_id_bus_satellite_scanner_dbus_method_info_Run = {-1, "Run", (GDBusArgInfo **) (&_dvb_id_bus_satellite_scanner_dbus_arg_info_Run_in), (GDBusArgInfo **) (&_dvb_id_bus_satellite_scanner_dbus_arg_info_Run_out)};
static const GDBusArgInfo * const _dvb_id_bus_satellite_scanner_dbus_arg_info_Destroy_in[] = {NULL};
static const GDBusArgInfo * const _dvb_id_bus_satellite_scanner_dbus_arg_info_Destroy_out[] = {NULL};
static const GDBusMethodInfo _dvb_id_bus_satellite_scanner_dbus_method_info_Destroy = {-1, "Destroy", (GDBusArgInfo **) (&_dvb_id_bus_satellite_scanner_dbus_arg_info_Destroy_in), (GDBusArgInfo **) (&_dvb_id_bus_satellite_scanner_dbus_arg_info_Destroy_out)};
static const GDBusArgInfo _dvb_id_bus_satellite_scanner_dbus_arg_info_WriteAllChannelsToFile_path = {-1, "path", "s"};
static const GDBusArgInfo _dvb_id_bus_satellite_scanner_dbus_arg_info_WriteAllChannelsToFile_result = {-1, "result", "b"};
static const GDBusArgInfo * const _dvb_id_bus_satellite_scanner_dbus_arg_info_WriteAllChannelsToFile_in[] = {&_dvb_id_bus_satellite_scanner_dbus_arg_info_WriteAllChannelsToFile_path, NULL};
static const GDBusArgInfo * const _dvb_id_bus_satellite_scanner_dbus_arg_info_WriteAllChannelsToFile_out[] = {&_dvb_id_bus_satellite_scanner_dbus_arg_info_WriteAllChannelsToFile_result, NULL};
static const GDBusMethodInfo _dvb_id_bus_satellite_scanner_dbus_method_info_WriteAllChannelsToFile = {-1, "WriteAllChannelsToFile", (GDBusArgInfo **) (&_dvb_id_bus_satellite_scanner_dbus_arg_info_WriteAllChannelsToFile_in), (GDBusArgInfo **) (&_dvb_id_bus_satellite_scanner_dbus_arg_info_WriteAllChannelsToFile_out)};
static const GDBusArgInfo _dvb_id_bus_satellite_scanner_dbus_arg_info_WriteChannelsToFile_channel_sids = {-1, "channel_sids", "au"};
static const GDBusArgInfo _dvb_id_bus_satellite_scanner_dbus_arg_info_WriteChannelsToFile_path = {-1, "path", "s"};
static const GDBusArgInfo _dvb_id_bus_satellite_scanner_dbus_arg_info_WriteChannelsToFile_result = {-1, "result", "b"};
static const GDBusArgInfo * const _dvb_id_bus_satellite_scanner_dbus_arg_info_WriteChannelsToFile_in[] = {&_dvb_id_bus_satellite_scanner_dbus_arg_info_WriteChannelsToFile_channel_sids, &_dvb_id_bus_satellite_scanner_dbus_arg_info_WriteChannelsToFile_path, NULL};
static const GDBusArgInfo * const _dvb_id_bus_satellite_scanner_dbus_arg_info_WriteChannelsToFile_out[] = {&_dvb_id_bus_satellite_scanner_dbus_arg_info_WriteChannelsToFile_result, NULL};
static const GDBusMethodInfo _dvb_id_bus_satellite_scanner_dbus_method_info_WriteChannelsToFile = {-1, "WriteChannelsToFile", (GDBusArgInfo **) (&_dvb_id_bus_satellite_scanner_dbus_arg_info_WriteChannelsToFile_in), (GDBusArgInfo **) (&_dvb_id_bus_satellite_scanner_dbus_arg_info_WriteChannelsToFile_out)};
static const GDBusArgInfo _dvb_id_bus_satellite_scanner_dbus_arg_info_AddScanningData_frequency = {-1, "frequency", "u"};
static const GDBusArgInfo _dvb_id_bus_satellite_scanner_dbus_arg_info_AddScanningData_polarization = {-1, "polarization", "s"};
static const GDBusArgInfo _dvb_id_bus_satellite_scanner_dbus_arg_info_AddScanningData_symbol_rate = {-1, "symbol_rate", "u"};
static const GDBusArgInfo * const _dvb_id_bus_satellite_scanner_dbus_arg_info_AddScanningData_in[] = {&_dvb_id_bus_satellite_scanner_dbus_arg_info_AddScanningData_frequency, &_dvb_id_bus_satellite_scanner_dbus_arg_info_AddScanningData_polarization, &_dvb_id_bus_satellite_scanner_dbus_arg_info_AddScanningData_symbol_rate, NULL};
static const GDBusArgInfo * const _dvb_id_bus_satellite_scanner_dbus_arg_info_AddScanningData_out[] = {NULL};
static const GDBusMethodInfo _dvb_id_bus_satellite_scanner_dbus_method_info_AddScanningData = {-1, "AddScanningData", (GDBusArgInfo **) (&_dvb_id_bus_satellite_scanner_dbus_arg_info_AddScanningData_in), (GDBusArgInfo **) (&_dvb_id_bus_satellite_scanner_dbus_arg_info_AddScanningData_out)};
static const GDBusArgInfo _dvb_id_bus_satellite_scanner_dbus_arg_info_AddScanningDataFromFile_path = {-1, "path", "s"};
static const GDBusArgInfo _dvb_id_bus_satellite_scanner_dbus_arg_info_AddScanningDataFromFile_result = {-1, "result", "b"};
static const GDBusArgInfo * const _dvb_id_bus_satellite_scanner_dbus_arg_info_AddScanningDataFromFile_in[] = {&_dvb_id_bus_satellite_scanner_dbus_arg_info_AddScanningDataFromFile_path, NULL};
static const GDBusArgInfo * const _dvb_id_bus_satellite_scanner_dbus_arg_info_AddScanningDataFromFile_out[] = {&_dvb_id_bus_satellite_scanner_dbus_arg_info_AddScanningDataFromFile_result, NULL};
static const GDBusMethodInfo _dvb_id_bus_satellite_scanner_dbus_method_info_AddScanningDataFromFile = {-1, "AddScanningDataFromFile", (GDBusArgInfo **) (&_dvb_id_bus_satellite_scanner_dbus_arg_info_AddScanningDataFromFile_in), (GDBusArgInfo **) (&_dvb_id_bus_satellite_scanner_dbus_arg_info_AddScanningDataFromFile_out)};
static const GDBusMethodInfo * const _dvb_id_bus_satellite_scanner_dbus_method_info[] = {&_dvb_id_bus_satellite_scanner_dbus_method_info_Run, &_dvb_id_bus_satellite_scanner_dbus_method_info_Destroy, &_dvb_id_bus_satellite_scanner_dbus_method_info_WriteAllChannelsToFile, &_dvb_id_bus_satellite_scanner_dbus_method_info_WriteChannelsToFile, &_dvb_id_bus_satellite_scanner_dbus_method_info_AddScanningData, &_dvb_id_bus_satellite_scanner_dbus_method_info_AddScanningDataFromFile, NULL};
static const GDBusArgInfo _dvb_id_bus_satellite_scanner_dbus_arg_info_frequency_scanned_frequency = {-1, "frequency", "u"};
static const GDBusArgInfo _dvb_id_bus_satellite_scanner_dbus_arg_info_frequency_scanned_freq_left = {-1, "freq_left", "u"};
static const GDBusArgInfo * const _dvb_id_bus_satellite_scanner_dbus_arg_info_frequency_scanned[] = {&_dvb_id_bus_satellite_scanner_dbus_arg_info_frequency_scanned_frequency, &_dvb_id_bus_satellite_scanner_dbus_arg_info_frequency_scanned_freq_left, NULL};
static const GDBusSignalInfo _dvb_id_bus_satellite_scanner_dbus_signal_info_frequency_scanned = {-1, "FrequencyScanned", (GDBusArgInfo **) (&_dvb_id_bus_satellite_scanner_dbus_arg_info_frequency_scanned)};
static const GDBusArgInfo * const _dvb_id_bus_satellite_scanner_dbus_arg_info_finished[] = {NULL};
static const GDBusSignalInfo _dvb_id_bus_satellite_scanner_dbus_signal_info_finished = {-1, "Finished", (GDBusArgInfo **) (&_dvb_id_bus_satellite_scanner_dbus_arg_info_finished)};
static const GDBusArgInfo _dvb_id_bus_satellite_scanner_dbus_arg_info_channel_added_frequency = {-1, "frequency", "u"};
static const GDBusArgInfo _dvb_id_bus_satellite_scanner_dbus_arg_info_channel_added_sid = {-1, "sid", "u"};
static const GDBusArgInfo _dvb_id_bus_satellite_scanner_dbus_arg_info_channel_added_name = {-1, "name", "s"};
static const GDBusArgInfo _dvb_id_bus_satellite_scanner_dbus_arg_info_channel_added_network = {-1, "network", "s"};
static const GDBusArgInfo _dvb_id_bus_satellite_scanner_dbus_arg_info_channel_added_type = {-1, "type", "s"};
static const GDBusArgInfo _dvb_id_bus_satellite_scanner_dbus_arg_info_channel_added_scrambled = {-1, "scrambled", "b"};
static const GDBusArgInfo * const _dvb_id_bus_satellite_scanner_dbus_arg_info_channel_added[] = {&_dvb_id_bus_satellite_scanner_dbus_arg_info_channel_added_frequency, &_dvb_id_bus_satellite_scanner_dbus_arg_info_channel_added_sid, &_dvb_id_bus_satellite_scanner_dbus_arg_info_channel_added_name, &_dvb_id_bus_satellite_scanner_dbus_arg_info_channel_added_network, &_dvb_id_bus_satellite_scanner_dbus_arg_info_channel_added_type, &_dvb_id_bus_satellite_scanner_dbus_arg_info_channel_added_scrambled, NULL};
static const GDBusSignalInfo _dvb_id_bus_satellite_scanner_dbus_signal_info_channel_added = {-1, "ChannelAdded", (GDBusArgInfo **) (&_dvb_id_bus_satellite_scanner_dbus_arg_info_channel_added)};
static const GDBusArgInfo _dvb_id_bus_satellite_scanner_dbus_arg_info_frontend_stats_signal_strength = {-1, "signal_strength", "d"};
static const GDBusArgInfo _dvb_id_bus_satellite_scanner_dbus_arg_info_frontend_stats_signal_noise_ratio = {-1, "signal_noise_ratio", "d"};
static const GDBusArgInfo * const _dvb_id_bus_satellite_scanner_dbus_arg_info_frontend_stats[] = {&_dvb_id_bus_satellite_scanner_dbus_arg_info_frontend_stats_signal_strength, &_dvb_id_bus_satellite_scanner_dbus_arg_info_frontend_stats_signal_noise_ratio, NULL};
static const GDBusSignalInfo _dvb_id_bus_satellite_scanner_dbus_signal_info_frontend_stats = {-1, "FrontendStats", (GDBusArgInfo **) (&_dvb_id_bus_satellite_scanner_dbus_arg_info_frontend_stats)};
static const GDBusSignalInfo * const _dvb_id_bus_satellite_scanner_dbus_signal_info[] = {&_dvb_id_bus_satellite_scanner_dbus_signal_info_frequency_scanned, &_dvb_id_bus_satellite_scanner_dbus_signal_info_finished, &_dvb_id_bus_satellite_scanner_dbus_signal_info_channel_added, &_dvb_id_bus_satellite_scanner_dbus_signal_info_frontend_stats, NULL};
static const GDBusPropertyInfo * const _dvb_id_bus_satellite_scanner_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _dvb_id_bus_satellite_scanner_dbus_interface_info = {-1, "org.gnome.DVB.Scanner.Satellite", (GDBusMethodInfo **) (&_dvb_id_bus_satellite_scanner_dbus_method_info), (GDBusSignalInfo **) (&_dvb_id_bus_satellite_scanner_dbus_signal_info), (GDBusPropertyInfo **) (&_dvb_id_bus_satellite_scanner_dbus_property_info)};
static const GDBusInterfaceVTable _dvb_id_bus_satellite_scanner_dbus_interface_vtable = {dvb_id_bus_satellite_scanner_dbus_interface_method_call, dvb_id_bus_satellite_scanner_dbus_interface_get_property, dvb_id_bus_satellite_scanner_dbus_interface_set_property};

void dvb_id_bus_satellite_scanner_Run (DVBIDBusSatelliteScanner* self, GError** error) {
	DVB_ID_BUS_SATELLITE_SCANNER_GET_INTERFACE (self)->Run (self, error);
}


void dvb_id_bus_satellite_scanner_Destroy (DVBIDBusSatelliteScanner* self, GError** error) {
	DVB_ID_BUS_SATELLITE_SCANNER_GET_INTERFACE (self)->Destroy (self, error);
}


gboolean dvb_id_bus_satellite_scanner_WriteAllChannelsToFile (DVBIDBusSatelliteScanner* self, const gchar* path, GError** error) {
	return DVB_ID_BUS_SATELLITE_SCANNER_GET_INTERFACE (self)->WriteAllChannelsToFile (self, path, error);
}


gboolean dvb_id_bus_satellite_scanner_WriteChannelsToFile (DVBIDBusSatelliteScanner* self, guint* channel_sids, int channel_sids_length1, const gchar* path, GError** error) {
	return DVB_ID_BUS_SATELLITE_SCANNER_GET_INTERFACE (self)->WriteChannelsToFile (self, channel_sids, channel_sids_length1, path, error);
}


void dvb_id_bus_satellite_scanner_AddScanningData (DVBIDBusSatelliteScanner* self, guint frequency, const gchar* polarization, guint symbol_rate, GError** error) {
	DVB_ID_BUS_SATELLITE_SCANNER_GET_INTERFACE (self)->AddScanningData (self, frequency, polarization, symbol_rate, error);
}


/**
         * @path: Path to file containing scanning data
         * @returns: TRUE when the file has been parsed successfully
         *
         * Parses initial tuning data from a file as provided by dvb-apps
         */
gboolean dvb_id_bus_satellite_scanner_AddScanningDataFromFile (DVBIDBusSatelliteScanner* self, const gchar* path, GError** error) {
	return DVB_ID_BUS_SATELLITE_SCANNER_GET_INTERFACE (self)->AddScanningDataFromFile (self, path, error);
}


static void g_cclosure_user_marshal_VOID__UINT_UINT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__UINT_UINT) (gpointer data1, guint arg_1, guint arg_2, gpointer data2);
	register GMarshalFunc_VOID__UINT_UINT callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__UINT_UINT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_uint (param_values + 1), g_value_get_uint (param_values + 2), data2);
}


static void g_cclosure_user_marshal_VOID__UINT_UINT_STRING_STRING_STRING_BOOLEAN (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__UINT_UINT_STRING_STRING_STRING_BOOLEAN) (gpointer data1, guint arg_1, guint arg_2, const char* arg_3, const char* arg_4, const char* arg_5, gboolean arg_6, gpointer data2);
	register GMarshalFunc_VOID__UINT_UINT_STRING_STRING_STRING_BOOLEAN callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 7);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__UINT_UINT_STRING_STRING_STRING_BOOLEAN) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_uint (param_values + 1), g_value_get_uint (param_values + 2), g_value_get_string (param_values + 3), g_value_get_string (param_values + 4), g_value_get_string (param_values + 5), g_value_get_boolean (param_values + 6), data2);
}


static void g_cclosure_user_marshal_VOID__DOUBLE_DOUBLE (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__DOUBLE_DOUBLE) (gpointer data1, gdouble arg_1, gdouble arg_2, gpointer data2);
	register GMarshalFunc_VOID__DOUBLE_DOUBLE callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__DOUBLE_DOUBLE) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_double (param_values + 1), g_value_get_double (param_values + 2), data2);
}


static void dvb_id_bus_satellite_scanner_base_init (DVBIDBusSatelliteScannerIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_signal_new ("frequency_scanned", DVB_TYPE_ID_BUS_SATELLITE_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__UINT_UINT, G_TYPE_NONE, 2, G_TYPE_UINT, G_TYPE_UINT);
		g_signal_new ("finished", DVB_TYPE_ID_BUS_SATELLITE_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
		g_signal_new ("channel_added", DVB_TYPE_ID_BUS_SATELLITE_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__UINT_UINT_STRING_STRING_STRING_BOOLEAN, G_TYPE_NONE, 6, G_TYPE_UINT, G_TYPE_UINT, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_BOOLEAN);
		g_signal_new ("frontend_stats", DVB_TYPE_ID_BUS_SATELLITE_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__DOUBLE_DOUBLE, G_TYPE_NONE, 2, G_TYPE_DOUBLE, G_TYPE_DOUBLE);
	}
}


GType dvb_id_bus_satellite_scanner_get_type (void) {
	static volatile gsize dvb_id_bus_satellite_scanner_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_id_bus_satellite_scanner_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBIDBusSatelliteScannerIface), (GBaseInitFunc) dvb_id_bus_satellite_scanner_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType dvb_id_bus_satellite_scanner_type_id;
		dvb_id_bus_satellite_scanner_type_id = g_type_register_static (G_TYPE_INTERFACE, "DVBIDBusSatelliteScanner", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (dvb_id_bus_satellite_scanner_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (dvb_id_bus_satellite_scanner_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) dvb_id_bus_satellite_scanner_proxy_get_type);
		g_type_set_qdata (dvb_id_bus_satellite_scanner_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.gnome.DVB.Scanner.Satellite");
		g_type_set_qdata (dvb_id_bus_satellite_scanner_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) dvb_id_bus_satellite_scanner_register_object);
		g_once_init_leave (&dvb_id_bus_satellite_scanner_type_id__volatile, dvb_id_bus_satellite_scanner_type_id);
	}
	return dvb_id_bus_satellite_scanner_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (DVBIDBusSatelliteScannerProxy, dvb_id_bus_satellite_scanner_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (DVB_TYPE_ID_BUS_SATELLITE_SCANNER, dvb_id_bus_satellite_scanner_proxy_dvb_id_bus_satellite_scanner_interface_init) )
static void dvb_id_bus_satellite_scanner_proxy_class_init (DVBIDBusSatelliteScannerProxyClass* klass) {
	G_DBUS_PROXY_CLASS (klass)->g_signal = dvb_id_bus_satellite_scanner_proxy_g_signal;
}


static void _dbus_handle_dvb_id_bus_satellite_scanner_frequency_scanned (DVBIDBusSatelliteScanner* self, GVariant* parameters) {
	GVariantIter _arguments_iter;
	guint frequency = 0U;
	GVariant* _tmp0_;
	guint freq_left = 0U;
	GVariant* _tmp1_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp0_ = g_variant_iter_next_value (&_arguments_iter);
	frequency = g_variant_get_uint32 (_tmp0_);
	g_variant_unref (_tmp0_);
	_tmp1_ = g_variant_iter_next_value (&_arguments_iter);
	freq_left = g_variant_get_uint32 (_tmp1_);
	g_variant_unref (_tmp1_);
	g_signal_emit_by_name (self, "frequency-scanned", frequency, freq_left);
}


static void _dbus_handle_dvb_id_bus_satellite_scanner_finished (DVBIDBusSatelliteScanner* self, GVariant* parameters) {
	GVariantIter _arguments_iter;
	g_variant_iter_init (&_arguments_iter, parameters);
	g_signal_emit_by_name (self, "finished");
}


static void _dbus_handle_dvb_id_bus_satellite_scanner_channel_added (DVBIDBusSatelliteScanner* self, GVariant* parameters) {
	GVariantIter _arguments_iter;
	guint frequency = 0U;
	GVariant* _tmp2_;
	guint sid = 0U;
	GVariant* _tmp3_;
	gchar* name = NULL;
	GVariant* _tmp4_;
	gchar* network = NULL;
	GVariant* _tmp5_;
	gchar* type = NULL;
	GVariant* _tmp6_;
	gboolean scrambled = FALSE;
	GVariant* _tmp7_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp2_ = g_variant_iter_next_value (&_arguments_iter);
	frequency = g_variant_get_uint32 (_tmp2_);
	g_variant_unref (_tmp2_);
	_tmp3_ = g_variant_iter_next_value (&_arguments_iter);
	sid = g_variant_get_uint32 (_tmp3_);
	g_variant_unref (_tmp3_);
	_tmp4_ = g_variant_iter_next_value (&_arguments_iter);
	name = g_variant_dup_string (_tmp4_, NULL);
	g_variant_unref (_tmp4_);
	_tmp5_ = g_variant_iter_next_value (&_arguments_iter);
	network = g_variant_dup_string (_tmp5_, NULL);
	g_variant_unref (_tmp5_);
	_tmp6_ = g_variant_iter_next_value (&_arguments_iter);
	type = g_variant_dup_string (_tmp6_, NULL);
	g_variant_unref (_tmp6_);
	_tmp7_ = g_variant_iter_next_value (&_arguments_iter);
	scrambled = g_variant_get_boolean (_tmp7_);
	g_variant_unref (_tmp7_);
	g_signal_emit_by_name (self, "channel-added", frequency, sid, name, network, type, scrambled);
	_g_free0 (name);
	_g_free0 (network);
	_g_free0 (type);
}


static void _dbus_handle_dvb_id_bus_satellite_scanner_frontend_stats (DVBIDBusSatelliteScanner* self, GVariant* parameters) {
	GVariantIter _arguments_iter;
	gdouble signal_strength = 0.0;
	GVariant* _tmp8_;
	gdouble signal_noise_ratio = 0.0;
	GVariant* _tmp9_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp8_ = g_variant_iter_next_value (&_arguments_iter);
	signal_strength = g_variant_get_double (_tmp8_);
	g_variant_unref (_tmp8_);
	_tmp9_ = g_variant_iter_next_value (&_arguments_iter);
	signal_noise_ratio = g_variant_get_double (_tmp9_);
	g_variant_unref (_tmp9_);
	g_signal_emit_by_name (self, "frontend-stats", signal_strength, signal_noise_ratio);
}


static void dvb_id_bus_satellite_scanner_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters) {
	if (strcmp (signal_name, "FrequencyScanned") == 0) {
		_dbus_handle_dvb_id_bus_satellite_scanner_frequency_scanned ((DVBIDBusSatelliteScanner*) proxy, parameters);
	} else if (strcmp (signal_name, "Finished") == 0) {
		_dbus_handle_dvb_id_bus_satellite_scanner_finished ((DVBIDBusSatelliteScanner*) proxy, parameters);
	} else if (strcmp (signal_name, "ChannelAdded") == 0) {
		_dbus_handle_dvb_id_bus_satellite_scanner_channel_added ((DVBIDBusSatelliteScanner*) proxy, parameters);
	} else if (strcmp (signal_name, "FrontendStats") == 0) {
		_dbus_handle_dvb_id_bus_satellite_scanner_frontend_stats ((DVBIDBusSatelliteScanner*) proxy, parameters);
	}
}


static void dvb_id_bus_satellite_scanner_proxy_init (DVBIDBusSatelliteScannerProxy* self) {
}


static void dvb_id_bus_satellite_scanner_proxy_Run (DVBIDBusSatelliteScanner* self, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	G_DBUS_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.DVB.Scanner.Satellite", "Run");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}


static void dvb_id_bus_satellite_scanner_proxy_Destroy (DVBIDBusSatelliteScanner* self, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	G_DBUS_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.DVB.Scanner.Satellite", "Destroy");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}


static gboolean dvb_id_bus_satellite_scanner_proxy_WriteAllChannelsToFile (DVBIDBusSatelliteScanner* self, const gchar* path, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gboolean _result;
	GVariant* _tmp10_;
	G_DBUS_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.DVB.Scanner.Satellite", "WriteAllChannelsToFile");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (path));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return FALSE;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return FALSE;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp10_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_get_boolean (_tmp10_);
	g_variant_unref (_tmp10_);
	g_object_unref (_reply_message);
	return _result;
}


static gboolean dvb_id_bus_satellite_scanner_proxy_WriteChannelsToFile (DVBIDBusSatelliteScanner* self, guint* channel_sids, int channel_sids_length1, const gchar* path, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	guint* _tmp11_;
	GVariantBuilder _tmp12_;
	int _tmp13_;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gboolean _result;
	GVariant* _tmp14_;
	G_DBUS_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.DVB.Scanner.Satellite", "WriteChannelsToFile");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_tmp11_ = channel_sids;
	g_variant_builder_init (&_tmp12_, G_VARIANT_TYPE ("au"));
	for (_tmp13_ = 0; _tmp13_ < channel_sids_length1; _tmp13_++) {
		g_variant_builder_add_value (&_tmp12_, g_variant_new_uint32 (*_tmp11_));
		_tmp11_++;
	}
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp12_));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (path));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return FALSE;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return FALSE;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp14_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_get_boolean (_tmp14_);
	g_variant_unref (_tmp14_);
	g_object_unref (_reply_message);
	return _result;
}


static void dvb_id_bus_satellite_scanner_proxy_AddScanningData (DVBIDBusSatelliteScanner* self, guint frequency, const gchar* polarization, guint symbol_rate, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	G_DBUS_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.DVB.Scanner.Satellite", "AddScanningData");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (frequency));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (polarization));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (symbol_rate));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}


static gboolean dvb_id_bus_satellite_scanner_proxy_AddScanningDataFromFile (DVBIDBusSatelliteScanner* self, const gchar* path, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gboolean _result;
	GVariant* _tmp15_;
	G_DBUS_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.DVB.Scanner.Satellite", "AddScanningDataFromFile");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (path));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return FALSE;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return FALSE;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp15_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_get_boolean (_tmp15_);
	g_variant_unref (_tmp15_);
	g_object_unref (_reply_message);
	return _result;
}


static void dvb_id_bus_satellite_scanner_proxy_dvb_id_bus_satellite_scanner_interface_init (DVBIDBusSatelliteScannerIface* iface) {
	iface->Run = dvb_id_bus_satellite_scanner_proxy_Run;
	iface->Destroy = dvb_id_bus_satellite_scanner_proxy_Destroy;
	iface->WriteAllChannelsToFile = dvb_id_bus_satellite_scanner_proxy_WriteAllChannelsToFile;
	iface->WriteChannelsToFile = dvb_id_bus_satellite_scanner_proxy_WriteChannelsToFile;
	iface->AddScanningData = dvb_id_bus_satellite_scanner_proxy_AddScanningData;
	iface->AddScanningDataFromFile = dvb_id_bus_satellite_scanner_proxy_AddScanningDataFromFile;
}


static void _dbus_dvb_id_bus_satellite_scanner_Run (DVBIDBusSatelliteScanner* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, parameters);
	dvb_id_bus_satellite_scanner_Run (self, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_dvb_id_bus_satellite_scanner_Destroy (DVBIDBusSatelliteScanner* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, parameters);
	dvb_id_bus_satellite_scanner_Destroy (self, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_dvb_id_bus_satellite_scanner_WriteAllChannelsToFile (DVBIDBusSatelliteScanner* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* path = NULL;
	GVariant* _tmp16_;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gboolean result;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp16_ = g_variant_iter_next_value (&_arguments_iter);
	path = g_variant_dup_string (_tmp16_, NULL);
	g_variant_unref (_tmp16_);
	result = dvb_id_bus_satellite_scanner_WriteAllChannelsToFile (self, path, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_boolean (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	_g_free0 (path);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_dvb_id_bus_satellite_scanner_WriteChannelsToFile (DVBIDBusSatelliteScanner* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	guint* channel_sids = NULL;
	int channel_sids_length1 = 0;
	GVariant* _tmp17_;
	guint* _tmp18_;
	int _tmp18__length;
	int _tmp18__size;
	int _tmp18__length1;
	GVariantIter _tmp19_;
	GVariant* _tmp20_;
	gchar* path = NULL;
	GVariant* _tmp21_;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gboolean result;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp17_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp18_ = g_new (guint, 5);
	_tmp18__length = 0;
	_tmp18__size = 4;
	_tmp18__length1 = 0;
	g_variant_iter_init (&_tmp19_, _tmp17_);
	for (; (_tmp20_ = g_variant_iter_next_value (&_tmp19_)) != NULL; _tmp18__length1++) {
		if (_tmp18__size == _tmp18__length) {
			_tmp18__size = 2 * _tmp18__size;
			_tmp18_ = g_renew (guint, _tmp18_, _tmp18__size + 1);
		}
		_tmp18_[_tmp18__length++] = g_variant_get_uint32 (_tmp20_);
		g_variant_unref (_tmp20_);
	}
	channel_sids_length1 = _tmp18__length1;
	channel_sids = _tmp18_;
	g_variant_unref (_tmp17_);
	_tmp21_ = g_variant_iter_next_value (&_arguments_iter);
	path = g_variant_dup_string (_tmp21_, NULL);
	g_variant_unref (_tmp21_);
	result = dvb_id_bus_satellite_scanner_WriteChannelsToFile (self, channel_sids, channel_sids_length1, path, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_boolean (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	channel_sids = (g_free (channel_sids), NULL);
	_g_free0 (path);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_dvb_id_bus_satellite_scanner_AddScanningData (DVBIDBusSatelliteScanner* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	guint frequency = 0U;
	GVariant* _tmp22_;
	gchar* polarization = NULL;
	GVariant* _tmp23_;
	guint symbol_rate = 0U;
	GVariant* _tmp24_;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp22_ = g_variant_iter_next_value (&_arguments_iter);
	frequency = g_variant_get_uint32 (_tmp22_);
	g_variant_unref (_tmp22_);
	_tmp23_ = g_variant_iter_next_value (&_arguments_iter);
	polarization = g_variant_dup_string (_tmp23_, NULL);
	g_variant_unref (_tmp23_);
	_tmp24_ = g_variant_iter_next_value (&_arguments_iter);
	symbol_rate = g_variant_get_uint32 (_tmp24_);
	g_variant_unref (_tmp24_);
	dvb_id_bus_satellite_scanner_AddScanningData (self, frequency, polarization, symbol_rate, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	_g_free0 (polarization);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_dvb_id_bus_satellite_scanner_AddScanningDataFromFile (DVBIDBusSatelliteScanner* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* path = NULL;
	GVariant* _tmp25_;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gboolean result;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp25_ = g_variant_iter_next_value (&_arguments_iter);
	path = g_variant_dup_string (_tmp25_, NULL);
	g_variant_unref (_tmp25_);
	result = dvb_id_bus_satellite_scanner_AddScanningDataFromFile (self, path, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_boolean (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	_g_free0 (path);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void dvb_id_bus_satellite_scanner_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "Run") == 0) {
		_dbus_dvb_id_bus_satellite_scanner_Run (object, parameters, invocation);
	} else if (strcmp (method_name, "Destroy") == 0) {
		_dbus_dvb_id_bus_satellite_scanner_Destroy (object, parameters, invocation);
	} else if (strcmp (method_name, "WriteAllChannelsToFile") == 0) {
		_dbus_dvb_id_bus_satellite_scanner_WriteAllChannelsToFile (object, parameters, invocation);
	} else if (strcmp (method_name, "WriteChannelsToFile") == 0) {
		_dbus_dvb_id_bus_satellite_scanner_WriteChannelsToFile (object, parameters, invocation);
	} else if (strcmp (method_name, "AddScanningData") == 0) {
		_dbus_dvb_id_bus_satellite_scanner_AddScanningData (object, parameters, invocation);
	} else if (strcmp (method_name, "AddScanningDataFromFile") == 0) {
		_dbus_dvb_id_bus_satellite_scanner_AddScanningDataFromFile (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}


static GVariant* dvb_id_bus_satellite_scanner_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}


static gboolean dvb_id_bus_satellite_scanner_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}


static void _dbus_dvb_id_bus_satellite_scanner_frequency_scanned (GObject* _sender, guint frequency, guint freq_left, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (frequency));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (freq_left));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.gnome.DVB.Scanner.Satellite", "FrequencyScanned", _arguments, NULL);
}


static void _dbus_dvb_id_bus_satellite_scanner_finished (GObject* _sender, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.gnome.DVB.Scanner.Satellite", "Finished", _arguments, NULL);
}


static void _dbus_dvb_id_bus_satellite_scanner_channel_added (GObject* _sender, guint frequency, guint sid, const gchar* name, const gchar* network, const gchar* type, gboolean scrambled, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (frequency));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (sid));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (name));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (network));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (type));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_boolean (scrambled));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.gnome.DVB.Scanner.Satellite", "ChannelAdded", _arguments, NULL);
}


static void _dbus_dvb_id_bus_satellite_scanner_frontend_stats (GObject* _sender, gdouble signal_strength, gdouble signal_noise_ratio, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_double (signal_strength));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_double (signal_noise_ratio));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.gnome.DVB.Scanner.Satellite", "FrontendStats", _arguments, NULL);
}


guint dvb_id_bus_satellite_scanner_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_dvb_id_bus_satellite_scanner_dbus_interface_info), &_dvb_id_bus_satellite_scanner_dbus_interface_vtable, data, _dvb_id_bus_satellite_scanner_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "frequency-scanned", (GCallback) _dbus_dvb_id_bus_satellite_scanner_frequency_scanned, data);
	g_signal_connect (object, "finished", (GCallback) _dbus_dvb_id_bus_satellite_scanner_finished, data);
	g_signal_connect (object, "channel-added", (GCallback) _dbus_dvb_id_bus_satellite_scanner_channel_added, data);
	g_signal_connect (object, "frontend-stats", (GCallback) _dbus_dvb_id_bus_satellite_scanner_frontend_stats, data);
	return result;
}


static void _dvb_id_bus_satellite_scanner_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}


DVBSatelliteScanner* dvb_satellite_scanner_construct (GType object_type, DVBDevice* device) {
	DVBSatelliteScanner * self = NULL;
	g_return_val_if_fail (device != NULL, NULL);
	self = (DVBSatelliteScanner*) g_object_new (object_type, "Device", device, NULL);
	return self;
}


DVBSatelliteScanner* dvb_satellite_scanner_new (DVBDevice* device) {
	return dvb_satellite_scanner_construct (DVB_TYPE_SATELLITE_SCANNER, device);
}


static gboolean dvb_satellite_scanner_real_AddScanningData (DVBIDBusScanner* base, GHashTable* data, GError** error) {
	DVBSatelliteScanner * self;
	gboolean result = FALSE;
	guint frequency = 0U;
	guint symbol_rate = 0U;
	gchar* polarization = NULL;
	GVariant* _var = NULL;
	gconstpointer _tmp0_ = NULL;
	guint32 _tmp1_;
	gconstpointer _tmp2_ = NULL;
	guint32 _tmp3_;
	gconstpointer _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_;
	self = (DVBSatelliteScanner*) base;
	g_return_val_if_fail (data != NULL, FALSE);
	_tmp0_ = g_hash_table_lookup (data, "frequency");
	_var = (GVariant*) _tmp0_;
	if (_var == NULL) {
		result = FALSE;
		_g_free0 (polarization);
		return result;
	}
	_tmp1_ = g_variant_get_uint32 (_var);
	frequency = (guint) _tmp1_;
	_tmp2_ = g_hash_table_lookup (data, "symbol-rate");
	_var = (GVariant*) _tmp2_;
	if (_var == NULL) {
		result = FALSE;
		_g_free0 (polarization);
		return result;
	}
	_tmp3_ = g_variant_get_uint32 (_var);
	symbol_rate = (guint) _tmp3_;
	_tmp4_ = g_hash_table_lookup (data, "polarization");
	_var = (GVariant*) _tmp4_;
	if (_var == NULL) {
		result = FALSE;
		_g_free0 (polarization);
		return result;
	}
	_tmp5_ = g_variant_get_string (_var, NULL);
	_tmp6_ = g_strdup (_tmp5_);
	_g_free0 (polarization);
	polarization = _tmp6_;
	dvb_satellite_scanner_add_scanning_data (self, frequency, polarization, symbol_rate);
	result = TRUE;
	_g_free0 (polarization);
	return result;
}


static gpointer _gst_structure_copy0 (gpointer self) {
	return self ? gst_structure_copy (self) : NULL;
}


static inline void dvb_satellite_scanner_add_scanning_data (DVBSatelliteScanner* self, guint frequency, const gchar* polarization, guint symbol_rate) {
	GstStructure* _tmp0_ = NULL;
	GstStructure* tuning_params;
	GstStructure* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (polarization != NULL);
	_tmp0_ = gst_structure_new ("tuning_params", "frequency", G_TYPE_UINT, frequency, "symbol-rate", G_TYPE_UINT, symbol_rate, "polarization", G_TYPE_STRING, polarization, NULL);
	tuning_params = _tmp0_;
	_tmp1_ = _gst_structure_copy0 (tuning_params);
	dvb_scanner_add_structure_to_scan (DVB_SCANNER (self), _tmp1_);
	_gst_structure_free0 (tuning_params);
}


static void dvb_satellite_scanner_real_add_scanning_data_from_string (DVBScanner* base, const gchar* line) {
	DVBSatelliteScanner * self;
	gchar** _tmp0_;
	gchar** _tmp1_ = NULL;
	gchar** cols;
	gint cols_length1;
	gint _cols_size_;
	gint _tmp2_;
	guint freq;
	gint _tmp3_;
	guint symbol_rate;
	gchar* pol = NULL;
	gchar* _tmp4_ = NULL;
	gchar* lower_pol;
	self = (DVBSatelliteScanner*) base;
	g_return_if_fail (line != NULL);
	_tmp1_ = _tmp0_ = g_regex_split_simple ("\\s+", line, 0, 0);
	cols = _tmp1_;
	cols_length1 = _vala_array_length (_tmp0_);
	_cols_size_ = _vala_array_length (_tmp0_);
	if (cols_length1 < 5) {
		cols = (_vala_array_free (cols, cols_length1, (GDestroyNotify) g_free), NULL);
		return;
	}
	_tmp2_ = atoi (cols[1]);
	freq = (guint) _tmp2_;
	_tmp3_ = atoi (cols[3]);
	symbol_rate = (guint) (_tmp3_ / 1000);
	_tmp4_ = g_utf8_strdown (cols[2], (gssize) (-1));
	lower_pol = _tmp4_;
	if (g_strcmp0 (lower_pol, "h") == 0) {
		gchar* _tmp5_;
		_tmp5_ = g_strdup ("horizontal");
		_g_free0 (pol);
		pol = _tmp5_;
	} else {
		if (g_strcmp0 (lower_pol, "v") == 0) {
			gchar* _tmp6_;
			_tmp6_ = g_strdup ("vertical");
			_g_free0 (pol);
			pol = _tmp6_;
		} else {
			_g_free0 (lower_pol);
			_g_free0 (pol);
			cols = (_vala_array_free (cols, cols_length1, (GDestroyNotify) g_free), NULL);
			return;
		}
	}
	dvb_satellite_scanner_add_scanning_data (self, freq, pol, symbol_rate);
	_g_free0 (lower_pol);
	_g_free0 (pol);
	cols = (_vala_array_free (cols, cols_length1, (GDestroyNotify) g_free), NULL);
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* _tmp0_ = NULL;
	gchar* end;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	if (end == NULL) {
		result = maxlen;
		return result;
	} else {
		result = (glong) (end - str);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= 0) {
		_tmp0_ = len >= 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp1_;
		_tmp1_ = string_strnlen ((gchar*) self, offset + len);
		string_length = _tmp1_;
	} else {
		gint _tmp2_;
		_tmp2_ = strlen (self);
		string_length = (glong) _tmp2_;
	}
	if (offset < 0) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= 0, NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < 0) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}


static void dvb_satellite_scanner_real_prepare (DVBScanner* base) {
	DVBSatelliteScanner * self;
	GstElement* _tmp0_ = NULL;
	GstElement* dvbsrc;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar** _tmp3_ = NULL;
	gchar** uint_keys;
	gint uint_keys_length1;
	gint _uint_keys_size_;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* polarity;
	guint code_rate = 0U;
	guint _tmp7_;
	self = (DVBSatelliteScanner*) base;
	g_debug ("SatelliteScanner.vala:119: Setting up pipeline for DVB-S scan");
	_tmp0_ = gst_bin_get_by_name (GST_BIN (DVB_SCANNER (self)->pipeline), "dvbsrc");
	dvbsrc = _tmp0_;
	_tmp1_ = g_strdup ("frequency");
	_tmp2_ = g_strdup ("symbol-rate");
	_tmp3_ = g_new0 (gchar*, 2 + 1);
	_tmp3_[0] = _tmp1_;
	_tmp3_[1] = _tmp2_;
	uint_keys = _tmp3_;
	uint_keys_length1 = 2;
	_uint_keys_size_ = 2;
	{
		gchar** key_collection;
		int key_collection_length1;
		int key_it;
		key_collection = uint_keys;
		key_collection_length1 = uint_keys_length1;
		for (key_it = 0; key_it < uint_keys_length1; key_it = key_it + 1) {
			gchar* _tmp4_;
			gchar* key;
			_tmp4_ = g_strdup (key_collection[key_it]);
			key = _tmp4_;
			{
				dvb_scanner_set_uint_property (dvbsrc, DVB_SCANNER (self)->current_tuning_params, key);
				_g_free0 (key);
			}
		}
	}
	_tmp5_ = gst_structure_get_string (DVB_SCANNER (self)->current_tuning_params, "polarization");
	_tmp6_ = string_substring (_tmp5_, (glong) 0, (glong) 1);
	polarity = _tmp6_;
	g_object_set ((GObject*) dvbsrc, "polarity", polarity, NULL);
	gst_structure_get_uint (DVB_SCANNER (self)->current_tuning_params, "inner-fec", &_tmp7_);
	code_rate = _tmp7_;
	g_object_set ((GObject*) dvbsrc, "code-rate-hp", code_rate, NULL);
	_g_free0 (polarity);
	uint_keys = (_vala_array_free (uint_keys, uint_keys_length1, (GDestroyNotify) g_free), NULL);
	_gst_object_unref0 (dvbsrc);
}


static DVBScannedItem* dvb_satellite_scanner_real_get_scanned_item (DVBScanner* base, const GstStructure* structure) {
	DVBSatelliteScanner * self;
	DVBScannedItem* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* pol;
	guint freq = 0U;
	guint _tmp2_;
	DVBScannedSatteliteItem* _tmp3_ = NULL;
	self = (DVBSatelliteScanner*) base;
	g_return_val_if_fail (structure != NULL, NULL);
	_tmp0_ = gst_structure_get_string (structure, "polarization");
	_tmp1_ = g_strdup_printf ("%s", _tmp0_);
	pol = _tmp1_;
	gst_structure_get_uint (structure, "frequency", &_tmp2_);
	freq = _tmp2_;
	_tmp3_ = dvb_scanned_sattelite_item_new (freq, pol);
	result = (DVBScannedItem*) _tmp3_;
	_g_free0 (pol);
	return result;
}


static DVBChannel* dvb_satellite_scanner_real_get_new_channel (DVBScanner* base) {
	DVBSatelliteScanner * self;
	DVBChannel* result = NULL;
	DVBSatelliteChannel* _tmp0_ = NULL;
	self = (DVBSatelliteScanner*) base;
	_tmp0_ = dvb_satellite_channel_new_without_schedule ();
	result = (DVBChannel*) _tmp0_;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void dvb_satellite_scanner_real_add_values_from_structure_to_channel (DVBScanner* base, const GstStructure* delivery, DVBChannel* channel) {
	DVBSatelliteScanner * self;
	DVBSatelliteChannel* _tmp0_;
	DVBSatelliteChannel* sc;
	guint freq = 0U;
	guint _tmp1_;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	guint srate = 0U;
	guint _tmp5_;
	self = (DVBSatelliteScanner*) base;
	g_return_if_fail (delivery != NULL);
	g_return_if_fail (channel != NULL);
	if (!DVB_IS_SATELLITE_CHANNEL (channel)) {
		return;
	}
	_tmp0_ = _g_object_ref0 (DVB_SATELLITE_CHANNEL (channel));
	sc = _tmp0_;
	gst_structure_get_uint (delivery, "frequency", &_tmp1_);
	freq = _tmp1_;
	dvb_channel_set_Frequency ((DVBChannel*) sc, freq);
	_tmp2_ = gst_structure_get_string (delivery, "polarization");
	_tmp3_ = string_substring (_tmp2_, (glong) 0, (glong) 1);
	_tmp4_ = _tmp3_;
	dvb_satellite_channel_set_Polarization (sc, _tmp4_);
	_g_free0 (_tmp4_);
	gst_structure_get_uint (delivery, "symbol-rate", &_tmp5_);
	srate = _tmp5_;
	dvb_satellite_channel_set_SymbolRate (sc, srate);
	dvb_satellite_channel_set_DiseqcSource (sc, -1);
	_g_object_unref0 (sc);
}


static void dvb_satellite_scanner_class_init (DVBSatelliteScannerClass * klass) {
	dvb_satellite_scanner_parent_class = g_type_class_peek_parent (klass);
	DVB_SCANNER_CLASS (klass)->add_scanning_data_from_string = dvb_satellite_scanner_real_add_scanning_data_from_string;
	DVB_SCANNER_CLASS (klass)->prepare = dvb_satellite_scanner_real_prepare;
	DVB_SCANNER_CLASS (klass)->get_scanned_item = dvb_satellite_scanner_real_get_scanned_item;
	DVB_SCANNER_CLASS (klass)->get_new_channel = dvb_satellite_scanner_real_get_new_channel;
	DVB_SCANNER_CLASS (klass)->add_values_from_structure_to_channel = dvb_satellite_scanner_real_add_values_from_structure_to_channel;
}


static void dvb_satellite_scanner_dvb_id_bus_scanner_interface_init (DVBIDBusScannerIface * iface) {
	dvb_satellite_scanner_dvb_id_bus_scanner_parent_iface = g_type_interface_peek_parent (iface);
	iface->AddScanningData = (gboolean (*)(DVBIDBusScanner* ,GHashTable* ,GError**)) dvb_satellite_scanner_real_AddScanningData;
	iface->Run = (void (*)(DVBIDBusScanner* ,GError**)) dvb_scanner_Run;
	iface->Destroy = (void (*)(DVBIDBusScanner* ,GError**)) dvb_scanner_Destroy;
	iface->WriteAllChannelsToFile = (gboolean (*)(DVBIDBusScanner* ,const gchar* ,GError**)) dvb_scanner_WriteAllChannelsToFile;
	iface->WriteChannelsToFile = (gboolean (*)(DVBIDBusScanner* ,guint* ,int ,const gchar* ,GError**)) dvb_scanner_WriteChannelsToFile;
	iface->AddScanningDataFromFile = (gboolean (*)(DVBIDBusScanner* ,const gchar* ,GError**)) dvb_scanner_AddScanningDataFromFile;
}


static void dvb_satellite_scanner_instance_init (DVBSatelliteScanner * self) {
}


GType dvb_satellite_scanner_get_type (void) {
	static volatile gsize dvb_satellite_scanner_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_satellite_scanner_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBSatelliteScannerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_satellite_scanner_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBSatelliteScanner), 0, (GInstanceInitFunc) dvb_satellite_scanner_instance_init, NULL };
		static const GInterfaceInfo dvb_id_bus_scanner_info = { (GInterfaceInitFunc) dvb_satellite_scanner_dvb_id_bus_scanner_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType dvb_satellite_scanner_type_id;
		dvb_satellite_scanner_type_id = g_type_register_static (DVB_TYPE_SCANNER, "DVBSatelliteScanner", &g_define_type_info, 0);
		g_type_add_interface_static (dvb_satellite_scanner_type_id, DVB_TYPE_ID_BUS_SCANNER, &dvb_id_bus_scanner_info);
		g_once_init_leave (&dvb_satellite_scanner_type_id__volatile, dvb_satellite_scanner_type_id);
	}
	return dvb_satellite_scanner_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



