/* TerrestrialScanner.c generated by valac 0.12.0, the Vala compiler
 * generated from TerrestrialScanner.vala, do not modify */

/*
 * Copyright (C) 2008-2010 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gst/gst.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gio/gio.h>


#define DVB_TYPE_SCANNER (dvb_scanner_get_type ())
#define DVB_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_SCANNER, DVBScanner))
#define DVB_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_SCANNER, DVBScannerClass))
#define DVB_IS_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_SCANNER))
#define DVB_IS_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_SCANNER))
#define DVB_SCANNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_SCANNER, DVBScannerClass))

typedef struct _DVBScanner DVBScanner;
typedef struct _DVBScannerClass DVBScannerClass;
typedef struct _DVBScannerPrivate DVBScannerPrivate;

#define DVB_TYPE_SCANNED_ITEM (dvb_scanned_item_get_type ())
#define DVB_SCANNED_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_SCANNED_ITEM, DVBScannedItem))
#define DVB_SCANNED_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_SCANNED_ITEM, DVBScannedItemClass))
#define DVB_IS_SCANNED_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_SCANNED_ITEM))
#define DVB_IS_SCANNED_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_SCANNED_ITEM))
#define DVB_SCANNED_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_SCANNED_ITEM, DVBScannedItemClass))

typedef struct _DVBScannedItem DVBScannedItem;
typedef struct _DVBScannedItemClass DVBScannedItemClass;

#define DVB_TYPE_CHANNEL (dvb_channel_get_type ())
#define DVB_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL, DVBChannel))
#define DVB_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL, DVBChannelClass))
#define DVB_IS_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL))
#define DVB_IS_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL))
#define DVB_CHANNEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL, DVBChannelClass))

typedef struct _DVBChannel DVBChannel;
typedef struct _DVBChannelClass DVBChannelClass;

#define DVB_TYPE_CHANNEL_LIST (dvb_channel_list_get_type ())
#define DVB_CHANNEL_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL_LIST, DVBChannelList))
#define DVB_CHANNEL_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL_LIST, DVBChannelListClass))
#define DVB_IS_CHANNEL_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL_LIST))
#define DVB_IS_CHANNEL_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL_LIST))
#define DVB_CHANNEL_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL_LIST, DVBChannelListClass))

typedef struct _DVBChannelList DVBChannelList;
typedef struct _DVBChannelListClass DVBChannelListClass;

#define DVB_TYPE_ID_BUS_SCANNER (dvb_id_bus_scanner_get_type ())
#define DVB_ID_BUS_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_ID_BUS_SCANNER, DVBIDBusScanner))
#define DVB_IS_ID_BUS_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_ID_BUS_SCANNER))
#define DVB_ID_BUS_SCANNER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DVB_TYPE_ID_BUS_SCANNER, DVBIDBusScannerIface))

typedef struct _DVBIDBusScanner DVBIDBusScanner;
typedef struct _DVBIDBusScannerIface DVBIDBusScannerIface;

#define DVB_TYPE_ID_BUS_SCANNER_PROXY (dvb_id_bus_scanner_proxy_get_type ())

#define DVB_TYPE_TERRESTRIAL_SCANNER (dvb_terrestrial_scanner_get_type ())
#define DVB_TERRESTRIAL_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_TERRESTRIAL_SCANNER, DVBTerrestrialScanner))
#define DVB_TERRESTRIAL_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_TERRESTRIAL_SCANNER, DVBTerrestrialScannerClass))
#define DVB_IS_TERRESTRIAL_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_TERRESTRIAL_SCANNER))
#define DVB_IS_TERRESTRIAL_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_TERRESTRIAL_SCANNER))
#define DVB_TERRESTRIAL_SCANNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_TERRESTRIAL_SCANNER, DVBTerrestrialScannerClass))

typedef struct _DVBTerrestrialScanner DVBTerrestrialScanner;
typedef struct _DVBTerrestrialScannerClass DVBTerrestrialScannerClass;
typedef struct _DVBTerrestrialScannerPrivate DVBTerrestrialScannerPrivate;

#define DVB_TYPE_DEVICE (dvb_device_get_type ())
#define DVB_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_DEVICE, DVBDevice))
#define DVB_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_DEVICE, DVBDeviceClass))
#define DVB_IS_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_DEVICE))
#define DVB_IS_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_DEVICE))
#define DVB_DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_DEVICE, DVBDeviceClass))

typedef struct _DVBDevice DVBDevice;
typedef struct _DVBDeviceClass DVBDeviceClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _gst_structure_free0(var) ((var == NULL) ? NULL : (var = (gst_structure_free (var), NULL)))

#define DVB_TYPE_DVB_SRC_BANDWIDTH (dvb_dvb_src_bandwidth_get_type ())

#define DVB_TYPE_DVB_SRC_HIERARCHY (dvb_dvb_src_hierarchy_get_type ())

#define DVB_TYPE_DVB_SRC_MODULATION (dvb_dvb_src_modulation_get_type ())

#define DVB_TYPE_DVB_SRC_CODE_RATE (dvb_dvb_src_code_rate_get_type ())

#define DVB_TYPE_DVB_SRC_GUARD (dvb_dvb_src_guard_get_type ())

#define DVB_TYPE_DVB_SRC_TRANSMISSION_MODE (dvb_dvb_src_transmission_mode_get_type ())
#define _gst_object_unref0(var) ((var == NULL) ? NULL : (var = (gst_object_unref (var), NULL)))

#define DVB_TYPE_TERRESTRIAL_CHANNEL (dvb_terrestrial_channel_get_type ())
#define DVB_TERRESTRIAL_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_TERRESTRIAL_CHANNEL, DVBTerrestrialChannel))
#define DVB_TERRESTRIAL_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_TERRESTRIAL_CHANNEL, DVBTerrestrialChannelClass))
#define DVB_IS_TERRESTRIAL_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_TERRESTRIAL_CHANNEL))
#define DVB_IS_TERRESTRIAL_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_TERRESTRIAL_CHANNEL))
#define DVB_TERRESTRIAL_CHANNEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_TERRESTRIAL_CHANNEL, DVBTerrestrialChannelClass))

typedef struct _DVBTerrestrialChannel DVBTerrestrialChannel;
typedef struct _DVBTerrestrialChannelClass DVBTerrestrialChannelClass;

#define DVB_TYPE_DVB_SRC_INVERSION (dvb_dvb_src_inversion_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _DVBScanner {
	GObject parent_instance;
	DVBScannerPrivate * priv;
	DVBChannelList* channels;
	GstElement* pipeline;
	GQueue* frequencies;
	GstStructure* current_tuning_params;
	GeeHashSet* scanned_frequencies;
};

struct _DVBScannerClass {
	GObjectClass parent_class;
	void (*prepare) (DVBScanner* self);
	DVBScannedItem* (*get_scanned_item) (DVBScanner* self, const GstStructure* structure);
	DVBChannel* (*get_new_channel) (DVBScanner* self);
	void (*add_values_from_structure_to_channel) (DVBScanner* self, const GstStructure* delivery, DVBChannel* channel);
	void (*add_scanning_data_from_string) (DVBScanner* self, const gchar* line);
};

struct _DVBIDBusScannerIface {
	GTypeInterface parent_iface;
	void (*Run) (DVBIDBusScanner* self, GError** error);
	void (*Destroy) (DVBIDBusScanner* self, GError** error);
	gboolean (*WriteAllChannelsToFile) (DVBIDBusScanner* self, const gchar* path, GError** error);
	gboolean (*WriteChannelsToFile) (DVBIDBusScanner* self, guint* channel_sids, int channel_sids_length1, const gchar* path, GError** error);
	gboolean (*AddScanningData) (DVBIDBusScanner* self, GHashTable* data, GError** error);
	gboolean (*AddScanningDataFromFile) (DVBIDBusScanner* self, const gchar* path, GError** error);
};

struct _DVBTerrestrialScanner {
	DVBScanner parent_instance;
	DVBTerrestrialScannerPrivate * priv;
};

struct _DVBTerrestrialScannerClass {
	DVBScannerClass parent_class;
};

typedef enum  {
	DVB_DVB_SRC_BANDWIDTH_BANDWIDTH_8_MHZ,
	DVB_DVB_SRC_BANDWIDTH_BANDWIDTH_7_MHZ,
	DVB_DVB_SRC_BANDWIDTH_BANDWIDTH_6_MHZ,
	DVB_DVB_SRC_BANDWIDTH_BANDWIDTH_AUTO
} DVBDvbSrcBandwidth;

typedef enum  {
	DVB_DVB_SRC_HIERARCHY_HIERARCHY_NONE,
	DVB_DVB_SRC_HIERARCHY_HIERARCHY_1,
	DVB_DVB_SRC_HIERARCHY_HIERARCHY_2,
	DVB_DVB_SRC_HIERARCHY_HIERARCHY_4,
	DVB_DVB_SRC_HIERARCHY_HIERARCHY_AUTO
} DVBDvbSrcHierarchy;

typedef enum  {
	DVB_DVB_SRC_MODULATION_QPSK,
	DVB_DVB_SRC_MODULATION_QAM_16,
	DVB_DVB_SRC_MODULATION_QAM_32,
	DVB_DVB_SRC_MODULATION_QAM_64,
	DVB_DVB_SRC_MODULATION_QAM_128,
	DVB_DVB_SRC_MODULATION_QAM_256,
	DVB_DVB_SRC_MODULATION_QAM_AUTO
} DVBDvbSrcModulation;

typedef enum  {
	DVB_DVB_SRC_CODE_RATE_FEC_NONE,
	DVB_DVB_SRC_CODE_RATE_FEC_1_2,
	DVB_DVB_SRC_CODE_RATE_FEC_2_3,
	DVB_DVB_SRC_CODE_RATE_FEC_3_4,
	DVB_DVB_SRC_CODE_RATE_FEC_4_5,
	DVB_DVB_SRC_CODE_RATE_FEC_5_6,
	DVB_DVB_SRC_CODE_RATE_FEC_6_7,
	DVB_DVB_SRC_CODE_RATE_FEC_7_8,
	DVB_DVB_SRC_CODE_RATE_FEC_8_9,
	DVB_DVB_SRC_CODE_RATE_FEC_AUTO
} DVBDvbSrcCodeRate;

typedef enum  {
	DVB_DVB_SRC_GUARD_GUARD_INTERVAL_1_32,
	DVB_DVB_SRC_GUARD_GUARD_INTERVAL_1_16,
	DVB_DVB_SRC_GUARD_GUARD_INTERVAL_1_8,
	DVB_DVB_SRC_GUARD_GUARD_INTERVAL_1_4,
	DVB_DVB_SRC_GUARD_GUARD_INTERVAL_AUTO
} DVBDvbSrcGuard;

typedef enum  {
	DVB_DVB_SRC_TRANSMISSION_MODE_TRANSMISSION_MODE_2K,
	DVB_DVB_SRC_TRANSMISSION_MODE_TRANSMISSION_MODE_8K,
	DVB_DVB_SRC_TRANSMISSION_MODE_TRANSMISSION_MODE_AUTO
} DVBDvbSrcTransmissionMode;

typedef enum  {
	DVB_DVB_SRC_INVERSION_INVERSION_OFF,
	DVB_DVB_SRC_INVERSION_INVERSION_ON,
	DVB_DVB_SRC_INVERSION_INVERSION_AUTO
} DVBDvbSrcInversion;


static gpointer dvb_terrestrial_scanner_parent_class = NULL;
static DVBIDBusScannerIface* dvb_terrestrial_scanner_dvb_id_bus_scanner_parent_iface = NULL;

GType dvb_scanner_get_type (void) G_GNUC_CONST;
GType dvb_scanned_item_get_type (void) G_GNUC_CONST;
GType dvb_channel_get_type (void) G_GNUC_CONST;
GType dvb_channel_list_get_type (void) G_GNUC_CONST;
GType dvb_id_bus_scanner_proxy_get_type (void) G_GNUC_CONST;
guint dvb_id_bus_scanner_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType dvb_id_bus_scanner_get_type (void) G_GNUC_CONST;
GType dvb_terrestrial_scanner_get_type (void) G_GNUC_CONST;
enum  {
	DVB_TERRESTRIAL_SCANNER_DUMMY_PROPERTY
};
GType dvb_device_get_type (void) G_GNUC_CONST;
DVBTerrestrialScanner* dvb_terrestrial_scanner_new (DVBDevice* device);
DVBTerrestrialScanner* dvb_terrestrial_scanner_construct (GType object_type, DVBDevice* device);
static gboolean dvb_terrestrial_scanner_real_AddScanningData (DVBIDBusScanner* base, GHashTable* data, GError** error);
static inline void dvb_terrestrial_scanner_add_scanning_data (DVBTerrestrialScanner* self, guint frequency, guint hierarchy, guint bandwidth, const gchar* transmode, const gchar* code_rate_hp, const gchar* code_rate_lp, const gchar* constellation, guint guard);
void dvb_scanner_add_structure_to_scan (DVBScanner* self, GstStructure* structure);
static void dvb_terrestrial_scanner_real_add_scanning_data_from_string (DVBScanner* base, const gchar* line);
static void dvb_terrestrial_scanner_real_prepare (DVBScanner* base);
void dvb_scanner_set_uint_property (GstElement* src, const GstStructure* params, const gchar* key);
GType dvb_dvb_src_bandwidth_get_type (void) G_GNUC_CONST;
DVBDvbSrcBandwidth dvb_get_bandwidth_val (guint bandwidth);
GType dvb_dvb_src_hierarchy_get_type (void) G_GNUC_CONST;
DVBDvbSrcHierarchy dvb_get_hierarchy_val (guint hierarchy);
GType dvb_dvb_src_modulation_get_type (void) G_GNUC_CONST;
DVBDvbSrcModulation dvb_get_modulation_val (const gchar* constellation);
GType dvb_dvb_src_code_rate_get_type (void) G_GNUC_CONST;
DVBDvbSrcCodeRate dvb_get_code_rate_val (const gchar* code_rate_string);
GType dvb_dvb_src_guard_get_type (void) G_GNUC_CONST;
DVBDvbSrcGuard dvb_get_guard_interval_val (guint guard);
GType dvb_dvb_src_transmission_mode_get_type (void) G_GNUC_CONST;
DVBDvbSrcTransmissionMode dvb_get_transmission_mode_val (const gchar* transmode);
static DVBScannedItem* dvb_terrestrial_scanner_real_get_scanned_item (DVBScanner* base, const GstStructure* structure);
DVBScannedItem* dvb_scanned_item_new (guint frequency);
DVBScannedItem* dvb_scanned_item_construct (GType object_type, guint frequency);
static DVBChannel* dvb_terrestrial_scanner_real_get_new_channel (DVBScanner* base);
DVBTerrestrialChannel* dvb_terrestrial_channel_new_without_schedule (void);
DVBTerrestrialChannel* dvb_terrestrial_channel_construct_without_schedule (GType object_type);
GType dvb_terrestrial_channel_get_type (void) G_GNUC_CONST;
static void dvb_terrestrial_scanner_real_add_values_from_structure_to_channel (DVBScanner* base, const GstStructure* delivery, DVBChannel* channel);
GType dvb_dvb_src_inversion_get_type (void) G_GNUC_CONST;
void dvb_terrestrial_channel_set_Inversion (DVBTerrestrialChannel* self, DVBDvbSrcInversion value);
void dvb_channel_set_Frequency (DVBChannel* self, guint value);
void dvb_terrestrial_channel_set_Bandwidth (DVBTerrestrialChannel* self, DVBDvbSrcBandwidth value);
void dvb_terrestrial_channel_set_Hierarchy (DVBTerrestrialChannel* self, DVBDvbSrcHierarchy value);
void dvb_terrestrial_channel_set_Constellation (DVBTerrestrialChannel* self, DVBDvbSrcModulation value);
void dvb_terrestrial_channel_set_CodeRateHP (DVBTerrestrialChannel* self, DVBDvbSrcCodeRate value);
void dvb_terrestrial_channel_set_CodeRateLP (DVBTerrestrialChannel* self, DVBDvbSrcCodeRate value);
void dvb_terrestrial_channel_set_GuardInterval (DVBTerrestrialChannel* self, DVBDvbSrcGuard value);
void dvb_terrestrial_channel_set_TransmissionMode (DVBTerrestrialChannel* self, DVBDvbSrcTransmissionMode value);
void dvb_scanner_Run (DVBScanner* self, GError** error);
void dvb_scanner_Destroy (DVBScanner* self, GError** error);
gboolean dvb_scanner_WriteAllChannelsToFile (DVBScanner* self, const gchar* path, GError** error);
gboolean dvb_scanner_WriteChannelsToFile (DVBScanner* self, guint* channel_sids, int channel_sids_length1, const gchar* path, GError** error);
gboolean dvb_scanner_AddScanningDataFromFile (DVBScanner* self, const gchar* path, GError** error);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


DVBTerrestrialScanner* dvb_terrestrial_scanner_construct (GType object_type, DVBDevice* device) {
	DVBTerrestrialScanner * self = NULL;
	g_return_val_if_fail (device != NULL, NULL);
	self = (DVBTerrestrialScanner*) g_object_new (object_type, "Device", device, NULL);
	return self;
}


DVBTerrestrialScanner* dvb_terrestrial_scanner_new (DVBDevice* device) {
	return dvb_terrestrial_scanner_construct (DVB_TYPE_TERRESTRIAL_SCANNER, device);
}


/**
          * See enums in MpegTsEnums
          */
static gboolean dvb_terrestrial_scanner_real_AddScanningData (DVBIDBusScanner* base, GHashTable* data, GError** error) {
	DVBTerrestrialScanner * self;
	gboolean result = FALSE;
	guint frequency = 0U;
	guint hierarchy = 0U;
	guint bandwidth = 0U;
	guint guard = 0U;
	gchar* transmode = NULL;
	gchar* code_rate_hp = NULL;
	gchar* code_rate_lp = NULL;
	gchar* constellation = NULL;
	GVariant* _var = NULL;
	gconstpointer _tmp0_ = NULL;
	guint32 _tmp1_;
	gconstpointer _tmp2_ = NULL;
	guint32 _tmp3_;
	gconstpointer _tmp4_ = NULL;
	guint32 _tmp5_;
	gconstpointer _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	gconstpointer _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	gchar* _tmp11_;
	gconstpointer _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	gchar* _tmp14_;
	gconstpointer _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	gchar* _tmp17_;
	gconstpointer _tmp18_ = NULL;
	guint32 _tmp19_;
	self = (DVBTerrestrialScanner*) base;
	g_return_val_if_fail (data != NULL, FALSE);
	_tmp0_ = g_hash_table_lookup (data, "frequency");
	_var = (GVariant*) _tmp0_;
	if (_var == NULL) {
		result = FALSE;
		_g_free0 (constellation);
		_g_free0 (code_rate_lp);
		_g_free0 (code_rate_hp);
		_g_free0 (transmode);
		return result;
	}
	_tmp1_ = g_variant_get_uint32 (_var);
	frequency = (guint) _tmp1_;
	_tmp2_ = g_hash_table_lookup (data, "hierarchy");
	_var = (GVariant*) _tmp2_;
	if (_var == NULL) {
		result = FALSE;
		_g_free0 (constellation);
		_g_free0 (code_rate_lp);
		_g_free0 (code_rate_hp);
		_g_free0 (transmode);
		return result;
	}
	_tmp3_ = g_variant_get_uint32 (_var);
	hierarchy = (guint) _tmp3_;
	_tmp4_ = g_hash_table_lookup (data, "bandwidth");
	_var = (GVariant*) _tmp4_;
	if (_var == NULL) {
		result = FALSE;
		_g_free0 (constellation);
		_g_free0 (code_rate_lp);
		_g_free0 (code_rate_hp);
		_g_free0 (transmode);
		return result;
	}
	_tmp5_ = g_variant_get_uint32 (_var);
	bandwidth = (guint) _tmp5_;
	_tmp6_ = g_hash_table_lookup (data, "transmission-mode");
	_var = (GVariant*) _tmp6_;
	if (_var == NULL) {
		result = FALSE;
		_g_free0 (constellation);
		_g_free0 (code_rate_lp);
		_g_free0 (code_rate_hp);
		_g_free0 (transmode);
		return result;
	}
	_tmp7_ = g_variant_get_string (_var, NULL);
	_tmp8_ = g_strdup (_tmp7_);
	_g_free0 (transmode);
	transmode = _tmp8_;
	_tmp9_ = g_hash_table_lookup (data, "code-rate-hp");
	_var = (GVariant*) _tmp9_;
	if (_var == NULL) {
		result = FALSE;
		_g_free0 (constellation);
		_g_free0 (code_rate_lp);
		_g_free0 (code_rate_hp);
		_g_free0 (transmode);
		return result;
	}
	_tmp10_ = g_variant_get_string (_var, NULL);
	_tmp11_ = g_strdup (_tmp10_);
	_g_free0 (code_rate_hp);
	code_rate_hp = _tmp11_;
	_tmp12_ = g_hash_table_lookup (data, "code-rate-lp");
	_var = (GVariant*) _tmp12_;
	if (_var == NULL) {
		result = FALSE;
		_g_free0 (constellation);
		_g_free0 (code_rate_lp);
		_g_free0 (code_rate_hp);
		_g_free0 (transmode);
		return result;
	}
	_tmp13_ = g_variant_get_string (_var, NULL);
	_tmp14_ = g_strdup (_tmp13_);
	_g_free0 (code_rate_lp);
	code_rate_lp = _tmp14_;
	_tmp15_ = g_hash_table_lookup (data, "constellation");
	_var = (GVariant*) _tmp15_;
	if (_var == NULL) {
		result = FALSE;
		_g_free0 (constellation);
		_g_free0 (code_rate_lp);
		_g_free0 (code_rate_hp);
		_g_free0 (transmode);
		return result;
	}
	_tmp16_ = g_variant_get_string (_var, NULL);
	_tmp17_ = g_strdup (_tmp16_);
	_g_free0 (constellation);
	constellation = _tmp17_;
	_tmp18_ = g_hash_table_lookup (data, "guard-interval");
	_var = (GVariant*) _tmp18_;
	if (_var == NULL) {
		result = FALSE;
		_g_free0 (constellation);
		_g_free0 (code_rate_lp);
		_g_free0 (code_rate_hp);
		_g_free0 (transmode);
		return result;
	}
	_tmp19_ = g_variant_get_uint32 (_var);
	guard = (guint) _tmp19_;
	dvb_terrestrial_scanner_add_scanning_data (self, frequency, hierarchy, bandwidth, transmode, code_rate_hp, code_rate_lp, constellation, guard);
	result = TRUE;
	_g_free0 (constellation);
	_g_free0 (code_rate_lp);
	_g_free0 (code_rate_hp);
	_g_free0 (transmode);
	return result;
}


static gpointer _gst_structure_copy0 (gpointer self) {
	return self ? gst_structure_copy (self) : NULL;
}


static inline void dvb_terrestrial_scanner_add_scanning_data (DVBTerrestrialScanner* self, guint frequency, guint hierarchy, guint bandwidth, const gchar* transmode, const gchar* code_rate_hp, const gchar* code_rate_lp, const gchar* constellation, guint guard) {
	GstStructure* _tmp0_ = NULL;
	GstStructure* tuning_params;
	GstStructure* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (transmode != NULL);
	g_return_if_fail (code_rate_hp != NULL);
	g_return_if_fail (code_rate_lp != NULL);
	g_return_if_fail (constellation != NULL);
	_tmp0_ = gst_structure_new ("tuning_params", "frequency", G_TYPE_UINT, frequency, "hierarchy", G_TYPE_UINT, hierarchy, "bandwidth", G_TYPE_UINT, bandwidth, "transmission-mode", G_TYPE_STRING, transmode, "code-rate-hp", G_TYPE_STRING, code_rate_hp, "code-rate-lp", G_TYPE_STRING, code_rate_lp, "constellation", G_TYPE_STRING, constellation, "guard-interval", G_TYPE_UINT, guard, NULL);
	tuning_params = _tmp0_;
	_tmp1_ = _gst_structure_copy0 (tuning_params);
	dvb_scanner_add_structure_to_scan (DVB_SCANNER (self), _tmp1_);
	_gst_structure_free0 (tuning_params);
}


static gint string_index_of (const gchar* self, const gchar* needle, gint start_index) {
	gint result = 0;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	if (_result_ != NULL) {
		result = (gint) (_result_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static void dvb_terrestrial_scanner_real_add_scanning_data_from_string (DVBScanner* base, const gchar* line) {
	DVBTerrestrialScanner * self;
	gchar** _tmp0_;
	gchar** _tmp1_ = NULL;
	gchar** cols;
	gint cols_length1;
	gint _cols_size_;
	gint _tmp2_;
	guint freq;
	guint hierarchy;
	gchar** _tmp3_;
	gchar** _tmp4_ = NULL;
	gchar** _tmp5_;
	gint _tmp5__length1;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* bandwidth_str;
	gint _tmp8_;
	guint bandwidth;
	gchar* _tmp9_;
	gchar* transmode;
	gchar* _tmp10_;
	gchar* code_rate_hp;
	gchar* _tmp11_;
	gchar* code_rate_lp;
	gchar* _tmp12_;
	gchar* constellation;
	guint guard = 0U;
	gint _tmp13_;
	self = (DVBTerrestrialScanner*) base;
	g_return_if_fail (line != NULL);
	_tmp1_ = _tmp0_ = g_regex_split_simple ("\\s+", line, 0, 0);
	cols = _tmp1_;
	cols_length1 = _vala_array_length (_tmp0_);
	_cols_size_ = _vala_array_length (_tmp0_);
	if (cols_length1 < 9) {
		cols = (_vala_array_free (cols, cols_length1, (GDestroyNotify) g_free), NULL);
		return;
	}
	_tmp2_ = atoi (cols[1]);
	freq = (guint) _tmp2_;
	hierarchy = (guint) 0;
	if (g_strcmp0 (cols[8], "1") == 0) {
		hierarchy = (guint) 1;
	} else {
		if (g_strcmp0 (cols[8], "2") == 0) {
			hierarchy = (guint) 2;
		} else {
			if (g_strcmp0 (cols[8], "4") == 0) {
				hierarchy = (guint) 3;
			}
		}
	}
	_tmp4_ = _tmp3_ = g_strsplit (cols[2], "MHz", 0);
	_tmp5_ = _tmp4_;
	_tmp5__length1 = _vala_array_length (_tmp3_);
	_tmp6_ = g_strdup (_tmp5_[0]);
	_tmp7_ = _tmp6_;
	_tmp5_ = (_vala_array_free (_tmp5_, _tmp5__length1, (GDestroyNotify) g_free), NULL);
	bandwidth_str = _tmp7_;
	_tmp8_ = atoi (bandwidth_str);
	bandwidth = (guint) _tmp8_;
	_tmp9_ = g_strdup (cols[6]);
	transmode = _tmp9_;
	_tmp10_ = g_strdup (cols[3]);
	code_rate_hp = _tmp10_;
	_tmp11_ = g_strdup (cols[4]);
	code_rate_lp = _tmp11_;
	_tmp12_ = g_strdup (cols[5]);
	constellation = _tmp12_;
	_tmp13_ = string_index_of (cols[7], "/", 0);
	if (_tmp13_ == (-1)) {
		guard = (guint) 0;
	} else {
		gchar** _tmp14_;
		gchar** _tmp15_ = NULL;
		gchar** _tmp16_;
		gint _tmp16__length1;
		gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* guard_str;
		gint _tmp19_;
		_tmp15_ = _tmp14_ = g_strsplit (cols[7], "/", 0);
		_tmp16_ = _tmp15_;
		_tmp16__length1 = _vala_array_length (_tmp14_);
		_tmp17_ = g_strdup (_tmp16_[1]);
		_tmp18_ = _tmp17_;
		_tmp16_ = (_vala_array_free (_tmp16_, _tmp16__length1, (GDestroyNotify) g_free), NULL);
		guard_str = _tmp18_;
		_tmp19_ = atoi (guard_str);
		guard = (guint) _tmp19_;
		_g_free0 (guard_str);
	}
	dvb_terrestrial_scanner_add_scanning_data (self, freq, hierarchy, bandwidth, transmode, code_rate_hp, code_rate_lp, constellation, guard);
	_g_free0 (constellation);
	_g_free0 (code_rate_lp);
	_g_free0 (code_rate_hp);
	_g_free0 (transmode);
	_g_free0 (bandwidth_str);
	cols = (_vala_array_free (cols, cols_length1, (GDestroyNotify) g_free), NULL);
}


static void dvb_terrestrial_scanner_real_prepare (DVBScanner* base) {
	DVBTerrestrialScanner * self;
	GstElement* _tmp0_ = NULL;
	GstElement* dvbsrc;
	guint bandwidth = 0U;
	guint _tmp1_;
	DVBDvbSrcBandwidth _tmp2_;
	guint hierarchy = 0U;
	guint _tmp3_;
	DVBDvbSrcHierarchy _tmp4_;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_;
	gchar* constellation;
	DVBDvbSrcModulation _tmp7_;
	const gchar* _tmp8_ = NULL;
	DVBDvbSrcCodeRate _tmp9_;
	const gchar* _tmp10_ = NULL;
	DVBDvbSrcCodeRate _tmp11_;
	guint guard = 0U;
	guint _tmp12_;
	DVBDvbSrcGuard _tmp13_;
	const gchar* _tmp14_ = NULL;
	gchar* _tmp15_;
	gchar* transmode;
	DVBDvbSrcTransmissionMode _tmp16_;
	self = (DVBTerrestrialScanner*) base;
	g_debug ("TerrestrialScanner.vala:146: Setting up pipeline for DVB-T scan");
	_tmp0_ = gst_bin_get_by_name (GST_BIN (DVB_SCANNER (self)->pipeline), "dvbsrc");
	dvbsrc = _tmp0_;
	dvb_scanner_set_uint_property (dvbsrc, DVB_SCANNER (self)->current_tuning_params, "frequency");
	gst_structure_get_uint (((DVBScanner*) self)->current_tuning_params, "bandwidth", &_tmp1_);
	bandwidth = _tmp1_;
	_tmp2_ = dvb_get_bandwidth_val (bandwidth);
	g_object_set ((GObject*) dvbsrc, "bandwidth", _tmp2_, NULL);
	gst_structure_get_uint (((DVBScanner*) self)->current_tuning_params, "hierarchy", &_tmp3_);
	hierarchy = _tmp3_;
	_tmp4_ = dvb_get_hierarchy_val (hierarchy);
	g_object_set ((GObject*) dvbsrc, "hierarchy", _tmp4_, NULL);
	_tmp5_ = gst_structure_get_string (((DVBScanner*) self)->current_tuning_params, "constellation");
	_tmp6_ = g_strdup (_tmp5_);
	constellation = _tmp6_;
	_tmp7_ = dvb_get_modulation_val (constellation);
	g_object_set ((GObject*) dvbsrc, "modulation", _tmp7_, NULL);
	_tmp8_ = gst_structure_get_string (((DVBScanner*) self)->current_tuning_params, "code-rate-hp");
	_tmp9_ = dvb_get_code_rate_val (_tmp8_);
	g_object_set ((GObject*) dvbsrc, "code-rate-hp", _tmp9_, NULL);
	_tmp10_ = gst_structure_get_string (((DVBScanner*) self)->current_tuning_params, "code-rate-lp");
	_tmp11_ = dvb_get_code_rate_val (_tmp10_);
	g_object_set ((GObject*) dvbsrc, "code-rate-lp", _tmp11_, NULL);
	gst_structure_get_uint (((DVBScanner*) self)->current_tuning_params, "guard-interval", &_tmp12_);
	guard = _tmp12_;
	_tmp13_ = dvb_get_guard_interval_val (guard);
	g_object_set ((GObject*) dvbsrc, "guard", _tmp13_, NULL);
	_tmp14_ = gst_structure_get_string (((DVBScanner*) self)->current_tuning_params, "transmission-mode");
	_tmp15_ = g_strdup (_tmp14_);
	transmode = _tmp15_;
	_tmp16_ = dvb_get_transmission_mode_val (transmode);
	g_object_set ((GObject*) dvbsrc, "trans-mode", _tmp16_, NULL);
	_g_free0 (transmode);
	_g_free0 (constellation);
	_gst_object_unref0 (dvbsrc);
}


static DVBScannedItem* dvb_terrestrial_scanner_real_get_scanned_item (DVBScanner* base, const GstStructure* structure) {
	DVBTerrestrialScanner * self;
	DVBScannedItem* result = NULL;
	guint freq = 0U;
	guint _tmp0_;
	DVBScannedItem* _tmp1_ = NULL;
	self = (DVBTerrestrialScanner*) base;
	g_return_val_if_fail (structure != NULL, NULL);
	gst_structure_get_uint (structure, "frequency", &_tmp0_);
	freq = _tmp0_;
	_tmp1_ = dvb_scanned_item_new (freq);
	result = _tmp1_;
	return result;
}


static DVBChannel* dvb_terrestrial_scanner_real_get_new_channel (DVBScanner* base) {
	DVBTerrestrialScanner * self;
	DVBChannel* result = NULL;
	DVBTerrestrialChannel* _tmp0_ = NULL;
	self = (DVBTerrestrialScanner*) base;
	_tmp0_ = dvb_terrestrial_channel_new_without_schedule ();
	result = (DVBChannel*) _tmp0_;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void dvb_terrestrial_scanner_real_add_values_from_structure_to_channel (DVBScanner* base, const GstStructure* delivery, DVBChannel* channel) {
	DVBTerrestrialScanner * self;
	DVBTerrestrialChannel* _tmp0_;
	DVBTerrestrialChannel* tc;
	guint freq = 0U;
	guint _tmp1_;
	guint bandwidth = 0U;
	guint _tmp2_;
	DVBDvbSrcBandwidth _tmp3_;
	guint hierarchy = 0U;
	guint _tmp4_;
	DVBDvbSrcHierarchy _tmp5_;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	gchar* constellation;
	DVBDvbSrcModulation _tmp8_;
	const gchar* _tmp9_ = NULL;
	DVBDvbSrcCodeRate _tmp10_;
	const gchar* _tmp11_ = NULL;
	DVBDvbSrcCodeRate _tmp12_;
	guint guard = 0U;
	guint _tmp13_;
	DVBDvbSrcGuard _tmp14_;
	const gchar* _tmp15_ = NULL;
	gchar* _tmp16_;
	gchar* transmode;
	DVBDvbSrcTransmissionMode _tmp17_;
	self = (DVBTerrestrialScanner*) base;
	g_return_if_fail (delivery != NULL);
	g_return_if_fail (channel != NULL);
	if (!DVB_IS_TERRESTRIAL_CHANNEL (channel)) {
		return;
	}
	_tmp0_ = _g_object_ref0 (DVB_TERRESTRIAL_CHANNEL (channel));
	tc = _tmp0_;
	dvb_terrestrial_channel_set_Inversion (tc, DVB_DVB_SRC_INVERSION_INVERSION_AUTO);
	gst_structure_get_uint (delivery, "frequency", &_tmp1_);
	freq = _tmp1_;
	dvb_channel_set_Frequency ((DVBChannel*) tc, freq);
	gst_structure_get_uint (delivery, "bandwidth", &_tmp2_);
	bandwidth = _tmp2_;
	_tmp3_ = dvb_get_bandwidth_val (bandwidth);
	dvb_terrestrial_channel_set_Bandwidth (tc, _tmp3_);
	gst_structure_get_uint (delivery, "hierarchy", &_tmp4_);
	hierarchy = _tmp4_;
	_tmp5_ = dvb_get_hierarchy_val (hierarchy);
	dvb_terrestrial_channel_set_Hierarchy (tc, _tmp5_);
	_tmp6_ = gst_structure_get_string (delivery, "constellation");
	_tmp7_ = g_strdup (_tmp6_);
	constellation = _tmp7_;
	_tmp8_ = dvb_get_modulation_val (constellation);
	dvb_terrestrial_channel_set_Constellation (tc, _tmp8_);
	_tmp9_ = gst_structure_get_string (delivery, "code-rate-hp");
	_tmp10_ = dvb_get_code_rate_val (_tmp9_);
	dvb_terrestrial_channel_set_CodeRateHP (tc, _tmp10_);
	_tmp11_ = gst_structure_get_string (delivery, "code-rate-lp");
	_tmp12_ = dvb_get_code_rate_val (_tmp11_);
	dvb_terrestrial_channel_set_CodeRateLP (tc, _tmp12_);
	gst_structure_get_uint (delivery, "guard-interval", &_tmp13_);
	guard = _tmp13_;
	_tmp14_ = dvb_get_guard_interval_val (guard);
	dvb_terrestrial_channel_set_GuardInterval (tc, _tmp14_);
	_tmp15_ = gst_structure_get_string (delivery, "transmission-mode");
	_tmp16_ = g_strdup (_tmp15_);
	transmode = _tmp16_;
	_tmp17_ = dvb_get_transmission_mode_val (transmode);
	dvb_terrestrial_channel_set_TransmissionMode (tc, _tmp17_);
	_g_free0 (transmode);
	_g_free0 (constellation);
	_g_object_unref0 (tc);
}


static void dvb_terrestrial_scanner_class_init (DVBTerrestrialScannerClass * klass) {
	dvb_terrestrial_scanner_parent_class = g_type_class_peek_parent (klass);
	DVB_SCANNER_CLASS (klass)->add_scanning_data_from_string = dvb_terrestrial_scanner_real_add_scanning_data_from_string;
	DVB_SCANNER_CLASS (klass)->prepare = dvb_terrestrial_scanner_real_prepare;
	DVB_SCANNER_CLASS (klass)->get_scanned_item = dvb_terrestrial_scanner_real_get_scanned_item;
	DVB_SCANNER_CLASS (klass)->get_new_channel = dvb_terrestrial_scanner_real_get_new_channel;
	DVB_SCANNER_CLASS (klass)->add_values_from_structure_to_channel = dvb_terrestrial_scanner_real_add_values_from_structure_to_channel;
}


static void dvb_terrestrial_scanner_dvb_id_bus_scanner_interface_init (DVBIDBusScannerIface * iface) {
	dvb_terrestrial_scanner_dvb_id_bus_scanner_parent_iface = g_type_interface_peek_parent (iface);
	iface->AddScanningData = (gboolean (*)(DVBIDBusScanner* ,GHashTable* ,GError**)) dvb_terrestrial_scanner_real_AddScanningData;
	iface->Run = (void (*)(DVBIDBusScanner* ,GError**)) dvb_scanner_Run;
	iface->Destroy = (void (*)(DVBIDBusScanner* ,GError**)) dvb_scanner_Destroy;
	iface->WriteAllChannelsToFile = (gboolean (*)(DVBIDBusScanner* ,const gchar* ,GError**)) dvb_scanner_WriteAllChannelsToFile;
	iface->WriteChannelsToFile = (gboolean (*)(DVBIDBusScanner* ,guint* ,int ,const gchar* ,GError**)) dvb_scanner_WriteChannelsToFile;
	iface->AddScanningDataFromFile = (gboolean (*)(DVBIDBusScanner* ,const gchar* ,GError**)) dvb_scanner_AddScanningDataFromFile;
}


static void dvb_terrestrial_scanner_instance_init (DVBTerrestrialScanner * self) {
}


GType dvb_terrestrial_scanner_get_type (void) {
	static volatile gsize dvb_terrestrial_scanner_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_terrestrial_scanner_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBTerrestrialScannerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_terrestrial_scanner_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBTerrestrialScanner), 0, (GInstanceInitFunc) dvb_terrestrial_scanner_instance_init, NULL };
		static const GInterfaceInfo dvb_id_bus_scanner_info = { (GInterfaceInitFunc) dvb_terrestrial_scanner_dvb_id_bus_scanner_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType dvb_terrestrial_scanner_type_id;
		dvb_terrestrial_scanner_type_id = g_type_register_static (DVB_TYPE_SCANNER, "DVBTerrestrialScanner", &g_define_type_info, 0);
		g_type_add_interface_static (dvb_terrestrial_scanner_type_id, DVB_TYPE_ID_BUS_SCANNER, &dvb_id_bus_scanner_info);
		g_once_init_leave (&dvb_terrestrial_scanner_type_id__volatile, dvb_terrestrial_scanner_type_id);
	}
	return dvb_terrestrial_scanner_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



