/*
 * Copyright (C) 2008,2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <dbus/dbus.h>
#include <dbus/dbus-glib.h>
#include <dbus/dbus-glib-lowlevel.h>


#define DVB_TYPE_EVENT_INFO (dvb_event_info_get_type ())
typedef struct _DVBEventInfo DVBEventInfo;

#define DVB_TYPE_ID_BUS_SCHEDULE (dvb_id_bus_schedule_get_type ())
#define DVB_ID_BUS_SCHEDULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_ID_BUS_SCHEDULE, DVBIDBusSchedule))
#define DVB_IS_ID_BUS_SCHEDULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_ID_BUS_SCHEDULE))
#define DVB_ID_BUS_SCHEDULE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DVB_TYPE_ID_BUS_SCHEDULE, DVBIDBusScheduleIface))

typedef struct _DVBIDBusSchedule DVBIDBusSchedule;
typedef struct _DVBIDBusScheduleIface DVBIDBusScheduleIface;
typedef struct _DVBIDBusScheduleDBusProxy DVBIDBusScheduleDBusProxy;
typedef DBusGProxyClass DVBIDBusScheduleDBusProxyClass;
typedef struct _DBusObjectVTable _DBusObjectVTable;

struct _DVBEventInfo {
	guint32 id;
	guint32 next;
	char* name;
	guint duration;
	char* short_description;
};

/* public uint[] local_start; */
struct _DVBIDBusScheduleIface {
	GTypeInterface parent_iface;
	guint32* (*GetAllEvents) (DVBIDBusSchedule* self, int* result_length1);
	DVBEventInfo* (*GetAllEventInfos) (DVBIDBusSchedule* self, int* result_length1);
	DVBEventInfo (*GetInformations) (DVBIDBusSchedule* self, guint32 event_id);
	guint32 (*NowPlaying) (DVBIDBusSchedule* self);
	guint32 (*Next) (DVBIDBusSchedule* self, guint32 event_id);
	char* (*GetName) (DVBIDBusSchedule* self, guint32 event_id);
	char* (*GetShortDescription) (DVBIDBusSchedule* self, guint32 event_id);
	char* (*GetExtendedDescription) (DVBIDBusSchedule* self, guint32 event_id);
	guint (*GetDuration) (DVBIDBusSchedule* self, guint32 event_id);
	guint* (*GetLocalStartTime) (DVBIDBusSchedule* self, guint32 event_id, int* result_length1);
	gint64 (*GetLocalStartTimestamp) (DVBIDBusSchedule* self, guint32 event_id);
	gboolean (*IsRunning) (DVBIDBusSchedule* self, guint32 event_id);
	gboolean (*IsScrambled) (DVBIDBusSchedule* self, guint32 event_id);
};

struct _DVBIDBusScheduleDBusProxy {
	DBusGProxy parent_instance;
	gboolean disposed;
};

struct _DBusObjectVTable {
	void (*register_object) (DBusConnection*, const char*, void*);
};



GType dvb_event_info_get_type (void);
DVBEventInfo* dvb_event_info_dup (const DVBEventInfo* self);
void dvb_event_info_free (DVBEventInfo* self);
void dvb_event_info_copy (const DVBEventInfo* self, DVBEventInfo* dest);
void dvb_event_info_destroy (DVBEventInfo* self);
GType dvb_id_bus_schedule_get_type (void);
guint32* dvb_id_bus_schedule_GetAllEvents (DVBIDBusSchedule* self, int* result_length1);
DVBEventInfo* dvb_id_bus_schedule_GetAllEventInfos (DVBIDBusSchedule* self, int* result_length1);
DVBEventInfo dvb_id_bus_schedule_GetInformations (DVBIDBusSchedule* self, guint32 event_id);
guint32 dvb_id_bus_schedule_NowPlaying (DVBIDBusSchedule* self);
guint32 dvb_id_bus_schedule_Next (DVBIDBusSchedule* self, guint32 event_id);
char* dvb_id_bus_schedule_GetName (DVBIDBusSchedule* self, guint32 event_id);
char* dvb_id_bus_schedule_GetShortDescription (DVBIDBusSchedule* self, guint32 event_id);
char* dvb_id_bus_schedule_GetExtendedDescription (DVBIDBusSchedule* self, guint32 event_id);
guint dvb_id_bus_schedule_GetDuration (DVBIDBusSchedule* self, guint32 event_id);
guint* dvb_id_bus_schedule_GetLocalStartTime (DVBIDBusSchedule* self, guint32 event_id, int* result_length1);
gint64 dvb_id_bus_schedule_GetLocalStartTimestamp (DVBIDBusSchedule* self, guint32 event_id);
gboolean dvb_id_bus_schedule_IsRunning (DVBIDBusSchedule* self, guint32 event_id);
gboolean dvb_id_bus_schedule_IsScrambled (DVBIDBusSchedule* self, guint32 event_id);
void dvb_id_bus_schedule_dbus_register_object (DBusConnection* connection, const char* path, void* object);
void _dvb_id_bus_schedule_dbus_unregister (DBusConnection* connection, void* user_data);
DBusHandlerResult dvb_id_bus_schedule_dbus_message (DBusConnection* connection, DBusMessage* message, void* object);
static DBusMessage* _dbus_dvb_id_bus_schedule_introspect (DVBIDBusSchedule* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_schedule_property_get_all (DVBIDBusSchedule* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_schedule_GetAllEvents (DVBIDBusSchedule* self, DBusConnection* connection, DBusMessage* message);
static void _vala_DVBEventInfo_array_free (DVBEventInfo* array, gint array_length);
static DBusMessage* _dbus_dvb_id_bus_schedule_GetAllEventInfos (DVBIDBusSchedule* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_schedule_GetInformations (DVBIDBusSchedule* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_schedule_NowPlaying (DVBIDBusSchedule* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_schedule_Next (DVBIDBusSchedule* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_schedule_GetName (DVBIDBusSchedule* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_schedule_GetShortDescription (DVBIDBusSchedule* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_schedule_GetExtendedDescription (DVBIDBusSchedule* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_schedule_GetDuration (DVBIDBusSchedule* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_schedule_GetLocalStartTime (DVBIDBusSchedule* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_schedule_GetLocalStartTimestamp (DVBIDBusSchedule* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_schedule_IsRunning (DVBIDBusSchedule* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_schedule_IsScrambled (DVBIDBusSchedule* self, DBusConnection* connection, DBusMessage* message);
GType dvb_id_bus_schedule_dbus_proxy_get_type (void);
DVBIDBusSchedule* dvb_id_bus_schedule_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path);
DBusHandlerResult dvb_id_bus_schedule_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data);
enum  {
	DVB_ID_BUS_SCHEDULE_DBUS_PROXY_DUMMY_PROPERTY
};
static guint32* dvb_id_bus_schedule_dbus_proxy_GetAllEvents (DVBIDBusSchedule* self, int* result_length1);
static DVBEventInfo* dvb_id_bus_schedule_dbus_proxy_GetAllEventInfos (DVBIDBusSchedule* self, int* result_length1);
static DVBEventInfo dvb_id_bus_schedule_dbus_proxy_GetInformations (DVBIDBusSchedule* self, guint32 event_id);
static guint32 dvb_id_bus_schedule_dbus_proxy_NowPlaying (DVBIDBusSchedule* self);
static guint32 dvb_id_bus_schedule_dbus_proxy_Next (DVBIDBusSchedule* self, guint32 event_id);
static char* dvb_id_bus_schedule_dbus_proxy_GetName (DVBIDBusSchedule* self, guint32 event_id);
static char* dvb_id_bus_schedule_dbus_proxy_GetShortDescription (DVBIDBusSchedule* self, guint32 event_id);
static char* dvb_id_bus_schedule_dbus_proxy_GetExtendedDescription (DVBIDBusSchedule* self, guint32 event_id);
static guint dvb_id_bus_schedule_dbus_proxy_GetDuration (DVBIDBusSchedule* self, guint32 event_id);
static guint* dvb_id_bus_schedule_dbus_proxy_GetLocalStartTime (DVBIDBusSchedule* self, guint32 event_id, int* result_length1);
static gint64 dvb_id_bus_schedule_dbus_proxy_GetLocalStartTimestamp (DVBIDBusSchedule* self, guint32 event_id);
static gboolean dvb_id_bus_schedule_dbus_proxy_IsRunning (DVBIDBusSchedule* self, guint32 event_id);
static gboolean dvb_id_bus_schedule_dbus_proxy_IsScrambled (DVBIDBusSchedule* self, guint32 event_id);
static void dvb_id_bus_schedule_dbus_proxy_interface_init (DVBIDBusScheduleIface* iface);
static void dvb_id_bus_schedule_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void dvb_id_bus_schedule_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object);
static void _vala_dbus_unregister_object (gpointer connection, GObject* object);

static const DBusObjectPathVTable _dvb_id_bus_schedule_dbus_path_vtable = {_dvb_id_bus_schedule_dbus_unregister, dvb_id_bus_schedule_dbus_message};
static const _DBusObjectVTable _dvb_id_bus_schedule_dbus_vtable = {dvb_id_bus_schedule_dbus_register_object};


void dvb_event_info_copy (const DVBEventInfo* self, DVBEventInfo* dest) {
	const char* _tmp1_;
	const char* _tmp0_;
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	dest->id = self->id;
	dest->next = self->next;
	dest->name = (_tmp0_ = self->name, (_tmp0_ == NULL) ? NULL : g_strdup (_tmp0_));
	dest->duration = self->duration;
	dest->short_description = (_tmp1_ = self->short_description, (_tmp1_ == NULL) ? NULL : g_strdup (_tmp1_));
}


void dvb_event_info_destroy (DVBEventInfo* self) {
	self->name = (g_free (self->name), NULL);
	self->short_description = (g_free (self->short_description), NULL);
}


DVBEventInfo* dvb_event_info_dup (const DVBEventInfo* self) {
	DVBEventInfo* dup;
	dup = g_new0 (DVBEventInfo, 1);
	dvb_event_info_copy (self, dup);
	return dup;
}


void dvb_event_info_free (DVBEventInfo* self) {
	dvb_event_info_destroy (self);
	g_free (self);
}


GType dvb_event_info_get_type (void) {
	static GType dvb_event_info_type_id = 0;
	if (dvb_event_info_type_id == 0) {
		dvb_event_info_type_id = g_boxed_type_register_static ("DVBEventInfo", (GBoxedCopyFunc) dvb_event_info_dup, (GBoxedFreeFunc) dvb_event_info_free);
	}
	return dvb_event_info_type_id;
}


guint32* dvb_id_bus_schedule_GetAllEvents (DVBIDBusSchedule* self, int* result_length1) {
	return DVB_ID_BUS_SCHEDULE_GET_INTERFACE (self)->GetAllEvents (self, result_length1);
}


DVBEventInfo* dvb_id_bus_schedule_GetAllEventInfos (DVBIDBusSchedule* self, int* result_length1) {
	return DVB_ID_BUS_SCHEDULE_GET_INTERFACE (self)->GetAllEventInfos (self, result_length1);
}


DVBEventInfo dvb_id_bus_schedule_GetInformations (DVBIDBusSchedule* self, guint32 event_id) {
	return DVB_ID_BUS_SCHEDULE_GET_INTERFACE (self)->GetInformations (self, event_id);
}


/**
         * @returns: ID of currently running event
         */
guint32 dvb_id_bus_schedule_NowPlaying (DVBIDBusSchedule* self) {
	return DVB_ID_BUS_SCHEDULE_GET_INTERFACE (self)->NowPlaying (self);
}


/**
         * @returnns: ID of event that follows the given event
         */
guint32 dvb_id_bus_schedule_Next (DVBIDBusSchedule* self, guint32 event_id) {
	return DVB_ID_BUS_SCHEDULE_GET_INTERFACE (self)->Next (self, event_id);
}


char* dvb_id_bus_schedule_GetName (DVBIDBusSchedule* self, guint32 event_id) {
	return DVB_ID_BUS_SCHEDULE_GET_INTERFACE (self)->GetName (self, event_id);
}


char* dvb_id_bus_schedule_GetShortDescription (DVBIDBusSchedule* self, guint32 event_id) {
	return DVB_ID_BUS_SCHEDULE_GET_INTERFACE (self)->GetShortDescription (self, event_id);
}


char* dvb_id_bus_schedule_GetExtendedDescription (DVBIDBusSchedule* self, guint32 event_id) {
	return DVB_ID_BUS_SCHEDULE_GET_INTERFACE (self)->GetExtendedDescription (self, event_id);
}


guint dvb_id_bus_schedule_GetDuration (DVBIDBusSchedule* self, guint32 event_id) {
	return DVB_ID_BUS_SCHEDULE_GET_INTERFACE (self)->GetDuration (self, event_id);
}


guint* dvb_id_bus_schedule_GetLocalStartTime (DVBIDBusSchedule* self, guint32 event_id, int* result_length1) {
	return DVB_ID_BUS_SCHEDULE_GET_INTERFACE (self)->GetLocalStartTime (self, event_id, result_length1);
}


gint64 dvb_id_bus_schedule_GetLocalStartTimestamp (DVBIDBusSchedule* self, guint32 event_id) {
	return DVB_ID_BUS_SCHEDULE_GET_INTERFACE (self)->GetLocalStartTimestamp (self, event_id);
}


gboolean dvb_id_bus_schedule_IsRunning (DVBIDBusSchedule* self, guint32 event_id) {
	return DVB_ID_BUS_SCHEDULE_GET_INTERFACE (self)->IsRunning (self, event_id);
}


gboolean dvb_id_bus_schedule_IsScrambled (DVBIDBusSchedule* self, guint32 event_id) {
	return DVB_ID_BUS_SCHEDULE_GET_INTERFACE (self)->IsScrambled (self, event_id);
}


void _dvb_id_bus_schedule_dbus_unregister (DBusConnection* connection, void* user_data) {
}


static DBusMessage* _dbus_dvb_id_bus_schedule_introspect (DVBIDBusSchedule* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter;
	GString* xml_data;
	char** children;
	int i;
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	xml_data = g_string_new ("<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\" \"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n");
	g_string_append (xml_data, "<node>\n<interface name=\"org.freedesktop.DBus.Introspectable\">\n  <method name=\"Introspect\">\n    <arg name=\"data\" direction=\"out\" type=\"s\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DBus.Properties\">\n  <method name=\"Get\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"out\" type=\"v\"/>\n  </method>\n  <method name=\"Set\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"in\" type=\"v\"/>\n  </method>\n  <method name=\"GetAll\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"props\" direction=\"out\" type=\"a{sv}\"/>\n  </method>\n</interface>\n<interface name=\"org.gnome.DVB.Schedule\">\n  <method name=\"GetAllEvents\">\n    <arg name=\"result\" type=\"au\" direction=\"out\"/>\n  </method>\n  <method name=\"GetAllEventInfos\">\n    <arg name=\"result\" type=\"a(uusus)\" direction=\"out\"/>\n  </method>\n  <method name=\"GetInformations\">\n    <arg name=\"event_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"(uusus)\" direction=\"out\"/>\n  </method>\n  <method name=\"NowPlaying\">\n    <arg name=\"result\" type=\"u\" direction=\"out\"/>\n  </method>\n  <method name=\"Next\">\n    <arg name=\"event_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"u\" direction=\"out\"/>\n  </method>\n  <method name=\"GetName\">\n    <arg name=\"event_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"s\" direction=\"out\"/>\n  </method>\n  <method name=\"GetShortDescription\">\n    <arg name=\"event_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"s\" direction=\"out\"/>\n  </method>\n  <method name=\"GetExtendedDescription\">\n    <arg name=\"event_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"s\" direction=\"out\"/>\n  </method>\n  <method name=\"GetDuration\">\n    <arg name=\"event_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"u\" direction=\"out\"/>\n  </method>\n  <method name=\"GetLocalStartTime\">\n    <arg name=\"event_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"au\" direction=\"out\"/>\n  </method>\n  <method name=\"GetLocalStartTimestamp\">\n    <arg name=\"event_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"x\" direction=\"out\"/>\n  </method>\n  <method name=\"IsRunning\">\n    <arg name=\"event_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <method name=\"IsScrambled\">\n    <arg name=\"event_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n</interface>\n");
	dbus_connection_list_registered (connection, g_object_get_data ((GObject *) self, "dbus_object_path"), &children);
	for (i = 0; children[i]; i++) {
		g_string_append_printf (xml_data, "<node name=\"%s\"/>\n", children[i]);
	}
	dbus_free_string_array (children);
	g_string_append (xml_data, "</node>\n");
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &xml_data->str);
	g_string_free (xml_data, TRUE);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_schedule_property_get_all (DVBIDBusSchedule* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter, reply_iter, subiter;
	char* interface_name;
	const char* _tmp2_;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &reply_iter);
	dbus_message_iter_get_basic (&iter, &_tmp2_);
	dbus_message_iter_next (&iter);
	interface_name = g_strdup (_tmp2_);
	if (strcmp (interface_name, "org.gnome.DVB.Schedule") == 0) {
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_ARRAY, "{sv}", &subiter);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else {
		dbus_message_unref (reply);
		reply = NULL;
	}
	g_free (interface_name);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_schedule_GetAllEvents (DVBIDBusSchedule* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	int result_length1;
	guint32* result;
	DBusMessage* reply;
	guint32* _tmp3_;
	DBusMessageIter _tmp4_;
	int _tmp5_;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	result_length1 = 0;
	result = dvb_id_bus_schedule_GetAllEvents (self, &result_length1);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp3_ = result;
	dbus_message_iter_open_container (&iter, DBUS_TYPE_ARRAY, "u", &_tmp4_);
	for (_tmp5_ = 0; _tmp5_ < result_length1; _tmp5_++) {
		dbus_uint32_t _tmp6_;
		_tmp6_ = *_tmp3_;
		dbus_message_iter_append_basic (&_tmp4_, DBUS_TYPE_UINT32, &_tmp6_);
		_tmp3_++;
	}
	dbus_message_iter_close_container (&iter, &_tmp4_);
	result = (g_free (result), NULL);
	return reply;
}


static void _vala_DVBEventInfo_array_free (DVBEventInfo* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			dvb_event_info_destroy (&array[i]);
		}
	}
	g_free (array);
}


static DBusMessage* _dbus_dvb_id_bus_schedule_GetAllEventInfos (DVBIDBusSchedule* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	int result_length1;
	DVBEventInfo* result;
	DBusMessage* reply;
	DVBEventInfo* _tmp7_;
	DBusMessageIter _tmp8_;
	int _tmp9_;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	result_length1 = 0;
	result = dvb_id_bus_schedule_GetAllEventInfos (self, &result_length1);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp7_ = result;
	dbus_message_iter_open_container (&iter, DBUS_TYPE_ARRAY, "(uusus)", &_tmp8_);
	for (_tmp9_ = 0; _tmp9_ < result_length1; _tmp9_++) {
		DBusMessageIter _tmp10_;
		dbus_uint32_t _tmp11_;
		dbus_uint32_t _tmp12_;
		const char* _tmp13_;
		dbus_uint32_t _tmp14_;
		const char* _tmp15_;
		dbus_message_iter_open_container (&_tmp8_, DBUS_TYPE_STRUCT, NULL, &_tmp10_);
		_tmp11_ = (*_tmp7_).id;
		dbus_message_iter_append_basic (&_tmp10_, DBUS_TYPE_UINT32, &_tmp11_);
		_tmp12_ = (*_tmp7_).next;
		dbus_message_iter_append_basic (&_tmp10_, DBUS_TYPE_UINT32, &_tmp12_);
		_tmp13_ = (*_tmp7_).name;
		dbus_message_iter_append_basic (&_tmp10_, DBUS_TYPE_STRING, &_tmp13_);
		_tmp14_ = (*_tmp7_).duration;
		dbus_message_iter_append_basic (&_tmp10_, DBUS_TYPE_UINT32, &_tmp14_);
		_tmp15_ = (*_tmp7_).short_description;
		dbus_message_iter_append_basic (&_tmp10_, DBUS_TYPE_STRING, &_tmp15_);
		dbus_message_iter_close_container (&_tmp8_, &_tmp10_);
		_tmp7_++;
	}
	dbus_message_iter_close_container (&iter, &_tmp8_);
	result = (_vala_DVBEventInfo_array_free (result,  result_length1), NULL);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_schedule_GetInformations (DVBIDBusSchedule* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	guint32 event_id;
	dbus_uint32_t _tmp16_;
	DVBEventInfo result;
	DBusMessage* reply;
	DBusMessageIter _tmp17_;
	dbus_uint32_t _tmp18_;
	dbus_uint32_t _tmp19_;
	const char* _tmp20_;
	dbus_uint32_t _tmp21_;
	const char* _tmp22_;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "u")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	event_id = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp16_);
	dbus_message_iter_next (&iter);
	event_id = _tmp16_;
	result = dvb_id_bus_schedule_GetInformations (self, event_id);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	dbus_message_iter_open_container (&iter, DBUS_TYPE_STRUCT, NULL, &_tmp17_);
	_tmp18_ = result.id;
	dbus_message_iter_append_basic (&_tmp17_, DBUS_TYPE_UINT32, &_tmp18_);
	_tmp19_ = result.next;
	dbus_message_iter_append_basic (&_tmp17_, DBUS_TYPE_UINT32, &_tmp19_);
	_tmp20_ = result.name;
	dbus_message_iter_append_basic (&_tmp17_, DBUS_TYPE_STRING, &_tmp20_);
	_tmp21_ = result.duration;
	dbus_message_iter_append_basic (&_tmp17_, DBUS_TYPE_UINT32, &_tmp21_);
	_tmp22_ = result.short_description;
	dbus_message_iter_append_basic (&_tmp17_, DBUS_TYPE_STRING, &_tmp22_);
	dbus_message_iter_close_container (&iter, &_tmp17_);
	dvb_event_info_destroy (&result);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_schedule_NowPlaying (DVBIDBusSchedule* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	guint32 result;
	DBusMessage* reply;
	dbus_uint32_t _tmp23_;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	result = dvb_id_bus_schedule_NowPlaying (self);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp23_ = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_UINT32, &_tmp23_);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_schedule_Next (DVBIDBusSchedule* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	guint32 event_id;
	dbus_uint32_t _tmp24_;
	guint32 result;
	DBusMessage* reply;
	dbus_uint32_t _tmp25_;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "u")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	event_id = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp24_);
	dbus_message_iter_next (&iter);
	event_id = _tmp24_;
	result = dvb_id_bus_schedule_Next (self, event_id);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp25_ = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_UINT32, &_tmp25_);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_schedule_GetName (DVBIDBusSchedule* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	guint32 event_id;
	dbus_uint32_t _tmp26_;
	char* result;
	DBusMessage* reply;
	const char* _tmp27_;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "u")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	event_id = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp26_);
	dbus_message_iter_next (&iter);
	event_id = _tmp26_;
	result = dvb_id_bus_schedule_GetName (self, event_id);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp27_ = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &_tmp27_);
	result = (g_free (result), NULL);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_schedule_GetShortDescription (DVBIDBusSchedule* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	guint32 event_id;
	dbus_uint32_t _tmp28_;
	char* result;
	DBusMessage* reply;
	const char* _tmp29_;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "u")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	event_id = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp28_);
	dbus_message_iter_next (&iter);
	event_id = _tmp28_;
	result = dvb_id_bus_schedule_GetShortDescription (self, event_id);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp29_ = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &_tmp29_);
	result = (g_free (result), NULL);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_schedule_GetExtendedDescription (DVBIDBusSchedule* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	guint32 event_id;
	dbus_uint32_t _tmp30_;
	char* result;
	DBusMessage* reply;
	const char* _tmp31_;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "u")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	event_id = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp30_);
	dbus_message_iter_next (&iter);
	event_id = _tmp30_;
	result = dvb_id_bus_schedule_GetExtendedDescription (self, event_id);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp31_ = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &_tmp31_);
	result = (g_free (result), NULL);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_schedule_GetDuration (DVBIDBusSchedule* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	guint32 event_id;
	dbus_uint32_t _tmp32_;
	guint result;
	DBusMessage* reply;
	dbus_uint32_t _tmp33_;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "u")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	event_id = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp32_);
	dbus_message_iter_next (&iter);
	event_id = _tmp32_;
	result = dvb_id_bus_schedule_GetDuration (self, event_id);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp33_ = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_UINT32, &_tmp33_);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_schedule_GetLocalStartTime (DVBIDBusSchedule* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	guint32 event_id;
	dbus_uint32_t _tmp34_;
	int result_length1;
	guint* result;
	DBusMessage* reply;
	guint* _tmp35_;
	DBusMessageIter _tmp36_;
	int _tmp37_;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "u")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	event_id = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp34_);
	dbus_message_iter_next (&iter);
	event_id = _tmp34_;
	result_length1 = 0;
	result = dvb_id_bus_schedule_GetLocalStartTime (self, event_id, &result_length1);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp35_ = result;
	dbus_message_iter_open_container (&iter, DBUS_TYPE_ARRAY, "u", &_tmp36_);
	for (_tmp37_ = 0; _tmp37_ < result_length1; _tmp37_++) {
		dbus_uint32_t _tmp38_;
		_tmp38_ = *_tmp35_;
		dbus_message_iter_append_basic (&_tmp36_, DBUS_TYPE_UINT32, &_tmp38_);
		_tmp35_++;
	}
	dbus_message_iter_close_container (&iter, &_tmp36_);
	result = (g_free (result), NULL);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_schedule_GetLocalStartTimestamp (DVBIDBusSchedule* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	guint32 event_id;
	dbus_uint32_t _tmp39_;
	gint64 result;
	DBusMessage* reply;
	dbus_int64_t _tmp40_;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "u")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	event_id = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp39_);
	dbus_message_iter_next (&iter);
	event_id = _tmp39_;
	result = dvb_id_bus_schedule_GetLocalStartTimestamp (self, event_id);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp40_ = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_INT64, &_tmp40_);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_schedule_IsRunning (DVBIDBusSchedule* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	guint32 event_id;
	dbus_uint32_t _tmp41_;
	gboolean result;
	DBusMessage* reply;
	dbus_bool_t _tmp42_;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "u")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	event_id = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp41_);
	dbus_message_iter_next (&iter);
	event_id = _tmp41_;
	result = dvb_id_bus_schedule_IsRunning (self, event_id);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp42_ = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_BOOLEAN, &_tmp42_);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_schedule_IsScrambled (DVBIDBusSchedule* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	guint32 event_id;
	dbus_uint32_t _tmp43_;
	gboolean result;
	DBusMessage* reply;
	dbus_bool_t _tmp44_;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "u")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	event_id = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp43_);
	dbus_message_iter_next (&iter);
	event_id = _tmp43_;
	result = dvb_id_bus_schedule_IsScrambled (self, event_id);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp44_ = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_BOOLEAN, &_tmp44_);
	return reply;
}


DBusHandlerResult dvb_id_bus_schedule_dbus_message (DBusConnection* connection, DBusMessage* message, void* object) {
	DBusMessage* reply;
	reply = NULL;
	if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Introspectable", "Introspect")) {
		reply = _dbus_dvb_id_bus_schedule_introspect (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Properties", "GetAll")) {
		reply = _dbus_dvb_id_bus_schedule_property_get_all (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.Schedule", "GetAllEvents")) {
		reply = _dbus_dvb_id_bus_schedule_GetAllEvents (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.Schedule", "GetAllEventInfos")) {
		reply = _dbus_dvb_id_bus_schedule_GetAllEventInfos (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.Schedule", "GetInformations")) {
		reply = _dbus_dvb_id_bus_schedule_GetInformations (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.Schedule", "NowPlaying")) {
		reply = _dbus_dvb_id_bus_schedule_NowPlaying (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.Schedule", "Next")) {
		reply = _dbus_dvb_id_bus_schedule_Next (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.Schedule", "GetName")) {
		reply = _dbus_dvb_id_bus_schedule_GetName (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.Schedule", "GetShortDescription")) {
		reply = _dbus_dvb_id_bus_schedule_GetShortDescription (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.Schedule", "GetExtendedDescription")) {
		reply = _dbus_dvb_id_bus_schedule_GetExtendedDescription (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.Schedule", "GetDuration")) {
		reply = _dbus_dvb_id_bus_schedule_GetDuration (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.Schedule", "GetLocalStartTime")) {
		reply = _dbus_dvb_id_bus_schedule_GetLocalStartTime (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.Schedule", "GetLocalStartTimestamp")) {
		reply = _dbus_dvb_id_bus_schedule_GetLocalStartTimestamp (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.Schedule", "IsRunning")) {
		reply = _dbus_dvb_id_bus_schedule_IsRunning (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.Schedule", "IsScrambled")) {
		reply = _dbus_dvb_id_bus_schedule_IsScrambled (object, connection, message);
	}
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


void dvb_id_bus_schedule_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	if (!g_object_get_data (object, "dbus_object_path")) {
		g_object_set_data (object, "dbus_object_path", g_strdup (path));
		dbus_connection_register_object_path (connection, path, &_dvb_id_bus_schedule_dbus_path_vtable, object);
		g_object_weak_ref (object, _vala_dbus_unregister_object, connection);
	}
}


static void dvb_id_bus_schedule_base_init (DVBIDBusScheduleIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_type_set_qdata (DVB_TYPE_ID_BUS_SCHEDULE, g_quark_from_static_string ("DBusObjectVTable"), (void*) (&_dvb_id_bus_schedule_dbus_vtable));
	}
}


GType dvb_id_bus_schedule_get_type (void) {
	static GType dvb_id_bus_schedule_type_id = 0;
	if (dvb_id_bus_schedule_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBIDBusScheduleIface), (GBaseInitFunc) dvb_id_bus_schedule_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		dvb_id_bus_schedule_type_id = g_type_register_static (G_TYPE_INTERFACE, "DVBIDBusSchedule", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (dvb_id_bus_schedule_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (dvb_id_bus_schedule_type_id, g_quark_from_string ("ValaDBusInterfaceProxyType"), &dvb_id_bus_schedule_dbus_proxy_get_type);
	}
	return dvb_id_bus_schedule_type_id;
}


G_DEFINE_TYPE_EXTENDED (DVBIDBusScheduleDBusProxy, dvb_id_bus_schedule_dbus_proxy, DBUS_TYPE_G_PROXY, 0, G_IMPLEMENT_INTERFACE (DVB_TYPE_ID_BUS_SCHEDULE, dvb_id_bus_schedule_dbus_proxy_interface_init));
DVBIDBusSchedule* dvb_id_bus_schedule_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path) {
	DVBIDBusSchedule* self;
	self = g_object_new (dvb_id_bus_schedule_dbus_proxy_get_type (), "connection", connection, "name", name, "path", path, "interface", "org.gnome.DVB.Schedule", NULL);
	return self;
}


static GObject* dvb_id_bus_schedule_dbus_proxy_construct (GType gtype, guint n_properties, GObjectConstructParam* properties) {
	GObject* self;
	DBusGConnection *connection;
	char* path;
	char* filter;
	self = G_OBJECT_CLASS (dvb_id_bus_schedule_dbus_proxy_parent_class)->constructor (gtype, n_properties, properties);
	g_object_get (self, "connection", &connection, NULL);
	g_object_get (self, "path", &path, NULL);
	dbus_connection_add_filter (dbus_g_connection_get_connection (connection), dvb_id_bus_schedule_dbus_proxy_filter, self, NULL);
	filter = g_strdup_printf ("type='signal',path='%s'", path);
	dbus_bus_add_match (dbus_g_connection_get_connection (connection), filter, NULL);
	dbus_g_connection_unref (connection);
	g_free (path);
	g_free (filter);
	return self;
}


DBusHandlerResult dvb_id_bus_schedule_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data) {
	if (dbus_message_has_path (message, dbus_g_proxy_get_path (user_data))) {
	}
	return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
}


static void dvb_id_bus_schedule_dbus_proxy_dispose (GObject* self) {
	DBusGConnection *connection;
	if (((DVBIDBusScheduleDBusProxy*) self)->disposed) {
		return;
	}
	((DVBIDBusScheduleDBusProxy*) self)->disposed = TRUE;
	g_object_get (self, "connection", &connection, NULL);
	dbus_connection_remove_filter (dbus_g_connection_get_connection (connection), dvb_id_bus_schedule_dbus_proxy_filter, self);
	G_OBJECT_CLASS (dvb_id_bus_schedule_dbus_proxy_parent_class)->dispose (self);
}


static void dvb_id_bus_schedule_dbus_proxy_class_init (DVBIDBusScheduleDBusProxyClass* klass) {
	G_OBJECT_CLASS (klass)->constructor = dvb_id_bus_schedule_dbus_proxy_construct;
	G_OBJECT_CLASS (klass)->dispose = dvb_id_bus_schedule_dbus_proxy_dispose;
	G_OBJECT_CLASS (klass)->get_property = dvb_id_bus_schedule_dbus_proxy_get_property;
	G_OBJECT_CLASS (klass)->set_property = dvb_id_bus_schedule_dbus_proxy_set_property;
}


static void dvb_id_bus_schedule_dbus_proxy_init (DVBIDBusScheduleDBusProxy* self) {
}


static guint32* dvb_id_bus_schedule_dbus_proxy_GetAllEvents (DVBIDBusSchedule* self, int* result_length1) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	guint32* _result;
	int _result_length1;
	guint32* _tmp45_;
	int _tmp45__length;
	int _tmp45__size;
	int _tmp45__length1;
	DBusMessageIter _tmp46_;
	if (((DVBIDBusScheduleDBusProxy*) self)->disposed) {
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.Schedule", "GetAllEvents");
	dbus_message_iter_init_append (_message, &_iter);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	_result_length1 = 0;
	_tmp45_ = g_new (guint32, 5);
	_tmp45__length = 0;
	_tmp45__size = 4;
	_tmp45__length1 = 0;
	dbus_message_iter_recurse (&_iter, &_tmp46_);
	for (; dbus_message_iter_get_arg_type (&_tmp46_); _tmp45__length1++) {
		dbus_uint32_t _tmp47_;
		if (_tmp45__size == _tmp45__length) {
			_tmp45__size = 2 * _tmp45__size;
			_tmp45_ = g_renew (guint32, _tmp45_, _tmp45__size + 1);
		}
		dbus_message_iter_get_basic (&_tmp46_, &_tmp47_);
		dbus_message_iter_next (&_tmp46_);
		_tmp45_[_tmp45__length++] = _tmp47_;
	}
	_result_length1 = _tmp45__length1;
	dbus_message_iter_next (&_iter);
	_result = _tmp45_;
	*result_length1 = _result_length1;
	dbus_message_unref (_reply);
	return _result;
}


static DVBEventInfo* dvb_id_bus_schedule_dbus_proxy_GetAllEventInfos (DVBIDBusSchedule* self, int* result_length1) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	DVBEventInfo* _result;
	int _result_length1;
	DVBEventInfo* _tmp48_;
	int _tmp48__length;
	int _tmp48__size;
	int _tmp48__length1;
	DBusMessageIter _tmp49_;
	if (((DVBIDBusScheduleDBusProxy*) self)->disposed) {
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.Schedule", "GetAllEventInfos");
	dbus_message_iter_init_append (_message, &_iter);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	_result_length1 = 0;
	_tmp48_ = g_new (DVBEventInfo, 5);
	_tmp48__length = 0;
	_tmp48__size = 4;
	_tmp48__length1 = 0;
	dbus_message_iter_recurse (&_iter, &_tmp49_);
	for (; dbus_message_iter_get_arg_type (&_tmp49_); _tmp48__length1++) {
		DVBEventInfo _tmp50_;
		DBusMessageIter _tmp51_;
		dbus_uint32_t _tmp52_;
		dbus_uint32_t _tmp53_;
		const char* _tmp54_;
		dbus_uint32_t _tmp55_;
		const char* _tmp56_;
		if (_tmp48__size == _tmp48__length) {
			_tmp48__size = 2 * _tmp48__size;
			_tmp48_ = g_renew (DVBEventInfo, _tmp48_, _tmp48__size + 1);
		}
		dbus_message_iter_recurse (&_tmp49_, &_tmp51_);
		dbus_message_iter_get_basic (&_tmp51_, &_tmp52_);
		dbus_message_iter_next (&_tmp51_);
		_tmp50_.id = _tmp52_;
		dbus_message_iter_get_basic (&_tmp51_, &_tmp53_);
		dbus_message_iter_next (&_tmp51_);
		_tmp50_.next = _tmp53_;
		dbus_message_iter_get_basic (&_tmp51_, &_tmp54_);
		dbus_message_iter_next (&_tmp51_);
		_tmp50_.name = g_strdup (_tmp54_);
		dbus_message_iter_get_basic (&_tmp51_, &_tmp55_);
		dbus_message_iter_next (&_tmp51_);
		_tmp50_.duration = _tmp55_;
		dbus_message_iter_get_basic (&_tmp51_, &_tmp56_);
		dbus_message_iter_next (&_tmp51_);
		_tmp50_.short_description = g_strdup (_tmp56_);
		dbus_message_iter_next (&_tmp49_);
		_tmp48_[_tmp48__length++] = _tmp50_;
	}
	_result_length1 = _tmp48__length1;
	dbus_message_iter_next (&_iter);
	_result = _tmp48_;
	*result_length1 = _result_length1;
	dbus_message_unref (_reply);
	return _result;
}


static DVBEventInfo dvb_id_bus_schedule_dbus_proxy_GetInformations (DVBIDBusSchedule* self, guint32 event_id) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp57_;
	DVBEventInfo _result;
	DVBEventInfo _tmp58_;
	DBusMessageIter _tmp59_;
	dbus_uint32_t _tmp60_;
	dbus_uint32_t _tmp61_;
	const char* _tmp62_;
	dbus_uint32_t _tmp63_;
	const char* _tmp64_;
	if (((DVBIDBusScheduleDBusProxy*) self)->disposed) {
		return;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.Schedule", "GetInformations");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp57_ = event_id;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp57_);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_recurse (&_iter, &_tmp59_);
	dbus_message_iter_get_basic (&_tmp59_, &_tmp60_);
	dbus_message_iter_next (&_tmp59_);
	_tmp58_.id = _tmp60_;
	dbus_message_iter_get_basic (&_tmp59_, &_tmp61_);
	dbus_message_iter_next (&_tmp59_);
	_tmp58_.next = _tmp61_;
	dbus_message_iter_get_basic (&_tmp59_, &_tmp62_);
	dbus_message_iter_next (&_tmp59_);
	_tmp58_.name = g_strdup (_tmp62_);
	dbus_message_iter_get_basic (&_tmp59_, &_tmp63_);
	dbus_message_iter_next (&_tmp59_);
	_tmp58_.duration = _tmp63_;
	dbus_message_iter_get_basic (&_tmp59_, &_tmp64_);
	dbus_message_iter_next (&_tmp59_);
	_tmp58_.short_description = g_strdup (_tmp64_);
	dbus_message_iter_next (&_iter);
	_result = _tmp58_;
	dbus_message_unref (_reply);
	return _result;
}


static guint32 dvb_id_bus_schedule_dbus_proxy_NowPlaying (DVBIDBusSchedule* self) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	guint32 _result;
	dbus_uint32_t _tmp65_;
	if (((DVBIDBusScheduleDBusProxy*) self)->disposed) {
		return 0U;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.Schedule", "NowPlaying");
	dbus_message_iter_init_append (_message, &_iter);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp65_);
	dbus_message_iter_next (&_iter);
	_result = _tmp65_;
	dbus_message_unref (_reply);
	return _result;
}


static guint32 dvb_id_bus_schedule_dbus_proxy_Next (DVBIDBusSchedule* self, guint32 event_id) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp66_;
	guint32 _result;
	dbus_uint32_t _tmp67_;
	if (((DVBIDBusScheduleDBusProxy*) self)->disposed) {
		return 0U;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.Schedule", "Next");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp66_ = event_id;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp66_);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp67_);
	dbus_message_iter_next (&_iter);
	_result = _tmp67_;
	dbus_message_unref (_reply);
	return _result;
}


static char* dvb_id_bus_schedule_dbus_proxy_GetName (DVBIDBusSchedule* self, guint32 event_id) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp68_;
	char* _result;
	const char* _tmp69_;
	if (((DVBIDBusScheduleDBusProxy*) self)->disposed) {
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.Schedule", "GetName");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp68_ = event_id;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp68_);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp69_);
	dbus_message_iter_next (&_iter);
	_result = g_strdup (_tmp69_);
	dbus_message_unref (_reply);
	return _result;
}


static char* dvb_id_bus_schedule_dbus_proxy_GetShortDescription (DVBIDBusSchedule* self, guint32 event_id) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp70_;
	char* _result;
	const char* _tmp71_;
	if (((DVBIDBusScheduleDBusProxy*) self)->disposed) {
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.Schedule", "GetShortDescription");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp70_ = event_id;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp70_);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp71_);
	dbus_message_iter_next (&_iter);
	_result = g_strdup (_tmp71_);
	dbus_message_unref (_reply);
	return _result;
}


static char* dvb_id_bus_schedule_dbus_proxy_GetExtendedDescription (DVBIDBusSchedule* self, guint32 event_id) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp72_;
	char* _result;
	const char* _tmp73_;
	if (((DVBIDBusScheduleDBusProxy*) self)->disposed) {
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.Schedule", "GetExtendedDescription");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp72_ = event_id;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp72_);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp73_);
	dbus_message_iter_next (&_iter);
	_result = g_strdup (_tmp73_);
	dbus_message_unref (_reply);
	return _result;
}


static guint dvb_id_bus_schedule_dbus_proxy_GetDuration (DVBIDBusSchedule* self, guint32 event_id) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp74_;
	guint _result;
	dbus_uint32_t _tmp75_;
	if (((DVBIDBusScheduleDBusProxy*) self)->disposed) {
		return 0U;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.Schedule", "GetDuration");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp74_ = event_id;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp74_);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp75_);
	dbus_message_iter_next (&_iter);
	_result = _tmp75_;
	dbus_message_unref (_reply);
	return _result;
}


static guint* dvb_id_bus_schedule_dbus_proxy_GetLocalStartTime (DVBIDBusSchedule* self, guint32 event_id, int* result_length1) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp76_;
	guint* _result;
	int _result_length1;
	guint* _tmp77_;
	int _tmp77__length;
	int _tmp77__size;
	int _tmp77__length1;
	DBusMessageIter _tmp78_;
	if (((DVBIDBusScheduleDBusProxy*) self)->disposed) {
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.Schedule", "GetLocalStartTime");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp76_ = event_id;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp76_);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	_result_length1 = 0;
	_tmp77_ = g_new (guint, 5);
	_tmp77__length = 0;
	_tmp77__size = 4;
	_tmp77__length1 = 0;
	dbus_message_iter_recurse (&_iter, &_tmp78_);
	for (; dbus_message_iter_get_arg_type (&_tmp78_); _tmp77__length1++) {
		dbus_uint32_t _tmp79_;
		if (_tmp77__size == _tmp77__length) {
			_tmp77__size = 2 * _tmp77__size;
			_tmp77_ = g_renew (guint, _tmp77_, _tmp77__size + 1);
		}
		dbus_message_iter_get_basic (&_tmp78_, &_tmp79_);
		dbus_message_iter_next (&_tmp78_);
		_tmp77_[_tmp77__length++] = _tmp79_;
	}
	_result_length1 = _tmp77__length1;
	dbus_message_iter_next (&_iter);
	_result = _tmp77_;
	*result_length1 = _result_length1;
	dbus_message_unref (_reply);
	return _result;
}


static gint64 dvb_id_bus_schedule_dbus_proxy_GetLocalStartTimestamp (DVBIDBusSchedule* self, guint32 event_id) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp80_;
	gint64 _result;
	dbus_int64_t _tmp81_;
	if (((DVBIDBusScheduleDBusProxy*) self)->disposed) {
		return 0LL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.Schedule", "GetLocalStartTimestamp");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp80_ = event_id;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp80_);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp81_);
	dbus_message_iter_next (&_iter);
	_result = _tmp81_;
	dbus_message_unref (_reply);
	return _result;
}


static gboolean dvb_id_bus_schedule_dbus_proxy_IsRunning (DVBIDBusSchedule* self, guint32 event_id) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp82_;
	gboolean _result;
	dbus_bool_t _tmp83_;
	if (((DVBIDBusScheduleDBusProxy*) self)->disposed) {
		return FALSE;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.Schedule", "IsRunning");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp82_ = event_id;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp82_);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp83_);
	dbus_message_iter_next (&_iter);
	_result = _tmp83_;
	dbus_message_unref (_reply);
	return _result;
}


static gboolean dvb_id_bus_schedule_dbus_proxy_IsScrambled (DVBIDBusSchedule* self, guint32 event_id) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp84_;
	gboolean _result;
	dbus_bool_t _tmp85_;
	if (((DVBIDBusScheduleDBusProxy*) self)->disposed) {
		return FALSE;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.Schedule", "IsScrambled");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp84_ = event_id;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp84_);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp85_);
	dbus_message_iter_next (&_iter);
	_result = _tmp85_;
	dbus_message_unref (_reply);
	return _result;
}


static void dvb_id_bus_schedule_dbus_proxy_interface_init (DVBIDBusScheduleIface* iface) {
	iface->GetAllEvents = dvb_id_bus_schedule_dbus_proxy_GetAllEvents;
	iface->GetAllEventInfos = dvb_id_bus_schedule_dbus_proxy_GetAllEventInfos;
	iface->GetInformations = dvb_id_bus_schedule_dbus_proxy_GetInformations;
	iface->NowPlaying = dvb_id_bus_schedule_dbus_proxy_NowPlaying;
	iface->Next = dvb_id_bus_schedule_dbus_proxy_Next;
	iface->GetName = dvb_id_bus_schedule_dbus_proxy_GetName;
	iface->GetShortDescription = dvb_id_bus_schedule_dbus_proxy_GetShortDescription;
	iface->GetExtendedDescription = dvb_id_bus_schedule_dbus_proxy_GetExtendedDescription;
	iface->GetDuration = dvb_id_bus_schedule_dbus_proxy_GetDuration;
	iface->GetLocalStartTime = dvb_id_bus_schedule_dbus_proxy_GetLocalStartTime;
	iface->GetLocalStartTimestamp = dvb_id_bus_schedule_dbus_proxy_GetLocalStartTimestamp;
	iface->IsRunning = dvb_id_bus_schedule_dbus_proxy_IsRunning;
	iface->IsScrambled = dvb_id_bus_schedule_dbus_proxy_IsScrambled;
}


static void dvb_id_bus_schedule_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
}


static void dvb_id_bus_schedule_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
}


static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	const _DBusObjectVTable * vtable;
	vtable = g_type_get_qdata (G_TYPE_FROM_INSTANCE (object), g_quark_from_static_string ("DBusObjectVTable"));
	if (vtable) {
		vtable->register_object (connection, path, object);
	} else {
		g_warning ("Object does not implement any D-Bus interface");
	}
}


static void _vala_dbus_unregister_object (gpointer connection, GObject* object) {
	char* path;
	path = g_object_steal_data ((GObject*) object, "dbus_object_path");
	dbus_connection_unregister_object_path (connection, path);
	g_free (path);
}




