/*
 * Copyright (C) 2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <dbus/dbus.h>
#include <dbus/dbus-glib.h>
#include <dbus/dbus-glib-lowlevel.h>


#define DVB_TYPE_ID_BUS_DEVICE_GROUP (dvb_id_bus_device_group_get_type ())
#define DVB_ID_BUS_DEVICE_GROUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_ID_BUS_DEVICE_GROUP, DVBIDBusDeviceGroup))
#define DVB_IS_ID_BUS_DEVICE_GROUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_ID_BUS_DEVICE_GROUP))
#define DVB_ID_BUS_DEVICE_GROUP_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DVB_TYPE_ID_BUS_DEVICE_GROUP, DVBIDBusDeviceGroupIface))

typedef struct _DVBIDBusDeviceGroup DVBIDBusDeviceGroup;
typedef struct _DVBIDBusDeviceGroupIface DVBIDBusDeviceGroupIface;
typedef struct _DVBIDBusDeviceGroupDBusProxy DVBIDBusDeviceGroupDBusProxy;
typedef DBusGProxyClass DVBIDBusDeviceGroupDBusProxyClass;
typedef struct _DBusObjectVTable _DBusObjectVTable;

struct _DVBIDBusDeviceGroupIface {
	GTypeInterface parent_iface;
	char* (*GetType) (DVBIDBusDeviceGroup* self);
	char* (*GetRecorder) (DVBIDBusDeviceGroup* self);
	gboolean (*AddDevice) (DVBIDBusDeviceGroup* self, guint adapter, guint frontend);
	gboolean (*RemoveDevice) (DVBIDBusDeviceGroup* self, guint adapter, guint frontend);
	char* (*GetChannelList) (DVBIDBusDeviceGroup* self);
	char* (*GetName) (DVBIDBusDeviceGroup* self);
	gboolean (*SetName) (DVBIDBusDeviceGroup* self, const char* name);
	char** (*GetMembers) (DVBIDBusDeviceGroup* self, int* result_length1);
	char* (*GetSchedule) (DVBIDBusDeviceGroup* self, guint channel_sid);
	char* (*GetRecordingsDirectory) (DVBIDBusDeviceGroup* self);
	gboolean (*SetRecordingsDirectory) (DVBIDBusDeviceGroup* self, const char* location);
};

struct _DVBIDBusDeviceGroupDBusProxy {
	DBusGProxy parent_instance;
	gboolean disposed;
};

struct _DBusObjectVTable {
	void (*register_object) (DBusConnection*, const char*, void*);
};



GType dvb_id_bus_device_group_get_type (void);
char* dvb_id_bus_device_group_GetType (DVBIDBusDeviceGroup* self);
char* dvb_id_bus_device_group_GetRecorder (DVBIDBusDeviceGroup* self);
gboolean dvb_id_bus_device_group_AddDevice (DVBIDBusDeviceGroup* self, guint adapter, guint frontend);
gboolean dvb_id_bus_device_group_RemoveDevice (DVBIDBusDeviceGroup* self, guint adapter, guint frontend);
char* dvb_id_bus_device_group_GetChannelList (DVBIDBusDeviceGroup* self);
char* dvb_id_bus_device_group_GetName (DVBIDBusDeviceGroup* self);
gboolean dvb_id_bus_device_group_SetName (DVBIDBusDeviceGroup* self, const char* name);
char** dvb_id_bus_device_group_GetMembers (DVBIDBusDeviceGroup* self, int* result_length1);
char* dvb_id_bus_device_group_GetSchedule (DVBIDBusDeviceGroup* self, guint channel_sid);
char* dvb_id_bus_device_group_GetRecordingsDirectory (DVBIDBusDeviceGroup* self);
gboolean dvb_id_bus_device_group_SetRecordingsDirectory (DVBIDBusDeviceGroup* self, const char* location);
void dvb_id_bus_device_group_dbus_register_object (DBusConnection* connection, const char* path, void* object);
void _dvb_id_bus_device_group_dbus_unregister (DBusConnection* connection, void* user_data);
DBusHandlerResult dvb_id_bus_device_group_dbus_message (DBusConnection* connection, DBusMessage* message, void* object);
static DBusMessage* _dbus_dvb_id_bus_device_group_introspect (DVBIDBusDeviceGroup* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_device_group_property_get_all (DVBIDBusDeviceGroup* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_device_group_GetType (DVBIDBusDeviceGroup* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_device_group_GetRecorder (DVBIDBusDeviceGroup* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_device_group_AddDevice (DVBIDBusDeviceGroup* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_device_group_RemoveDevice (DVBIDBusDeviceGroup* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_device_group_GetChannelList (DVBIDBusDeviceGroup* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_device_group_GetName (DVBIDBusDeviceGroup* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_device_group_SetName (DVBIDBusDeviceGroup* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_device_group_GetMembers (DVBIDBusDeviceGroup* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_device_group_GetSchedule (DVBIDBusDeviceGroup* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_device_group_GetRecordingsDirectory (DVBIDBusDeviceGroup* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_device_group_SetRecordingsDirectory (DVBIDBusDeviceGroup* self, DBusConnection* connection, DBusMessage* message);
static void _dbus_dvb_id_bus_device_group_device_added (GObject* _sender, guint adapter, guint frontend, DBusConnection* _connection);
static void _dbus_dvb_id_bus_device_group_device_removed (GObject* _sender, guint adapter, guint frontend, DBusConnection* _connection);
GType dvb_id_bus_device_group_dbus_proxy_get_type (void);
DVBIDBusDeviceGroup* dvb_id_bus_device_group_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path);
static void _dbus_handle_dvb_id_bus_device_group_device_added (DVBIDBusDeviceGroup* self, DBusConnection* connection, DBusMessage* message);
static void _dbus_handle_dvb_id_bus_device_group_device_removed (DVBIDBusDeviceGroup* self, DBusConnection* connection, DBusMessage* message);
DBusHandlerResult dvb_id_bus_device_group_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data);
enum  {
	DVB_ID_BUS_DEVICE_GROUP_DBUS_PROXY_DUMMY_PROPERTY
};
static char* dvb_id_bus_device_group_dbus_proxy_GetType (DVBIDBusDeviceGroup* self);
static char* dvb_id_bus_device_group_dbus_proxy_GetRecorder (DVBIDBusDeviceGroup* self);
static gboolean dvb_id_bus_device_group_dbus_proxy_AddDevice (DVBIDBusDeviceGroup* self, guint adapter, guint frontend);
static gboolean dvb_id_bus_device_group_dbus_proxy_RemoveDevice (DVBIDBusDeviceGroup* self, guint adapter, guint frontend);
static char* dvb_id_bus_device_group_dbus_proxy_GetChannelList (DVBIDBusDeviceGroup* self);
static char* dvb_id_bus_device_group_dbus_proxy_GetName (DVBIDBusDeviceGroup* self);
static gboolean dvb_id_bus_device_group_dbus_proxy_SetName (DVBIDBusDeviceGroup* self, const char* name);
static char** dvb_id_bus_device_group_dbus_proxy_GetMembers (DVBIDBusDeviceGroup* self, int* result_length1);
static char* dvb_id_bus_device_group_dbus_proxy_GetSchedule (DVBIDBusDeviceGroup* self, guint channel_sid);
static char* dvb_id_bus_device_group_dbus_proxy_GetRecordingsDirectory (DVBIDBusDeviceGroup* self);
static gboolean dvb_id_bus_device_group_dbus_proxy_SetRecordingsDirectory (DVBIDBusDeviceGroup* self, const char* location);
static void dvb_id_bus_device_group_dbus_proxy_interface_init (DVBIDBusDeviceGroupIface* iface);
static void dvb_id_bus_device_group_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void dvb_id_bus_device_group_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object);
static void _vala_dbus_unregister_object (gpointer connection, GObject* object);

static const DBusObjectPathVTable _dvb_id_bus_device_group_dbus_path_vtable = {_dvb_id_bus_device_group_dbus_unregister, dvb_id_bus_device_group_dbus_message};
static const _DBusObjectVTable _dvb_id_bus_device_group_dbus_vtable = {dvb_id_bus_device_group_dbus_register_object};

static void g_cclosure_user_marshal_VOID__UINT_UINT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);

/**
         * @returns: Name of adapter type the group holds
         * or an empty string when group with given id doesn't exist.
         */
char* dvb_id_bus_device_group_GetType (DVBIDBusDeviceGroup* self) {
	return DVB_ID_BUS_DEVICE_GROUP_GET_INTERFACE (self)->GetType (self);
}


/**
         * @returns: Object path of the device's recorder
         * 
         * Returns the object path to the device's recorder.
         */
char* dvb_id_bus_device_group_GetRecorder (DVBIDBusDeviceGroup* self) {
	return DVB_ID_BUS_DEVICE_GROUP_GET_INTERFACE (self)->GetRecorder (self);
}


/**
         * @adapter: Number of the device's adapter
         * @frontend: Number of the device's frontend
         * @group_id: ID of device group
         * @returns: TRUE when the device has been registered successfully
         *
         * Creates a new device and adds it to the specified DeviceGroup.
         * The new device will inherit all settings from the group's
         * reference device.
         */
gboolean dvb_id_bus_device_group_AddDevice (DVBIDBusDeviceGroup* self, guint adapter, guint frontend) {
	return DVB_ID_BUS_DEVICE_GROUP_GET_INTERFACE (self)->AddDevice (self, adapter, frontend);
}


/**
         * @adapter: Number of the device's adapter
         * @frontend: Number of the device's frontend
         * @returns: TRUE when device has been removed successfully
         *
         * Removes the device from the group. If the group contains
         * no devices after the removal it's removed as well.
         */
gboolean dvb_id_bus_device_group_RemoveDevice (DVBIDBusDeviceGroup* self, guint adapter, guint frontend) {
	return DVB_ID_BUS_DEVICE_GROUP_GET_INTERFACE (self)->RemoveDevice (self, adapter, frontend);
}


/**
         * @returns: Object path to the ChannelList service for this device
         */
char* dvb_id_bus_device_group_GetChannelList (DVBIDBusDeviceGroup* self) {
	return DVB_ID_BUS_DEVICE_GROUP_GET_INTERFACE (self)->GetChannelList (self);
}


/**
         * @returns: Name of the device group
         */
char* dvb_id_bus_device_group_GetName (DVBIDBusDeviceGroup* self) {
	return DVB_ID_BUS_DEVICE_GROUP_GET_INTERFACE (self)->GetName (self);
}


/**
         * @name: Name of the group
         * @returns: TRUE on success
         */
gboolean dvb_id_bus_device_group_SetName (DVBIDBusDeviceGroup* self, const char* name) {
	return DVB_ID_BUS_DEVICE_GROUP_GET_INTERFACE (self)->SetName (self, name);
}


/**
         * @returns: List of paths to the devices that are part of
         * the group (e.g. /dev/dvb/adapter0/frontend0)
         */
char** dvb_id_bus_device_group_GetMembers (DVBIDBusDeviceGroup* self, int* result_length1) {
	return DVB_ID_BUS_DEVICE_GROUP_GET_INTERFACE (self)->GetMembers (self, result_length1);
}


/**
         * @channel_sid: ID of the channel
         * @returns: Object path to Schedule service
         */
char* dvb_id_bus_device_group_GetSchedule (DVBIDBusDeviceGroup* self, guint channel_sid) {
	return DVB_ID_BUS_DEVICE_GROUP_GET_INTERFACE (self)->GetSchedule (self, channel_sid);
}


/**
         * @returns: Location of the recordings directory
         */
char* dvb_id_bus_device_group_GetRecordingsDirectory (DVBIDBusDeviceGroup* self) {
	return DVB_ID_BUS_DEVICE_GROUP_GET_INTERFACE (self)->GetRecordingsDirectory (self);
}


/**
         * @location: Location of the recordings directory
         * @returns: TRUE on success
         */
gboolean dvb_id_bus_device_group_SetRecordingsDirectory (DVBIDBusDeviceGroup* self, const char* location) {
	return DVB_ID_BUS_DEVICE_GROUP_GET_INTERFACE (self)->SetRecordingsDirectory (self, location);
}


void _dvb_id_bus_device_group_dbus_unregister (DBusConnection* connection, void* user_data) {
}


static DBusMessage* _dbus_dvb_id_bus_device_group_introspect (DVBIDBusDeviceGroup* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter;
	GString* xml_data;
	char** children;
	int i;
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	xml_data = g_string_new ("<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\" \"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n");
	g_string_append (xml_data, "<node>\n<interface name=\"org.freedesktop.DBus.Introspectable\">\n  <method name=\"Introspect\">\n    <arg name=\"data\" direction=\"out\" type=\"s\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DBus.Properties\">\n  <method name=\"Get\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"out\" type=\"v\"/>\n  </method>\n  <method name=\"Set\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"in\" type=\"v\"/>\n  </method>\n  <method name=\"GetAll\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"props\" direction=\"out\" type=\"a{sv}\"/>\n  </method>\n</interface>\n<interface name=\"org.gnome.DVB.DeviceGroup\">\n  <method name=\"GetType\">\n    <arg name=\"result\" type=\"s\" direction=\"out\"/>\n  </method>\n  <method name=\"GetRecorder\">\n    <arg name=\"result\" type=\"o\" direction=\"out\"/>\n  </method>\n  <method name=\"AddDevice\">\n    <arg name=\"adapter\" type=\"u\" direction=\"in\"/>\n    <arg name=\"frontend\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <method name=\"RemoveDevice\">\n    <arg name=\"adapter\" type=\"u\" direction=\"in\"/>\n    <arg name=\"frontend\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <method name=\"GetChannelList\">\n    <arg name=\"result\" type=\"o\" direction=\"out\"/>\n  </method>\n  <method name=\"GetName\">\n    <arg name=\"result\" type=\"s\" direction=\"out\"/>\n  </method>\n  <method name=\"SetName\">\n    <arg name=\"name\" type=\"s\" direction=\"in\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <method name=\"GetMembers\">\n    <arg name=\"result\" type=\"as\" direction=\"out\"/>\n  </method>\n  <method name=\"GetSchedule\">\n    <arg name=\"channel_sid\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"o\" direction=\"out\"/>\n  </method>\n  <method name=\"GetRecordingsDirectory\">\n    <arg name=\"result\" type=\"s\" direction=\"out\"/>\n  </method>\n  <method name=\"SetRecordingsDirectory\">\n    <arg name=\"location\" type=\"s\" direction=\"in\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <signal name=\"DeviceAdded\">\n    <arg name=\"adapter\" type=\"u\"/>\n    <arg name=\"frontend\" type=\"u\"/>\n  </signal>\n  <signal name=\"DeviceRemoved\">\n    <arg name=\"adapter\" type=\"u\"/>\n    <arg name=\"frontend\" type=\"u\"/>\n  </signal>\n</interface>\n");
	dbus_connection_list_registered (connection, g_object_get_data ((GObject *) self, "dbus_object_path"), &children);
	for (i = 0; children[i]; i++) {
		g_string_append_printf (xml_data, "<node name=\"%s\"/>\n", children[i]);
	}
	dbus_free_string_array (children);
	g_string_append (xml_data, "</node>\n");
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &xml_data->str);
	g_string_free (xml_data, TRUE);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_device_group_property_get_all (DVBIDBusDeviceGroup* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter, reply_iter, subiter;
	char* interface_name;
	const char* _tmp0_;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &reply_iter);
	dbus_message_iter_get_basic (&iter, &_tmp0_);
	dbus_message_iter_next (&iter);
	interface_name = g_strdup (_tmp0_);
	if (strcmp (interface_name, "org.gnome.DVB.DeviceGroup") == 0) {
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_ARRAY, "{sv}", &subiter);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else {
		dbus_message_unref (reply);
		reply = NULL;
	}
	g_free (interface_name);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_device_group_GetType (DVBIDBusDeviceGroup* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	char* result;
	DBusMessage* reply;
	const char* _tmp1_;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	result = dvb_id_bus_device_group_GetType (self);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp1_ = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &_tmp1_);
	result = (g_free (result), NULL);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_device_group_GetRecorder (DVBIDBusDeviceGroup* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	char* result;
	DBusMessage* reply;
	const char* _tmp2_;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	result = dvb_id_bus_device_group_GetRecorder (self);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp2_ = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_OBJECT_PATH, &_tmp2_);
	result = (g_free (result), NULL);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_device_group_AddDevice (DVBIDBusDeviceGroup* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	guint adapter;
	dbus_uint32_t _tmp3_;
	guint frontend;
	dbus_uint32_t _tmp4_;
	gboolean result;
	DBusMessage* reply;
	dbus_bool_t _tmp5_;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "uu")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	adapter = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp3_);
	dbus_message_iter_next (&iter);
	adapter = _tmp3_;
	frontend = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp4_);
	dbus_message_iter_next (&iter);
	frontend = _tmp4_;
	result = dvb_id_bus_device_group_AddDevice (self, adapter, frontend);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp5_ = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_BOOLEAN, &_tmp5_);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_device_group_RemoveDevice (DVBIDBusDeviceGroup* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	guint adapter;
	dbus_uint32_t _tmp6_;
	guint frontend;
	dbus_uint32_t _tmp7_;
	gboolean result;
	DBusMessage* reply;
	dbus_bool_t _tmp8_;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "uu")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	adapter = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp6_);
	dbus_message_iter_next (&iter);
	adapter = _tmp6_;
	frontend = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp7_);
	dbus_message_iter_next (&iter);
	frontend = _tmp7_;
	result = dvb_id_bus_device_group_RemoveDevice (self, adapter, frontend);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp8_ = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_BOOLEAN, &_tmp8_);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_device_group_GetChannelList (DVBIDBusDeviceGroup* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	char* result;
	DBusMessage* reply;
	const char* _tmp9_;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	result = dvb_id_bus_device_group_GetChannelList (self);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp9_ = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_OBJECT_PATH, &_tmp9_);
	result = (g_free (result), NULL);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_device_group_GetName (DVBIDBusDeviceGroup* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	char* result;
	DBusMessage* reply;
	const char* _tmp10_;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	result = dvb_id_bus_device_group_GetName (self);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp10_ = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &_tmp10_);
	result = (g_free (result), NULL);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_device_group_SetName (DVBIDBusDeviceGroup* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	char* name;
	const char* _tmp11_;
	gboolean result;
	DBusMessage* reply;
	dbus_bool_t _tmp12_;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	name = NULL;
	dbus_message_iter_get_basic (&iter, &_tmp11_);
	dbus_message_iter_next (&iter);
	name = g_strdup (_tmp11_);
	result = dvb_id_bus_device_group_SetName (self, name);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	name = (g_free (name), NULL);
	_tmp12_ = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_BOOLEAN, &_tmp12_);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_device_group_GetMembers (DVBIDBusDeviceGroup* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	int result_length1;
	char** result;
	DBusMessage* reply;
	char** _tmp13_;
	DBusMessageIter _tmp14_;
	int _tmp15_;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	result_length1 = 0;
	result = dvb_id_bus_device_group_GetMembers (self, &result_length1);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp13_ = result;
	dbus_message_iter_open_container (&iter, DBUS_TYPE_ARRAY, "s", &_tmp14_);
	for (_tmp15_ = 0; _tmp15_ < result_length1; _tmp15_++) {
		const char* _tmp16_;
		_tmp16_ = *_tmp13_;
		dbus_message_iter_append_basic (&_tmp14_, DBUS_TYPE_STRING, &_tmp16_);
		_tmp13_++;
	}
	dbus_message_iter_close_container (&iter, &_tmp14_);
	result = (_vala_array_free (result,  result_length1, (GDestroyNotify) g_free), NULL);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_device_group_GetSchedule (DVBIDBusDeviceGroup* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	guint channel_sid;
	dbus_uint32_t _tmp17_;
	char* result;
	DBusMessage* reply;
	const char* _tmp18_;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "u")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	channel_sid = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp17_);
	dbus_message_iter_next (&iter);
	channel_sid = _tmp17_;
	result = dvb_id_bus_device_group_GetSchedule (self, channel_sid);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp18_ = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_OBJECT_PATH, &_tmp18_);
	result = (g_free (result), NULL);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_device_group_GetRecordingsDirectory (DVBIDBusDeviceGroup* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	char* result;
	DBusMessage* reply;
	const char* _tmp19_;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	result = dvb_id_bus_device_group_GetRecordingsDirectory (self);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp19_ = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &_tmp19_);
	result = (g_free (result), NULL);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_device_group_SetRecordingsDirectory (DVBIDBusDeviceGroup* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	char* location;
	const char* _tmp20_;
	gboolean result;
	DBusMessage* reply;
	dbus_bool_t _tmp21_;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	location = NULL;
	dbus_message_iter_get_basic (&iter, &_tmp20_);
	dbus_message_iter_next (&iter);
	location = g_strdup (_tmp20_);
	result = dvb_id_bus_device_group_SetRecordingsDirectory (self, location);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	location = (g_free (location), NULL);
	_tmp21_ = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_BOOLEAN, &_tmp21_);
	return reply;
}


DBusHandlerResult dvb_id_bus_device_group_dbus_message (DBusConnection* connection, DBusMessage* message, void* object) {
	DBusMessage* reply;
	reply = NULL;
	if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Introspectable", "Introspect")) {
		reply = _dbus_dvb_id_bus_device_group_introspect (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Properties", "GetAll")) {
		reply = _dbus_dvb_id_bus_device_group_property_get_all (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.DeviceGroup", "GetType")) {
		reply = _dbus_dvb_id_bus_device_group_GetType (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.DeviceGroup", "GetRecorder")) {
		reply = _dbus_dvb_id_bus_device_group_GetRecorder (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.DeviceGroup", "AddDevice")) {
		reply = _dbus_dvb_id_bus_device_group_AddDevice (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.DeviceGroup", "RemoveDevice")) {
		reply = _dbus_dvb_id_bus_device_group_RemoveDevice (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.DeviceGroup", "GetChannelList")) {
		reply = _dbus_dvb_id_bus_device_group_GetChannelList (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.DeviceGroup", "GetName")) {
		reply = _dbus_dvb_id_bus_device_group_GetName (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.DeviceGroup", "SetName")) {
		reply = _dbus_dvb_id_bus_device_group_SetName (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.DeviceGroup", "GetMembers")) {
		reply = _dbus_dvb_id_bus_device_group_GetMembers (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.DeviceGroup", "GetSchedule")) {
		reply = _dbus_dvb_id_bus_device_group_GetSchedule (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.DeviceGroup", "GetRecordingsDirectory")) {
		reply = _dbus_dvb_id_bus_device_group_GetRecordingsDirectory (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.DeviceGroup", "SetRecordingsDirectory")) {
		reply = _dbus_dvb_id_bus_device_group_SetRecordingsDirectory (object, connection, message);
	}
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static void _dbus_dvb_id_bus_device_group_device_added (GObject* _sender, guint adapter, guint frontend, DBusConnection* _connection) {
	const char * _path;
	DBusMessage *_message;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp22_;
	dbus_uint32_t _tmp23_;
	_path = g_object_get_data (_sender, "dbus_object_path");
	_message = dbus_message_new_signal (_path, "org.gnome.DVB.DeviceGroup", "DeviceAdded");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp22_ = adapter;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp22_);
	_tmp23_ = frontend;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp23_);
	dbus_connection_send (_connection, _message, NULL);
	dbus_message_unref (_message);
}


static void _dbus_dvb_id_bus_device_group_device_removed (GObject* _sender, guint adapter, guint frontend, DBusConnection* _connection) {
	const char * _path;
	DBusMessage *_message;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp24_;
	dbus_uint32_t _tmp25_;
	_path = g_object_get_data (_sender, "dbus_object_path");
	_message = dbus_message_new_signal (_path, "org.gnome.DVB.DeviceGroup", "DeviceRemoved");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp24_ = adapter;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp24_);
	_tmp25_ = frontend;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp25_);
	dbus_connection_send (_connection, _message, NULL);
	dbus_message_unref (_message);
}


void dvb_id_bus_device_group_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	if (!g_object_get_data (object, "dbus_object_path")) {
		g_object_set_data (object, "dbus_object_path", g_strdup (path));
		dbus_connection_register_object_path (connection, path, &_dvb_id_bus_device_group_dbus_path_vtable, object);
		g_object_weak_ref (object, _vala_dbus_unregister_object, connection);
	}
	g_signal_connect (object, "device-added", (GCallback) _dbus_dvb_id_bus_device_group_device_added, connection);
	g_signal_connect (object, "device-removed", (GCallback) _dbus_dvb_id_bus_device_group_device_removed, connection);
}


static void dvb_id_bus_device_group_base_init (DVBIDBusDeviceGroupIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_signal_new ("device_added", DVB_TYPE_ID_BUS_DEVICE_GROUP, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__UINT_UINT, G_TYPE_NONE, 2, G_TYPE_UINT, G_TYPE_UINT);
		g_signal_new ("device_removed", DVB_TYPE_ID_BUS_DEVICE_GROUP, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__UINT_UINT, G_TYPE_NONE, 2, G_TYPE_UINT, G_TYPE_UINT);
		g_type_set_qdata (DVB_TYPE_ID_BUS_DEVICE_GROUP, g_quark_from_static_string ("DBusObjectVTable"), (void*) (&_dvb_id_bus_device_group_dbus_vtable));
	}
}


GType dvb_id_bus_device_group_get_type (void) {
	static GType dvb_id_bus_device_group_type_id = 0;
	if (dvb_id_bus_device_group_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBIDBusDeviceGroupIface), (GBaseInitFunc) dvb_id_bus_device_group_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		dvb_id_bus_device_group_type_id = g_type_register_static (G_TYPE_INTERFACE, "DVBIDBusDeviceGroup", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (dvb_id_bus_device_group_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (dvb_id_bus_device_group_type_id, g_quark_from_string ("ValaDBusInterfaceProxyType"), &dvb_id_bus_device_group_dbus_proxy_get_type);
	}
	return dvb_id_bus_device_group_type_id;
}


G_DEFINE_TYPE_EXTENDED (DVBIDBusDeviceGroupDBusProxy, dvb_id_bus_device_group_dbus_proxy, DBUS_TYPE_G_PROXY, 0, G_IMPLEMENT_INTERFACE (DVB_TYPE_ID_BUS_DEVICE_GROUP, dvb_id_bus_device_group_dbus_proxy_interface_init));
DVBIDBusDeviceGroup* dvb_id_bus_device_group_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path) {
	DVBIDBusDeviceGroup* self;
	self = g_object_new (dvb_id_bus_device_group_dbus_proxy_get_type (), "connection", connection, "name", name, "path", path, "interface", "org.gnome.DVB.DeviceGroup", NULL);
	return self;
}


static GObject* dvb_id_bus_device_group_dbus_proxy_construct (GType gtype, guint n_properties, GObjectConstructParam* properties) {
	GObject* self;
	DBusGConnection *connection;
	char* path;
	char* filter;
	self = G_OBJECT_CLASS (dvb_id_bus_device_group_dbus_proxy_parent_class)->constructor (gtype, n_properties, properties);
	g_object_get (self, "connection", &connection, NULL);
	g_object_get (self, "path", &path, NULL);
	dbus_connection_add_filter (dbus_g_connection_get_connection (connection), dvb_id_bus_device_group_dbus_proxy_filter, self, NULL);
	filter = g_strdup_printf ("type='signal',path='%s'", path);
	dbus_bus_add_match (dbus_g_connection_get_connection (connection), filter, NULL);
	dbus_g_connection_unref (connection);
	g_free (path);
	g_free (filter);
	return self;
}


static void _dbus_handle_dvb_id_bus_device_group_device_added (DVBIDBusDeviceGroup* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	guint adapter;
	dbus_uint32_t _tmp26_;
	guint frontend;
	dbus_uint32_t _tmp27_;
	DBusMessage* reply;
	if (strcmp (dbus_message_get_signature (message), "uu")) {
		return;
	}
	dbus_message_iter_init (message, &iter);
	adapter = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp26_);
	dbus_message_iter_next (&iter);
	adapter = _tmp26_;
	frontend = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp27_);
	dbus_message_iter_next (&iter);
	frontend = _tmp27_;
	g_signal_emit_by_name (self, "device-added", adapter, frontend);
}


static void _dbus_handle_dvb_id_bus_device_group_device_removed (DVBIDBusDeviceGroup* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	guint adapter;
	dbus_uint32_t _tmp28_;
	guint frontend;
	dbus_uint32_t _tmp29_;
	DBusMessage* reply;
	if (strcmp (dbus_message_get_signature (message), "uu")) {
		return;
	}
	dbus_message_iter_init (message, &iter);
	adapter = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp28_);
	dbus_message_iter_next (&iter);
	adapter = _tmp28_;
	frontend = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp29_);
	dbus_message_iter_next (&iter);
	frontend = _tmp29_;
	g_signal_emit_by_name (self, "device-removed", adapter, frontend);
}


DBusHandlerResult dvb_id_bus_device_group_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data) {
	if (dbus_message_has_path (message, dbus_g_proxy_get_path (user_data))) {
		if (dbus_message_is_signal (message, "org.gnome.DVB.DeviceGroup", "DeviceAdded")) {
			_dbus_handle_dvb_id_bus_device_group_device_added (user_data, connection, message);
		} else if (dbus_message_is_signal (message, "org.gnome.DVB.DeviceGroup", "DeviceRemoved")) {
			_dbus_handle_dvb_id_bus_device_group_device_removed (user_data, connection, message);
		}
	}
	return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
}


static void dvb_id_bus_device_group_dbus_proxy_dispose (GObject* self) {
	DBusGConnection *connection;
	if (((DVBIDBusDeviceGroupDBusProxy*) self)->disposed) {
		return;
	}
	((DVBIDBusDeviceGroupDBusProxy*) self)->disposed = TRUE;
	g_object_get (self, "connection", &connection, NULL);
	dbus_connection_remove_filter (dbus_g_connection_get_connection (connection), dvb_id_bus_device_group_dbus_proxy_filter, self);
	G_OBJECT_CLASS (dvb_id_bus_device_group_dbus_proxy_parent_class)->dispose (self);
}


static void dvb_id_bus_device_group_dbus_proxy_class_init (DVBIDBusDeviceGroupDBusProxyClass* klass) {
	G_OBJECT_CLASS (klass)->constructor = dvb_id_bus_device_group_dbus_proxy_construct;
	G_OBJECT_CLASS (klass)->dispose = dvb_id_bus_device_group_dbus_proxy_dispose;
	G_OBJECT_CLASS (klass)->get_property = dvb_id_bus_device_group_dbus_proxy_get_property;
	G_OBJECT_CLASS (klass)->set_property = dvb_id_bus_device_group_dbus_proxy_set_property;
}


static void dvb_id_bus_device_group_dbus_proxy_init (DVBIDBusDeviceGroupDBusProxy* self) {
}


static char* dvb_id_bus_device_group_dbus_proxy_GetType (DVBIDBusDeviceGroup* self) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	char* _result;
	const char* _tmp30_;
	if (((DVBIDBusDeviceGroupDBusProxy*) self)->disposed) {
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.DeviceGroup", "GetType");
	dbus_message_iter_init_append (_message, &_iter);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp30_);
	dbus_message_iter_next (&_iter);
	_result = g_strdup (_tmp30_);
	dbus_message_unref (_reply);
	return _result;
}


static char* dvb_id_bus_device_group_dbus_proxy_GetRecorder (DVBIDBusDeviceGroup* self) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	char* _result;
	const char* _tmp31_;
	if (((DVBIDBusDeviceGroupDBusProxy*) self)->disposed) {
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.DeviceGroup", "GetRecorder");
	dbus_message_iter_init_append (_message, &_iter);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp31_);
	dbus_message_iter_next (&_iter);
	_result = g_strdup (_tmp31_);
	dbus_message_unref (_reply);
	return _result;
}


static gboolean dvb_id_bus_device_group_dbus_proxy_AddDevice (DVBIDBusDeviceGroup* self, guint adapter, guint frontend) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp32_;
	dbus_uint32_t _tmp33_;
	gboolean _result;
	dbus_bool_t _tmp34_;
	if (((DVBIDBusDeviceGroupDBusProxy*) self)->disposed) {
		return FALSE;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.DeviceGroup", "AddDevice");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp32_ = adapter;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp32_);
	_tmp33_ = frontend;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp33_);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp34_);
	dbus_message_iter_next (&_iter);
	_result = _tmp34_;
	dbus_message_unref (_reply);
	return _result;
}


static gboolean dvb_id_bus_device_group_dbus_proxy_RemoveDevice (DVBIDBusDeviceGroup* self, guint adapter, guint frontend) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp35_;
	dbus_uint32_t _tmp36_;
	gboolean _result;
	dbus_bool_t _tmp37_;
	if (((DVBIDBusDeviceGroupDBusProxy*) self)->disposed) {
		return FALSE;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.DeviceGroup", "RemoveDevice");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp35_ = adapter;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp35_);
	_tmp36_ = frontend;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp36_);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp37_);
	dbus_message_iter_next (&_iter);
	_result = _tmp37_;
	dbus_message_unref (_reply);
	return _result;
}


static char* dvb_id_bus_device_group_dbus_proxy_GetChannelList (DVBIDBusDeviceGroup* self) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	char* _result;
	const char* _tmp38_;
	if (((DVBIDBusDeviceGroupDBusProxy*) self)->disposed) {
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.DeviceGroup", "GetChannelList");
	dbus_message_iter_init_append (_message, &_iter);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp38_);
	dbus_message_iter_next (&_iter);
	_result = g_strdup (_tmp38_);
	dbus_message_unref (_reply);
	return _result;
}


static char* dvb_id_bus_device_group_dbus_proxy_GetName (DVBIDBusDeviceGroup* self) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	char* _result;
	const char* _tmp39_;
	if (((DVBIDBusDeviceGroupDBusProxy*) self)->disposed) {
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.DeviceGroup", "GetName");
	dbus_message_iter_init_append (_message, &_iter);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp39_);
	dbus_message_iter_next (&_iter);
	_result = g_strdup (_tmp39_);
	dbus_message_unref (_reply);
	return _result;
}


static gboolean dvb_id_bus_device_group_dbus_proxy_SetName (DVBIDBusDeviceGroup* self, const char* name) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	const char* _tmp40_;
	gboolean _result;
	dbus_bool_t _tmp41_;
	if (((DVBIDBusDeviceGroupDBusProxy*) self)->disposed) {
		return FALSE;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.DeviceGroup", "SetName");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp40_ = name;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp40_);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp41_);
	dbus_message_iter_next (&_iter);
	_result = _tmp41_;
	dbus_message_unref (_reply);
	return _result;
}


static char** dvb_id_bus_device_group_dbus_proxy_GetMembers (DVBIDBusDeviceGroup* self, int* result_length1) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	char** _result;
	int _result_length1;
	char** _tmp42_;
	int _tmp42__length;
	int _tmp42__size;
	int _tmp42__length1;
	DBusMessageIter _tmp43_;
	if (((DVBIDBusDeviceGroupDBusProxy*) self)->disposed) {
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.DeviceGroup", "GetMembers");
	dbus_message_iter_init_append (_message, &_iter);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	_result_length1 = 0;
	_tmp42_ = g_new (char*, 5);
	_tmp42__length = 0;
	_tmp42__size = 4;
	_tmp42__length1 = 0;
	dbus_message_iter_recurse (&_iter, &_tmp43_);
	for (; dbus_message_iter_get_arg_type (&_tmp43_); _tmp42__length1++) {
		const char* _tmp44_;
		if (_tmp42__size == _tmp42__length) {
			_tmp42__size = 2 * _tmp42__size;
			_tmp42_ = g_renew (char*, _tmp42_, _tmp42__size + 1);
		}
		dbus_message_iter_get_basic (&_tmp43_, &_tmp44_);
		dbus_message_iter_next (&_tmp43_);
		_tmp42_[_tmp42__length++] = g_strdup (_tmp44_);
	}
	_result_length1 = _tmp42__length1;
	_tmp42_[_tmp42__length] = NULL;
	dbus_message_iter_next (&_iter);
	_result = _tmp42_;
	*result_length1 = _result_length1;
	dbus_message_unref (_reply);
	return _result;
}


static char* dvb_id_bus_device_group_dbus_proxy_GetSchedule (DVBIDBusDeviceGroup* self, guint channel_sid) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp45_;
	char* _result;
	const char* _tmp46_;
	if (((DVBIDBusDeviceGroupDBusProxy*) self)->disposed) {
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.DeviceGroup", "GetSchedule");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp45_ = channel_sid;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp45_);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp46_);
	dbus_message_iter_next (&_iter);
	_result = g_strdup (_tmp46_);
	dbus_message_unref (_reply);
	return _result;
}


static char* dvb_id_bus_device_group_dbus_proxy_GetRecordingsDirectory (DVBIDBusDeviceGroup* self) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	char* _result;
	const char* _tmp47_;
	if (((DVBIDBusDeviceGroupDBusProxy*) self)->disposed) {
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.DeviceGroup", "GetRecordingsDirectory");
	dbus_message_iter_init_append (_message, &_iter);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp47_);
	dbus_message_iter_next (&_iter);
	_result = g_strdup (_tmp47_);
	dbus_message_unref (_reply);
	return _result;
}


static gboolean dvb_id_bus_device_group_dbus_proxy_SetRecordingsDirectory (DVBIDBusDeviceGroup* self, const char* location) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	const char* _tmp48_;
	gboolean _result;
	dbus_bool_t _tmp49_;
	if (((DVBIDBusDeviceGroupDBusProxy*) self)->disposed) {
		return FALSE;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.DeviceGroup", "SetRecordingsDirectory");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp48_ = location;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp48_);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp49_);
	dbus_message_iter_next (&_iter);
	_result = _tmp49_;
	dbus_message_unref (_reply);
	return _result;
}


static void dvb_id_bus_device_group_dbus_proxy_interface_init (DVBIDBusDeviceGroupIface* iface) {
	iface->GetType = dvb_id_bus_device_group_dbus_proxy_GetType;
	iface->GetRecorder = dvb_id_bus_device_group_dbus_proxy_GetRecorder;
	iface->AddDevice = dvb_id_bus_device_group_dbus_proxy_AddDevice;
	iface->RemoveDevice = dvb_id_bus_device_group_dbus_proxy_RemoveDevice;
	iface->GetChannelList = dvb_id_bus_device_group_dbus_proxy_GetChannelList;
	iface->GetName = dvb_id_bus_device_group_dbus_proxy_GetName;
	iface->SetName = dvb_id_bus_device_group_dbus_proxy_SetName;
	iface->GetMembers = dvb_id_bus_device_group_dbus_proxy_GetMembers;
	iface->GetSchedule = dvb_id_bus_device_group_dbus_proxy_GetSchedule;
	iface->GetRecordingsDirectory = dvb_id_bus_device_group_dbus_proxy_GetRecordingsDirectory;
	iface->SetRecordingsDirectory = dvb_id_bus_device_group_dbus_proxy_SetRecordingsDirectory;
}


static void dvb_id_bus_device_group_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
}


static void dvb_id_bus_device_group_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	const _DBusObjectVTable * vtable;
	vtable = g_type_get_qdata (G_TYPE_FROM_INSTANCE (object), g_quark_from_static_string ("DBusObjectVTable"));
	if (vtable) {
		vtable->register_object (connection, path, object);
	} else {
		g_warning ("Object does not implement any D-Bus interface");
	}
}


static void _vala_dbus_unregister_object (gpointer connection, GObject* object) {
	char* path;
	path = g_object_steal_data ((GObject*) object, "dbus_object_path");
	dbus_connection_unregister_object_path (connection, path);
	g_free (path);
}



static void g_cclosure_user_marshal_VOID__UINT_UINT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__UINT_UINT) (gpointer data1, guint arg_1, guint arg_2, gpointer data2);
	register GMarshalFunc_VOID__UINT_UINT callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__UINT_UINT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_uint (param_values + 1), g_value_get_uint (param_values + 2), data2);
}



