
#ifndef __SRC_TIMERSSTORE_H__
#define __SRC_TIMERSSTORE_H__

#include <glib.h>
#include <glib-object.h>
#include <gee/list.h>
#include "src/DeviceGroup.h"
#include "src/Timer.h"

G_BEGIN_DECLS


#define DVB_TYPE_TIMERS_STORE (dvb_timers_store_get_type ())
#define DVB_TIMERS_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_TIMERS_STORE, DVBTimersStore))
#define DVB_IS_TIMERS_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_TIMERS_STORE))
#define DVB_TIMERS_STORE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DVB_TYPE_TIMERS_STORE, DVBTimersStoreIface))

typedef struct _DVBTimersStore DVBTimersStore;
typedef struct _DVBTimersStoreIface DVBTimersStoreIface;

struct _DVBTimersStoreIface {
	GTypeInterface parent_iface;
	GeeList* (*get_all_timers_of_device_group) (DVBTimersStore* self, DVBDeviceGroup* dev);
	void (*add_timer_to_device_group) (DVBTimersStore* self, DVBTimer* timer, DVBDeviceGroup* dev);
	void (*remove_timer_from_device_group) (DVBTimersStore* self, guint timer_id, DVBDeviceGroup* dev);
};


GeeList* dvb_timers_store_get_all_timers_of_device_group (DVBTimersStore* self, DVBDeviceGroup* dev);
void dvb_timers_store_add_timer_to_device_group (DVBTimersStore* self, DVBTimer* timer, DVBDeviceGroup* dev);
void dvb_timers_store_remove_timer_from_device_group (DVBTimersStore* self, guint timer_id, DVBDeviceGroup* dev);
GType dvb_timers_store_get_type (void);


G_END_DECLS

#endif
