
#include <src/Cable/CableChannel.h>
#include "src/Utils.h"




struct _DVBCableChannelPrivate {
	DVBDvbSrcInversion _Inversion;
	guint _SymbolRate;
	DVBDvbSrcCodeRate _CodeRate;
	DVBDvbSrcModulation _Modulation;
};

#define DVB_CABLE_CHANNEL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_TYPE_CABLE_CHANNEL, DVBCableChannelPrivate))
enum  {
	DVB_CABLE_CHANNEL_DUMMY_PROPERTY,
	DVB_CABLE_CHANNEL_INVERSION,
	DVB_CABLE_CHANNEL_SYMBOL_RATE,
	DVB_CABLE_CHANNEL_CODE_RATE,
	DVB_CABLE_CHANNEL_MODULATION
};
static void dvb_cable_channel_real_setup_dvb_source (DVBChannel* base, GstElement* source);
static char* dvb_cable_channel_real_to_string (DVBChannel* base);
static gpointer dvb_cable_channel_parent_class = NULL;
static void dvb_cable_channel_finalize (GObject* obj);



static void dvb_cable_channel_real_setup_dvb_source (DVBChannel* base, GstElement* source) {
	DVBCableChannel * self;
	self = (DVBCableChannel*) base;
	g_return_if_fail (source != NULL);
	g_object_set ((GObject*) source, "frequency", dvb_channel_get_Frequency ((DVBChannel*) self), NULL);
	g_object_set ((GObject*) source, "inversion", self->priv->_Inversion, NULL);
	g_object_set ((GObject*) source, "symbol-rate", self->priv->_SymbolRate, NULL);
	g_object_set ((GObject*) source, "code-rate-hp", self->priv->_CodeRate, NULL);
	g_object_set ((GObject*) source, "modulation", self->priv->_Modulation, NULL);
}


static char* dvb_cable_channel_real_to_string (DVBChannel* base) {
	DVBCableChannel * self;
	char* _tmp0;
	char* _tmp1;
	self = (DVBCableChannel*) base;
	_tmp0 = NULL;
	_tmp1 = NULL;
	return (_tmp1 = g_strdup_printf ("%s:%u:%s:%u:%s:%s:%u:%s:%u", dvb_channel_get_Name (DVB_CHANNEL (self)), dvb_channel_get_Frequency (DVB_CHANNEL (self)), dvb_utils_get_nick_from_enum (DVB_TYPE_DVB_SRC_INVERSION, (gint) self->priv->_Inversion), self->priv->_SymbolRate, dvb_utils_get_nick_from_enum (DVB_TYPE_DVB_SRC_CODE_RATE, (gint) self->priv->_CodeRate), dvb_utils_get_nick_from_enum (DVB_TYPE_DVB_SRC_MODULATION, (gint) self->priv->_Modulation), dvb_channel_get_VideoPID (DVB_CHANNEL (self)), _tmp0 = dvb_channel_get_audio_pids_string (DVB_CHANNEL (self)), dvb_channel_get_Sid (DVB_CHANNEL (self))), _tmp0 = (g_free (_tmp0), NULL), _tmp1);
}


DVBCableChannel* dvb_cable_channel_construct (GType object_type) {
	DVBCableChannel * self;
	self = g_object_newv (object_type, 0, NULL);
	return self;
}


DVBCableChannel* dvb_cable_channel_new (void) {
	return dvb_cable_channel_construct (DVB_TYPE_CABLE_CHANNEL);
}


DVBDvbSrcInversion dvb_cable_channel_get_Inversion (DVBCableChannel* self) {
	g_return_val_if_fail (self != NULL, 0);
	return self->priv->_Inversion;
}


void dvb_cable_channel_set_Inversion (DVBCableChannel* self, DVBDvbSrcInversion value) {
	g_return_if_fail (self != NULL);
	self->priv->_Inversion = value;
	g_object_notify ((GObject *) self, "Inversion");
}


guint dvb_cable_channel_get_SymbolRate (DVBCableChannel* self) {
	g_return_val_if_fail (self != NULL, 0U);
	return self->priv->_SymbolRate;
}


void dvb_cable_channel_set_SymbolRate (DVBCableChannel* self, guint value) {
	g_return_if_fail (self != NULL);
	self->priv->_SymbolRate = value;
	g_object_notify ((GObject *) self, "SymbolRate");
}


DVBDvbSrcCodeRate dvb_cable_channel_get_CodeRate (DVBCableChannel* self) {
	g_return_val_if_fail (self != NULL, 0);
	return self->priv->_CodeRate;
}


void dvb_cable_channel_set_CodeRate (DVBCableChannel* self, DVBDvbSrcCodeRate value) {
	g_return_if_fail (self != NULL);
	self->priv->_CodeRate = value;
	g_object_notify ((GObject *) self, "CodeRate");
}


DVBDvbSrcModulation dvb_cable_channel_get_Modulation (DVBCableChannel* self) {
	g_return_val_if_fail (self != NULL, 0);
	return self->priv->_Modulation;
}


void dvb_cable_channel_set_Modulation (DVBCableChannel* self, DVBDvbSrcModulation value) {
	g_return_if_fail (self != NULL);
	self->priv->_Modulation = value;
	g_object_notify ((GObject *) self, "Modulation");
}


static void dvb_cable_channel_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DVBCableChannel * self;
	gpointer boxed;
	self = DVB_CABLE_CHANNEL (object);
	switch (property_id) {
		case DVB_CABLE_CHANNEL_INVERSION:
		g_value_set_enum (value, dvb_cable_channel_get_Inversion (self));
		break;
		case DVB_CABLE_CHANNEL_SYMBOL_RATE:
		g_value_set_uint (value, dvb_cable_channel_get_SymbolRate (self));
		break;
		case DVB_CABLE_CHANNEL_CODE_RATE:
		g_value_set_enum (value, dvb_cable_channel_get_CodeRate (self));
		break;
		case DVB_CABLE_CHANNEL_MODULATION:
		g_value_set_enum (value, dvb_cable_channel_get_Modulation (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void dvb_cable_channel_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DVBCableChannel * self;
	self = DVB_CABLE_CHANNEL (object);
	switch (property_id) {
		case DVB_CABLE_CHANNEL_INVERSION:
		dvb_cable_channel_set_Inversion (self, g_value_get_enum (value));
		break;
		case DVB_CABLE_CHANNEL_SYMBOL_RATE:
		dvb_cable_channel_set_SymbolRate (self, g_value_get_uint (value));
		break;
		case DVB_CABLE_CHANNEL_CODE_RATE:
		dvb_cable_channel_set_CodeRate (self, g_value_get_enum (value));
		break;
		case DVB_CABLE_CHANNEL_MODULATION:
		dvb_cable_channel_set_Modulation (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void dvb_cable_channel_class_init (DVBCableChannelClass * klass) {
	dvb_cable_channel_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBCableChannelPrivate));
	G_OBJECT_CLASS (klass)->get_property = dvb_cable_channel_get_property;
	G_OBJECT_CLASS (klass)->set_property = dvb_cable_channel_set_property;
	G_OBJECT_CLASS (klass)->finalize = dvb_cable_channel_finalize;
	DVB_CHANNEL_CLASS (klass)->setup_dvb_source = dvb_cable_channel_real_setup_dvb_source;
	DVB_CHANNEL_CLASS (klass)->to_string = dvb_cable_channel_real_to_string;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_CABLE_CHANNEL_INVERSION, g_param_spec_enum ("Inversion", "Inversion", "Inversion", DVB_TYPE_DVB_SRC_INVERSION, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_CABLE_CHANNEL_SYMBOL_RATE, g_param_spec_uint ("SymbolRate", "SymbolRate", "SymbolRate", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_CABLE_CHANNEL_CODE_RATE, g_param_spec_enum ("CodeRate", "CodeRate", "CodeRate", DVB_TYPE_DVB_SRC_CODE_RATE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_CABLE_CHANNEL_MODULATION, g_param_spec_enum ("Modulation", "Modulation", "Modulation", DVB_TYPE_DVB_SRC_MODULATION, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void dvb_cable_channel_instance_init (DVBCableChannel * self) {
	self->priv = DVB_CABLE_CHANNEL_GET_PRIVATE (self);
}


static void dvb_cable_channel_finalize (GObject* obj) {
	DVBCableChannel * self;
	self = DVB_CABLE_CHANNEL (obj);
	G_OBJECT_CLASS (dvb_cable_channel_parent_class)->finalize (obj);
}


GType dvb_cable_channel_get_type (void) {
	static GType dvb_cable_channel_type_id = 0;
	if (dvb_cable_channel_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBCableChannelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_cable_channel_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBCableChannel), 0, (GInstanceInitFunc) dvb_cable_channel_instance_init, NULL };
		dvb_cable_channel_type_id = g_type_register_static (DVB_TYPE_CHANNEL, "DVBCableChannel", &g_define_type_info, 0);
	}
	return dvb_cable_channel_type_id;
}




