
#include <src/Satellite/SatelliteScanner.h>
#include <gio/gio.h>
#include "src/Utils.h"
#include "src/Satellite/SatelliteChannel.h"

typedef DBusGProxy DVBIDBusSatelliteScannerDBusProxy;
typedef DBusGProxyClass DVBIDBusSatelliteScannerDBusProxyClass;
typedef struct _DBusObjectVTable _DBusObjectVTable;

struct _DBusObjectVTable {
	void (*register_object) (DBusConnection*, const char*, void*);
};



static char* string_substring (const char* self, glong offset, glong len);
void _dvb_id_bus_satellite_scanner_dbus_unregister (DBusConnection* connection, void* user_data);
static DBusMessage* _dbus_dvb_id_bus_satellite_scanner_introspect (DVBIDBusSatelliteScanner* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_satellite_scanner_property_get_all (DVBIDBusSatelliteScanner* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_satellite_scanner_Run (DVBIDBusSatelliteScanner* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_satellite_scanner_Destroy (DVBIDBusSatelliteScanner* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_satellite_scanner_WriteChannelsToFile (DVBIDBusSatelliteScanner* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_satellite_scanner_AddScanningData (DVBIDBusSatelliteScanner* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_satellite_scanner_AddScanningDataFromFile (DVBIDBusSatelliteScanner* self, DBusConnection* connection, DBusMessage* message);
static void _dbus_dvb_id_bus_satellite_scanner_frequency_scanned (GObject* _sender, guint frequency, guint freq_left, DBusConnection* _connection);
static void _dbus_dvb_id_bus_satellite_scanner_finished (GObject* _sender, DBusConnection* _connection);
static void _dbus_dvb_id_bus_satellite_scanner_channel_added (GObject* _sender, guint frequency, guint sid, const char* name, const char* network, const char* type, gboolean scrambled, DBusConnection* _connection);
static void _dbus_handle_dvb_id_bus_satellite_scanner_frequency_scanned (DVBIDBusSatelliteScanner* self, DBusConnection* connection, DBusMessage* message);
static void _dbus_handle_dvb_id_bus_satellite_scanner_finished (DVBIDBusSatelliteScanner* self, DBusConnection* connection, DBusMessage* message);
static void _dbus_handle_dvb_id_bus_satellite_scanner_channel_added (DVBIDBusSatelliteScanner* self, DBusConnection* connection, DBusMessage* message);
DBusHandlerResult dvb_id_bus_satellite_scanner_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data);
static void dvb_id_bus_satellite_scanner_dbus_proxy_Run (DVBIDBusSatelliteScanner* self);
static void dvb_id_bus_satellite_scanner_dbus_proxy_Destroy (DVBIDBusSatelliteScanner* self);
static gboolean dvb_id_bus_satellite_scanner_dbus_proxy_WriteChannelsToFile (DVBIDBusSatelliteScanner* self, const char* path);
static void dvb_id_bus_satellite_scanner_dbus_proxy_AddScanningData (DVBIDBusSatelliteScanner* self, guint frequency, const char* polarization, guint symbol_rate);
static gboolean dvb_id_bus_satellite_scanner_dbus_proxy_AddScanningDataFromFile (DVBIDBusSatelliteScanner* self, const char* path);
static void dvb_id_bus_satellite_scanner_dbus_proxy_interface_init (DVBIDBusSatelliteScannerIface* iface);
enum  {
	DVB_SATELLITE_SCANNER_DUMMY_PROPERTY
};
static void dvb_satellite_scanner_real_AddScanningData (DVBIDBusSatelliteScanner* base, guint frequency, const char* polarization, guint symbol_rate);
static gboolean dvb_satellite_scanner_real_AddScanningDataFromFile (DVBIDBusSatelliteScanner* base, const char* path);
static void dvb_satellite_scanner_real_prepare (DVBScanner* base);
static DVBScannedItem* dvb_satellite_scanner_real_get_scanned_item (DVBScanner* base, const GstStructure* structure);
static DVBChannel* dvb_satellite_scanner_real_get_new_channel (DVBScanner* base);
static void dvb_satellite_scanner_real_add_values_from_structure_to_channel (DVBScanner* base, const GstStructure* delivery, DVBChannel* channel);
static gpointer dvb_satellite_scanner_parent_class = NULL;
void _dvb_satellite_scanner_dbus_unregister (DBusConnection* connection, void* user_data);
static DBusMessage* _dbus_dvb_satellite_scanner_introspect (DVBSatelliteScanner* self, DBusConnection* connection, DBusMessage* message);
static DVBIDBusSatelliteScannerIface* dvb_satellite_scanner_dvb_id_bus_satellite_scanner_parent_iface = NULL;
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);
static int _vala_strcmp0 (const char * str1, const char * str2);
static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object);

static const DBusObjectPathVTable _dvb_id_bus_satellite_scanner_dbus_path_vtable = {_dvb_id_bus_satellite_scanner_dbus_unregister, dvb_id_bus_satellite_scanner_dbus_message};
static const _DBusObjectVTable _dvb_id_bus_satellite_scanner_dbus_vtable = {dvb_id_bus_satellite_scanner_dbus_register_object};
static const DBusObjectPathVTable _dvb_satellite_scanner_dbus_path_vtable = {_dvb_satellite_scanner_dbus_unregister, dvb_satellite_scanner_dbus_message};
static const _DBusObjectVTable _dvb_satellite_scanner_dbus_vtable = {dvb_satellite_scanner_dbus_register_object};

static void g_cclosure_user_marshal_VOID__UINT_UINT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__UINT_UINT_STRING_STRING_STRING_BOOLEAN (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);

static char* string_substring (const char* self, glong offset, glong len) {
	glong string_length;
	const char* start;
	g_return_val_if_fail (self != NULL, NULL);
	string_length = g_utf8_strlen (self, -1);
	if (offset < 0) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= 0, NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < 0) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	start = g_utf8_offset_to_pointer (self, offset);
	return g_strndup (start, ((gchar*) g_utf8_offset_to_pointer (start, len)) - ((gchar*) start));
}


void dvb_id_bus_satellite_scanner_Run (DVBIDBusSatelliteScanner* self) {
	DVB_ID_BUS_SATELLITE_SCANNER_GET_INTERFACE (self)->Run (self);
}


void dvb_id_bus_satellite_scanner_Destroy (DVBIDBusSatelliteScanner* self) {
	DVB_ID_BUS_SATELLITE_SCANNER_GET_INTERFACE (self)->Destroy (self);
}


gboolean dvb_id_bus_satellite_scanner_WriteChannelsToFile (DVBIDBusSatelliteScanner* self, const char* path) {
	return DVB_ID_BUS_SATELLITE_SCANNER_GET_INTERFACE (self)->WriteChannelsToFile (self, path);
}


void dvb_id_bus_satellite_scanner_AddScanningData (DVBIDBusSatelliteScanner* self, guint frequency, const char* polarization, guint symbol_rate) {
	DVB_ID_BUS_SATELLITE_SCANNER_GET_INTERFACE (self)->AddScanningData (self, frequency, polarization, symbol_rate);
}


/* "horizontal", "vertical"
*
         * @path: Path to file containing scanning data
         * @returns: TRUE when the file has been parsed successfully
         *
         * Parses initial tuning data from a file as provided by dvb-apps
         */
gboolean dvb_id_bus_satellite_scanner_AddScanningDataFromFile (DVBIDBusSatelliteScanner* self, const char* path) {
	return DVB_ID_BUS_SATELLITE_SCANNER_GET_INTERFACE (self)->AddScanningDataFromFile (self, path);
}


void _dvb_id_bus_satellite_scanner_dbus_unregister (DBusConnection* connection, void* user_data) {
}


static DBusMessage* _dbus_dvb_id_bus_satellite_scanner_introspect (DVBIDBusSatelliteScanner* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter;
	GString* xml_data;
	char** children;
	int i;
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	xml_data = g_string_new ("<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\" \"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n");
	g_string_append (xml_data, "<node>\n<interface name=\"org.freedesktop.DBus.Introspectable\">\n  <method name=\"Introspect\">\n    <arg name=\"data\" direction=\"out\" type=\"s\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DBus.Properties\">\n  <method name=\"Get\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"out\" type=\"v\"/>\n  </method>\n  <method name=\"Set\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"in\" type=\"v\"/>\n  </method>\n  <method name=\"GetAll\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"props\" direction=\"out\" type=\"a{sv}\"/>\n  </method>\n</interface>\n<interface name=\"org.gnome.DVB.Scanner.Satellite\">\n  <method name=\"Run\">\n  </method>\n  <method name=\"Destroy\">\n  </method>\n  <method name=\"WriteChannelsToFile\">\n    <arg name=\"path\" type=\"s\" direction=\"in\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <method name=\"AddScanningData\">\n    <arg name=\"frequency\" type=\"u\" direction=\"in\"/>\n    <arg name=\"polarization\" type=\"s\" direction=\"in\"/>\n    <arg name=\"symbol_rate\" type=\"u\" direction=\"in\"/>\n  </method>\n  <method name=\"AddScanningDataFromFile\">\n    <arg name=\"path\" type=\"s\" direction=\"in\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <signal name=\"FrequencyScanned\">\n    <arg name=\"frequency\" type=\"u\"/>\n    <arg name=\"freq_left\" type=\"u\"/>\n  </signal>\n  <signal name=\"Finished\">\n  </signal>\n  <signal name=\"ChannelAdded\">\n    <arg name=\"frequency\" type=\"u\"/>\n    <arg name=\"sid\" type=\"u\"/>\n    <arg name=\"name\" type=\"s\"/>\n    <arg name=\"network\" type=\"s\"/>\n    <arg name=\"type\" type=\"s\"/>\n    <arg name=\"scrambled\" type=\"b\"/>\n  </signal>\n</interface>\n");
	dbus_connection_list_registered (connection, g_object_get_data ((GObject *) self, "dbus_object_path"), &children);
	for (i = 0; children[i]; i++) {
		g_string_append_printf (xml_data, "<node name=\"%s\"/>\n", children[i]);
	}
	g_string_append (xml_data, "</node>\n");
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &xml_data->str);
	g_string_free (xml_data, TRUE);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_satellite_scanner_property_get_all (DVBIDBusSatelliteScanner* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter, reply_iter, subiter;
	char* interface_name;
	const char* _tmp0;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &reply_iter);
	dbus_message_iter_get_basic (&iter, &_tmp0);
	dbus_message_iter_next (&iter);
	interface_name = g_strdup (_tmp0);
	if (strcmp (interface_name, "org.gnome.DVB.Scanner.Satellite") == 0) {
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_ARRAY, "{sv}", &subiter);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else {
		return NULL;
	}
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_satellite_scanner_Run (DVBIDBusSatelliteScanner* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	DBusMessage* reply;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	dvb_id_bus_satellite_scanner_Run (self);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_satellite_scanner_Destroy (DVBIDBusSatelliteScanner* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	DBusMessage* reply;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	dvb_id_bus_satellite_scanner_Destroy (self);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_satellite_scanner_WriteChannelsToFile (DVBIDBusSatelliteScanner* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	const char* path;
	const char* _tmp1;
	gboolean result;
	DBusMessage* reply;
	dbus_bool_t _tmp2;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	path = NULL;
	dbus_message_iter_get_basic (&iter, &_tmp1);
	dbus_message_iter_next (&iter);
	path = g_strdup (_tmp1);
	result = dvb_id_bus_satellite_scanner_WriteChannelsToFile (self, path);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp2 = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_BOOLEAN, &_tmp2);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_satellite_scanner_AddScanningData (DVBIDBusSatelliteScanner* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	guint frequency;
	dbus_uint32_t _tmp3;
	const char* polarization;
	const char* _tmp4;
	guint symbol_rate;
	dbus_uint32_t _tmp5;
	DBusMessage* reply;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "usu")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	frequency = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp3);
	dbus_message_iter_next (&iter);
	frequency = _tmp3;
	polarization = NULL;
	dbus_message_iter_get_basic (&iter, &_tmp4);
	dbus_message_iter_next (&iter);
	polarization = g_strdup (_tmp4);
	symbol_rate = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp5);
	dbus_message_iter_next (&iter);
	symbol_rate = _tmp5;
	dvb_id_bus_satellite_scanner_AddScanningData (self, frequency, polarization, symbol_rate);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_satellite_scanner_AddScanningDataFromFile (DVBIDBusSatelliteScanner* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	const char* path;
	const char* _tmp6;
	gboolean result;
	DBusMessage* reply;
	dbus_bool_t _tmp7;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	path = NULL;
	dbus_message_iter_get_basic (&iter, &_tmp6);
	dbus_message_iter_next (&iter);
	path = g_strdup (_tmp6);
	result = dvb_id_bus_satellite_scanner_AddScanningDataFromFile (self, path);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp7 = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_BOOLEAN, &_tmp7);
	return reply;
}


DBusHandlerResult dvb_id_bus_satellite_scanner_dbus_message (DBusConnection* connection, DBusMessage* message, void* object) {
	DBusMessage* reply;
	reply = NULL;
	if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Introspectable", "Introspect")) {
		reply = _dbus_dvb_id_bus_satellite_scanner_introspect (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Properties", "GetAll")) {
		reply = _dbus_dvb_id_bus_satellite_scanner_property_get_all (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.Scanner.Satellite", "Run")) {
		reply = _dbus_dvb_id_bus_satellite_scanner_Run (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.Scanner.Satellite", "Destroy")) {
		reply = _dbus_dvb_id_bus_satellite_scanner_Destroy (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.Scanner.Satellite", "WriteChannelsToFile")) {
		reply = _dbus_dvb_id_bus_satellite_scanner_WriteChannelsToFile (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.Scanner.Satellite", "AddScanningData")) {
		reply = _dbus_dvb_id_bus_satellite_scanner_AddScanningData (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.Scanner.Satellite", "AddScanningDataFromFile")) {
		reply = _dbus_dvb_id_bus_satellite_scanner_AddScanningDataFromFile (object, connection, message);
	}
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static void _dbus_dvb_id_bus_satellite_scanner_frequency_scanned (GObject* _sender, guint frequency, guint freq_left, DBusConnection* _connection) {
	const char * _path;
	DBusMessage *_message;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp8;
	dbus_uint32_t _tmp9;
	_path = g_object_get_data (_sender, "dbus_object_path");
	_message = dbus_message_new_signal (_path, "org.gnome.DVB.Scanner.Satellite", "FrequencyScanned");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp8 = frequency;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp8);
	_tmp9 = freq_left;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp9);
	dbus_connection_send (_connection, _message, NULL);
	dbus_message_unref (_message);
}


static void _dbus_dvb_id_bus_satellite_scanner_finished (GObject* _sender, DBusConnection* _connection) {
	const char * _path;
	DBusMessage *_message;
	DBusMessageIter _iter;
	_path = g_object_get_data (_sender, "dbus_object_path");
	_message = dbus_message_new_signal (_path, "org.gnome.DVB.Scanner.Satellite", "Finished");
	dbus_message_iter_init_append (_message, &_iter);
	dbus_connection_send (_connection, _message, NULL);
	dbus_message_unref (_message);
}


static void _dbus_dvb_id_bus_satellite_scanner_channel_added (GObject* _sender, guint frequency, guint sid, const char* name, const char* network, const char* type, gboolean scrambled, DBusConnection* _connection) {
	const char * _path;
	DBusMessage *_message;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp10;
	dbus_uint32_t _tmp11;
	const char* _tmp12;
	const char* _tmp13;
	const char* _tmp14;
	dbus_bool_t _tmp15;
	_path = g_object_get_data (_sender, "dbus_object_path");
	_message = dbus_message_new_signal (_path, "org.gnome.DVB.Scanner.Satellite", "ChannelAdded");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp10 = frequency;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp10);
	_tmp11 = sid;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp11);
	_tmp12 = name;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp12);
	_tmp13 = network;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp13);
	_tmp14 = type;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp14);
	_tmp15 = scrambled;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_BOOLEAN, &_tmp15);
	dbus_connection_send (_connection, _message, NULL);
	dbus_message_unref (_message);
}


void dvb_id_bus_satellite_scanner_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	if (!g_object_get_data (object, "dbus_object_path")) {
		g_object_set_data (object, "dbus_object_path", g_strdup (path));
		dbus_connection_register_object_path (connection, path, &_dvb_id_bus_satellite_scanner_dbus_path_vtable, object);
	}
	g_signal_connect (object, "frequency-scanned", (GCallback) _dbus_dvb_id_bus_satellite_scanner_frequency_scanned, connection);
	g_signal_connect (object, "finished", (GCallback) _dbus_dvb_id_bus_satellite_scanner_finished, connection);
	g_signal_connect (object, "channel-added", (GCallback) _dbus_dvb_id_bus_satellite_scanner_channel_added, connection);
}


static void dvb_id_bus_satellite_scanner_base_init (DVBIDBusSatelliteScannerIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_signal_new ("frequency_scanned", DVB_TYPE_ID_BUS_SATELLITE_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__UINT_UINT, G_TYPE_NONE, 2, G_TYPE_UINT, G_TYPE_UINT);
		g_signal_new ("finished", DVB_TYPE_ID_BUS_SATELLITE_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
		g_signal_new ("channel_added", DVB_TYPE_ID_BUS_SATELLITE_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__UINT_UINT_STRING_STRING_STRING_BOOLEAN, G_TYPE_NONE, 6, G_TYPE_UINT, G_TYPE_UINT, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_BOOLEAN);
		g_type_set_qdata (DVB_TYPE_ID_BUS_SATELLITE_SCANNER, g_quark_from_static_string ("DBusObjectVTable"), (void*) (&_dvb_id_bus_satellite_scanner_dbus_vtable));
	}
}


GType dvb_id_bus_satellite_scanner_get_type (void) {
	static GType dvb_id_bus_satellite_scanner_type_id = 0;
	if (dvb_id_bus_satellite_scanner_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBIDBusSatelliteScannerIface), (GBaseInitFunc) dvb_id_bus_satellite_scanner_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		dvb_id_bus_satellite_scanner_type_id = g_type_register_static (G_TYPE_INTERFACE, "DVBIDBusSatelliteScanner", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (dvb_id_bus_satellite_scanner_type_id, G_TYPE_OBJECT);
	}
	return dvb_id_bus_satellite_scanner_type_id;
}


G_DEFINE_TYPE_EXTENDED (DVBIDBusSatelliteScannerDBusProxy, dvb_id_bus_satellite_scanner_dbus_proxy, DBUS_TYPE_G_PROXY, 0, G_IMPLEMENT_INTERFACE (DVB_TYPE_ID_BUS_SATELLITE_SCANNER, dvb_id_bus_satellite_scanner_dbus_proxy_interface_init));
DVBIDBusSatelliteScanner* dvb_id_bus_satellite_scanner_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path) {
	DVBIDBusSatelliteScanner* self;
	char* filter;
	self = g_object_new (dvb_id_bus_satellite_scanner_dbus_proxy_get_type (), "connection", connection, "name", name, "path", path, "interface", "org.gnome.DVB.Scanner.Satellite", NULL);
	dbus_connection_add_filter (dbus_g_connection_get_connection (connection), dvb_id_bus_satellite_scanner_dbus_proxy_filter, self, NULL);
	filter = g_strdup_printf ("type='signal',path='%s'", path);
	dbus_bus_add_match (dbus_g_connection_get_connection (connection), filter, NULL);
	g_free (filter);
	return self;
}


static void _dbus_handle_dvb_id_bus_satellite_scanner_frequency_scanned (DVBIDBusSatelliteScanner* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	guint frequency;
	dbus_uint32_t _tmp16;
	guint freq_left;
	dbus_uint32_t _tmp17;
	DBusMessage* reply;
	if (strcmp (dbus_message_get_signature (message), "uu")) {
		return;
	}
	dbus_message_iter_init (message, &iter);
	frequency = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp16);
	dbus_message_iter_next (&iter);
	frequency = _tmp16;
	freq_left = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp17);
	dbus_message_iter_next (&iter);
	freq_left = _tmp17;
	g_signal_emit_by_name (self, "frequency-scanned", frequency, freq_left);
}


static void _dbus_handle_dvb_id_bus_satellite_scanner_finished (DVBIDBusSatelliteScanner* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	DBusMessage* reply;
	if (strcmp (dbus_message_get_signature (message), "")) {
		return;
	}
	dbus_message_iter_init (message, &iter);
	g_signal_emit_by_name (self, "finished");
}


static void _dbus_handle_dvb_id_bus_satellite_scanner_channel_added (DVBIDBusSatelliteScanner* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	guint frequency;
	dbus_uint32_t _tmp18;
	guint sid;
	dbus_uint32_t _tmp19;
	const char* name;
	const char* _tmp20;
	const char* network;
	const char* _tmp21;
	const char* type;
	const char* _tmp22;
	gboolean scrambled;
	dbus_bool_t _tmp23;
	DBusMessage* reply;
	if (strcmp (dbus_message_get_signature (message), "uusssb")) {
		return;
	}
	dbus_message_iter_init (message, &iter);
	frequency = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp18);
	dbus_message_iter_next (&iter);
	frequency = _tmp18;
	sid = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp19);
	dbus_message_iter_next (&iter);
	sid = _tmp19;
	name = NULL;
	dbus_message_iter_get_basic (&iter, &_tmp20);
	dbus_message_iter_next (&iter);
	name = g_strdup (_tmp20);
	network = NULL;
	dbus_message_iter_get_basic (&iter, &_tmp21);
	dbus_message_iter_next (&iter);
	network = g_strdup (_tmp21);
	type = NULL;
	dbus_message_iter_get_basic (&iter, &_tmp22);
	dbus_message_iter_next (&iter);
	type = g_strdup (_tmp22);
	scrambled = FALSE;
	dbus_message_iter_get_basic (&iter, &_tmp23);
	dbus_message_iter_next (&iter);
	scrambled = _tmp23;
	g_signal_emit_by_name (self, "channel-added", frequency, sid, name, network, type, scrambled);
}


DBusHandlerResult dvb_id_bus_satellite_scanner_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data) {
	if (dbus_message_is_signal (message, "org.gnome.DVB.Scanner.Satellite", "FrequencyScanned")) {
		_dbus_handle_dvb_id_bus_satellite_scanner_frequency_scanned (user_data, connection, message);
	} else if (dbus_message_is_signal (message, "org.gnome.DVB.Scanner.Satellite", "Finished")) {
		_dbus_handle_dvb_id_bus_satellite_scanner_finished (user_data, connection, message);
	} else if (dbus_message_is_signal (message, "org.gnome.DVB.Scanner.Satellite", "ChannelAdded")) {
		_dbus_handle_dvb_id_bus_satellite_scanner_channel_added (user_data, connection, message);
	}
	return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
}


static void dvb_id_bus_satellite_scanner_dbus_proxy_class_init (DVBIDBusSatelliteScannerDBusProxyClass* klass) {
}


static void dvb_id_bus_satellite_scanner_dbus_proxy_init (DVBIDBusSatelliteScannerDBusProxy* self) {
}


static void dvb_id_bus_satellite_scanner_dbus_proxy_Run (DVBIDBusSatelliteScanner* self) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.Scanner.Satellite", "Run");
	dbus_message_iter_init_append (_message, &_iter);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_unref (_reply);
}


static void dvb_id_bus_satellite_scanner_dbus_proxy_Destroy (DVBIDBusSatelliteScanner* self) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.Scanner.Satellite", "Destroy");
	dbus_message_iter_init_append (_message, &_iter);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_unref (_reply);
}


static gboolean dvb_id_bus_satellite_scanner_dbus_proxy_WriteChannelsToFile (DVBIDBusSatelliteScanner* self, const char* path) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	const char* _tmp24;
	gboolean _result;
	dbus_bool_t _tmp25;
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.Scanner.Satellite", "WriteChannelsToFile");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp24 = path;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp24);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp25);
	dbus_message_iter_next (&_iter);
	_result = _tmp25;
	dbus_message_unref (_reply);
	return _result;
}


static void dvb_id_bus_satellite_scanner_dbus_proxy_AddScanningData (DVBIDBusSatelliteScanner* self, guint frequency, const char* polarization, guint symbol_rate) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp26;
	const char* _tmp27;
	dbus_uint32_t _tmp28;
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.Scanner.Satellite", "AddScanningData");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp26 = frequency;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp26);
	_tmp27 = polarization;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp27);
	_tmp28 = symbol_rate;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp28);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_unref (_reply);
}


static gboolean dvb_id_bus_satellite_scanner_dbus_proxy_AddScanningDataFromFile (DVBIDBusSatelliteScanner* self, const char* path) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	const char* _tmp29;
	gboolean _result;
	dbus_bool_t _tmp30;
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.Scanner.Satellite", "AddScanningDataFromFile");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp29 = path;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp29);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp30);
	dbus_message_iter_next (&_iter);
	_result = _tmp30;
	dbus_message_unref (_reply);
	return _result;
}


static void dvb_id_bus_satellite_scanner_dbus_proxy_interface_init (DVBIDBusSatelliteScannerIface* iface) {
	iface->Run = dvb_id_bus_satellite_scanner_dbus_proxy_Run;
	iface->Destroy = dvb_id_bus_satellite_scanner_dbus_proxy_Destroy;
	iface->WriteChannelsToFile = dvb_id_bus_satellite_scanner_dbus_proxy_WriteChannelsToFile;
	iface->AddScanningData = dvb_id_bus_satellite_scanner_dbus_proxy_AddScanningData;
	iface->AddScanningDataFromFile = dvb_id_bus_satellite_scanner_dbus_proxy_AddScanningDataFromFile;
}


DVBSatelliteScanner* dvb_satellite_scanner_construct (GType object_type, DVBDevice* device) {
	GParameter * __params;
	GParameter * __params_it;
	DVBSatelliteScanner * self;
	g_return_val_if_fail (device != NULL, NULL);
	__params = g_new0 (GParameter, 1);
	__params_it = __params;
	__params_it->name = "Device";
	g_value_init (&__params_it->value, DVB_TYPE_DEVICE);
	g_value_set_object (&__params_it->value, device);
	__params_it++;
	self = g_object_newv (object_type, __params_it - __params, __params);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


DVBSatelliteScanner* dvb_satellite_scanner_new (DVBDevice* device) {
	return dvb_satellite_scanner_construct (DVB_TYPE_SATELLITE_SCANNER, device);
}


static void dvb_satellite_scanner_real_AddScanningData (DVBIDBusSatelliteScanner* base, guint frequency, const char* polarization, guint symbol_rate) {
	DVBSatelliteScanner * self;
	GstStructure* tuning_params;
	GstStructure* _tmp0;
	self = (DVBSatelliteScanner*) base;
	g_return_if_fail (polarization != NULL);
	tuning_params = gst_structure_new ("tuning_params", "frequency", G_TYPE_UINT, frequency, "symbol-rate", G_TYPE_UINT, symbol_rate, "polarization", G_TYPE_STRING, polarization, NULL);
	_tmp0 = NULL;
	dvb_scanner_add_structure_to_scan (DVB_SCANNER (self), (_tmp0 = tuning_params, tuning_params = NULL, _tmp0));
	(tuning_params == NULL) ? NULL : (tuning_params = (gst_structure_free (tuning_params), NULL));
}


static gboolean dvb_satellite_scanner_real_AddScanningDataFromFile (DVBIDBusSatelliteScanner* base, const char* path) {
	DVBSatelliteScanner * self;
	GError * inner_error;
	GFile* datafile;
	char* contents;
	gboolean _tmp8;
	self = (DVBSatelliteScanner*) base;
	g_return_val_if_fail (path != NULL, FALSE);
	inner_error = NULL;
	datafile = g_file_new_for_path (path);
	g_debug ("SatelliteScanner.vala:49: Reading scanning data from %s", path);
	contents = NULL;
	{
		char* _tmp0;
		char* _tmp1;
		_tmp0 = dvb_utils_read_file_contents (datafile, &inner_error);
		if (inner_error != NULL) {
			goto __catch1_g_error;
			goto __finally1;
		}
		_tmp1 = NULL;
		contents = (_tmp1 = _tmp0, contents = (g_free (contents), NULL), _tmp1);
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError * e;
		e = inner_error;
		inner_error = NULL;
		{
			g_critical ("SatelliteScanner.vala:55: Could not read %s: %s", e->message, path);
			(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
		}
	}
	__finally1:
	if (inner_error != NULL) {
		(datafile == NULL) ? NULL : (datafile = (g_object_unref (datafile), NULL));
		contents = (g_free (contents), NULL);
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
		g_clear_error (&inner_error);
		return FALSE;
	}
	if (contents == NULL) {
		gboolean _tmp2;
		return (_tmp2 = FALSE, (datafile == NULL) ? NULL : (datafile = (g_object_unref (datafile), NULL)), contents = (g_free (contents), NULL), _tmp2);
	}
	/* line looks like:
	 S freq pol sr fec*/
	{
		char** _tmp3;
		char** line_collection;
		int line_collection_length1;
		int line_it;
		_tmp3 = NULL;
		line_collection = _tmp3 = g_strsplit (contents, "\n", 0);
		line_collection_length1 = _vala_array_length (_tmp3);
		for (line_it = 0; line_it < _vala_array_length (_tmp3); line_it = line_it + 1) {
			const char* _tmp7;
			char* line;
			_tmp7 = NULL;
			line = (_tmp7 = line_collection[line_it], (_tmp7 == NULL) ? NULL : g_strdup (_tmp7));
			{
				char** _tmp4;
				gint cols_size;
				gint cols_length1;
				char** cols;
				gint cols_length;
				guint freq;
				guint symbol_rate;
				char* pol;
				char* lower_pol;
				if (g_str_has_prefix (line, "#")) {
					line = (g_free (line), NULL);
					continue;
				}
				_tmp4 = NULL;
				cols = (_tmp4 = g_regex_split_simple ("\\s+", line, 0, 0), cols_length1 = -1, cols_size = cols_length1, _tmp4);
				cols_length = 0;
				while (cols[cols_length] != NULL) {
					cols_length++;
				}
				cols_length++;
				if (cols_length < 5) {
					line = (g_free (line), NULL);
					cols = (_vala_array_free (cols, cols_length1, (GDestroyNotify) g_free), NULL);
					continue;
				}
				freq = (guint) atoi (cols[1]);
				symbol_rate = ((guint) atoi (cols[3])) / 1000;
				pol = NULL;
				lower_pol = g_utf8_strdown (cols[2], -1);
				if (_vala_strcmp0 (lower_pol, "h") == 0) {
					char* _tmp5;
					_tmp5 = NULL;
					pol = (_tmp5 = g_strdup ("horizontal"), pol = (g_free (pol), NULL), _tmp5);
				} else {
					if (_vala_strcmp0 (lower_pol, "v") == 0) {
						char* _tmp6;
						_tmp6 = NULL;
						pol = (_tmp6 = g_strdup ("vertical"), pol = (g_free (pol), NULL), _tmp6);
					} else {
						line = (g_free (line), NULL);
						cols = (_vala_array_free (cols, cols_length1, (GDestroyNotify) g_free), NULL);
						pol = (g_free (pol), NULL);
						lower_pol = (g_free (lower_pol), NULL);
						continue;
					}
				}
				/* TODO what about fec?*/
				dvb_id_bus_satellite_scanner_AddScanningData ((DVBIDBusSatelliteScanner*) self, freq, pol, symbol_rate);
				line = (g_free (line), NULL);
				cols = (_vala_array_free (cols, cols_length1, (GDestroyNotify) g_free), NULL);
				pol = (g_free (pol), NULL);
				lower_pol = (g_free (lower_pol), NULL);
			}
		}
		line_collection = (_vala_array_free (line_collection, line_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	return (_tmp8 = TRUE, (datafile == NULL) ? NULL : (datafile = (g_object_unref (datafile), NULL)), contents = (g_free (contents), NULL), _tmp8);
}


static void dvb_satellite_scanner_real_prepare (DVBScanner* base) {
	DVBSatelliteScanner * self;
	GstElement* dvbsrc;
	char** _tmp1;
	gint uint_keys_size;
	gint uint_keys_length1;
	char** _tmp0;
	char** uint_keys;
	char* polarity;
	guint code_rate;
	self = (DVBSatelliteScanner*) base;
	g_debug ("SatelliteScanner.vala:95: Setting up pipeline for DVB-S scan");
	dvbsrc = gst_bin_get_by_name ((GST_BIN (DVB_SCANNER (self)->pipeline)), "dvbsrc");
	_tmp1 = NULL;
	_tmp0 = NULL;
	uint_keys = (_tmp1 = (_tmp0 = g_new0 (char*, 2 + 1), _tmp0[0] = g_strdup ("frequency"), _tmp0[1] = g_strdup ("symbol-rate"), _tmp0), uint_keys_length1 = 2, uint_keys_size = uint_keys_length1, _tmp1);
	{
		char** key_collection;
		int key_collection_length1;
		int key_it;
		key_collection = uint_keys;
		key_collection_length1 = uint_keys_length1;
		for (key_it = 0; key_it < uint_keys_length1; key_it = key_it + 1) {
			const char* _tmp2;
			char* key;
			_tmp2 = NULL;
			key = (_tmp2 = key_collection[key_it], (_tmp2 == NULL) ? NULL : g_strdup (_tmp2));
			{
				dvb_scanner_set_uint_property (dvbsrc, DVB_SCANNER (self)->current_tuning_params, key);
				key = (g_free (key), NULL);
			}
		}
	}
	polarity = string_substring (gst_structure_get_string (DVB_SCANNER (self)->current_tuning_params, "polarization"), (glong) 0, (glong) 1);
	g_object_set ((GObject*) dvbsrc, "polarity", polarity, NULL);
	code_rate = 0U;
	gst_structure_get_uint (DVB_SCANNER (self)->current_tuning_params, "inner-fec", &code_rate);
	g_object_set ((GObject*) dvbsrc, "code-rate-hp", code_rate, NULL);
	(dvbsrc == NULL) ? NULL : (dvbsrc = (gst_object_unref (dvbsrc), NULL));
	uint_keys = (_vala_array_free (uint_keys, uint_keys_length1, (GDestroyNotify) g_free), NULL);
	polarity = (g_free (polarity), NULL);
}


static DVBScannedItem* dvb_satellite_scanner_real_get_scanned_item (DVBScanner* base, const GstStructure* structure) {
	DVBSatelliteScanner * self;
	char* pol;
	guint freq;
	DVBScannedItem* _tmp0;
	self = (DVBSatelliteScanner*) base;
	g_return_val_if_fail (structure != NULL, NULL);
	/* dup string because get_string returns weak string*/
	pol = g_strdup_printf ("%s", gst_structure_get_string (structure, "polarization"));
	freq = 0U;
	gst_structure_get_uint (structure, "frequency", &freq);
	_tmp0 = NULL;
	return (_tmp0 = (DVBScannedItem*) dvb_scanned_sattelite_item_new (freq, pol), pol = (g_free (pol), NULL), _tmp0);
}


static DVBChannel* dvb_satellite_scanner_real_get_new_channel (DVBScanner* base) {
	DVBSatelliteScanner * self;
	self = (DVBSatelliteScanner*) base;
	return (DVBChannel*) dvb_satellite_channel_new ();
}


static void dvb_satellite_scanner_real_add_values_from_structure_to_channel (DVBScanner* base, const GstStructure* delivery, DVBChannel* channel) {
	DVBSatelliteScanner * self;
	DVBSatelliteChannel* _tmp0;
	DVBSatelliteChannel* sc;
	guint freq;
	char* _tmp1;
	guint srate;
	self = (DVBSatelliteScanner*) base;
	g_return_if_fail (delivery != NULL);
	g_return_if_fail (channel != NULL);
	if (!(DVB_IS_SATELLITE_CHANNEL (channel))) {
		return;
	}
	_tmp0 = NULL;
	sc = (_tmp0 = DVB_SATELLITE_CHANNEL (channel), (_tmp0 == NULL) ? NULL : g_object_ref (_tmp0));
	freq = 0U;
	gst_structure_get_uint (delivery, "frequency", &freq);
	dvb_channel_set_Frequency ((DVBChannel*) sc, freq);
	_tmp1 = NULL;
	dvb_satellite_channel_set_Polarization (sc, _tmp1 = string_substring (gst_structure_get_string (delivery, "polarization"), (glong) 0, (glong) 1));
	_tmp1 = (g_free (_tmp1), NULL);
	srate = 0U;
	gst_structure_get_uint (delivery, "symbol-rate", &srate);
	dvb_satellite_channel_set_SymbolRate (sc, srate);
	/* TODO*/
	dvb_satellite_channel_set_DiseqcSource (sc, -1);
	(sc == NULL) ? NULL : (sc = (g_object_unref (sc), NULL));
}


void _dvb_satellite_scanner_dbus_unregister (DBusConnection* connection, void* user_data) {
}


static DBusMessage* _dbus_dvb_satellite_scanner_introspect (DVBSatelliteScanner* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter;
	GString* xml_data;
	char** children;
	int i;
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	xml_data = g_string_new ("<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\" \"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n");
	g_string_append (xml_data, "<node>\n<interface name=\"org.freedesktop.DBus.Introspectable\">\n  <method name=\"Introspect\">\n    <arg name=\"data\" direction=\"out\" type=\"s\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DBus.Properties\">\n  <method name=\"Get\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"out\" type=\"v\"/>\n  </method>\n  <method name=\"Set\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"in\" type=\"v\"/>\n  </method>\n  <method name=\"GetAll\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"props\" direction=\"out\" type=\"a{sv}\"/>\n  </method>\n</interface>\n<interface name=\"org.gnome.DVB.Scanner.Satellite\">\n  <method name=\"Run\">\n  </method>\n  <method name=\"Destroy\">\n  </method>\n  <method name=\"WriteChannelsToFile\">\n    <arg name=\"path\" type=\"s\" direction=\"in\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <method name=\"AddScanningData\">\n    <arg name=\"frequency\" type=\"u\" direction=\"in\"/>\n    <arg name=\"polarization\" type=\"s\" direction=\"in\"/>\n    <arg name=\"symbol_rate\" type=\"u\" direction=\"in\"/>\n  </method>\n  <method name=\"AddScanningDataFromFile\">\n    <arg name=\"path\" type=\"s\" direction=\"in\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <signal name=\"FrequencyScanned\">\n    <arg name=\"frequency\" type=\"u\"/>\n    <arg name=\"freq_left\" type=\"u\"/>\n  </signal>\n  <signal name=\"Finished\">\n  </signal>\n  <signal name=\"ChannelAdded\">\n    <arg name=\"frequency\" type=\"u\"/>\n    <arg name=\"sid\" type=\"u\"/>\n    <arg name=\"name\" type=\"s\"/>\n    <arg name=\"network\" type=\"s\"/>\n    <arg name=\"type\" type=\"s\"/>\n    <arg name=\"scrambled\" type=\"b\"/>\n  </signal>\n</interface>\n");
	dbus_connection_list_registered (connection, g_object_get_data ((GObject *) self, "dbus_object_path"), &children);
	for (i = 0; children[i]; i++) {
		g_string_append_printf (xml_data, "<node name=\"%s\"/>\n", children[i]);
	}
	g_string_append (xml_data, "</node>\n");
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &xml_data->str);
	g_string_free (xml_data, TRUE);
	return reply;
}


DBusHandlerResult dvb_satellite_scanner_dbus_message (DBusConnection* connection, DBusMessage* message, void* object) {
	DBusMessage* reply;
	reply = NULL;
	if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Introspectable", "Introspect")) {
		reply = _dbus_dvb_satellite_scanner_introspect (object, connection, message);
	}
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else if (dvb_id_bus_satellite_scanner_dbus_message (connection, message, object) == DBUS_HANDLER_RESULT_HANDLED) {
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


void dvb_satellite_scanner_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	if (!g_object_get_data (object, "dbus_object_path")) {
		g_object_set_data (object, "dbus_object_path", g_strdup (path));
		dbus_connection_register_object_path (connection, path, &_dvb_satellite_scanner_dbus_path_vtable, object);
	}
	dvb_id_bus_satellite_scanner_dbus_register_object (connection, path, object);
}


static void dvb_satellite_scanner_class_init (DVBSatelliteScannerClass * klass) {
	dvb_satellite_scanner_parent_class = g_type_class_peek_parent (klass);
	DVB_SCANNER_CLASS (klass)->prepare = dvb_satellite_scanner_real_prepare;
	DVB_SCANNER_CLASS (klass)->get_scanned_item = dvb_satellite_scanner_real_get_scanned_item;
	DVB_SCANNER_CLASS (klass)->get_new_channel = dvb_satellite_scanner_real_get_new_channel;
	DVB_SCANNER_CLASS (klass)->add_values_from_structure_to_channel = dvb_satellite_scanner_real_add_values_from_structure_to_channel;
	g_type_set_qdata (DVB_TYPE_SATELLITE_SCANNER, g_quark_from_static_string ("DBusObjectVTable"), (void*) (&_dvb_satellite_scanner_dbus_vtable));
}


static void dvb_satellite_scanner_dvb_id_bus_satellite_scanner_interface_init (DVBIDBusSatelliteScannerIface * iface) {
	dvb_satellite_scanner_dvb_id_bus_satellite_scanner_parent_iface = g_type_interface_peek_parent (iface);
	iface->AddScanningData = dvb_satellite_scanner_real_AddScanningData;
	iface->AddScanningDataFromFile = dvb_satellite_scanner_real_AddScanningDataFromFile;
	iface->Run = dvb_scanner_Run;
	iface->Destroy = dvb_scanner_Destroy;
	iface->WriteChannelsToFile = dvb_scanner_WriteChannelsToFile;
}


static void dvb_satellite_scanner_instance_init (DVBSatelliteScanner * self) {
}


GType dvb_satellite_scanner_get_type (void) {
	static GType dvb_satellite_scanner_type_id = 0;
	if (dvb_satellite_scanner_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBSatelliteScannerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_satellite_scanner_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBSatelliteScanner), 0, (GInstanceInitFunc) dvb_satellite_scanner_instance_init, NULL };
		static const GInterfaceInfo dvb_id_bus_satellite_scanner_info = { (GInterfaceInitFunc) dvb_satellite_scanner_dvb_id_bus_satellite_scanner_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		dvb_satellite_scanner_type_id = g_type_register_static (DVB_TYPE_SCANNER, "DVBSatelliteScanner", &g_define_type_info, 0);
		g_type_add_interface_static (dvb_satellite_scanner_type_id, DVB_TYPE_ID_BUS_SATELLITE_SCANNER, &dvb_id_bus_satellite_scanner_info);
	}
	return dvb_satellite_scanner_type_id;
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}


static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	const _DBusObjectVTable * vtable;
	vtable = g_type_get_qdata (G_TYPE_FROM_INSTANCE (object), g_quark_from_static_string ("DBusObjectVTable"));
	if (vtable) {
		vtable->register_object (connection, path, object);
	} else {
		g_warning ("Object does not implement any D-Bus interface");
	}
}



static void g_cclosure_user_marshal_VOID__UINT_UINT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__UINT_UINT) (gpointer data1, guint arg_1, guint arg_2, gpointer data2);
	register GMarshalFunc_VOID__UINT_UINT callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__UINT_UINT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_uint (param_values + 1), g_value_get_uint (param_values + 2), data2);
}


static void g_cclosure_user_marshal_VOID__UINT_UINT_STRING_STRING_STRING_BOOLEAN (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__UINT_UINT_STRING_STRING_STRING_BOOLEAN) (gpointer data1, guint arg_1, guint arg_2, const char* arg_3, const char* arg_4, const char* arg_5, gboolean arg_6, gpointer data2);
	register GMarshalFunc_VOID__UINT_UINT_STRING_STRING_STRING_BOOLEAN callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 7);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__UINT_UINT_STRING_STRING_STRING_BOOLEAN) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_uint (param_values + 1), g_value_get_uint (param_values + 2), g_value_get_string (param_values + 3), g_value_get_string (param_values + 4), g_value_get_string (param_values + 5), g_value_get_boolean (param_values + 6), data2);
}



