
#ifndef __SRC_EPGSTORE_H__
#define __SRC_EPGSTORE_H__

#include <glib.h>
#include <glib-object.h>
#include <gee/list.h>
#include "src/Event.h"
#include "src/Channel.h"

G_BEGIN_DECLS


#define DVB_TYPE_EPG_STORE (dvb_epg_store_get_type ())
#define DVB_EPG_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_EPG_STORE, DVBEPGStore))
#define DVB_IS_EPG_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_EPG_STORE))
#define DVB_EPG_STORE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DVB_TYPE_EPG_STORE, DVBEPGStoreIface))

typedef struct _DVBEPGStore DVBEPGStore;
typedef struct _DVBEPGStoreIface DVBEPGStoreIface;

struct _DVBEPGStoreIface {
	GTypeInterface parent_iface;
	gboolean (*add_or_update_event) (DVBEPGStore* self, DVBEvent* event, DVBChannel* channel);
	DVBEvent* (*get_event) (DVBEPGStore* self, guint event_id, guint channel_sid);
	gboolean (*remove_event) (DVBEPGStore* self, guint event_id, DVBChannel* channel);
	gboolean (*contains_event) (DVBEPGStore* self, DVBEvent* event, DVBChannel* channel);
	GeeList* (*get_events) (DVBEPGStore* self, DVBChannel* channel);
};


gboolean dvb_epg_store_add_or_update_event (DVBEPGStore* self, DVBEvent* event, DVBChannel* channel);
DVBEvent* dvb_epg_store_get_event (DVBEPGStore* self, guint event_id, guint channel_sid);
gboolean dvb_epg_store_remove_event (DVBEPGStore* self, guint event_id, DVBChannel* channel);
gboolean dvb_epg_store_contains_event (DVBEPGStore* self, DVBEvent* event, DVBChannel* channel);
GeeList* dvb_epg_store_get_events (DVBEPGStore* self, DVBChannel* channel);
GType dvb_epg_store_get_type (void);


G_END_DECLS

#endif
