/* RecordingsStore.c generated by valac 0.9.7, the Vala compiler
 * generated from RecordingsStore.vala, do not modify */

/*
 * Copyright (C) 2008,2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <dbus/dbus-glib-lowlevel.h>
#include <dbus/dbus-glib.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gio/gio.h>
#include <time.h>
#include <dbus/dbus.h>


#define DVB_TYPE_ID_BUS_RECORDINGS_STORE (dvb_id_bus_recordings_store_get_type ())
#define DVB_ID_BUS_RECORDINGS_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_ID_BUS_RECORDINGS_STORE, DVBIDBusRecordingsStore))
#define DVB_IS_ID_BUS_RECORDINGS_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_ID_BUS_RECORDINGS_STORE))
#define DVB_ID_BUS_RECORDINGS_STORE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DVB_TYPE_ID_BUS_RECORDINGS_STORE, DVBIDBusRecordingsStoreIface))

typedef struct _DVBIDBusRecordingsStore DVBIDBusRecordingsStore;
typedef struct _DVBIDBusRecordingsStoreIface DVBIDBusRecordingsStoreIface;

#define DVB_TYPE_RECORDING_INFO (dvb_recording_info_get_type ())
typedef struct _DVBRecordingInfo DVBRecordingInfo;

#define DVB_TYPE_RECORDINGS_STORE (dvb_recordings_store_get_type ())
#define DVB_RECORDINGS_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_RECORDINGS_STORE, DVBRecordingsStore))
#define DVB_RECORDINGS_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_RECORDINGS_STORE, DVBRecordingsStoreClass))
#define DVB_IS_RECORDINGS_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_RECORDINGS_STORE))
#define DVB_IS_RECORDINGS_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_RECORDINGS_STORE))
#define DVB_RECORDINGS_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_RECORDINGS_STORE, DVBRecordingsStoreClass))

typedef struct _DVBRecordingsStore DVBRecordingsStore;
typedef struct _DVBRecordingsStoreClass DVBRecordingsStoreClass;
typedef struct _DVBRecordingsStorePrivate DVBRecordingsStorePrivate;

#define DVB_TYPE_RECORDING (dvb_recording_get_type ())
#define DVB_RECORDING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_RECORDING, DVBRecording))
#define DVB_RECORDING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_RECORDING, DVBRecordingClass))
#define DVB_IS_RECORDING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_RECORDING))
#define DVB_IS_RECORDING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_RECORDING))
#define DVB_RECORDING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_RECORDING, DVBRecordingClass))

typedef struct _DVBRecording DVBRecording;
typedef struct _DVBRecordingClass DVBRecordingClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define DVB_TYPE_CHANGE_TYPE (dvb_change_type_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define DVB_IO_TYPE_RECORDING_READER (dvb_io_recording_reader_get_type ())
#define DVB_IO_RECORDING_READER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_IO_TYPE_RECORDING_READER, DVBioRecordingReader))
#define DVB_IO_RECORDING_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_IO_TYPE_RECORDING_READER, DVBioRecordingReaderClass))
#define DVB_IO_IS_RECORDING_READER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_IO_TYPE_RECORDING_READER))
#define DVB_IO_IS_RECORDING_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_IO_TYPE_RECORDING_READER))
#define DVB_IO_RECORDING_READER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_IO_TYPE_RECORDING_READER, DVBioRecordingReaderClass))

typedef struct _DVBioRecordingReader DVBioRecordingReader;
typedef struct _DVBioRecordingReaderClass DVBioRecordingReaderClass;
typedef struct _DBusObjectVTable _DBusObjectVTable;

struct _DVBRecordingInfo {
	guint32 id;
	char* name;
	char* description;
	gint64 length;
	gint64 start_timestamp;
	char* channel;
	char* location;
};

struct _DVBIDBusRecordingsStoreIface {
	GTypeInterface parent_iface;
	guint32* (*GetRecordings) (DVBIDBusRecordingsStore* self, int* result_length1, GError** error);
	gboolean (*GetLocation) (DVBIDBusRecordingsStore* self, guint32 rec_id, char** location, GError** error);
	gboolean (*GetName) (DVBIDBusRecordingsStore* self, guint32 rec_id, char** name, GError** error);
	gboolean (*GetDescription) (DVBIDBusRecordingsStore* self, guint32 rec_id, char** description, GError** error);
	gboolean (*GetStartTime) (DVBIDBusRecordingsStore* self, guint32 rec_id, guint** start_time, int* start_time_length1, GError** error);
	gboolean (*GetStartTimestamp) (DVBIDBusRecordingsStore* self, guint32 rec_id, gint64* timestamp, GError** error);
	gboolean (*GetLength) (DVBIDBusRecordingsStore* self, guint32 rec_id, gint64* length, GError** error);
	gboolean (*Delete) (DVBIDBusRecordingsStore* self, guint32 rec_id, GError** error);
	gboolean (*GetChannelName) (DVBIDBusRecordingsStore* self, guint32 rec_id, char** name, GError** error);
	gboolean (*GetAllInformations) (DVBIDBusRecordingsStore* self, guint32 rec_id, DVBRecordingInfo* infos, GError** error);
};

struct _DVBRecordingsStore {
	GObject parent_instance;
	DVBRecordingsStorePrivate * priv;
};

struct _DVBRecordingsStoreClass {
	GObjectClass parent_class;
};

struct _DVBRecordingsStorePrivate {
	GeeHashMap* recordings;
	GStaticRecMutex __lock_recordings;
	guint32 last_id;
};

typedef enum  {
	DVB_CHANGE_TYPE_ADDED = 0,
	DVB_CHANGE_TYPE_DELETED = 1,
	DVB_CHANGE_TYPE_UPDATED = 2
} DVBChangeType;

struct _DBusObjectVTable {
	void (*register_object) (DBusConnection*, const char*, void*);
};


static DVBRecordingsStore* dvb_recordings_store_instance;
static DVBRecordingsStore* dvb_recordings_store_instance = NULL;
static GStaticRecMutex dvb_recordings_store_instance_mutex;
static GStaticRecMutex dvb_recordings_store_instance_mutex = {0};
static gpointer dvb_recordings_store_parent_class = NULL;
static DVBIDBusRecordingsStoreIface* dvb_recordings_store_dvb_id_bus_recordings_store_parent_iface = NULL;

DVBIDBusRecordingsStore* dvb_id_bus_recordings_store_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path);
GType dvb_recording_info_get_type (void) G_GNUC_CONST;
DVBRecordingInfo* dvb_recording_info_dup (const DVBRecordingInfo* self);
void dvb_recording_info_free (DVBRecordingInfo* self);
void dvb_recording_info_copy (const DVBRecordingInfo* self, DVBRecordingInfo* dest);
void dvb_recording_info_destroy (DVBRecordingInfo* self);
GType dvb_id_bus_recordings_store_get_type (void) G_GNUC_CONST;
GType dvb_recordings_store_get_type (void) G_GNUC_CONST;
GType dvb_recording_get_type (void) G_GNUC_CONST;
#define DVB_RECORDINGS_STORE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_TYPE_RECORDINGS_STORE, DVBRecordingsStorePrivate))
enum  {
	DVB_RECORDINGS_STORE_DUMMY_PROPERTY
};
DVBRecordingsStore* dvb_recordings_store_get_instance (void);
DVBRecordingsStore* dvb_recordings_store_new (void);
DVBRecordingsStore* dvb_recordings_store_construct (GType object_type);
void dvb_recordings_store_shutdown (void);
void dvb_recordings_store_update_last_id (DVBRecordingsStore* self, guint32 new_last_id);
gboolean dvb_recordings_store_add (DVBRecordingsStore* self, DVBRecording* rec);
guint32 dvb_recording_get_Id (DVBRecording* self);
GType dvb_change_type_get_type (void) G_GNUC_CONST;
gboolean dvb_recordings_store_add_and_monitor (DVBRecordingsStore* self, DVBRecording* rec);
void dvb_recording_monitor_recording (DVBRecording* self);
void dvb_recordings_store_remove (DVBRecordingsStore* self, DVBRecording* rec);
guint32 dvb_recordings_store_get_next_id (DVBRecordingsStore* self);
static guint32* dvb_recordings_store_real_GetRecordings (DVBIDBusRecordingsStore* base, int* result_length1, GError** error);
static gboolean dvb_recordings_store_real_GetLocation (DVBIDBusRecordingsStore* base, guint32 rec_id, char** location, GError** error);
GFile* dvb_recording_get_Location (DVBRecording* self);
static gboolean dvb_recordings_store_real_GetName (DVBIDBusRecordingsStore* base, guint32 rec_id, char** name, GError** error);
const char* dvb_recording_get_Name (DVBRecording* self);
static gboolean dvb_recordings_store_real_GetDescription (DVBIDBusRecordingsStore* base, guint32 rec_id, char** description, GError** error);
const char* dvb_recording_get_Description (DVBRecording* self);
static gboolean dvb_recordings_store_real_GetStartTime (DVBIDBusRecordingsStore* base, guint32 rec_id, guint** start_time, int* start_time_length1, GError** error);
guint* dvb_recording_get_start (DVBRecording* self, int* result_length1);
static gboolean dvb_recordings_store_real_GetStartTimestamp (DVBIDBusRecordingsStore* base, guint32 rec_id, gint64* timestamp, GError** error);
void dvb_recording_get_StartTime (DVBRecording* self, struct tm* result);
static gboolean dvb_recordings_store_real_GetLength (DVBIDBusRecordingsStore* base, guint32 rec_id, gint64* length, GError** error);
gint64 dvb_recording_get_Length (DVBRecording* self);
static gboolean dvb_recordings_store_real_Delete (DVBIDBusRecordingsStore* base, guint32 rec_id, GError** error);
void dvb_utils_delete_dir_recursively (GFile* dir, GError** error);
static gboolean dvb_recordings_store_real_GetChannelName (DVBIDBusRecordingsStore* base, guint32 rec_id, char** name, GError** error);
const char* dvb_recording_get_ChannelName (DVBRecording* self);
static gboolean dvb_recordings_store_real_GetAllInformations (DVBIDBusRecordingsStore* base, guint32 rec_id, DVBRecordingInfo* info, GError** error);
void dvb_recordings_store_restore_from_dir (DVBRecordingsStore* self, GFile* recordingsbasedir);
DVBioRecordingReader* dvb_io_recording_reader_new (GFile* recordingsbasedir, DVBRecordingsStore* recstore);
DVBioRecordingReader* dvb_io_recording_reader_construct (GType object_type, GFile* recordingsbasedir, DVBRecordingsStore* recstore);
GType dvb_io_recording_reader_get_type (void) G_GNUC_CONST;
gboolean dvb_io_recording_reader_load_into (DVBioRecordingReader* self);
static GObject * dvb_recordings_store_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object);
static void _vala_dbus_unregister_object (gpointer connection, GObject* object);
void dvb_recordings_store_dbus_register_object (DBusConnection* connection, const char* path, void* object);
void _dvb_recordings_store_dbus_unregister (DBusConnection* connection, void* _user_data_);
DBusHandlerResult dvb_recordings_store_dbus_message (DBusConnection* connection, DBusMessage* message, void* object);
static DBusHandlerResult _dbus_dvb_recordings_store_introspect (DVBRecordingsStore* self, DBusConnection* connection, DBusMessage* message);
static void dvb_recordings_store_finalize (GObject* obj);

static const DBusObjectPathVTable _dvb_recordings_store_dbus_path_vtable = {_dvb_recordings_store_dbus_unregister, dvb_recordings_store_dbus_message};
static const _DBusObjectVTable _dvb_recordings_store_dbus_vtable = {dvb_recordings_store_dbus_register_object};


DVBRecordingsStore* dvb_recordings_store_get_instance (void) {
	DVBRecordingsStore* result = NULL;
	g_static_rec_mutex_lock (&dvb_recordings_store_instance_mutex);
	if (dvb_recordings_store_instance == NULL) {
		DVBRecordingsStore* _tmp0_;
		dvb_recordings_store_instance = (_tmp0_ = dvb_recordings_store_new (), _g_object_unref0 (dvb_recordings_store_instance), _tmp0_);
	}
	g_static_rec_mutex_unlock (&dvb_recordings_store_instance_mutex);
	result = dvb_recordings_store_instance;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void dvb_recordings_store_shutdown (void) {
	DVBRecordingsStore* rs;
	g_static_rec_mutex_lock (&dvb_recordings_store_instance_mutex);
	rs = _g_object_ref0 (dvb_recordings_store_instance);
	if (rs != NULL) {
		DVBRecordingsStore* _tmp0_;
		gee_abstract_map_clear ((GeeAbstractMap*) rs->priv->recordings);
		dvb_recordings_store_instance = (_tmp0_ = NULL, _g_object_unref0 (dvb_recordings_store_instance), _tmp0_);
	}
	g_static_rec_mutex_unlock (&dvb_recordings_store_instance_mutex);
	_g_object_unref0 (rs);
}


void dvb_recordings_store_update_last_id (DVBRecordingsStore* self, guint32 new_last_id) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		g_static_rec_mutex_lock (&self->priv->__lock_recordings);
		{
			if (new_last_id > self->priv->last_id) {
				self->priv->last_id = new_last_id;
			}
		}
		__finally126:
		{
			g_static_rec_mutex_unlock (&self->priv->__lock_recordings);
		}
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


gboolean dvb_recordings_store_add (DVBRecordingsStore* self, DVBRecording* rec) {
	gboolean result = FALSE;
	guint32 id;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (rec != NULL, FALSE);
	id = dvb_recording_get_Id (rec);
	{
		g_static_rec_mutex_lock (&self->priv->__lock_recordings);
		{
			if (gee_abstract_map_has_key ((GeeAbstractMap*) self->priv->recordings, GUINT_TO_POINTER (id))) {
				g_critical ("RecordingsStore.vala:70: Recording with id %u already available", (guint) id);
				result = FALSE;
				{
					g_static_rec_mutex_unlock (&self->priv->__lock_recordings);
				}
				return result;
			}
			if (dvb_recording_get_Id (rec) > self->priv->last_id) {
				self->priv->last_id = dvb_recording_get_Id (rec);
			}
			gee_abstract_map_set ((GeeAbstractMap*) self->priv->recordings, GUINT_TO_POINTER (id), rec);
			g_signal_emit_by_name ((DVBIDBusRecordingsStore*) self, "changed", id, (guint) DVB_CHANGE_TYPE_ADDED);
		}
		__finally127:
		{
			g_static_rec_mutex_unlock (&self->priv->__lock_recordings);
		}
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = TRUE;
	return result;
}


gboolean dvb_recordings_store_add_and_monitor (DVBRecordingsStore* self, DVBRecording* rec) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (rec != NULL, FALSE);
	if (dvb_recordings_store_add (self, rec)) {
		dvb_recording_monitor_recording (rec);
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


void dvb_recordings_store_remove (DVBRecordingsStore* self, DVBRecording* rec) {
	guint32 rec_id;
	g_return_if_fail (self != NULL);
	g_return_if_fail (rec != NULL);
	rec_id = dvb_recording_get_Id (rec);
	gee_abstract_map_unset ((GeeAbstractMap*) self->priv->recordings, GUINT_TO_POINTER (rec_id), NULL);
	g_signal_emit_by_name ((DVBIDBusRecordingsStore*) self, "changed", rec_id, (guint) DVB_CHANGE_TYPE_DELETED);
}


guint32 dvb_recordings_store_get_next_id (DVBRecordingsStore* self) {
	guint32 result = 0U;
	guint32 val = 0U;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0U);
	{
		g_static_rec_mutex_lock (&self->priv->__lock_recordings);
		{
			val = self->priv->last_id = self->priv->last_id + 1;
		}
		__finally128:
		{
			g_static_rec_mutex_unlock (&self->priv->__lock_recordings);
		}
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0U;
		}
	}
	result = val;
	return result;
}


/**
         * @returns: A list of ids for all recordings
         */
static guint32* dvb_recordings_store_real_GetRecordings (DVBIDBusRecordingsStore* base, int* result_length1, GError** error) {
	DVBRecordingsStore * self;
	guint32* result = NULL;
	gint ids_length1;
	gint _ids_size_;
	guint32* ids;
	guint32* _tmp4_;
	GError * _inner_error_ = NULL;
	self = (DVBRecordingsStore*) base;
	ids = (ids_length1 = 0, NULL);
	{
		g_static_rec_mutex_lock (&self->priv->__lock_recordings);
		{
			gint _tmp0_;
			guint32* _tmp1_;
			gint i;
			ids = (_tmp1_ = g_new0 (guint32, _tmp0_ = gee_map_get_size ((GeeMap*) self->priv->recordings)), ids = (g_free (ids), NULL), ids_length1 = _tmp0_, _ids_size_ = ids_length1, _tmp1_);
			i = 0;
			{
				GeeSet* _tmp2_;
				GeeIterator* _tmp3_;
				GeeIterator* _key_it;
				_key_it = (_tmp3_ = gee_iterable_iterator ((GeeIterable*) (_tmp2_ = gee_map_get_keys ((GeeMap*) self->priv->recordings))), _g_object_unref0 (_tmp2_), _tmp3_);
				while (TRUE) {
					guint32 key;
					if (!gee_iterator_next (_key_it)) {
						break;
					}
					key = GPOINTER_TO_UINT (gee_iterator_get (_key_it));
					ids[i] = key;
					i++;
				}
				_g_object_unref0 (_key_it);
			}
		}
		__finally129:
		{
			g_static_rec_mutex_unlock (&self->priv->__lock_recordings);
		}
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DBUS_GERROR) {
				g_propagate_error (error, _inner_error_);
				ids = (g_free (ids), NULL);
				return NULL;
			} else {
				ids = (g_free (ids), NULL);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	}
	result = (_tmp4_ = ids, *result_length1 = ids_length1, _tmp4_);
	return result;
	ids = (g_free (ids), NULL);
}


/**
         * @rec_id: The id of the recording
         * @location: The location of the recording on the filesystem
         * @returns: TRUE on success
         */
static gboolean dvb_recordings_store_real_GetLocation (DVBIDBusRecordingsStore* base, guint32 rec_id, char** location, GError** error) {
	DVBRecordingsStore * self;
	gboolean result = FALSE;
	gboolean ret;
	GError * _inner_error_ = NULL;
	self = (DVBRecordingsStore*) base;
	if (location != NULL) {
		*location = NULL;
	}
	ret = FALSE;
	{
		g_static_rec_mutex_lock (&self->priv->__lock_recordings);
		{
			if (gee_abstract_map_has_key ((GeeAbstractMap*) self->priv->recordings, GUINT_TO_POINTER (rec_id))) {
				DVBRecording* _tmp0_;
				char* _tmp1_;
				*location = (_tmp1_ = g_file_get_uri (dvb_recording_get_Location (_tmp0_ = (DVBRecording*) gee_abstract_map_get ((GeeAbstractMap*) self->priv->recordings, GUINT_TO_POINTER (rec_id)))), _g_free0 (*location), _tmp1_);
				_g_object_unref0 (_tmp0_);
				ret = TRUE;
			}
		}
		__finally130:
		{
			g_static_rec_mutex_unlock (&self->priv->__lock_recordings);
		}
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DBUS_GERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	if (!ret) {
		char* _tmp2_;
		*location = (_tmp2_ = g_strdup (""), _g_free0 (*location), _tmp2_);
	}
	result = ret;
	return result;
}


/**
         * @rec_id: The id of the recording
         * @name: The name of the recording (e.g. the name of
         * a TV show)
         * @returns: TRUE on success
         */
static gboolean dvb_recordings_store_real_GetName (DVBIDBusRecordingsStore* base, guint32 rec_id, char** name, GError** error) {
	DVBRecordingsStore * self;
	gboolean result = FALSE;
	gboolean ret;
	GError * _inner_error_ = NULL;
	self = (DVBRecordingsStore*) base;
	if (name != NULL) {
		*name = NULL;
	}
	ret = FALSE;
	{
		g_static_rec_mutex_lock (&self->priv->__lock_recordings);
		{
			if (gee_abstract_map_has_key ((GeeAbstractMap*) self->priv->recordings, GUINT_TO_POINTER (rec_id))) {
				DVBRecording* _tmp0_;
				char* _tmp1_;
				char* val;
				const char* _tmp2_;
				char* _tmp3_;
				val = (_tmp1_ = g_strdup (dvb_recording_get_Name (_tmp0_ = (DVBRecording*) gee_abstract_map_get ((GeeAbstractMap*) self->priv->recordings, GUINT_TO_POINTER (rec_id)))), _g_object_unref0 (_tmp0_), _tmp1_);
				_tmp2_ = NULL;
				if (val == NULL) {
					_tmp2_ = "";
				} else {
					_tmp2_ = val;
				}
				*name = (_tmp3_ = g_strdup (_tmp2_), _g_free0 (*name), _tmp3_);
				ret = TRUE;
				_g_free0 (val);
			}
		}
		__finally131:
		{
			g_static_rec_mutex_unlock (&self->priv->__lock_recordings);
		}
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DBUS_GERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	if (!ret) {
		char* _tmp4_;
		*name = (_tmp4_ = g_strdup (""), _g_free0 (*name), _tmp4_);
	}
	result = ret;
	return result;
}


/**
         * @rec_id: The id of the recording
         * @description: A short text describing the recorded item
         * (e.g. the description from EPG)
         * @returns: TRUE on success
         */
static gboolean dvb_recordings_store_real_GetDescription (DVBIDBusRecordingsStore* base, guint32 rec_id, char** description, GError** error) {
	DVBRecordingsStore * self;
	gboolean result = FALSE;
	gboolean ret;
	GError * _inner_error_ = NULL;
	self = (DVBRecordingsStore*) base;
	if (description != NULL) {
		*description = NULL;
	}
	ret = FALSE;
	{
		g_static_rec_mutex_lock (&self->priv->__lock_recordings);
		{
			if (gee_abstract_map_has_key ((GeeAbstractMap*) self->priv->recordings, GUINT_TO_POINTER (rec_id))) {
				DVBRecording* _tmp0_;
				char* _tmp1_;
				char* val;
				const char* _tmp2_;
				char* _tmp3_;
				val = (_tmp1_ = g_strdup (dvb_recording_get_Description (_tmp0_ = (DVBRecording*) gee_abstract_map_get ((GeeAbstractMap*) self->priv->recordings, GUINT_TO_POINTER (rec_id)))), _g_object_unref0 (_tmp0_), _tmp1_);
				_tmp2_ = NULL;
				if (val == NULL) {
					_tmp2_ = "";
				} else {
					_tmp2_ = val;
				}
				*description = (_tmp3_ = g_strdup (_tmp2_), _g_free0 (*description), _tmp3_);
				ret = TRUE;
				_g_free0 (val);
			}
		}
		__finally132:
		{
			g_static_rec_mutex_unlock (&self->priv->__lock_recordings);
		}
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DBUS_GERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	if (!ret) {
		char* _tmp4_;
		*description = (_tmp4_ = g_strdup (""), _g_free0 (*description), _tmp4_);
	}
	result = ret;
	return result;
}


/**
         * @rec_id: The id of the recording
         * @start_time: The starting time of the recording
         * @returns: TRUE on success
         */
static gboolean dvb_recordings_store_real_GetStartTime (DVBIDBusRecordingsStore* base, guint32 rec_id, guint** start_time, int* start_time_length1, GError** error) {
	DVBRecordingsStore * self;
	gboolean result = FALSE;
	gboolean ret = FALSE;
	GError * _inner_error_ = NULL;
	self = (DVBRecordingsStore*) base;
	if (start_time != NULL) {
		*start_time = NULL;
	}
	{
		g_static_rec_mutex_lock (&self->priv->__lock_recordings);
		{
			if (gee_abstract_map_has_key ((GeeAbstractMap*) self->priv->recordings, GUINT_TO_POINTER (rec_id))) {
				DVBRecording* _tmp0_;
				gint _tmp1_;
				guint* _tmp2_;
				*start_time = (_tmp2_ = dvb_recording_get_start (_tmp0_ = (DVBRecording*) gee_abstract_map_get ((GeeAbstractMap*) self->priv->recordings, GUINT_TO_POINTER (rec_id)), &_tmp1_), *start_time = (g_free (*start_time), NULL), *start_time_length1 = _tmp1_, _tmp2_);
				_g_object_unref0 (_tmp0_);
				ret = TRUE;
			} else {
				guint* _tmp3_ = NULL;
				guint* _tmp4_;
				*start_time = (_tmp4_ = (_tmp3_ = g_new0 (guint, 0), _tmp3_), *start_time = (g_free (*start_time), NULL), *start_time_length1 = 0, _tmp4_);
				ret = FALSE;
			}
		}
		__finally133:
		{
			g_static_rec_mutex_unlock (&self->priv->__lock_recordings);
		}
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DBUS_GERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	result = ret;
	return result;
}


/**
         * @rec_id: The id of the recording
         * @timestamp: Start time as UNIX timestamp
         * @returns: TRUE on success
         */
static gboolean dvb_recordings_store_real_GetStartTimestamp (DVBIDBusRecordingsStore* base, guint32 rec_id, gint64* timestamp, GError** error) {
	DVBRecordingsStore * self;
	gboolean result = FALSE;
	gboolean ret;
	GError * _inner_error_ = NULL;
	self = (DVBRecordingsStore*) base;
	ret = FALSE;
	{
		g_static_rec_mutex_lock (&self->priv->__lock_recordings);
		{
			if (gee_abstract_map_has_key ((GeeAbstractMap*) self->priv->recordings, GUINT_TO_POINTER (rec_id))) {
				DVBRecording* _tmp0_;
				struct tm _tmp1_ = {0};
				struct tm _tmp2_;
				*timestamp = (gint64) mktime ((_tmp2_ = (dvb_recording_get_StartTime (_tmp0_ = (DVBRecording*) gee_abstract_map_get ((GeeAbstractMap*) self->priv->recordings, GUINT_TO_POINTER (rec_id)), &_tmp1_), _tmp1_), &_tmp2_));
				_g_object_unref0 (_tmp0_);
				ret = TRUE;
			}
		}
		__finally134:
		{
			g_static_rec_mutex_unlock (&self->priv->__lock_recordings);
		}
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DBUS_GERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	result = ret;
	return result;
}


/**
         * @rec_id: The id of the recording
         * @length: The length of the recording in seconds
         * @returns: TRUE on success
         */
static gboolean dvb_recordings_store_real_GetLength (DVBIDBusRecordingsStore* base, guint32 rec_id, gint64* length, GError** error) {
	DVBRecordingsStore * self;
	gboolean result = FALSE;
	gboolean ret;
	GError * _inner_error_ = NULL;
	self = (DVBRecordingsStore*) base;
	ret = FALSE;
	{
		g_static_rec_mutex_lock (&self->priv->__lock_recordings);
		{
			if (gee_abstract_map_has_key ((GeeAbstractMap*) self->priv->recordings, GUINT_TO_POINTER (rec_id))) {
				DVBRecording* _tmp0_;
				*length = dvb_recording_get_Length (_tmp0_ = (DVBRecording*) gee_abstract_map_get ((GeeAbstractMap*) self->priv->recordings, GUINT_TO_POINTER (rec_id)));
				_g_object_unref0 (_tmp0_);
				ret = TRUE;
			}
		}
		__finally135:
		{
			g_static_rec_mutex_unlock (&self->priv->__lock_recordings);
		}
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DBUS_GERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	result = ret;
	return result;
}


/**
         * @rec_id: The id of the recording
         * @returns: TRUE on success, FALSE otherwises
         *
         * Delete the recording. This deletes all files in the directory
         * created by the Recorder
         */
static gboolean dvb_recordings_store_real_Delete (DVBIDBusRecordingsStore* base, guint32 rec_id, GError** error) {
	DVBRecordingsStore * self;
	gboolean result = FALSE;
	gboolean val;
	GError * _inner_error_ = NULL;
	self = (DVBRecordingsStore*) base;
	val = FALSE;
	{
		g_static_rec_mutex_lock (&self->priv->__lock_recordings);
		{
			if (!gee_abstract_map_has_key ((GeeAbstractMap*) self->priv->recordings, GUINT_TO_POINTER (rec_id))) {
				val = FALSE;
			} else {
				DVBRecording* rec;
				g_debug ("RecordingsStore.vala:245: Deleting recording %u", (guint) rec_id);
				rec = (DVBRecording*) gee_abstract_map_get ((GeeAbstractMap*) self->priv->recordings, GUINT_TO_POINTER (rec_id));
				{
					GFile* _tmp0_;
					dvb_utils_delete_dir_recursively (_tmp0_ = g_file_get_parent (dvb_recording_get_Location (rec)), &_inner_error_);
					_g_object_unref0 (_tmp0_);
					if (_inner_error_ != NULL) {
						goto __catch137_g_error;
					}
					val = TRUE;
				}
				goto __finally137;
				__catch137_g_error:
				{
					GError * e;
					e = _inner_error_;
					_inner_error_ = NULL;
					{
						g_critical ("RecordingsStore.vala:251: Could not delete recording: %s", e->message);
						val = FALSE;
						_g_error_free0 (e);
					}
				}
				__finally137:
				if (_inner_error_ != NULL) {
					_g_object_unref0 (rec);
					_g_object_unref0 (rec);
					{
						g_static_rec_mutex_unlock (&self->priv->__lock_recordings);
					}
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return FALSE;
				}
				dvb_recordings_store_remove (self, rec);
				_g_object_unref0 (rec);
			}
		}
		__finally136:
		{
			g_static_rec_mutex_unlock (&self->priv->__lock_recordings);
		}
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DBUS_GERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	result = val;
	return result;
}


/**
         * @rec_id: The id of the recording
         * @name: The channel's name or an empty string if
         * rec_id doesn't exist
         * @returns: TRUE on success
         */
static gboolean dvb_recordings_store_real_GetChannelName (DVBIDBusRecordingsStore* base, guint32 rec_id, char** name, GError** error) {
	DVBRecordingsStore * self;
	gboolean result = FALSE;
	gboolean ret;
	GError * _inner_error_ = NULL;
	self = (DVBRecordingsStore*) base;
	if (name != NULL) {
		*name = NULL;
	}
	ret = FALSE;
	{
		g_static_rec_mutex_lock (&self->priv->__lock_recordings);
		{
			if (gee_abstract_map_has_key ((GeeAbstractMap*) self->priv->recordings, GUINT_TO_POINTER (rec_id))) {
				DVBRecording* rec;
				char* _tmp0_;
				rec = (DVBRecording*) gee_abstract_map_get ((GeeAbstractMap*) self->priv->recordings, GUINT_TO_POINTER (rec_id));
				*name = (_tmp0_ = g_strdup (dvb_recording_get_ChannelName (rec)), _g_free0 (*name), _tmp0_);
				ret = TRUE;
				_g_object_unref0 (rec);
			}
		}
		__finally138:
		{
			g_static_rec_mutex_unlock (&self->priv->__lock_recordings);
		}
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DBUS_GERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	if (!ret) {
		char* _tmp1_;
		*name = (_tmp1_ = g_strdup (""), _g_free0 (*name), _tmp1_);
	}
	result = ret;
	return result;
}


static gboolean dvb_recordings_store_real_GetAllInformations (DVBIDBusRecordingsStore* base, guint32 rec_id, DVBRecordingInfo* info, GError** error) {
	DVBRecordingsStore * self;
	gboolean result = FALSE;
	gboolean ret = FALSE;
	DVBRecordingInfo _tmp0_ = {0};
	DVBRecordingInfo _tmp1_;
	GError * _inner_error_ = NULL;
	self = (DVBRecordingsStore*) base;
	*info = (_tmp1_ = (memset (&_tmp0_, 0, sizeof (DVBRecordingInfo)), _tmp0_), dvb_recording_info_destroy (info), _tmp1_);
	{
		g_static_rec_mutex_lock (&self->priv->__lock_recordings);
		{
			if (gee_abstract_map_has_key ((GeeAbstractMap*) self->priv->recordings, GUINT_TO_POINTER (rec_id))) {
				DVBRecording* rec;
				char* name;
				const char* _tmp2_;
				char* _tmp3_;
				const char* _tmp4_;
				char* _tmp5_;
				char* _tmp6_;
				struct tm _tmp7_ = {0};
				struct tm _tmp8_;
				char* _tmp9_;
				rec = (DVBRecording*) gee_abstract_map_get ((GeeAbstractMap*) self->priv->recordings, GUINT_TO_POINTER (rec_id));
				name = g_strdup (dvb_recording_get_Name (rec));
				_tmp2_ = NULL;
				if (name == NULL) {
					_tmp2_ = "";
				} else {
					_tmp2_ = name;
				}
				(*info).name = (_tmp3_ = g_strdup (_tmp2_), _g_free0 ((*info).name), _tmp3_);
				(*info).id = rec_id;
				(*info).length = dvb_recording_get_Length (rec);
				_tmp4_ = NULL;
				if (dvb_recording_get_Description (rec) == NULL) {
					_tmp4_ = "";
				} else {
					_tmp4_ = dvb_recording_get_Description (rec);
				}
				(*info).description = (_tmp5_ = g_strdup (_tmp4_), _g_free0 ((*info).description), _tmp5_);
				(*info).location = (_tmp6_ = g_file_get_path (dvb_recording_get_Location (rec)), _g_free0 ((*info).location), _tmp6_);
				(*info).start_timestamp = (gint64) mktime ((_tmp8_ = (dvb_recording_get_StartTime (rec, &_tmp7_), _tmp7_), &_tmp8_));
				(*info).channel = (_tmp9_ = g_strdup (dvb_recording_get_ChannelName (rec)), _g_free0 ((*info).channel), _tmp9_);
				ret = TRUE;
				_g_free0 (name);
				_g_object_unref0 (rec);
			} else {
				char* _tmp10_;
				char* _tmp11_;
				char* _tmp12_;
				char* _tmp13_;
				(*info).name = (_tmp10_ = g_strdup (""), _g_free0 ((*info).name), _tmp10_);
				(*info).id = (guint32) 0;
				(*info).length = (gint64) 0;
				(*info).description = (_tmp11_ = g_strdup (""), _g_free0 ((*info).description), _tmp11_);
				(*info).location = (_tmp12_ = g_strdup (""), _g_free0 ((*info).location), _tmp12_);
				(*info).start_timestamp = (gint64) 0;
				(*info).channel = (_tmp13_ = g_strdup (""), _g_free0 ((*info).channel), _tmp13_);
				ret = FALSE;
			}
		}
		__finally139:
		{
			g_static_rec_mutex_unlock (&self->priv->__lock_recordings);
		}
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DBUS_GERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	result = ret;
	return result;
}


void dvb_recordings_store_restore_from_dir (DVBRecordingsStore* self, GFile* recordingsbasedir) {
	DVBioRecordingReader* reader;
	g_return_if_fail (self != NULL);
	g_return_if_fail (recordingsbasedir != NULL);
	reader = dvb_io_recording_reader_new (recordingsbasedir, self);
	dvb_io_recording_reader_load_into (reader);
	_g_object_unref0 (reader);
}


DVBRecordingsStore* dvb_recordings_store_construct (GType object_type) {
	DVBRecordingsStore * self;
	self = (DVBRecordingsStore*) g_object_new (object_type, NULL);
	return self;
}


DVBRecordingsStore* dvb_recordings_store_new (void) {
	return dvb_recordings_store_construct (DVB_TYPE_RECORDINGS_STORE);
}


static GObject * dvb_recordings_store_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	DVBRecordingsStore * self;
	parent_class = G_OBJECT_CLASS (dvb_recordings_store_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = DVB_RECORDINGS_STORE (obj);
	{
		GeeHashMap* _tmp1_;
		self->priv->recordings = (_tmp1_ = gee_hash_map_new (G_TYPE_UINT, NULL, NULL, DVB_TYPE_RECORDING, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL), _g_object_unref0 (self->priv->recordings), _tmp1_);
		self->priv->last_id = (guint32) 0;
	}
	return obj;
}


static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	const _DBusObjectVTable * vtable;
	vtable = g_type_get_qdata (G_TYPE_FROM_INSTANCE (object), g_quark_from_static_string ("DBusObjectVTable"));
	if (vtable) {
		vtable->register_object (connection, path, object);
	} else {
		g_warning ("Object does not implement any D-Bus interface");
	}
}


static void _vala_dbus_unregister_object (gpointer connection, GObject* object) {
	char* path;
	path = g_object_steal_data ((GObject*) object, "dbus_object_path");
	dbus_connection_unregister_object_path (connection, path);
	g_free (path);
}


void _dvb_recordings_store_dbus_unregister (DBusConnection* connection, void* _user_data_) {
}


static DBusHandlerResult _dbus_dvb_recordings_store_introspect (DVBRecordingsStore* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter;
	GString* xml_data;
	char** children;
	int i;
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	xml_data = g_string_new ("<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\" \"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n");
	g_string_append (xml_data, "<node>\n<interface name=\"org.freedesktop.DBus.Introspectable\">\n  <method name=\"Introspect\">\n    <arg name=\"data\" direction=\"out\" type=\"s\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DBus.Properties\">\n  <method name=\"Get\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"out\" type=\"v\"/>\n  </method>\n  <method name=\"Set\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"in\" type=\"v\"/>\n  </method>\n  <method name=\"GetAll\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"props\" direction=\"out\" type=\"a{sv}\"/>\n  </method>\n</interface>\n<interface name=\"org.gnome.DVB.RecordingsStore\">\n  <method name=\"GetRecordings\">\n    <arg name=\"result\" type=\"au\" direction=\"out\"/>\n  </method>\n  <method name=\"GetLocation\">\n    <arg name=\"rec_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"location\" type=\"s\" direction=\"out\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <method name=\"GetName\">\n    <arg name=\"rec_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"name\" type=\"s\" direction=\"out\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <method name=\"GetDescription\">\n    <arg name=\"rec_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"description\" type=\"s\" direction=\"out\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <method name=\"GetStartTime\">\n    <arg name=\"rec_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"start_time\" type=\"au\" direction=\"out\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <method name=\"GetStartTimestamp\">\n    <arg name=\"rec_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"timestamp\" type=\"x\" direction=\"out\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <method name=\"GetLength\">\n    <arg name=\"rec_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"length\" type=\"x\" direction=\"out\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <method name=\"Delete\">\n    <arg name=\"rec_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <method name=\"GetChannelName\">\n    <arg name=\"rec_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"name\" type=\"s\" direction=\"out\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <method name=\"GetAllInformations\">\n    <arg name=\"rec_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"infos\" type=\"(ussxxss)\" direction=\"out\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <signal name=\"Changed\">\n    <arg name=\"rec_id\" type=\"u\"/>\n    <arg name=\"type\" type=\"u\"/>\n  </signal>\n</interface>\n");
	dbus_connection_list_registered (connection, g_object_get_data ((GObject *) self, "dbus_object_path"), &children);
	for (i = 0; children[i]; i++) {
		g_string_append_printf (xml_data, "<node name=\"%s\"/>\n", children[i]);
	}
	dbus_free_string_array (children);
	g_string_append (xml_data, "</node>\n");
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &xml_data->str);
	g_string_free (xml_data, TRUE);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


DBusHandlerResult dvb_recordings_store_dbus_message (DBusConnection* connection, DBusMessage* message, void* object) {
	DBusHandlerResult result;
	result = DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Introspectable", "Introspect")) {
		result = _dbus_dvb_recordings_store_introspect (object, connection, message);
	}
	if (result == DBUS_HANDLER_RESULT_HANDLED) {
		return result;
	} else if (dvb_id_bus_recordings_store_dbus_message (connection, message, object) == DBUS_HANDLER_RESULT_HANDLED) {
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


void dvb_recordings_store_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	if (!g_object_get_data (object, "dbus_object_path")) {
		g_object_set_data (object, "dbus_object_path", g_strdup (path));
		dbus_connection_register_object_path (connection, path, &_dvb_recordings_store_dbus_path_vtable, object);
		g_object_weak_ref (object, _vala_dbus_unregister_object, connection);
	}
	dvb_id_bus_recordings_store_dbus_register_object (connection, path, object);
}


static void dvb_recordings_store_class_init (DVBRecordingsStoreClass * klass) {
	GStaticRecMutex _tmp0_ = {0};
	dvb_recordings_store_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBRecordingsStorePrivate));
	G_OBJECT_CLASS (klass)->constructor = dvb_recordings_store_constructor;
	G_OBJECT_CLASS (klass)->finalize = dvb_recordings_store_finalize;
	g_type_set_qdata (DVB_TYPE_RECORDINGS_STORE, g_quark_from_static_string ("DBusObjectVTable"), (void*) (&_dvb_recordings_store_dbus_vtable));
	dvb_recordings_store_instance_mutex = (g_static_rec_mutex_init (&_tmp0_), _tmp0_);
}


static void dvb_recordings_store_dvb_id_bus_recordings_store_interface_init (DVBIDBusRecordingsStoreIface * iface) {
	dvb_recordings_store_dvb_id_bus_recordings_store_parent_iface = g_type_interface_peek_parent (iface);
	iface->GetRecordings = dvb_recordings_store_real_GetRecordings;
	iface->GetLocation = dvb_recordings_store_real_GetLocation;
	iface->GetName = dvb_recordings_store_real_GetName;
	iface->GetDescription = dvb_recordings_store_real_GetDescription;
	iface->GetStartTime = dvb_recordings_store_real_GetStartTime;
	iface->GetStartTimestamp = dvb_recordings_store_real_GetStartTimestamp;
	iface->GetLength = dvb_recordings_store_real_GetLength;
	iface->Delete = dvb_recordings_store_real_Delete;
	iface->GetChannelName = dvb_recordings_store_real_GetChannelName;
	iface->GetAllInformations = dvb_recordings_store_real_GetAllInformations;
}


static void dvb_recordings_store_instance_init (DVBRecordingsStore * self) {
	self->priv = DVB_RECORDINGS_STORE_GET_PRIVATE (self);
	g_static_rec_mutex_init (&self->priv->__lock_recordings);
}


static void dvb_recordings_store_finalize (GObject* obj) {
	DVBRecordingsStore * self;
	self = DVB_RECORDINGS_STORE (obj);
	g_static_rec_mutex_free (&self->priv->__lock_recordings);
	_g_object_unref0 (self->priv->recordings);
	G_OBJECT_CLASS (dvb_recordings_store_parent_class)->finalize (obj);
}


/**
     * This class manages the recordings off all devices
     */
GType dvb_recordings_store_get_type (void) {
	static volatile gsize dvb_recordings_store_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_recordings_store_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBRecordingsStoreClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_recordings_store_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBRecordingsStore), 0, (GInstanceInitFunc) dvb_recordings_store_instance_init, NULL };
		static const GInterfaceInfo dvb_id_bus_recordings_store_info = { (GInterfaceInitFunc) dvb_recordings_store_dvb_id_bus_recordings_store_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType dvb_recordings_store_type_id;
		dvb_recordings_store_type_id = g_type_register_static (G_TYPE_OBJECT, "DVBRecordingsStore", &g_define_type_info, 0);
		g_type_add_interface_static (dvb_recordings_store_type_id, DVB_TYPE_ID_BUS_RECORDINGS_STORE, &dvb_id_bus_recordings_store_info);
		g_once_init_leave (&dvb_recordings_store_type_id__volatile, dvb_recordings_store_type_id);
	}
	return dvb_recordings_store_type_id__volatile;
}




