
#ifndef __SRC_SCHEDULE_H__
#define __SRC_SCHEDULE_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include "src/IDBusSchedule.h"
#include "src/Channel.h"
#include "src/Event.h"
#include <dbus/dbus.h>
#include <dbus/dbus-glib.h>

G_BEGIN_DECLS


#define DVB_TYPE_EVENT_ELEMENT (dvb_event_element_get_type ())
#define DVB_EVENT_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_EVENT_ELEMENT, DVBEventElement))
#define DVB_EVENT_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_EVENT_ELEMENT, DVBEventElementClass))
#define DVB_IS_EVENT_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_EVENT_ELEMENT))
#define DVB_IS_EVENT_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_EVENT_ELEMENT))
#define DVB_EVENT_ELEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_EVENT_ELEMENT, DVBEventElementClass))

typedef struct _DVBEventElementPrivate DVBEventElementPrivate;

#define DVB_TYPE_SCHEDULE (dvb_schedule_get_type ())
#define DVB_SCHEDULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_SCHEDULE, DVBSchedule))
#define DVB_SCHEDULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_SCHEDULE, DVBScheduleClass))
#define DVB_IS_SCHEDULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_SCHEDULE))
#define DVB_IS_SCHEDULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_SCHEDULE))
#define DVB_SCHEDULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_SCHEDULE, DVBScheduleClass))

typedef struct _DVBSchedulePrivate DVBSchedulePrivate;

/**
     * We don't want to hold the complete information about
     * every event in memory. Just remember id and starttime
     * so we can have a sorted list.
     */
struct _DVBEventElement {
	GObject parent_instance;
	DVBEventElementPrivate * priv;
	guint id;
	gint64 starttime;
};

struct _DVBEventElementClass {
	GObjectClass parent_class;
};

/**
     * Represents a series of events of a channel
     */
struct _DVBSchedule {
	GObject parent_instance;
	DVBSchedulePrivate * priv;
};

struct _DVBScheduleClass {
	GObjectClass parent_class;
};


gint dvb_event_element_compare (DVBEventElement* event1, DVBEventElement* event2);
void dvb_event_element_destroy (void* data);
DVBEventElement* dvb_event_element_construct (GType object_type);
DVBEventElement* dvb_event_element_new (void);
GType dvb_event_element_get_type (void);
DVBSchedule* dvb_schedule_construct (GType object_type, DVBChannel* channel);
DVBSchedule* dvb_schedule_new (DVBChannel* channel);
void dvb_schedule_remove_expired_events (DVBSchedule* self);
DVBEvent* dvb_schedule_get (DVBSchedule* self, guint event_id);
void dvb_schedule_add (DVBSchedule* self, DVBEvent* event);
gboolean dvb_schedule_contains (DVBSchedule* self, guint event_id);
DVBEvent* dvb_schedule_get_running_event (DVBSchedule* self);
DVBChannel* dvb_schedule_get_channel (DVBSchedule* self);
void dvb_schedule_dbus_register_object (DBusConnection* connection, const char* path, void* object);
DBusHandlerResult dvb_schedule_dbus_message (DBusConnection* connection, DBusMessage* message, void* object);
GType dvb_schedule_get_type (void);


G_END_DECLS

#endif
