#define VALA_FREE_CHECKED(o,f) ((o) == NULL ? NULL : ((o) = (f (o), NULL)))

#include <src/Schedule.h>
#include <gee/map.h>
#include <time.h>
#include <gee/hashmap.h>
#include <gee/list.h>
#include <gee/iterable.h>
#include <gee/iterator.h>
#include "src/EPGStore.h"
#include <gobject/gvaluecollector.h>


#define DVB_TYPE_EVENT_ELEMENT (dvb_event_element_get_type ())
#define DVB_EVENT_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_EVENT_ELEMENT, DVBEventElement))
#define DVB_EVENT_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_EVENT_ELEMENT, DVBEventElementClass))
#define DVB_IS_EVENT_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_EVENT_ELEMENT))
#define DVB_IS_EVENT_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_EVENT_ELEMENT))
#define DVB_EVENT_ELEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_EVENT_ELEMENT, DVBEventElementClass))

typedef struct _DVBEventElementPrivate DVBEventElementPrivate;
typedef struct _DVBParamSpecEventElement DVBParamSpecEventElement;
typedef struct _DBusObjectVTable _DBusObjectVTable;

/**
     * We don't want to hold the complete information about
     * every event in memory. Just remember id and starttime
     * so we can have a sorted list.
     */
struct _DVBEventElement {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DVBEventElementPrivate * priv;
	guint id;
	gint64 starttime;
};

struct _DVBEventElementClass {
	GTypeClass parent_class;
	void (*finalize) (DVBEventElement *self);
};

struct _DVBParamSpecEventElement {
	GParamSpec parent_instance;
};

struct _DBusObjectVTable {
	void (*register_object) (DBusConnection*, const char*, void*);
};



enum  {
	DVB_EVENT_ELEMENT_DUMMY_PROPERTY
};
static gint dvb_event_element_compare (DVBEventElement* event1, DVBEventElement* event2);
static DVBEventElement* dvb_event_element_construct (GType object_type);
static DVBEventElement* dvb_event_element_new (void);
static GParamSpec* dvb_param_spec_event_element (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
static gpointer dvb_value_get_event_element (const GValue* value);
static void dvb_value_set_event_element (GValue* value, gpointer v_object);
static gpointer dvb_event_element_parent_class = NULL;
static void dvb_event_element_finalize (DVBEventElement* obj);
static GType dvb_event_element_get_type (void);
static gpointer dvb_event_element_ref (gpointer instance);
static void dvb_event_element_unref (gpointer instance);
struct _DVBSchedulePrivate {
	DVBChannel* _channel;
	GStaticRecMutex __lock_events;
	GSequence* events;
	GeeMap* event_id_map;
	DVBEPGStore* epgstore;
};

#define DVB_SCHEDULE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_TYPE_SCHEDULE, DVBSchedulePrivate))
enum  {
	DVB_SCHEDULE_DUMMY_PROPERTY,
	DVB_SCHEDULE_CHANNEL
};
static gint _dvb_event_element_compare_gcompare_data_func (void* a, void* b, gpointer self);
static void dvb_schedule_create_and_add_event_element (DVBSchedule* self, DVBEvent* event);
static guint32* dvb_schedule_real_GetAllEvents (DVBIDBusSchedule* base, int* result_length1);
static guint32 dvb_schedule_real_NowPlaying (DVBIDBusSchedule* base);
static guint32 dvb_schedule_real_Next (DVBIDBusSchedule* base, guint32 event_id);
static char* dvb_schedule_real_GetName (DVBIDBusSchedule* base, guint32 event_id);
static char* dvb_schedule_real_GetShortDescription (DVBIDBusSchedule* base, guint32 event_id);
static char* dvb_schedule_real_GetExtendedDescription (DVBIDBusSchedule* base, guint32 event_id);
static guint dvb_schedule_real_GetDuration (DVBIDBusSchedule* base, guint32 event_id);
static guint* dvb_schedule_real_GetLocalStartTime (DVBIDBusSchedule* base, guint32 event_id, int* result_length1);
static gboolean dvb_schedule_real_IsRunning (DVBIDBusSchedule* base, guint32 event_id);
static gboolean dvb_schedule_real_IsScrambled (DVBIDBusSchedule* base, guint32 event_id);
static void dvb_schedule_set_channel (DVBSchedule* self, DVBChannel* value);
static GObject * dvb_schedule_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static gpointer dvb_schedule_parent_class = NULL;
void _dvb_schedule_dbus_unregister (DBusConnection* connection, void* user_data);
static DBusMessage* _dbus_dvb_schedule_introspect (DVBSchedule* self, DBusConnection* connection, DBusMessage* message);
static DVBIDBusScheduleIface* dvb_schedule_dvb_id_bus_schedule_parent_iface = NULL;
static void dvb_schedule_finalize (GObject* obj);
static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object);

static const DBusObjectPathVTable _dvb_schedule_dbus_path_vtable = {_dvb_schedule_dbus_unregister, dvb_schedule_dbus_message};
static const _DBusObjectVTable _dvb_schedule_dbus_vtable = {dvb_schedule_dbus_register_object};


static gint dvb_event_element_compare (DVBEventElement* event1, DVBEventElement* event2) {
	gboolean _tmp0;
	_tmp0 = FALSE;
	if (event1 == NULL) {
		_tmp0 = event2 == NULL;
	} else {
		_tmp0 = FALSE;
	}
	if (_tmp0) {
		return 0;
	} else {
		gboolean _tmp2;
		_tmp2 = FALSE;
		if (event1 == NULL) {
			_tmp2 = event2 != NULL;
		} else {
			_tmp2 = FALSE;
		}
		if (_tmp2) {
			return +1;
		} else {
			gboolean _tmp4;
			_tmp4 = FALSE;
			if (event1 != NULL) {
				_tmp4 = event2 == NULL;
			} else {
				_tmp4 = FALSE;
			}
			if (_tmp4) {
				return -1;
			}
		}
	}
	if (event1->starttime < event2->starttime) {
		return -1;
	} else {
		if (event1->starttime > event2->starttime) {
			return +1;
		} else {
			return 0;
		}
	}
}


/**
     * We don't want to hold the complete information about
     * every event in memory. Just remember id and starttime
     * so we can have a sorted list.
     */
static DVBEventElement* dvb_event_element_construct (GType object_type) {
	DVBEventElement* self;
	self = (DVBEventElement*) g_type_create_instance (object_type);
	return self;
}


static DVBEventElement* dvb_event_element_new (void) {
	return dvb_event_element_construct (DVB_TYPE_EVENT_ELEMENT);
}


static void dvb_value_event_element_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void dvb_value_event_element_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		dvb_event_element_unref (value->data[0].v_pointer);
	}
}


static void dvb_value_event_element_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = dvb_event_element_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer dvb_value_event_element_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* dvb_value_event_element_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		DVBEventElement* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = dvb_event_element_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* dvb_value_event_element_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	DVBEventElement** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags && G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = dvb_event_element_ref (value->data[0].v_pointer);
	}
	return NULL;
}


static GParamSpec* dvb_param_spec_event_element (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	DVBParamSpecEventElement* spec;
	g_return_val_if_fail (g_type_is_a (object_type, DVB_TYPE_EVENT_ELEMENT), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


static gpointer dvb_value_get_event_element (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, DVB_TYPE_EVENT_ELEMENT), NULL);
	return value->data[0].v_pointer;
}


static void dvb_value_set_event_element (GValue* value, gpointer v_object) {
	DVBEventElement* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, DVB_TYPE_EVENT_ELEMENT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, DVB_TYPE_EVENT_ELEMENT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		dvb_event_element_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		dvb_event_element_unref (old);
	}
}


static void dvb_event_element_class_init (DVBEventElementClass * klass) {
	dvb_event_element_parent_class = g_type_class_peek_parent (klass);
	DVB_EVENT_ELEMENT_CLASS (klass)->finalize = dvb_event_element_finalize;
}


static void dvb_event_element_instance_init (DVBEventElement * self) {
	self->ref_count = 1;
}


static void dvb_event_element_finalize (DVBEventElement* obj) {
	DVBEventElement * self;
	self = DVB_EVENT_ELEMENT (obj);
}


static GType dvb_event_element_get_type (void) {
	static GType dvb_event_element_type_id = 0;
	if (dvb_event_element_type_id == 0) {
		static const GTypeValueTable g_define_type_value_table = { dvb_value_event_element_init, dvb_value_event_element_free_value, dvb_value_event_element_copy_value, dvb_value_event_element_peek_pointer, "p", dvb_value_event_element_collect_value, "p", dvb_value_event_element_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (DVBEventElementClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_event_element_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBEventElement), 0, (GInstanceInitFunc) dvb_event_element_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		dvb_event_element_type_id = g_type_register_fundamental (g_type_fundamental_next (), "DVBEventElement", &g_define_type_info, &g_define_type_fundamental_info, 0);
	}
	return dvb_event_element_type_id;
}


static gpointer dvb_event_element_ref (gpointer instance) {
	DVBEventElement* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


static void dvb_event_element_unref (gpointer instance) {
	DVBEventElement* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		DVB_EVENT_ELEMENT_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


DVBSchedule* dvb_schedule_construct (GType object_type, DVBChannel* channel) {
	GParameter * __params;
	GParameter * __params_it;
	DVBSchedule * self;
	g_return_val_if_fail (channel != NULL, NULL);
	__params = g_new0 (GParameter, 1);
	__params_it = __params;
	__params_it->name = "channel";
	g_value_init (&__params_it->value, DVB_TYPE_CHANNEL);
	g_value_set_object (&__params_it->value, channel);
	__params_it++;
	self = g_object_newv (object_type, __params_it - __params, __params);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


DVBSchedule* dvb_schedule_new (DVBChannel* channel) {
	return dvb_schedule_construct (DVB_TYPE_SCHEDULE, channel);
}


void dvb_schedule_remove_expired_events (DVBSchedule* self) {
	GSList* expired_events;
	g_return_if_fail (self != NULL);
	expired_events = NULL;
	g_static_rec_mutex_lock (&self->priv->__lock_events);
	{
		{
			gint i;
			i = 0;
			for (; i < g_sequence_get_length (self->priv->events); i++) {
				GSequenceIter* iter;
				DVBEventElement* _tmp0;
				DVBEventElement* element;
				DVBEvent* e;
				gboolean _tmp1;
				iter = g_sequence_get_iter_at_pos (self->priv->events, i);
				_tmp0 = NULL;
				element = (_tmp0 = (DVBEventElement*) g_sequence_get (iter), (_tmp0 == NULL) ? NULL : dvb_event_element_ref (_tmp0));
				e = dvb_schedule_get (self, element->id);
				_tmp1 = FALSE;
				if (e != NULL) {
					_tmp1 = dvb_event_has_expired (e);
				} else {
					_tmp1 = FALSE;
				}
				if (_tmp1) {
					char* _tmp2;
					_tmp2 = NULL;
					g_debug (_tmp2 = dvb_event_to_string (e));
					_tmp2 = (g_free (_tmp2), NULL);
					expired_events = g_slist_prepend (expired_events, iter);
				} else {
					/* events are sorted, all other events didn't expire, too*/
					(element == NULL) ? NULL : (element = (dvb_event_element_unref (element), NULL));
					(e == NULL) ? NULL : (e = (dvb_event_unref (e), NULL));
					break;
				}
				(element == NULL) ? NULL : (element = (dvb_event_element_unref (element), NULL));
				(e == NULL) ? NULL : (e = (dvb_event_unref (e), NULL));
			}
		}
		{
			GSList* iter_collection;
			GSList* iter_it;
			iter_collection = expired_events;
			for (iter_it = iter_collection; iter_it != NULL; iter_it = iter_it->next) {
				GSequenceIter* iter;
				iter = (GSequenceIter*) iter_it->data;
				{
					DVBEventElement* _tmp3;
					DVBEventElement* element;
					g_debug ("Schedule.vala:77: Removing expired event");
					_tmp3 = NULL;
					element = (_tmp3 = (DVBEventElement*) g_sequence_get (iter), (_tmp3 == NULL) ? NULL : dvb_event_element_ref (_tmp3));
					gee_map_remove (self->priv->event_id_map, GUINT_TO_POINTER (element->id));
					g_sequence_remove (iter);
					dvb_epg_store_remove_event (self->priv->epgstore, element->id, self->priv->_channel);
					(element == NULL) ? NULL : (element = (dvb_event_element_unref (element), NULL));
				}
			}
		}
	}
	g_static_rec_mutex_unlock (&self->priv->__lock_events);
	(expired_events == NULL) ? NULL : (expired_events = (g_slist_free (expired_events), NULL));
}


DVBEvent* dvb_schedule_get (DVBSchedule* self, guint event_id) {
	g_return_val_if_fail (self != NULL, NULL);
	return dvb_epg_store_get_event (self->priv->epgstore, event_id, dvb_channel_get_Sid (self->priv->_channel));
}


/**
         * When an event with the same id already exists, it's replaced
         */
void dvb_schedule_add (DVBSchedule* self, DVBEvent* event) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (event != NULL);
	if (dvb_event_has_expired (event)) {
		return;
	}
	g_static_rec_mutex_lock (&self->priv->__lock_events);
	{
		if (gee_map_contains (self->priv->event_id_map, GUINT_TO_POINTER (event->id))) {
			GSequenceIter* iter;
			/* Remove old event*/
			iter = (GSequenceIter*) gee_map_get (self->priv->event_id_map, GUINT_TO_POINTER (event->id));
			gee_map_remove (self->priv->event_id_map, GUINT_TO_POINTER (event->id));
			g_sequence_remove (iter);
		}
		dvb_schedule_create_and_add_event_element (self, event);
		dvb_epg_store_add_or_update_event (self->priv->epgstore, event, self->priv->_channel);
	}
	g_static_rec_mutex_unlock (&self->priv->__lock_events);
}


static gint _dvb_event_element_compare_gcompare_data_func (void* a, void* b, gpointer self) {
	return dvb_event_element_compare (a, b);
}


/**
         * Create event element from @event and add it to list of events
         */
static void dvb_schedule_create_and_add_event_element (DVBSchedule* self, DVBEvent* event) {
	DVBEventElement* element;
	struct tm utc_starttime;
	DVBEventElement* _tmp0;
	GSequenceIter* iter;
	g_return_if_fail (self != NULL);
	g_return_if_fail (event != NULL);
	element = dvb_event_element_new ();
	element->id = event->id;
	utc_starttime = dvb_event_get_utc_start_time (event);
	element->starttime = (gint64) mktime (&utc_starttime);
	_tmp0 = NULL;
	iter = g_sequence_insert_sorted (self->priv->events, (_tmp0 = element, (_tmp0 == NULL) ? NULL : dvb_event_element_ref (_tmp0)), _dvb_event_element_compare_gcompare_data_func, NULL);
	gee_map_set (self->priv->event_id_map, GUINT_TO_POINTER (event->id), iter);
	g_assert (g_sequence_get_length (self->priv->events) == gee_map_get_size (self->priv->event_id_map));
	(element == NULL) ? NULL : (element = (dvb_event_element_unref (element), NULL));
}


gboolean dvb_schedule_contains (DVBSchedule* self, guint event_id) {
	gboolean val;
	g_return_val_if_fail (self != NULL, FALSE);
	val = FALSE;
	g_static_rec_mutex_lock (&self->priv->__lock_events);
	{
		val = gee_map_contains (self->priv->event_id_map, GUINT_TO_POINTER (event_id));
	}
	g_static_rec_mutex_unlock (&self->priv->__lock_events);
	return val;
}


DVBEvent* dvb_schedule_get_running_event (DVBSchedule* self) {
	DVBEvent* running_event;
	g_return_val_if_fail (self != NULL, NULL);
	running_event = NULL;
	g_static_rec_mutex_lock (&self->priv->__lock_events);
	{
		{
			gint i;
			i = 0;
			for (; i < g_sequence_get_length (self->priv->events); i++) {
				GSequenceIter* iter;
				DVBEventElement* _tmp0;
				DVBEventElement* element;
				DVBEvent* event;
				gboolean _tmp1;
				iter = g_sequence_get_iter_at_pos (self->priv->events, i);
				_tmp0 = NULL;
				element = (_tmp0 = (DVBEventElement*) g_sequence_get (iter), (_tmp0 == NULL) ? NULL : dvb_event_element_ref (_tmp0));
				event = dvb_schedule_get (self, element->id);
				_tmp1 = FALSE;
				if (event != NULL) {
					_tmp1 = dvb_event_is_running (event);
				} else {
					_tmp1 = FALSE;
				}
				if (_tmp1) {
					DVBEvent* _tmp3;
					DVBEvent* _tmp2;
					_tmp3 = NULL;
					_tmp2 = NULL;
					running_event = (_tmp3 = (_tmp2 = event, (_tmp2 == NULL) ? NULL : dvb_event_ref (_tmp2)), (running_event == NULL) ? NULL : (running_event = (dvb_event_unref (running_event), NULL)), _tmp3);
					(element == NULL) ? NULL : (element = (dvb_event_element_unref (element), NULL));
					(event == NULL) ? NULL : (event = (dvb_event_unref (event), NULL));
					break;
				}
				(element == NULL) ? NULL : (element = (dvb_event_element_unref (element), NULL));
				(event == NULL) ? NULL : (event = (dvb_event_unref (event), NULL));
			}
		}
	}
	g_static_rec_mutex_unlock (&self->priv->__lock_events);
	return running_event;
}


/*
        public weak Event get_event_around (Time time) {
            return new Event ();
        }*/
static guint32* dvb_schedule_real_GetAllEvents (DVBIDBusSchedule* base, int* result_length1) {
	DVBSchedule * self;
	guint32* _tmp1;
	gint event_ids_length1;
	gint _tmp0;
	guint32* event_ids;
	guint32* _tmp3;
	self = (DVBSchedule*) base;
	_tmp1 = NULL;
	event_ids = (_tmp1 = g_new0 (guint32, _tmp0 = g_sequence_get_length (self->priv->events)), event_ids_length1 = _tmp0, _tmp1);
	g_static_rec_mutex_lock (&self->priv->__lock_events);
	{
		{
			gint i;
			i = 0;
			for (; i < g_sequence_get_length (self->priv->events); i++) {
				GSequenceIter* iter;
				DVBEventElement* _tmp2;
				DVBEventElement* element;
				iter = g_sequence_get_iter_at_pos (self->priv->events, i);
				_tmp2 = NULL;
				element = (_tmp2 = (DVBEventElement*) g_sequence_get (iter), (_tmp2 == NULL) ? NULL : dvb_event_element_ref (_tmp2));
				event_ids[i] = (guint32) element->id;
				(element == NULL) ? NULL : (element = (dvb_event_element_unref (element), NULL));
			}
		}
	}
	g_static_rec_mutex_unlock (&self->priv->__lock_events);
	_tmp3 = NULL;
	return (_tmp3 = event_ids, *result_length1 = event_ids_length1, _tmp3);
}


static guint32 dvb_schedule_real_NowPlaying (DVBIDBusSchedule* base) {
	DVBSchedule * self;
	DVBEvent* event;
	guint _tmp0;
	guint32 _tmp1;
	self = (DVBSchedule*) base;
	event = dvb_schedule_get_running_event (self);
	_tmp0 = 0U;
	if ((event == NULL)) {
		_tmp0 = (guint) 0;
	} else {
		_tmp0 = event->id;
	}
	return (_tmp1 = (guint32) _tmp0, (event == NULL) ? NULL : (event = (dvb_event_unref (event), NULL)), _tmp1);
}


static guint32 dvb_schedule_real_Next (DVBIDBusSchedule* base, guint32 event_id) {
	DVBSchedule * self;
	guint32 next_event;
	self = (DVBSchedule*) base;
	next_event = (guint32) 0;
	g_static_rec_mutex_lock (&self->priv->__lock_events);
	{
		if (gee_map_contains (self->priv->event_id_map, GUINT_TO_POINTER ((guint) event_id))) {
			GSequenceIter* iter;
			GSequenceIter* next_iter;
			iter = (GSequenceIter*) gee_map_get (self->priv->event_id_map, GUINT_TO_POINTER ((guint) event_id));
			next_iter = g_sequence_iter_next (iter);
			/* Check if a new event follows*/
			if (!g_sequence_iter_is_end (next_iter)) {
				DVBEventElement* _tmp0;
				DVBEventElement* element;
				_tmp0 = NULL;
				element = (_tmp0 = (DVBEventElement*) g_sequence_get (next_iter), (_tmp0 == NULL) ? NULL : dvb_event_element_ref (_tmp0));
				next_event = (guint32) element->id;
				(element == NULL) ? NULL : (element = (dvb_event_element_unref (element), NULL));
			}
		} else {
			g_debug ("Schedule.vala:191: No event with id %u", (guint) event_id);
		}
	}
	g_static_rec_mutex_unlock (&self->priv->__lock_events);
	return next_event;
}


static char* dvb_schedule_real_GetName (DVBIDBusSchedule* base, guint32 event_id) {
	DVBSchedule * self;
	char* name;
	self = (DVBSchedule*) base;
	name = g_strdup ("");
	g_static_rec_mutex_lock (&self->priv->__lock_events);
	{
		if (gee_map_contains (self->priv->event_id_map, GUINT_TO_POINTER ((guint) event_id))) {
			GSequenceIter* iter;
			DVBEventElement* _tmp0;
			DVBEventElement* element;
			DVBEvent* event;
			char* _tmp2;
			const char* _tmp1;
			iter = (GSequenceIter*) gee_map_get (self->priv->event_id_map, GUINT_TO_POINTER ((guint) event_id));
			_tmp0 = NULL;
			element = (_tmp0 = (DVBEventElement*) g_sequence_get (iter), (_tmp0 == NULL) ? NULL : dvb_event_element_ref (_tmp0));
			event = dvb_schedule_get (self, element->id);
			_tmp2 = NULL;
			_tmp1 = NULL;
			name = (_tmp2 = (_tmp1 = event->name, (_tmp1 == NULL) ? NULL : g_strdup (_tmp1)), name = (g_free (name), NULL), _tmp2);
			(element == NULL) ? NULL : (element = (dvb_event_element_unref (element), NULL));
			(event == NULL) ? NULL : (event = (dvb_event_unref (event), NULL));
		} else {
			g_debug ("Schedule.vala:208: No event with id %u", (guint) event_id);
		}
	}
	g_static_rec_mutex_unlock (&self->priv->__lock_events);
	return name;
}


static char* dvb_schedule_real_GetShortDescription (DVBIDBusSchedule* base, guint32 event_id) {
	DVBSchedule * self;
	char* desc;
	self = (DVBSchedule*) base;
	desc = g_strdup ("");
	g_static_rec_mutex_lock (&self->priv->__lock_events);
	{
		if (gee_map_contains (self->priv->event_id_map, GUINT_TO_POINTER ((guint) event_id))) {
			GSequenceIter* iter;
			DVBEventElement* _tmp0;
			DVBEventElement* element;
			DVBEvent* event;
			char* _tmp2;
			const char* _tmp1;
			iter = (GSequenceIter*) gee_map_get (self->priv->event_id_map, GUINT_TO_POINTER ((guint) event_id));
			_tmp0 = NULL;
			element = (_tmp0 = (DVBEventElement*) g_sequence_get (iter), (_tmp0 == NULL) ? NULL : dvb_event_element_ref (_tmp0));
			event = dvb_schedule_get (self, element->id);
			_tmp2 = NULL;
			_tmp1 = NULL;
			desc = (_tmp2 = (_tmp1 = event->description, (_tmp1 == NULL) ? NULL : g_strdup (_tmp1)), desc = (g_free (desc), NULL), _tmp2);
			(element == NULL) ? NULL : (element = (dvb_event_element_unref (element), NULL));
			(event == NULL) ? NULL : (event = (dvb_event_unref (event), NULL));
		} else {
			g_debug ("Schedule.vala:225: No event with id %u", (guint) event_id);
		}
	}
	g_static_rec_mutex_unlock (&self->priv->__lock_events);
	return desc;
}


static char* dvb_schedule_real_GetExtendedDescription (DVBIDBusSchedule* base, guint32 event_id) {
	DVBSchedule * self;
	char* desc;
	self = (DVBSchedule*) base;
	desc = g_strdup ("");
	g_static_rec_mutex_lock (&self->priv->__lock_events);
	{
		if (gee_map_contains (self->priv->event_id_map, GUINT_TO_POINTER ((guint) event_id))) {
			GSequenceIter* iter;
			DVBEventElement* _tmp0;
			DVBEventElement* element;
			DVBEvent* event;
			char* _tmp2;
			const char* _tmp1;
			iter = (GSequenceIter*) gee_map_get (self->priv->event_id_map, GUINT_TO_POINTER ((guint) event_id));
			_tmp0 = NULL;
			element = (_tmp0 = (DVBEventElement*) g_sequence_get (iter), (_tmp0 == NULL) ? NULL : dvb_event_element_ref (_tmp0));
			event = dvb_schedule_get (self, element->id);
			_tmp2 = NULL;
			_tmp1 = NULL;
			desc = (_tmp2 = (_tmp1 = event->extended_description, (_tmp1 == NULL) ? NULL : g_strdup (_tmp1)), desc = (g_free (desc), NULL), _tmp2);
			(element == NULL) ? NULL : (element = (dvb_event_element_unref (element), NULL));
			(event == NULL) ? NULL : (event = (dvb_event_unref (event), NULL));
		} else {
			g_debug ("Schedule.vala:242: No event with id %u", (guint) event_id);
		}
	}
	g_static_rec_mutex_unlock (&self->priv->__lock_events);
	return desc;
}


static guint dvb_schedule_real_GetDuration (DVBIDBusSchedule* base, guint32 event_id) {
	DVBSchedule * self;
	guint duration;
	self = (DVBSchedule*) base;
	duration = (guint) 0;
	g_static_rec_mutex_lock (&self->priv->__lock_events);
	{
		if (gee_map_contains (self->priv->event_id_map, GUINT_TO_POINTER ((guint) event_id))) {
			GSequenceIter* iter;
			DVBEventElement* _tmp0;
			DVBEventElement* element;
			DVBEvent* event;
			iter = (GSequenceIter*) gee_map_get (self->priv->event_id_map, GUINT_TO_POINTER ((guint) event_id));
			_tmp0 = NULL;
			element = (_tmp0 = (DVBEventElement*) g_sequence_get (iter), (_tmp0 == NULL) ? NULL : dvb_event_element_ref (_tmp0));
			event = dvb_schedule_get (self, element->id);
			duration = event->duration;
			(element == NULL) ? NULL : (element = (dvb_event_element_unref (element), NULL));
			(event == NULL) ? NULL : (event = (dvb_event_unref (event), NULL));
		} else {
			g_debug ("Schedule.vala:259: No event with id %u", (guint) event_id);
		}
	}
	g_static_rec_mutex_unlock (&self->priv->__lock_events);
	return duration;
}


static guint* dvb_schedule_real_GetLocalStartTime (DVBIDBusSchedule* base, guint32 event_id, int* result_length1) {
	DVBSchedule * self;
	guint* _tmp1;
	gint start_length1;
	guint* _tmp0;
	guint* start;
	guint* _tmp4;
	self = (DVBSchedule*) base;
	_tmp1 = NULL;
	_tmp0 = NULL;
	start = (_tmp1 = (_tmp0 = g_new0 (guint, 0), _tmp0), start_length1 = 0, _tmp1);
	g_static_rec_mutex_lock (&self->priv->__lock_events);
	{
		if (gee_map_contains (self->priv->event_id_map, GUINT_TO_POINTER ((guint) event_id))) {
			GSequenceIter* iter;
			DVBEventElement* _tmp2;
			DVBEventElement* element;
			DVBEvent* event;
			struct tm local_time;
			guint* _tmp3;
			iter = (GSequenceIter*) gee_map_get (self->priv->event_id_map, GUINT_TO_POINTER ((guint) event_id));
			_tmp2 = NULL;
			element = (_tmp2 = (DVBEventElement*) g_sequence_get (iter), (_tmp2 == NULL) ? NULL : dvb_event_element_ref (_tmp2));
			event = dvb_schedule_get (self, element->id);
			local_time = dvb_event_get_local_start_time (event);
			_tmp3 = NULL;
			start = (_tmp3 = g_new0 (guint, 6), start = (g_free (start), NULL), start_length1 = 6, _tmp3);
			start[0] = (guint) (local_time.tm_year + 1900);
			start[1] = (guint) (local_time.tm_mon + 1);
			start[2] = (guint) local_time.tm_mday;
			start[3] = (guint) local_time.tm_hour;
			start[4] = (guint) local_time.tm_min;
			start[5] = (guint) local_time.tm_sec;
			(element == NULL) ? NULL : (element = (dvb_event_element_unref (element), NULL));
			(event == NULL) ? NULL : (event = (dvb_event_unref (event), NULL));
		} else {
			g_debug ("Schedule.vala:283: No event with id %u", (guint) event_id);
		}
	}
	g_static_rec_mutex_unlock (&self->priv->__lock_events);
	_tmp4 = NULL;
	return (_tmp4 = start, *result_length1 = start_length1, _tmp4);
}


static gboolean dvb_schedule_real_IsRunning (DVBIDBusSchedule* base, guint32 event_id) {
	DVBSchedule * self;
	gboolean val;
	self = (DVBSchedule*) base;
	val = FALSE;
	g_static_rec_mutex_lock (&self->priv->__lock_events);
	{
		if (gee_map_contains (self->priv->event_id_map, GUINT_TO_POINTER ((guint) event_id))) {
			GSequenceIter* iter;
			DVBEventElement* _tmp0;
			DVBEventElement* element;
			DVBEvent* event;
			iter = (GSequenceIter*) gee_map_get (self->priv->event_id_map, GUINT_TO_POINTER ((guint) event_id));
			_tmp0 = NULL;
			element = (_tmp0 = (DVBEventElement*) g_sequence_get (iter), (_tmp0 == NULL) ? NULL : dvb_event_element_ref (_tmp0));
			event = dvb_schedule_get (self, element->id);
			val = (dvb_event_is_running (event));
			(element == NULL) ? NULL : (element = (dvb_event_element_unref (element), NULL));
			(event == NULL) ? NULL : (event = (dvb_event_unref (event), NULL));
		} else {
			g_debug ("Schedule.vala:300: No event with id %u", (guint) event_id);
		}
	}
	g_static_rec_mutex_unlock (&self->priv->__lock_events);
	return val;
}


static gboolean dvb_schedule_real_IsScrambled (DVBIDBusSchedule* base, guint32 event_id) {
	DVBSchedule * self;
	gboolean val;
	self = (DVBSchedule*) base;
	val = FALSE;
	g_static_rec_mutex_lock (&self->priv->__lock_events);
	{
		if (gee_map_contains (self->priv->event_id_map, GUINT_TO_POINTER ((guint) event_id))) {
			GSequenceIter* iter;
			DVBEventElement* _tmp0;
			DVBEventElement* element;
			DVBEvent* event;
			iter = (GSequenceIter*) gee_map_get (self->priv->event_id_map, GUINT_TO_POINTER ((guint) event_id));
			_tmp0 = NULL;
			element = (_tmp0 = (DVBEventElement*) g_sequence_get (iter), (_tmp0 == NULL) ? NULL : dvb_event_element_ref (_tmp0));
			event = dvb_schedule_get (self, element->id);
			val = (!event->free_ca_mode);
			(element == NULL) ? NULL : (element = (dvb_event_element_unref (element), NULL));
			(event == NULL) ? NULL : (event = (dvb_event_unref (event), NULL));
		} else {
			g_debug ("Schedule.vala:317: No event with id %u", (guint) event_id);
		}
	}
	g_static_rec_mutex_unlock (&self->priv->__lock_events);
	return val;
}


DVBChannel* dvb_schedule_get_channel (DVBSchedule* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_channel;
}


static void dvb_schedule_set_channel (DVBSchedule* self, DVBChannel* value) {
	DVBChannel* _tmp2;
	DVBChannel* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_channel = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : g_object_ref (_tmp1)), (self->priv->_channel == NULL) ? NULL : (self->priv->_channel = (g_object_unref (self->priv->_channel), NULL)), _tmp2);
	g_object_notify ((GObject *) self, "channel");
}


static GObject * dvb_schedule_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	DVBScheduleClass * klass;
	GObjectClass * parent_class;
	DVBSchedule * self;
	klass = DVB_SCHEDULE_CLASS (g_type_class_peek (DVB_TYPE_SCHEDULE));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = DVB_SCHEDULE (obj);
	{
		GSequence* _tmp0;
		GeeMap* _tmp1;
		DVBEPGStore* _tmp3;
		DVBEPGStore* _tmp2;
		GeeList* events;
		_tmp0 = NULL;
		self->priv->events = (_tmp0 = g_sequence_new (NULL), (self->priv->events == NULL) ? NULL : (self->priv->events = (g_sequence_free (self->priv->events), NULL)), _tmp0);
		_tmp1 = NULL;
		self->priv->event_id_map = (_tmp1 = (GeeMap*) gee_hash_map_new (G_TYPE_UINT, NULL, NULL, G_TYPE_POINTER, NULL, NULL, g_direct_hash, g_direct_equal, g_direct_equal), (self->priv->event_id_map == NULL) ? NULL : (self->priv->event_id_map = (g_object_unref (self->priv->event_id_map), NULL)), _tmp1);
		_tmp3 = NULL;
		_tmp2 = NULL;
		self->priv->epgstore = (_tmp3 = (_tmp2 = dvb_epg_store_get_instance (), (_tmp2 == NULL) ? NULL : g_object_ref (_tmp2)), (self->priv->epgstore == NULL) ? NULL : (self->priv->epgstore = (g_object_unref (self->priv->epgstore), NULL)), _tmp3);
		events = dvb_epg_store_get_events (self->priv->epgstore, self->priv->_channel);
		{
			GeeIterator* _event_it;
			_event_it = gee_iterable_iterator ((GeeIterable*) events);
			while (gee_iterator_next (_event_it)) {
				DVBEvent* event;
				event = (DVBEvent*) gee_iterator_get (_event_it);
				if (dvb_event_has_expired (event)) {
					dvb_epg_store_remove_event (self->priv->epgstore, event->id, self->priv->_channel);
				} else {
					dvb_schedule_create_and_add_event_element (self, event);
				}
				(event == NULL) ? NULL : (event = (dvb_event_unref (event), NULL));
			}
			(_event_it == NULL) ? NULL : (_event_it = (g_object_unref (_event_it), NULL));
		}
		(events == NULL) ? NULL : (events = (g_object_unref (events), NULL));
	}
	return obj;
}


static void dvb_schedule_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DVBSchedule * self;
	self = DVB_SCHEDULE (object);
	switch (property_id) {
		case DVB_SCHEDULE_CHANNEL:
		g_value_set_object (value, dvb_schedule_get_channel (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void dvb_schedule_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DVBSchedule * self;
	self = DVB_SCHEDULE (object);
	switch (property_id) {
		case DVB_SCHEDULE_CHANNEL:
		dvb_schedule_set_channel (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


void _dvb_schedule_dbus_unregister (DBusConnection* connection, void* user_data) {
}


static DBusMessage* _dbus_dvb_schedule_introspect (DVBSchedule* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter;
	GString* xml_data;
	char** children;
	int i;
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	xml_data = g_string_new ("<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\" \"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n");
	g_string_append (xml_data, "<node>\n<interface name=\"org.freedesktop.DBus.Introspectable\">\n  <method name=\"Introspect\">\n    <arg name=\"data\" direction=\"out\" type=\"s\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DBus.Properties\">\n  <method name=\"Get\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"out\" type=\"v\"/>\n  </method>\n  <method name=\"Set\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"in\" type=\"v\"/>\n  </method>\n  <method name=\"GetAll\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"props\" direction=\"out\" type=\"a{sv}\"/>\n  </method>\n</interface>\n<interface name=\"org.gnome.DVB.Schedule\">\n  <method name=\"GetAllEvents\">\n    <arg name=\"result\" type=\"au\" direction=\"out\"/>\n  </method>\n  <method name=\"NowPlaying\">\n    <arg name=\"result\" type=\"u\" direction=\"out\"/>\n  </method>\n  <method name=\"Next\">\n    <arg name=\"event_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"u\" direction=\"out\"/>\n  </method>\n  <method name=\"GetName\">\n    <arg name=\"event_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"s\" direction=\"out\"/>\n  </method>\n  <method name=\"GetShortDescription\">\n    <arg name=\"event_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"s\" direction=\"out\"/>\n  </method>\n  <method name=\"GetExtendedDescription\">\n    <arg name=\"event_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"s\" direction=\"out\"/>\n  </method>\n  <method name=\"GetDuration\">\n    <arg name=\"event_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"u\" direction=\"out\"/>\n  </method>\n  <method name=\"GetLocalStartTime\">\n    <arg name=\"event_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"au\" direction=\"out\"/>\n  </method>\n  <method name=\"IsRunning\">\n    <arg name=\"event_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <method name=\"IsScrambled\">\n    <arg name=\"event_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n</interface>\n");
	dbus_connection_list_registered (connection, g_object_get_data ((GObject *) self, "dbus_object_path"), &children);
	for (i = 0; children[i]; i++) {
		g_string_append_printf (xml_data, "<node name=\"%s\"/>\n", children[i]);
	}
	g_string_append (xml_data, "</node>\n");
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &xml_data->str);
	g_string_free (xml_data, TRUE);
	return reply;
}


DBusHandlerResult dvb_schedule_dbus_message (DBusConnection* connection, DBusMessage* message, void* object) {
	DBusMessage* reply;
	reply = NULL;
	if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Introspectable", "Introspect")) {
		reply = _dbus_dvb_schedule_introspect (object, connection, message);
	}
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else if (dvb_id_bus_schedule_dbus_message (connection, message, object) == DBUS_HANDLER_RESULT_HANDLED) {
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


void dvb_schedule_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	if (!g_object_get_data (object, "dbus_object_path")) {
		g_object_set_data (object, "dbus_object_path", g_strdup (path));
		dbus_connection_register_object_path (connection, path, &_dvb_schedule_dbus_path_vtable, object);
	}
	dvb_id_bus_schedule_dbus_register_object (connection, path, object);
}


static void dvb_schedule_class_init (DVBScheduleClass * klass) {
	dvb_schedule_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBSchedulePrivate));
	G_OBJECT_CLASS (klass)->get_property = dvb_schedule_get_property;
	G_OBJECT_CLASS (klass)->set_property = dvb_schedule_set_property;
	G_OBJECT_CLASS (klass)->constructor = dvb_schedule_constructor;
	G_OBJECT_CLASS (klass)->finalize = dvb_schedule_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_SCHEDULE_CHANNEL, g_param_spec_object ("channel", "channel", "channel", DVB_TYPE_CHANNEL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_type_set_qdata (DVB_TYPE_SCHEDULE, g_quark_from_static_string ("DBusObjectVTable"), (void*) (&_dvb_schedule_dbus_vtable));
}


static void dvb_schedule_dvb_id_bus_schedule_interface_init (DVBIDBusScheduleIface * iface) {
	dvb_schedule_dvb_id_bus_schedule_parent_iface = g_type_interface_peek_parent (iface);
	iface->GetAllEvents = dvb_schedule_real_GetAllEvents;
	iface->NowPlaying = dvb_schedule_real_NowPlaying;
	iface->Next = dvb_schedule_real_Next;
	iface->GetName = dvb_schedule_real_GetName;
	iface->GetShortDescription = dvb_schedule_real_GetShortDescription;
	iface->GetExtendedDescription = dvb_schedule_real_GetExtendedDescription;
	iface->GetDuration = dvb_schedule_real_GetDuration;
	iface->GetLocalStartTime = dvb_schedule_real_GetLocalStartTime;
	iface->IsRunning = dvb_schedule_real_IsRunning;
	iface->IsScrambled = dvb_schedule_real_IsScrambled;
}


static void dvb_schedule_instance_init (DVBSchedule * self) {
	self->priv = DVB_SCHEDULE_GET_PRIVATE (self);
	g_static_rec_mutex_init (&self->priv->__lock_events);
}


static void dvb_schedule_finalize (GObject* obj) {
	DVBSchedule * self;
	self = DVB_SCHEDULE (obj);
	(self->priv->_channel == NULL) ? NULL : (self->priv->_channel = (g_object_unref (self->priv->_channel), NULL));
	g_static_rec_mutex_free (&self->priv->__lock_events);
	(self->priv->events == NULL) ? NULL : (self->priv->events = (g_sequence_free (self->priv->events), NULL));
	(self->priv->event_id_map == NULL) ? NULL : (self->priv->event_id_map = (g_object_unref (self->priv->event_id_map), NULL));
	(self->priv->epgstore == NULL) ? NULL : (self->priv->epgstore = (g_object_unref (self->priv->epgstore), NULL));
	G_OBJECT_CLASS (dvb_schedule_parent_class)->finalize (obj);
}


GType dvb_schedule_get_type (void) {
	static GType dvb_schedule_type_id = 0;
	if (dvb_schedule_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBScheduleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_schedule_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBSchedule), 0, (GInstanceInitFunc) dvb_schedule_instance_init, NULL };
		static const GInterfaceInfo dvb_id_bus_schedule_info = { (GInterfaceInitFunc) dvb_schedule_dvb_id_bus_schedule_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		dvb_schedule_type_id = g_type_register_static (G_TYPE_OBJECT, "DVBSchedule", &g_define_type_info, 0);
		g_type_add_interface_static (dvb_schedule_type_id, DVB_TYPE_ID_BUS_SCHEDULE, &dvb_id_bus_schedule_info);
	}
	return dvb_schedule_type_id;
}


static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	const _DBusObjectVTable * vtable;
	vtable = g_type_get_qdata (G_TYPE_FROM_INSTANCE (object), g_quark_from_static_string ("DBusObjectVTable"));
	vtable->register_object (connection, path, object);
}




