
#ifndef __SRC_GCONFSTORE_H__
#define __SRC_GCONFSTORE_H__

#include <glib.h>
#include <glib-object.h>
#include <gee/arraylist.h>
#include "src/DeviceGroup.h"
#include "src/Device.h"
#include "src/Timer.h"

G_BEGIN_DECLS


#define DVB_TYPE_GCONF_STORE (dvb_gconf_store_get_type ())
#define DVB_GCONF_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_GCONF_STORE, DVBGConfStore))
#define DVB_GCONF_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_GCONF_STORE, DVBGConfStoreClass))
#define DVB_IS_GCONF_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_GCONF_STORE))
#define DVB_IS_GCONF_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_GCONF_STORE))
#define DVB_GCONF_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_GCONF_STORE, DVBGConfStoreClass))

typedef struct _DVBGConfStore DVBGConfStore;
typedef struct _DVBGConfStoreClass DVBGConfStoreClass;
typedef struct _DVBGConfStorePrivate DVBGConfStorePrivate;

/**
     * Example tree:
     * /app/dvb-daemon
     *     /device_groups
     *         /group_0
     *             /devices
     *                 /device_0_0
     *                      adapter
     *                      frontend
     *                  /device_1_0
     *                      adapter
     *                     frontend
     *             /timers
     *                 /timer_0
     *                     id
     *                     channel_sid
     *                     year
     *                 /timer_1
     *                     id
     *                     channel_sid
     *                     year
     *             channels_file
     *             adapter_type
     *             recordings_dir
     *         /group_1
     *             /devices
     *                  /device_2_0
     *                      adapter
     *                      frontend
     *                  /device_3_0
     *                      adapter
     *                      frontend
     *             channels_file
     *             adapter_type
     *             recordings_dir
     */
struct _DVBGConfStore {
	GObject parent_instance;
	DVBGConfStorePrivate * priv;
};

struct _DVBGConfStoreClass {
	GObjectClass parent_class;
};


#define DVB_GCONF_STORE_BASE_DIR "/apps/dvb-daemon"
DVBGConfStore* dvb_gconf_store_get_instance (void);
GeeArrayList* dvb_gconf_store_get_all_device_groups (DVBGConfStore* self);
void dvb_gconf_store_add_device_group (DVBGConfStore* self, DVBDeviceGroup* dev_group);
void dvb_gconf_store_remove_device_group (DVBGConfStore* self, DVBDeviceGroup* devgroup);
void dvb_gconf_store_add_device_to_group (DVBGConfStore* self, DVBDevice* dev, DVBDeviceGroup* devgroup);
void dvb_gconf_store_remove_device_from_group (DVBGConfStore* self, DVBDevice* dev, DVBDeviceGroup* devgroup);
GeeArrayList* dvb_gconf_store_get_all_timers_of_device_group (DVBGConfStore* self, DVBDeviceGroup* dev);
void dvb_gconf_store_add_timer_to_device_group (DVBGConfStore* self, DVBTimer* timer, DVBDeviceGroup* dev);
void dvb_gconf_store_remove_timer_from_device_group (DVBGConfStore* self, guint timer_id, DVBDeviceGroup* dev);
DVBGConfStore* dvb_gconf_store_construct (GType object_type);
DVBGConfStore* dvb_gconf_store_new (void);
GType dvb_gconf_store_get_type (void);


G_END_DECLS

#endif
