
#include <src/Terrestrial/TerrestrialChannel.h>
#include "src/Utils.h"




struct _DVBTerrestrialChannelPrivate {
	DVBDvbSrcInversion _Inversion;
	DVBDvbSrcBandwidth _Bandwidth;
	DVBDvbSrcCodeRate _CodeRateHP;
	DVBDvbSrcCodeRate _CodeRateLP;
	DVBDvbSrcModulation _Constellation;
	DVBDvbSrcTransmissionMode _TransmissionMode;
	DVBDvbSrcGuard _GuardInterval;
	DVBDvbSrcHierarchy _Hierarchy;
};

#define DVB_TERRESTRIAL_CHANNEL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_TYPE_TERRESTRIAL_CHANNEL, DVBTerrestrialChannelPrivate))
enum  {
	DVB_TERRESTRIAL_CHANNEL_DUMMY_PROPERTY,
	DVB_TERRESTRIAL_CHANNEL_INVERSION,
	DVB_TERRESTRIAL_CHANNEL_BANDWIDTH,
	DVB_TERRESTRIAL_CHANNEL_CODE_RATE_HP,
	DVB_TERRESTRIAL_CHANNEL_CODE_RATE_LP,
	DVB_TERRESTRIAL_CHANNEL_CONSTELLATION,
	DVB_TERRESTRIAL_CHANNEL_TRANSMISSION_MODE,
	DVB_TERRESTRIAL_CHANNEL_GUARD_INTERVAL,
	DVB_TERRESTRIAL_CHANNEL_HIERARCHY
};
static void dvb_terrestrial_channel_real_setup_dvb_source (DVBChannel* base, GstElement* source);
static char* dvb_terrestrial_channel_real_to_string (DVBChannel* base);
static gpointer dvb_terrestrial_channel_parent_class = NULL;
static void dvb_terrestrial_channel_finalize (GObject* obj);



static void dvb_terrestrial_channel_real_setup_dvb_source (DVBChannel* base, GstElement* source) {
	DVBTerrestrialChannel * self;
	self = (DVBTerrestrialChannel*) base;
	g_return_if_fail (source != NULL);
	g_object_set ((GObject*) source, "modulation", self->priv->_Constellation, NULL);
	g_object_set ((GObject*) source, "trans-mode", self->priv->_TransmissionMode, NULL);
	g_object_set ((GObject*) source, "code-rate-hp", self->priv->_CodeRateHP, NULL);
	g_object_set ((GObject*) source, "code-rate-lp", self->priv->_CodeRateLP, NULL);
	g_object_set ((GObject*) source, "guard", self->priv->_GuardInterval, NULL);
	g_object_set ((GObject*) source, "bandwidth", self->priv->_Bandwidth, NULL);
	g_object_set ((GObject*) source, "frequency", dvb_channel_get_Frequency ((DVBChannel*) self), NULL);
	g_object_set ((GObject*) source, "hierarchy", self->priv->_Hierarchy, NULL);
	g_object_set ((GObject*) source, "inversion", self->priv->_Inversion, NULL);
}


static char* dvb_terrestrial_channel_real_to_string (DVBChannel* base) {
	DVBTerrestrialChannel * self;
	self = (DVBTerrestrialChannel*) base;
	return g_strdup_printf ("%s:%u:%s:%s:%s:%s:%s:%s:%s:%s:%u:%u:%u", dvb_channel_get_Name (DVB_CHANNEL (self)), dvb_channel_get_Frequency (DVB_CHANNEL (self)), dvb_utils_get_nick_from_enum (DVB_TYPE_DVB_SRC_INVERSION, (gint) self->priv->_Inversion), dvb_utils_get_nick_from_enum (DVB_TYPE_DVB_SRC_BANDWIDTH, (gint) self->priv->_Bandwidth), dvb_utils_get_nick_from_enum (DVB_TYPE_DVB_SRC_CODE_RATE, (gint) self->priv->_CodeRateHP), dvb_utils_get_nick_from_enum (DVB_TYPE_DVB_SRC_CODE_RATE, (gint) self->priv->_CodeRateLP), dvb_utils_get_nick_from_enum (DVB_TYPE_DVB_SRC_MODULATION, (gint) self->priv->_Constellation), dvb_utils_get_nick_from_enum (DVB_TYPE_DVB_SRC_TRANSMISSION_MODE, (gint) self->priv->_TransmissionMode), dvb_utils_get_nick_from_enum (DVB_TYPE_DVB_SRC_GUARD, (gint) self->priv->_GuardInterval), dvb_utils_get_nick_from_enum (DVB_TYPE_DVB_SRC_HIERARCHY, (gint) self->priv->_Hierarchy), dvb_channel_get_VideoPID (DVB_CHANNEL (self)), dvb_channel_get_AudioPID (DVB_CHANNEL (self)), dvb_channel_get_Sid (DVB_CHANNEL (self)));
}


DVBTerrestrialChannel* dvb_terrestrial_channel_construct (GType object_type) {
	DVBTerrestrialChannel * self;
	self = g_object_newv (object_type, 0, NULL);
	return self;
}


DVBTerrestrialChannel* dvb_terrestrial_channel_new (void) {
	return dvb_terrestrial_channel_construct (DVB_TYPE_TERRESTRIAL_CHANNEL);
}


DVBDvbSrcInversion dvb_terrestrial_channel_get_Inversion (DVBTerrestrialChannel* self) {
	g_return_val_if_fail (self != NULL, 0);
	return self->priv->_Inversion;
}


void dvb_terrestrial_channel_set_Inversion (DVBTerrestrialChannel* self, DVBDvbSrcInversion value) {
	g_return_if_fail (self != NULL);
	self->priv->_Inversion = value;
	g_object_notify ((GObject *) self, "Inversion");
}


DVBDvbSrcBandwidth dvb_terrestrial_channel_get_Bandwidth (DVBTerrestrialChannel* self) {
	g_return_val_if_fail (self != NULL, 0);
	return self->priv->_Bandwidth;
}


void dvb_terrestrial_channel_set_Bandwidth (DVBTerrestrialChannel* self, DVBDvbSrcBandwidth value) {
	g_return_if_fail (self != NULL);
	self->priv->_Bandwidth = value;
	g_object_notify ((GObject *) self, "Bandwidth");
}


DVBDvbSrcCodeRate dvb_terrestrial_channel_get_CodeRateHP (DVBTerrestrialChannel* self) {
	g_return_val_if_fail (self != NULL, 0);
	return self->priv->_CodeRateHP;
}


void dvb_terrestrial_channel_set_CodeRateHP (DVBTerrestrialChannel* self, DVBDvbSrcCodeRate value) {
	g_return_if_fail (self != NULL);
	self->priv->_CodeRateHP = value;
	g_object_notify ((GObject *) self, "CodeRateHP");
}


DVBDvbSrcCodeRate dvb_terrestrial_channel_get_CodeRateLP (DVBTerrestrialChannel* self) {
	g_return_val_if_fail (self != NULL, 0);
	return self->priv->_CodeRateLP;
}


void dvb_terrestrial_channel_set_CodeRateLP (DVBTerrestrialChannel* self, DVBDvbSrcCodeRate value) {
	g_return_if_fail (self != NULL);
	self->priv->_CodeRateLP = value;
	g_object_notify ((GObject *) self, "CodeRateLP");
}


DVBDvbSrcModulation dvb_terrestrial_channel_get_Constellation (DVBTerrestrialChannel* self) {
	g_return_val_if_fail (self != NULL, 0);
	return self->priv->_Constellation;
}


void dvb_terrestrial_channel_set_Constellation (DVBTerrestrialChannel* self, DVBDvbSrcModulation value) {
	g_return_if_fail (self != NULL);
	self->priv->_Constellation = value;
	g_object_notify ((GObject *) self, "Constellation");
}


DVBDvbSrcTransmissionMode dvb_terrestrial_channel_get_TransmissionMode (DVBTerrestrialChannel* self) {
	g_return_val_if_fail (self != NULL, 0);
	return self->priv->_TransmissionMode;
}


void dvb_terrestrial_channel_set_TransmissionMode (DVBTerrestrialChannel* self, DVBDvbSrcTransmissionMode value) {
	g_return_if_fail (self != NULL);
	self->priv->_TransmissionMode = value;
	g_object_notify ((GObject *) self, "TransmissionMode");
}


DVBDvbSrcGuard dvb_terrestrial_channel_get_GuardInterval (DVBTerrestrialChannel* self) {
	g_return_val_if_fail (self != NULL, 0);
	return self->priv->_GuardInterval;
}


void dvb_terrestrial_channel_set_GuardInterval (DVBTerrestrialChannel* self, DVBDvbSrcGuard value) {
	g_return_if_fail (self != NULL);
	self->priv->_GuardInterval = value;
	g_object_notify ((GObject *) self, "GuardInterval");
}


DVBDvbSrcHierarchy dvb_terrestrial_channel_get_Hierarchy (DVBTerrestrialChannel* self) {
	g_return_val_if_fail (self != NULL, 0);
	return self->priv->_Hierarchy;
}


void dvb_terrestrial_channel_set_Hierarchy (DVBTerrestrialChannel* self, DVBDvbSrcHierarchy value) {
	g_return_if_fail (self != NULL);
	self->priv->_Hierarchy = value;
	g_object_notify ((GObject *) self, "Hierarchy");
}


static void dvb_terrestrial_channel_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DVBTerrestrialChannel * self;
	self = DVB_TERRESTRIAL_CHANNEL (object);
	switch (property_id) {
		case DVB_TERRESTRIAL_CHANNEL_INVERSION:
		g_value_set_enum (value, dvb_terrestrial_channel_get_Inversion (self));
		break;
		case DVB_TERRESTRIAL_CHANNEL_BANDWIDTH:
		g_value_set_enum (value, dvb_terrestrial_channel_get_Bandwidth (self));
		break;
		case DVB_TERRESTRIAL_CHANNEL_CODE_RATE_HP:
		g_value_set_enum (value, dvb_terrestrial_channel_get_CodeRateHP (self));
		break;
		case DVB_TERRESTRIAL_CHANNEL_CODE_RATE_LP:
		g_value_set_enum (value, dvb_terrestrial_channel_get_CodeRateLP (self));
		break;
		case DVB_TERRESTRIAL_CHANNEL_CONSTELLATION:
		g_value_set_enum (value, dvb_terrestrial_channel_get_Constellation (self));
		break;
		case DVB_TERRESTRIAL_CHANNEL_TRANSMISSION_MODE:
		g_value_set_enum (value, dvb_terrestrial_channel_get_TransmissionMode (self));
		break;
		case DVB_TERRESTRIAL_CHANNEL_GUARD_INTERVAL:
		g_value_set_enum (value, dvb_terrestrial_channel_get_GuardInterval (self));
		break;
		case DVB_TERRESTRIAL_CHANNEL_HIERARCHY:
		g_value_set_enum (value, dvb_terrestrial_channel_get_Hierarchy (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void dvb_terrestrial_channel_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DVBTerrestrialChannel * self;
	self = DVB_TERRESTRIAL_CHANNEL (object);
	switch (property_id) {
		case DVB_TERRESTRIAL_CHANNEL_INVERSION:
		dvb_terrestrial_channel_set_Inversion (self, g_value_get_enum (value));
		break;
		case DVB_TERRESTRIAL_CHANNEL_BANDWIDTH:
		dvb_terrestrial_channel_set_Bandwidth (self, g_value_get_enum (value));
		break;
		case DVB_TERRESTRIAL_CHANNEL_CODE_RATE_HP:
		dvb_terrestrial_channel_set_CodeRateHP (self, g_value_get_enum (value));
		break;
		case DVB_TERRESTRIAL_CHANNEL_CODE_RATE_LP:
		dvb_terrestrial_channel_set_CodeRateLP (self, g_value_get_enum (value));
		break;
		case DVB_TERRESTRIAL_CHANNEL_CONSTELLATION:
		dvb_terrestrial_channel_set_Constellation (self, g_value_get_enum (value));
		break;
		case DVB_TERRESTRIAL_CHANNEL_TRANSMISSION_MODE:
		dvb_terrestrial_channel_set_TransmissionMode (self, g_value_get_enum (value));
		break;
		case DVB_TERRESTRIAL_CHANNEL_GUARD_INTERVAL:
		dvb_terrestrial_channel_set_GuardInterval (self, g_value_get_enum (value));
		break;
		case DVB_TERRESTRIAL_CHANNEL_HIERARCHY:
		dvb_terrestrial_channel_set_Hierarchy (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void dvb_terrestrial_channel_class_init (DVBTerrestrialChannelClass * klass) {
	dvb_terrestrial_channel_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBTerrestrialChannelPrivate));
	G_OBJECT_CLASS (klass)->get_property = dvb_terrestrial_channel_get_property;
	G_OBJECT_CLASS (klass)->set_property = dvb_terrestrial_channel_set_property;
	G_OBJECT_CLASS (klass)->finalize = dvb_terrestrial_channel_finalize;
	DVB_CHANNEL_CLASS (klass)->setup_dvb_source = dvb_terrestrial_channel_real_setup_dvb_source;
	DVB_CHANNEL_CLASS (klass)->to_string = dvb_terrestrial_channel_real_to_string;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_TERRESTRIAL_CHANNEL_INVERSION, g_param_spec_enum ("Inversion", "Inversion", "Inversion", DVB_TYPE_DVB_SRC_INVERSION, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_TERRESTRIAL_CHANNEL_BANDWIDTH, g_param_spec_enum ("Bandwidth", "Bandwidth", "Bandwidth", DVB_TYPE_DVB_SRC_BANDWIDTH, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_TERRESTRIAL_CHANNEL_CODE_RATE_HP, g_param_spec_enum ("CodeRateHP", "CodeRateHP", "CodeRateHP", DVB_TYPE_DVB_SRC_CODE_RATE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_TERRESTRIAL_CHANNEL_CODE_RATE_LP, g_param_spec_enum ("CodeRateLP", "CodeRateLP", "CodeRateLP", DVB_TYPE_DVB_SRC_CODE_RATE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_TERRESTRIAL_CHANNEL_CONSTELLATION, g_param_spec_enum ("Constellation", "Constellation", "Constellation", DVB_TYPE_DVB_SRC_MODULATION, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_TERRESTRIAL_CHANNEL_TRANSMISSION_MODE, g_param_spec_enum ("TransmissionMode", "TransmissionMode", "TransmissionMode", DVB_TYPE_DVB_SRC_TRANSMISSION_MODE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_TERRESTRIAL_CHANNEL_GUARD_INTERVAL, g_param_spec_enum ("GuardInterval", "GuardInterval", "GuardInterval", DVB_TYPE_DVB_SRC_GUARD, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_TERRESTRIAL_CHANNEL_HIERARCHY, g_param_spec_enum ("Hierarchy", "Hierarchy", "Hierarchy", DVB_TYPE_DVB_SRC_HIERARCHY, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void dvb_terrestrial_channel_instance_init (DVBTerrestrialChannel * self) {
	self->priv = DVB_TERRESTRIAL_CHANNEL_GET_PRIVATE (self);
}


static void dvb_terrestrial_channel_finalize (GObject* obj) {
	DVBTerrestrialChannel * self;
	self = DVB_TERRESTRIAL_CHANNEL (obj);
	G_OBJECT_CLASS (dvb_terrestrial_channel_parent_class)->finalize (obj);
}


GType dvb_terrestrial_channel_get_type (void) {
	static GType dvb_terrestrial_channel_type_id = 0;
	if (dvb_terrestrial_channel_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBTerrestrialChannelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_terrestrial_channel_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBTerrestrialChannel), 0, (GInstanceInitFunc) dvb_terrestrial_channel_instance_init, NULL };
		dvb_terrestrial_channel_type_id = g_type_register_static (DVB_TYPE_CHANNEL, "DVBTerrestrialChannel", &g_define_type_info, 0);
	}
	return dvb_terrestrial_channel_type_id;
}




