/* Services2.c generated by valac 0.12.0, the Vala compiler
 * generated from Services2.vala, do not modify */

/*
 * Copyright (C) 2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gee.h>


#define DVB_LOGGING_TYPE_LOGGER (dvb_logging_logger_get_type ())
#define DVB_LOGGING_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLogger))
#define DVB_LOGGING_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLoggerClass))
#define DVB_LOGGING_IS_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_LOGGING_TYPE_LOGGER))
#define DVB_LOGGING_IS_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_LOGGING_TYPE_LOGGER))
#define DVB_LOGGING_LOGGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLoggerClass))

typedef struct _DVBLoggingLogger DVBLoggingLogger;
typedef struct _DVBLoggingLoggerClass DVBLoggingLoggerClass;

#define TYPE_MEDIA_CONTAINER2 (media_container2_get_type ())
#define MEDIA_CONTAINER2(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_CONTAINER2, MediaContainer2))
#define IS_MEDIA_CONTAINER2(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_CONTAINER2))
#define MEDIA_CONTAINER2_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_MEDIA_CONTAINER2, MediaContainer2Iface))

typedef struct _MediaContainer2 MediaContainer2;
typedef struct _MediaContainer2Iface MediaContainer2Iface;

#define TYPE_MEDIA_CONTAINER2_PROXY (media_container2_proxy_get_type ())

#define TYPE_MEDIA_OBJECT2 (media_object2_get_type ())
#define MEDIA_OBJECT2(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_OBJECT2, MediaObject2))
#define IS_MEDIA_OBJECT2(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_OBJECT2))
#define MEDIA_OBJECT2_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_MEDIA_OBJECT2, MediaObject2Iface))

typedef struct _MediaObject2 MediaObject2;
typedef struct _MediaObject2Iface MediaObject2Iface;

#define TYPE_MEDIA_OBJECT2_PROXY (media_object2_proxy_get_type ())

#define DVB_MEDIA_SERVER2_TYPE_DEVICE_GROUPS_MEDIA_CONTAINER2 (dvb_media_server2_device_groups_media_container2_get_type ())
#define DVB_MEDIA_SERVER2_DEVICE_GROUPS_MEDIA_CONTAINER2(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_MEDIA_SERVER2_TYPE_DEVICE_GROUPS_MEDIA_CONTAINER2, DVBMediaServer2DeviceGroupsMediaContainer2))
#define DVB_MEDIA_SERVER2_DEVICE_GROUPS_MEDIA_CONTAINER2_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_MEDIA_SERVER2_TYPE_DEVICE_GROUPS_MEDIA_CONTAINER2, DVBMediaServer2DeviceGroupsMediaContainer2Class))
#define DVB_MEDIA_SERVER2_IS_DEVICE_GROUPS_MEDIA_CONTAINER2(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_MEDIA_SERVER2_TYPE_DEVICE_GROUPS_MEDIA_CONTAINER2))
#define DVB_MEDIA_SERVER2_IS_DEVICE_GROUPS_MEDIA_CONTAINER2_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_MEDIA_SERVER2_TYPE_DEVICE_GROUPS_MEDIA_CONTAINER2))
#define DVB_MEDIA_SERVER2_DEVICE_GROUPS_MEDIA_CONTAINER2_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_MEDIA_SERVER2_TYPE_DEVICE_GROUPS_MEDIA_CONTAINER2, DVBMediaServer2DeviceGroupsMediaContainer2Class))

typedef struct _DVBMediaServer2DeviceGroupsMediaContainer2 DVBMediaServer2DeviceGroupsMediaContainer2;
typedef struct _DVBMediaServer2DeviceGroupsMediaContainer2Class DVBMediaServer2DeviceGroupsMediaContainer2Class;
typedef struct _DVBMediaServer2DeviceGroupsMediaContainer2Private DVBMediaServer2DeviceGroupsMediaContainer2Private;

#define DVB_MEDIA_SERVER2_TYPE_CHANNELS_MEDIA_CONTAINER2 (dvb_media_server2_channels_media_container2_get_type ())
#define DVB_MEDIA_SERVER2_CHANNELS_MEDIA_CONTAINER2(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_MEDIA_SERVER2_TYPE_CHANNELS_MEDIA_CONTAINER2, DVBMediaServer2ChannelsMediaContainer2))
#define DVB_MEDIA_SERVER2_CHANNELS_MEDIA_CONTAINER2_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_MEDIA_SERVER2_TYPE_CHANNELS_MEDIA_CONTAINER2, DVBMediaServer2ChannelsMediaContainer2Class))
#define DVB_MEDIA_SERVER2_IS_CHANNELS_MEDIA_CONTAINER2(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_MEDIA_SERVER2_TYPE_CHANNELS_MEDIA_CONTAINER2))
#define DVB_MEDIA_SERVER2_IS_CHANNELS_MEDIA_CONTAINER2_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_MEDIA_SERVER2_TYPE_CHANNELS_MEDIA_CONTAINER2))
#define DVB_MEDIA_SERVER2_CHANNELS_MEDIA_CONTAINER2_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_MEDIA_SERVER2_TYPE_CHANNELS_MEDIA_CONTAINER2, DVBMediaServer2ChannelsMediaContainer2Class))

typedef struct _DVBMediaServer2ChannelsMediaContainer2 DVBMediaServer2ChannelsMediaContainer2;
typedef struct _DVBMediaServer2ChannelsMediaContainer2Class DVBMediaServer2ChannelsMediaContainer2Class;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define DVB_TYPE_MANAGER (dvb_manager_get_type ())
#define DVB_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_MANAGER, DVBManager))
#define DVB_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_MANAGER, DVBManagerClass))
#define DVB_IS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_MANAGER))
#define DVB_IS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_MANAGER))
#define DVB_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_MANAGER, DVBManagerClass))

typedef struct _DVBManager DVBManager;
typedef struct _DVBManagerClass DVBManagerClass;

#define DVB_TYPE_DEVICE_GROUP (dvb_device_group_get_type ())
#define DVB_DEVICE_GROUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_DEVICE_GROUP, DVBDeviceGroup))
#define DVB_DEVICE_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_DEVICE_GROUP, DVBDeviceGroupClass))
#define DVB_IS_DEVICE_GROUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_DEVICE_GROUP))
#define DVB_IS_DEVICE_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_DEVICE_GROUP))
#define DVB_DEVICE_GROUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_DEVICE_GROUP, DVBDeviceGroupClass))

typedef struct _DVBDeviceGroup DVBDeviceGroup;
typedef struct _DVBDeviceGroupClass DVBDeviceGroupClass;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

#define DVB_TYPE_ID_BUS_MANAGER (dvb_id_bus_manager_get_type ())
#define DVB_ID_BUS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_ID_BUS_MANAGER, DVBIDBusManager))
#define DVB_IS_ID_BUS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_ID_BUS_MANAGER))
#define DVB_ID_BUS_MANAGER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DVB_TYPE_ID_BUS_MANAGER, DVBIDBusManagerIface))

typedef struct _DVBIDBusManager DVBIDBusManager;
typedef struct _DVBIDBusManagerIface DVBIDBusManagerIface;

#define DVB_TYPE_ID_BUS_MANAGER_PROXY (dvb_id_bus_manager_proxy_get_type ())

#define DVB_TYPE_CHANNEL_GROUP_INFO (dvb_channel_group_info_get_type ())
typedef struct _DVBChannelGroupInfo DVBChannelGroupInfo;
typedef struct _DVBMediaServer2ChannelsMediaContainer2Private DVBMediaServer2ChannelsMediaContainer2Private;

#define DVB_MEDIA_SERVER2_TYPE_CHANNEL_MEDIA_ITEM2 (dvb_media_server2_channel_media_item2_get_type ())
#define DVB_MEDIA_SERVER2_CHANNEL_MEDIA_ITEM2(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_MEDIA_SERVER2_TYPE_CHANNEL_MEDIA_ITEM2, DVBMediaServer2ChannelMediaItem2))
#define DVB_MEDIA_SERVER2_CHANNEL_MEDIA_ITEM2_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_MEDIA_SERVER2_TYPE_CHANNEL_MEDIA_ITEM2, DVBMediaServer2ChannelMediaItem2Class))
#define DVB_MEDIA_SERVER2_IS_CHANNEL_MEDIA_ITEM2(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_MEDIA_SERVER2_TYPE_CHANNEL_MEDIA_ITEM2))
#define DVB_MEDIA_SERVER2_IS_CHANNEL_MEDIA_ITEM2_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_MEDIA_SERVER2_TYPE_CHANNEL_MEDIA_ITEM2))
#define DVB_MEDIA_SERVER2_CHANNEL_MEDIA_ITEM2_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_MEDIA_SERVER2_TYPE_CHANNEL_MEDIA_ITEM2, DVBMediaServer2ChannelMediaItem2Class))

typedef struct _DVBMediaServer2ChannelMediaItem2 DVBMediaServer2ChannelMediaItem2;
typedef struct _DVBMediaServer2ChannelMediaItem2Class DVBMediaServer2ChannelMediaItem2Class;

#define DVB_TYPE_CHANNEL_LIST (dvb_channel_list_get_type ())
#define DVB_CHANNEL_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL_LIST, DVBChannelList))
#define DVB_CHANNEL_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL_LIST, DVBChannelListClass))
#define DVB_IS_CHANNEL_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL_LIST))
#define DVB_IS_CHANNEL_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL_LIST))
#define DVB_CHANNEL_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL_LIST, DVBChannelListClass))

typedef struct _DVBChannelList DVBChannelList;
typedef struct _DVBChannelListClass DVBChannelListClass;

#define DVB_TYPE_CHANNEL (dvb_channel_get_type ())
#define DVB_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL, DVBChannel))
#define DVB_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL, DVBChannelClass))
#define DVB_IS_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL))
#define DVB_IS_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL))
#define DVB_CHANNEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL, DVBChannelClass))

typedef struct _DVBChannel DVBChannel;
typedef struct _DVBChannelClass DVBChannelClass;

#define TYPE_MEDIA_ITEM2 (media_item2_get_type ())
#define MEDIA_ITEM2(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_ITEM2, MediaItem2))
#define IS_MEDIA_ITEM2(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_ITEM2))
#define MEDIA_ITEM2_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_MEDIA_ITEM2, MediaItem2Iface))

typedef struct _MediaItem2 MediaItem2;
typedef struct _MediaItem2Iface MediaItem2Iface;

#define TYPE_MEDIA_ITEM2_PROXY (media_item2_proxy_get_type ())
typedef struct _DVBMediaServer2ChannelMediaItem2Private DVBMediaServer2ChannelMediaItem2Private;

#define DVB_LOGGING_TYPE_LOG_MANAGER (dvb_logging_log_manager_get_type ())
#define DVB_LOGGING_LOG_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManager))
#define DVB_LOGGING_LOG_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManagerClass))
#define DVB_LOGGING_IS_LOG_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_LOGGING_TYPE_LOG_MANAGER))
#define DVB_LOGGING_IS_LOG_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_LOGGING_TYPE_LOG_MANAGER))
#define DVB_LOGGING_LOG_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManagerClass))

typedef struct _DVBLoggingLogManager DVBLoggingLogManager;
typedef struct _DVBLoggingLogManagerClass DVBLoggingLogManagerClass;

struct _MediaContainer2Iface {
	GTypeInterface parent_iface;
	GHashTable** (*ListChildren) (MediaContainer2* self, guint offset, guint max, gchar** filter, int filter_length1, int* result_length1, GError** error);
	GHashTable** (*ListContainers) (MediaContainer2* self, guint offset, guint max, gchar** filter, int filter_length1, int* result_length1, GError** error);
	GHashTable** (*ListItems) (MediaContainer2* self, guint offset, guint max, gchar** filter, int filter_length1, int* result_length1, GError** error);
	guint (*get_ChildCount) (MediaContainer2* self);
	guint (*get_ItemCount) (MediaContainer2* self);
	guint (*get_ContainerCount) (MediaContainer2* self);
	gboolean (*get_Searchable) (MediaContainer2* self);
};

struct _MediaObject2Iface {
	GTypeInterface parent_iface;
	char* (*get_Parent) (MediaObject2* self);
	gchar* (*get_DisplayName) (MediaObject2* self);
	gchar* (*get_Type) (MediaObject2* self);
	gchar* (*get_Path) (MediaObject2* self);
};

struct _DVBMediaServer2DeviceGroupsMediaContainer2 {
	GObject parent_instance;
	DVBMediaServer2DeviceGroupsMediaContainer2Private * priv;
};

struct _DVBMediaServer2DeviceGroupsMediaContainer2Class {
	GObjectClass parent_class;
};

struct _DVBMediaServer2DeviceGroupsMediaContainer2Private {
	GeeHashMap* containers;
	char* path;
};

struct _DVBChannelGroupInfo {
	gint id;
	gchar* name;
};

struct _DVBIDBusManagerIface {
	GTypeInterface parent_iface;
	gboolean (*GetScannerForDevice) (DVBIDBusManager* self, guint adapter, guint frontend, char** opath, gchar** dbusiface, GError** error);
	char** (*GetRegisteredDeviceGroups) (DVBIDBusManager* self, int* result_length1, GError** error);
	gboolean (*GetDeviceGroup) (DVBIDBusManager* self, guint group_id, char** opath, GError** error);
	gboolean (*AddDeviceToNewGroup) (DVBIDBusManager* self, guint adapter, guint frontend, const gchar* channels_conf, const gchar* recordings_dir, const gchar* name, GError** error);
	gboolean (*GetNameOfRegisteredDevice) (DVBIDBusManager* self, guint adapter, guint frontend, gchar** name, GError** error);
	gint (*GetDeviceGroupSize) (DVBIDBusManager* self, GError** error);
	DVBChannelGroupInfo* (*GetChannelGroups) (DVBIDBusManager* self, int* result_length1, GError** error);
	gboolean (*AddChannelGroup) (DVBIDBusManager* self, const gchar* name, gint* channel_group_id, GError** error);
	gboolean (*RemoveChannelGroup) (DVBIDBusManager* self, gint channel_group_id, GError** error);
	GHashTable** (*GetDevices) (DVBIDBusManager* self, int* result_length1, GError** error);
};

struct _DVBMediaServer2ChannelsMediaContainer2 {
	GObject parent_instance;
	DVBMediaServer2ChannelsMediaContainer2Private * priv;
	char* parent;
};

struct _DVBMediaServer2ChannelsMediaContainer2Class {
	GObjectClass parent_class;
};

struct _DVBMediaServer2ChannelsMediaContainer2Private {
	DVBDeviceGroup* device_group;
	GeeHashMap* items;
};

struct _MediaItem2Iface {
	GTypeInterface parent_iface;
	gchar** (*get_URLs) (MediaItem2* self, int* result_length1);
	gchar* (*get_MIMEType) (MediaItem2* self);
};

struct _DVBMediaServer2ChannelMediaItem2 {
	GObject parent_instance;
	DVBMediaServer2ChannelMediaItem2Private * priv;
};

struct _DVBMediaServer2ChannelMediaItem2Class {
	GObjectClass parent_class;
};

struct _DVBMediaServer2ChannelMediaItem2Private {
	DVBChannel* channel;
	char* parent;
};


extern DVBLoggingLogger* dvb_media_server2_log;
DVBLoggingLogger* dvb_media_server2_log = NULL;
static gpointer dvb_media_server2_device_groups_media_container2_parent_class = NULL;
extern GDBusConnection* dvb_media_server2_conn;
static MediaContainer2Iface* dvb_media_server2_device_groups_media_container2_media_container2_parent_iface = NULL;
static MediaObject2Iface* dvb_media_server2_device_groups_media_container2_media_object2_parent_iface = NULL;
static gpointer dvb_media_server2_channels_media_container2_parent_class = NULL;
static MediaContainer2Iface* dvb_media_server2_channels_media_container2_media_container2_parent_iface = NULL;
static MediaObject2Iface* dvb_media_server2_channels_media_container2_media_object2_parent_iface = NULL;
static gpointer dvb_media_server2_channel_media_item2_parent_class = NULL;
static MediaItem2Iface* dvb_media_server2_channel_media_item2_media_item2_parent_iface = NULL;
static MediaObject2Iface* dvb_media_server2_channel_media_item2_media_object2_parent_iface = NULL;
extern DVBMediaServer2DeviceGroupsMediaContainer2* dvb_media_server2_root_container;
DVBMediaServer2DeviceGroupsMediaContainer2* dvb_media_server2_root_container = NULL;
GDBusConnection* dvb_media_server2_conn = NULL;

GType dvb_logging_logger_get_type (void) G_GNUC_CONST;
#define DVB_MEDIA_SERVER2_SERVICE_NAME "org.gnome.UPnP.MediaServer2.DVBDaemon"
#define DVB_MEDIA_SERVER2_ROOT_PATH "/org/gnome/UPnP/MediaServer2/DVBDaemon"
#define DVB_MEDIA_SERVER2_GROUP_PATH "/org/gnome/UPnP/MediaServer2/DVBDaemon/Group%u"
#define DVB_MEDIA_SERVER2_CHANNEL_PATH DVB_MEDIA_SERVER2_GROUP_PATH "/Channel%u"
GType media_container2_proxy_get_type (void) G_GNUC_CONST;
guint media_container2_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType media_container2_get_type (void) G_GNUC_CONST;
GType media_object2_get_type (void) G_GNUC_CONST;
GType media_object2_proxy_get_type (void) G_GNUC_CONST;
guint media_object2_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType dvb_media_server2_device_groups_media_container2_get_type (void) G_GNUC_CONST;
GType dvb_media_server2_channels_media_container2_get_type (void) G_GNUC_CONST;
#define DVB_MEDIA_SERVER2_DEVICE_GROUPS_MEDIA_CONTAINER2_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_MEDIA_SERVER2_TYPE_DEVICE_GROUPS_MEDIA_CONTAINER2, DVBMediaServer2DeviceGroupsMediaContainer2Private))
enum  {
	DVB_MEDIA_SERVER2_DEVICE_GROUPS_MEDIA_CONTAINER2_DUMMY_PROPERTY
};
void dvb_media_server2_device_groups_media_container2_create_container_services (DVBMediaServer2DeviceGroupsMediaContainer2* self);
GType dvb_manager_get_type (void) G_GNUC_CONST;
DVBManager* dvb_manager_get_instance (void);
GType dvb_device_group_get_type (void) G_GNUC_CONST;
GeeCollection* dvb_manager_get_device_groups (DVBManager* self);
static void dvb_media_server2_device_groups_media_container2_create_service (DVBMediaServer2DeviceGroupsMediaContainer2* self, DVBDeviceGroup* devgroup);
void dvb_logging_logger_debug (DVBLoggingLogger* self, const gchar* format, ...);
guint dvb_device_group_get_Id (DVBDeviceGroup* self);
DVBMediaServer2ChannelsMediaContainer2* dvb_media_server2_channels_media_container2_new (DVBDeviceGroup* devgroup, const char* parent);
DVBMediaServer2ChannelsMediaContainer2* dvb_media_server2_channels_media_container2_construct (GType object_type, DVBDeviceGroup* devgroup, const char* parent);
void dvb_utils_dbus_register_object (GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func, GDBusConnection* conn, const gchar* object_path, gconstpointer obj);
gchar* media_object2_get_Path (MediaObject2* self);
void dvb_media_server2_channels_media_container2_create_item_services (DVBMediaServer2ChannelsMediaContainer2* self, GDBusConnection* conn);
static GHashTable** dvb_media_server2_device_groups_media_container2_real_ListContainers (MediaContainer2* base, guint offset, guint max, gchar** filter, int filter_length1, int* result_length1, GError** error);
guint dvb_media_server2_get_num_elements (gint items, guint offset, guint max);
static void _g_free0_ (gpointer var);
static void _g_variant_unref0_ (gpointer var);
static GVariant* _variant_new1 (gchar* value);
gchar* media_object2_get_DisplayName (MediaObject2* self);
static GVariant* _variant_new2 (gchar* value);
guint media_container2_get_ChildCount (MediaContainer2* self);
static GVariant* _variant_new3 (guint value);
gboolean media_container2_get_Searchable (MediaContainer2* self);
static GVariant* _variant_new4 (gboolean value);
gchar* media_object2_get_Type (MediaObject2* self);
static GVariant* _variant_new5 (gchar* value);
static GVariant* _variant_new6 (gchar* value);
static GHashTable** dvb_media_server2_device_groups_media_container2_real_ListChildren (MediaContainer2* base, guint offset, guint max, gchar** filter, int filter_length1, int* result_length1, GError** error);
GHashTable** media_container2_ListContainers (MediaContainer2* self, guint offset, guint max, gchar** filter, int filter_length1, int* result_length1, GError** error);
static GHashTable** dvb_media_server2_device_groups_media_container2_real_ListItems (MediaContainer2* base, guint offset, guint max, gchar** filter, int filter_length1, int* result_length1, GError** error);
static void dvb_media_server2_device_groups_media_container2_on_device_added (DVBMediaServer2DeviceGroupsMediaContainer2* self, guint group_id);
DVBDeviceGroup* dvb_manager_get_device_group_if_exists (DVBManager* self, guint group_id);
static void dvb_media_server2_device_groups_media_container2_on_device_removed (DVBMediaServer2DeviceGroupsMediaContainer2* self, guint group_id);
DVBMediaServer2DeviceGroupsMediaContainer2* dvb_media_server2_device_groups_media_container2_new (void);
DVBMediaServer2DeviceGroupsMediaContainer2* dvb_media_server2_device_groups_media_container2_construct (GType object_type);
guint media_container2_get_ContainerCount (MediaContainer2* self);
static GObject * dvb_media_server2_device_groups_media_container2_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
GType dvb_id_bus_manager_proxy_get_type (void) G_GNUC_CONST;
guint dvb_id_bus_manager_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType dvb_channel_group_info_get_type (void) G_GNUC_CONST;
DVBChannelGroupInfo* dvb_channel_group_info_dup (const DVBChannelGroupInfo* self);
void dvb_channel_group_info_free (DVBChannelGroupInfo* self);
void dvb_channel_group_info_copy (const DVBChannelGroupInfo* self, DVBChannelGroupInfo* dest);
void dvb_channel_group_info_destroy (DVBChannelGroupInfo* self);
GType dvb_id_bus_manager_get_type (void) G_GNUC_CONST;
static void _dvb_media_server2_device_groups_media_container2_on_device_added_dvb_id_bus_manager_group_added (DVBIDBusManager* _sender, guint group_id, gpointer self);
static void _dvb_media_server2_device_groups_media_container2_on_device_removed_dvb_id_bus_manager_group_removed (DVBIDBusManager* _sender, guint group_id, gpointer self);
static void dvb_media_server2_device_groups_media_container2_finalize (GObject* obj);
static void _vala_dvb_media_server2_device_groups_media_container2_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
GType dvb_media_server2_channel_media_item2_get_type (void) G_GNUC_CONST;
#define DVB_MEDIA_SERVER2_CHANNELS_MEDIA_CONTAINER2_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_MEDIA_SERVER2_TYPE_CHANNELS_MEDIA_CONTAINER2, DVBMediaServer2ChannelsMediaContainer2Private))
enum  {
	DVB_MEDIA_SERVER2_CHANNELS_MEDIA_CONTAINER2_DUMMY_PROPERTY
};
GType dvb_channel_list_get_type (void) G_GNUC_CONST;
DVBChannelList* dvb_device_group_get_Channels (DVBDeviceGroup* self);
GType dvb_channel_get_type (void) G_GNUC_CONST;
void dvb_media_server2_channels_media_container2_create_service (DVBMediaServer2ChannelsMediaContainer2* self, DVBChannel* channel);
guint dvb_channel_get_Sid (DVBChannel* self);
DVBMediaServer2ChannelMediaItem2* dvb_media_server2_channel_media_item2_new (DVBChannel* channel, const char* parent);
DVBMediaServer2ChannelMediaItem2* dvb_media_server2_channel_media_item2_construct (GType object_type, DVBChannel* channel, const char* parent);
GType media_item2_get_type (void) G_GNUC_CONST;
GType media_item2_proxy_get_type (void) G_GNUC_CONST;
guint media_item2_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
static GHashTable** dvb_media_server2_channels_media_container2_real_ListItems (MediaContainer2* base, guint offset, guint max, gchar** filter, int filter_length1, int* result_length1, GError** error);
static GVariant* _variant_new7 (gchar* value);
static GVariant* _variant_new8 (gchar* value);
static GVariant* _variant_new9 (gchar* value);
gchar* media_item2_get_MIMEType (MediaItem2* self);
static GVariant* _variant_new10 (gchar* value);
gchar** media_item2_get_URLs (MediaItem2* self, int* result_length1);
static GVariant* _variant_new11 (gchar** value, gint value_length1);
static GVariant* _variant_new12 (gchar* value);
static GHashTable** dvb_media_server2_channels_media_container2_real_ListContainers (MediaContainer2* base, guint offset, guint max, gchar** filter, int filter_length1, int* result_length1, GError** error);
static GHashTable** dvb_media_server2_channels_media_container2_real_ListChildren (MediaContainer2* base, guint offset, guint max, gchar** filter, int filter_length1, int* result_length1, GError** error);
GHashTable** media_container2_ListItems (MediaContainer2* self, guint offset, guint max, gchar** filter, int filter_length1, int* result_length1, GError** error);
const gchar* dvb_device_group_get_Name (DVBDeviceGroup* self);
guint media_container2_get_ItemCount (MediaContainer2* self);
static GObject * dvb_media_server2_channels_media_container2_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void dvb_media_server2_channels_media_container2_finalize (GObject* obj);
static void _vala_dvb_media_server2_channels_media_container2_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
#define DVB_MEDIA_SERVER2_CHANNEL_MEDIA_ITEM2_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_MEDIA_SERVER2_TYPE_CHANNEL_MEDIA_ITEM2, DVBMediaServer2ChannelMediaItem2Private))
enum  {
	DVB_MEDIA_SERVER2_CHANNEL_MEDIA_ITEM2_DUMMY_PROPERTY
};
guint dvb_channel_get_GroupId (DVBChannel* self);
const gchar* dvb_channel_get_Name (DVBChannel* self);
gchar* dvb_channel_get_URL (DVBChannel* self);
static void dvb_media_server2_channel_media_item2_finalize (GObject* obj);
static void _vala_dvb_media_server2_channel_media_item2_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
void dvb_media_server2_on_bus_acquired (GDBusConnection* _conn);
char* media_object2_get_Parent (MediaObject2* self);
gboolean dvb_media_server2_start_rygel_services (void);
GType dvb_logging_log_manager_get_type (void) G_GNUC_CONST;
DVBLoggingLogManager* dvb_logging_log_manager_getLogManager (void);
DVBLoggingLogger* dvb_logging_log_manager_getDefaultLogger (DVBLoggingLogManager* self);
void dvb_utils_dbus_own_name (const gchar* service_name, GBusAcquiredCallback cb, void* cb_target);
static void _dvb_media_server2_on_bus_acquired_gbus_acquired_callback (GDBusConnection* connection, const gchar* name, gpointer self);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void dvb_media_server2_device_groups_media_container2_create_container_services (DVBMediaServer2DeviceGroupsMediaContainer2* self) {
	DVBManager* _tmp0_ = NULL;
	DVBManager* _tmp1_;
	DVBManager* manager;
	g_return_if_fail (self != NULL);
	_tmp0_ = dvb_manager_get_instance ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	manager = _tmp1_;
	{
		GeeCollection* _tmp2_ = NULL;
		GeeCollection* _tmp3_;
		GeeIterator* _tmp4_ = NULL;
		GeeIterator* _tmp5_;
		GeeIterator* _devgroup_it;
		_tmp2_ = dvb_manager_get_device_groups (manager);
		_tmp3_ = _tmp2_;
		_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
		_tmp5_ = _tmp4_;
		_g_object_unref0 (_tmp3_);
		_devgroup_it = _tmp5_;
		while (TRUE) {
			gboolean _tmp6_;
			gpointer _tmp7_ = NULL;
			DVBDeviceGroup* devgroup;
			_tmp6_ = gee_iterator_next (_devgroup_it);
			if (!_tmp6_) {
				break;
			}
			_tmp7_ = gee_iterator_get (_devgroup_it);
			devgroup = (DVBDeviceGroup*) _tmp7_;
			dvb_media_server2_device_groups_media_container2_create_service (self, devgroup);
			_g_object_unref0 (devgroup);
		}
		_g_object_unref0 (_devgroup_it);
	}
	_g_object_unref0 (manager);
}


static void dvb_media_server2_device_groups_media_container2_create_service (DVBMediaServer2DeviceGroupsMediaContainer2* self, DVBDeviceGroup* devgroup) {
	guint _tmp0_;
	DVBMediaServer2ChannelsMediaContainer2* _tmp1_ = NULL;
	DVBMediaServer2ChannelsMediaContainer2* devgroup_container;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	guint _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (devgroup != NULL);
	_tmp0_ = dvb_device_group_get_Id (devgroup);
	dvb_logging_logger_debug (dvb_media_server2_log, "Services2.vala:62: Creating container for device group %u", _tmp0_);
	_tmp1_ = dvb_media_server2_channels_media_container2_new (devgroup, self->priv->path);
	devgroup_container = _tmp1_;
	_tmp2_ = media_object2_get_Path ((MediaObject2*) devgroup_container);
	_tmp3_ = _tmp2_;
	dvb_utils_dbus_register_object (TYPE_MEDIA_CONTAINER2, (GBoxedCopyFunc) g_object_ref, g_object_unref, dvb_media_server2_conn, _tmp3_, (MediaContainer2*) devgroup_container);
	_g_free0 (_tmp3_);
	_tmp4_ = media_object2_get_Path ((MediaObject2*) devgroup_container);
	_tmp5_ = _tmp4_;
	dvb_utils_dbus_register_object (TYPE_MEDIA_OBJECT2, (GBoxedCopyFunc) g_object_ref, g_object_unref, dvb_media_server2_conn, _tmp5_, (MediaObject2*) devgroup_container);
	_g_free0 (_tmp5_);
	dvb_media_server2_channels_media_container2_create_item_services (devgroup_container, dvb_media_server2_conn);
	_tmp6_ = dvb_device_group_get_Id (devgroup);
	gee_abstract_map_set ((GeeAbstractMap*) self->priv->containers, GUINT_TO_POINTER (_tmp6_), devgroup_container);
	_g_object_unref0 (devgroup_container);
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_variant_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_variant_unref (var), NULL));
}


static GVariant* _variant_new1 (gchar* value) {
	return g_variant_ref_sink (g_variant_new_string (value));
}


static GVariant* _variant_new2 (gchar* value) {
	return g_variant_ref_sink (g_variant_new_string (value));
}


static GVariant* _variant_new3 (guint value) {
	return g_variant_ref_sink (g_variant_new_uint32 (value));
}


static GVariant* _variant_new4 (gboolean value) {
	return g_variant_ref_sink (g_variant_new_boolean (value));
}


static GVariant* _variant_new5 (gchar* value) {
	return g_variant_ref_sink (g_variant_new_string (value));
}


static GVariant* _variant_new6 (gchar* value) {
	return g_variant_ref_sink (g_variant_new_string (value));
}


static GHashTable** dvb_media_server2_device_groups_media_container2_real_ListContainers (MediaContainer2* base, guint offset, guint max, gchar** filter, int filter_length1, int* result_length1, GError** error) {
	DVBMediaServer2DeviceGroupsMediaContainer2 * self;
	GHashTable** result = NULL;
	gint _tmp0_;
	guint _tmp1_;
	guint num_elements;
	GHashTable** _tmp2_ = NULL;
	GHashTable** hash;
	gint hash_length1;
	gint _hash_size_;
	gint i;
	GHashTable** _tmp23_;
	self = (DVBMediaServer2DeviceGroupsMediaContainer2*) base;
	_tmp0_ = gee_map_get_size ((GeeMap*) self->priv->containers);
	_tmp1_ = dvb_media_server2_get_num_elements (_tmp0_, offset, max);
	num_elements = _tmp1_;
	_tmp2_ = g_new0 (GHashTable*, num_elements + 1);
	hash = _tmp2_;
	hash_length1 = num_elements;
	_hash_size_ = num_elements;
	i = 0;
	{
		GeeCollection* _tmp3_ = NULL;
		GeeCollection* _tmp4_;
		GeeIterator* _tmp5_ = NULL;
		GeeIterator* _tmp6_;
		GeeIterator* _container_it;
		_tmp3_ = gee_map_get_values ((GeeMap*) self->priv->containers);
		_tmp4_ = _tmp3_;
		_tmp5_ = gee_iterable_iterator ((GeeIterable*) _tmp4_);
		_tmp6_ = _tmp5_;
		_g_object_unref0 (_tmp4_);
		_container_it = _tmp6_;
		while (TRUE) {
			gboolean _tmp7_;
			gpointer _tmp8_ = NULL;
			DVBMediaServer2ChannelsMediaContainer2* container;
			_tmp7_ = gee_iterator_next (_container_it);
			if (!_tmp7_) {
				break;
			}
			_tmp8_ = gee_iterator_get (_container_it);
			container = (DVBMediaServer2ChannelsMediaContainer2*) _tmp8_;
			if (i >= offset) {
				guint index;
				GHashTable* _tmp9_ = NULL;
				GHashTable* _tmp10_;
				gchar* _tmp11_;
				gchar* _tmp12_ = NULL;
				gchar* _tmp13_;
				gchar* _tmp14_ = NULL;
				gchar* _tmp15_;
				guint _tmp16_;
				gchar* _tmp17_;
				gboolean _tmp18_;
				gchar* _tmp19_;
				gchar* _tmp20_ = NULL;
				gchar* _tmp21_;
				gchar* _tmp22_ = NULL;
				index = i - offset;
				_tmp9_ = g_hash_table_new_full (g_str_hash, g_str_equal, _g_free0_, _g_variant_unref0_);
				_tmp10_ = _tmp9_;
				_g_hash_table_unref0 (hash[index]);
				hash[index] = _tmp10_;
				_tmp11_ = g_strdup ("Path");
				_tmp12_ = media_object2_get_Path ((MediaObject2*) container);
				g_hash_table_insert (hash[index], _tmp11_, _variant_new1 (_tmp12_));
				_tmp13_ = g_strdup ("DisplayName");
				_tmp14_ = media_object2_get_DisplayName ((MediaObject2*) container);
				g_hash_table_insert (hash[index], _tmp13_, _variant_new2 (_tmp14_));
				_tmp15_ = g_strdup ("ChildCount");
				_tmp16_ = media_container2_get_ChildCount ((MediaContainer2*) container);
				g_hash_table_insert (hash[index], _tmp15_, _variant_new3 (_tmp16_));
				_tmp17_ = g_strdup ("Searchable");
				_tmp18_ = media_container2_get_Searchable ((MediaContainer2*) container);
				g_hash_table_insert (hash[index], _tmp17_, _variant_new4 (_tmp18_));
				_tmp19_ = g_strdup ("Type");
				_tmp20_ = media_object2_get_Type ((MediaObject2*) container);
				g_hash_table_insert (hash[index], _tmp19_, _variant_new5 (_tmp20_));
				_tmp21_ = g_strdup ("Parent");
				_tmp22_ = media_object2_get_Path ((MediaObject2*) self);
				g_hash_table_insert (hash[index], _tmp21_, _variant_new6 (_tmp22_));
			}
			i++;
			if (i >= (offset + num_elements)) {
				_g_object_unref0 (container);
				break;
			}
			_g_object_unref0 (container);
		}
		_g_object_unref0 (_container_it);
	}
	_tmp23_ = hash;
	*result_length1 = hash_length1;
	result = _tmp23_;
	return result;
}


static GHashTable** dvb_media_server2_device_groups_media_container2_real_ListChildren (MediaContainer2* base, guint offset, guint max, gchar** filter, int filter_length1, int* result_length1, GError** error) {
	DVBMediaServer2DeviceGroupsMediaContainer2 * self;
	GHashTable** result = NULL;
	gint _tmp0_;
	GHashTable** _tmp1_ = NULL;
	GHashTable** _tmp2_;
	gint _tmp2__length1;
	gint __tmp2__size_;
	GHashTable** _tmp3_;
	GError * _inner_error_ = NULL;
	self = (DVBMediaServer2DeviceGroupsMediaContainer2*) base;
	_tmp1_ = media_container2_ListContainers ((MediaContainer2*) self, offset, max, filter, filter_length1, &_tmp0_, &_inner_error_);
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _tmp0_;
	__tmp2__size_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_DBUS_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp3_ = _tmp2_;
	*result_length1 = _tmp2__length1;
	result = _tmp3_;
	return result;
}


static GHashTable** dvb_media_server2_device_groups_media_container2_real_ListItems (MediaContainer2* base, guint offset, guint max, gchar** filter, int filter_length1, int* result_length1, GError** error) {
	DVBMediaServer2DeviceGroupsMediaContainer2 * self;
	GHashTable** result = NULL;
	GHashTable** _tmp0_ = NULL;
	GHashTable** _tmp1_;
	self = (DVBMediaServer2DeviceGroupsMediaContainer2*) base;
	_tmp0_ = g_new0 (GHashTable*, 0 + 1);
	_tmp1_ = _tmp0_;
	*result_length1 = 0;
	result = _tmp1_;
	return result;
}


static void dvb_media_server2_device_groups_media_container2_on_device_added (DVBMediaServer2DeviceGroupsMediaContainer2* self, guint group_id) {
	DVBManager* _tmp0_ = NULL;
	DVBManager* _tmp1_;
	DVBManager* manager;
	DVBDeviceGroup* _tmp2_ = NULL;
	DVBDeviceGroup* devgroup;
	g_return_if_fail (self != NULL);
	_tmp0_ = dvb_manager_get_instance ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	manager = _tmp1_;
	_tmp2_ = dvb_manager_get_device_group_if_exists (manager, group_id);
	devgroup = _tmp2_;
	dvb_media_server2_device_groups_media_container2_create_service (self, devgroup);
	g_signal_emit_by_name ((MediaContainer2*) self, "updated");
	_g_object_unref0 (devgroup);
	_g_object_unref0 (manager);
}


static void dvb_media_server2_device_groups_media_container2_on_device_removed (DVBMediaServer2DeviceGroupsMediaContainer2* self, guint group_id) {
	g_return_if_fail (self != NULL);
	gee_abstract_map_unset ((GeeAbstractMap*) self->priv->containers, GUINT_TO_POINTER (group_id), NULL);
	g_signal_emit_by_name ((MediaContainer2*) self, "updated");
}


DVBMediaServer2DeviceGroupsMediaContainer2* dvb_media_server2_device_groups_media_container2_construct (GType object_type) {
	DVBMediaServer2DeviceGroupsMediaContainer2 * self = NULL;
	self = (DVBMediaServer2DeviceGroupsMediaContainer2*) g_object_new (object_type, NULL);
	return self;
}


DVBMediaServer2DeviceGroupsMediaContainer2* dvb_media_server2_device_groups_media_container2_new (void) {
	return dvb_media_server2_device_groups_media_container2_construct (DVB_MEDIA_SERVER2_TYPE_DEVICE_GROUPS_MEDIA_CONTAINER2);
}


static char* dvb_media_server2_device_groups_media_container2_real_get_Parent (MediaObject2* base) {
	char* result;
	DVBMediaServer2DeviceGroupsMediaContainer2* self;
	char* _tmp0_;
	self = (DVBMediaServer2DeviceGroupsMediaContainer2*) base;
	_tmp0_ = g_strdup (self->priv->path);
	result = _tmp0_;
	return result;
}


static gchar* dvb_media_server2_device_groups_media_container2_real_get_Path (MediaObject2* base) {
	gchar* result;
	DVBMediaServer2DeviceGroupsMediaContainer2* self;
	gchar* _tmp0_;
	self = (DVBMediaServer2DeviceGroupsMediaContainer2*) base;
	_tmp0_ = g_strdup (DVB_MEDIA_SERVER2_ROOT_PATH);
	result = _tmp0_;
	return result;
}


static gchar* dvb_media_server2_device_groups_media_container2_real_get_DisplayName (MediaObject2* base) {
	gchar* result;
	DVBMediaServer2DeviceGroupsMediaContainer2* self;
	gchar* _tmp0_;
	self = (DVBMediaServer2DeviceGroupsMediaContainer2*) base;
	_tmp0_ = g_strdup ("@REALNAME@'s TV on @HOSTNAME@");
	result = _tmp0_;
	return result;
}


static gchar* dvb_media_server2_device_groups_media_container2_real_get_Type (MediaObject2* base) {
	gchar* result;
	DVBMediaServer2DeviceGroupsMediaContainer2* self;
	gchar* _tmp0_;
	self = (DVBMediaServer2DeviceGroupsMediaContainer2*) base;
	_tmp0_ = g_strdup ("container");
	result = _tmp0_;
	return result;
}


static guint dvb_media_server2_device_groups_media_container2_real_get_ItemCount (MediaContainer2* base) {
	guint result;
	DVBMediaServer2DeviceGroupsMediaContainer2* self;
	self = (DVBMediaServer2DeviceGroupsMediaContainer2*) base;
	result = (guint) 0;
	return result;
}


static guint dvb_media_server2_device_groups_media_container2_real_get_ChildCount (MediaContainer2* base) {
	guint result;
	DVBMediaServer2DeviceGroupsMediaContainer2* self;
	guint _tmp0_;
	self = (DVBMediaServer2DeviceGroupsMediaContainer2*) base;
	_tmp0_ = media_container2_get_ContainerCount ((MediaContainer2*) self);
	result = _tmp0_;
	return result;
}


static guint dvb_media_server2_device_groups_media_container2_real_get_ContainerCount (MediaContainer2* base) {
	guint result;
	DVBMediaServer2DeviceGroupsMediaContainer2* self;
	gint _tmp0_;
	self = (DVBMediaServer2DeviceGroupsMediaContainer2*) base;
	_tmp0_ = gee_map_get_size ((GeeMap*) self->priv->containers);
	result = (guint) _tmp0_;
	return result;
}


static gboolean dvb_media_server2_device_groups_media_container2_real_get_Searchable (MediaContainer2* base) {
	gboolean result;
	DVBMediaServer2DeviceGroupsMediaContainer2* self;
	self = (DVBMediaServer2DeviceGroupsMediaContainer2*) base;
	result = FALSE;
	return result;
}


static void _dvb_media_server2_device_groups_media_container2_on_device_added_dvb_id_bus_manager_group_added (DVBIDBusManager* _sender, guint group_id, gpointer self) {
	dvb_media_server2_device_groups_media_container2_on_device_added (self, group_id);
}


static void _dvb_media_server2_device_groups_media_container2_on_device_removed_dvb_id_bus_manager_group_removed (DVBIDBusManager* _sender, guint group_id, gpointer self) {
	dvb_media_server2_device_groups_media_container2_on_device_removed (self, group_id);
}


static GObject * dvb_media_server2_device_groups_media_container2_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	DVBMediaServer2DeviceGroupsMediaContainer2 * self;
	GeeHashMap* _tmp0_ = NULL;
	DVBManager* _tmp1_ = NULL;
	DVBManager* _tmp2_;
	DVBManager* manager;
	char* _tmp3_ = NULL;
	parent_class = G_OBJECT_CLASS (dvb_media_server2_device_groups_media_container2_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = DVB_MEDIA_SERVER2_DEVICE_GROUPS_MEDIA_CONTAINER2 (obj);
	_tmp0_ = gee_hash_map_new (G_TYPE_UINT, NULL, NULL, DVB_MEDIA_SERVER2_TYPE_CHANNELS_MEDIA_CONTAINER2, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->containers);
	self->priv->containers = _tmp0_;
	_tmp1_ = dvb_manager_get_instance ();
	_tmp2_ = _g_object_ref0 (_tmp1_);
	manager = _tmp2_;
	g_signal_connect_object ((DVBIDBusManager*) manager, "group-added", (GCallback) _dvb_media_server2_device_groups_media_container2_on_device_added_dvb_id_bus_manager_group_added, self, 0);
	g_signal_connect_object ((DVBIDBusManager*) manager, "group-removed", (GCallback) _dvb_media_server2_device_groups_media_container2_on_device_removed_dvb_id_bus_manager_group_removed, self, 0);
	_tmp3_ = g_strdup (DVB_MEDIA_SERVER2_ROOT_PATH);
	_g_free0 (self->priv->path);
	self->priv->path = _tmp3_;
	_g_object_unref0 (manager);
	return obj;
}


static void dvb_media_server2_device_groups_media_container2_class_init (DVBMediaServer2DeviceGroupsMediaContainer2Class * klass) {
	dvb_media_server2_device_groups_media_container2_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBMediaServer2DeviceGroupsMediaContainer2Private));
	G_OBJECT_CLASS (klass)->get_property = _vala_dvb_media_server2_device_groups_media_container2_get_property;
	G_OBJECT_CLASS (klass)->constructor = dvb_media_server2_device_groups_media_container2_constructor;
	G_OBJECT_CLASS (klass)->finalize = dvb_media_server2_device_groups_media_container2_finalize;
}


static void dvb_media_server2_device_groups_media_container2_media_container2_interface_init (MediaContainer2Iface * iface) {
	dvb_media_server2_device_groups_media_container2_media_container2_parent_iface = g_type_interface_peek_parent (iface);
	iface->ListContainers = (GHashTable** (*)(MediaContainer2* ,guint ,guint ,gchar** ,int ,int* ,GError**)) dvb_media_server2_device_groups_media_container2_real_ListContainers;
	iface->ListChildren = (GHashTable** (*)(MediaContainer2* ,guint ,guint ,gchar** ,int ,int* ,GError**)) dvb_media_server2_device_groups_media_container2_real_ListChildren;
	iface->ListItems = (GHashTable** (*)(MediaContainer2* ,guint ,guint ,gchar** ,int ,int* ,GError**)) dvb_media_server2_device_groups_media_container2_real_ListItems;
	iface->get_ItemCount = dvb_media_server2_device_groups_media_container2_real_get_ItemCount;
	iface->get_ChildCount = dvb_media_server2_device_groups_media_container2_real_get_ChildCount;
	iface->get_ContainerCount = dvb_media_server2_device_groups_media_container2_real_get_ContainerCount;
	iface->get_Searchable = dvb_media_server2_device_groups_media_container2_real_get_Searchable;
}


static void dvb_media_server2_device_groups_media_container2_media_object2_interface_init (MediaObject2Iface * iface) {
	dvb_media_server2_device_groups_media_container2_media_object2_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_Parent = dvb_media_server2_device_groups_media_container2_real_get_Parent;
	iface->get_Path = dvb_media_server2_device_groups_media_container2_real_get_Path;
	iface->get_DisplayName = dvb_media_server2_device_groups_media_container2_real_get_DisplayName;
	iface->get_Type = dvb_media_server2_device_groups_media_container2_real_get_Type;
}


static void dvb_media_server2_device_groups_media_container2_instance_init (DVBMediaServer2DeviceGroupsMediaContainer2 * self) {
	self->priv = DVB_MEDIA_SERVER2_DEVICE_GROUPS_MEDIA_CONTAINER2_GET_PRIVATE (self);
}


static void dvb_media_server2_device_groups_media_container2_finalize (GObject* obj) {
	DVBMediaServer2DeviceGroupsMediaContainer2 * self;
	self = DVB_MEDIA_SERVER2_DEVICE_GROUPS_MEDIA_CONTAINER2 (obj);
	_g_object_unref0 (self->priv->containers);
	_g_free0 (self->priv->path);
	G_OBJECT_CLASS (dvb_media_server2_device_groups_media_container2_parent_class)->finalize (obj);
}


/**
     * Holds all device groups
     *
     * It only contains containers only and no items
     */
GType dvb_media_server2_device_groups_media_container2_get_type (void) {
	static volatile gsize dvb_media_server2_device_groups_media_container2_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_media_server2_device_groups_media_container2_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBMediaServer2DeviceGroupsMediaContainer2Class), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_media_server2_device_groups_media_container2_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBMediaServer2DeviceGroupsMediaContainer2), 0, (GInstanceInitFunc) dvb_media_server2_device_groups_media_container2_instance_init, NULL };
		static const GInterfaceInfo media_container2_info = { (GInterfaceInitFunc) dvb_media_server2_device_groups_media_container2_media_container2_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo media_object2_info = { (GInterfaceInitFunc) dvb_media_server2_device_groups_media_container2_media_object2_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType dvb_media_server2_device_groups_media_container2_type_id;
		dvb_media_server2_device_groups_media_container2_type_id = g_type_register_static (G_TYPE_OBJECT, "DVBMediaServer2DeviceGroupsMediaContainer2", &g_define_type_info, 0);
		g_type_add_interface_static (dvb_media_server2_device_groups_media_container2_type_id, TYPE_MEDIA_CONTAINER2, &media_container2_info);
		g_type_add_interface_static (dvb_media_server2_device_groups_media_container2_type_id, TYPE_MEDIA_OBJECT2, &media_object2_info);
		g_once_init_leave (&dvb_media_server2_device_groups_media_container2_type_id__volatile, dvb_media_server2_device_groups_media_container2_type_id);
	}
	return dvb_media_server2_device_groups_media_container2_type_id__volatile;
}


static void _vala_dvb_media_server2_device_groups_media_container2_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DVBMediaServer2DeviceGroupsMediaContainer2 * self;
	self = DVB_MEDIA_SERVER2_DEVICE_GROUPS_MEDIA_CONTAINER2 (object);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


DVBMediaServer2ChannelsMediaContainer2* dvb_media_server2_channels_media_container2_construct (GType object_type, DVBDeviceGroup* devgroup, const char* parent) {
	DVBMediaServer2ChannelsMediaContainer2 * self = NULL;
	DVBDeviceGroup* _tmp0_;
	char* _tmp1_;
	g_return_val_if_fail (devgroup != NULL, NULL);
	g_return_val_if_fail (parent != NULL, NULL);
	self = (DVBMediaServer2ChannelsMediaContainer2*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (devgroup);
	_g_object_unref0 (self->priv->device_group);
	self->priv->device_group = _tmp0_;
	_tmp1_ = g_strdup (parent);
	_g_free0 (self->parent);
	self->parent = _tmp1_;
	return self;
}


DVBMediaServer2ChannelsMediaContainer2* dvb_media_server2_channels_media_container2_new (DVBDeviceGroup* devgroup, const char* parent) {
	return dvb_media_server2_channels_media_container2_construct (DVB_MEDIA_SERVER2_TYPE_CHANNELS_MEDIA_CONTAINER2, devgroup, parent);
}


void dvb_media_server2_channels_media_container2_create_item_services (DVBMediaServer2ChannelsMediaContainer2* self, GDBusConnection* conn) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (conn != NULL);
	{
		DVBChannelList* _tmp0_ = NULL;
		GeeIterator* _tmp1_ = NULL;
		GeeIterator* _channel_it;
		_tmp0_ = dvb_device_group_get_Channels (self->priv->device_group);
		_tmp1_ = gee_iterable_iterator ((GeeIterable*) _tmp0_);
		_channel_it = _tmp1_;
		while (TRUE) {
			gboolean _tmp2_;
			gpointer _tmp3_ = NULL;
			DVBChannel* channel;
			_tmp2_ = gee_iterator_next (_channel_it);
			if (!_tmp2_) {
				break;
			}
			_tmp3_ = gee_iterator_get (_channel_it);
			channel = (DVBChannel*) _tmp3_;
			dvb_media_server2_channels_media_container2_create_service (self, channel);
			_g_object_unref0 (channel);
		}
		_g_object_unref0 (_channel_it);
	}
}


void dvb_media_server2_channels_media_container2_create_service (DVBMediaServer2ChannelsMediaContainer2* self, DVBChannel* channel) {
	guint _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	char* _tmp3_ = NULL;
	char* _tmp4_;
	DVBMediaServer2ChannelMediaItem2* _tmp5_ = NULL;
	DVBMediaServer2ChannelMediaItem2* _tmp6_;
	DVBMediaServer2ChannelMediaItem2* channel_item;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_;
	guint _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (channel != NULL);
	_tmp0_ = dvb_channel_get_Sid (channel);
	dvb_logging_logger_debug (dvb_media_server2_log, "Services2.vala:205: Creating container for channel %u", _tmp0_);
	_tmp1_ = media_object2_get_Path ((MediaObject2*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = dvb_media_server2_channel_media_item2_new (channel, _tmp4_);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	channel_item = _tmp6_;
	_tmp7_ = media_object2_get_Path ((MediaObject2*) channel_item);
	_tmp8_ = _tmp7_;
	dvb_utils_dbus_register_object (TYPE_MEDIA_ITEM2, (GBoxedCopyFunc) g_object_ref, g_object_unref, dvb_media_server2_conn, _tmp8_, (MediaItem2*) channel_item);
	_g_free0 (_tmp8_);
	_tmp9_ = media_object2_get_Path ((MediaObject2*) channel_item);
	_tmp10_ = _tmp9_;
	dvb_utils_dbus_register_object (TYPE_MEDIA_OBJECT2, (GBoxedCopyFunc) g_object_ref, g_object_unref, dvb_media_server2_conn, _tmp10_, (MediaObject2*) channel_item);
	_g_free0 (_tmp10_);
	_tmp11_ = dvb_channel_get_Sid (channel);
	gee_abstract_map_set ((GeeAbstractMap*) self->priv->items, GUINT_TO_POINTER (_tmp11_), channel_item);
	_g_object_unref0 (channel_item);
}


static GVariant* _variant_new7 (gchar* value) {
	return g_variant_ref_sink (g_variant_new_string (value));
}


static GVariant* _variant_new8 (gchar* value) {
	return g_variant_ref_sink (g_variant_new_string (value));
}


static GVariant* _variant_new9 (gchar* value) {
	return g_variant_ref_sink (g_variant_new_string (value));
}


static GVariant* _variant_new10 (gchar* value) {
	return g_variant_ref_sink (g_variant_new_string (value));
}


static GVariant* _variant_new11 (gchar** value, gint value_length1) {
	gchar** _tmp22_;
	GVariantBuilder _tmp23_;
	int _tmp24_;
	_tmp22_ = value;
	g_variant_builder_init (&_tmp23_, G_VARIANT_TYPE ("as"));
	for (_tmp24_ = 0; _tmp24_ < value_length1; _tmp24_++) {
		g_variant_builder_add_value (&_tmp23_, g_variant_new_string (*_tmp22_));
		_tmp22_++;
	}
	return g_variant_ref_sink (g_variant_builder_end (&_tmp23_));
}


static GVariant* _variant_new12 (gchar* value) {
	return g_variant_ref_sink (g_variant_new_string (value));
}


static GHashTable** dvb_media_server2_channels_media_container2_real_ListItems (MediaContainer2* base, guint offset, guint max, gchar** filter, int filter_length1, int* result_length1, GError** error) {
	DVBMediaServer2ChannelsMediaContainer2 * self;
	GHashTable** result = NULL;
	gint _tmp0_;
	guint _tmp1_;
	guint num_elements;
	GHashTable** _tmp2_ = NULL;
	GHashTable** hash;
	gint hash_length1;
	gint _hash_size_;
	guint i;
	GHashTable** _tmp27_;
	self = (DVBMediaServer2ChannelsMediaContainer2*) base;
	_tmp0_ = gee_map_get_size ((GeeMap*) self->priv->items);
	_tmp1_ = dvb_media_server2_get_num_elements (_tmp0_, offset, max);
	num_elements = _tmp1_;
	_tmp2_ = g_new0 (GHashTable*, num_elements + 1);
	hash = _tmp2_;
	hash_length1 = num_elements;
	_hash_size_ = num_elements;
	i = (guint) 0;
	{
		GeeCollection* _tmp3_ = NULL;
		GeeCollection* _tmp4_;
		GeeIterator* _tmp5_ = NULL;
		GeeIterator* _tmp6_;
		GeeIterator* _item_it;
		_tmp3_ = gee_map_get_values ((GeeMap*) self->priv->items);
		_tmp4_ = _tmp3_;
		_tmp5_ = gee_iterable_iterator ((GeeIterable*) _tmp4_);
		_tmp6_ = _tmp5_;
		_g_object_unref0 (_tmp4_);
		_item_it = _tmp6_;
		while (TRUE) {
			gboolean _tmp7_;
			gpointer _tmp8_ = NULL;
			DVBMediaServer2ChannelMediaItem2* item;
			_tmp7_ = gee_iterator_next (_item_it);
			if (!_tmp7_) {
				break;
			}
			_tmp8_ = gee_iterator_get (_item_it);
			item = (DVBMediaServer2ChannelMediaItem2*) _tmp8_;
			if (i >= offset) {
				guint index;
				GHashTable* _tmp9_ = NULL;
				GHashTable* _tmp10_;
				gchar* _tmp11_;
				gchar* _tmp12_ = NULL;
				gchar* _tmp13_;
				gchar* _tmp14_ = NULL;
				gchar* _tmp15_;
				gchar* _tmp16_ = NULL;
				gchar* _tmp17_;
				gchar* _tmp18_ = NULL;
				gchar* _tmp19_;
				gchar** _tmp20_ = NULL;
				gint _tmp21_;
				gchar* _tmp25_;
				gchar* _tmp26_ = NULL;
				index = i - offset;
				_tmp9_ = g_hash_table_new_full (g_str_hash, g_str_equal, _g_free0_, _g_variant_unref0_);
				_tmp10_ = _tmp9_;
				_g_hash_table_unref0 (hash[index]);
				hash[index] = _tmp10_;
				_tmp11_ = g_strdup ("Path");
				_tmp12_ = media_object2_get_Path ((MediaObject2*) item);
				g_hash_table_insert (hash[index], _tmp11_, _variant_new7 (_tmp12_));
				_tmp13_ = g_strdup ("DisplayName");
				_tmp14_ = media_object2_get_DisplayName ((MediaObject2*) item);
				g_hash_table_insert (hash[index], _tmp13_, _variant_new8 (_tmp14_));
				_tmp15_ = g_strdup ("Type");
				_tmp16_ = media_object2_get_Type ((MediaObject2*) item);
				g_hash_table_insert (hash[index], _tmp15_, _variant_new9 (_tmp16_));
				_tmp17_ = g_strdup ("MIMEType");
				_tmp18_ = media_item2_get_MIMEType ((MediaItem2*) item);
				g_hash_table_insert (hash[index], _tmp17_, _variant_new10 (_tmp18_));
				_tmp19_ = g_strdup ("URLs");
				_tmp20_ = media_item2_get_URLs ((MediaItem2*) item, &_tmp21_);
				g_hash_table_insert (hash[index], _tmp19_, _variant_new11 (_tmp20_, _tmp21_));
				_tmp25_ = g_strdup ("Parent");
				_tmp26_ = media_object2_get_Path ((MediaObject2*) self);
				g_hash_table_insert (hash[index], _tmp25_, _variant_new12 (_tmp26_));
			}
			i++;
			if (i >= (offset + num_elements)) {
				_g_object_unref0 (item);
				break;
			}
			_g_object_unref0 (item);
		}
		_g_object_unref0 (_item_it);
	}
	_tmp27_ = hash;
	*result_length1 = hash_length1;
	result = _tmp27_;
	return result;
}


static GHashTable** dvb_media_server2_channels_media_container2_real_ListContainers (MediaContainer2* base, guint offset, guint max, gchar** filter, int filter_length1, int* result_length1, GError** error) {
	DVBMediaServer2ChannelsMediaContainer2 * self;
	GHashTable** result = NULL;
	GHashTable** _tmp0_ = NULL;
	GHashTable** _tmp1_;
	self = (DVBMediaServer2ChannelsMediaContainer2*) base;
	_tmp0_ = g_new0 (GHashTable*, 0 + 1);
	_tmp1_ = _tmp0_;
	*result_length1 = 0;
	result = _tmp1_;
	return result;
}


static GHashTable** dvb_media_server2_channels_media_container2_real_ListChildren (MediaContainer2* base, guint offset, guint max, gchar** filter, int filter_length1, int* result_length1, GError** error) {
	DVBMediaServer2ChannelsMediaContainer2 * self;
	GHashTable** result = NULL;
	gint _tmp0_;
	GHashTable** _tmp1_ = NULL;
	GHashTable** _tmp2_;
	gint _tmp2__length1;
	gint __tmp2__size_;
	GHashTable** _tmp3_;
	GError * _inner_error_ = NULL;
	self = (DVBMediaServer2ChannelsMediaContainer2*) base;
	_tmp1_ = media_container2_ListItems ((MediaContainer2*) self, offset, max, filter, filter_length1, &_tmp0_, &_inner_error_);
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _tmp0_;
	__tmp2__size_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_DBUS_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp3_ = _tmp2_;
	*result_length1 = _tmp2__length1;
	result = _tmp3_;
	return result;
}


static char* dvb_media_server2_channels_media_container2_real_get_Parent (MediaObject2* base) {
	char* result;
	DVBMediaServer2ChannelsMediaContainer2* self;
	char* _tmp0_;
	self = (DVBMediaServer2ChannelsMediaContainer2*) base;
	_tmp0_ = g_strdup (self->parent);
	result = _tmp0_;
	return result;
}


static gchar* dvb_media_server2_channels_media_container2_real_get_Path (MediaObject2* base) {
	gchar* result;
	DVBMediaServer2ChannelsMediaContainer2* self;
	guint _tmp0_;
	gchar* _tmp1_ = NULL;
	self = (DVBMediaServer2ChannelsMediaContainer2*) base;
	_tmp0_ = dvb_device_group_get_Id (self->priv->device_group);
	_tmp1_ = g_strdup_printf (DVB_MEDIA_SERVER2_GROUP_PATH, _tmp0_);
	result = _tmp1_;
	return result;
}


static gchar* dvb_media_server2_channels_media_container2_real_get_DisplayName (MediaObject2* base) {
	gchar* result;
	DVBMediaServer2ChannelsMediaContainer2* self;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	self = (DVBMediaServer2ChannelsMediaContainer2*) base;
	_tmp0_ = dvb_device_group_get_Name (self->priv->device_group);
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


static gchar* dvb_media_server2_channels_media_container2_real_get_Type (MediaObject2* base) {
	gchar* result;
	DVBMediaServer2ChannelsMediaContainer2* self;
	gchar* _tmp0_;
	self = (DVBMediaServer2ChannelsMediaContainer2*) base;
	_tmp0_ = g_strdup ("container");
	result = _tmp0_;
	return result;
}


static guint dvb_media_server2_channels_media_container2_real_get_ChildCount (MediaContainer2* base) {
	guint result;
	DVBMediaServer2ChannelsMediaContainer2* self;
	guint _tmp0_;
	self = (DVBMediaServer2ChannelsMediaContainer2*) base;
	_tmp0_ = media_container2_get_ItemCount ((MediaContainer2*) self);
	result = _tmp0_;
	return result;
}


static guint dvb_media_server2_channels_media_container2_real_get_ItemCount (MediaContainer2* base) {
	guint result;
	DVBMediaServer2ChannelsMediaContainer2* self;
	gint _tmp0_;
	self = (DVBMediaServer2ChannelsMediaContainer2*) base;
	_tmp0_ = gee_map_get_size ((GeeMap*) self->priv->items);
	result = (guint) _tmp0_;
	return result;
}


static guint dvb_media_server2_channels_media_container2_real_get_ContainerCount (MediaContainer2* base) {
	guint result;
	DVBMediaServer2ChannelsMediaContainer2* self;
	self = (DVBMediaServer2ChannelsMediaContainer2*) base;
	result = (guint) 0;
	return result;
}


static gboolean dvb_media_server2_channels_media_container2_real_get_Searchable (MediaContainer2* base) {
	gboolean result;
	DVBMediaServer2ChannelsMediaContainer2* self;
	self = (DVBMediaServer2ChannelsMediaContainer2*) base;
	result = FALSE;
	return result;
}


static GObject * dvb_media_server2_channels_media_container2_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	DVBMediaServer2ChannelsMediaContainer2 * self;
	GeeHashMap* _tmp0_ = NULL;
	parent_class = G_OBJECT_CLASS (dvb_media_server2_channels_media_container2_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = DVB_MEDIA_SERVER2_CHANNELS_MEDIA_CONTAINER2 (obj);
	_tmp0_ = gee_hash_map_new (G_TYPE_UINT, NULL, NULL, DVB_MEDIA_SERVER2_TYPE_CHANNEL_MEDIA_ITEM2, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->items);
	self->priv->items = _tmp0_;
	return obj;
}


static void dvb_media_server2_channels_media_container2_class_init (DVBMediaServer2ChannelsMediaContainer2Class * klass) {
	dvb_media_server2_channels_media_container2_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBMediaServer2ChannelsMediaContainer2Private));
	G_OBJECT_CLASS (klass)->get_property = _vala_dvb_media_server2_channels_media_container2_get_property;
	G_OBJECT_CLASS (klass)->constructor = dvb_media_server2_channels_media_container2_constructor;
	G_OBJECT_CLASS (klass)->finalize = dvb_media_server2_channels_media_container2_finalize;
}


static void dvb_media_server2_channels_media_container2_media_container2_interface_init (MediaContainer2Iface * iface) {
	dvb_media_server2_channels_media_container2_media_container2_parent_iface = g_type_interface_peek_parent (iface);
	iface->ListItems = (GHashTable** (*)(MediaContainer2* ,guint ,guint ,gchar** ,int ,int* ,GError**)) dvb_media_server2_channels_media_container2_real_ListItems;
	iface->ListContainers = (GHashTable** (*)(MediaContainer2* ,guint ,guint ,gchar** ,int ,int* ,GError**)) dvb_media_server2_channels_media_container2_real_ListContainers;
	iface->ListChildren = (GHashTable** (*)(MediaContainer2* ,guint ,guint ,gchar** ,int ,int* ,GError**)) dvb_media_server2_channels_media_container2_real_ListChildren;
	iface->get_ChildCount = dvb_media_server2_channels_media_container2_real_get_ChildCount;
	iface->get_ItemCount = dvb_media_server2_channels_media_container2_real_get_ItemCount;
	iface->get_ContainerCount = dvb_media_server2_channels_media_container2_real_get_ContainerCount;
	iface->get_Searchable = dvb_media_server2_channels_media_container2_real_get_Searchable;
}


static void dvb_media_server2_channels_media_container2_media_object2_interface_init (MediaObject2Iface * iface) {
	dvb_media_server2_channels_media_container2_media_object2_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_Parent = dvb_media_server2_channels_media_container2_real_get_Parent;
	iface->get_Path = dvb_media_server2_channels_media_container2_real_get_Path;
	iface->get_DisplayName = dvb_media_server2_channels_media_container2_real_get_DisplayName;
	iface->get_Type = dvb_media_server2_channels_media_container2_real_get_Type;
}


static void dvb_media_server2_channels_media_container2_instance_init (DVBMediaServer2ChannelsMediaContainer2 * self) {
	self->priv = DVB_MEDIA_SERVER2_CHANNELS_MEDIA_CONTAINER2_GET_PRIVATE (self);
}


static void dvb_media_server2_channels_media_container2_finalize (GObject* obj) {
	DVBMediaServer2ChannelsMediaContainer2 * self;
	self = DVB_MEDIA_SERVER2_CHANNELS_MEDIA_CONTAINER2 (obj);
	_g_free0 (self->parent);
	_g_object_unref0 (self->priv->device_group);
	_g_object_unref0 (self->priv->items);
	G_OBJECT_CLASS (dvb_media_server2_channels_media_container2_parent_class)->finalize (obj);
}


/**
     * Holds a list of channels for a single device group
     *
     * It only contains items only and no containers
     */
GType dvb_media_server2_channels_media_container2_get_type (void) {
	static volatile gsize dvb_media_server2_channels_media_container2_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_media_server2_channels_media_container2_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBMediaServer2ChannelsMediaContainer2Class), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_media_server2_channels_media_container2_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBMediaServer2ChannelsMediaContainer2), 0, (GInstanceInitFunc) dvb_media_server2_channels_media_container2_instance_init, NULL };
		static const GInterfaceInfo media_container2_info = { (GInterfaceInitFunc) dvb_media_server2_channels_media_container2_media_container2_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo media_object2_info = { (GInterfaceInitFunc) dvb_media_server2_channels_media_container2_media_object2_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType dvb_media_server2_channels_media_container2_type_id;
		dvb_media_server2_channels_media_container2_type_id = g_type_register_static (G_TYPE_OBJECT, "DVBMediaServer2ChannelsMediaContainer2", &g_define_type_info, 0);
		g_type_add_interface_static (dvb_media_server2_channels_media_container2_type_id, TYPE_MEDIA_CONTAINER2, &media_container2_info);
		g_type_add_interface_static (dvb_media_server2_channels_media_container2_type_id, TYPE_MEDIA_OBJECT2, &media_object2_info);
		g_once_init_leave (&dvb_media_server2_channels_media_container2_type_id__volatile, dvb_media_server2_channels_media_container2_type_id);
	}
	return dvb_media_server2_channels_media_container2_type_id__volatile;
}


static void _vala_dvb_media_server2_channels_media_container2_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DVBMediaServer2ChannelsMediaContainer2 * self;
	self = DVB_MEDIA_SERVER2_CHANNELS_MEDIA_CONTAINER2 (object);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


DVBMediaServer2ChannelMediaItem2* dvb_media_server2_channel_media_item2_construct (GType object_type, DVBChannel* channel, const char* parent) {
	DVBMediaServer2ChannelMediaItem2 * self = NULL;
	DVBChannel* _tmp0_;
	char* _tmp1_;
	g_return_val_if_fail (channel != NULL, NULL);
	g_return_val_if_fail (parent != NULL, NULL);
	self = (DVBMediaServer2ChannelMediaItem2*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (channel);
	_g_object_unref0 (self->priv->channel);
	self->priv->channel = _tmp0_;
	_tmp1_ = g_strdup (parent);
	_g_free0 (self->priv->parent);
	self->priv->parent = _tmp1_;
	return self;
}


DVBMediaServer2ChannelMediaItem2* dvb_media_server2_channel_media_item2_new (DVBChannel* channel, const char* parent) {
	return dvb_media_server2_channel_media_item2_construct (DVB_MEDIA_SERVER2_TYPE_CHANNEL_MEDIA_ITEM2, channel, parent);
}


static char* dvb_media_server2_channel_media_item2_real_get_Parent (MediaObject2* base) {
	char* result;
	DVBMediaServer2ChannelMediaItem2* self;
	char* _tmp0_;
	self = (DVBMediaServer2ChannelMediaItem2*) base;
	_tmp0_ = g_strdup (self->priv->parent);
	result = _tmp0_;
	return result;
}


static gchar* dvb_media_server2_channel_media_item2_real_get_Path (MediaObject2* base) {
	gchar* result;
	DVBMediaServer2ChannelMediaItem2* self;
	guint _tmp0_;
	guint _tmp1_;
	gchar* _tmp2_ = NULL;
	self = (DVBMediaServer2ChannelMediaItem2*) base;
	_tmp0_ = dvb_channel_get_GroupId (self->priv->channel);
	_tmp1_ = dvb_channel_get_Sid (self->priv->channel);
	_tmp2_ = g_strdup_printf (DVB_MEDIA_SERVER2_CHANNEL_PATH, _tmp0_, _tmp1_);
	result = _tmp2_;
	return result;
}


static gchar* dvb_media_server2_channel_media_item2_real_get_DisplayName (MediaObject2* base) {
	gchar* result;
	DVBMediaServer2ChannelMediaItem2* self;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	self = (DVBMediaServer2ChannelMediaItem2*) base;
	_tmp0_ = dvb_channel_get_Name (self->priv->channel);
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


static gchar** dvb_media_server2_channel_media_item2_real_get_URLs (MediaItem2* base, int* result_length1) {
	gchar** result;
	DVBMediaServer2ChannelMediaItem2* self;
	gchar* _tmp0_ = NULL;
	gchar** _tmp1_ = NULL;
	gchar** _tmp2_;
	self = (DVBMediaServer2ChannelMediaItem2*) base;
	_tmp0_ = dvb_channel_get_URL (self->priv->channel);
	_tmp1_ = g_new0 (gchar*, 1 + 1);
	_tmp1_[0] = _tmp0_;
	_tmp2_ = _tmp1_;
	*result_length1 = 1;
	result = _tmp2_;
	return result;
}


static gchar* dvb_media_server2_channel_media_item2_real_get_MIMEType (MediaItem2* base) {
	gchar* result;
	DVBMediaServer2ChannelMediaItem2* self;
	gchar* _tmp0_;
	self = (DVBMediaServer2ChannelMediaItem2*) base;
	_tmp0_ = g_strdup ("video/mpeg");
	result = _tmp0_;
	return result;
}


static gchar* dvb_media_server2_channel_media_item2_real_get_Type (MediaObject2* base) {
	gchar* result;
	DVBMediaServer2ChannelMediaItem2* self;
	gchar* _tmp0_;
	self = (DVBMediaServer2ChannelMediaItem2*) base;
	_tmp0_ = g_strdup ("video");
	result = _tmp0_;
	return result;
}


static void dvb_media_server2_channel_media_item2_class_init (DVBMediaServer2ChannelMediaItem2Class * klass) {
	dvb_media_server2_channel_media_item2_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBMediaServer2ChannelMediaItem2Private));
	G_OBJECT_CLASS (klass)->get_property = _vala_dvb_media_server2_channel_media_item2_get_property;
	G_OBJECT_CLASS (klass)->finalize = dvb_media_server2_channel_media_item2_finalize;
}


static void dvb_media_server2_channel_media_item2_media_item2_interface_init (MediaItem2Iface * iface) {
	dvb_media_server2_channel_media_item2_media_item2_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_URLs = dvb_media_server2_channel_media_item2_real_get_URLs;
	iface->get_MIMEType = dvb_media_server2_channel_media_item2_real_get_MIMEType;
}


static void dvb_media_server2_channel_media_item2_media_object2_interface_init (MediaObject2Iface * iface) {
	dvb_media_server2_channel_media_item2_media_object2_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_Parent = dvb_media_server2_channel_media_item2_real_get_Parent;
	iface->get_Path = dvb_media_server2_channel_media_item2_real_get_Path;
	iface->get_DisplayName = dvb_media_server2_channel_media_item2_real_get_DisplayName;
	iface->get_Type = dvb_media_server2_channel_media_item2_real_get_Type;
}


static void dvb_media_server2_channel_media_item2_instance_init (DVBMediaServer2ChannelMediaItem2 * self) {
	self->priv = DVB_MEDIA_SERVER2_CHANNEL_MEDIA_ITEM2_GET_PRIVATE (self);
}


static void dvb_media_server2_channel_media_item2_finalize (GObject* obj) {
	DVBMediaServer2ChannelMediaItem2 * self;
	self = DVB_MEDIA_SERVER2_CHANNEL_MEDIA_ITEM2 (obj);
	_g_object_unref0 (self->priv->channel);
	_g_free0 (self->priv->parent);
	G_OBJECT_CLASS (dvb_media_server2_channel_media_item2_parent_class)->finalize (obj);
}


/**
     * Holds a single channel
     */
GType dvb_media_server2_channel_media_item2_get_type (void) {
	static volatile gsize dvb_media_server2_channel_media_item2_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_media_server2_channel_media_item2_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBMediaServer2ChannelMediaItem2Class), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_media_server2_channel_media_item2_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBMediaServer2ChannelMediaItem2), 0, (GInstanceInitFunc) dvb_media_server2_channel_media_item2_instance_init, NULL };
		static const GInterfaceInfo media_item2_info = { (GInterfaceInitFunc) dvb_media_server2_channel_media_item2_media_item2_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo media_object2_info = { (GInterfaceInitFunc) dvb_media_server2_channel_media_item2_media_object2_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType dvb_media_server2_channel_media_item2_type_id;
		dvb_media_server2_channel_media_item2_type_id = g_type_register_static (G_TYPE_OBJECT, "DVBMediaServer2ChannelMediaItem2", &g_define_type_info, 0);
		g_type_add_interface_static (dvb_media_server2_channel_media_item2_type_id, TYPE_MEDIA_ITEM2, &media_item2_info);
		g_type_add_interface_static (dvb_media_server2_channel_media_item2_type_id, TYPE_MEDIA_OBJECT2, &media_object2_info);
		g_once_init_leave (&dvb_media_server2_channel_media_item2_type_id__volatile, dvb_media_server2_channel_media_item2_type_id);
	}
	return dvb_media_server2_channel_media_item2_type_id__volatile;
}


static void _vala_dvb_media_server2_channel_media_item2_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DVBMediaServer2ChannelMediaItem2 * self;
	self = DVB_MEDIA_SERVER2_CHANNEL_MEDIA_ITEM2 (object);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


guint dvb_media_server2_get_num_elements (gint items, guint offset, guint max) {
	guint result = 0U;
	guint num_elements = 0U;
	if (max > 0) {
		if (max > (items - offset)) {
			num_elements = items - offset;
		} else {
			num_elements = max;
		}
	} else {
		num_elements = items - offset;
	}
	result = num_elements;
	return result;
}


void dvb_media_server2_on_bus_acquired (GDBusConnection* _conn) {
	DVBMediaServer2DeviceGroupsMediaContainer2* _tmp0_ = NULL;
	char* _tmp1_ = NULL;
	char* _tmp2_;
	char* _tmp3_ = NULL;
	char* _tmp4_;
	GDBusConnection* _tmp5_;
	g_return_if_fail (_conn != NULL);
	_tmp0_ = dvb_media_server2_device_groups_media_container2_new ();
	_g_object_unref0 (dvb_media_server2_root_container);
	dvb_media_server2_root_container = _tmp0_;
	_tmp1_ = media_object2_get_Parent ((MediaObject2*) dvb_media_server2_root_container);
	_tmp2_ = _tmp1_;
	dvb_utils_dbus_register_object (TYPE_MEDIA_CONTAINER2, (GBoxedCopyFunc) g_object_ref, g_object_unref, _conn, (const gchar*) _tmp2_, (MediaContainer2*) dvb_media_server2_root_container);
	_g_free0 (_tmp2_);
	_tmp3_ = media_object2_get_Parent ((MediaObject2*) dvb_media_server2_root_container);
	_tmp4_ = _tmp3_;
	dvb_utils_dbus_register_object (TYPE_MEDIA_OBJECT2, (GBoxedCopyFunc) g_object_ref, g_object_unref, _conn, (const gchar*) _tmp4_, (MediaObject2*) dvb_media_server2_root_container);
	_g_free0 (_tmp4_);
	_tmp5_ = _g_object_ref0 (_conn);
	_g_object_unref0 (dvb_media_server2_conn);
	dvb_media_server2_conn = _tmp5_;
	dvb_media_server2_device_groups_media_container2_create_container_services (dvb_media_server2_root_container);
}


static void _dvb_media_server2_on_bus_acquired_gbus_acquired_callback (GDBusConnection* connection, const gchar* name, gpointer self) {
	dvb_media_server2_on_bus_acquired (connection);
}


gboolean dvb_media_server2_start_rygel_services (void) {
	gboolean result = FALSE;
	DVBLoggingLogManager* _tmp0_ = NULL;
	DVBLoggingLogger* _tmp1_ = NULL;
	_tmp0_ = dvb_logging_log_manager_getLogManager ();
	_tmp1_ = dvb_logging_log_manager_getDefaultLogger (_tmp0_);
	_g_object_unref0 (dvb_media_server2_log);
	dvb_media_server2_log = _tmp1_;
	dvb_utils_dbus_own_name (DVB_MEDIA_SERVER2_SERVICE_NAME, _dvb_media_server2_on_bus_acquired_gbus_acquired_callback, NULL);
	result = FALSE;
	return result;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



