/* EventStorage.c generated by valac 0.12.0, the Vala compiler
 * generated from EventStorage.vala, do not modify */

/*
 * Copyright (C) 2011 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <time.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>


#define DVB_TYPE_EVENT_ELEMENT (dvb_event_element_get_type ())
#define DVB_EVENT_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_EVENT_ELEMENT, DVBEventElement))
#define DVB_EVENT_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_EVENT_ELEMENT, DVBEventElementClass))
#define DVB_IS_EVENT_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_EVENT_ELEMENT))
#define DVB_IS_EVENT_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_EVENT_ELEMENT))
#define DVB_EVENT_ELEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_EVENT_ELEMENT, DVBEventElementClass))

typedef struct _DVBEventElement DVBEventElement;
typedef struct _DVBEventElementClass DVBEventElementClass;
typedef struct _DVBEventElementPrivate DVBEventElementPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define DVB_TYPE_EVENT (dvb_event_get_type ())
#define DVB_EVENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_EVENT, DVBEvent))
#define DVB_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_EVENT, DVBEventClass))
#define DVB_IS_EVENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_EVENT))
#define DVB_IS_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_EVENT))
#define DVB_EVENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_EVENT, DVBEventClass))

typedef struct _DVBEvent DVBEvent;
typedef struct _DVBEventClass DVBEventClass;
typedef struct _DVBEventPrivate DVBEventPrivate;

#define DVB_EVENT_TYPE_AUDIO_COMPONENT (dvb_event_audio_component_get_type ())
#define DVB_EVENT_AUDIO_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_EVENT_TYPE_AUDIO_COMPONENT, DVBEventAudioComponent))
#define DVB_EVENT_AUDIO_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_EVENT_TYPE_AUDIO_COMPONENT, DVBEventAudioComponentClass))
#define DVB_EVENT_IS_AUDIO_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_EVENT_TYPE_AUDIO_COMPONENT))
#define DVB_EVENT_IS_AUDIO_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_EVENT_TYPE_AUDIO_COMPONENT))
#define DVB_EVENT_AUDIO_COMPONENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_EVENT_TYPE_AUDIO_COMPONENT, DVBEventAudioComponentClass))

typedef struct _DVBEventAudioComponent DVBEventAudioComponent;
typedef struct _DVBEventAudioComponentClass DVBEventAudioComponentClass;

#define DVB_EVENT_TYPE_VIDEO_COMPONENT (dvb_event_video_component_get_type ())
#define DVB_EVENT_VIDEO_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_EVENT_TYPE_VIDEO_COMPONENT, DVBEventVideoComponent))
#define DVB_EVENT_VIDEO_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_EVENT_TYPE_VIDEO_COMPONENT, DVBEventVideoComponentClass))
#define DVB_EVENT_IS_VIDEO_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_EVENT_TYPE_VIDEO_COMPONENT))
#define DVB_EVENT_IS_VIDEO_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_EVENT_TYPE_VIDEO_COMPONENT))
#define DVB_EVENT_VIDEO_COMPONENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_EVENT_TYPE_VIDEO_COMPONENT, DVBEventVideoComponentClass))

typedef struct _DVBEventVideoComponent DVBEventVideoComponent;
typedef struct _DVBEventVideoComponentClass DVBEventVideoComponentClass;

#define DVB_EVENT_TYPE_TELETEXT_COMPONENT (dvb_event_teletext_component_get_type ())
#define DVB_EVENT_TELETEXT_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_EVENT_TYPE_TELETEXT_COMPONENT, DVBEventTeletextComponent))
#define DVB_EVENT_TELETEXT_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_EVENT_TYPE_TELETEXT_COMPONENT, DVBEventTeletextComponentClass))
#define DVB_EVENT_IS_TELETEXT_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_EVENT_TYPE_TELETEXT_COMPONENT))
#define DVB_EVENT_IS_TELETEXT_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_EVENT_TYPE_TELETEXT_COMPONENT))
#define DVB_EVENT_TELETEXT_COMPONENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_EVENT_TYPE_TELETEXT_COMPONENT, DVBEventTeletextComponentClass))

typedef struct _DVBEventTeletextComponent DVBEventTeletextComponent;
typedef struct _DVBEventTeletextComponentClass DVBEventTeletextComponentClass;

#define DVB_TYPE_EVENT_STORAGE (dvb_event_storage_get_type ())
#define DVB_EVENT_STORAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_EVENT_STORAGE, DVBEventStorage))
#define DVB_EVENT_STORAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_EVENT_STORAGE, DVBEventStorageClass))
#define DVB_IS_EVENT_STORAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_EVENT_STORAGE))
#define DVB_IS_EVENT_STORAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_EVENT_STORAGE))
#define DVB_EVENT_STORAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_EVENT_STORAGE, DVBEventStorageClass))

typedef struct _DVBEventStorage DVBEventStorage;
typedef struct _DVBEventStorageClass DVBEventStorageClass;
typedef struct _DVBEventStoragePrivate DVBEventStoragePrivate;
#define _g_sequence_free0(var) ((var == NULL) ? NULL : (var = (g_sequence_free (var), NULL)))
#define _dvb_event_unref0(var) ((var == NULL) ? NULL : (var = (dvb_event_unref (var), NULL)))

#define DVB_EVENT_STORAGE_TYPE_EVENT_ITERATOR (dvb_event_storage_event_iterator_get_type ())
#define DVB_EVENT_STORAGE_EVENT_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_EVENT_STORAGE_TYPE_EVENT_ITERATOR, DVBEventStorageEventIterator))
#define DVB_EVENT_STORAGE_EVENT_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_EVENT_STORAGE_TYPE_EVENT_ITERATOR, DVBEventStorageEventIteratorClass))
#define DVB_EVENT_STORAGE_IS_EVENT_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_EVENT_STORAGE_TYPE_EVENT_ITERATOR))
#define DVB_EVENT_STORAGE_IS_EVENT_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_EVENT_STORAGE_TYPE_EVENT_ITERATOR))
#define DVB_EVENT_STORAGE_EVENT_ITERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_EVENT_STORAGE_TYPE_EVENT_ITERATOR, DVBEventStorageEventIteratorClass))

typedef struct _DVBEventStorageEventIterator DVBEventStorageEventIterator;
typedef struct _DVBEventStorageEventIteratorClass DVBEventStorageEventIteratorClass;
typedef struct _DVBEventStorageEventIteratorPrivate DVBEventStorageEventIteratorPrivate;

struct _DVBEventElement {
	GObject parent_instance;
	DVBEventElementPrivate * priv;
	guint id;
	time_t starttime;
};

struct _DVBEventElementClass {
	GObjectClass parent_class;
};

struct _DVBEvent {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DVBEventPrivate * priv;
	guint id;
	guint year;
	guint month;
	guint hour;
	guint day;
	guint minute;
	guint second;
	guint duration;
	guint running_status;
	gboolean free_ca_mode;
	gchar* name;
	gchar* description;
	gchar* extended_description;
	GSList* audio_components;
	GSList* video_components;
	GSList* teletext_components;
};

struct _DVBEventClass {
	GTypeClass parent_class;
	void (*finalize) (DVBEvent *self);
};

struct _DVBEventStorage {
	GObject parent_instance;
	DVBEventStoragePrivate * priv;
};

struct _DVBEventStorageClass {
	GObjectClass parent_class;
};

struct _DVBEventStoragePrivate {
	GSequence* events;
	GeeMap* event_id_map;
	gint _stamp;
};

struct _DVBEventStorageEventIterator {
	GObject parent_instance;
	DVBEventStorageEventIteratorPrivate * priv;
};

struct _DVBEventStorageEventIteratorClass {
	GObjectClass parent_class;
};

struct _DVBEventStorageEventIteratorPrivate {
	DVBEventStorage* _storage;
	GSequenceIter* _iter;
	gint _stamp;
};


static gpointer dvb_event_element_parent_class = NULL;
static gpointer dvb_event_storage_parent_class = NULL;
static gpointer dvb_event_storage_event_iterator_parent_class = NULL;
static GeeIteratorIface* dvb_event_storage_event_iterator_gee_iterator_parent_iface = NULL;
static GeeBidirIteratorIface* dvb_event_storage_event_iterator_gee_bidir_iterator_parent_iface = NULL;
static GeeIterableIface* dvb_event_storage_gee_iterable_parent_iface = NULL;

GType dvb_event_element_get_type (void) G_GNUC_CONST;
enum  {
	DVB_EVENT_ELEMENT_DUMMY_PROPERTY
};
gint dvb_event_element_compare (DVBEventElement* event1, DVBEventElement* event2);
void dvb_event_element_destroy (void* data);
gpointer dvb_event_ref (gpointer instance);
void dvb_event_unref (gpointer instance);
GParamSpec* dvb_param_spec_event (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void dvb_value_set_event (GValue* value, gpointer v_object);
void dvb_value_take_event (GValue* value, gpointer v_object);
gpointer dvb_value_get_event (const GValue* value);
GType dvb_event_get_type (void) G_GNUC_CONST;
DVBEventElement* dvb_event_element_new_from_event (DVBEvent* event);
DVBEventElement* dvb_event_element_new (void);
DVBEventElement* dvb_event_element_construct (GType object_type);
gpointer dvb_event_audio_component_ref (gpointer instance);
void dvb_event_audio_component_unref (gpointer instance);
GParamSpec* dvb_event_param_spec_audio_component (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void dvb_event_value_set_audio_component (GValue* value, gpointer v_object);
void dvb_event_value_take_audio_component (GValue* value, gpointer v_object);
gpointer dvb_event_value_get_audio_component (const GValue* value);
GType dvb_event_audio_component_get_type (void) G_GNUC_CONST;
gpointer dvb_event_video_component_ref (gpointer instance);
void dvb_event_video_component_unref (gpointer instance);
GParamSpec* dvb_event_param_spec_video_component (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void dvb_event_value_set_video_component (GValue* value, gpointer v_object);
void dvb_event_value_take_video_component (GValue* value, gpointer v_object);
gpointer dvb_event_value_get_video_component (const GValue* value);
GType dvb_event_video_component_get_type (void) G_GNUC_CONST;
gpointer dvb_event_teletext_component_ref (gpointer instance);
void dvb_event_teletext_component_unref (gpointer instance);
GParamSpec* dvb_event_param_spec_teletext_component (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void dvb_event_value_set_teletext_component (GValue* value, gpointer v_object);
void dvb_event_value_take_teletext_component (GValue* value, gpointer v_object);
gpointer dvb_event_value_get_teletext_component (const GValue* value);
GType dvb_event_teletext_component_get_type (void) G_GNUC_CONST;
time_t dvb_event_get_start_timestamp (DVBEvent* self);
static void dvb_event_element_finalize (GObject* obj);
GType dvb_event_storage_get_type (void) G_GNUC_CONST;
#define DVB_EVENT_STORAGE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_TYPE_EVENT_STORAGE, DVBEventStoragePrivate))
enum  {
	DVB_EVENT_STORAGE_DUMMY_PROPERTY,
	DVB_EVENT_STORAGE_SIZE,
	DVB_EVENT_STORAGE_ELEMENT_TYPE
};
DVBEventStorage* dvb_event_storage_new (void);
DVBEventStorage* dvb_event_storage_construct (GType object_type);
static void _dvb_event_element_destroy_gdestroy_notify (void* data);
void dvb_event_storage_insert (DVBEventStorage* self, DVBEvent* event);
static gint _dvb_event_element_compare_gcompare_data_func (gconstpointer a, gconstpointer b, gpointer self);
void dvb_event_storage_remove_range (DVBEventStorage* self, gint start, gint end);
void dvb_event_storage_remove_all (DVBEventStorage* self, GeeList* events);
DVBEventElement* dvb_event_storage_get (DVBEventStorage* self, gint index);
DVBEventElement* dvb_event_storage_get_by_id (DVBEventStorage* self, guint event_id);
gboolean dvb_event_storage_contains_event_with_id (DVBEventStorage* self, guint event_id);
DVBEventElement* dvb_event_storage_next (DVBEventStorage* self, DVBEventElement* element);
DVBEventElement* dvb_event_storage_prev (DVBEventStorage* self, DVBEventElement* element);
GeeList* dvb_event_storage_get_overlapping_events (DVBEventStorage* self, DVBEvent* event);
time_t dvb_event_get_end_timestamp (DVBEvent* self);
static GeeIterator* dvb_event_storage_real_iterator (GeeIterable* base);
static DVBEventStorageEventIterator* dvb_event_storage_event_iterator_new (DVBEventStorage* storage);
static DVBEventStorageEventIterator* dvb_event_storage_event_iterator_construct (GType object_type, DVBEventStorage* storage);
static GType dvb_event_storage_event_iterator_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
GeeBidirIterator* dvb_event_storage_bidir_iterator (DVBEventStorage* self);
gint dvb_event_storage_get_size (DVBEventStorage* self);
#define DVB_EVENT_STORAGE_EVENT_ITERATOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_EVENT_STORAGE_TYPE_EVENT_ITERATOR, DVBEventStorageEventIteratorPrivate))
enum  {
	DVB_EVENT_STORAGE_EVENT_ITERATOR_DUMMY_PROPERTY
};
static gboolean dvb_event_storage_event_iterator_real_next (GeeIterator* base);
static gboolean dvb_event_storage_event_iterator_real_has_next (GeeIterator* base);
static gboolean dvb_event_storage_event_iterator_real_first (GeeIterator* base);
static DVBEventElement* dvb_event_storage_event_iterator_real_get (GeeIterator* base);
static void dvb_event_storage_event_iterator_real_remove (GeeIterator* base);
static gboolean dvb_event_storage_event_iterator_real_previous (GeeBidirIterator* base);
static gboolean dvb_event_storage_event_iterator_real_has_previous (GeeBidirIterator* base);
static gboolean dvb_event_storage_event_iterator_real_last (GeeBidirIterator* base);
static void dvb_event_storage_event_iterator_finalize (GObject* obj);
static void dvb_event_storage_finalize (GObject* obj);
static void _vala_dvb_event_storage_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);


gint dvb_event_element_compare (DVBEventElement* event1, DVBEventElement* event2) {
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (event1 != NULL, 0);
	g_return_val_if_fail (event2 != NULL, 0);
	if (event1 == NULL) {
		_tmp0_ = event2 == NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = 0;
		return result;
	} else {
		gboolean _tmp1_ = FALSE;
		if (event1 == NULL) {
			_tmp1_ = event2 != NULL;
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			result = +1;
			return result;
		} else {
			gboolean _tmp2_ = FALSE;
			if (event1 != NULL) {
				_tmp2_ = event2 == NULL;
			} else {
				_tmp2_ = FALSE;
			}
			if (_tmp2_) {
				result = -1;
				return result;
			}
		}
	}
	if (event1->starttime < event2->starttime) {
		result = -1;
		return result;
	} else {
		if (event1->starttime > event2->starttime) {
			result = +1;
			return result;
		} else {
			result = 0;
			return result;
		}
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void dvb_event_element_destroy (void* data) {
	DVBEventElement* _tmp0_;
	DVBEventElement* e;
	_tmp0_ = _g_object_ref0 (DVB_EVENT_ELEMENT (data));
	e = _tmp0_;
	g_object_unref (e);
	_g_object_unref0 (e);
}


DVBEventElement* dvb_event_element_new_from_event (DVBEvent* event) {
	DVBEventElement* result = NULL;
	DVBEventElement* _tmp0_ = NULL;
	DVBEventElement* element;
	time_t _tmp1_;
	g_return_val_if_fail (event != NULL, NULL);
	_tmp0_ = dvb_event_element_new ();
	element = _tmp0_;
	element->id = event->id;
	_tmp1_ = dvb_event_get_start_timestamp (event);
	element->starttime = _tmp1_;
	result = element;
	return result;
}


DVBEventElement* dvb_event_element_construct (GType object_type) {
	DVBEventElement * self = NULL;
	self = (DVBEventElement*) g_object_new (object_type, NULL);
	return self;
}


DVBEventElement* dvb_event_element_new (void) {
	return dvb_event_element_construct (DVB_TYPE_EVENT_ELEMENT);
}


static void dvb_event_element_class_init (DVBEventElementClass * klass) {
	dvb_event_element_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = dvb_event_element_finalize;
}


static void dvb_event_element_instance_init (DVBEventElement * self) {
}


static void dvb_event_element_finalize (GObject* obj) {
	DVBEventElement * self;
	self = DVB_EVENT_ELEMENT (obj);
	G_OBJECT_CLASS (dvb_event_element_parent_class)->finalize (obj);
}


/**
     * We don't want to hold the complete information about
     * every event in memory. Just remember id and starttime
     * so we can have a sorted list.
     */
GType dvb_event_element_get_type (void) {
	static volatile gsize dvb_event_element_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_event_element_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBEventElementClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_event_element_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBEventElement), 0, (GInstanceInitFunc) dvb_event_element_instance_init, NULL };
		GType dvb_event_element_type_id;
		dvb_event_element_type_id = g_type_register_static (G_TYPE_OBJECT, "DVBEventElement", &g_define_type_info, 0);
		g_once_init_leave (&dvb_event_element_type_id__volatile, dvb_event_element_type_id);
	}
	return dvb_event_element_type_id__volatile;
}


static void _dvb_event_element_destroy_gdestroy_notify (void* data) {
	dvb_event_element_destroy (data);
}


DVBEventStorage* dvb_event_storage_construct (GType object_type) {
	DVBEventStorage * self = NULL;
	GSequence* _tmp0_ = NULL;
	GeeHashMap* _tmp1_ = NULL;
	self = (DVBEventStorage*) g_object_new (object_type, NULL);
	_tmp0_ = g_sequence_new (_dvb_event_element_destroy_gdestroy_notify);
	_g_sequence_free0 (self->priv->events);
	self->priv->events = _tmp0_;
	_tmp1_ = gee_hash_map_new (G_TYPE_UINT, NULL, NULL, G_TYPE_POINTER, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->event_id_map);
	self->priv->event_id_map = (GeeMap*) _tmp1_;
	return self;
}


DVBEventStorage* dvb_event_storage_new (void) {
	return dvb_event_storage_construct (DVB_TYPE_EVENT_STORAGE);
}


static gint _dvb_event_element_compare_gcompare_data_func (gconstpointer a, gconstpointer b, gpointer self) {
	gint result;
	result = dvb_event_element_compare (a, b);
	return result;
}


void dvb_event_storage_insert (DVBEventStorage* self, DVBEvent* event) {
	DVBEventElement* _tmp0_ = NULL;
	DVBEventElement* element;
	DVBEventElement* _tmp1_;
	GSequenceIter* _tmp2_ = NULL;
	GSequenceIter* iter;
	gint _tmp3_;
	gint _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (event != NULL);
	_tmp0_ = dvb_event_element_new_from_event (event);
	element = _tmp0_;
	_tmp1_ = _g_object_ref0 (element);
	_tmp2_ = g_sequence_insert_sorted (self->priv->events, _tmp1_, _dvb_event_element_compare_gcompare_data_func, NULL);
	iter = _tmp2_;
	gee_map_set (self->priv->event_id_map, GUINT_TO_POINTER (event->id), iter);
	self->priv->_stamp++;
	_tmp3_ = g_sequence_get_length (self->priv->events);
	_tmp4_ = gee_map_get_size (self->priv->event_id_map);
	g_assert (_tmp3_ == _tmp4_);
	_g_object_unref0 (element);
}


void dvb_event_storage_remove_range (DVBEventStorage* self, gint start, gint end) {
	gint _tmp0_;
	GSequenceIter* _tmp1_ = NULL;
	GSequenceIter* begin_iter;
	GSequenceIter* _tmp2_ = NULL;
	GSequenceIter* end_iter;
	GSequenceIter* iter;
	gint _tmp6_;
	gint _tmp7_;
	g_return_if_fail (self != NULL);
	g_assert (start >= 0);
	_tmp0_ = g_sequence_get_length (self->priv->events);
	g_assert (end < _tmp0_);
	_tmp1_ = g_sequence_get_iter_at_pos (self->priv->events, start);
	begin_iter = _tmp1_;
	_tmp2_ = g_sequence_get_iter_at_pos (self->priv->events, end);
	end_iter = _tmp2_;
	iter = begin_iter;
	while (TRUE) {
		gconstpointer _tmp3_ = NULL;
		DVBEventElement* _tmp4_;
		DVBEventElement* element;
		GSequenceIter* _tmp5_ = NULL;
		if (!(iter != end_iter)) {
			break;
		}
		_tmp3_ = g_sequence_get (iter);
		_tmp4_ = _g_object_ref0 ((DVBEventElement*) _tmp3_);
		element = _tmp4_;
		gee_map_unset (self->priv->event_id_map, GUINT_TO_POINTER (element->id), NULL);
		_tmp5_ = g_sequence_iter_next (iter);
		iter = _tmp5_;
		_g_object_unref0 (element);
	}
	g_sequence_remove_range (begin_iter, end_iter);
	self->priv->_stamp++;
	_tmp6_ = g_sequence_get_length (self->priv->events);
	_tmp7_ = gee_map_get_size (self->priv->event_id_map);
	g_assert (_tmp6_ == _tmp7_);
}


void dvb_event_storage_remove_all (DVBEventStorage* self, GeeList* events) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (events != NULL);
	{
		GeeList* _tmp0_;
		GeeList* _event_list;
		gint _tmp1_;
		gint _event_size;
		gint _event_index;
		_tmp0_ = _g_object_ref0 (events);
		_event_list = _tmp0_;
		_tmp1_ = gee_collection_get_size ((GeeCollection*) _event_list);
		_event_size = _tmp1_;
		_event_index = -1;
		while (TRUE) {
			gpointer _tmp2_ = NULL;
			DVBEvent* event;
			gpointer _tmp3_ = NULL;
			GSequenceIter* iter;
			_event_index = _event_index + 1;
			if (!(_event_index < _event_size)) {
				break;
			}
			_tmp2_ = gee_list_get (_event_list, _event_index);
			event = (DVBEvent*) _tmp2_;
			_tmp3_ = gee_map_get (self->priv->event_id_map, GUINT_TO_POINTER (event->id));
			iter = (GSequenceIter*) _tmp3_;
			if (iter != NULL) {
				g_sequence_remove (iter);
				gee_map_unset (self->priv->event_id_map, GUINT_TO_POINTER (event->id), NULL);
			}
			_dvb_event_unref0 (event);
		}
		_g_object_unref0 (_event_list);
	}
	self->priv->_stamp++;
}


DVBEventElement* dvb_event_storage_get (DVBEventStorage* self, gint index) {
	DVBEventElement* result = NULL;
	gint _tmp0_;
	GSequenceIter* _tmp1_ = NULL;
	GSequenceIter* iter;
	gconstpointer _tmp2_ = NULL;
	DVBEventElement* _tmp3_;
	DVBEventElement* element;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_sequence_get_length (self->priv->events);
	g_assert (index < _tmp0_);
	_tmp1_ = g_sequence_get_iter_at_pos (self->priv->events, index);
	iter = _tmp1_;
	_tmp2_ = g_sequence_get (iter);
	_tmp3_ = _g_object_ref0 ((DVBEventElement*) _tmp2_);
	element = _tmp3_;
	result = element;
	return result;
}


DVBEventElement* dvb_event_storage_get_by_id (DVBEventStorage* self, guint event_id) {
	DVBEventElement* result = NULL;
	gpointer _tmp0_ = NULL;
	GSequenceIter* iter;
	gconstpointer _tmp1_ = NULL;
	DVBEventElement* _tmp2_;
	DVBEventElement* element;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gee_map_get (self->priv->event_id_map, GUINT_TO_POINTER (event_id));
	iter = (GSequenceIter*) _tmp0_;
	_tmp1_ = g_sequence_get (iter);
	_tmp2_ = _g_object_ref0 ((DVBEventElement*) _tmp1_);
	element = _tmp2_;
	result = element;
	return result;
}


gboolean dvb_event_storage_contains_event_with_id (DVBEventStorage* self, guint event_id) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = gee_map_has_key (self->priv->event_id_map, GUINT_TO_POINTER (event_id));
	result = _tmp0_;
	return result;
}


DVBEventElement* dvb_event_storage_next (DVBEventStorage* self, DVBEventElement* element) {
	DVBEventElement* result = NULL;
	gpointer _tmp0_ = NULL;
	GSequenceIter* iter;
	GSequenceIter* _tmp1_ = NULL;
	GSequenceIter* next;
	DVBEventElement* _tmp2_ = NULL;
	gboolean _tmp3_;
	DVBEventElement* _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (element != NULL, NULL);
	_tmp0_ = gee_map_get (self->priv->event_id_map, GUINT_TO_POINTER (element->id));
	iter = (GSequenceIter*) _tmp0_;
	g_assert (iter != NULL);
	_tmp1_ = g_sequence_iter_next (iter);
	next = _tmp1_;
	_tmp3_ = g_sequence_iter_is_end (next);
	if (_tmp3_) {
		_tmp2_ = NULL;
	} else {
		gconstpointer _tmp4_ = NULL;
		_tmp4_ = g_sequence_get (next);
		_tmp2_ = (DVBEventElement*) _tmp4_;
	}
	_tmp5_ = _g_object_ref0 (_tmp2_);
	result = _tmp5_;
	return result;
}


DVBEventElement* dvb_event_storage_prev (DVBEventStorage* self, DVBEventElement* element) {
	DVBEventElement* result = NULL;
	gpointer _tmp0_ = NULL;
	GSequenceIter* iter;
	GSequenceIter* _tmp1_ = NULL;
	GSequenceIter* prev;
	DVBEventElement* _tmp2_ = NULL;
	gboolean _tmp3_;
	DVBEventElement* _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (element != NULL, NULL);
	_tmp0_ = gee_map_get (self->priv->event_id_map, GUINT_TO_POINTER (element->id));
	iter = (GSequenceIter*) _tmp0_;
	g_assert (iter != NULL);
	_tmp1_ = g_sequence_iter_prev (iter);
	prev = _tmp1_;
	_tmp3_ = g_sequence_iter_is_begin (prev);
	if (_tmp3_) {
		_tmp2_ = NULL;
	} else {
		gconstpointer _tmp4_ = NULL;
		_tmp4_ = g_sequence_get (prev);
		_tmp2_ = (DVBEventElement*) _tmp4_;
	}
	_tmp5_ = _g_object_ref0 (_tmp2_);
	result = _tmp5_;
	return result;
}


GeeList* dvb_event_storage_get_overlapping_events (DVBEventStorage* self, DVBEvent* event) {
	GeeList* result = NULL;
	DVBEventElement* _tmp0_ = NULL;
	DVBEventElement* element;
	time_t _tmp1_;
	time_t event_end;
	GSequenceIter* _tmp2_ = NULL;
	GSequenceIter* _tmp3_ = NULL;
	GSequenceIter* start_iter;
	GeeArrayList* _tmp4_ = NULL;
	GeeList* overlap;
	GSequenceIter* end_iter;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (event != NULL, NULL);
	_tmp0_ = dvb_event_element_new_from_event (event);
	element = _tmp0_;
	_tmp1_ = dvb_event_get_end_timestamp (event);
	event_end = _tmp1_;
	_tmp2_ = g_sequence_search (self->priv->events, element, _dvb_event_element_compare_gcompare_data_func, NULL);
	_tmp3_ = g_sequence_iter_prev (_tmp2_);
	start_iter = _tmp3_;
	_tmp4_ = gee_array_list_new (DVB_TYPE_EVENT_ELEMENT, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL);
	overlap = (GeeList*) _tmp4_;
	end_iter = start_iter;
	while (TRUE) {
		gboolean _tmp5_;
		gconstpointer _tmp6_ = NULL;
		DVBEventElement* _tmp7_;
		DVBEventElement* data;
		GSequenceIter* _tmp8_ = NULL;
		_tmp5_ = g_sequence_iter_is_end (end_iter);
		if (!(!_tmp5_)) {
			break;
		}
		_tmp6_ = g_sequence_get (end_iter);
		_tmp7_ = _g_object_ref0 ((DVBEventElement*) _tmp6_);
		data = _tmp7_;
		if (data->starttime > event_end) {
			_g_object_unref0 (data);
			break;
		}
		gee_collection_add ((GeeCollection*) overlap, data);
		_tmp8_ = g_sequence_iter_next (end_iter);
		end_iter = _tmp8_;
		_g_object_unref0 (data);
	}
	result = overlap;
	_g_object_unref0 (element);
	return result;
}


static GeeIterator* dvb_event_storage_real_iterator (GeeIterable* base) {
	DVBEventStorage * self;
	GeeIterator* result = NULL;
	DVBEventStorageEventIterator* _tmp0_ = NULL;
	self = (DVBEventStorage*) base;
	_tmp0_ = dvb_event_storage_event_iterator_new (self);
	result = (GeeIterator*) _tmp0_;
	return result;
}


GeeBidirIterator* dvb_event_storage_bidir_iterator (DVBEventStorage* self) {
	GeeBidirIterator* result = NULL;
	DVBEventStorageEventIterator* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = dvb_event_storage_event_iterator_new (self);
	result = (GeeBidirIterator*) _tmp0_;
	return result;
}


gint dvb_event_storage_get_size (DVBEventStorage* self) {
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_sequence_get_length (self->priv->events);
	result = _tmp0_;
	return result;
}


static GType dvb_event_storage_real_get_element_type (GeeIterable* base) {
	GType result;
	DVBEventStorage* self;
	self = (DVBEventStorage*) base;
	result = DVB_TYPE_EVENT_ELEMENT;
	return result;
}


static DVBEventStorageEventIterator* dvb_event_storage_event_iterator_construct (GType object_type, DVBEventStorage* storage) {
	DVBEventStorageEventIterator * self = NULL;
	DVBEventStorage* _tmp0_;
	g_return_val_if_fail (storage != NULL, NULL);
	self = (DVBEventStorageEventIterator*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (storage);
	_g_object_unref0 (self->priv->_storage);
	self->priv->_storage = _tmp0_;
	self->priv->_stamp = storage->priv->_stamp;
	return self;
}


static DVBEventStorageEventIterator* dvb_event_storage_event_iterator_new (DVBEventStorage* storage) {
	return dvb_event_storage_event_iterator_construct (DVB_EVENT_STORAGE_TYPE_EVENT_ITERATOR, storage);
}


static gboolean dvb_event_storage_event_iterator_real_next (GeeIterator* base) {
	DVBEventStorageEventIterator * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	self = (DVBEventStorageEventIterator*) base;
	g_assert (self->priv->_stamp == self->priv->_storage->priv->_stamp);
	_tmp0_ = g_sequence_iter_is_end (self->priv->_iter);
	if (!_tmp0_) {
		GSequenceIter* _tmp1_ = NULL;
		_tmp1_ = g_sequence_iter_next (self->priv->_iter);
		self->priv->_iter = _tmp1_;
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static gboolean dvb_event_storage_event_iterator_real_has_next (GeeIterator* base) {
	DVBEventStorageEventIterator * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	self = (DVBEventStorageEventIterator*) base;
	g_assert (self->priv->_stamp == self->priv->_storage->priv->_stamp);
	_tmp0_ = g_sequence_iter_is_end (self->priv->_iter);
	result = !_tmp0_;
	return result;
}


static gboolean dvb_event_storage_event_iterator_real_first (GeeIterator* base) {
	DVBEventStorageEventIterator * self;
	gboolean result = FALSE;
	gint _tmp0_;
	self = (DVBEventStorageEventIterator*) base;
	g_assert (self->priv->_stamp == self->priv->_storage->priv->_stamp);
	_tmp0_ = dvb_event_storage_get_size (self->priv->_storage);
	if (_tmp0_ > 0) {
		GSequenceIter* _tmp1_ = NULL;
		_tmp1_ = g_sequence_get_begin_iter (self->priv->_storage->priv->events);
		self->priv->_iter = _tmp1_;
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static DVBEventElement* dvb_event_storage_event_iterator_real_get (GeeIterator* base) {
	DVBEventStorageEventIterator * self;
	DVBEventElement* result = NULL;
	gconstpointer _tmp0_ = NULL;
	DVBEventElement* _tmp1_;
	self = (DVBEventStorageEventIterator*) base;
	g_assert (self->priv->_stamp == self->priv->_storage->priv->_stamp);
	g_assert (self->priv->_iter != NULL);
	_tmp0_ = g_sequence_get (self->priv->_iter);
	_tmp1_ = _g_object_ref0 ((DVBEventElement*) _tmp0_);
	result = _tmp1_;
	return result;
}


static void dvb_event_storage_event_iterator_real_remove (GeeIterator* base) {
	DVBEventStorageEventIterator * self;
	self = (DVBEventStorageEventIterator*) base;
}


static gboolean dvb_event_storage_event_iterator_real_previous (GeeBidirIterator* base) {
	DVBEventStorageEventIterator * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	self = (DVBEventStorageEventIterator*) base;
	g_assert (self->priv->_stamp == self->priv->_storage->priv->_stamp);
	_tmp0_ = g_sequence_iter_is_begin (self->priv->_iter);
	if (!_tmp0_) {
		GSequenceIter* _tmp1_ = NULL;
		_tmp1_ = g_sequence_iter_prev (self->priv->_iter);
		self->priv->_iter = _tmp1_;
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static gboolean dvb_event_storage_event_iterator_real_has_previous (GeeBidirIterator* base) {
	DVBEventStorageEventIterator * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	self = (DVBEventStorageEventIterator*) base;
	g_assert (self->priv->_stamp == self->priv->_storage->priv->_stamp);
	_tmp0_ = g_sequence_iter_is_begin (self->priv->_iter);
	result = !_tmp0_;
	return result;
}


static gboolean dvb_event_storage_event_iterator_real_last (GeeBidirIterator* base) {
	DVBEventStorageEventIterator * self;
	gboolean result = FALSE;
	gint _tmp0_;
	self = (DVBEventStorageEventIterator*) base;
	g_assert (self->priv->_stamp == self->priv->_storage->priv->_stamp);
	_tmp0_ = dvb_event_storage_get_size (self->priv->_storage);
	if (_tmp0_ > 0) {
		GSequenceIter* _tmp1_ = NULL;
		_tmp1_ = g_sequence_get_end_iter (self->priv->_storage->priv->events);
		self->priv->_iter = _tmp1_;
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static void dvb_event_storage_event_iterator_class_init (DVBEventStorageEventIteratorClass * klass) {
	dvb_event_storage_event_iterator_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBEventStorageEventIteratorPrivate));
	G_OBJECT_CLASS (klass)->finalize = dvb_event_storage_event_iterator_finalize;
}


static void dvb_event_storage_event_iterator_gee_iterator_interface_init (GeeIteratorIface * iface) {
	dvb_event_storage_event_iterator_gee_iterator_parent_iface = g_type_interface_peek_parent (iface);
	iface->next = (gboolean (*)(GeeIterator*)) dvb_event_storage_event_iterator_real_next;
	iface->has_next = (gboolean (*)(GeeIterator*)) dvb_event_storage_event_iterator_real_has_next;
	iface->first = (gboolean (*)(GeeIterator*)) dvb_event_storage_event_iterator_real_first;
	iface->get = (gpointer (*)(GeeIterator*)) dvb_event_storage_event_iterator_real_get;
	iface->remove = (void (*)(GeeIterator*)) dvb_event_storage_event_iterator_real_remove;
}


static void dvb_event_storage_event_iterator_gee_bidir_iterator_interface_init (GeeBidirIteratorIface * iface) {
	dvb_event_storage_event_iterator_gee_bidir_iterator_parent_iface = g_type_interface_peek_parent (iface);
	iface->previous = (gboolean (*)(GeeBidirIterator*)) dvb_event_storage_event_iterator_real_previous;
	iface->has_previous = (gboolean (*)(GeeBidirIterator*)) dvb_event_storage_event_iterator_real_has_previous;
	iface->last = (gboolean (*)(GeeBidirIterator*)) dvb_event_storage_event_iterator_real_last;
}


static void dvb_event_storage_event_iterator_instance_init (DVBEventStorageEventIterator * self) {
	self->priv = DVB_EVENT_STORAGE_EVENT_ITERATOR_GET_PRIVATE (self);
	self->priv->_stamp = 0;
}


static void dvb_event_storage_event_iterator_finalize (GObject* obj) {
	DVBEventStorageEventIterator * self;
	self = DVB_EVENT_STORAGE_EVENT_ITERATOR (obj);
	_g_object_unref0 (self->priv->_storage);
	G_OBJECT_CLASS (dvb_event_storage_event_iterator_parent_class)->finalize (obj);
}


static GType dvb_event_storage_event_iterator_get_type (void) {
	static volatile gsize dvb_event_storage_event_iterator_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_event_storage_event_iterator_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBEventStorageEventIteratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_event_storage_event_iterator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBEventStorageEventIterator), 0, (GInstanceInitFunc) dvb_event_storage_event_iterator_instance_init, NULL };
		static const GInterfaceInfo gee_iterator_info = { (GInterfaceInitFunc) dvb_event_storage_event_iterator_gee_iterator_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo gee_bidir_iterator_info = { (GInterfaceInitFunc) dvb_event_storage_event_iterator_gee_bidir_iterator_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType dvb_event_storage_event_iterator_type_id;
		dvb_event_storage_event_iterator_type_id = g_type_register_static (G_TYPE_OBJECT, "DVBEventStorageEventIterator", &g_define_type_info, 0);
		g_type_add_interface_static (dvb_event_storage_event_iterator_type_id, GEE_TYPE_ITERATOR, &gee_iterator_info);
		g_type_add_interface_static (dvb_event_storage_event_iterator_type_id, GEE_TYPE_BIDIR_ITERATOR, &gee_bidir_iterator_info);
		g_once_init_leave (&dvb_event_storage_event_iterator_type_id__volatile, dvb_event_storage_event_iterator_type_id);
	}
	return dvb_event_storage_event_iterator_type_id__volatile;
}


static void dvb_event_storage_class_init (DVBEventStorageClass * klass) {
	dvb_event_storage_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBEventStoragePrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_dvb_event_storage_get_property;
	G_OBJECT_CLASS (klass)->finalize = dvb_event_storage_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_EVENT_STORAGE_SIZE, g_param_spec_int ("size", "size", "size", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_override_property (G_OBJECT_CLASS (klass), DVB_EVENT_STORAGE_ELEMENT_TYPE, "element-type");
}


static void dvb_event_storage_gee_iterable_interface_init (GeeIterableIface * iface) {
	dvb_event_storage_gee_iterable_parent_iface = g_type_interface_peek_parent (iface);
	iface->iterator = (GeeIterator* (*)(GeeIterable*)) dvb_event_storage_real_iterator;
	iface->get_element_type = dvb_event_storage_real_get_element_type;
}


static void dvb_event_storage_instance_init (DVBEventStorage * self) {
	self->priv = DVB_EVENT_STORAGE_GET_PRIVATE (self);
	self->priv->_stamp = 0;
}


static void dvb_event_storage_finalize (GObject* obj) {
	DVBEventStorage * self;
	self = DVB_EVENT_STORAGE (obj);
	_g_sequence_free0 (self->priv->events);
	_g_object_unref0 (self->priv->event_id_map);
	G_OBJECT_CLASS (dvb_event_storage_parent_class)->finalize (obj);
}


GType dvb_event_storage_get_type (void) {
	static volatile gsize dvb_event_storage_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_event_storage_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBEventStorageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_event_storage_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBEventStorage), 0, (GInstanceInitFunc) dvb_event_storage_instance_init, NULL };
		static const GInterfaceInfo gee_iterable_info = { (GInterfaceInitFunc) dvb_event_storage_gee_iterable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType dvb_event_storage_type_id;
		dvb_event_storage_type_id = g_type_register_static (G_TYPE_OBJECT, "DVBEventStorage", &g_define_type_info, 0);
		g_type_add_interface_static (dvb_event_storage_type_id, GEE_TYPE_ITERABLE, &gee_iterable_info);
		g_once_init_leave (&dvb_event_storage_type_id__volatile, dvb_event_storage_type_id);
	}
	return dvb_event_storage_type_id__volatile;
}


static void _vala_dvb_event_storage_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DVBEventStorage * self;
	self = DVB_EVENT_STORAGE (object);
	switch (property_id) {
		case DVB_EVENT_STORAGE_SIZE:
		g_value_set_int (value, dvb_event_storage_get_size (self));
		break;
		case DVB_EVENT_STORAGE_ELEMENT_TYPE:
		g_value_set_gtype (value, gee_iterable_get_element_type ((GeeIterable*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



