/* GNOME-DB Components
 * Copyright (C) 2000-2002 The GNOME Foundation.
 *
 * AUTHORS:
 *	Rodrigo Moya <rodrigo@gnome-db.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#if !defined(__components_database_h__)
#  define __components_database_h__

#include <gnome-db-defs.h>
#include <gnome-db-shell-component.h>

G_BEGIN_DECLS

#define COMPONENTS_TYPE_DATABASE            (components_database_get_type ())
#define COMPONENTS_DATABASE(obj)            (G_TYPE_CHECK_INSTANCE_CAST (obj, COMPONENTS_TYPE_DATABASE, ComponentsDatabase))
#define COMPONENTS_DATABASE_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST (klass, COMPONENTS_TYPE_DATABASE, ComponentsDatabaseClass))
#define COMPONENTS_IS_DATABASE(obj)         (G_TYPE_CHECK_INSTANCE_TYPE (obj, COMPONENTS_TYPE_DATABASE))
#define COMPONENTS_IS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), COMPONENTS_TYPE_DATABASE))

typedef struct {
	GnomeDbShellComponent component;

	/* widgets */
	GtkWidget *notebook;
	GtkWidget *browser;
	GtkWidget *sql;

	GdaConnection *current_connection;
	GList *open_connections;
} ComponentsDatabase;

typedef struct {
	GnomeDbShellComponentClass parent_class;
} ComponentsDatabaseClass;

GType                  components_database_get_type (void);
GnomeDbShellComponent *components_database_new (void);

G_END_DECLS

#endif
