/* GNOME-DB Monikers
 * Copyright (C) 2000-2002 The GNOME Foundation.
 *
 * AUTHORS:
 *	Rodrigo Moya <rodrigo@gnome-db.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <libgda/gda-error.h>
#include <libgnomevfs/gnome-vfs-uri.h>
#include "gnome-db-defs.h"
#include "gnome-db-monikers.h"

static Bonobo_Unknown
create_database_control (GnomeVFSURI *uri, CORBA_Environment *ev)
{
	Bonobo_Unknown control;

	control = bonobo_get_object (GNOME_DB_ID_DATABASE, "IDL:Bonobo/Control:1.0", ev);

	/* FIXME: if connection parameters are present, set the properties
	   for the control, which should make it open the given connection */

	return control;
}

Bonobo_Unknown
moniker_database_resolve (BonoboMoniker *moniker,
			  const Bonobo_ResolveOptions *options,
			  const CORBA_char *requested_interface,
			  CORBA_Environment *ev)
{
	gchar *moniker_name;
	GnomeVFSURI *uri;
	Bonobo_Unknown unknown = CORBA_OBJECT_NIL;

	moniker_name = bonobo_moniker_get_name (moniker);

	/* we use the same format as URIs, so we can safely use GnomeVFS
	   to parse the moniker string.
	   A typical string would be: database:username:password@dsn_name
	   Which maps easily to URI's method:username:password@host */
	uri = gnome_vfs_uri_new (moniker_name);
	if (!uri) {
		bonobo_exception_general_error_set (
			ev, NULL,
			_("Invalid format for connection string"));
		return CORBA_OBJECT_NIL;
	}

	/* create the requested object */
	if (!strcmp (requested_interface, "IDL:GNOME/Database/UI/Database:1.0"))
		unknown = create_database_control (uri, ev);

	/* free memory */
	gnome_vfs_uri_unref (uri);

	return unknown;
}
