/* GNOME DB library
 * Copyright (C) 1999-2000 Rodrigo Moya
 *
 * This Library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This Library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this Library; see the file COPYING.LIB.  If not,
 * write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#if !defined(__gnome_db_util_h__)
#  define __gnome_db_util_h__

#include <libgnome/gnome-defs.h>
#include <libgnomeui/libgnomeui.h>
#include <libgnomeprint/gnome-printer.h>

BEGIN_GNOME_DECLS

/*
 * Common dialogs
 */
gchar* gnome_db_select_file   (const gchar *title);
void   gnome_db_show_error    (const gchar *, ...);
void   gnome_db_show_file     (const gchar *);
void   gnome_db_show_message  (const gchar *, ...);
void   gnome_db_submit_bug_cb (GtkWidget *w, gpointer data);

/*
 * Utility functions (private use)
 */
void         gnome_db_clear_clist        (GtkCList *);
GnomePixmap* gnome_db_get_pixmap         (const gchar *stock_pixmap);
GtkWidget*   gnome_db_new_popup_menu     (GtkWidget *, GnomeUIInfo *, gpointer );
void         gnome_db_show_about_dialog  (const gchar *title);
void         gnome_db_set_bg_color       (GtkWidget *w, gint red, gint green, gint blue);
void         gnome_db_set_widget_tooltip (GtkWidget *w, const gchar *text);

void         gnome_db_load_window_config (const gchar *name, GtkWidget *window);
void         gnome_db_save_window_config (const gchar *name, GtkWidget *window);
gboolean     gnome_db_yes_no_dialog      (const gchar *msg, ...);

/*
 * Common widgets creation
 */
GtkWidget* gnome_db_new_button_widget             (gchar *);
GtkWidget* gnome_db_new_button_widget_with_pixmap (const gchar *, const gchar *);
GtkWidget* gnome_db_new_check_button_widget       (gchar *, gint );
GtkWidget* gnome_db_new_clist_widget              (const gchar *[], gint );
GtkWidget* gnome_db_new_color_picker_widget       (void);
GtkWidget* gnome_db_new_ctree_widget              (gchar *[], gint );
GtkWidget* gnome_db_new_combo_widget              (void);
GtkWidget* gnome_db_new_entry_widget              (gint , gboolean );
GtkWidget* gnome_db_new_file_entry_widget         (const gchar *history_id);
GtkWidget* gnome_db_new_file_viewer_widget        (const gchar *file);
GtkWidget* gnome_db_new_font_picker_widget        (void);
GtkWidget* gnome_db_new_frame_widget              (const gchar *label);
GtkWidget* gnome_db_new_icon_widget               (const gchar *);
GtkWidget* gnome_db_new_icon_list_widget          (void);
GtkWidget* gnome_db_new_label_widget              (const gchar *);
GtkWidget* gnome_db_new_menu_item_widget          (GtkMenu *menu, const gchar *label);
GtkWidget* gnome_db_new_notebook_widget           (void);
GtkWidget* gnome_db_new_option_menu_widget        (void);
GtkWidget* gnome_db_new_progress_bar_widget       (void);
GtkWidget* gnome_db_new_radio_button_widget       (const gchar *, GtkRadioButton *);
GtkWidget* gnome_db_new_scrolled_window_widget    (void);
GtkWidget* gnome_db_new_spin_button_widget        (gfloat init_value,
						   gfloat lower,
						   gfloat upper,
						   guint dec_digits);
GtkWidget* gnome_db_new_status_bar_widget         (void);
GtkWidget* gnome_db_new_table_widget              (guint cols, guint rows, gboolean homogenous);
GtkWidget* gnome_db_new_text_widget               (void);
GtkWidget* gnome_db_new_toolbar_widget            (GtkOrientation orientation,
                                                   GtkToolbarStyle style,
                                                   GnomeUIInfo uiinfo[],
                                                   gpointer user_data);
GtkWidget* gnome_db_new_tree_widget               (void);

/*
 * Printing support
 */
void          gnome_db_print_setup_dlg_cb (GtkWidget *w, gpointer data);
GnomePrinter* gnome_db_print_get_printer  (void);

END_GNOME_DECLS

#endif
