/* GNOME DB components library
 * Copyright (C) 1999 Rodrigo Moya
 *
 * This Library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This Library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this Library; see the file COPYING.LIB.  If not,
 * write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#if !defined(__gnome_db_control_h__)
#  define __gnome_db_control_h__

#include <libgnome/gnome-defs.h>
#include <bonobo/bonobo-xobject.h>
#include <bonobo/bonobo-control.h>
#include <bonobo/bonobo-ui-component.h>
#include "GNOME_Database_UI.h"

BEGIN_GNOME_DECLS

#define GNOME_DB_TYPE_CONTROL            (gnome_db_control_get_type())
#define GNOME_DB_CONTROL(obj)            GTK_CHECK_CAST(obj, GNOME_DB_TYPE_CONTROL, GnomeDbControl)
#define GNOME_DB_CONTROL_CLASS(klass)    GTK_CHECK_CLASS_CAST(klass, GNOME_DB_TYPE_CONTROL, GnomeDbControlInstanceClass)
#define GNOME_DB_IS_CONTROL(obj)         GTK_CHECK_TYPE(obj, GNOME_DB_TYPE_CONTROL)
#define GNOME_DB_IS_CONTROL_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GNOME_DB_TYPE_CONTROL))

typedef struct _GnomeDbControl      GnomeDbControl;
typedef struct _GnomeDbControlClass GnomeDbControlClass;

typedef struct _GnomeDbControlPrivate GnomeDbControlPrivate;

struct _GnomeDbControl {
	BonoboXObject           bonobo_object;
	GnomeDbControlPrivate* priv;
};

struct _GnomeDbControlClass {
	BonoboXObjectClass parent_class; 

	POA_GNOME_Database_UIControl__epv epv;
  
	void              (*get_property)(GnomeDbControl *control, const gchar *name);
	void              (*set_property)(GnomeDbControl *control, const gchar *name);

	void              (*set_owner)(GnomeDbControl *control);
	void              (*unset_owner)(GnomeDbControl *control);

	void              (*do_print)(GnomeDbControl *control);
	void              (*do_cut_clipboard)(GnomeDbControl *control);
	void              (*do_copy_clipboard)(GnomeDbControl *control);
	void              (*do_paste_clipboard)(GnomeDbControl *control);
};

GtkType            gnome_db_control_get_type (void);
GnomeDbControl*    gnome_db_control_construct (GnomeDbControl *control, GtkWidget *w);
GnomeDbControl*    gnome_db_control_new (GtkWidget *w);

void               gnome_db_control_set_ui (GnomeDbControl *control,
					    const gchar *app_prefix,
					    const gchar *ui_xml_file,
					    BonoboUIVerb *verbs,
					    gpointer user_data);

void               gnome_db_control_activate (GnomeDbControl *control);
void               gnome_db_control_deactivate (GnomeDbControl *control);
void               gnome_db_control_set_status (GnomeDbControl *control, const gchar *msg);

gpointer           gnome_db_control_get_user_data (GnomeDbControl *control);
void               gnome_db_control_set_user_data (GnomeDbControl *control, gpointer user_data);
GtkWidget*         gnome_db_control_get_widget (GnomeDbControl *control);
BonoboControl*     gnome_db_control_get_bonobo_control (GnomeDbControl *control);
Bonobo_UIContainer gnome_db_control_get_ui_container (GnomeDbControl *control);

END_GNOME_DECLS

#endif
